/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.statistics.median;

import com.actelion.research.util.Formatter;
import com.actelion.research.util.StringFunctions;
import java.util.List;

public class ModelMedianDouble {
    private static final int LENGTH = 7;
    public double lowerQuartile;
    public double median;
    public double upperQuartile;
    public int id;
    public int size;

    public ModelMedianDouble() {
    }

    public ModelMedianDouble(double lowerQuartile, double median, double upperQuartile, int id, int size) {
        this.lowerQuartile = lowerQuartile;
        this.median = median;
        this.upperQuartile = upperQuartile;
        this.id = id;
        this.size = size;
    }

    public ModelMedianDouble(ModelMedianDouble m) {
        this.lowerQuartile = m.lowerQuartile;
        this.median = m.median;
        this.upperQuartile = m.upperQuartile;
        this.id = m.id;
        this.size = m.size;
    }

    public double range() {
        return this.upperQuartile - this.lowerQuartile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Formatter.format4(this.lowerQuartile));
        sb.append("\t");
        sb.append(Formatter.format4(this.median));
        sb.append("\t");
        sb.append(Formatter.format4(this.upperQuartile));
        return sb.toString();
    }

    public static String toString(List<ModelMedianDouble> liModelMedian) {
        String s;
        ModelMedianDouble m;
        int i;
        StringBuilder sb = new StringBuilder();
        int length = 7;
        int lengthText = 15;
        sb.append(StringFunctions.format2DefinedLengthTrailing("Id", lengthText));
        for (i = 0; i < liModelMedian.size(); ++i) {
            m = liModelMedian.get(i);
            s = StringFunctions.format2DefinedLengthLeading(Integer.toString(m.id), length);
            sb.append(s);
        }
        sb.append("\n");
        sb.append(StringFunctions.format2DefinedLengthTrailing("Upper quartile", lengthText));
        for (i = 0; i < liModelMedian.size(); ++i) {
            m = liModelMedian.get(i);
            s = StringFunctions.format2DefinedLengthLeading(Formatter.format2(m.upperQuartile), length);
            sb.append(s);
        }
        sb.append("\n");
        sb.append(StringFunctions.format2DefinedLengthTrailing("Median", lengthText));
        for (i = 0; i < liModelMedian.size(); ++i) {
            m = liModelMedian.get(i);
            s = StringFunctions.format2DefinedLengthLeading(Formatter.format2(m.median), length);
            sb.append(s);
        }
        sb.append("\n");
        sb.append(StringFunctions.format2DefinedLengthTrailing("Lower quartile", lengthText));
        for (i = 0; i < liModelMedian.size(); ++i) {
            m = liModelMedian.get(i);
            s = StringFunctions.format2DefinedLengthLeading(Formatter.format2(m.lowerQuartile), length);
            sb.append(s);
        }
        sb.append("\n");
        sb.append(StringFunctions.format2DefinedLengthTrailing("Size", lengthText));
        for (i = 0; i < liModelMedian.size(); ++i) {
            m = liModelMedian.get(i);
            s = StringFunctions.format2DefinedLengthLeading(Integer.toString(m.size), length);
            sb.append(s);
        }
        return sb.toString();
    }
}

