/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectFactory;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.generic.GenericShape;

public abstract class AbstractDrawingObject {
    protected static final String DESCRIPTOR_START = "<DrawingObject";
    protected static final String DESCRIPTOR_END = "></DrawingObject>";
    protected static final String DESCRIPTOR_TYPE = " type=\"";
    protected GenericPoint[] mPoint;
    protected boolean mIsSelected;
    protected boolean mProtectedFromDeletion;
    protected double mTransformationReferenceX;
    protected double mTransformationReferenceY;
    protected double[] mTransformationValue1;
    protected double[] mTransformationValue2;

    public abstract void draw(GenericDrawContext var1, DepictorTransformation var2);

    public abstract void hilite(GenericDrawContext var1);

    public abstract void clearHiliting();

    public abstract boolean contains(double var1, double var3);

    public abstract boolean checkHiliting(double var1, double var3);

    public abstract AbstractDrawingObject clone();

    public abstract String getDescriptorDetail();

    public abstract String getTypeString();

    public static AbstractDrawingObject instantiate(String descriptor) {
        return DrawingObjectFactory.createObject(descriptor);
    }

    public void move(double dx, double dy) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                this.mPoint[i].x += dx;
                this.mPoint[i].y += dy;
            }
        }
    }

    public void scale(double f) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                this.mPoint[i].x *= f;
                this.mPoint[i].y *= f;
            }
        }
    }

    public boolean isDeletable() {
        return !this.mProtectedFromDeletion;
    }

    public void setDeletable(boolean d) {
        this.mProtectedFromDeletion = !d;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean s) {
        this.mIsSelected = s;
    }

    public GenericRectangle getBoundingRect(GenericDrawContext context) {
        if (this.mPoint == null) {
            return null;
        }
        GenericRectangle bounds = new GenericRectangle(this.mPoint[0].x, this.mPoint[0].y, 0.0, 0.0);
        for (int i = 1; i < this.mPoint.length; ++i) {
            if (bounds.x > this.mPoint[i].x) {
                bounds.width += bounds.x - this.mPoint[i].x;
                bounds.x = this.mPoint[i].x;
            } else if (bounds.width < this.mPoint[i].x - bounds.x) {
                bounds.width = this.mPoint[i].x - bounds.x;
            }
            if (bounds.y > this.mPoint[i].y) {
                bounds.height += bounds.y - this.mPoint[i].y;
                bounds.y = this.mPoint[i].y;
                continue;
            }
            if (!(bounds.height < this.mPoint[i].y - bounds.y)) continue;
            bounds.height = this.mPoint[i].y - bounds.y;
        }
        return bounds;
    }

    public boolean isSurroundedBy(GenericShape shape) {
        if (this.mPoint == null) {
            return false;
        }
        for (int i = 0; i < this.mPoint.length; ++i) {
            if (shape.contains(this.mPoint[i].x, this.mPoint[i].y)) continue;
            return false;
        }
        return true;
    }

    public void translateInit(double x, double y) {
        this.mTransformationReferenceX = x;
        this.mTransformationReferenceY = y;
        if (this.mPoint != null) {
            int pointCount = this.mPoint.length;
            this.mTransformationValue1 = new double[pointCount];
            this.mTransformationValue2 = new double[pointCount];
            for (int i = 0; i < pointCount; ++i) {
                this.mTransformationValue1[i] = this.mPoint[i].x;
                this.mTransformationValue2[i] = this.mPoint[i].y;
            }
        }
    }

    public void translate(double x, double y) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                this.mPoint[i].x = this.mTransformationValue1[i] + x - this.mTransformationReferenceX;
                this.mPoint[i].y = this.mTransformationValue2[i] + y - this.mTransformationReferenceY;
            }
        }
    }

    public void zoomAndRotateInit(double x, double y) {
        this.mTransformationReferenceX = x;
        this.mTransformationReferenceY = y;
        if (this.mPoint != null) {
            int pointCount = this.mPoint.length;
            this.mTransformationValue1 = new double[pointCount];
            this.mTransformationValue2 = new double[pointCount];
            for (int i = 0; i < pointCount; ++i) {
                double dx = x - this.mPoint[i].x;
                double dy = y - this.mPoint[i].y;
                this.mTransformationValue2[i] = Math.sqrt(dx * dx + dy * dy);
                this.mTransformationValue1[i] = Molecule.getAngle(x, y, this.mPoint[i].x, this.mPoint[i].y);
            }
        }
    }

    public void zoomAndRotate(double zoom, double angle) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                double newDistance = this.mTransformationValue2[i] * zoom;
                double newAngle = this.mTransformationValue1[i] - angle;
                this.mPoint[i].x = this.mTransformationReferenceX + newDistance * Math.sin(newAngle);
                this.mPoint[i].y = this.mTransformationReferenceY + newDistance * Math.cos(newAngle);
            }
        }
    }

    public String getDescriptor() {
        return "<DrawingObject type=\"" + this.getTypeString() + "\"" + this.getDescriptorDetail() + DESCRIPTOR_END;
    }

    public String toString() {
        StringBuffer objectString = new StringBuffer();
        objectString.append(this.getDescriptor());
        return objectString.toString();
    }
}

