/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.RingCollection;

public class AromaticityResolver {
    ExtendedMolecule mMol;
    private boolean mAllHydrogensAreExplicit;
    private boolean[] mIsDelocalizedAtom;
    private boolean[] mIsDelocalizedBond;
    private int mAromaticAtoms;
    private int mAromaticBonds;
    private int mPiElectronsAdded;

    public AromaticityResolver(ExtendedMolecule mol) {
        this.mMol = mol;
    }

    public boolean locateDelocalizedDoubleBonds(boolean[] isAromaticBond) {
        return this.locateDelocalizedDoubleBonds(isAromaticBond, false, false);
    }

    public boolean locateDelocalizedDoubleBonds(boolean[] isAromaticBond, boolean mayChangeAtomCharges, boolean allHydrogensAreExplicit) {
        int bond;
        this.mMol.ensureHelperArrays(1);
        if (isAromaticBond != null) {
            this.mIsDelocalizedBond = isAromaticBond;
        } else {
            this.mIsDelocalizedBond = new boolean[this.mMol.getBonds()];
            for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (this.mMol.getBondType(bond) != 64) continue;
                this.mIsDelocalizedBond[bond] = true;
                this.mMol.setBondType(bond, 1);
            }
        }
        this.mPiElectronsAdded = 0;
        this.mIsDelocalizedAtom = new boolean[this.mMol.getAtoms()];
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (!this.mIsDelocalizedBond[bond]) continue;
            ++this.mAromaticBonds;
            for (int i = 0; i < 2; ++i) {
                if (this.mIsDelocalizedAtom[this.mMol.getBondAtom(i, bond)]) continue;
                this.mIsDelocalizedAtom[this.mMol.getBondAtom((int)i, (int)bond)] = true;
                ++this.mAromaticAtoms;
            }
        }
        if (this.mAromaticBonds == 0) {
            return true;
        }
        this.mAllHydrogensAreExplicit = allHydrogensAreExplicit;
        this.protectFullValenceAtoms(mayChangeAtomCharges);
        if (this.mMol.isFragment()) {
            this.promoteDelocalizedChains();
        }
        RingCollection ringSet = new RingCollection(this.mMol, 1);
        if (mayChangeAtomCharges) {
            this.addObviousAtomCharges(ringSet);
        }
        this.protectObviousDelocalizationLeaks(ringSet);
        this.protectAmideBonds(ringSet);
        this.protectDoubleBondAtoms();
        this.promoteObviousBonds();
        while (this.promoteOuterShellDelocalizedRingSystems(ringSet)) {
            this.promoteObviousBonds();
        }
        block4: while (this.mAromaticBonds != 0) {
            boolean bondsPromoted = false;
            if (!bondsPromoted) {
                for (int ring = 0; ring < ringSet.getSize(); ++ring) {
                    int i;
                    if (ringSet.getRingSize(ring) != 6) continue;
                    boolean isAromaticRing = true;
                    int[] ringBond = ringSet.getRingBonds(ring);
                    for (i = 0; i < 6; ++i) {
                        if (this.mIsDelocalizedBond[ringBond[i]]) continue;
                        isAromaticRing = false;
                        break;
                    }
                    if (!isAromaticRing) continue;
                    for (i = 0; i < 6; i += 2) {
                        this.promoteBond(ringBond[i]);
                    }
                    bondsPromoted = true;
                    break;
                }
            }
            if (bondsPromoted) continue;
            for (int bond2 = 0; bond2 < this.mMol.getBonds(); ++bond2) {
                if (!this.mIsDelocalizedBond[bond2]) continue;
                this.promoteBond(bond2);
                this.promoteObviousBonds();
                bondsPromoted = true;
                continue block4;
            }
        }
        return this.mAromaticAtoms == this.mPiElectronsAdded;
    }

    private void protectObviousDelocalizationLeaks(RingCollection ringSet) {
        int r;
        for (r = 0; r < ringSet.getSize(); ++r) {
            int ringSize = ringSet.getRingSize(r);
            if (ringSize != 3 && ringSize != 5 && ringSize != 7) continue;
            int[] ringAtom = ringSet.getRingAtoms(r);
            for (int i = 0; i < ringSize; ++i) {
                int atom = ringAtom[i];
                if (!this.isAromaticAtom(atom)) continue;
                if (ringSize == 5) {
                    if (!(this.mMol.getAtomicNo(atom) == 6 && this.mMol.getAtomCharge(atom) == -1 && this.mMol.getAllConnAtoms(atom) == 3 || this.mMol.getAtomicNo(atom) == 7 && this.mMol.getAtomCharge(atom) == 0 && this.mMol.getAllConnAtoms(atom) == 3 || this.mMol.getAtomicNo(atom) == 8 && this.mMol.getAtomCharge(atom) == 0 && this.mMol.getConnAtoms(atom) == 2 || this.mMol.getAtomicNo(atom) == 16 && this.mMol.getAtomCharge(atom) == 0 && this.mMol.getConnAtoms(atom) == 2) && (this.mMol.getAtomicNo(atom) != 34 || this.mMol.getAtomCharge(atom) != 0 || this.mMol.getConnAtoms(atom) != 2)) continue;
                    this.protectAtom(atom);
                    continue;
                }
                if ((this.mMol.getAtomicNo(atom) != 5 || this.mMol.getAtomCharge(atom) != 0 || this.mMol.getAllConnAtoms(atom) != 3) && (this.mMol.getAtomicNo(atom) != 6 || this.mMol.getAtomCharge(atom) != 1)) continue;
                this.protectAtom(atom);
            }
        }
        for (r = 0; r < ringSet.getSize(); ++r) {
            if (ringSet.getRingSize(r) != 5) continue;
            int[] ringBond = ringSet.getRingBonds(r);
            boolean isDelocalized = true;
            for (int i = 0; i < ringBond.length; ++i) {
                if (this.mIsDelocalizedBond[ringBond[i]]) continue;
                isDelocalized = false;
                break;
            }
            if (!isDelocalized) continue;
            int[] ringAtom = ringSet.getRingAtoms(r);
            int negativeCarbonPriority = 0;
            int negativeCarbon = -1;
            for (int i = 0; i < ringBond.length; ++i) {
                int priority;
                if (this.mMol.getAtomCharge(ringAtom[i]) != -1 || this.mMol.getAtomicNo(ringAtom[i]) != 6) continue;
                int n = this.mMol.getAllConnAtoms(ringAtom[i]) == 3 ? 3 : (priority = this.mMol.getAllConnAtomsPlusMetalBonds(ringAtom[i]) == 3 ? 2 : 1);
                if (negativeCarbonPriority >= priority) continue;
                negativeCarbonPriority = priority;
                negativeCarbon = ringAtom[i];
            }
            if (negativeCarbon == -1) continue;
            this.protectAtom(negativeCarbon);
        }
    }

    private boolean promoteOuterShellDelocalizedRingSystems(RingCollection ringSet) {
        int[] sharedDelocalizedRingCount = new int[this.mMol.getBonds()];
        for (int r = 0; r < ringSet.getSize(); ++r) {
            int i;
            int[] ringBond = ringSet.getRingBonds(r);
            boolean isDelocalized = true;
            for (i = 0; i < ringBond.length; ++i) {
                if (this.mIsDelocalizedBond[ringBond[i]]) continue;
                isDelocalized = false;
                break;
            }
            if (!isDelocalized) continue;
            for (i = 0; i < ringBond.length; ++i) {
                int n = ringBond[i];
                sharedDelocalizedRingCount[n] = sharedDelocalizedRingCount[n] + 1;
            }
        }
        int delocalizedBonds = this.mAromaticBonds;
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (sharedDelocalizedRingCount[bond] != 1) continue;
            block4: for (int i = 0; i < 2 && this.mIsDelocalizedBond[bond]; ++i) {
                int connIndex;
                int atom1 = this.mMol.getBondAtom(i, bond);
                int atom2 = this.mMol.getBondAtom(1 - i, bond);
                if (!this.hasSharedDelocalizedBond(atom1, sharedDelocalizedRingCount) || this.hasSharedDelocalizedBond(atom2, sharedDelocalizedRingCount)) continue;
                while (-1 != (connIndex = this.getNextOuterDelocalizedConnIndex(atom2, atom1, sharedDelocalizedRingCount))) {
                    int atom3 = this.mMol.getConnAtom(atom2, connIndex);
                    int bond2to3 = this.mMol.getConnBond(atom2, connIndex);
                    if (!this.mIsDelocalizedBond[bond2to3]) continue block4;
                    this.promoteBond(bond2to3);
                    connIndex = this.getNextOuterDelocalizedConnIndex(atom3, atom2, sharedDelocalizedRingCount);
                    if (connIndex == -1) continue block4;
                    atom1 = atom3;
                    atom2 = this.mMol.getConnAtom(atom3, connIndex);
                }
            }
        }
        return delocalizedBonds != this.mAromaticBonds;
    }

    private boolean hasSharedDelocalizedBond(int atom, int[] sharedDelocalizedRingCount) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (sharedDelocalizedRingCount[this.mMol.getConnBond(atom, i)] <= 1) continue;
            return true;
        }
        return false;
    }

    private int getNextOuterDelocalizedConnIndex(int atom, int previousAtom, int[] sharedDelocalizedRingCount) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (sharedDelocalizedRingCount[this.mMol.getConnBond(atom, i)] != 1 || this.mMol.getConnAtom(atom, i) == previousAtom) continue;
            return i;
        }
        return -1;
    }

    private boolean isAromaticAtom(int atom) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (!this.mIsDelocalizedBond[this.mMol.getConnBond(atom, i)]) continue;
            return true;
        }
        return false;
    }

    private void protectFullValenceAtoms(boolean mayChangeAtomCharges) {
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (!this.mIsDelocalizedAtom[atom] || this.mMol.getLowestFreeValence(atom) != 0 || mayChangeAtomCharges && (this.mMol.getAtomicNo(atom) != 5 || this.mMol.getAtomCharge(atom) >= 0) && this.mMol.getAtomicNo(atom) != 6 && this.mMol.getAtomicNo(atom) != 14 && (!this.mMol.isElectronegative(atom) || this.mMol.getAtomCharge(atom) <= 0)) continue;
            this.protectAtom(atom);
        }
    }

    private void protectAtom(int atom) {
        if (this.mIsDelocalizedAtom[atom]) {
            this.mIsDelocalizedAtom[atom] = false;
            --this.mAromaticAtoms;
        }
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            int connBond = this.mMol.getConnBond(atom, i);
            if (!this.mIsDelocalizedBond[connBond]) continue;
            this.mIsDelocalizedBond[connBond] = false;
            --this.mAromaticBonds;
        }
    }

    private void promoteBond(int bond) {
        if (this.mMol.getBondType(bond) == 1) {
            this.mMol.setBondType(bond, 2);
            this.mPiElectronsAdded += 2;
        }
        for (int i = 0; i < 2; ++i) {
            int bondAtom = this.mMol.getBondAtom(i, bond);
            this.mIsDelocalizedAtom[bondAtom] = false;
            for (int j = 0; j < this.mMol.getConnAtoms(bondAtom); ++j) {
                int connBond = this.mMol.getConnBond(bondAtom, j);
                if (!this.mIsDelocalizedBond[connBond]) continue;
                this.mIsDelocalizedBond[connBond] = false;
                --this.mAromaticBonds;
            }
        }
    }

    private void promoteObviousBonds() {
        boolean terminalAromaticBondFound;
        do {
            terminalAromaticBondFound = false;
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (!this.mIsDelocalizedBond[bond]) continue;
                boolean isTerminalAromaticBond = false;
                for (int i = 0; i < 2; ++i) {
                    int bondAtom = this.mMol.getBondAtom(i, bond);
                    boolean aromaticNeighbourFound = false;
                    for (int j = 0; j < this.mMol.getConnAtoms(bondAtom); ++j) {
                        if (bond == this.mMol.getConnBond(bondAtom, j) || !this.mIsDelocalizedBond[this.mMol.getConnBond(bondAtom, j)]) continue;
                        aromaticNeighbourFound = true;
                        break;
                    }
                    if (aromaticNeighbourFound) continue;
                    isTerminalAromaticBond = true;
                    break;
                }
                if (!isTerminalAromaticBond) continue;
                terminalAromaticBondFound = true;
                this.promoteBond(bond);
            }
        } while (terminalAromaticBondFound);
    }

    private void promoteDelocalizedChains() {
        block0: for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (!this.mIsDelocalizedBond[bond]) continue;
            for (int i = 0; i < 2; ++i) {
                int terminalAtom = this.mMol.getBondAtom(i, bond);
                boolean aromaticNeighbourFound = false;
                for (int j = 0; j < this.mMol.getConnAtoms(terminalAtom); ++j) {
                    if (bond == this.mMol.getConnBond(terminalAtom, j) || !this.mIsDelocalizedBond[this.mMol.getConnBond(terminalAtom, j)]) continue;
                    aromaticNeighbourFound = true;
                    break;
                }
                if (aromaticNeighbourFound) continue;
                int terminalBond = bond;
                int bridgeAtom = this.mMol.getBondAtom(1 - i, bond);
                block3: while (terminalBond != -1) {
                    this.mIsDelocalizedBond[terminalBond] = false;
                    --this.mAromaticBonds;
                    this.mMol.setBondType(terminalBond, 64);
                    terminalBond = -1;
                    terminalAtom = bridgeAtom;
                    for (int j = 0; j < this.mMol.getConnAtoms(terminalAtom); ++j) {
                        if (!this.mIsDelocalizedBond[this.mMol.getConnBond(terminalAtom, j)]) continue;
                        if (terminalBond == -1) {
                            terminalBond = this.mMol.getConnBond(terminalAtom, j);
                            bridgeAtom = this.mMol.getConnAtom(terminalAtom, j);
                            continue;
                        }
                        terminalAtom = -1;
                        terminalBond = -1;
                        continue block3;
                    }
                }
                continue block0;
            }
        }
    }

    private void protectAmideBonds(RingCollection ringSet) {
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (!this.mIsDelocalizedBond[bond] || !ringSet.qualifiesAsAmideTypeBond(bond)) continue;
            this.protectAtom(this.mMol.getBondAtom(0, bond));
            this.protectAtom(this.mMol.getBondAtom(1, bond));
        }
    }

    private void protectDoubleBondAtoms() {
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondOrder(bond) != 2) continue;
            block1: for (int i = 0; i < 2; ++i) {
                int atom = this.mMol.getBondAtom(i, bond);
                if (this.mMol.getAtomicNo(atom) > 8) continue;
                for (int j = 0; j < this.mMol.getConnAtoms(atom); ++j) {
                    int connBond = this.mMol.getConnBond(atom, j);
                    if (!this.mIsDelocalizedBond[connBond]) continue;
                    this.protectAtom(atom);
                    continue block1;
                }
            }
        }
    }

    private void addObviousAtomCharges(RingCollection ringSet) {
        boolean[] isDelocalized = new boolean[ringSet.getSize()];
        int[] delocalizedRingCount = new int[this.mMol.getAtoms()];
        for (int r = 0; r < ringSet.getSize(); ++r) {
            isDelocalized[r] = true;
            for (int bond : ringSet.getRingBonds(r)) {
                if (this.mIsDelocalizedBond[bond]) continue;
                isDelocalized[r] = false;
                break;
            }
            if (!isDelocalized[r]) continue;
            int[] nArray = ringSet.getRingAtoms(r);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int atom;
                int n2 = atom = nArray[i];
                delocalizedRingCount[n2] = delocalizedRingCount[n2] + 1;
            }
        }
        boolean[] isAromaticRingAtom = new boolean[this.mMol.getAtoms()];
        for (int ring = 0; ring < ringSet.getSize(); ++ring) {
            int ringSize = ringSet.getRingSize(ring);
            if (ringSize != 3 && ringSize != 5 && ringSize != 6 && ringSize != 7 || !isDelocalized[ring]) continue;
            for (int atom : ringSet.getRingAtoms(ring)) {
                isAromaticRingAtom[atom] = true;
            }
            boolean possible = true;
            int leakAtom = -1;
            int leakPriority = 0;
            for (int atom : ringSet.getRingAtoms(ring)) {
                int priority;
                if (ringSize == 6 || delocalizedRingCount[atom] > 1) {
                    if (this.checkAtomTypePi1(atom, false)) continue;
                    possible = false;
                    break;
                }
                int n = priority = ringSize == 5 ? this.checkAtomTypeLeak5(atom, false) : this.checkAtomTypeLeak7(atom, false);
                if (!this.checkAtomTypePi1(atom, false)) {
                    if (leakPriority == 10) {
                        possible = false;
                        break;
                    }
                    leakAtom = atom;
                    leakPriority = 20;
                    continue;
                }
                if (leakPriority >= priority) continue;
                leakPriority = priority;
                leakAtom = atom;
            }
            if (!possible) continue;
            for (int atom : ringSet.getRingAtoms(ring)) {
                if (atom == leakAtom) {
                    if (ringSize == 5) {
                        this.checkAtomTypeLeak5(atom, true);
                    } else {
                        this.checkAtomTypeLeak7(atom, true);
                    }
                    this.protectAtom(atom);
                    continue;
                }
                this.checkAtomTypePi1(atom, true);
            }
        }
        int[] delocalizedNeighbourCount = new int[this.mMol.getAtoms()];
        boolean[] hasMetalLigandBond = new boolean[this.mMol.getAtoms()];
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atom2 = this.mMol.getBondAtom(1, bond);
            if (isAromaticRingAtom[atom1] || isAromaticRingAtom[atom2]) continue;
            if (this.mIsDelocalizedBond[bond]) {
                int n = atom1;
                delocalizedNeighbourCount[n] = delocalizedNeighbourCount[n] + 1;
                int n3 = atom2;
                delocalizedNeighbourCount[n3] = delocalizedNeighbourCount[n3] + 1;
            }
            if (this.mMol.getBondType(bond) != 32) continue;
            hasMetalLigandBond[atom1] = true;
            hasMetalLigandBond[atom2] = true;
        }
        int[] priority = new int[this.mMol.getAtoms()];
        int[] graphAtom = new int[this.mMol.getAtoms()];
        for (int seedAtom = 0; seedAtom < this.mMol.getAtoms(); ++seedAtom) {
            if (delocalizedNeighbourCount[seedAtom] != 1) continue;
            graphAtom[0] = seedAtom;
            int highest = 0;
            block9: for (int current = 0; current <= highest; ++current) {
                for (int i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                    if (!this.mIsDelocalizedBond[this.mMol.getConnBond(graphAtom[current], i)]) continue;
                    int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                    if (current != 0 && candidate == graphAtom[current - 1] || delocalizedNeighbourCount[candidate] == 0) continue;
                    graphAtom[++highest] = candidate;
                    if ((delocalizedNeighbourCount[candidate] & 1) == 0) continue block9;
                    for (int j = 1; j < highest; j += 2) {
                        priority[graphAtom[j]] = -1;
                    }
                    highest = 0;
                    continue block9;
                }
            }
        }
        boolean[] atomHandled = new boolean[this.mMol.getAtoms()];
        for (int seedAtom = 0; seedAtom < this.mMol.getAtoms(); ++seedAtom) {
            int i;
            if (atomHandled[seedAtom] || delocalizedNeighbourCount[seedAtom] == 0) continue;
            graphAtom[0] = seedAtom;
            atomHandled[seedAtom] = true;
            int highest = 0;
            for (int current = 0; current <= highest; ++current) {
                for (i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                    int candidate;
                    if (!this.mIsDelocalizedBond[this.mMol.getConnBond(graphAtom[current], i)] || atomHandled[candidate = this.mMol.getConnAtom(graphAtom[current], i)]) continue;
                    graphAtom[++highest] = candidate;
                    atomHandled[candidate] = true;
                }
            }
            if (highest & true) continue;
            for (i = 0; i <= highest; ++i) {
                if (priority[graphAtom[i]] != 0) continue;
                priority[graphAtom[i]] = this.checkAtomTypeLeakNonRing(graphAtom[i], false);
            }
            boolean isPossible = true;
            for (int i2 = 0; i2 <= highest; ++i2) {
                if (priority[graphAtom[i2]] > 0 || this.checkAtomTypePi1(graphAtom[i2], false)) continue;
                isPossible = false;
                break;
            }
            if (!isPossible) continue;
            int maxPriority = 0;
            int maxAtom = -1;
            for (int i3 = 0; i3 <= highest; ++i3) {
                if (maxPriority >= priority[graphAtom[i3]]) continue;
                maxPriority = priority[graphAtom[i3]];
                maxAtom = graphAtom[i3];
            }
            if (maxPriority <= 0) continue;
            this.checkAtomTypeLeakNonRing(maxAtom, true);
            this.protectAtom(maxAtom);
        }
    }

    private boolean checkAtomTypePi1(int atom, boolean correctCharge) {
        int atomicNo = this.mMol.getAtomicNo(atom);
        if (atomicNo >= 5 && atomicNo <= 8 || atomicNo == 15 || atomicNo == 16 || atomicNo == 33 || atomicNo == 34 || atomicNo == 52) {
            int freeValence = this.mMol.getLowestFreeValence(atom);
            if (freeValence != 0) {
                return true;
            }
            int charge = this.mMol.getAtomCharge(atom);
            if (atomicNo == 5 && charge >= 0) {
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, charge - 1);
                }
                return true;
            }
            if (atomicNo != 5 && charge <= 0) {
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, charge + 1);
                }
                return true;
            }
        }
        return false;
    }

    private int checkAtomTypeLeak5(int atom, boolean correctCharge) {
        if (this.mMol.getAtomicNo(atom) == 7) {
            if (this.mMol.getAllConnAtoms(atom) == 3) {
                return 6;
            }
            if (this.mMol.getConnAtoms(atom) == 2) {
                return 4;
            }
        } else {
            if (this.mMol.getAtomicNo(atom) == 8) {
                return 10;
            }
            if (this.mMol.getAtomicNo(atom) == 15 || this.mMol.getAtomicNo(atom) == 33) {
                if (this.mMol.getConnAtoms(atom) == 3) {
                    return 8;
                }
            } else if (this.mMol.getAtomicNo(atom) == 16 || this.mMol.getAtomicNo(atom) == 34 || this.mMol.getAtomicNo(atom) == 52) {
                if (this.mMol.getConnAtoms(atom) == 2) {
                    return 12;
                }
            } else if (this.mMol.getAtomicNo(atom) == 6) {
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.mMol.getAllConnAtoms(atom) != this.mMol.getAllConnAtomsPlusMetalBonds(atom) ? 2 : 3;
            }
        }
        return 0;
    }

    private int checkAtomTypeLeak7(int atom, boolean correctCharge) {
        if (this.mAllHydrogensAreExplicit ? this.mMol.getAllConnAtoms(atom) != 3 : this.mMol.getAllConnAtoms(atom) > 3) {
            return 0;
        }
        if (this.mMol.getAtomicNo(atom) == 6) {
            if (correctCharge) {
                this.mMol.setAtomCharge(atom, 1);
            }
            return 2;
        }
        if (this.mMol.getAtomicNo(atom) == 5) {
            return 4;
        }
        return 0;
    }

    private int checkAtomTypeLeakNonRing(int atom, boolean correctCharge) {
        if (this.mMol.getAtomCharge(atom) != 0) {
            return 0;
        }
        if (this.mAllHydrogensAreExplicit) {
            if (this.mMol.getAtomicNo(atom) == 5) {
                if (this.mMol.getOccupiedValence(atom) != 2) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, 1);
                }
                return 1;
            }
            if (this.mMol.getAtomicNo(atom) == 7) {
                if (this.mMol.getOccupiedValence(atom) != 2) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 6 : 3;
            }
            if (this.mMol.getAtomicNo(atom) == 8) {
                if (this.mMol.getOccupiedValence(atom) != 1) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 7 : 4;
            }
            if (this.mMol.getAtomicNo(atom) == 16) {
                if (this.mMol.getOccupiedValence(atom) != 1) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 5 : 2;
            }
            if (this.mMol.getAtomicNo(atom) == 34) {
                if (this.mMol.getOccupiedValence(atom) != 1) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 4 : 1;
            }
        } else {
            if (this.mMol.getAtomicNo(atom) == 5) {
                if (this.mMol.getOccupiedValence(atom) > 2) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, 1);
                }
                return 1;
            }
            if (this.mMol.getAtomicNo(atom) == 7) {
                if (this.mMol.getOccupiedValence(atom) > 2) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 5 : 3;
            }
            if (this.mMol.getAtomicNo(atom) == 8) {
                if (this.mMol.getOccupiedValence(atom) > 1) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 7 : 4;
            }
            if (this.mMol.getAtomicNo(atom) == 16) {
                if (this.mMol.getOccupiedValence(atom) > 1) {
                    return 0;
                }
                if (correctCharge) {
                    this.mMol.setAtomCharge(atom, -1);
                }
                return this.hasMetalNeighbour(atom) ? 5 : 2;
            }
        }
        return 0;
    }

    private boolean hasMetalNeighbour(int atom) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (!this.mMol.isMetalAtom(this.mMol.getConnAtom(atom, i))) continue;
            return true;
        }
        return false;
    }
}

