/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;

public class AtomFunctionAnalyzer {
    private static int getOxoCount(StereoMolecule mol, int atom) {
        int count = 0;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            if (mol.getConnBondOrder(atom, i) != 2 || mol.getAtomicNo(mol.getConnAtom(atom, i)) != 8) continue;
            ++count;
        }
        return count;
    }

    private static int getFakeOxoCount(StereoMolecule mol, int atom) {
        int count = 0;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            if (mol.getConnBondOrder(atom, i) != 2 || mol.getAtomicNo(mol.getConnAtom(atom, i)) != 7 && mol.getAtomicNo(mol.getConnAtom(atom, i)) != 8 && mol.getAtomicNo(mol.getConnAtom(atom, i)) != 16) continue;
            ++count;
        }
        return count;
    }

    public static int getNegativeNeighbourCount(StereoMolecule mol, int atom) {
        int count = 0;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            if (!mol.isElectronegative(mol.getConnAtom(atom, i))) continue;
            ++count;
        }
        return count;
    }

    public static boolean isAlkylAmine(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 7 || mol.isAromaticAtom(atom) || mol.getAtomPi(atom) != 0) {
            return false;
        }
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(conn) == 6 && mol.getAtomPi(conn) == 0 && !mol.isAromaticAtom(conn) && AtomFunctionAnalyzer.getNegativeNeighbourCount(mol, conn) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isStabilized(StereoMolecule mol, int atom, boolean twice) {
        boolean aleadyFound = false;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn;
            if (mol.isAromaticBond(mol.getConnBond(atom, i)) || mol.getConnBondOrder(atom, i) != 1 || mol.isAromaticAtom(conn = mol.getConnAtom(atom, i)) || (mol.getAtomicNo(conn) != 6 || AtomFunctionAnalyzer.getFakeOxoCount(mol, conn) != 1) && (mol.getAtomicNo(conn) != 16 || AtomFunctionAnalyzer.getFakeOxoCount(mol, conn) != 2)) continue;
            if (aleadyFound || !twice) {
                return true;
            }
            aleadyFound = true;
        }
        return false;
    }

    public static boolean isAmide(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 7 || mol.getAtomPi(atom) != 0 || mol.isAromaticAtom(atom)) {
            return false;
        }
        boolean carbonylEquivalentFound = false;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(conn) == 6 && AtomFunctionAnalyzer.getOxoCount(mol, conn) == 1 || mol.getAtomicNo(conn) == 16 && AtomFunctionAnalyzer.getOxoCount(mol, conn) == 2) {
                carbonylEquivalentFound = true;
                continue;
            }
            if (mol.getAtomicNo(conn) == 6) continue;
            return false;
        }
        return carbonylEquivalentFound;
    }

    public static boolean isAmine(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 7 || mol.isAromaticAtom(atom) || mol.getAtomPi(atom) != 0) {
            return false;
        }
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(conn) == 6 && (mol.isAromaticAtom(conn) || mol.getAtomPi(conn) == 0 && AtomFunctionAnalyzer.getNegativeNeighbourCount(mol, conn) == 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArylAmine(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 7 || mol.isAromaticAtom(atom) || mol.getAtomPi(atom) != 0) {
            return false;
        }
        boolean aromaticNeighbourFound = false;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(conn) != 6 || !mol.isAromaticAtom(conn) && (mol.getAtomPi(conn) != 0 || AtomFunctionAnalyzer.getNegativeNeighbourCount(mol, conn) != 1)) {
                return false;
            }
            if (!mol.isAromaticAtom(conn)) continue;
            aromaticNeighbourFound = true;
        }
        return aromaticNeighbourFound;
    }

    public static boolean hasUnbalancedAtomCharge(StereoMolecule mol, int atom) {
        if (mol.getAtomCharge(atom) == 0) {
            return false;
        }
        boolean unbalanced = true;
        int chargeCenterAtom = mol.getAtomCharge(atom);
        int nConnected = mol.getConnAtoms(atom);
        int sumChargeConnectedAtoms = 0;
        for (int i = 0; i < nConnected; ++i) {
            int indexAtom = mol.getConnAtom(atom, i);
            sumChargeConnectedAtoms += mol.getAtomCharge(indexAtom);
        }
        if (Math.abs(chargeCenterAtom) <= Math.abs(sumChargeConnectedAtoms) && Math.signum(chargeCenterAtom) != Math.signum(sumChargeConnectedAtoms)) {
            unbalanced = false;
        }
        return unbalanced;
    }

    public static boolean isAcidicOxygen(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 8 || mol.getAtomCharge(atom) != 0 || mol.getConnAtoms(atom) != 1 || mol.getConnBondOrder(atom, 0) != 1) {
            return false;
        }
        int connAtom = mol.getConnAtom(atom, 0);
        if (mol.getAtomicNo(connAtom) == 6) {
            int nConnected2C = mol.getConnAtoms(connAtom);
            for (int i = 0; i < nConnected2C; ++i) {
                int indexBond;
                int indexAtom = mol.getConnAtom(connAtom, i);
                if (indexAtom == atom || mol.getAtomicNo(indexAtom) != 8 || mol.getBondType(indexBond = mol.getBond(connAtom, indexAtom)) != 2) continue;
                return true;
            }
        } else if (mol.getAtomicNo(connAtom) == 7) {
            if (mol.getAtomCharge(connAtom) == 1) {
                return true;
            }
        } else if (mol.getAtomicNo(connAtom) == 16) {
            int nConnected2S = mol.getConnAtoms(connAtom);
            int nDoubleBondedO2S = 0;
            for (int i = 0; i < nConnected2S; ++i) {
                int indexBond;
                int indexAtom = mol.getConnAtom(connAtom, i);
                if (indexAtom == atom || mol.getAtomicNo(indexAtom) != 8 || mol.getBondType(indexBond = mol.getBond(connAtom, indexAtom)) != 2) continue;
                ++nDoubleBondedO2S;
            }
            if (nDoubleBondedO2S == 2) {
                return true;
            }
        } else if (AtomFunctionAnalyzer.isAcidicOxygenAtPhosphoricAcid(mol, atom)) {
            return true;
        }
        return false;
    }

    public static boolean isAcidicOxygenAtPhosphoricAcid(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 8) {
            return false;
        }
        if (mol.getConnAtoms(atom) != 1) {
            return false;
        }
        int connAtom = mol.getConnAtom(atom, 0);
        if (mol.getAtomicNo(connAtom) == 15) {
            int nConnected2P = mol.getConnAtoms(connAtom);
            for (int i = 0; i < nConnected2P; ++i) {
                int indexBond;
                int indexAtom = mol.getConnAtom(connAtom, i);
                if (indexAtom == atom || mol.getAtomicNo(indexAtom) != 8 || mol.getBondType(indexBond = mol.getBond(connAtom, indexAtom)) != 2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMemberOfNitroGroup(StereoMolecule mol, int atom) {
        boolean member;
        block4: {
            block3: {
                member = false;
                if (mol.getAtomicNo(atom) != 7 && mol.getAtomicNo(atom) != 8) {
                    return false;
                }
                if (mol.getAtomicNo(atom) != 7) break block3;
                if (!AtomFunctionAnalyzer.isNitroGroupN(mol, atom)) break block4;
                member = true;
                break block4;
            }
            if (mol.getAtomicNo(atom) == 8) {
                int nConnAts = mol.getConnAtoms(atom);
                for (int i = 0; i < nConnAts; ++i) {
                    int indexAt = mol.getConnAtom(atom, i);
                    if (mol.getAtomicNo(indexAt) != 7 || !AtomFunctionAnalyzer.isNitroGroupN(mol, indexAt)) continue;
                    member = true;
                    break;
                }
            }
        }
        return member;
    }

    public static boolean isNitroGroupN(StereoMolecule mol, int atom) {
        boolean nitro = false;
        if (mol.getAtomicNo(atom) != 7) {
            return false;
        }
        int nConnAts = mol.getConnAtoms(atom);
        int indexSingleBondedO = -1;
        int indexDoubleBondedO = -1;
        for (int i = 0; i < nConnAts; ++i) {
            int indexAt = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(indexAt) != 8) continue;
            int indexBnd = mol.getBond(atom, indexAt);
            if (mol.getBondOrder(indexBnd) == 1) {
                indexSingleBondedO = indexAt;
                continue;
            }
            if (mol.getBondOrder(indexBnd) != 2) continue;
            indexDoubleBondedO = indexAt;
        }
        if (indexSingleBondedO > -1 && indexDoubleBondedO > -1) {
            nitro = true;
        }
        return nitro;
    }

    public static boolean isBasicNitrogen(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 7 || mol.getAtomCharge(atom) != 0 || mol.getConnAtoms(atom) + mol.getAtomPi(atom) > 3) {
            return false;
        }
        if (mol.isAromaticAtom(atom)) {
            if (mol.getAtomPi(atom) != 1) {
                return false;
            }
            if (mol.getAtomRingCount(atom, 7) != 1) {
                return false;
            }
            RingCollection rc = mol.getRingSet();
            for (int r = 0; r < rc.getSize(); ++r) {
                int exoCyclicAtom;
                int i;
                if (!rc.isAtomMember(r, atom)) continue;
                if (rc.getRingSize(r) != 5 && rc.getRingSize(r) != 6) break;
                int[] ring = rc.getRingAtoms(r);
                int nIndex = -1;
                for (int i2 = 0; i2 < ring.length; ++i2) {
                    if (ring[i2] != atom) continue;
                    nIndex = i2;
                    break;
                }
                int enablerCount = 0;
                int[] opi = null;
                int[] mi = null;
                if (ring.length == 5) {
                    opi = new int[]{ring[nIndex - 1 < 0 ? nIndex + 4 : nIndex - 1], ring[nIndex - 4 < 0 ? nIndex + 1 : nIndex - 4]};
                    mi = new int[]{ring[nIndex - 2 < 0 ? nIndex + 3 : nIndex - 2], ring[nIndex - 3 < 0 ? nIndex + 2 : nIndex - 3]};
                }
                if (ring.length == 6) {
                    opi = new int[]{ring[nIndex - 1 < 0 ? nIndex + 5 : nIndex - 1], ring[nIndex - 3 < 0 ? nIndex + 3 : nIndex - 3], ring[nIndex - 5 < 0 ? nIndex + 1 : nIndex - 5]};
                    mi = new int[]{ring[nIndex - 2 < 0 ? nIndex + 4 : nIndex - 2], ring[nIndex - 4 < 0 ? nIndex + 2 : nIndex - 4]};
                }
                for (i = 0; i < ring.length; ++i) {
                    if (atom == ring[i] || mol.getAtomicNo(ring[i]) != 7 || mol.getAtomPi(ring[i]) != 1) continue;
                    --enablerCount;
                }
                block3: for (i = 0; i < opi.length; ++i) {
                    exoCyclicAtom = -1;
                    int exoCyclicBond = -1;
                    for (int j = 0; j < mol.getConnAtoms(opi[i]); ++j) {
                        if (mol.isAromaticBond(mol.getConnBond(opi[i], j))) continue;
                        exoCyclicAtom = mol.getConnAtom(opi[i], j);
                        exoCyclicBond = mol.getConnBond(opi[i], j);
                        break;
                    }
                    if (exoCyclicAtom == -1) continue;
                    if (mol.getAtomicNo(exoCyclicAtom) == 7 && mol.getAtomPi(exoCyclicAtom) == 0 && mol.getConnAtoms(exoCyclicAtom) + mol.getAtomPi(exoCyclicAtom) <= 3 && !AtomFunctionAnalyzer.isStabilized(mol, exoCyclicAtom, false)) {
                        ++enablerCount;
                        continue;
                    }
                    if (mol.getAtomicNo(exoCyclicAtom) == 8 && mol.getConnAtoms(exoCyclicAtom) == 1) {
                        enablerCount += 2;
                        continue;
                    }
                    if (!mol.isAromaticBond(exoCyclicBond)) continue;
                    for (int s = 0; s < rc.getSize(); ++s) {
                        if (!rc.isAromatic(s) || !rc.isAtomMember(s, exoCyclicAtom)) continue;
                        int[] ratom = rc.getRingAtoms(s);
                        for (int j = 0; j < ratom.length; ++j) {
                            if (mol.getAtomicNo(ratom[j]) != 7 || mol.getAtomPi(ratom[j]) != 1) continue;
                            --enablerCount;
                            continue block3;
                        }
                        continue block3;
                    }
                }
                for (i = 0; i < mi.length; ++i) {
                    exoCyclicAtom = -1;
                    for (int j = 0; j < mol.getConnAtoms(mi[i]); ++j) {
                        if (mol.isAromaticBond(mol.getConnBond(mi[i], j))) continue;
                        exoCyclicAtom = mol.getConnAtom(mi[i], j);
                    }
                    if (mol.getAtomicNo(mi[i]) == 6) {
                        if (exoCyclicAtom == -1 || AtomFunctionAnalyzer.getFakeOxoCount(mol, exoCyclicAtom) == 0) continue;
                        --enablerCount;
                        continue;
                    }
                    if (mol.getAtomicNo(mi[i]) != 7 || mol.getAtomPi(mi[i]) != 0 || exoCyclicAtom != -1 && (mol.isAromaticAtom(exoCyclicAtom) || AtomFunctionAnalyzer.getFakeOxoCount(mol, exoCyclicAtom) != 0)) continue;
                    ++enablerCount;
                }
                return enablerCount > 0;
            }
            return false;
        }
        if (mol.getAtomPi(atom) > 1) {
            return false;
        }
        if (mol.getAtomPi(atom) == 1) {
            int imineC = -1;
            int supporterCount = 0;
            for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
                int conn = mol.getConnAtom(atom, i);
                if (mol.getConnBondOrder(atom, i) == 2) {
                    if (mol.getAtomicNo(conn) != 6) {
                        return false;
                    }
                    imineC = conn;
                    continue;
                }
                if (mol.getAtomicNo(conn) == 8) {
                    return false;
                }
                if (mol.getAtomicNo(conn) == 7) {
                    --supporterCount;
                    if (!AtomFunctionAnalyzer.isStabilized(mol, conn, false)) continue;
                    --supporterCount;
                    continue;
                }
                if (!mol.isAromaticAtom(conn)) continue;
                --supporterCount;
            }
            if (imineC == -1) {
                return false;
            }
            int aromaticNeighborCount = 0;
            for (int i = 0; i < mol.getConnAtoms(imineC); ++i) {
                if (mol.getConnBondOrder(imineC, i) != 1) continue;
                int conn = mol.getConnAtom(imineC, i);
                if (AtomFunctionAnalyzer.getFakeOxoCount(mol, conn) != 0) {
                    return false;
                }
                if (mol.isAromaticAtom(conn)) {
                    ++aromaticNeighborCount;
                }
                if (mol.getAtomicNo(conn) == 7 && !AtomFunctionAnalyzer.isStabilized(mol, conn, true)) {
                    ++supporterCount;
                }
                if (mol.getAtomicNo(conn) != 8 && mol.getAtomicNo(conn) != 16) continue;
                --supporterCount;
            }
            if (aromaticNeighborCount == 2) {
                --supporterCount;
            }
            return supporterCount >= 0;
        }
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn = mol.getConnAtom(atom, i);
            if (mol.isAromaticAtom(conn)) {
                return false;
            }
            if (mol.getAtomicNo(conn) != 6) {
                return false;
            }
            if (AtomFunctionAnalyzer.getFakeOxoCount(mol, conn) != 0) {
                return false;
            }
            if (mol.getAtomPi(conn) == 0 || !AtomFunctionAnalyzer.isVinylogFakeOxo(mol, conn)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVinylogFakeOxo(StereoMolecule mol, int atom) {
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            if (mol.getConnBondOrder(atom, i) == 1) continue;
            int conn = mol.getConnAtom(atom, i);
            for (int j = 0; j < mol.getConnAtoms(conn); ++j) {
                if (mol.getConnBondOrder(conn, j) != 1 || AtomFunctionAnalyzer.getFakeOxoCount(mol, mol.getConnAtom(conn, j)) == 0) continue;
                return true;
            }
        }
        return false;
    }
}

