/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.StereoMolecule;

public class AtomTypeCalculator {
    public static final int cPropertiesAll = 32702;
    public static final int cPropertiesForSolubility = 2144;
    public static final int cPropertiesForCLogPCharges = 6241;
    public static final int cPropertiesForCLogP = 2145;
    public static final int cPropertiesForMutator = 32190;
    public static final int cPropertiesBasicType = 60;
    public static final int cPropertiesAtomSmallRing = 1;
    public static final int cPropertiesAtomRingSize = 2;
    public static final int cPropertiesAtomAromatic = 4;
    public static final int cPropertiesAtomAllylic = 8;
    public static final int cPropertiesAtomStabilized = 16;
    public static final int cPropertiesAtomCharged = 4096;
    public static final int cPropertiesAtomRingCount = 8192;
    public static final int cPropertiesConnBondOrder = 32;
    public static final int cPropertiesConnAtomTypeSimple = 64;
    public static final int cPropertiesConnAtomType = 128;
    public static final int cPropertiesConnAtomNeighbours = 256;
    public static final int cPropertiesConnAtomNeighboursExact = 512;
    public static final int cPropertiesConnAtomSmallRing = 1024;
    public static final int cPropertiesConnAtomAromatic = 2048;
    public static final int cPropertiesConnAtomStabilized = 16384;
    private static final long ATOM_FLAG_COUNT = 15L;
    private static final long CONN_FLAG_COUNT = 11L;
    private static final long ATOM_FLAGS_ATOMICNO = 15L;
    private static final long ATOM_FLAGS_RINGSIZE = 112L;
    private static final long ATOM_SHIFT_RINGSIZE = 4L;
    private static final long ATOM_FLAGS_RINGCOUNT = 896L;
    private static final long ATOM_SHIFT_RINGCOUNT = 7L;
    private static final long ATOM_FLAG_SMALLRING = 64L;
    private static final long ATOM_FLAG_AROMATIC = 1024L;
    private static final long ATOM_FLAG_ALLYLIC = 2048L;
    private static final long ATOM_FLAG_STABILIZED = 4096L;
    private static final long ATOM_FLAG_CHARGED = 8192L;
    private static final long ATOM_FLAG_AMPHOLYTIC = 16384L;
    private static final long CONN_FLAGS_ALL = 2047L;
    private static final long CONN_FLAGS_ATOMICNO = 15L;
    private static final long CONN_FLAGS_BONDORDER = 48L;
    private static final long CONN_SHIFT_BONDORDER = 4L;
    private static final long CONN_FLAGS_NEIGHBOURS = 192L;
    private static final long CONN_SHIFT_NEIGHBOURS = 6L;
    private static final long CONN_FLAG_SMALLRING = 256L;
    private static final long CONN_FLAG_AROMATIC = 512L;
    private static final long CONN_FLAG_STABILIZED = 1024L;
    private static final short[] cAtomicNoCode = new short[]{-1, -1, -1, 0, 0, 1, 2, 3, 4, 5, -1, 0, 0, 0, 6, 7, 8, 9, -1, 0, 0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 1, 11, 11, 12, 13, -1, 0, 0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 0, 0, 0, 11, 14, -1, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 10, 10, 10, 10, 10, 10, 10, 10, 1, 1, 1, 1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final short[] cSimpleAtomicNoCode = new short[]{-1, -1, -1, 0, 0, 0, 2, 5, 5, 5, -1, 0, 0, 0, 0, 9, 9, 9, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String[] cAtomicNoCodeString = new String[]{"MainGroupMetal", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluor", "Silicon", "Phosphorous", "Sulfur", "Chlorine", "Transition Metal", "MainGroupNonMetal", "Selene", "Bromine", "Iodine", "LanthanideOrActinide"};
    private static final String[] cSimpleAtomicNoCodeString = new String[]{"Metal", "-", "Carbon", "-", "-", "Small Hetero", "-", "-", "-", "Large Hetero", "-", "-", "-", "-", "-", "-"};

    public static String getAtomicNoCodeString(int atomicNoCode) {
        return cAtomicNoCodeString[atomicNoCode];
    }

    public static String getSimpleAtomicNoCodeString(int atomicNoCode) {
        return cSimpleAtomicNoCodeString[atomicNoCode];
    }

    public static void printAtomType(StereoMolecule mol, int atom) {
        try {
            AtomTypeCalculator.printAtomType(AtomTypeCalculator.getAtomType(mol, atom));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String getHeaderString(int mode) {
        StringBuffer sb = new StringBuffer();
        sb.append("AtomicNo-Code");
        if ((mode & 2) != 0) {
            sb.append("\tRingsize");
        }
        if ((mode & 1) != 0) {
            sb.append("\tRingmember");
        }
        if ((mode & 4) != 0) {
            sb.append("\tAromatic");
        }
        if ((mode & 8) != 0) {
            sb.append("\tAllylic");
        }
        if ((mode & 0x10) != 0) {
            sb.append("\tStabilized");
        }
        if ((mode & 0x1000) != 0) {
            sb.append("\tCharged\tAmpholytic");
        }
        if ((mode & 0x2000) != 0) {
            sb.append("\tRingCount");
        }
        for (int i = 1; i <= 4; ++i) {
            if ((mode & 0x20) != 0) {
                sb.append("\tConnBondType" + i);
            }
            if ((mode & 0x80) != 0) {
                sb.append("\tConnAtomType" + i);
            } else if ((mode & 0x40) != 0) {
                sb.append("\tSimpleConnAtomType" + i);
            }
            if ((mode & 0x100) != 0) {
                sb.append("\tConnMoreNeighbours" + i);
            }
            if ((mode & 0x400) != 0) {
                sb.append("\tConnIsSmallRingMember" + i);
            }
            if ((mode & 0x800) != 0) {
                sb.append("\tConnIsAromatic" + i);
            }
            if ((mode & 0x4000) == 0) continue;
            sb.append("\tConnIsStabilized" + i);
        }
        return sb.toString();
    }

    public static String getTypeString(long type, int mode) {
        StringBuffer sb = new StringBuffer();
        sb.append(AtomTypeCalculator.getAtomicNoCodeString((int)(type & 0xFL)));
        if ((mode & 2) != 0) {
            long ringSize = (type & 0x70L) >> 4;
            if (ringSize != 0L) {
                ringSize += 2L;
            }
            sb.append("\t" + ringSize);
        }
        if ((mode & 1) != 0) {
            sb.append("\t" + ((type & 0x40L) != 0L ? "yes" : "no"));
        }
        if ((mode & 4) != 0) {
            sb.append("\t" + ((type & 0x400L) != 0L ? "yes" : "no"));
        }
        if ((mode & 8) != 0) {
            sb.append("\t" + ((type & 0x800L) != 0L ? "yes" : "no"));
        }
        if ((mode & 0x10) != 0) {
            sb.append("\t" + ((type & 0x1000L) != 0L ? "yes" : "no"));
        }
        if ((mode & 0x1000) != 0) {
            sb.append("\t" + ((type & 0x2000L) != 0L ? "yes" : "no"));
            sb.append("\t" + ((type & 0x4000L) != 0L ? "yes" : "no"));
        }
        if ((mode & 0x2000) != 0) {
            long ringCount = (type & 0x380L) >> 7;
            sb.append("\t" + ringCount);
        }
        type >>= 15;
        for (int i = 1; i <= 4; ++i) {
            long neighbourType = type & 0x7FFL;
            if (neighbourType != 0L) {
                if ((mode & 0x20) != 0) {
                    sb.append("\t" + ((neighbourType & 0x30L) >> 4));
                }
                if ((mode & 0x80) != 0) {
                    sb.append("\t" + AtomTypeCalculator.getAtomicNoCodeString((int)(neighbourType & 0xFL)));
                } else if ((mode & 0x40) != 0) {
                    sb.append("\t" + AtomTypeCalculator.getSimpleAtomicNoCodeString((int)(neighbourType & 0xFL)));
                }
                if ((mode & 0x100) != 0) {
                    long otherNeighbours = (neighbourType & 0xC0L) >> 6;
                    if ((mode & 0x200) == 0) {
                        sb.append("\t" + (otherNeighbours == 0L ? "no" : "yes"));
                    } else {
                        sb.append("\t" + otherNeighbours);
                    }
                }
                if ((mode & 0x400) != 0) {
                    sb.append("\t" + ((neighbourType & 0x100L) != 0L ? "yes" : "no"));
                }
                if ((mode & 0x800) != 0) {
                    sb.append("\t" + ((neighbourType & 0x200L) != 0L ? "yes" : "no"));
                }
                if ((mode & 0x4000) != 0) {
                    sb.append("\t" + ((neighbourType & 0x400L) != 0L ? "yes" : "no"));
                }
            }
            type >>= 11;
        }
        return sb.toString();
    }

    public static String toString(long type) {
        return AtomTypeCalculator.toString(type, 32702);
    }

    public static String toString(long type, int mode) {
        StringBuffer sb = new StringBuffer();
        sb.append(AtomTypeCalculator.getAtomicNoCodeString((int)(type & 0xFL)) + ":");
        if ((mode & 0x1000) != 0) {
            if ((type & 0x2000L) != 0L) {
                sb.append("Chg");
            }
            if ((type & 0x4000L) != 0L) {
                sb.append("Amp");
            }
        }
        if ((mode & 0x2000) != 0) {
            long ringCount = (type & 0x380L) >> 7;
            sb.append("Rc" + ringCount);
        }
        if ((mode & 2) != 0) {
            long ringSize = (type & 0x70L) >> 4;
            if (ringSize != 0L) {
                ringSize += 2L;
            }
            sb.append("Rs" + ringSize);
        }
        if ((mode & 4) != 0 && (type & 0x400L) != 0L) {
            sb.append("Ar");
        }
        if ((mode & 8) != 0 && (type & 0x800L) != 0L) {
            sb.append("Al");
        }
        if ((mode & 0x10) != 0 && (type & 0x1000L) != 0L) {
            sb.append("St");
        }
        type >>= 15;
        for (int j = 0; j < 4 && type != 0L; type >>= 11, ++j) {
            if ((mode & 0x20) != 0) {
                int bondType = (int)((type & 0x30L) >> 4);
                switch (bondType) {
                    case 0: {
                        sb.append(" *");
                        break;
                    }
                    case 1: {
                        sb.append(" -");
                        break;
                    }
                    case 2: {
                        sb.append(" =");
                        break;
                    }
                    case 3: {
                        sb.append(" #");
                    }
                }
            }
            sb.append("{");
            if ((mode & 0x80) != 0) {
                sb.append(AtomTypeCalculator.getAtomicNoCodeString((int)(type & 0xFL)) + ":");
            } else if ((mode & 0x40) != 0) {
                sb.append(AtomTypeCalculator.getSimpleAtomicNoCodeString((int)(type & 0xFL)) + ":");
            }
            long neighbours = ((type & 0xC0L) >> 6) + 1L;
            if ((mode & 0x100) != 0) {
                sb.append("N" + neighbours);
            }
            if ((mode & 0x400) != 0 && (type & 0x100L) != 0L) {
                sb.append("Ri");
            }
            if ((mode & 0x800) != 0 && (type & 0x200L) != 0L) {
                sb.append("Ar");
            }
            if ((mode & 0x4000) != 0 && (type & 0x400L) != 0L) {
                sb.append("St");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public static void printAtomType(long type) {
        System.out.println(AtomTypeCalculator.toString(type));
    }

    public static long getAtomType(StereoMolecule mol, int atom) throws Exception {
        return AtomTypeCalculator.getAtomType(mol, atom, 32702);
    }

    public static long getAtomType(StereoMolecule mol, int atom, int mode) throws Exception {
        int i;
        mol.ensureHelperArrays(7);
        long[] neighbourType = new long[mol.getConnAtoms(atom)];
        int neighbourCount = 0;
        for (int i2 = 0; i2 < mol.getConnAtoms(atom); ++i2) {
            int connAtom = mol.getConnAtom(atom, i2);
            if (mol.getAtomicNo(connAtom) == 1) continue;
            long connType = 0L;
            if ((mode & 0x20) != 0) {
                long connBondOrder = mol.getConnBondOrder(atom, i2);
                if (mode == 32190) {
                    if (connBondOrder < 3L && mol.isDelocalizedBond(mol.getConnBond(atom, i2)) && mol.getAtomPi(atom) == 1) {
                        connBondOrder = 0L;
                    }
                } else if (connBondOrder < 3L && mol.isAromaticBond(mol.getConnBond(atom, i2))) {
                    connBondOrder = 0L;
                }
                connType |= connBondOrder << 4;
            }
            if ((mode & 0x80) != 0) {
                if (cAtomicNoCode[mol.getAtomicNo(connAtom)] == -1) {
                    throw new Exception("unsupported atomicNo:" + mol.getAtomicNo(connAtom));
                }
                connType += (long)cAtomicNoCode[mol.getAtomicNo(connAtom)];
            } else if ((mode & 0x40) != 0) {
                if (cSimpleAtomicNoCode[mol.getAtomicNo(connAtom)] == -1) {
                    throw new Exception("unsupported atomicNo:" + mol.getAtomicNo(connAtom));
                }
                connType += (long)cSimpleAtomicNoCode[mol.getAtomicNo(connAtom)];
            }
            if ((mode & 0x100) != 0) {
                int otherNeighbours = mol.getConnAtoms(connAtom) - 1;
                if (otherNeighbours > 3) {
                    otherNeighbours = 3;
                }
                if ((mode & 0x200) == 0 && otherNeighbours > 1) {
                    otherNeighbours = 1;
                }
                connType |= (long)(otherNeighbours << 6);
            }
            if ((mode & 0x400) != 0 && mol.isSmallRingAtom(connAtom)) {
                connType |= 0x100L;
            }
            if ((mode & 0x800) != 0 && mol.isAromaticAtom(connAtom)) {
                connType |= 0x200L;
            }
            if ((mode & 0x4000) != 0 && mol.isStabilizedAtom(connAtom)) {
                connType |= 0x400L;
            }
            int index = 0;
            while (connType < neighbourType[index]) {
                ++index;
            }
            for (int j = i2; j > index; --j) {
                neighbourType[j] = neighbourType[j - 1];
            }
            neighbourType[index] = connType;
            ++neighbourCount;
        }
        if (neighbourCount > 4) {
            neighbourCount = 4;
        }
        long atomType = 0L;
        for (i = 0; i < neighbourCount; ++i) {
            atomType <<= 11;
            atomType |= neighbourType[i];
        }
        atomType <<= 15;
        if (cAtomicNoCode[mol.getAtomicNo(atom)] == -1) {
            throw new Exception("unsupported atomicNo:" + mol.getAtomicNo(atom));
        }
        atomType |= (long)cAtomicNoCode[mol.getAtomicNo(atom)];
        if ((mode & 2) != 0) {
            int ringSize = mol.getAtomRingSize(atom);
            if (ringSize > 9) {
                ringSize = 9;
            }
            if (ringSize > 2) {
                ringSize -= 2;
            }
            atomType |= (long)(ringSize << 4);
        } else if ((mode & 1) != 0 && mol.isSmallRingAtom(atom)) {
            atomType |= 0x40L;
        }
        if ((mode & 4) != 0 && mol.isAromaticAtom(atom)) {
            atomType |= 0x400L;
        }
        if ((mode & 8) != 0 && mol.isAllylicAtom(atom)) {
            atomType |= 0x800L;
        }
        if ((mode & 0x10) != 0 && mol.isStabilizedAtom(atom)) {
            atomType |= 0x1000L;
        }
        if ((mode & 0x1000) != 0) {
            if (AtomFunctionAnalyzer.hasUnbalancedAtomCharge(mol, atom)) {
                atomType |= 0x2000L;
            }
            if (AtomFunctionAnalyzer.isBasicNitrogen(mol, atom)) {
                for (i = 0; i < mol.getAtoms(); ++i) {
                    if (!AtomFunctionAnalyzer.isAcidicOxygen(mol, i)) continue;
                    atomType |= 0x4000L;
                    break;
                }
            }
        }
        if ((mode & 0x2000) != 0) {
            long ringCount = mol.getAtomRingCount(atom, 10);
            atomType |= ringCount << 7;
        }
        return atomType;
    }
}

