/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.CanonizerBaseValue;
import com.actelion.research.chem.CanonizerFragment;
import com.actelion.research.chem.CanonizerMesoHelper;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.EZHalfParity;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SortedStringList;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class Canonizer {
    public static final int CREATE_SYMMETRY_RANK = 1;
    public static final int CONSIDER_DIASTEREOTOPICITY = 2;
    public static final int CONSIDER_ENANTIOTOPICITY = 4;
    public static final int CONSIDER_STEREOHETEROTOPICITY = 6;
    public static final int ENCODE_ATOM_CUSTOM_LABELS = 8;
    public static final int ENCODE_ATOM_SELECTION = 16;
    public static final int ASSIGN_PARITIES_TO_TETRAHEDRAL_N = 32;
    public static final int COORDS_ARE_3D = 64;
    public static final int CREATE_PSEUDO_STEREO_GROUPS = 128;
    public static final int DISTINGUISH_RACEMIC_OR_GROUPS = 256;
    public static final int TIE_BREAK_FREE_VALENCE_ATOMS = 512;
    public static final int ENCODE_ATOM_CUSTOM_LABELS_WITHOUT_RANKING = 1024;
    public static final int NEGLECT_ANY_STEREO_INFORMATION = 2048;
    protected static final int cIDCodeVersion2 = 8;
    protected static final int cIDCodeVersion3 = 9;
    public static final int cIDCodeCurrentVersion = 9;
    protected static final int cParity1And = 4;
    protected static final int cParity2And = 5;
    protected static final int cParity1Or = 6;
    protected static final int cParity2Or = 7;
    private StereoMolecule mMol;
    private int[] mCanRank;
    private int[] mCanRankBeforeTieBreaking;
    private int[] mPseudoTHGroup;
    private int[] mPseudoEZGroup;
    private byte[] mTHParity;
    private byte[] mEZParity;
    private byte[] mTHConfiguration;
    private byte[] mEZConfiguration;
    private byte[] mTHCIPParity;
    private byte[] mEZCIPParity;
    private byte[] mTHESRType;
    private byte[] mTHESRGroup;
    private byte[] mEZESRType;
    private byte[] mEZESRGroup;
    private byte[] mAbnormalValence;
    private CanonizerBaseValue[] mCanBase;
    private CanonizerMesoHelper mMesoHelper;
    private boolean mIsMeso;
    private boolean mStereoCentersFound;
    private boolean[] mIsStereoCenter;
    private boolean[] mTHParityIsMesoInverted;
    private boolean[] mTHParityNeedsNormalization;
    private boolean[] mTHESRTypeNeedsNormalization;
    private boolean[] mTHParityRoundIsOdd;
    private boolean[] mEZParityRoundIsOdd;
    private boolean[] mTHParityIsPseudo;
    private boolean[] mEZParityIsPseudo;
    private boolean[] mProTHAtomsInSameFragment;
    private boolean[] mProEZAtomsInSameFragment;
    private boolean[] mNitrogenQualifiesForParity;
    private ArrayList<CanonizerFragment> mFragmentList;
    private ArrayList<int[]> mTHParityNormalizationGroupList;
    private int mMode;
    private int mNoOfRanks;
    private int mNoOfPseudoGroups;
    private boolean mIsOddParityRound;
    private boolean mZCoordinatesAvailable;
    private boolean mCIPParityNoDistinctionProblem;
    private boolean mEncodeAvoid127;
    private boolean mGraphGenerated;
    private int mGraphRings;
    private int[] mGraphAtom;
    private int[] mGraphIndex;
    private int[] mGraphBond;
    private int[] mGraphFrom;
    private int[] mGraphClosure;
    private String mIDCode;
    private String mEncodedCoords;
    private String mMapping;
    private StringBuilder mEncodingBuffer;
    private int mEncodingBitsAvail;
    private int mEncodingTempData;
    private int mAtomBits;
    private int mMaxConnAtoms;

    public Canonizer(StereoMolecule mol) {
        this(mol, 0);
    }

    public Canonizer(StereoMolecule mol, int mode) {
        this.mMol = mol;
        this.mMode = mode;
        this.mMol.ensureHelperArrays(7);
        this.mAtomBits = Canonizer.getNeededBits(this.mMol.getAtoms());
        if ((this.mMode & 0x800) == 0) {
            this.canFindNitrogenQualifyingForParity();
        }
        boolean bl = this.mZCoordinatesAvailable = (mode & 0x40) != 0 || this.mMol.is3D();
        if ((this.mMode & 0x800) == 0) {
            this.mTHParity = new byte[this.mMol.getAtoms()];
            this.mTHParityIsPseudo = new boolean[this.mMol.getAtoms()];
            this.mTHParityRoundIsOdd = new boolean[this.mMol.getAtoms()];
            this.mEZParity = new byte[this.mMol.getBonds()];
            this.mEZParityRoundIsOdd = new boolean[this.mMol.getBonds()];
            this.mEZParityIsPseudo = new boolean[this.mMol.getBonds()];
        }
        this.mCIPParityNoDistinctionProblem = false;
        this.canInitializeRanking();
        if ((this.mMode & 0x800) == 0) {
            this.canRankStereo();
        }
        this.canRankFinal();
    }

    public boolean hasCIPParityDistinctionProblem() {
        return this.mCIPParityNoDistinctionProblem;
    }

    private void canFindNitrogenQualifyingForParity() {
        this.mNitrogenQualifiesForParity = new boolean[this.mMol.getAtoms()];
        block6: for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            boolean bridgeHeadMayInvert;
            int smallRingNo;
            int smallRingSize;
            if (this.mMol.getAtomicNo(atom) != 7) continue;
            if (this.mMol.getConnAtoms(atom) == 4) {
                this.mNitrogenQualifiesForParity[atom] = true;
                continue;
            }
            if (this.mMol.getConnAtoms(atom) != 3) continue;
            if (this.mMol.getAtomRingSize(atom) == 3) {
                this.mNitrogenQualifiesForParity[atom] = true;
                continue;
            }
            if (this.mMol.getAtomCharge(atom) == 1) {
                this.mNitrogenQualifiesForParity[atom] = true;
                continue;
            }
            if (this.mMol.isFlatNitrogen(atom)) continue;
            if ((this.mMode & 0x20) != 0) {
                this.mNitrogenQualifiesForParity[atom] = true;
                continue;
            }
            if (this.mMol.getAtomRingBondCount(atom) != 3 || (smallRingSize = this.mMol.getAtomRingSize(atom)) > 7) continue;
            RingCollection ringSet = this.mMol.getRingSet();
            for (smallRingNo = 0; !(smallRingNo >= ringSet.getSize() || ringSet.getRingSize(smallRingNo) == smallRingSize && ringSet.isAtomMember(smallRingNo, atom)); ++smallRingNo) {
            }
            int firstBridgeAtom = -1;
            int firstBridgeBond = -1;
            for (int i = 0; i < 3; ++i) {
                int connBond = this.mMol.getConnBond(atom, i);
                if (ringSet.isBondMember(smallRingNo, connBond)) continue;
                firstBridgeAtom = this.mMol.getConnAtom(atom, i);
                firstBridgeBond = connBond;
                break;
            }
            boolean[] neglectBond = new boolean[this.mMol.getBonds()];
            neglectBond[firstBridgeBond] = true;
            int[] pathAtom = new int[11];
            int pathLength = this.mMol.getPath(pathAtom, firstBridgeAtom, atom, 10, neglectBond);
            if (pathLength == -1) continue;
            int bridgeAtomCount = 1;
            while (!ringSet.isAtomMember(smallRingNo, pathAtom[bridgeAtomCount])) {
                ++bridgeAtomCount;
            }
            int bondCountToBridgeHead = pathLength - bridgeAtomCount;
            int bridgeHead = pathAtom[bridgeAtomCount];
            if (smallRingSize == 6 && bondCountToBridgeHead == 2 && bridgeAtomCount == 3 && this.mMol.getAtomRingBondCount(pathAtom[1]) >= 3) {
                boolean isAdamantane = false;
                int[] ringAtom = ringSet.getRingAtoms(smallRingNo);
                for (int i = 0; i < 6; ++i) {
                    if (atom != ringAtom[i]) continue;
                    int potentialOtherBridgeHeadIndex = ringSet.validateMemberIndex(smallRingNo, bridgeHead == ringAtom[ringSet.validateMemberIndex(smallRingNo, i + 2)] ? i - 2 : i + 2);
                    int potentialOtherBridgeHead = ringAtom[potentialOtherBridgeHeadIndex];
                    if (this.mMol.getAtomRingBondCount(potentialOtherBridgeHead) < 3 || this.mMol.getPathLength(pathAtom[1], potentialOtherBridgeHead, 2, null) != 2) break;
                    isAdamantane = true;
                    break;
                }
                if (isAdamantane) {
                    this.mNitrogenQualifiesForParity[atom] = true;
                    continue;
                }
            }
            boolean bridgeHeadIsFlat = this.mMol.getAtomPi(bridgeHead) == 1 || this.mMol.isAromaticAtom(bridgeHead) || this.mMol.isFlatNitrogen(bridgeHead);
            boolean bl = bridgeHeadMayInvert = !bridgeHeadIsFlat && this.mMol.getAtomicNo(bridgeHead) == 7 && this.mMol.getAtomCharge(bridgeHead) != 1;
            if (bondCountToBridgeHead == 1) {
                if (bridgeHeadIsFlat || bridgeHeadMayInvert || smallRingSize > 4 || bridgeAtomCount > 3) continue;
                this.mNitrogenQualifiesForParity[atom] = true;
                continue;
            }
            switch (smallRingSize) {
                case 4: {
                    if (bridgeHeadIsFlat || bridgeHeadMayInvert || bridgeAtomCount > 4) continue block6;
                    this.mNitrogenQualifiesForParity[atom] = true;
                    continue block6;
                }
                case 5: {
                    if (bridgeHeadMayInvert) {
                        if (bridgeAtomCount > 3) continue block6;
                        this.mNitrogenQualifiesForParity[atom] = true;
                        continue block6;
                    }
                    if (bridgeHeadIsFlat || bridgeAtomCount > 4) continue block6;
                    this.mNitrogenQualifiesForParity[atom] = true;
                    continue block6;
                }
                case 6: {
                    if (bondCountToBridgeHead == 2) {
                        if (bridgeHeadIsFlat) {
                            if (bridgeAtomCount > 4) continue block6;
                            this.mNitrogenQualifiesForParity[atom] = true;
                            continue block6;
                        }
                        if (bridgeHeadMayInvert || bridgeAtomCount > 3) continue block6;
                        this.mNitrogenQualifiesForParity[atom] = true;
                        continue block6;
                    }
                    if (bondCountToBridgeHead != 3) continue block6;
                    if (bridgeHeadIsFlat) {
                        if (bridgeAtomCount > 6) continue block6;
                        this.mNitrogenQualifiesForParity[atom] = true;
                        continue block6;
                    }
                    if (bridgeAtomCount > 4) continue block6;
                    this.mNitrogenQualifiesForParity[atom] = true;
                    continue block6;
                }
                case 7: {
                    if (bondCountToBridgeHead != 3 || bridgeAtomCount > 3) continue block6;
                    this.mNitrogenQualifiesForParity[atom] = true;
                }
            }
        }
    }

    private int canCalcImplicitAbnormalValence(int atom) {
        int explicitAbnormalValence = this.mMol.getAtomAbnormalValence(atom);
        int implicitHigherValence = this.mMol.getImplicitHigherValence(atom, false);
        int newImplicitHigherValence = this.mMol.getImplicitHigherValence(atom, true);
        int valence = -1;
        if (implicitHigherValence != newImplicitHigherValence) {
            valence = explicitAbnormalValence != -1 && explicitAbnormalValence > implicitHigherValence ? (int)((byte)explicitAbnormalValence) : (int)((byte)implicitHigherValence);
        } else if (explicitAbnormalValence != -1) {
            if (explicitAbnormalValence > newImplicitHigherValence || explicitAbnormalValence < newImplicitHigherValence && explicitAbnormalValence >= this.mMol.getOccupiedValence(atom)) {
                valence = (byte)explicitAbnormalValence;
            }
        } else if (!this.mMol.supportsImplicitHydrogen(atom) && this.mMol.getExplicitHydrogens(atom) != 0) {
            valence = this.mMol.getOccupiedValence(atom);
            valence -= this.mMol.getElectronValenceCorrection(atom, valence);
        }
        this.canSetAbnormalValence(atom, valence);
        return valence;
    }

    private void canSetAbnormalValence(int atom, int valence) {
        if (this.mAbnormalValence == null) {
            this.mAbnormalValence = new byte[this.mMol.getAtoms()];
            Arrays.fill(this.mAbnormalValence, (byte)-1);
        }
        this.mAbnormalValence[atom] = (byte)valence;
    }

    private void canRankStereo() {
        int atom;
        int noOfRanksWithoutStereo = this.mNoOfRanks;
        int[] canRankWithoutStereo = Arrays.copyOf(this.mCanRank, this.mMol.getAtoms());
        if (!this.mMol.isFragment()) {
            this.canRecursivelyFindCIPParities();
            this.initializeParities(noOfRanksWithoutStereo, canRankWithoutStereo);
        }
        this.mTHESRType = new byte[this.mMol.getAtoms()];
        this.mTHESRGroup = new byte[this.mMol.getAtoms()];
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            this.mTHESRType[atom] = (byte)this.mMol.getAtomESRType(atom);
            this.mTHESRGroup[atom] = (byte)this.mMol.getAtomESRGroup(atom);
        }
        this.mEZESRType = new byte[this.mMol.getBonds()];
        this.mEZESRGroup = new byte[this.mMol.getBonds()];
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            this.mEZESRType[bond] = (byte)this.mMol.getBondESRType(bond);
            this.mEZESRGroup[bond] = (byte)this.mMol.getBondESRGroup(bond);
        }
        this.canRecursivelyFindAllParities();
        this.mStereoCentersFound = false;
        this.mIsStereoCenter = new boolean[this.mMol.getAtoms()];
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 0) continue;
            this.mIsStereoCenter[atom] = true;
            this.mStereoCentersFound = true;
        }
        this.canRemoveOverspecifiedESRGroups();
        this.mMesoHelper = null;
        this.mTHESRTypeNeedsNormalization = new boolean[this.mMol.getAtoms()];
        if (this.mStereoCentersFound) {
            this.mMesoHelper = new CanonizerMesoHelper(this.mMol, canRankWithoutStereo, this.mIsStereoCenter, this.mTHParity, this.mEZParity, this.mTHESRType, this.mTHESRGroup, this.mEZESRType, this.mEZESRGroup, this.mTHParityRoundIsOdd, this.mEZParityRoundIsOdd, this.mTHESRTypeNeedsNormalization);
            this.mMesoHelper.normalizeESRGroups();
        }
        this.mTHParityIsMesoInverted = new boolean[this.mMol.getAtoms()];
        this.mTHParityNeedsNormalization = new boolean[this.mMol.getAtoms()];
        this.mTHParityNormalizationGroupList = new ArrayList();
        if (this.mMesoHelper != null) {
            this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank);
        }
        this.canMarkESRGroupsForParityNormalization();
        this.initializeParities(noOfRanksWithoutStereo, canRankWithoutStereo);
        this.canRecursivelyFindCanonizedParities();
        if (this.mMesoHelper != null) {
            this.mIsMeso = this.mMesoHelper.isMeso();
        }
        this.determineChirality(canRankWithoutStereo);
    }

    private void canRankFinal() {
        int atom;
        int atom2;
        if ((this.mMode & 0x800) == 0) {
            this.mProTHAtomsInSameFragment = new boolean[this.mMol.getAtoms()];
            this.mProEZAtomsInSameFragment = new boolean[this.mMol.getBonds()];
            if ((this.mMode & 6) != 0) {
                for (atom2 = 0; atom2 < this.mMol.getAtoms(); ++atom2) {
                    this.mCanBase[atom2].init(atom2);
                    this.mCanBase[atom2].add(this.mAtomBits + 12, this.mCanRank[atom2] << 12);
                }
            }
            if (this.mNoOfRanks < this.mMol.getAtoms()) {
                int proParities = 0;
                for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    if (!this.canCalcTHParity(atom, true)) continue;
                    ++proParities;
                }
                for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                    if (!this.canCalcEZParity(bond, true)) continue;
                    ++proParities;
                }
            }
            if ((this.mMode & 6) != 0) {
                this.mNoOfRanks = this.canPerformRanking();
            }
        }
        if ((this.mMode & 1) != 0) {
            this.mCanRankBeforeTieBreaking = Arrays.copyOf(this.mCanRank, this.mMol.getAtoms());
        }
        while (this.mNoOfRanks < this.mMol.getAtoms()) {
            for (atom2 = 0; atom2 < this.mMol.getAtoms(); ++atom2) {
                this.mCanBase[atom2].init(atom2);
                this.mCanBase[atom2].add(this.mAtomBits + 1, 2 * this.mCanRank[atom2]);
            }
            int[] rankCount = new int[this.mNoOfRanks + 1];
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                int n = this.mCanRank[atom];
                rankCount[n] = rankCount[n] + 1;
            }
            int rank = 1;
            while (rankCount[rank] == 1) {
                ++rank;
            }
            for (int atom3 = 0; atom3 < this.mMol.getAtoms(); ++atom3) {
                if (this.mCanRank[atom3] != rank) continue;
                this.mCanBase[atom3].add(1L);
                break;
            }
            this.mNoOfRanks = this.canPerformRanking();
            if ((this.mMode & 0x800) != 0) continue;
            this.canNormalizeGroupParities();
            if (this.mMesoHelper == null) continue;
            this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank);
        }
        if ((this.mMode & 0x800) == 0) {
            this.canNormalizeGroupParities();
            this.canFindPseudoParities();
            this.flagStereoProblems();
        }
    }

    private void initializeParities(int noOfRanksWithoutStereo, int[] canRankWithoutStereo) {
        this.mNoOfRanks = noOfRanksWithoutStereo;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            this.mCanRank[atom] = canRankWithoutStereo[atom];
            this.mTHParity[atom] = 0;
            this.mTHParityRoundIsOdd[atom] = false;
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            this.mEZParity[bond] = 0;
            this.mEZParityRoundIsOdd[bond] = false;
        }
    }

    private void canInitializeRanking() {
        int i;
        int atom;
        boolean bondQueryFeaturesPresent = false;
        if (this.mMol.isFragment()) {
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (this.mMol.getBondQueryFeatures(bond) == 0) continue;
                bondQueryFeaturesPresent = true;
                break;
            }
        }
        this.mMaxConnAtoms = 2;
        for (int atom2 = 0; atom2 < this.mMol.getAtoms(); ++atom2) {
            this.mMaxConnAtoms = Math.max(this.mMaxConnAtoms, this.mMol.getConnAtoms(atom2) + this.mMol.getMetalBondedConnAtoms(atom2));
        }
        int baseValueSize = Math.max(2, bondQueryFeaturesPresent ? (62 + this.mAtomBits + this.mMaxConnAtoms * (this.mAtomBits + 21)) / 63 : (62 + this.mAtomBits + this.mMaxConnAtoms * (this.mAtomBits + 5)) / 63);
        this.mCanRank = new int[this.mMol.getAllAtoms()];
        this.mCanBase = new CanonizerBaseValue[this.mMol.getAtoms()];
        for (int atom3 = 0; atom3 < this.mMol.getAtoms(); ++atom3) {
            this.mCanBase[atom3] = new CanonizerBaseValue(baseValueSize);
        }
        boolean atomListFound = false;
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            this.mCanBase[atom].init(atom);
            if ((this.mMol.getAtomQueryFeatures(atom) & 1L) != 0L || this.mMol.getAtomList(atom) != null) {
                this.mCanBase[atom].add(8, 6L);
            } else {
                this.mCanBase[atom].add(8, this.mMol.getAtomicNo(atom));
            }
            this.mCanBase[atom].add(8, this.mMol.getAtomMass(atom));
            this.mCanBase[atom].add(2, this.mMol.getAtomPi(atom));
            this.mCanBase[atom].add(4, this.mMol.getConnAtoms(atom) + this.mMol.getMetalBondedConnAtoms(atom));
            if ((this.mMol.getAtomQueryFeatures(atom) & 1L) != 0L) {
                this.mCanBase[atom].add(4, 8L);
            } else {
                this.mCanBase[atom].add(4, 8 + this.mMol.getAtomCharge(atom));
            }
            this.mCanBase[atom].add(5, Math.min(31, this.mMol.getAtomRingSize(atom)));
            this.mCanBase[atom].add(4, this.canCalcImplicitAbnormalValence(atom) + 1);
            this.mCanBase[atom].add(2, this.mMol.getAtomRadical(atom) >> 4);
            if (!this.mMol.isFragment()) continue;
            this.mCanBase[atom].add(39, this.mMol.getAtomQueryFeatures(atom));
            if (this.mMol.getAtomList(atom) == null) continue;
            atomListFound = true;
        }
        this.mNoOfRanks = this.canPerformRanking();
        if (this.mNoOfRanks < this.mMol.getAtoms()) {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                int i2;
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
                int[] bondRingSize = new int[this.mMol.getConnAtoms(atom)];
                for (i2 = 0; i2 < this.mMol.getConnAtoms(atom); ++i2) {
                    bondRingSize[i2] = this.mCanRank[this.mMol.getConnAtom(atom, i2)] << 5;
                    int n = i2;
                    bondRingSize[n] = bondRingSize[n] | Math.min(31, this.mMol.getBondRingSize(this.mMol.getConnBond(atom, i2)));
                }
                Arrays.sort(bondRingSize);
                for (i2 = this.mMaxConnAtoms; i2 > bondRingSize.length; --i2) {
                    this.mCanBase[atom].add(this.mAtomBits + 5, 0L);
                }
                for (i2 = bondRingSize.length - 1; i2 >= 0; --i2) {
                    this.mCanBase[atom].add(this.mAtomBits + 5, bondRingSize[i2]);
                }
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if (atomListFound && this.mNoOfRanks < this.mMol.getAtoms()) {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
                int[] atomList = this.mMol.getAtomList(atom);
                int listLength = atomList == null ? 0 : Math.min(12, atomList.length);
                for (i = 12; i > listLength; --i) {
                    this.mCanBase[atom].add(8, 0L);
                }
                for (i = listLength - 1; i >= 0; --i) {
                    this.mCanBase[atom].add(8, atomList[i]);
                }
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if (bondQueryFeaturesPresent && this.mNoOfRanks < this.mMol.getAtoms()) {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
                long[] bondQFList = new long[this.mMol.getConnAtoms(atom) + this.mMol.getMetalBondedConnAtoms(atom)];
                int index = 0;
                for (i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(atom); ++i) {
                    if (i >= this.mMol.getConnAtoms(atom) && i < this.mMol.getAllConnAtoms(atom)) continue;
                    bondQFList[index] = this.mCanRank[this.mMol.getConnAtom(atom, i)];
                    int n = index;
                    bondQFList[n] = bondQFList[n] << 21;
                    int n2 = index++;
                    bondQFList[n2] = bondQFList[n2] | (long)this.mMol.getBondQueryFeatures(this.mMol.getConnBond(atom, i));
                }
                Arrays.sort(bondQFList);
                for (i = this.mMaxConnAtoms; i > bondQFList.length; --i) {
                    this.mCanBase[atom].add(this.mAtomBits + 21, 0L);
                }
                for (i = bondQFList.length - 1; i >= 0; --i) {
                    this.mCanBase[atom].add(this.mAtomBits + 21, bondQFList[i]);
                }
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if ((this.mMode & 8) != 0 && this.mNoOfRanks < this.mMol.getAtoms()) {
            int atom4;
            SortedStringList list = new SortedStringList();
            for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
                if (this.mMol.getAtomCustomLabel(atom4) == null) continue;
                list.addString(this.mMol.getAtomCustomLabel(atom4));
            }
            for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
                int rank = this.mMol.getAtomCustomLabel(atom4) == null ? 0 : 1 + list.getListIndex(this.mMol.getAtomCustomLabel(atom4));
                this.mCanBase[atom4].init(atom4);
                this.mCanBase[atom4].add(this.mAtomBits, this.mCanRank[atom4]);
                this.mCanBase[atom4].add(this.mAtomBits, rank);
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if ((this.mMode & 0x10) != 0 && this.mNoOfRanks < this.mMol.getAtoms()) {
            for (int atom5 = 0; atom5 < this.mMol.getAtoms(); ++atom5) {
                this.mCanBase[atom5].init(atom5);
                this.mCanBase[atom5].add(this.mAtomBits, this.mCanRank[atom5]);
                this.mCanBase[atom5].add(1, this.mMol.isSelectedAtom(atom5) ? 1L : 0L);
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if ((this.mMode & 0x200) != 0 && this.mMol.isFragment()) {
            this.canBreakFreeValenceAtomTies();
        }
    }

    private void canBreakFreeValenceAtomTies() {
        while (true) {
            boolean[] isFreeValenceRank = new boolean[this.mNoOfRanks + 1];
            int highestSharedFreeValenceRank = -1;
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (this.mMol.getLowestFreeValence(atom) == 0) continue;
                if (isFreeValenceRank[this.mCanRank[atom]] && highestSharedFreeValenceRank < this.mCanRank[atom]) {
                    highestSharedFreeValenceRank = this.mCanRank[atom];
                }
                isFreeValenceRank[this.mCanRank[atom]] = true;
            }
            if (highestSharedFreeValenceRank == -1) break;
            int increment = 0;
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                int value = 0;
                if (this.mCanRank[atom] == highestSharedFreeValenceRank) {
                    value = ++increment;
                }
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
                this.mCanBase[atom].add(8, value);
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
    }

    private void canRemoveOverspecifiedESRGroups() {
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mIsStereoCenter[atom] && this.mTHParity[atom] != 3) continue;
            this.mTHESRType[atom] = 0;
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondType(bond) == 1 && this.mEZParity[bond] != 0 && this.mEZParity[bond] != 3) continue;
            this.mEZESRType[bond] = 0;
        }
    }

    private void canRecursivelyFindAllParities() {
        this.mIsOddParityRound = true;
        boolean paritiesFound = this.canFindParities(false);
        int parityInfoBits = 9;
        while (this.mNoOfRanks < this.mMol.getAtoms() && paritiesFound) {
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
                int thParityInfo = this.mTHParity[atom] << 7;
                if ((this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2) && this.mTHESRType[atom] != 0) {
                    thParityInfo |= this.mTHESRType[atom] << 5;
                    thParityInfo |= this.mTHESRGroup[atom];
                }
                this.mCanBase[atom].add(18, thParityInfo << 9);
            }
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                int ezParityInfo = this.mEZParity[bond] << 7;
                if ((this.mEZParity[bond] == 1 || this.mEZParity[bond] == 2) && this.mMol.getBondType(bond) == 1 && this.mEZESRType[bond] != 0) {
                    ezParityInfo |= this.mEZESRType[bond] << 5;
                    ezParityInfo |= this.mEZESRGroup[bond];
                }
                this.mCanBase[this.mMol.getBondAtom(0, bond)].add(ezParityInfo);
                this.mCanBase[this.mMol.getBondAtom(1, bond)].add(ezParityInfo);
            }
            int newNoOfRanks = this.canPerformRanking();
            if (this.mNoOfRanks == newNoOfRanks) break;
            this.mNoOfRanks = newNoOfRanks;
            paritiesFound = this.canFindParities(false);
        }
    }

    private void canRecursivelyFindCIPParities() {
        this.mIsOddParityRound = true;
        this.mTHCIPParity = new byte[this.mMol.getAtoms()];
        this.mEZCIPParity = new byte[this.mMol.getBonds()];
        boolean paritiesFound = this.canFindParities(true);
        while (this.mNoOfRanks < this.mMol.getAtoms() && paritiesFound) {
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits + 4, this.mCanRank[atom] << 4 | this.mTHParity[atom] << 2);
            }
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                this.mCanBase[this.mMol.getBondAtom(0, bond)].add(this.mEZParity[bond]);
                this.mCanBase[this.mMol.getBondAtom(1, bond)].add(this.mEZParity[bond]);
            }
            int newNoOfRanks = this.canPerformRanking();
            if (this.mNoOfRanks == newNoOfRanks) break;
            this.mNoOfRanks = newNoOfRanks;
            paritiesFound = this.canFindParities(true);
        }
    }

    private void canRecursivelyFindCanonizedParities() {
        this.mIsOddParityRound = true;
        int[][][] esrGroupMember = this.compileESRGroupMembers();
        if (this.mMesoHelper != null && this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank)) {
            esrGroupMember = this.compileESRGroupMembers();
        }
        if (this.canFindParities(false)) {
            this.canNormalizeGroupParities();
        }
        boolean newStereoInfoAvailable = true;
        while (this.mNoOfRanks < this.mMol.getAtoms() && newStereoInfoAvailable) {
            int[][] groupRank = this.canGetESRGroupRank(esrGroupMember);
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                this.mCanBase[atom].init(atom);
                this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
                this.mCanBase[atom].add(20, 0L);
                if (!this.mTHESRTypeNeedsNormalization[atom] && this.mTHESRType[atom] != 0) {
                    this.mCanBase[atom].add((this.mTHESRType[atom] << 18) + (groupRank[this.mTHESRType[atom] == 1 ? 0 : 1][this.mTHESRGroup[atom]] << 8));
                }
                int parity = this.mTHParity[atom];
                if (this.mTHParityIsMesoInverted[atom]) {
                    if (parity == 1) {
                        parity = 2;
                    } else if (parity == 2) {
                        parity = 1;
                    }
                }
                this.mCanBase[atom].add(parity << 4);
            }
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                this.mCanBase[this.mMol.getBondAtom(0, bond)].add(this.mEZParity[bond]);
                this.mCanBase[this.mMol.getBondAtom(1, bond)].add(this.mEZParity[bond]);
            }
            int newNoOfRanks = this.canPerformRanking();
            if (this.mNoOfRanks == newNoOfRanks) break;
            this.mNoOfRanks = newNoOfRanks;
            newStereoInfoAvailable = false;
            if (this.mMesoHelper != null && this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank)) {
                newStereoInfoAvailable = true;
                esrGroupMember = this.compileESRGroupMembers();
            }
            if (!this.canFindParities(false)) continue;
            newStereoInfoAvailable = true;
            this.canNormalizeGroupParities();
        }
    }

    private int[][][] compileESRGroupMembers() {
        int[][][] esrGroupMember = new int[2][32][];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (!this.mIsStereoCenter[atom]) continue;
            if (this.mTHESRType[atom] == 1) {
                esrGroupMember[0][this.mTHESRGroup[atom]] = CanonizerMesoHelper.addToIntArray(esrGroupMember[0][this.mTHESRGroup[atom]], atom);
                continue;
            }
            if (this.mTHESRType[atom] != 2) continue;
            esrGroupMember[1][this.mTHESRGroup[atom]] = CanonizerMesoHelper.addToIntArray(esrGroupMember[0][this.mTHESRGroup[atom]], atom);
        }
        return esrGroupMember;
    }

    private boolean canNormalizeGroupParities() {
        boolean groupNormalized = false;
        for (int i = 0; i < this.mTHParityNormalizationGroupList.size(); ++i) {
            int[] groupAtom = this.mTHParityNormalizationGroupList.get(i);
            boolean allParitiesDetermined = true;
            int maxRank = -1;
            boolean invertParities = false;
            for (int j = 0; j < groupAtom.length; ++j) {
                int atom = groupAtom[j];
                if (this.mTHParity[atom] == 0) {
                    allParitiesDetermined = false;
                    break;
                }
                if (this.mTHParity[atom] == 3) continue;
                boolean isUniqueRank = true;
                for (int k = 0; k < groupAtom.length; ++k) {
                    if (k == j || this.mCanRank[atom] != this.mCanRank[groupAtom[k]]) continue;
                    isUniqueRank = false;
                    break;
                }
                if (!isUniqueRank || maxRank >= this.mCanRank[atom]) continue;
                maxRank = this.mCanRank[atom];
                invertParities = this.mTHParity[atom] == 1;
            }
            if (!allParitiesDetermined || maxRank == -1) continue;
            for (int atom : groupAtom) {
                if (this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2) {
                    this.mTHParityIsMesoInverted[atom] = invertParities;
                }
                this.mTHParityNeedsNormalization[atom] = false;
            }
            this.mTHParityNormalizationGroupList.remove(groupAtom);
            groupNormalized = true;
            --i;
        }
        return groupNormalized;
    }

    private void canMarkESRGroupsForParityNormalization() {
        int count = 0;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHESRType[atom] == 0 || this.mTHESRType[atom] == 2 && (this.mMode & 0x100) != 0) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        int[] parity = new int[count];
        count = 0;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHESRType[atom] == 0 || this.mTHESRType[atom] == 2 && (this.mMode & 0x100) != 0) continue;
            parity[count] = this.mTHESRType[atom] << 29 | this.mTHESRGroup[atom] << 24 | this.mCanRank[atom] << 12 | atom;
            ++count;
        }
        Arrays.sort(parity);
        int groupBase = 0;
        int nextGroupBase = 0;
        int groupID = parity[0] & 0xFF000000;
        while (true) {
            if (++nextGroupBase != parity.length && groupID == (parity[nextGroupBase] & 0xFF000000)) {
                continue;
            }
            int[] atomList = new int[nextGroupBase - groupBase];
            for (int i = groupBase; i < nextGroupBase; ++i) {
                int atom;
                atomList[i - groupBase] = atom = parity[i] & 0xFFF;
                this.mTHParityNeedsNormalization[atom] = true;
            }
            this.mTHParityNormalizationGroupList.add(atomList);
            if (nextGroupBase == parity.length) break;
            groupID = parity[nextGroupBase] & 0xFF000000;
            groupBase = nextGroupBase;
        }
    }

    private int[][] canGetESRGroupRank(int[][][] groupMember) {
        int[][] groupRank = new int[2][32];
        for (int groupTypeIndex = 0; groupTypeIndex < 2; ++groupTypeIndex) {
            int[][] atomRank = new int[32][];
            int rankCount = 0;
            for (int group = 0; group < 32; ++group) {
                if (groupMember[groupTypeIndex][group] == null) continue;
                int memberCount = groupMember[groupTypeIndex][group].length;
                atomRank[group] = new int[memberCount];
                for (int i = 0; i < memberCount; ++i) {
                    atomRank[group][i] = this.mCanRank[groupMember[groupTypeIndex][group][i]];
                }
                Arrays.sort(atomRank[group]);
                ++rankCount;
            }
            int rank = rankCount;
            while (rank > 0) {
                int maxGroup = 0;
                int[] maxAtomRank = null;
                block4: for (int group = 0; group < 32; ++group) {
                    if (atomRank[group] == null) continue;
                    if (maxAtomRank == null || maxAtomRank.length < atomRank[group].length) {
                        maxAtomRank = atomRank[group];
                        maxGroup = group;
                        continue;
                    }
                    if (maxAtomRank.length != atomRank[group].length) continue;
                    for (int i = maxAtomRank.length - 1; i >= 0; --i) {
                        if (maxAtomRank[i] >= atomRank[group][i]) continue;
                        maxAtomRank = atomRank[group];
                        maxGroup = group;
                        continue block4;
                    }
                }
                groupRank[groupTypeIndex][maxGroup] = rank--;
                atomRank[maxGroup] = null;
            }
        }
        return groupRank;
    }

    private boolean canFindParities(boolean doCIP) {
        boolean ezFound = false;
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (!this.canCalcEZParity(bond, false)) continue;
            this.mEZParityRoundIsOdd[bond] = this.mIsOddParityRound;
            if (doCIP) {
                this.cipCalcEZParity(bond);
            }
            ezFound = true;
        }
        boolean thFound = false;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (!this.canCalcTHParity(atom, false)) continue;
            this.mTHParityRoundIsOdd[atom] = this.mIsOddParityRound;
            if (doCIP) {
                this.cipCalcTHParity(atom);
            }
            thFound = true;
        }
        if (thFound) {
            this.mIsOddParityRound = !this.mIsOddParityRound;
        }
        return ezFound || thFound;
    }

    private void determineChirality(int[] canRankWithoutStereo) {
        byte group;
        int stereoCenters = 0;
        int stereoCentersUnknown = 0;
        int stereoCentersTypeAbs = 0;
        int stereoCentersTypeAbsInMesoFragment = 0;
        int stereoCentersTypeAndGroup0 = 0;
        int stereoCentersTypeOrGroup0 = 0;
        int typeAndGroups = 0;
        boolean typeAndInMesoFragmentFound = false;
        boolean[] andGroupUsed = new boolean[32];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 0) continue;
            ++stereoCenters;
            if (this.mTHParity[atom] == 3) {
                ++stereoCentersUnknown;
                continue;
            }
            if (this.mTHESRType[atom] == 0) {
                ++stereoCentersTypeAbs;
                if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(atom)) continue;
                ++stereoCentersTypeAbsInMesoFragment;
                continue;
            }
            if (this.mTHESRType[atom] == 2) {
                if (this.mTHESRGroup[atom] != 0) continue;
                ++stereoCentersTypeOrGroup0;
                continue;
            }
            if (this.mTHESRType[atom] != 1) continue;
            group = this.mTHESRGroup[atom];
            if (!andGroupUsed[group]) {
                ++typeAndGroups;
                andGroupUsed[group] = true;
            }
            if (this.mTHESRGroup[atom] == 0) {
                ++stereoCentersTypeAndGroup0;
            }
            if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(atom)) continue;
            typeAndInMesoFragmentFound = true;
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mEZParity[bond] == 0 || this.mMol.getBondType(bond) != 1) continue;
            ++stereoCenters;
            if (this.mEZParity[bond] == 3) {
                ++stereoCentersUnknown;
                continue;
            }
            if (this.mEZESRType[bond] == 0) {
                ++stereoCentersTypeAbs;
                if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(0, bond)) || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(1, bond))) continue;
                ++stereoCentersTypeAbsInMesoFragment;
                continue;
            }
            if (this.mEZESRType[bond] == 2) {
                if (this.mEZESRGroup[bond] != 0) continue;
                ++stereoCentersTypeOrGroup0;
                continue;
            }
            if (this.mEZESRType[bond] != 1) continue;
            group = this.mEZESRGroup[bond];
            if (!andGroupUsed[group]) {
                ++typeAndGroups;
                andGroupUsed[group] = true;
            }
            if (this.mEZESRGroup[bond] == 0) {
                ++stereoCentersTypeAndGroup0;
            }
            if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(0, bond)) || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(1, bond))) continue;
            typeAndInMesoFragmentFound = true;
        }
        if (stereoCenters == 0) {
            this.mMol.setChirality(65536);
            return;
        }
        if (stereoCentersUnknown != 0) {
            this.mMol.setChirality(0);
            return;
        }
        if (this.mIsMeso) {
            this.mMol.setChirality(131072 + (1 << typeAndGroups));
            return;
        }
        if (stereoCentersTypeAndGroup0 + stereoCentersTypeAbsInMesoFragment == stereoCenters && !typeAndInMesoFragmentFound) {
            this.mMol.setChirality(196608);
        } else if (stereoCentersTypeAbs == stereoCenters) {
            this.mMol.setChirality(262144);
        } else if (stereoCentersTypeOrGroup0 == stereoCenters) {
            this.mMol.setChirality(327680);
        } else if (stereoCentersTypeAbs == stereoCenters - 1 && stereoCentersTypeAndGroup0 == 1) {
            this.mMol.setChirality(393216);
        } else {
            this.mMol.setChirality(458752 + (1 << typeAndGroups));
        }
    }

    private boolean canFindPseudoParities() {
        boolean pseudoParity1Or2Found;
        block31: {
            int anyPseudoParityCount;
            boolean[] isFreshPseudoParityBond;
            boolean[] isFreshPseudoParityAtom;
            block32: {
                int bond;
                int atom;
                isFreshPseudoParityAtom = new boolean[this.mMol.getAtoms()];
                isFreshPseudoParityBond = new boolean[this.mMol.getBonds()];
                anyPseudoParityCount = 0;
                pseudoParity1Or2Found = false;
                if ((this.mMode & 0x80) != 0) {
                    this.mPseudoTHGroup = new int[this.mMol.getAtoms()];
                    this.mPseudoEZGroup = new int[this.mMol.getBonds()];
                }
                for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    if (!this.mProTHAtomsInSameFragment[atom] || this.mTHParityIsPseudo[atom] || !this.canCalcTHParity(atom, false)) continue;
                    this.mTHParityIsPseudo[atom] = true;
                    isFreshPseudoParityAtom[atom] = true;
                    ++anyPseudoParityCount;
                }
                for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
                    if (!this.mProEZAtomsInSameFragment[bond] || this.mEZParityIsPseudo[bond] || !this.canCalcEZParity(bond, false)) continue;
                    this.mEZParityIsPseudo[bond] = true;
                    isFreshPseudoParityBond[bond] = true;
                    ++anyPseudoParityCount;
                }
                if (anyPseudoParityCount != true) break block32;
                for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    if (!isFreshPseudoParityAtom[atom]) continue;
                    this.mTHParity[atom] = 0;
                    break;
                }
                for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
                    if (!isFreshPseudoParityBond[bond]) continue;
                    this.mEZParity[bond] = 0;
                    break block31;
                }
                break block31;
            }
            if (anyPseudoParityCount <= true) break block31;
            this.canEnsureFragments();
            this.mNoOfPseudoGroups = 0;
            for (CanonizerFragment f : this.mFragmentList) {
                int i;
                int i2;
                int pseudoParitiesInGroup = 0;
                int pseudoParity1Or2InGroup = 0;
                int highRankingTHAtom = 0;
                int highRankingEZBond = 0;
                int highTHAtomRank = -1;
                int highEZBondRank = -1;
                for (i2 = 0; i2 < f.atom.length; ++i2) {
                    if (!isFreshPseudoParityAtom[f.atom[i2]]) continue;
                    ++pseudoParitiesInGroup;
                    if (this.mTHParity[f.atom[i2]] != 1 && this.mTHParity[f.atom[i2]] != 2) continue;
                    ++pseudoParity1Or2InGroup;
                    pseudoParity1Or2Found = true;
                    if (highTHAtomRank >= this.mCanRank[f.atom[i2]]) continue;
                    highTHAtomRank = this.mCanRank[f.atom[i2]];
                    highRankingTHAtom = f.atom[i2];
                }
                for (i2 = 0; i2 < f.bond.length; ++i2) {
                    int rank2;
                    int higherRank;
                    if (!isFreshPseudoParityBond[f.bond[i2]]) continue;
                    ++pseudoParitiesInGroup;
                    int rank1 = this.mCanRank[this.mMol.getBondAtom(0, f.bond[i2])];
                    int n = higherRank = rank1 > (rank2 = this.mCanRank[this.mMol.getBondAtom(1, f.bond[i2])]) ? (rank1 << 16) + rank2 : (rank2 << 16) + rank1;
                    if (this.mEZParity[f.bond[i2]] != 1 && this.mEZParity[f.bond[i2]] != 2) continue;
                    ++pseudoParity1Or2InGroup;
                    pseudoParity1Or2Found = true;
                    if (highEZBondRank >= higherRank) continue;
                    highEZBondRank = higherRank;
                    highRankingEZBond = f.bond[i2];
                }
                if (pseudoParitiesInGroup == 0) continue;
                if (pseudoParitiesInGroup == 1) {
                    for (i2 = 0; i2 < f.atom.length; ++i2) {
                        if (!isFreshPseudoParityAtom[f.atom[i2]]) continue;
                        this.mTHParity[f.atom[i2]] = 0;
                    }
                    for (i2 = 0; i2 < f.bond.length; ++i2) {
                        if (!isFreshPseudoParityBond[f.bond[i2]]) continue;
                        this.mEZParity[f.bond[i2]] = 0;
                    }
                    continue;
                }
                if (pseudoParity1Or2InGroup == 1) {
                    for (i2 = 0; i2 < f.atom.length; ++i2) {
                        if (!isFreshPseudoParityAtom[f.atom[i2]]) continue;
                        this.mTHParity[f.atom[i2]] = 3;
                    }
                    for (i2 = 0; i2 < f.bond.length; ++i2) {
                        if (!isFreshPseudoParityBond[f.bond[i2]]) continue;
                        this.mEZParity[f.bond[i2]] = 3;
                    }
                    continue;
                }
                if ((this.mMode & 0x80) != 0) {
                    ++this.mNoOfPseudoGroups;
                    for (i2 = 0; i2 < f.atom.length; ++i2) {
                        if (!isFreshPseudoParityAtom[f.atom[i2]]) continue;
                        this.mPseudoTHGroup[f.atom[i2]] = this.mNoOfPseudoGroups;
                    }
                    for (i2 = 0; i2 < f.bond.length; ++i2) {
                        if (!isFreshPseudoParityBond[f.bond[i2]]) continue;
                        this.mPseudoEZGroup[f.bond[i2]] = this.mNoOfPseudoGroups;
                    }
                }
                boolean invertFragmentsStereoFeatures = false;
                if (highTHAtomRank != -1) {
                    if (this.mTHParity[highRankingTHAtom] == 2) {
                        invertFragmentsStereoFeatures = true;
                    }
                } else if (this.mEZParity[highRankingEZBond] == 2) {
                    invertFragmentsStereoFeatures = true;
                }
                if (!invertFragmentsStereoFeatures) continue;
                block21: for (i = 0; i < f.atom.length; ++i) {
                    if (!isFreshPseudoParityAtom[f.atom[i]]) continue;
                    switch (this.mTHParity[f.atom[i]]) {
                        case 1: {
                            this.mTHParity[f.atom[i]] = 2;
                            continue block21;
                        }
                        case 2: {
                            this.mTHParity[f.atom[i]] = 1;
                        }
                    }
                }
                block22: for (i = 0; i < f.bond.length; ++i) {
                    if (!isFreshPseudoParityBond[f.bond[i]]) continue;
                    switch (this.mEZParity[f.bond[i]]) {
                        case 1: {
                            this.mEZParity[f.bond[i]] = 2;
                            continue block22;
                        }
                        case 2: {
                            this.mEZParity[f.bond[i]] = 1;
                        }
                    }
                }
            }
        }
        return pseudoParity1Or2Found;
    }

    private void canEnsureFragments() {
        if (this.mFragmentList != null) {
            return;
        }
        this.mFragmentList = new ArrayList();
        int fragmentCount = 0;
        int[] fragmentNo = new int[this.mMol.getAtoms()];
        int[] fragmentAtom = new int[this.mMol.getAtoms()];
        int[] fragmentBond = new int[this.mMol.getBonds()];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (fragmentNo[atom] != 0 || !this.mMol.isRingAtom(atom) && this.mMol.getAtomPi(atom) != 1) continue;
            fragmentAtom[0] = atom;
            int fragmentAtoms = 1;
            int fragmentBonds = 0;
            fragmentNo[atom] = ++fragmentCount;
            boolean[] bondHandled = new boolean[this.mMol.getBonds()];
            for (int current = 0; current < fragmentAtoms; ++current) {
                for (int i = 0; i < this.mMol.getConnAtoms(fragmentAtom[current]); ++i) {
                    int connBond = this.mMol.getConnBond(fragmentAtom[current], i);
                    if (!this.mMol.isRingBond(connBond) && this.mMol.getBondOrder(connBond) != 2 && !this.mMol.isBINAPChiralityBond(connBond)) continue;
                    int connAtom = this.mMol.getConnAtom(fragmentAtom[current], i);
                    if (!bondHandled[connBond]) {
                        fragmentBond[fragmentBonds++] = connBond;
                        bondHandled[connBond] = true;
                    }
                    if (fragmentNo[connAtom] != 0) continue;
                    fragmentAtom[fragmentAtoms++] = connAtom;
                    fragmentNo[connAtom] = fragmentCount;
                }
            }
            this.mFragmentList.add(new CanonizerFragment(fragmentAtom, fragmentAtoms, fragmentBond, fragmentBonds));
        }
    }

    private int canPerformRanking() {
        int oldNoOfRanks;
        int newNoOfRanks = this.canConsolidate();
        do {
            oldNoOfRanks = newNoOfRanks;
            this.canCalcNextBaseValues();
        } while (oldNoOfRanks != (newNoOfRanks = this.canConsolidate()));
        return newNoOfRanks;
    }

    private void canCalcNextBaseValues() {
        int[] connRank = new int[this.mMaxConnAtoms];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            int i;
            int neighbours = this.mMol.getConnAtoms(atom) + this.mMol.getMetalBondedConnAtoms(atom);
            int neighbour = 0;
            for (i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(atom); ++i) {
                int j;
                if (i >= this.mMol.getConnAtoms(atom) && i < this.mMol.getAllConnAtoms(atom)) continue;
                int rank = 2 * this.mCanRank[this.mMol.getConnAtom(atom, i)];
                int connBond = this.mMol.getConnBond(atom, i);
                if (this.mMol.getBondOrder(connBond) == 2 && !this.mMol.isAromaticBond(connBond)) {
                    ++rank;
                }
                for (j = 0; j < neighbour && rank >= connRank[j]; ++j) {
                }
                for (int k = neighbour; k > j; --k) {
                    connRank[k] = connRank[k - 1];
                }
                connRank[j] = rank;
                ++neighbour;
            }
            this.mCanBase[atom].init(atom);
            this.mCanBase[atom].add(this.mAtomBits, this.mCanRank[atom]);
            for (i = neighbours; i < this.mMaxConnAtoms; ++i) {
                this.mCanBase[atom].add(this.mAtomBits + 1, 0L);
            }
            for (i = 0; i < neighbours; ++i) {
                this.mCanBase[atom].add(this.mAtomBits + 1, connRank[i]);
            }
        }
    }

    private int canConsolidate() {
        int canRank = 0;
        Arrays.sort(this.mCanBase);
        for (int i = 0; i < this.mCanBase.length; ++i) {
            if (i == 0 || this.mCanBase[i].compareTo(this.mCanBase[i - 1]) != 0) {
                // empty if block
            }
            this.mCanRank[this.mCanBase[i].getAtom()] = ++canRank;
        }
        return canRank;
    }

    private boolean canCalcTHParity(int atom, boolean calcProParity) {
        byte atomTHParity;
        if (this.mTHParity[atom] != 0) {
            return false;
        }
        if (this.mMol.getAtomicNo(atom) != 5 && this.mMol.getAtomicNo(atom) != 6 && this.mMol.getAtomicNo(atom) != 7 && this.mMol.getAtomicNo(atom) != 14 && this.mMol.getAtomicNo(atom) != 15 && this.mMol.getAtomicNo(atom) != 16) {
            return false;
        }
        if (this.mMol.getAtomPi(atom) != 0) {
            if (this.mMol.isCentralAlleneAtom(atom)) {
                return this.canCalcAlleneParity(atom, calcProParity);
            }
            if (this.mMol.getAtomicNo(atom) != 15 && this.mMol.getAtomicNo(atom) != 16) {
                return false;
            }
        }
        if (this.mMol.getConnAtoms(atom) < 3 || this.mMol.getAllConnAtoms(atom) > 4) {
            return false;
        }
        if (this.mMol.getAtomCharge(atom) > 0 && this.mMol.getAtomicNo(atom) == 6) {
            return false;
        }
        if (this.mMol.getAtomicNo(atom) == 5 && this.mMol.getAllConnAtoms(atom) != 4) {
            return false;
        }
        if (this.mMol.getAtomicNo(atom) == 7 && !this.mNitrogenQualifiesForParity[atom]) {
            return false;
        }
        int[] remappedConn = new int[4];
        int[] remappedRank = new int[4];
        boolean[] neighbourUsed = new boolean[4];
        for (int i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
            int highestRank = -1;
            int highestConn = 0;
            for (int j = 0; j < this.mMol.getAllConnAtoms(atom); ++j) {
                if (neighbourUsed[j] || highestRank >= this.mCanRank[this.mMol.getConnAtom(atom, j)]) continue;
                highestRank = this.mCanRank[this.mMol.getConnAtom(atom, j)];
                highestConn = j;
            }
            remappedConn[i] = highestConn;
            remappedRank[i] = highestRank;
            neighbourUsed[highestConn] = true;
        }
        if (this.mMol.getAllConnAtoms(atom) == 4 && remappedRank[0] == remappedRank[1] && remappedRank[2] == remappedRank[3]) {
            return false;
        }
        if (this.mMol.getAllConnAtoms(atom) == 4 && (remappedRank[0] == remappedRank[2] || remappedRank[1] == remappedRank[3])) {
            return false;
        }
        if (this.mMol.getAllConnAtoms(atom) == 3 && remappedRank[0] == remappedRank[2]) {
            return false;
        }
        int proTHAtom1 = 0;
        int proTHAtom2 = 0;
        boolean proTHAtomsFound = false;
        for (int i = 1; i < this.mMol.getAllConnAtoms(atom); ++i) {
            if (remappedRank[i - 1] != remappedRank[i]) continue;
            if (!calcProParity || remappedRank[i] == 0) {
                return false;
            }
            proTHAtom1 = this.mMol.getConnAtom(atom, remappedConn[i - 1]);
            proTHAtom2 = this.mMol.getConnAtom(atom, remappedConn[i]);
            if (this.mMol.isRingBond(this.mMol.getConnBond(atom, remappedConn[i]))) {
                this.mProTHAtomsInSameFragment[atom] = true;
            }
            proTHAtomsFound = true;
        }
        if (calcProParity && !proTHAtomsFound) {
            return false;
        }
        byte by = atomTHParity = this.mZCoordinatesAvailable ? this.canCalcTHParity3D(atom, remappedConn) : this.canCalcTHParity2D(atom, remappedConn);
        if (!calcProParity) {
            this.mTHParity[atom] = atomTHParity;
        } else if (this.mStereoCentersFound && (this.mMode & 2) != 0 || !this.mStereoCentersFound && (this.mMode & 4) != 0) {
            if (atomTHParity == 1) {
                this.mCanBase[proTHAtom1].add(1024L);
                this.mCanBase[proTHAtom2].add(256L);
            } else if (atomTHParity == 2) {
                this.mCanBase[proTHAtom1].add(256L);
                this.mCanBase[proTHAtom2].add(1024L);
            }
        }
        return true;
    }

    private byte canCalcTHParity2D(int atom, int[] remappedConn) {
        int i;
        int[][] up_down = new int[][]{{2, 1, 2, 1}, {1, 2, 2, 1}, {1, 1, 2, 2}, {2, 1, 1, 2}, {2, 2, 1, 1}, {1, 2, 1, 2}};
        double[] angle = new double[this.mMol.getAllConnAtoms(atom)];
        for (int i2 = 0; i2 < this.mMol.getAllConnAtoms(atom); ++i2) {
            angle[i2] = this.mMol.getBondAngle(this.mMol.getConnAtom(atom, remappedConn[i2]), atom);
        }
        byte parity = (byte)this.mMol.getFisherProjectionParity(atom, remappedConn, angle, null);
        if (parity != 3) {
            return parity;
        }
        int stereoBond = 0;
        int stereoType = 0;
        for (i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
            int bnd = this.mMol.getConnBond(atom, remappedConn[i]);
            if (this.mMol.getBondAtom(0, bnd) != atom) continue;
            if (this.mMol.getBondType(bnd) == 9) {
                if (stereoType != 0) {
                    this.mMol.setStereoProblem(atom);
                }
                stereoBond = i;
                stereoType = 1;
            }
            if (this.mMol.getBondType(bnd) != 17) continue;
            if (stereoType != 0) {
                this.mMol.setStereoProblem(atom);
            }
            stereoBond = i;
            stereoType = 2;
        }
        if (stereoType == 0) {
            return 3;
        }
        for (i = 1; i < this.mMol.getAllConnAtoms(atom); ++i) {
            if (!(angle[i] < angle[0])) continue;
            int n = i;
            angle[n] = angle[n] + Math.PI * 2;
        }
        if (this.mMol.getAllConnAtoms(atom) == 3) {
            switch (stereoBond) {
                case 0: {
                    if (!(angle[1] < angle[2] && angle[2] - angle[1] < Math.PI) && (!(angle[1] > angle[2]) || !(angle[1] - angle[2] > Math.PI))) break;
                    stereoType = 3 - stereoType;
                    break;
                }
                case 1: {
                    if (!(angle[2] - angle[0] > Math.PI)) break;
                    stereoType = 3 - stereoType;
                    break;
                }
                case 2: {
                    if (!(angle[1] - angle[0] < Math.PI)) break;
                    stereoType = 3 - stereoType;
                }
            }
            return stereoType == 1 ? (byte)2 : 1;
        }
        int order = 0;
        if (angle[1] <= angle[2] && angle[2] <= angle[3]) {
            order = 0;
        } else if (angle[1] <= angle[3] && angle[3] <= angle[2]) {
            order = 1;
        } else if (angle[2] <= angle[1] && angle[1] <= angle[3]) {
            order = 2;
        } else if (angle[2] <= angle[3] && angle[3] <= angle[1]) {
            order = 3;
        } else if (angle[3] <= angle[1] && angle[1] <= angle[2]) {
            order = 4;
        } else if (angle[3] <= angle[2] && angle[2] <= angle[1]) {
            order = 5;
        }
        return up_down[order][stereoBond] == stereoType ? (byte)2 : 1;
    }

    private byte canCalcTHParity3D(int atom, int[] remappedConn) {
        int[] atomList = new int[4];
        for (int i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
            atomList[i] = this.mMol.getConnAtom(atom, remappedConn[i]);
        }
        if (this.mMol.getAllConnAtoms(atom) == 3) {
            atomList[3] = atom;
        }
        double[][] coords = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            coords[i][0] = this.mMol.getAtomX(atomList[i + 1]) - this.mMol.getAtomX(atomList[0]);
            coords[i][1] = this.mMol.getAtomY(atomList[i + 1]) - this.mMol.getAtomY(atomList[0]);
            coords[i][2] = this.mMol.getAtomZ(atomList[i + 1]) - this.mMol.getAtomZ(atomList[0]);
        }
        double[] n = new double[]{coords[0][1] * coords[1][2] - coords[0][2] * coords[1][1], coords[0][2] * coords[1][0] - coords[0][0] * coords[1][2], coords[0][0] * coords[1][1] - coords[0][1] * coords[1][0]};
        double cosa = (coords[2][0] * n[0] + coords[2][1] * n[1] + coords[2][2] * n[2]) / (Math.sqrt(coords[2][0] * coords[2][0] + coords[2][1] * coords[2][1] + coords[2][2] * coords[2][2]) * Math.sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]));
        return cosa > 0.0 ? (byte)1 : 2;
    }

    private boolean canCalcAlleneParity(int atom, boolean calcProParity) {
        byte alleneParity;
        if (this.mMol.getAtomicNo(atom) != 6 && this.mMol.getAtomicNo(atom) != 7) {
            return false;
        }
        int atom1 = this.mMol.getConnAtom(atom, 0);
        int atom2 = this.mMol.getConnAtom(atom, 1);
        if (this.mMol.getAtomPi(atom1) != 1 || this.mMol.getAtomPi(atom2) != 1) {
            return false;
        }
        if (this.mMol.getConnAtoms(atom1) == 1 || this.mMol.getConnAtoms(atom2) == 1) {
            return false;
        }
        if (this.mMol.getAllConnAtoms(atom1) > 3 || this.mMol.getAllConnAtoms(atom2) > 3) {
            return false;
        }
        EZHalfParity halfParity1 = new EZHalfParity(this.mMol, this.mCanRank, atom, atom1);
        if (halfParity1.mRanksEqual && !calcProParity) {
            return false;
        }
        EZHalfParity halfParity2 = new EZHalfParity(this.mMol, this.mCanRank, atom, atom2);
        if (halfParity2.mRanksEqual && !calcProParity) {
            return false;
        }
        if (halfParity1.mRanksEqual && halfParity2.mRanksEqual) {
            return false;
        }
        if (calcProParity) {
            if (halfParity1.mRanksEqual && halfParity1.mInSameFragment) {
                this.mProTHAtomsInSameFragment[atom] = true;
            }
            if (halfParity2.mRanksEqual && halfParity2.mInSameFragment) {
                this.mProTHAtomsInSameFragment[atom] = true;
            }
        }
        byte by = alleneParity = this.mZCoordinatesAvailable ? this.canCalcAlleneParity3D(halfParity1, halfParity2) : this.canCalcAlleneParity2D(halfParity1, halfParity2);
        if (!calcProParity) {
            this.mTHParity[atom] = alleneParity;
        } else if (this.mStereoCentersFound && (this.mMode & 2) != 0 || !this.mStereoCentersFound && (this.mMode & 4) != 0) {
            if (halfParity1.mRanksEqual) {
                if (alleneParity == 1) {
                    this.mCanBase[halfParity1.mHighConn].add(64L);
                    this.mCanBase[halfParity1.mLowConn].add(16L);
                } else {
                    this.mCanBase[halfParity1.mHighConn].add(16L);
                    this.mCanBase[halfParity1.mLowConn].add(64L);
                }
            }
            if (halfParity2.mRanksEqual) {
                if (alleneParity == 2) {
                    this.mCanBase[halfParity2.mHighConn].add(64L);
                    this.mCanBase[halfParity2.mLowConn].add(16L);
                } else {
                    this.mCanBase[halfParity2.mHighConn].add(16L);
                    this.mCanBase[halfParity2.mLowConn].add(64L);
                }
            }
        }
        return true;
    }

    private byte canCalcAlleneParity2D(EZHalfParity halfParity1, EZHalfParity halfParity2) {
        int hp1 = halfParity1.getValue();
        int hp2 = halfParity2.getValue();
        if (hp1 == -1 || hp2 == -1 || (hp1 + hp2 & 1) == 0) {
            return 3;
        }
        byte alleneParity = 0;
        switch (hp1 + hp2) {
            case 3: 
            case 7: {
                alleneParity = 2;
                break;
            }
            case 5: {
                alleneParity = 1;
            }
        }
        return alleneParity;
    }

    private byte canCalcAlleneParity3D(EZHalfParity halfParity1, EZHalfParity halfParity2) {
        int[] atom = new int[]{halfParity1.mHighConn, halfParity1.mCentralAxialAtom, halfParity2.mCentralAxialAtom, halfParity2.mHighConn};
        double torsion = this.mMol.calculateTorsion(atom);
        if (Math.abs(torsion) < 0.3 || Math.abs(torsion) > 2.8415926535897933) {
            return 3;
        }
        if (torsion < 0.0) {
            return 2;
        }
        return 1;
    }

    private boolean canCalcBINAPParity(int bond, boolean calcProParity) {
        byte axialParity;
        if (!this.mMol.isBINAPChiralityBond(bond)) {
            return false;
        }
        int atom1 = this.mMol.getBondAtom(0, bond);
        int atom2 = this.mMol.getBondAtom(1, bond);
        EZHalfParity halfParity1 = new EZHalfParity(this.mMol, this.mCanRank, atom1, atom2);
        if (halfParity1.mRanksEqual && !calcProParity) {
            return false;
        }
        EZHalfParity halfParity2 = new EZHalfParity(this.mMol, this.mCanRank, atom2, atom1);
        if (halfParity2.mRanksEqual && !calcProParity) {
            return false;
        }
        if (halfParity1.mRanksEqual && halfParity2.mRanksEqual) {
            return false;
        }
        if (calcProParity) {
            if (halfParity1.mRanksEqual) {
                this.mProEZAtomsInSameFragment[bond] = this.hasSecondBINAPBond(atom2);
            }
            if (halfParity2.mRanksEqual) {
                this.mProEZAtomsInSameFragment[bond] = this.hasSecondBINAPBond(atom1);
            }
        }
        byte by = axialParity = this.mZCoordinatesAvailable ? this.canCalcBINAPParity3D(halfParity1, halfParity2) : this.canCalcBINAPParity2D(halfParity1, halfParity2);
        if (!calcProParity) {
            this.mEZParity[bond] = axialParity;
        } else if (this.mStereoCentersFound && (this.mMode & 2) != 0 || !this.mStereoCentersFound && (this.mMode & 4) != 0) {
            if (halfParity1.mRanksEqual) {
                if (axialParity == 2) {
                    this.mCanBase[halfParity1.mHighConn].add(4L);
                    this.mCanBase[halfParity1.mLowConn].add(1L);
                } else {
                    this.mCanBase[halfParity1.mHighConn].add(1L);
                    this.mCanBase[halfParity1.mLowConn].add(4L);
                }
            }
            if (halfParity2.mRanksEqual) {
                if (axialParity == 2) {
                    this.mCanBase[halfParity2.mHighConn].add(4L);
                    this.mCanBase[halfParity2.mLowConn].add(1L);
                } else {
                    this.mCanBase[halfParity2.mHighConn].add(1L);
                    this.mCanBase[halfParity2.mLowConn].add(4L);
                }
            }
        }
        return true;
    }

    private byte canCalcBINAPParity2D(EZHalfParity halfParity1, EZHalfParity halfParity2) {
        int hp1 = halfParity1.getValue();
        int hp2 = halfParity2.getValue();
        if (hp1 == -1 || hp2 == -1 || (hp1 + hp2 & 1) == 0) {
            return 3;
        }
        byte axialParity = 0;
        switch (hp1 + hp2) {
            case 3: 
            case 7: {
                axialParity = 1;
                break;
            }
            case 5: {
                axialParity = 2;
            }
        }
        return axialParity;
    }

    private byte canCalcBINAPParity3D(EZHalfParity halfParity1, EZHalfParity halfParity2) {
        int[] atom = new int[]{halfParity1.mHighConn, halfParity1.mCentralAxialAtom, halfParity2.mCentralAxialAtom, halfParity2.mHighConn};
        double torsion = this.mMol.calculateTorsion(atom);
        if (Math.abs(torsion) < 0.3 || Math.abs(torsion) > 2.8415926535897933) {
            return 3;
        }
        if (torsion < 0.0) {
            return 1;
        }
        return 2;
    }

    private boolean hasSecondBINAPBond(int atom) {
        RingCollection ringSet = this.mMol.getRingSet();
        for (int i = 0; i < ringSet.getSize(); ++i) {
            if (!ringSet.isAromatic(i) || !ringSet.isAtomMember(i, atom)) continue;
            for (int j : ringSet.getRingAtoms(i)) {
                if (j == atom) continue;
                for (int k = 0; k < this.mMol.getConnAtoms(j); ++k) {
                    if (!this.mMol.isBINAPChiralityBond(this.mMol.getConnBond(j, k))) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean canCalcEZParity(int bond, boolean calcProParity) {
        int bondDBParity;
        if (this.mEZParity[bond] != 0) {
            return false;
        }
        if (this.mMol.getBondOrder(bond) == 1) {
            return this.canCalcBINAPParity(bond, calcProParity);
        }
        if (this.mMol.getBondOrder(bond) != 2) {
            return false;
        }
        if (this.mMol.isAromaticBond(bond)) {
            return false;
        }
        int dbAtom1 = this.mMol.getBondAtom(0, bond);
        int dbAtom2 = this.mMol.getBondAtom(1, bond);
        if (this.mMol.getConnAtoms(dbAtom1) == 1 || this.mMol.getConnAtoms(dbAtom2) == 1) {
            return false;
        }
        if (this.mMol.getConnAtoms(dbAtom1) > 3 || this.mMol.getConnAtoms(dbAtom2) > 3) {
            return false;
        }
        if (this.mMol.getAtomPi(dbAtom1) == 2 || this.mMol.getAtomPi(dbAtom2) == 2) {
            return false;
        }
        EZHalfParity halfParity1 = new EZHalfParity(this.mMol, this.mCanRank, dbAtom2, dbAtom1);
        if (halfParity1.mRanksEqual && !calcProParity) {
            return false;
        }
        EZHalfParity halfParity2 = new EZHalfParity(this.mMol, this.mCanRank, dbAtom1, dbAtom2);
        if (halfParity2.mRanksEqual && !calcProParity) {
            return false;
        }
        if (halfParity1.mRanksEqual && halfParity2.mRanksEqual) {
            return false;
        }
        if (calcProParity) {
            if (halfParity1.mRanksEqual && halfParity1.mInSameFragment) {
                this.mProEZAtomsInSameFragment[bond] = true;
            }
            if (halfParity2.mRanksEqual && halfParity2.mInSameFragment) {
                this.mProEZAtomsInSameFragment[bond] = true;
            }
        }
        int n = this.mMol.isBondParityUnknownOrNone(bond) ? 3 : (bondDBParity = this.mZCoordinatesAvailable ? (int)this.canCalcEZParity3D(halfParity1, halfParity2) : (int)this.canCalcEZParity2D(halfParity1, halfParity2));
        if (!calcProParity) {
            this.mEZParity[bond] = bondDBParity;
        } else if ((this.mMode & 2) != 0) {
            if (halfParity1.mRanksEqual) {
                if (bondDBParity == 1) {
                    this.mCanBase[halfParity1.mHighConn].add(4L);
                    this.mCanBase[halfParity1.mLowConn].add(1L);
                } else if (bondDBParity == 2) {
                    this.mCanBase[halfParity1.mHighConn].add(1L);
                    this.mCanBase[halfParity1.mLowConn].add(4L);
                }
            }
            if (halfParity2.mRanksEqual) {
                if (bondDBParity == 1) {
                    this.mCanBase[halfParity2.mHighConn].add(4L);
                    this.mCanBase[halfParity2.mLowConn].add(1L);
                } else if (bondDBParity == 2) {
                    this.mCanBase[halfParity2.mHighConn].add(1L);
                    this.mCanBase[halfParity2.mLowConn].add(4L);
                }
            }
        }
        return true;
    }

    private byte canCalcEZParity2D(EZHalfParity halfParity1, EZHalfParity halfParity2) {
        if (halfParity1.getValue() == -1 || halfParity2.getValue() == -1) {
            return 3;
        }
        if (((halfParity1.getValue() | halfParity2.getValue()) & 1) != 0) {
            return 3;
        }
        return halfParity1.getValue() == halfParity2.getValue() ? (byte)1 : 2;
    }

    private byte canCalcEZParity3D(EZHalfParity halfParity1, EZHalfParity halfParity2) {
        double[] db = new double[]{this.mMol.getAtomX(halfParity2.mCentralAxialAtom) - this.mMol.getAtomX(halfParity1.mCentralAxialAtom), this.mMol.getAtomY(halfParity2.mCentralAxialAtom) - this.mMol.getAtomY(halfParity1.mCentralAxialAtom), this.mMol.getAtomZ(halfParity2.mCentralAxialAtom) - this.mMol.getAtomZ(halfParity1.mCentralAxialAtom)};
        double[] s1 = new double[]{this.mMol.getAtomX(halfParity1.mHighConn) - this.mMol.getAtomX(halfParity1.mCentralAxialAtom), this.mMol.getAtomY(halfParity1.mHighConn) - this.mMol.getAtomY(halfParity1.mCentralAxialAtom), this.mMol.getAtomZ(halfParity1.mHighConn) - this.mMol.getAtomZ(halfParity1.mCentralAxialAtom)};
        double[] s2 = new double[]{this.mMol.getAtomX(halfParity2.mHighConn) - this.mMol.getAtomX(halfParity2.mCentralAxialAtom), this.mMol.getAtomY(halfParity2.mHighConn) - this.mMol.getAtomY(halfParity2.mCentralAxialAtom), this.mMol.getAtomZ(halfParity2.mHighConn) - this.mMol.getAtomZ(halfParity2.mCentralAxialAtom)};
        double[] n1 = new double[]{db[1] * s1[2] - db[2] * s1[1], db[2] * s1[0] - db[0] * s1[2], db[0] * s1[1] - db[1] * s1[0]};
        double[] n2 = new double[]{db[1] * n1[2] - db[2] * n1[1], db[2] * n1[0] - db[0] * n1[2], db[0] * n1[1] - db[1] * n1[0]};
        double cosa = (s1[0] * n2[0] + s1[1] * n2[1] + s1[2] * n2[2]) / (Math.sqrt(s1[0] * s1[0] + s1[1] * s1[1] + s1[2] * s1[2]) * Math.sqrt(n2[0] * n2[0] + n2[1] * n2[1] + n2[2] * n2[2]));
        double cosb = (s2[0] * n2[0] + s2[1] * n2[1] + s2[2] * n2[2]) / (Math.sqrt(s2[0] * s2[0] + s2[1] * s2[1] + s2[2] * s2[2]) * Math.sqrt(n2[0] * n2[0] + n2[1] * n2[1] + n2[2] * n2[2]));
        return cosa < 0.0 ^ cosb < 0.0 ? (byte)1 : 2;
    }

    private void flagStereoProblems() {
        int bond;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 3 && !this.mMol.isAtomConfigurationUnknown(atom)) {
                this.mMol.setStereoProblem(atom);
            }
            if (!(this.mMol.getAtomESRType(atom) != 1 && this.mMol.getAtomESRType(atom) != 2 || this.mIsStereoCenter[atom] && this.mTHParity[atom] != 3)) {
                this.mMol.setStereoProblem(atom);
            }
            if (!this.mMol.isAtomConfigurationUnknown(atom) || this.mTHParity[atom] == 3 || this.isUnknownBINAPBondAtom(atom)) continue;
            this.mMol.setStereoProblem(atom);
        }
        for (bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            if (!this.mMol.isStereoBond(bond) || this.isJustifiedStereoBond(bond)) continue;
            this.mMol.setStereoProblem(this.mMol.getBondAtom(0, bond));
        }
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondOrder(bond) == 2) {
                if (this.mMol.isBondParityUnknownOrNone(bond) && (this.mEZParity[bond] == 1 || this.mEZParity[bond] == 2)) {
                    this.mEZParity[bond] = 3;
                    this.mMol.setBondType(bond, 26);
                }
                if (this.mEZParity[bond] == 3 && !this.mEZParityIsPseudo[bond] && this.mMol.getBondType(bond) != 26) {
                    this.mMol.setStereoProblem(this.mMol.getBondAtom(0, bond));
                    this.mMol.setStereoProblem(this.mMol.getBondAtom(1, bond));
                }
            }
            if (this.mMol.getBondType(bond) == 1 && this.mEZParity[bond] == 3 && !this.mMol.isAtomConfigurationUnknown(this.mMol.getBondAtom(0, bond)) && !this.mMol.isAtomConfigurationUnknown(this.mMol.getBondAtom(1, bond))) {
                this.mMol.setStereoProblem(this.mMol.getBondAtom(0, bond));
                this.mMol.setStereoProblem(this.mMol.getBondAtom(1, bond));
            }
            if (this.mMol.getBondESRType(bond) != 1 && this.mMol.getBondESRType(bond) != 2 || this.mMol.getBondType(bond) == 1 && (this.mEZParity[bond] == 1 || this.mEZParity[bond] == 2)) continue;
            this.mMol.setStereoProblem(this.mMol.getBondAtom(0, bond));
            this.mMol.setStereoProblem(this.mMol.getBondAtom(1, bond));
        }
    }

    private boolean isUnknownBINAPBondAtom(int atom) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (this.mEZParity[this.mMol.getConnBond(atom, i)] != 3 || this.mMol.getConnBondOrder(atom, i) != 1) continue;
            return true;
        }
        return false;
    }

    private boolean isJustifiedStereoBond(int bond) {
        int atom = this.mMol.getBondAtom(0, bond);
        if (atom >= this.mMol.getAtoms()) {
            return false;
        }
        if (this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2) {
            return true;
        }
        if (this.mTHParity[atom] == 3) {
            return false;
        }
        int binapBond = this.mMol.findBINAPChiralityBond(atom);
        if (binapBond != -1) {
            return this.mEZParity[binapBond] == 1 || this.mEZParity[binapBond] == 2;
        }
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (this.mMol.getConnBondOrder(atom, i) != 2 || this.mTHParity[this.mMol.getConnAtom(atom, i)] != 1 && this.mTHParity[this.mMol.getConnAtom(atom, i)] != 2) continue;
            return true;
        }
        return false;
    }

    private void generateGraph() {
        if (this.mMol.getAtoms() == 0) {
            return;
        }
        if (this.mGraphGenerated) {
            return;
        }
        this.mGraphRings = 0;
        int startAtom = 0;
        for (int atom = 1; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mCanRank[atom] <= this.mCanRank[startAtom]) continue;
            startAtom = atom;
        }
        boolean[] atomHandled = new boolean[this.mMol.getAtoms()];
        boolean[] bondHandled = new boolean[this.mMol.getBonds()];
        this.mGraphIndex = new int[this.mMol.getAtoms()];
        this.mGraphAtom = new int[this.mMol.getAtoms()];
        this.mGraphFrom = new int[this.mMol.getAtoms()];
        this.mGraphBond = new int[this.mMol.getBonds()];
        this.mGraphAtom[0] = startAtom;
        this.mGraphIndex[startAtom] = 0;
        atomHandled[startAtom] = true;
        int atomsWithoutParents = 1;
        int firstUnhandled = 0;
        int firstUnused = 1;
        int graphBonds = 0;
        while (firstUnhandled < this.mMol.getAtoms()) {
            if (firstUnhandled < firstUnused) {
                while (true) {
                    int highestRankingConnAtom = 0;
                    int highestRankingConnBond = 0;
                    int highestRank = -1;
                    int atom = this.mGraphAtom[firstUnhandled];
                    for (int i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(atom); ++i) {
                        int connAtom;
                        if (i >= this.mMol.getConnAtoms(atom) && i < this.mMol.getAllConnAtoms(atom) || atomHandled[connAtom = this.mMol.getConnAtom(atom, i)] || this.mCanRank[connAtom] <= highestRank) continue;
                        highestRankingConnAtom = connAtom;
                        highestRankingConnBond = this.mMol.getConnBond(atom, i);
                        highestRank = this.mCanRank[connAtom];
                    }
                    if (highestRank == -1) break;
                    this.mGraphIndex[highestRankingConnAtom] = firstUnused;
                    this.mGraphFrom[firstUnused] = firstUnhandled;
                    this.mGraphAtom[firstUnused++] = highestRankingConnAtom;
                    this.mGraphBond[graphBonds++] = highestRankingConnBond;
                    atomHandled[highestRankingConnAtom] = true;
                    bondHandled[highestRankingConnBond] = true;
                }
                ++firstUnhandled;
                continue;
            }
            int highestRankingAtom = 0;
            int highestRank = -1;
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (atomHandled[atom] || this.mCanRank[atom] <= highestRank) continue;
                highestRankingAtom = atom;
                highestRank = this.mCanRank[atom];
            }
            ++atomsWithoutParents;
            this.mGraphIndex[highestRankingAtom] = firstUnused;
            this.mGraphFrom[firstUnused] = -1;
            this.mGraphAtom[firstUnused++] = highestRankingAtom;
            atomHandled[highestRankingAtom] = true;
        }
        this.mGraphClosure = new int[2 * (this.mMol.getBonds() - graphBonds)];
        while (true) {
            int lowAtomNo1 = this.mMol.getMaxAtoms();
            int lowAtomNo2 = this.mMol.getMaxAtoms();
            int lowBond = -1;
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                int hiAtom;
                int loAtom;
                if (bondHandled[bond]) continue;
                if (this.mGraphIndex[this.mMol.getBondAtom(0, bond)] < this.mGraphIndex[this.mMol.getBondAtom(1, bond)]) {
                    loAtom = this.mGraphIndex[this.mMol.getBondAtom(0, bond)];
                    hiAtom = this.mGraphIndex[this.mMol.getBondAtom(1, bond)];
                } else {
                    loAtom = this.mGraphIndex[this.mMol.getBondAtom(1, bond)];
                    hiAtom = this.mGraphIndex[this.mMol.getBondAtom(0, bond)];
                }
                if (loAtom >= lowAtomNo1 && (loAtom != lowAtomNo1 || hiAtom >= lowAtomNo2)) continue;
                lowAtomNo1 = loAtom;
                lowAtomNo2 = hiAtom;
                lowBond = bond;
            }
            if (lowBond == -1) break;
            bondHandled[lowBond] = true;
            this.mGraphBond[graphBonds++] = lowBond;
            this.mGraphClosure[2 * this.mGraphRings] = lowAtomNo1;
            this.mGraphClosure[2 * this.mGraphRings + 1] = lowAtomNo2;
            ++this.mGraphRings;
        }
        this.mGraphGenerated = true;
    }

    public StereoMolecule getCanMolecule() {
        return this.getCanMolecule(false);
    }

    public StereoMolecule getCanMolecule(boolean includeExplicitHydrogen) {
        int atom;
        int i;
        this.generateGraph();
        StereoMolecule mol = new StereoMolecule(this.mMol.getAtoms(), this.mMol.getBonds());
        mol.setFragment(this.mMol.isFragment());
        for (i = 0; i < this.mMol.getAtoms(); ++i) {
            this.mMol.copyAtom(mol, this.mGraphAtom[i], 0, 0);
            mol.setAtomESR(i, this.mTHESRType[this.mGraphAtom[i]], this.mTHESRGroup[this.mGraphAtom[i]]);
        }
        for (i = 0; i < this.mMol.getBonds(); ++i) {
            this.mMol.copyBond(mol, this.mGraphBond[i], 0, 0, this.mGraphIndex, false);
            if (!mol.isStereoBond(i) && mol.getBondAtom(0, i) > mol.getBondAtom(1, i)) {
                int temp = mol.getBondAtom(0, i);
                mol.setBondAtom(0, i, mol.getBondAtom(1, i));
                mol.setBondAtom(1, i, temp);
            }
            mol.setBondESR(i, this.mEZESRType[this.mGraphBond[i]], this.mEZESRGroup[this.mGraphBond[i]]);
        }
        if (includeExplicitHydrogen) {
            for (i = 0; i < this.mMol.getAtoms(); ++i) {
                atom = this.mGraphAtom[i];
                for (int j = this.mMol.getConnAtoms(atom); j < this.mMol.getAllConnAtoms(atom); ++j) {
                    int hydrogen = this.mMol.copyAtom(mol, this.mMol.getConnAtom(atom, j), 0, 0);
                    this.mMol.copyBond(mol, this.mMol.getConnBond(atom, j), 0, 0, this.mGraphIndex[atom], hydrogen, false);
                }
            }
        }
        for (int bond = 0; bond < mol.getAllBonds(); ++bond) {
            atom = mol.getBondAtom(0, bond);
            if (!this.mTHParityIsMesoInverted[this.mGraphAtom[atom]]) continue;
            if (mol.getBondType(bond) == 17) {
                mol.setBondType(bond, 9);
                continue;
            }
            if (mol.getBondType(bond) != 9) continue;
            mol.setBondType(bond, 17);
        }
        this.mMol.copyMoleculeProperties(mol);
        this.mMol.invalidateHelperArrays(8);
        return mol;
    }

    public void setUnknownParitiesToExplicitlyUnknown() {
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.isAtomConfigurationUnknown(atom) || this.mTHParity[atom] != 3) continue;
            this.mMol.setAtomConfigurationUnknown(atom, true);
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mEZParity[bond] != 3) continue;
            int order = this.mMol.getBondOrder(bond);
            if (order == 1) {
                this.mMol.setAtomConfigurationUnknown(this.mMol.getBondAtom(0, bond), true);
                continue;
            }
            if (order != 2) continue;
            this.mMol.setBondType(bond, 26);
        }
    }

    public boolean setSingleUnknownAsRacemicParity() {
        int bond;
        int atom;
        int unknownTHParities = 0;
        int knownTHParities = 0;
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 0 || this.mTHParityIsPseudo[atom]) continue;
            if (this.mTHParity[atom] == 3) {
                ++unknownTHParities;
                continue;
            }
            ++knownTHParities;
        }
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondType(bond) != 1 || this.mEZParity[bond] == 0 || this.mEZParityIsPseudo[bond]) continue;
            if (this.mEZParity[bond] == 3) {
                ++unknownTHParities;
                continue;
            }
            ++knownTHParities;
        }
        if (knownTHParities == 0 && unknownTHParities == 1) {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                int connAtom;
                int i;
                if (this.mTHParity[atom] != 3 || this.mTHParityIsPseudo[atom]) continue;
                if (this.mMol.getAtomPi(atom) == 2 && this.mMol.getConnAtoms(atom) == 2) {
                    for (i = 0; i < 2; ++i) {
                        connAtom = this.mMol.getConnAtom(atom, i);
                        for (int j = 0; j < this.mMol.getConnAtoms(connAtom); ++j) {
                            if (!this.mMol.isStereoBond(this.mMol.getConnBond(connAtom, j))) continue;
                            return false;
                        }
                    }
                } else {
                    for (i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                        if (!this.mMol.isStereoBond(this.mMol.getConnBond(atom, i))) continue;
                        return false;
                    }
                }
                this.mTHParity[atom] = 2;
                this.mTHESRType[atom] = 1;
                this.mTHESRGroup[atom] = 0;
                this.mMol.setAtomParity(atom, 2, false);
                this.mMol.setAtomESR(atom, 1, 0);
                int stereoBond = this.mMol.getAtomPreferredStereoBond(atom);
                this.mMol.setBondType(stereoBond, 17);
                if (this.mMol.getBondAtom(1, stereoBond) == atom) {
                    connAtom = this.mMol.getBondAtom(0, stereoBond);
                    this.mMol.setBondAtom(0, stereoBond, atom);
                    this.mMol.setBondAtom(1, stereoBond, connAtom);
                }
                return true;
            }
            for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (this.mMol.getBondType(bond) != 1 || this.mEZParity[bond] == 0 || this.mEZParityIsPseudo[bond]) continue;
                for (int i = 0; i < 2; ++i) {
                    int atom2 = this.mMol.getBondAtom(i, bond);
                    for (int j = 0; j < this.mMol.getConnAtoms(atom2); ++j) {
                        if (!this.mMol.isStereoBond(this.mMol.getConnBond(atom2, j))) continue;
                        return false;
                    }
                }
                this.mEZParity[bond] = 2;
                this.mEZESRType[bond] = 1;
                this.mEZESRGroup[bond] = 0;
                this.mMol.setBondParity(bond, 2, false);
                this.mMol.setAtomESR(bond, 1, 0);
                int stereoBond = this.mMol.getBondPreferredStereoBond(bond);
                this.mMol.setBondType(stereoBond, 17);
                if (this.mMol.getBondAtom(1, stereoBond) == this.mMol.getBondAtom(0, bond) || this.mMol.getBondAtom(1, stereoBond) == this.mMol.getBondAtom(1, bond)) {
                    int connAtom = this.mMol.getBondAtom(0, stereoBond);
                    this.mMol.setBondAtom(0, stereoBond, this.mMol.getBondAtom(1, stereoBond));
                    this.mMol.setBondAtom(1, stereoBond, connAtom);
                }
                return true;
            }
        }
        return false;
    }

    public String getIDCode() {
        if (this.mIDCode == null) {
            this.generateGraph();
            if ((this.mMode & 0x800) == 0) {
                this.idGenerateConfigurations();
                this.idNormalizeESRGroupNumbers();
            }
            this.idCodeCreate();
        }
        return this.mIDCode;
    }

    public int[] getFinalRank() {
        return this.mCanRank;
    }

    public int getSymmetryRank(int atom) {
        return this.mCanRankBeforeTieBreaking == null ? -1 : this.mCanRankBeforeTieBreaking[atom];
    }

    public int[] getSymmetryRanks() {
        return this.mCanRankBeforeTieBreaking;
    }

    private void idCodeCreate() {
        int bond;
        boolean[] isAromaticSPBond;
        int atom;
        int atom2;
        int bond2;
        int atom3;
        int atom4;
        this.encodeBitsStart(false);
        this.encodeBits(9L, 4);
        int nbits = Math.max(Canonizer.getNeededBits(this.mMol.getAtoms()), Canonizer.getNeededBits(this.mMol.getBonds()));
        this.encodeBits(nbits, 4);
        if (nbits == 0) {
            this.encodeBits(this.mMol.isFragment() ? 1L : 0L, 1);
            this.encodeBits(0L, 1);
            this.mIDCode = this.encodeBitsEnd();
            return;
        }
        int chargedAtoms = 0;
        int otherAtoms = 0;
        int oxygens = 0;
        int nitrogens = 0;
        for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
            if ((this.mMol.getAtomQueryFeatures(atom4) & 1L) != 0L) continue;
            switch (this.mMol.getAtomicNo(atom4)) {
                case 6: {
                    break;
                }
                case 7: {
                    ++nitrogens;
                    break;
                }
                case 8: {
                    ++oxygens;
                    break;
                }
                default: {
                    ++otherAtoms;
                }
            }
            if (this.mMol.getAtomCharge(atom4) == 0) continue;
            ++chargedAtoms;
        }
        this.encodeBits(this.mMol.getAtoms(), nbits);
        this.encodeBits(this.mMol.getBonds(), nbits);
        this.encodeBits(nitrogens, nbits);
        this.encodeBits(oxygens, nbits);
        this.encodeBits(otherAtoms, nbits);
        this.encodeBits(chargedAtoms, nbits);
        for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[atom4]) != 7 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[atom4]) & 1L) != 0L) continue;
            this.encodeBits(atom4, nbits);
        }
        for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[atom4]) != 8 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[atom4]) & 1L) != 0L) continue;
            this.encodeBits(atom4, nbits);
        }
        for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[atom4]) == 6 || this.mMol.getAtomicNo(this.mGraphAtom[atom4]) == 7 || this.mMol.getAtomicNo(this.mGraphAtom[atom4]) == 8 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[atom4]) & 1L) != 0L) continue;
            this.encodeBits(atom4, nbits);
            this.encodeBits(this.mMol.getAtomicNo(this.mGraphAtom[atom4]), 8);
        }
        for (atom4 = 0; atom4 < this.mMol.getAtoms(); ++atom4) {
            if (this.mMol.getAtomCharge(this.mGraphAtom[atom4]) == 0 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[atom4]) & 1L) != 0L) continue;
            this.encodeBits(atom4, nbits);
            this.encodeBits(8 + this.mMol.getAtomCharge(this.mGraphAtom[atom4]), 4);
        }
        int maxdif = 0;
        int base = 0;
        for (int atom5 = 1; atom5 < this.mMol.getAtoms(); ++atom5) {
            int dif;
            if (this.mGraphFrom[atom5] == -1) {
                dif = 0;
            } else {
                dif = 1 + this.mGraphFrom[atom5] - base;
                base = this.mGraphFrom[atom5];
            }
            if (maxdif >= dif) continue;
            maxdif = dif;
        }
        int dbits = Canonizer.getNeededBits(maxdif);
        this.encodeBits(dbits, 4);
        base = 0;
        for (int atom6 = 1; atom6 < this.mMol.getAtoms(); ++atom6) {
            int dif;
            if (this.mGraphFrom[atom6] == -1) {
                dif = 0;
            } else {
                dif = 1 + this.mGraphFrom[atom6] - base;
                base = this.mGraphFrom[atom6];
            }
            this.encodeBits(dif, dbits);
        }
        for (int i = 0; i < 2 * this.mGraphRings; ++i) {
            this.encodeBits(this.mGraphClosure[i], nbits);
        }
        for (int bond3 = 0; bond3 < this.mMol.getBonds(); ++bond3) {
            int bondOrder = (this.mMol.getBondQueryFeatures(this.mGraphBond[bond3]) & 0x7F80) != 0 || this.mMol.getBondType(this.mGraphBond[bond3]) == 32 ? 1 : (this.mMol.isDelocalizedBond(this.mGraphBond[bond3]) ? 0 : this.mMol.getBondOrder(this.mGraphBond[bond3]));
            this.encodeBits(bondOrder, 2);
        }
        int THCount = 0;
        if ((this.mMode & 0x800) == 0) {
            for (atom3 = 0; atom3 < this.mMol.getAtoms(); ++atom3) {
                if (this.mTHConfiguration[this.mGraphAtom[atom3]] == 0 || this.mTHConfiguration[this.mGraphAtom[atom3]] == 3) continue;
                ++THCount;
            }
        }
        this.encodeBits(THCount, nbits);
        if ((this.mMode & 0x800) == 0) {
            for (atom3 = 0; atom3 < this.mMol.getAtoms(); ++atom3) {
                if (this.mTHConfiguration[this.mGraphAtom[atom3]] == 0 || this.mTHConfiguration[this.mGraphAtom[atom3]] == 3) continue;
                this.encodeBits(atom3, nbits);
                if (this.mTHESRType[this.mGraphAtom[atom3]] == 0) {
                    this.encodeBits(this.mTHConfiguration[this.mGraphAtom[atom3]], 3);
                    continue;
                }
                int parity = this.mTHConfiguration[this.mGraphAtom[atom3]] == 1 ? (this.mTHESRType[this.mGraphAtom[atom3]] == 1 ? 4 : 6) : (this.mTHESRType[this.mGraphAtom[atom3]] == 1 ? 5 : 7);
                this.encodeBits(parity, 3);
                this.encodeBits(this.mTHESRGroup[this.mGraphAtom[atom3]], 3);
            }
        }
        int EZCount = 0;
        if ((this.mMode & 0x800) == 0) {
            for (bond2 = 0; bond2 < this.mMol.getBonds(); ++bond2) {
                if (this.mEZConfiguration[this.mGraphBond[bond2]] == 0 || this.mEZConfiguration[this.mGraphBond[bond2]] == 3 || this.mMol.isSmallRingBond(this.mGraphBond[bond2]) && this.mMol.getBondType(this.mGraphBond[bond2]) != 1) continue;
                ++EZCount;
            }
        }
        this.encodeBits(EZCount, nbits);
        if ((this.mMode & 0x800) == 0) {
            for (bond2 = 0; bond2 < this.mMol.getBonds(); ++bond2) {
                if (this.mEZConfiguration[this.mGraphBond[bond2]] == 0 || this.mEZConfiguration[this.mGraphBond[bond2]] == 3 || this.mMol.isSmallRingBond(this.mGraphBond[bond2]) && this.mMol.getBondType(this.mGraphBond[bond2]) != 1) continue;
                this.encodeBits(bond2, nbits);
                if (this.mMol.getBondType(this.mGraphBond[bond2]) == 1) {
                    if (this.mEZESRType[this.mGraphBond[bond2]] == 0) {
                        this.encodeBits(this.mEZConfiguration[this.mGraphBond[bond2]], 3);
                        continue;
                    }
                    int parity = this.mEZConfiguration[this.mGraphBond[bond2]] == 1 ? (this.mEZESRType[this.mGraphBond[bond2]] == 1 ? 4 : 6) : (this.mEZESRType[this.mGraphBond[bond2]] == 1 ? 5 : 7);
                    this.encodeBits(parity, 3);
                    this.encodeBits(this.mEZESRGroup[this.mGraphBond[bond2]], 3);
                    continue;
                }
                this.encodeBits(this.mEZConfiguration[this.mGraphBond[bond2]], 2);
            }
        }
        this.encodeBits(this.mMol.isFragment() ? 1L : 0L, 1);
        int count = 0;
        for (atom2 = 0; atom2 < this.mMol.getAtoms(); ++atom2) {
            if (this.mMol.getAtomMass(this.mGraphAtom[atom2]) == 0) continue;
            ++count;
        }
        if (count != 0) {
            this.encodeBits(1L, 1);
            this.encodeBits(1L, 4);
            this.encodeBits(count, nbits);
            for (atom2 = 0; atom2 < this.mMol.getAtoms(); ++atom2) {
                if (this.mMol.getAtomMass(this.mGraphAtom[atom2]) == 0) continue;
                this.encodeBits(atom2, nbits);
                this.encodeBits(this.mMol.getAtomMass(this.mGraphAtom[atom2]), 8);
            }
        }
        boolean isSecondFeatureBlock = false;
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(0, false, nbits, 2048L, 1, -1);
            this.addAtomQueryFeatures(3, false, nbits, 4096L, 1, -1);
            this.addAtomQueryFeatures(4, false, nbits, 120L, 4, 3);
            this.addAtomQueryFeatures(5, false, nbits, 6L, 2, 1);
            this.addAtomQueryFeatures(6, false, nbits, 1L, 1, -1);
            this.addAtomQueryFeatures(7, false, nbits, 1920L, 4, 7);
            count = 0;
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (this.mMol.getAtomList(this.mGraphAtom[atom]) == null) continue;
                ++count;
            }
            if (count > 0) {
                this.encodeBits(1L, 1);
                this.encodeBits(8L, 4);
                this.encodeBits(count, nbits);
                for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    int[] atomList = this.mMol.getAtomList(this.mGraphAtom[atom]);
                    if (atomList == null) continue;
                    this.encodeBits(atom, nbits);
                    this.encodeBits(atomList.length, 4);
                    for (int a : atomList) {
                        this.encodeBits(a, 8);
                    }
                }
            }
            this.addBondQueryFeatures(9, false, nbits, 96, 2, 5);
            this.addBondQueryFeatures(10, false, nbits, 31, 5, 0);
            this.addAtomQueryFeatures(11, false, nbits, 8192L, 1, -1);
            this.addBondQueryFeatures(12, false, nbits, 32640, 8, 7);
            this.addAtomQueryFeatures(13, false, nbits, 114688L, 3, 14);
            this.addAtomQueryFeatures(14, false, nbits, 0x3E0000L, 5, 17);
            isSecondFeatureBlock |= this.addAtomQueryFeatures(16, isSecondFeatureBlock, nbits, 0x1C00000L, 3, 22);
        }
        count = 0;
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mAbnormalValence == null || this.mAbnormalValence[this.mGraphAtom[atom]] == -1) continue;
            ++count;
        }
        if (count != 0) {
            isSecondFeatureBlock = this.ensureSecondFeatureBlock(isSecondFeatureBlock);
            this.encodeBits(1L, 1);
            this.encodeBits(1L, 4);
            this.encodeBits(count, nbits);
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (this.mAbnormalValence == null || this.mAbnormalValence[this.mGraphAtom[atom]] == -1) continue;
                this.encodeBits(atom, nbits);
                this.encodeBits(this.mAbnormalValence[this.mGraphAtom[atom]], 4);
            }
        }
        if ((this.mMode & 8) != 0 || (this.mMode & 0x400) != 0) {
            count = 0;
            int maxLength = 0;
            for (int atom7 = 0; atom7 < this.mMol.getAtoms(); ++atom7) {
                String label = this.mMol.getAtomCustomLabel(this.mGraphAtom[atom7]);
                if (label == null) continue;
                ++count;
                maxLength = Math.max(maxLength, label.length());
            }
            if (count != 0) {
                isSecondFeatureBlock = this.ensureSecondFeatureBlock(isSecondFeatureBlock);
                int lbits = Canonizer.getNeededBits(maxLength);
                this.encodeBits(1L, 1);
                this.encodeBits(2L, 4);
                this.encodeBits(count, nbits);
                this.encodeBits(lbits, 4);
                for (int atom8 = 0; atom8 < this.mMol.getAtoms(); ++atom8) {
                    String customLabel = this.mMol.getAtomCustomLabel(this.mGraphAtom[atom8]);
                    if (customLabel == null) continue;
                    this.encodeBits(atom8, nbits);
                    this.encodeBits(customLabel.length(), lbits);
                    for (int i = 0; i < customLabel.length(); ++i) {
                        this.encodeBits(customLabel.charAt(i), 7);
                    }
                }
            }
        }
        if (this.mMol.isFragment()) {
            isSecondFeatureBlock |= this.addAtomQueryFeatures(19, isSecondFeatureBlock, nbits, 0xE000000L, 3, 25);
            isSecondFeatureBlock |= this.addBondQueryFeatures(20, isSecondFeatureBlock, nbits, 229376, 3, 15);
        }
        count = 0;
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.getAtomRadical(this.mGraphAtom[atom]) == 0) continue;
            ++count;
        }
        if (count != 0) {
            isSecondFeatureBlock = this.ensureSecondFeatureBlock(isSecondFeatureBlock);
            this.encodeBits(1L, 1);
            this.encodeBits(5L, 4);
            this.encodeBits(count, nbits);
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (this.mMol.getAtomRadical(this.mGraphAtom[atom]) == 0) continue;
                this.encodeBits(atom, nbits);
                this.encodeBits(this.mMol.getAtomRadical(this.mGraphAtom[atom]) >> 4, 2);
            }
        }
        if (this.mMol.isFragment()) {
            isSecondFeatureBlock |= this.addAtomQueryFeatures(22, isSecondFeatureBlock, nbits, 0x10000000L, 1, -1);
            isSecondFeatureBlock |= this.addBondQueryFeatures(23, isSecondFeatureBlock, nbits, 262144, 1, -1);
            isSecondFeatureBlock |= this.addBondQueryFeatures(24, isSecondFeatureBlock, nbits, 0x180000, 2, 19);
        }
        if ((this.mMode & 0x10) != 0) {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (!this.mMol.isSelectedAtom(this.mGraphAtom[atom])) continue;
                isSecondFeatureBlock = this.ensureSecondFeatureBlock(isSecondFeatureBlock);
                this.encodeBits(1L, 1);
                this.encodeBits(9L, 4);
                for (int a = 0; a < this.mMol.getAtoms(); ++a) {
                    this.encodeBits(this.mMol.isSelectedAtom(this.mGraphAtom[a]) ? 1L : 0L, 1);
                }
                break;
            }
        }
        if ((isAromaticSPBond = this.getAromaticSPBonds()) != null) {
            int bond4;
            count = 0;
            for (bond4 = 0; bond4 < this.mMol.getBonds(); ++bond4) {
                if (!isAromaticSPBond[this.mGraphBond[bond4]]) continue;
                ++count;
            }
            isSecondFeatureBlock = this.ensureSecondFeatureBlock(isSecondFeatureBlock);
            this.encodeBits(1L, 1);
            this.encodeBits(10L, 4);
            this.encodeBits(count, nbits);
            for (bond4 = 0; bond4 < this.mMol.getBonds(); ++bond4) {
                if (!isAromaticSPBond[this.mGraphBond[bond4]]) continue;
                this.encodeBits(bond4, nbits);
            }
        }
        if (this.mMol.isFragment()) {
            isSecondFeatureBlock |= this.addAtomQueryFeatures(27, isSecondFeatureBlock, nbits, 0x20000000L, 1, -1);
        }
        count = 0;
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondType(this.mGraphBond[bond]) != 32) continue;
            ++count;
        }
        if (count != 0) {
            isSecondFeatureBlock = this.ensureSecondFeatureBlock(isSecondFeatureBlock);
            this.encodeBits(1L, 1);
            this.encodeBits(12L, 4);
            this.encodeBits(count, nbits);
            for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (this.mMol.getBondType(this.mGraphBond[bond]) != 32) continue;
                this.encodeBits(bond, nbits);
            }
        }
        if (this.mMol.isFragment()) {
            isSecondFeatureBlock |= this.addAtomQueryFeatures(29, isSecondFeatureBlock, nbits, -1073741824L, 2, 30);
            isSecondFeatureBlock |= this.addAtomQueryFeatures(30, isSecondFeatureBlock, nbits, 0x7F00000000L, 7, 32);
        }
        this.encodeBits(0L, 1);
        this.mIDCode = this.encodeBitsEnd();
    }

    private boolean ensureSecondFeatureBlock(boolean isSecondFeatureBlock) {
        if (!isSecondFeatureBlock) {
            this.encodeBits(1L, 1);
            this.encodeBits(15L, 4);
        }
        return true;
    }

    private boolean addAtomQueryFeatures(int codeNo, boolean isSecondFeatureBlock, int nbits, long qfMask, int qfBits, int qfShift) {
        int atom;
        int count = 0;
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if ((this.mMol.getAtomQueryFeatures(this.mGraphAtom[atom]) & qfMask) == 0L) continue;
            ++count;
        }
        if (count == 0) {
            return false;
        }
        if (codeNo > 15) {
            this.ensureSecondFeatureBlock(isSecondFeatureBlock);
            codeNo -= 16;
        }
        this.encodeBits(1L, 1);
        this.encodeBits(codeNo, 4);
        this.encodeBits(count, nbits);
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            long feature = this.mMol.getAtomQueryFeatures(this.mGraphAtom[atom]) & qfMask;
            if (feature == 0L) continue;
            this.encodeBits(atom, nbits);
            if (qfBits == 1) continue;
            this.encodeBits(feature >> qfShift, qfBits);
        }
        return true;
    }

    private boolean addBondQueryFeatures(int codeNo, boolean isSecondFeatureBlock, int nbits, int qfMask, int qfBits, int qfShift) {
        int bond;
        int count = 0;
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if ((this.mMol.getBondQueryFeatures(this.mGraphBond[bond]) & qfMask) == 0) continue;
            ++count;
        }
        if (count == 0) {
            return false;
        }
        if (codeNo > 15) {
            this.ensureSecondFeatureBlock(isSecondFeatureBlock);
            codeNo -= 16;
        }
        this.encodeBits(1L, 1);
        this.encodeBits(codeNo, 4);
        this.encodeBits(count, nbits);
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            int feature = this.mMol.getBondQueryFeatures(this.mGraphBond[bond]) & qfMask;
            if (feature == 0) continue;
            this.encodeBits(bond, nbits);
            if (qfBits == 1) continue;
            this.encodeBits(feature >> qfShift, qfBits);
        }
        return true;
    }

    private boolean[] getAromaticSPBonds() {
        boolean[] isAromaticSPBond = null;
        RingCollection ringSet = this.mMol.getRingSet();
        for (int r = 0; r < ringSet.getSize(); ++r) {
            int[] ringAtom;
            if (!ringSet.isDelocalized(r)) continue;
            int count = 0;
            for (int atom : ringAtom = ringSet.getRingAtoms(r)) {
                if (!this.hasTwoAromaticPiElectrons(atom)) continue;
                ++count;
            }
            if (count == 0) continue;
            int[] ringBond = ringSet.getRingBonds(r);
            if (isAromaticSPBond == null) {
                isAromaticSPBond = new boolean[this.mMol.getBonds()];
            }
            if (count == ringAtom.length) {
                int minIndex = -1;
                int minValue = Integer.MAX_VALUE;
                for (int i = 0; i < ringAtom.length; ++i) {
                    if (minValue <= this.mGraphAtom[ringBond[i]]) continue;
                    minValue = this.mGraphAtom[ringBond[i]];
                    minIndex = i;
                }
                while (count > 0) {
                    isAromaticSPBond[ringBond[minIndex]] = true;
                    minIndex = this.validateCyclicIndex(minIndex + 2, ringAtom.length);
                    count -= 2;
                }
                continue;
            }
            int index = 0;
            while (this.hasTwoAromaticPiElectrons(ringAtom[index])) {
                ++index;
            }
            while (!this.hasTwoAromaticPiElectrons(ringAtom[index])) {
                index = this.validateCyclicIndex(index + 1, ringAtom.length);
            }
            while (count > 0) {
                isAromaticSPBond[ringBond[index]] = true;
                index = this.validateCyclicIndex(index + 2, ringAtom.length);
                count -= 2;
                while (!this.hasTwoAromaticPiElectrons(ringAtom[index])) {
                    index = this.validateCyclicIndex(index + 1, ringAtom.length);
                }
            }
        }
        return isAromaticSPBond;
    }

    private boolean hasTwoAromaticPiElectrons(int atom) {
        if (this.mMol.getAtomPi(atom) < 2) {
            return false;
        }
        if (this.mMol.getConnAtoms(atom) == 2) {
            return true;
        }
        int aromaticPi = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            int connBond = this.mMol.getConnBond(atom, i);
            if (!this.mMol.isAromaticBond(connBond)) continue;
            aromaticPi += this.mMol.getBondOrder(connBond) - 1;
        }
        return aromaticPi > 1;
    }

    private int validateCyclicIndex(int index, int limit) {
        return index < limit ? index : index - limit;
    }

    public void invalidateCoordinates() {
        this.mEncodedCoords = null;
    }

    public String getEncodedCoordinates() {
        return this.getEncodedCoordinates(this.mZCoordinatesAvailable);
    }

    public String getEncodedCoordinates(boolean keepPositionAndScale) {
        if (this.mEncodedCoords == null) {
            this.generateGraph();
            this.encodeCoordinates(keepPositionAndScale, this.mMol.getAtomCoordinates());
        }
        return this.mEncodedCoords;
    }

    public String getEncodedCoordinates(boolean keepPositionAndScale, Coordinates[] atomCoordinates) {
        if (this.mEncodedCoords == null) {
            this.generateGraph();
            this.encodeCoordinates(keepPositionAndScale, atomCoordinates);
        }
        return this.mEncodedCoords;
    }

    private void encodeCoordinates(boolean keepPositionAndScale, Coordinates[] coords) {
        int i;
        int i2;
        if (this.mMol.getAtoms() == 0) {
            this.mEncodedCoords = "";
            return;
        }
        boolean includeHydrogenCoordinates = false;
        if (this.mZCoordinatesAvailable && this.mMol.getAllAtoms() > this.mMol.getAtoms() && !this.mMol.isFragment()) {
            includeHydrogenCoordinates = true;
            for (int i3 = 0; i3 < this.mMol.getAtoms(); ++i3) {
                if (this.mMol.getImplicitHydrogens(i3) == 0) continue;
                includeHydrogenCoordinates = false;
                break;
            }
        }
        int resolutionBits = this.mZCoordinatesAvailable ? 16 : 8;
        this.encodeBitsStart(true);
        this.mEncodingBuffer.append(includeHydrogenCoordinates ? (char)'#' : '!');
        this.encodeBits(this.mZCoordinatesAvailable ? 1L : 0L, 1);
        this.encodeBits(keepPositionAndScale ? 1L : 0L, 1);
        this.encodeBits(resolutionBits / 2, 4);
        double maxDelta = 0.0;
        for (i2 = 1; i2 < this.mMol.getAtoms(); ++i2) {
            maxDelta = this.getMaxDelta(this.mGraphAtom[i2], this.mGraphFrom[i2] == -1 ? -1 : this.mGraphAtom[this.mGraphFrom[i2]], maxDelta, coords);
        }
        if (includeHydrogenCoordinates) {
            for (i2 = 0; i2 < this.mMol.getAtoms(); ++i2) {
                int atom = this.mGraphAtom[i2];
                for (int j = this.mMol.getConnAtoms(atom); j < this.mMol.getAllConnAtoms(atom); ++j) {
                    maxDelta = this.getMaxDelta(this.mMol.getConnAtom(atom, j), atom, maxDelta, coords);
                }
            }
        }
        if (this.mMol.getAtoms() > 1 && maxDelta == 0.0) {
            this.mEncodedCoords = "";
            return;
        }
        int binCount = 1 << resolutionBits;
        double increment = maxDelta / ((double)binCount / 2.0 - 1.0);
        double maxDeltaPlusHalfIncrement = maxDelta + increment / 2.0;
        for (i = 1; i < this.mMol.getAtoms(); ++i) {
            this.encodeCoords(this.mGraphAtom[i], this.mGraphFrom[i] == -1 ? -1 : this.mGraphAtom[this.mGraphFrom[i]], maxDeltaPlusHalfIncrement, increment, resolutionBits, coords);
        }
        if (includeHydrogenCoordinates) {
            for (i = 0; i < this.mMol.getAtoms(); ++i) {
                int atom = this.mGraphAtom[i];
                for (int j = this.mMol.getConnAtoms(atom); j < this.mMol.getAllConnAtoms(atom); ++j) {
                    this.encodeCoords(this.mMol.getConnAtom(atom, j), atom, maxDeltaPlusHalfIncrement, increment, resolutionBits, coords);
                }
            }
        }
        if (keepPositionAndScale) {
            double avblDefault = this.mZCoordinatesAvailable ? 1.5 : Molecule.getDefaultAverageBondLength();
            double avbl = this.mMol.getAverageBondLength(includeHydrogenCoordinates ? this.mMol.getAllAtoms() : this.mMol.getAtoms(), includeHydrogenCoordinates ? this.mMol.getAllBonds() : this.mMol.getBonds(), avblDefault, coords);
            this.encodeBits(this.encodeABVL(avbl, binCount), resolutionBits);
            this.encodeBits(this.encodeShift(coords[this.mGraphAtom[0]].x / avbl, binCount), resolutionBits);
            this.encodeBits(this.encodeShift(coords[this.mGraphAtom[0]].y / avbl, binCount), resolutionBits);
            if (this.mZCoordinatesAvailable) {
                this.encodeBits(this.encodeShift(coords[this.mGraphAtom[0]].z / avbl, binCount), resolutionBits);
            }
        }
        this.mEncodedCoords = this.encodeBitsEnd();
    }

    private double getMaxDelta(int atom, int from, double maxDelta, Coordinates[] coords) {
        double deltaY;
        double deltaX;
        double d = deltaX = from == -1 ? Math.abs(coords[atom].x - coords[this.mGraphAtom[0]].x) / 8.0 : Math.abs(coords[atom].x - coords[from].x);
        if (maxDelta < deltaX) {
            maxDelta = deltaX;
        }
        double d2 = deltaY = from == -1 ? Math.abs(coords[atom].y - coords[this.mGraphAtom[0]].y) / 8.0 : Math.abs(coords[atom].y - coords[from].y);
        if (maxDelta < deltaY) {
            maxDelta = deltaY;
        }
        if (this.mZCoordinatesAvailable) {
            double deltaZ;
            double d3 = deltaZ = from == -1 ? Math.abs(coords[atom].z - coords[this.mGraphAtom[0]].z) / 8.0 : Math.abs(coords[atom].z - coords[from].z);
            if (maxDelta < deltaZ) {
                maxDelta = deltaZ;
            }
        }
        return maxDelta;
    }

    private void encodeCoords(int atom, int from, double maxDeltaPlusHalfIncrement, double increment, int resolutionBits, Coordinates[] coords) {
        double deltaX = from == -1 ? (coords[atom].x - coords[this.mGraphAtom[0]].x) / 8.0 : coords[atom].x - coords[from].x;
        double deltaY = from == -1 ? (coords[atom].y - coords[this.mGraphAtom[0]].y) / 8.0 : coords[atom].y - coords[from].y;
        this.encodeBits((int)((maxDeltaPlusHalfIncrement + deltaX) / increment), resolutionBits);
        this.encodeBits((int)((maxDeltaPlusHalfIncrement + deltaY) / increment), resolutionBits);
        if (this.mZCoordinatesAvailable) {
            double deltaZ = from == -1 ? (coords[atom].z - coords[this.mGraphAtom[0]].z) / 8.0 : coords[atom].z - coords[from].z;
            this.encodeBits((int)((maxDeltaPlusHalfIncrement + deltaZ) / increment), resolutionBits);
        }
    }

    private int encodeABVL(double value, int binCount) {
        return Math.min(binCount - 1, Math.max(0, (int)(0.5 + Math.log10(value / 0.1) / Math.log10(2000.0) * (double)(binCount - 1))));
    }

    private int encodeShift(double value, int binCount) {
        int halfBinCount = binCount / 2;
        boolean isNegative = value < 0.0;
        value = Math.abs(value);
        double steepness = binCount / 32;
        int intValue = Math.min(halfBinCount - 1, (int)Math.round(value * (double)halfBinCount / (value + steepness)));
        return isNegative ? halfBinCount + intValue : intValue;
    }

    public String getEncodedMapping() {
        if (this.mMapping == null) {
            this.generateGraph();
            this.encodeMapping();
        }
        return this.mMapping;
    }

    private void encodeMapping() {
        if (this.mMol.getAtoms() == 0) {
            this.mMapping = "";
            return;
        }
        int maxMapNo = 0;
        boolean autoMappingFound = false;
        boolean manualMappingFound = false;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (maxMapNo < this.mMol.getAtomMapNo(atom)) {
                maxMapNo = this.mMol.getAtomMapNo(atom);
            }
            if (this.mMol.isAutoMappedAtom(atom)) {
                autoMappingFound = true;
                continue;
            }
            manualMappingFound = true;
        }
        if (maxMapNo == 0) {
            this.mMapping = "";
            return;
        }
        int nbits = Canonizer.getNeededBits(maxMapNo);
        this.encodeBitsStart(true);
        this.encodeBits(nbits, 4);
        this.encodeBits(autoMappingFound ? 1L : 0L, 1);
        this.encodeBits(manualMappingFound ? 1L : 0L, 1);
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            this.encodeBits(this.mMol.getAtomMapNo(this.mGraphAtom[atom]), nbits);
            if (!autoMappingFound || !manualMappingFound) continue;
            this.encodeBits(this.mMol.isAutoMappedAtom(this.mGraphAtom[atom]) ? 1L : 0L, 1);
        }
        this.mMapping = this.encodeBitsEnd();
    }

    private void idGenerateConfigurations() {
        int j;
        int i;
        boolean inversion;
        this.mTHConfiguration = new byte[this.mMol.getAtoms()];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2) {
                inversion = this.mTHParityIsMesoInverted[atom];
                if (this.mMol.isCentralAlleneAtom(atom)) {
                    for (i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                        int connAtom = this.mMol.getConnAtom(atom, i);
                        int neighbours = 0;
                        int[] neighbour = new int[3];
                        for (j = 0; j < this.mMol.getConnAtoms(connAtom); ++j) {
                            neighbour[neighbours] = this.mMol.getConnAtom(connAtom, j);
                            if (neighbour[neighbours] == atom) continue;
                            ++neighbours;
                        }
                        if (neighbours != 2 || !(this.mCanRank[neighbour[0]] > this.mCanRank[neighbour[1]] ^ this.mGraphIndex[neighbour[0]] < this.mGraphIndex[neighbour[1]])) continue;
                        inversion = !inversion;
                    }
                } else {
                    for (i = 1; i < this.mMol.getConnAtoms(atom); ++i) {
                        for (int j2 = 0; j2 < i; ++j2) {
                            int connAtom2;
                            int connAtom1 = this.mMol.getConnAtom(atom, i);
                            if (this.mCanRank[connAtom1] > this.mCanRank[connAtom2 = this.mMol.getConnAtom(atom, j2)]) {
                                boolean bl = inversion = !inversion;
                            }
                            if (this.mGraphIndex[connAtom1] >= this.mGraphIndex[connAtom2]) continue;
                            inversion = !inversion;
                        }
                    }
                }
                this.mTHConfiguration[atom] = this.mTHParity[atom] == 1 ^ inversion ? 1 : 2;
                continue;
            }
            this.mTHConfiguration[atom] = this.mTHParity[atom];
        }
        this.mEZConfiguration = new byte[this.mMol.getBonds()];
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mEZParity[bond] == 1 || this.mEZParity[bond] == 2) {
                inversion = false;
                for (i = 0; i < 2; ++i) {
                    int bondAtom = this.mMol.getBondAtom(i, bond);
                    if (this.mMol.getConnAtoms(bondAtom) != 3) continue;
                    int[] neighbour = new int[2];
                    int neighbours = 0;
                    for (j = 0; j < 3; ++j) {
                        if (this.mMol.getConnAtom(bondAtom, j) == this.mMol.getBondAtom(1 - i, bond)) continue;
                        neighbour[neighbours++] = this.mMol.getConnAtom(bondAtom, j);
                    }
                    if (this.mCanRank[neighbour[0]] > this.mCanRank[neighbour[1]]) {
                        boolean bl = inversion = !inversion;
                    }
                    if (this.mGraphIndex[neighbour[0]] >= this.mGraphIndex[neighbour[1]]) continue;
                    inversion = !inversion;
                }
                this.mEZConfiguration[bond] = this.mEZParity[bond] == 1 ^ inversion ? 1 : 2;
                continue;
            }
            this.mEZConfiguration[bond] = this.mEZParity[bond];
        }
    }

    private void idNormalizeESRGroupNumbers() {
        this.idNormalizeESRGroupNumbers(1);
        this.idNormalizeESRGroupNumbers(2);
    }

    private void idNormalizeESRGroupNumbers(int type) {
        byte group;
        int[] groupRank = new int[32];
        int groups = 0;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHConfiguration[atom] != 1 && this.mTHConfiguration[atom] != 2 || this.mTHESRType[atom] != type || groupRank[group = this.mTHESRGroup[atom]] >= this.mCanRank[atom]) continue;
            if (groupRank[group] == 0) {
                ++groups;
            }
            groupRank[group] = this.mCanRank[atom];
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            int rank;
            if (this.mEZConfiguration[bond] != 1 && this.mEZConfiguration[bond] != 2 || this.mEZESRType[bond] != type || this.mMol.getBondType(bond) != 1 || groupRank[group = this.mEZESRGroup[bond]] >= (rank = Math.max(this.mCanRank[this.mMol.getBondAtom(0, bond)], this.mCanRank[this.mMol.getBondAtom(1, bond)]))) continue;
            if (groupRank[group] == 0) {
                ++groups;
            }
            groupRank[group] = rank;
        }
        byte[] canGroup = new byte[32];
        for (int i = 0; i < groups; ++i) {
            int maxGroup = -1;
            int maxRank = 0;
            for (int j = 0; j < 32; ++j) {
                if (maxRank >= groupRank[j]) continue;
                maxRank = groupRank[j];
                maxGroup = j;
            }
            groupRank[maxGroup] = 0;
            canGroup[maxGroup] = (byte)i;
        }
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHConfiguration[atom] != 1 && this.mTHConfiguration[atom] != 2 || this.mTHESRType[atom] != type) continue;
            this.mTHESRGroup[atom] = canGroup[this.mTHESRGroup[atom]];
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mEZConfiguration[bond] != 1 && this.mEZConfiguration[bond] != 2 || this.mEZESRType[bond] != type || this.mMol.getBondType(bond) != 1) continue;
            this.mEZESRGroup[bond] = canGroup[this.mEZESRGroup[bond]];
        }
    }

    private void encodeBitsStart(boolean avoid127) {
        this.mEncodingBuffer = new StringBuilder();
        this.mEncodingBitsAvail = 6;
        this.mEncodingTempData = 0;
        this.mEncodeAvoid127 = avoid127;
    }

    private void encodeBits(long data, int bits) {
        while (bits != 0) {
            if (this.mEncodingBitsAvail == 0) {
                if (!this.mEncodeAvoid127 || this.mEncodingTempData != 63) {
                    this.mEncodingTempData += 64;
                }
                this.mEncodingBuffer.append((char)this.mEncodingTempData);
                this.mEncodingBitsAvail = 6;
                this.mEncodingTempData = 0;
            }
            this.mEncodingTempData <<= 1;
            this.mEncodingTempData = (int)((long)this.mEncodingTempData | data & 1L);
            data >>= 1;
            --bits;
            --this.mEncodingBitsAvail;
        }
    }

    private String encodeBitsEnd() {
        this.mEncodingTempData <<= this.mEncodingBitsAvail;
        if (!this.mEncodeAvoid127 || this.mEncodingTempData != 63) {
            this.mEncodingTempData += 64;
        }
        this.mEncodingBuffer.append((char)this.mEncodingTempData);
        return this.mEncodingBuffer.toString();
    }

    public static int getNeededBits(int maxNo) {
        int bits = 0;
        while (maxNo > 0) {
            maxNo >>= 1;
            ++bits;
        }
        return bits;
    }

    public int getTHParity(int atom) {
        return this.mTHParity[atom];
    }

    public int getEZParity(int bond) {
        return this.mEZParity[bond];
    }

    public int getPseudoStereoGroupCount() {
        return this.mNoOfPseudoGroups;
    }

    public int getPseudoEZGroup(int bond) {
        return this.mPseudoEZGroup[bond];
    }

    public int getPseudoTHGroup(int atom) {
        return this.mPseudoTHGroup[atom];
    }

    public boolean normalizeEnantiomer() {
        int[] parityCount = new int[this.mNoOfRanks + 1];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.getAtomESRType(atom) != 0) continue;
            if (this.mTHParity[atom] == 1) {
                int n = this.mCanRank[atom];
                parityCount[n] = parityCount[n] + 1;
                continue;
            }
            if (this.mTHParity[atom] != 2) continue;
            int n = this.mCanRank[atom];
            parityCount[n] = parityCount[n] - 1;
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondOrder(bond) != 1 || this.mMol.getBondESRType(bond) != 0) continue;
            if (this.mEZParity[bond] == 1) {
                int n = this.mCanRank[this.mMol.getBondAtom(0, bond)];
                parityCount[n] = parityCount[n] + 1;
                int n2 = this.mCanRank[this.mMol.getBondAtom(1, bond)];
                parityCount[n2] = parityCount[n2] + 1;
                continue;
            }
            if (this.mEZParity[bond] != 2) continue;
            int n = this.mCanRank[this.mMol.getBondAtom(0, bond)];
            parityCount[n] = parityCount[n] - 1;
            int n3 = this.mCanRank[this.mMol.getBondAtom(1, bond)];
            parityCount[n3] = parityCount[n3] - 1;
        }
        for (int rank = 1; rank <= this.mNoOfRanks; ++rank) {
            boolean invert;
            if (parityCount[rank] == 0) continue;
            boolean bl = invert = parityCount[rank] < 0;
            if (invert) {
                for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    if (this.mMol.getAtomESRType(atom) != 0) continue;
                    if (this.mTHParity[atom] == 1) {
                        this.mTHParity[atom] = 2;
                        continue;
                    }
                    if (this.mTHParity[atom] != 2) continue;
                    this.mTHParity[atom] = 1;
                }
                for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                    if (this.mMol.getBondOrder(bond) != 1 || this.mMol.getBondESRType(bond) != 0) continue;
                    if (this.mEZParity[bond] == 1) {
                        this.mEZParity[bond] = 2;
                        continue;
                    }
                    if (this.mEZParity[bond] != 2) continue;
                    this.mEZParity[bond] = 1;
                }
            }
            return invert;
        }
        return false;
    }

    public void setParities() {
        int j;
        int i;
        boolean inversion;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2) {
                inversion = false;
                if (this.mMol.isCentralAlleneAtom(atom)) {
                    for (i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                        int connAtom = this.mMol.getConnAtom(atom, i);
                        int neighbours = 0;
                        int[] neighbour = new int[3];
                        for (j = 0; j < this.mMol.getConnAtoms(connAtom); ++j) {
                            neighbour[neighbours] = this.mMol.getConnAtom(connAtom, j);
                            if (neighbour[neighbours] == atom) continue;
                            ++neighbours;
                        }
                        if (neighbours != 2 || !(this.mCanRank[neighbour[0]] > this.mCanRank[neighbour[1]] ^ neighbour[0] < neighbour[1])) continue;
                        inversion = !inversion;
                    }
                } else {
                    for (i = 1; i < this.mMol.getConnAtoms(atom); ++i) {
                        for (int j2 = 0; j2 < i; ++j2) {
                            int connAtom2;
                            int connAtom1 = this.mMol.getConnAtom(atom, i);
                            if (this.mCanRank[connAtom1] > this.mCanRank[connAtom2 = this.mMol.getConnAtom(atom, j2)]) {
                                boolean bl = inversion = !inversion;
                            }
                            if (connAtom1 >= connAtom2) continue;
                            inversion = !inversion;
                        }
                    }
                }
                this.mMol.setAtomParity(atom, this.mTHParity[atom] == 1 ^ inversion ? 1 : 2, this.mTHParityIsPseudo[atom]);
                continue;
            }
            this.mMol.setAtomParity(atom, this.mTHParity[atom], this.mTHParityIsPseudo[atom]);
        }
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mEZParity[bond] == 1 || this.mEZParity[bond] == 2) {
                inversion = false;
                for (i = 0; i < 2; ++i) {
                    int bondAtom = this.mMol.getBondAtom(i, bond);
                    if (this.mMol.getConnAtoms(bondAtom) != 3) continue;
                    int[] neighbour = new int[2];
                    int neighbours = 0;
                    for (j = 0; j < 3; ++j) {
                        if (this.mMol.getConnAtom(bondAtom, j) == this.mMol.getBondAtom(1 - i, bond)) continue;
                        neighbour[neighbours++] = this.mMol.getConnAtom(bondAtom, j);
                    }
                    if (this.mCanRank[neighbour[0]] > this.mCanRank[neighbour[1]]) {
                        boolean bl = inversion = !inversion;
                    }
                    if (neighbour[0] >= neighbour[1]) continue;
                    inversion = !inversion;
                }
                this.mMol.setBondParity(bond, this.mEZParity[bond] == 1 ^ inversion ? 1 : 2, this.mEZParityIsPseudo[bond]);
                continue;
            }
            this.mMol.setBondParity(bond, this.mEZParity[bond], this.mEZParityIsPseudo[bond]);
        }
    }

    protected void setStereoCenters() {
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            this.mMol.setAtomStereoCenter(atom, this.mIsStereoCenter[atom]);
        }
    }

    protected void setCIPParities() {
        if (this.mTHCIPParity != null) {
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                this.mMol.setAtomCIPParity(atom, this.mTHCIPParity[atom]);
            }
        }
        if (this.mEZCIPParity != null) {
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                this.mMol.setBondCIPParity(bond, this.mEZCIPParity[bond]);
            }
        }
    }

    private void cipCalcTHParity(int atom) {
        if (this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2) {
            int[] cipConnAtom;
            boolean invertedOrder = false;
            if (this.mMol.getAtomPi(atom) == 2) {
                try {
                    for (int i = 0; i < 2; ++i) {
                        int alleneAtom = this.mMol.getConnAtom(atom, i);
                        if (this.mMol.getConnAtoms(alleneAtom) != 3) continue;
                        int[] connAtom = new int[2];
                        int count = 0;
                        for (int j = 0; j < this.mMol.getConnAtoms(alleneAtom); ++j) {
                            if (this.mMol.getConnBondOrder(alleneAtom, j) != 1) continue;
                            connAtom[count++] = this.mMol.getConnAtom(alleneAtom, j);
                        }
                        if (!(this.mCanRank[connAtom[0]] > this.mCanRank[connAtom[1]] ^ this.cipComparePriority(alleneAtom, connAtom[0], connAtom[1]))) continue;
                        invertedOrder = !invertedOrder;
                    }
                }
                catch (Exception e) {
                    this.mTHCIPParity[atom] = 3;
                    return;
                }
            }
            try {
                cipConnAtom = this.cipGetOrderedConns(atom);
            }
            catch (Exception e) {
                this.mTHCIPParity[atom] = 3;
                return;
            }
            for (int i = 1; i < cipConnAtom.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (this.mCanRank[cipConnAtom[i]] >= this.mCanRank[cipConnAtom[j]]) continue;
                    invertedOrder = !invertedOrder;
                }
            }
            this.mTHCIPParity[atom] = this.mTHParity[atom] == 1 ^ invertedOrder ? 1 : 2;
        }
    }

    private void cipCalcEZParity(int bond) {
        if (!(this.mEZParity[bond] != 1 && this.mEZParity[bond] != 2 || this.mMol.isSmallRingBond(bond))) {
            boolean invertedOrder = false;
            try {
                for (int i = 0; i < 2; ++i) {
                    int bondAtom = this.mMol.getBondAtom(i, bond);
                    if (this.mMol.getConnAtoms(bondAtom) != 3) continue;
                    int[] connAtom = new int[2];
                    int count = 0;
                    for (int j = 0; j < this.mMol.getConnAtoms(bondAtom); ++j) {
                        if (this.mMol.getConnBond(bondAtom, j) == bond) continue;
                        connAtom[count++] = this.mMol.getConnAtom(bondAtom, j);
                    }
                    if (!(this.mCanRank[connAtom[0]] > this.mCanRank[connAtom[1]] ^ this.cipComparePriority(bondAtom, connAtom[0], connAtom[1]))) continue;
                    invertedOrder = !invertedOrder;
                }
            }
            catch (Exception e) {
                this.mEZCIPParity[bond] = 3;
                return;
            }
            this.mEZCIPParity[bond] = this.mEZParity[bond] == 1 ^ invertedOrder ? 1 : 2;
        }
    }

    private int[] cipGetOrderedConns(int atom) throws Exception {
        int i;
        int noOfConns = this.mMol.getAllConnAtoms(atom);
        int[] orderedConn = new int[noOfConns];
        for (i = 0; i < noOfConns; ++i) {
            orderedConn[i] = this.mMol.getConnAtom(atom, i);
        }
        for (i = noOfConns; i > 1; --i) {
            boolean found = false;
            for (int j = 1; j < i; ++j) {
                if (!this.cipComparePriority(atom, orderedConn[j - 1], orderedConn[j])) continue;
                found = true;
                int temp = orderedConn[j - 1];
                orderedConn[j - 1] = orderedConn[j];
                orderedConn[j] = temp;
            }
            if (!found) break;
        }
        return orderedConn;
    }

    private boolean cipComparePriority(int rootAtom, int atom1, int atom2) throws Exception {
        int atom;
        if (this.mMol.getAtomicNo(atom1) != this.mMol.getAtomicNo(atom2)) {
            return this.mMol.getAtomicNo(atom1) > this.mMol.getAtomicNo(atom2);
        }
        if (this.mMol.getAtomMass(atom1) != this.mMol.getAtomMass(atom2)) {
            int mass1 = this.mMol.isNaturalAbundance(atom1) ? Molecule.cRoundedMass[this.mMol.getAtomicNo(atom1)] : this.mMol.getAtomMass(atom1);
            int mass2 = this.mMol.isNaturalAbundance(atom2) ? Molecule.cRoundedMass[this.mMol.getAtomicNo(atom2)] : this.mMol.getAtomMass(atom2);
            return mass1 > mass2;
        }
        int graphSize = this.mMol.getAtoms();
        int[] graphAtom = new int[graphSize];
        int[] graphParent = new int[graphSize];
        int[] graphRank = new int[graphSize];
        boolean[] graphIsPseudo = new boolean[graphSize];
        boolean[] atomUsed = new boolean[this.mMol.getAllAtoms()];
        graphAtom[0] = rootAtom;
        graphAtom[1] = atom1;
        graphAtom[2] = atom2;
        graphParent[0] = -1;
        graphParent[1] = 0;
        graphParent[2] = 0;
        atomUsed[rootAtom] = true;
        atomUsed[atom1] = true;
        atomUsed[atom2] = true;
        int current = 1;
        int highest = 2;
        int[] levelStart = new int[64];
        levelStart[1] = 1;
        levelStart[2] = 3;
        int currentLevel = 2;
        while (current <= highest) {
            while (current < levelStart[currentLevel]) {
                int currentAtom = graphAtom[current];
                if (!graphIsPseudo[current]) {
                    int delocalizedBondCount = 0;
                    int delocalizedMeanAtomicNo = 0;
                    for (int i = 0; i < this.mMol.getConnAtoms(currentAtom); ++i) {
                        int candidate = this.mMol.getConnAtom(currentAtom, i);
                        if (highest + this.mMol.getConnBondOrder(currentAtom, i) + 1 >= graphSize) {
                            graphAtom = this.resize(graphAtom, graphSize += this.mMol.getAtoms());
                            graphParent = this.resize(graphParent, graphSize);
                            graphRank = this.resize(graphRank, graphSize);
                            graphIsPseudo = this.resize(graphIsPseudo, graphSize);
                        }
                        if (this.mMol.isDelocalizedBond(this.mMol.getConnBond(currentAtom, i))) {
                            ++delocalizedBondCount;
                            delocalizedMeanAtomicNo += this.mMol.getAtomicNo(candidate);
                        } else {
                            for (int j = 1; j < this.mMol.getConnBondOrder(currentAtom, i); ++j) {
                                graphAtom[++highest] = candidate;
                                graphParent[highest] = current;
                                graphIsPseudo[highest] = true;
                            }
                        }
                        int parentGraphIndex = graphParent[current];
                        if (candidate == graphAtom[parentGraphIndex]) continue;
                        boolean atomInParentChain = false;
                        if (atomUsed[candidate]) {
                            int parent = graphParent[parentGraphIndex];
                            while (parent != -1) {
                                if (candidate == graphAtom[parent]) {
                                    atomInParentChain = true;
                                    break;
                                }
                                parent = graphParent[parent];
                            }
                        }
                        if (atomInParentChain) {
                            graphAtom[++highest] = candidate;
                            graphParent[highest] = current;
                            graphIsPseudo[highest] = true;
                            continue;
                        }
                        graphAtom[++highest] = candidate;
                        graphParent[highest] = current;
                        atomUsed[candidate] = true;
                    }
                    if (delocalizedBondCount != 0) {
                        graphRank[++highest] = (delocalizedMeanAtomicNo << 2) / delocalizedBondCount;
                        graphParent[highest] = current;
                        graphIsPseudo[highest] = true;
                    }
                }
                if (++current != 10000) continue;
                throw new Exception("Emergency break in while loop.");
            }
            if (levelStart.length == currentLevel + 1) {
                levelStart = this.resize(levelStart, levelStart.length + 64);
            }
            levelStart[currentLevel + 1] = highest + 1;
            for (int i = levelStart[currentLevel]; i < levelStart[currentLevel + 1]; ++i) {
                if (graphRank[i] == 0) {
                    graphRank[i] = (this.mMol.getAtomicNo(graphAtom[i]) == 151 ? 1 : (this.mMol.getAtomicNo(graphAtom[i]) == 152 ? 1 : this.mMol.getAtomicNo(graphAtom[i]))) << 2;
                }
                int n = i;
                graphRank[n] = graphRank[n] + (graphRank[graphParent[i]] << 16);
            }
            this.cipUpdateParentRanking(graphIsPseudo, graphRank, graphParent, graphAtom, levelStart, currentLevel);
            if (graphRank[1] != graphRank[2]) {
                return graphRank[1] > graphRank[2];
            }
            if (currentLevel > 1) {
                this.cipCompileRelativeRanks(graphRank, graphParent, levelStart, currentLevel);
            }
            ++currentLevel;
        }
        int[] cipRank = new int[this.mMol.getAtoms()];
        boolean isotopDataFound = false;
        for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (!atomUsed[atom] || this.mMol.isNaturalAbundance(atom)) continue;
            isotopDataFound = true;
            break;
        }
        if (isotopDataFound) {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                cipRank[atom] = this.mMol.isNaturalAbundance(atom) ? Molecule.cRoundedMass[this.mMol.getAtomicNo(atom)] : this.mMol.getAtomMass(atom);
            }
            if (this.cipTryDistinguishBranches(graphIsPseudo, graphRank, graphParent, graphAtom, cipRank, levelStart, currentLevel)) {
                return graphRank[1] > graphRank[2];
            }
        }
        Arrays.fill(cipRank, 0);
        boolean ezDataFound = false;
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (!atomUsed[this.mMol.getBondAtom(0, bond)] && !atomUsed[this.mMol.getBondAtom(1, bond)]) continue;
            if (this.mEZCIPParity[bond] == 1) {
                cipRank[this.mMol.getBondAtom((int)0, (int)bond)] = 1;
                cipRank[this.mMol.getBondAtom((int)1, (int)bond)] = 1;
                ezDataFound = true;
                continue;
            }
            if (this.mEZCIPParity[bond] != 2) continue;
            cipRank[this.mMol.getBondAtom((int)0, (int)bond)] = 2;
            cipRank[this.mMol.getBondAtom((int)1, (int)bond)] = 2;
            ezDataFound = true;
        }
        if (ezDataFound && this.cipTryDistinguishBranches(graphIsPseudo, graphRank, graphParent, graphAtom, cipRank, levelStart, currentLevel)) {
            return graphRank[1] > graphRank[2];
        }
        Arrays.fill(cipRank, 0);
        boolean rsDataFound = false;
        for (int atom3 = 0; atom3 < this.mMol.getAtoms(); ++atom3) {
            if (!atomUsed[atom3]) continue;
            if (this.mTHCIPParity[atom3] == 2) {
                cipRank[atom3] = 1;
                rsDataFound = true;
                continue;
            }
            if (this.mTHCIPParity[atom3] != 1) continue;
            cipRank[atom3] = 2;
            rsDataFound = true;
        }
        if (rsDataFound && this.cipTryDistinguishBranches(graphIsPseudo, graphRank, graphParent, graphAtom, cipRank, levelStart, currentLevel)) {
            return graphRank[1] > graphRank[2];
        }
        this.mCIPParityNoDistinctionProblem = true;
        throw new Exception("no distinction applying CIP rules");
    }

    private boolean cipTryDistinguishBranches(boolean[] graphIsPseudo, int[] graphRank, int[] graphParent, int[] graphAtom, int[] cipRank, int[] levelStart, int currentLevel) {
        for (int level = 1; level < currentLevel; ++level) {
            for (int i = levelStart[level]; i < levelStart[level + 1]; ++i) {
                graphRank[i] = cipRank[graphAtom[i]] + (graphRank[graphParent[i]] << 8);
            }
            this.cipUpdateParentRanking(graphIsPseudo, graphRank, graphParent, graphAtom, levelStart, level);
            if (graphRank[1] != graphRank[2]) {
                return true;
            }
            if (level <= 1) continue;
            this.cipCompileRelativeRanks(graphRank, graphParent, levelStart, level);
        }
        return false;
    }

    private int[] resize(int[] array, int newSize) {
        int[] copy = new int[newSize];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private boolean[] resize(boolean[] array, int newSize) {
        boolean[] copy = new boolean[newSize];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private void cipUpdateParentRanking(boolean[] graphIsPseudo, int[] graphRank, int[] graphParent, int[] graphAtom, int[] levelStart, int currentLevel) {
        for (int level = currentLevel; level > 1; --level) {
            int parentCount = levelStart[level] - levelStart[level - 1];
            class RankObject {
                int parentIndex;
                int parentRank;
                int parentHCount;
                int[] childRank;

                RankObject() {
                }
            }
            RankObject[] rankObject = new RankObject[parentCount];
            int baseIndex = levelStart[level];
            for (int parent = 0; parent < parentCount; ++parent) {
                int nextBaseIndex;
                int parentIndex = levelStart[level - 1] + parent;
                for (nextBaseIndex = baseIndex; nextBaseIndex < levelStart[level + 1] && graphParent[nextBaseIndex] == parentIndex; ++nextBaseIndex) {
                }
                rankObject[parent] = new RankObject();
                rankObject[parent].parentIndex = parentIndex;
                rankObject[parent].parentRank = graphRank[parentIndex];
                rankObject[parent].parentHCount = graphIsPseudo[parentIndex] ? 0 : this.mMol.getPlainHydrogens(graphAtom[parentIndex]);
                rankObject[parent].childRank = new int[nextBaseIndex - baseIndex];
                for (int i = baseIndex; i < nextBaseIndex; ++i) {
                    rankObject[parent].childRank[i - baseIndex] = graphRank[i];
                }
                Arrays.sort(rankObject[parent].childRank);
                baseIndex = nextBaseIndex;
            }
            Comparator<RankObject> comparator = new Comparator<RankObject>(){

                @Override
                public int compare(RankObject r1, RankObject r2) {
                    if (r1.parentRank != r2.parentRank) {
                        return r1.parentRank > r2.parentRank ? 1 : -1;
                    }
                    int i1 = r1.childRank.length;
                    int i2 = r2.childRank.length;
                    int count = Math.min(i1, i2);
                    for (int i = 0; i < count; ++i) {
                        if (r1.childRank[--i1] == r2.childRank[--i2]) continue;
                        return r1.childRank[i1] > r2.childRank[i2] ? 1 : -1;
                    }
                    if (i1 != i2) {
                        return i1 > i2 ? 1 : -1;
                    }
                    if (r1.parentHCount != r2.parentHCount) {
                        return r1.parentHCount > r2.parentHCount ? 1 : -1;
                    }
                    return 0;
                }
            };
            Arrays.sort(rankObject, comparator);
            int consolidatedRank = 1;
            for (int parent = 0; parent < parentCount; ++parent) {
                graphRank[rankObject[parent].parentIndex] = consolidatedRank++;
                if (parent != parentCount - 1 && comparator.compare(rankObject[parent], rankObject[parent + 1]) == 0) continue;
            }
        }
    }

    private void cipCompileRelativeRanks(int[] graphRank, int[] graphParent, int[] levelStart, int currentLevel) {
        int levelOffset = levelStart[currentLevel];
        int count = levelStart[currentLevel + 1] - levelOffset;
        class RankObject {
            int rank;
            int parent;
            int index;

            RankObject() {
            }
        }
        RankObject[] rankObject = new RankObject[count];
        for (int i = 0; i < count; ++i) {
            rankObject[i] = new RankObject();
            rankObject[i].rank = graphRank[i + levelOffset];
            rankObject[i].parent = graphParent[i + levelOffset];
            rankObject[i].index = i + levelOffset;
        }
        Comparator<RankObject> comparator = new Comparator<RankObject>(){

            @Override
            public int compare(RankObject r1, RankObject r2) {
                if (r1.rank != r2.rank) {
                    return r1.rank > r2.rank ? 1 : -1;
                }
                return 0;
            }
        };
        for (int level = currentLevel; level > 1; --level) {
            for (int i = 0; i < count; ++i) {
                rankObject[i].rank += graphRank[rankObject[i].parent] << 16;
                rankObject[i].parent = graphParent[rankObject[i].parent];
            }
            Arrays.sort(rankObject, comparator);
            int consolidatedRank = 1;
            for (int i = 0; i < count; ++i) {
                graphRank[rankObject[i].index] = consolidatedRank++;
                if (i != count - 1 && comparator.compare(rankObject[i], rankObject[i + 1]) == 0) continue;
            }
        }
    }

    public int[] getGraphAtoms() {
        this.generateGraph();
        return this.mGraphAtom;
    }

    public int[] getGraphIndexes() {
        this.generateGraph();
        return this.mGraphIndex;
    }

    class ESRGroup
    implements Comparable<ESRGroup> {
        int[] atomList;
        int[] rankList;

        protected ESRGroup(int type, int group) {
            int atom;
            int count = 0;
            for (atom = 0; atom < Canonizer.this.mMol.getAtoms(); ++atom) {
                if (Canonizer.this.mTHESRType[atom] != type || Canonizer.this.mTHESRGroup[atom] != group) continue;
                ++count;
            }
            this.atomList = new int[count];
            this.rankList = new int[count];
            count = 0;
            for (atom = 0; atom < Canonizer.this.mMol.getAtoms(); ++atom) {
                if (Canonizer.this.mTHESRType[atom] != type || Canonizer.this.mTHESRGroup[atom] != group) continue;
                this.atomList[count] = atom;
                this.rankList[count++] = Canonizer.this.mCanRank[atom];
            }
            Arrays.sort(this.rankList);
        }

        @Override
        public int compareTo(ESRGroup g) {
            if (this.rankList.length != g.rankList.length) {
                return this.rankList.length < g.rankList.length ? -1 : 1;
            }
            for (int i = 0; i < this.rankList.length; ++i) {
                if (this.rankList[i] == g.rankList[i]) continue;
                return this.rankList[i] < g.rankList[i] ? -1 : 1;
            }
            return 0;
        }
    }
}

