/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import java.util.Arrays;

public class CanonizerBaseValue
implements Comparable<CanonizerBaseValue> {
    public long[] mValue;
    private int mAtom;
    private int mIndex;
    private int mAvailableBits;

    public CanonizerBaseValue(int size) {
        this.mValue = new long[size];
    }

    public void init(int atom) {
        this.mAtom = atom;
        this.mIndex = 0;
        this.mAvailableBits = 63;
        Arrays.fill(this.mValue, 0L);
    }

    public void add(long data) {
        int n = this.mIndex;
        this.mValue[n] = this.mValue[n] + data;
    }

    public void add(int bits, long data) {
        if (this.mAvailableBits == 0) {
            ++this.mIndex;
            this.mAvailableBits = 63;
        }
        if (this.mAvailableBits == 63) {
            int n = this.mIndex;
            this.mValue[n] = this.mValue[n] | data;
            this.mAvailableBits -= bits;
        } else if (this.mAvailableBits >= bits) {
            int n = this.mIndex;
            this.mValue[n] = this.mValue[n] << bits;
            int n2 = this.mIndex;
            this.mValue[n2] = this.mValue[n2] | data;
            this.mAvailableBits -= bits;
        } else {
            int n = this.mIndex;
            this.mValue[n] = this.mValue[n] << this.mAvailableBits;
            int n3 = this.mIndex++;
            this.mValue[n3] = this.mValue[n3] | data >> bits - this.mAvailableBits;
            this.mAvailableBits = 63 - (bits -= this.mAvailableBits);
            int n4 = this.mIndex;
            this.mValue[n4] = this.mValue[n4] | data & (long)((1 << bits) - 1);
        }
    }

    public int getAtom() {
        return this.mAtom;
    }

    @Override
    public int compareTo(CanonizerBaseValue b) {
        assert (this.mIndex == b.mIndex);
        for (int i = 0; i < this.mIndex; ++i) {
            if (this.mValue[i] == b.mValue[i]) continue;
            return this.mValue[i] < b.mValue[i] ? -1 : 1;
        }
        return this.mValue[this.mIndex] == b.mValue[this.mIndex] ? 0 : (this.mValue[this.mIndex] < b.mValue[this.mIndex] ? -1 : 1);
    }
}

