/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.CanonizerRankListComparator;
import com.actelion.research.chem.ESRGroupNormalizationInfo;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.MesoFragmentBranch;
import com.actelion.research.chem.MesoFragmentMembers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class CanonizerMesoHelper {
    private static final int REMOVE_ESR_GROUP = 1;
    private static final int SWAP_ESR_GROUPS = 2;
    private ExtendedMolecule mMol;
    private int[] mCanRankWithoutStereo;
    private byte[] mTHParity;
    private byte[] mEZParity;
    private byte[] mTHESRType;
    private byte[] mTHESRGroup;
    private int[][] mMesoFragmentAtom;
    private boolean[] mIsStereoCenter;
    private boolean[] mIsMesoFragmentMember;
    private boolean[] mTHParityRoundIsOdd;
    private boolean[] mEZParityRoundIsOdd;
    private boolean[] mTHESRTypeNeedsNormalization;
    private ArrayList<ESRGroupNormalizationInfo> mESRGroupNormalizationInfoList;

    protected CanonizerMesoHelper(ExtendedMolecule mol, int[] canRankWithoutStereo, boolean[] isStereoCenter, byte[] thParity, byte[] ezParity, byte[] thESRType, byte[] thESRGroup, byte[] ezESRType, byte[] ezESRGroup, boolean[] thParityRoundIsOdd, boolean[] ezParityRoundIsOdd, boolean[] esrTypeNeedsNormalization) {
        this.mMol = mol;
        this.mCanRankWithoutStereo = canRankWithoutStereo;
        this.mIsStereoCenter = isStereoCenter;
        this.mTHParity = thParity;
        this.mEZParity = ezParity;
        this.mTHESRType = thESRType;
        this.mTHESRGroup = thESRGroup;
        this.mTHParityRoundIsOdd = thParityRoundIsOdd;
        this.mEZParityRoundIsOdd = ezParityRoundIsOdd;
        this.mTHESRTypeNeedsNormalization = esrTypeNeedsNormalization;
        this.findMesoFragments();
    }

    protected boolean isMeso() {
        boolean meso = true;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mTHParity[atom] == 0 || this.mIsMesoFragmentMember[atom]) continue;
            meso = false;
            break;
        }
        return meso;
    }

    protected boolean isInMesoFragment(int atom) {
        return this.mIsMesoFragmentMember[atom];
    }

    private boolean mayBeMirrorAtoms(int atom1, int atom2) {
        int bond;
        if (atom1 == atom2) {
            return false;
        }
        if (this.mCanRankWithoutStereo[atom1] != this.mCanRankWithoutStereo[atom2]) {
            return false;
        }
        if (this.mTHParity[atom1] != 0) {
            if (this.mTHParity[atom1] == 3 || this.mTHParity[atom2] == 3) {
                return false;
            }
            if (this.mTHParityRoundIsOdd[atom1] ^ this.mTHParity[atom1] != this.mTHParity[atom2]) {
                return false;
            }
            if (this.mTHESRType[atom1] != this.mTHESRType[atom2] || this.mTHESRGroup[atom1] != this.mTHESRGroup[atom2]) {
                return false;
            }
        }
        if ((bond = this.mMol.getBond(atom1, atom2)) != -1) {
            if (this.mMol.getBondOrder(bond) == 1 && this.mEZParity[bond] != 0) {
                return false;
            }
            if (this.mMol.getBondOrder(bond) == 2 && this.mEZParity[bond] == 1) {
                return false;
            }
        }
        if (this.mMol.getAtomPi(atom1) == 1 && !this.mMol.isAromaticAtom(atom1)) {
            int bond1 = -1;
            for (int i = 0; i < this.mMol.getConnAtoms(atom1); ++i) {
                if (this.mMol.getConnAtom(atom1, i) == atom2 || this.mMol.getConnBondOrder(atom1, i) != 2) continue;
                bond1 = this.mMol.getConnBond(atom1, i);
                break;
            }
            int bond2 = -1;
            for (int i = 0; i < this.mMol.getConnAtoms(atom2); ++i) {
                if (this.mMol.getConnAtom(atom2, i) == atom1 || this.mMol.getConnBondOrder(atom2, i) != 2) continue;
                bond2 = this.mMol.getConnBond(atom2, i);
                break;
            }
            if (bond1 != -1 && this.mEZParity[bond1] != 0 && this.mEZParityRoundIsOdd[bond1] ^ this.mEZParity[bond1] == this.mEZParity[bond2]) {
                return false;
            }
        }
        return true;
    }

    private void findMesoFragments() {
        TreeSet<MesoFragmentMembers> mesoFragmentList = new TreeSet<MesoFragmentMembers>();
        for (int seedAtom = 0; seedAtom < this.mMol.getAtoms(); ++seedAtom) {
            if (this.mMol.getAtomPi(seedAtom) >= 2 && this.mMol.getConnAtoms(seedAtom) <= 2) continue;
            for (int i = 1; i < this.mMol.getConnAtoms(seedAtom); ++i) {
                int atom1 = this.mMol.getConnAtom(seedAtom, i);
                for (int j = 0; j < i; ++j) {
                    int atom2 = this.mMol.getConnAtom(seedAtom, j);
                    if (!this.mayBeMirrorAtoms(atom1, atom2)) continue;
                    this.tryAddNewMesoFragment(atom1, atom2, mesoFragmentList);
                }
            }
        }
        for (int seedBond = 0; seedBond < this.mMol.getBonds(); ++seedBond) {
            int atom2;
            int atom1;
            if (this.mEZParity[seedBond] != 0 && (this.mMol.getBondOrder(seedBond) != 2 || this.mEZParity[seedBond] != 2) || !this.mayBeMirrorAtoms(atom1 = this.mMol.getBondAtom(0, seedBond), atom2 = this.mMol.getBondAtom(1, seedBond))) continue;
            this.tryAddNewMesoFragment(atom1, atom2, mesoFragmentList);
        }
        this.mMesoFragmentAtom = new int[mesoFragmentList.size()][];
        this.mIsMesoFragmentMember = new boolean[this.mMol.getAtoms()];
        int fragmentNo = 0;
        for (MesoFragmentMembers members : mesoFragmentList) {
            this.mMesoFragmentAtom[fragmentNo++] = members.memberAtom;
            for (int i = 0; i < members.memberAtom.length; ++i) {
                this.mIsMesoFragmentMember[members.memberAtom[i]] = true;
            }
        }
    }

    private void tryAddNewMesoFragment(int atom1, int atom2, TreeSet<MesoFragmentMembers> mesoFragmentList) {
        MesoFragmentMembers members = this.tryFindMesoFragment(atom1, atom2);
        if (members != null && members.hasStereoCenters(this.mIsStereoCenter)) {
            mesoFragmentList.add(members);
        }
    }

    private MesoFragmentMembers tryFindMesoFragment(int atom1, int atom2) {
        int[] graphAtom = new int[this.mMol.getAtoms()];
        int[] matchAtom = new int[this.mMol.getAtoms()];
        boolean[] isOrthogonal = new boolean[this.mMol.getAtoms()];
        boolean[] hasOrthogonality = new boolean[this.mMol.getAtoms()];
        MesoFragmentBranch[] branch = new MesoFragmentBranch[this.mMol.getAtoms()];
        MesoFragmentMembers members = new MesoFragmentMembers(this.mMol.getAtoms());
        graphAtom[0] = atom1;
        matchAtom[atom1] = atom2;
        matchAtom[atom2] = -2;
        members.add(atom1);
        members.add(atom2);
        int highest = 0;
        for (int current = 0; current <= highest; ++current) {
            int i;
            int candidate;
            int i2;
            int j;
            int currentAtom = graphAtom[current];
            if (matchAtom[currentAtom] == currentAtom) {
                for (int i3 = 0; i3 < this.mMol.getConnAtoms(currentAtom); ++i3) {
                    int candidate2 = this.mMol.getConnAtom(currentAtom, i3);
                    if (members.isMember[candidate2]) continue;
                    if (this.mMol.getConnBondOrder(currentAtom, i3) == 2 && this.mMol.getAtomicNo(candidate2) < 10) {
                        graphAtom[++highest] = candidate2;
                        matchAtom[candidate2] = candidate2;
                        boolean bl = hasOrthogonality[candidate2] = hasOrthogonality[currentAtom] || this.mMol.getAtomPi(candidate2) == 2;
                        isOrthogonal[candidate2] = hasOrthogonality[currentAtom] ? !isOrthogonal[currentAtom] : false;
                        members.add(candidate2);
                        continue;
                    }
                    if (hasOrthogonality[currentAtom] && isOrthogonal[currentAtom]) {
                        int opponent = this.findMirrorAtom(candidate2, matchAtom[currentAtom], members.isMember);
                        if (opponent == -1) {
                            return null;
                        }
                        graphAtom[++highest] = candidate2;
                        matchAtom[candidate2] = opponent;
                        matchAtom[opponent] = -2;
                        hasOrthogonality[candidate2] = false;
                        members.add(candidate2);
                        members.add(opponent);
                        continue;
                    }
                    if (!this.mMol.isRingBond(this.mMol.getConnBond(currentAtom, i3))) continue;
                    graphAtom[++highest] = candidate2;
                    matchAtom[candidate2] = candidate2;
                    hasOrthogonality[candidate2] = false;
                    members.add(candidate2);
                    if (!this.isTetrahedral(candidate2) || this.mMol.getConnAtoms(candidate2) <= 2) continue;
                    boolean found = false;
                    for (j = 1; j < this.mMol.getConnAtoms(candidate2); ++j) {
                        int symAtom1 = this.mMol.getConnAtom(candidate2, j);
                        if (members.isMember[symAtom1]) continue;
                        for (int k = 0; k < j; ++k) {
                            int symAtom2 = this.mMol.getConnAtom(candidate2, k);
                            if (members.isMember[symAtom2] || !this.mayBeMirrorAtoms(symAtom1, symAtom2)) continue;
                            graphAtom[++highest] = symAtom1;
                            matchAtom[symAtom1] = symAtom2;
                            matchAtom[symAtom2] = -2;
                            hasOrthogonality[symAtom1] = false;
                            members.add(symAtom1);
                            members.add(symAtom2);
                            found = true;
                        }
                    }
                    if (found) continue;
                    return null;
                }
                continue;
            }
            boolean[] connIsOnMirrorPlane = new boolean[this.mMol.getConnAtoms(currentAtom)];
            block4: for (i2 = 0; i2 < this.mMol.getConnAtoms(currentAtom); ++i2) {
                candidate = this.mMol.getConnAtom(currentAtom, i2);
                if (members.isMember[candidate]) {
                    connIsOnMirrorPlane[i2] = matchAtom[candidate] == candidate;
                    continue;
                }
                for (j = 0; j < this.mMol.getConnAtoms(candidate); ++j) {
                    if (this.mMol.getConnAtom(candidate, j) != matchAtom[currentAtom]) continue;
                    connIsOnMirrorPlane[i2] = true;
                    continue block4;
                }
            }
            for (i2 = 0; i2 < this.mMol.getConnAtoms(currentAtom); ++i2) {
                if (!connIsOnMirrorPlane[i2]) continue;
                candidate = this.mMol.getConnAtom(currentAtom, i2);
                if (members.isMember[candidate]) {
                    if (this.mMol.getBond(candidate, matchAtom[currentAtom]) != -1) continue;
                    return null;
                }
                graphAtom[++highest] = candidate;
                matchAtom[candidate] = candidate;
                isOrthogonal[candidate] = false;
                hasOrthogonality[candidate] = true;
                members.add(candidate);
            }
            MesoFragmentBranch b = branch[currentAtom];
            int n = i = b == null ? 0 : b.neighbourIndex;
            while (i < this.mMol.getConnAtoms(currentAtom)) {
                int candidate3;
                if (!connIsOnMirrorPlane[i] && !members.isMember[candidate3 = this.mMol.getConnAtom(currentAtom, i)]) {
                    int opponent = this.findMirrorAtom(candidate3, matchAtom[currentAtom], members.isMember);
                    if (opponent == -1) {
                        return null;
                    }
                    graphAtom[++highest] = candidate3;
                    matchAtom[candidate3] = opponent;
                    matchAtom[opponent] = -2;
                    hasOrthogonality[candidate3] = false;
                    members.add(candidate3);
                    members.add(opponent);
                }
                ++i;
            }
        }
        return members;
    }

    private boolean isTetrahedral(int atom) {
        return this.mMol.getAtomicNo(atom) == 6 && this.mMol.getAtomPi(atom) == 0 || this.mMol.getAtomicNo(atom) == 7 && this.mMol.getAtomCharge(atom) == 1 || this.mMol.getAtomicNo(atom) == 14 || this.mMol.getAtomicNo(atom) == 15 && this.mMol.getConnAtoms(atom) > 2 || this.mMol.getAtomicNo(atom) == 16 && this.mMol.getConnAtoms(atom) > 2;
    }

    private int findMirrorAtom(int atom, int parentOfMirrorAtom, boolean[] isFragmentMember) {
        for (int i = 0; i < this.mMol.getConnAtoms(parentOfMirrorAtom); ++i) {
            int candidate = this.mMol.getConnAtom(parentOfMirrorAtom, i);
            if (isFragmentMember[candidate] || !this.mayBeMirrorAtoms(atom, candidate)) continue;
            return candidate;
        }
        return -1;
    }

    protected void normalizeESRGroups() {
        if (this.mMesoFragmentAtom != null) {
            ESRGroupFragmentMatrix matrix = new ESRGroupFragmentMatrix();
            this.mESRGroupNormalizationInfoList = new ArrayList();
            for (int fragment = 0; fragment < this.mMesoFragmentAtom.length; ++fragment) {
                int dependentGroupCount = matrix.getDependentGroupCount(fragment);
                if (dependentGroupCount == 0) {
                    matrix.cutTiesOfIndependentGroups(fragment);
                    int orCount = this.countESRGroups(fragment, 2);
                    int andCount = this.countESRGroups(fragment, 1);
                    boolean containsABS = this.containsTypeABSParity1Or2(fragment);
                    if (orCount == 1 && andCount == 1 && !containsABS) {
                        this.putORAtomsIntoANDGroup(fragment, matrix.newESRGroup(1));
                        this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(fragment, 1, -1, -1));
                    }
                    if (orCount > 0) {
                        if (containsABS) {
                            this.putABSAtomsIntoESRGroup(fragment, matrix.newESRGroup(2), 2);
                            ++orCount;
                        }
                        this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(fragment, 1, -1, -1));
                        continue;
                    }
                    if (andCount > 0) {
                        if (containsABS) {
                            this.putABSAtomsIntoESRGroup(fragment, matrix.newESRGroup(1), 1);
                        }
                        this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(fragment, 1, -1, -1));
                        continue;
                    }
                    if (!containsABS) continue;
                    this.putABSAtomsIntoESRGroup(fragment, matrix.newESRGroup(1), 1);
                    this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(fragment, 1, -1, -1));
                    continue;
                }
                if (dependentGroupCount != 1) continue;
                if (this.containsTypeABSParity1Or2(fragment)) {
                    int group = matrix.getDependentGroup(fragment);
                    int type = matrix.getDependentType(fragment);
                    this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(fragment, 2, group, type));
                    continue;
                }
                matrix.cutTiesOfIndependentGroups(fragment);
                this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(fragment, 1, -1, -1));
            }
        }
    }

    private boolean containsTypeABSParity1Or2(int fragment) {
        for (int i = 0; i < this.mMesoFragmentAtom[fragment].length; ++i) {
            int atom = this.mMesoFragmentAtom[fragment][i];
            if (!this.hasParity1or2(atom) || this.mTHESRType[atom] != 0) continue;
            return true;
        }
        return false;
    }

    private int countESRGroups(int fragment, int esrType) {
        int count = 0;
        int groupBits = 0;
        for (int i = 0; i < this.mMesoFragmentAtom[fragment].length; ++i) {
            int groupBit;
            int atom = this.mMesoFragmentAtom[fragment][i];
            if (this.mTHESRType[atom] != esrType || (groupBits & (groupBit = 1 << this.mTHESRGroup[atom])) != 0) continue;
            groupBits |= groupBit;
            ++count;
        }
        return count;
    }

    private boolean hasParity1or2(int atom) {
        return this.mIsStereoCenter[atom] && (this.mTHParity[atom] == 1 || this.mTHParity[atom] == 2);
    }

    private void putABSAtomsIntoESRGroup(int fragment, int esrGroup, int esrType) {
        for (int j = 0; j < this.mMesoFragmentAtom[fragment].length; ++j) {
            int atom = this.mMesoFragmentAtom[fragment][j];
            if (!this.hasParity1or2(atom) || this.mTHESRType[atom] != 0) continue;
            this.mTHESRType[atom] = (byte)esrType;
            this.mTHESRGroup[atom] = (byte)esrGroup;
        }
    }

    private void putORAtomsIntoANDGroup(int fragment, int esrGroup) {
        for (int j = 0; j < this.mMesoFragmentAtom[fragment].length; ++j) {
            int atom = this.mMesoFragmentAtom[fragment][j];
            if (this.mTHESRType[atom] != 2) continue;
            this.mTHESRType[atom] = 1;
            this.mTHESRGroup[atom] = (byte)esrGroup;
        }
    }

    protected boolean normalizeESRGroupSwappingAndRemoval(int[] canRank) {
        if (this.mESRGroupNormalizationInfoList == null) {
            return false;
        }
        boolean doneAny = false;
        for (int i = this.mESRGroupNormalizationInfoList.size() - 1; i >= 0; --i) {
            boolean done = false;
            ESRGroupNormalizationInfo info = this.mESRGroupNormalizationInfoList.get(i);
            if (info.action == 2) {
                done = this.normalizeESRGroupSwapping(info.fragment, info.group, info.type, canRank);
            } else if (info.action == 1) {
                done = this.removeESRGroupFromFragment(info.fragment, canRank);
            }
            if (!done) continue;
            this.mESRGroupNormalizationInfoList.remove(info);
            for (int j = 0; j < this.mMesoFragmentAtom[info.fragment].length; ++j) {
                int atom = this.mMesoFragmentAtom[info.fragment][j];
                this.mTHESRTypeNeedsNormalization[atom] = false;
            }
            doneAny = true;
        }
        return doneAny;
    }

    private boolean normalizeESRGroupSwapping(int fragment, int group, int type, int[] canRank) {
        int[] groupAtom = null;
        int[] absAtom = null;
        for (int i = 0; i < this.mMesoFragmentAtom[fragment].length; ++i) {
            int atom = this.mMesoFragmentAtom[fragment][i];
            if (!this.hasParity1or2(atom)) continue;
            if (this.mTHESRType[atom] == 0) {
                absAtom = CanonizerMesoHelper.addToIntArray(absAtom, (canRank[atom] << 16) + atom);
                continue;
            }
            if (this.mTHESRType[atom] != type || this.mTHESRGroup[atom] != group) continue;
            groupAtom = CanonizerMesoHelper.addToIntArray(groupAtom, (canRank[atom] << 16) + atom);
        }
        int comparison = new CanonizerRankListComparator().compare(groupAtom, absAtom);
        if (comparison == 0) {
            return false;
        }
        if (comparison < 0) {
            for (int i = 0; i < this.mMesoFragmentAtom[fragment].length; ++i) {
                int atom = this.mMesoFragmentAtom[fragment][i];
                if (!this.hasParity1or2(atom)) continue;
                if (this.mTHESRType[atom] == 0) {
                    this.mTHESRType[atom] = (byte)type;
                    this.mTHESRGroup[atom] = (byte)group;
                    continue;
                }
                if (this.mTHESRType[atom] != type || this.mTHESRGroup[atom] != group) continue;
                this.mTHESRType[atom] = 0;
                this.mTHESRGroup[atom] = -1;
            }
        }
        return true;
    }

    private boolean removeESRGroupFromFragment(int fragment, int[] canRank) {
        int atom;
        int i;
        int[] fragmentAtom = this.mMesoFragmentAtom[fragment];
        byte esrType = 1;
        for (int i2 = 0; i2 < fragmentAtom.length; ++i2) {
            int atom2 = fragmentAtom[i2];
            if (!this.mIsStereoCenter[atom2] || this.mTHESRType[atom2] != 2) continue;
            esrType = 2;
            break;
        }
        int[][] groupMember = new int[32][];
        for (i = 0; i < fragmentAtom.length; ++i) {
            atom = fragmentAtom[i];
            if (!this.mIsStereoCenter[atom] || this.mTHESRType[atom] != esrType) continue;
            groupMember[this.mTHESRGroup[atom]] = CanonizerMesoHelper.addToIntArray(groupMember[this.mTHESRGroup[atom]], (canRank[atom] << 16) + atom);
        }
        for (i = 0; i < 32; ++i) {
            if (groupMember[i] == null) continue;
            Arrays.sort(groupMember[i]);
        }
        Arrays.sort(groupMember, new CanonizerRankListComparator());
        if (new CanonizerRankListComparator().compare(groupMember[0], groupMember[1]) == 0) {
            return false;
        }
        for (i = 0; i < groupMember[0].length; ++i) {
            atom = groupMember[0][i] & 0xFFFF;
            this.mTHESRType[atom] = 0;
            this.mTHESRGroup[atom] = -1;
        }
        return true;
    }

    protected static int[] addToIntArray(int[] intArray, int intValue) {
        int[] newArray = new int[intArray == null ? 1 : intArray.length + 1];
        for (int i = 0; i < newArray.length - 1; ++i) {
            newArray[i] = intArray[i];
        }
        newArray[newArray.length - 1] = intValue;
        return newArray;
    }

    private class ESRGroupFragmentMatrix {
        private int mAndGroupCount;
        private int mOrGroupCount;
        private int mGroupCount;
        private int mNewAndGroupCount;
        private int mNewOrGroupCount;
        private boolean[][] mMatrix;
        private int[] mGroupDependence;
        private int[][] mGroupNeighbour;

        public ESRGroupFragmentMatrix() {
            int group2;
            int fragment;
            int atom;
            for (atom = 0; atom < CanonizerMesoHelper.this.mMol.getAtoms(); ++atom) {
                if (!CanonizerMesoHelper.this.hasParity1or2(atom)) continue;
                if (CanonizerMesoHelper.this.mTHESRType[atom] == 1) {
                    if (this.mAndGroupCount > CanonizerMesoHelper.this.mTHESRGroup[atom]) continue;
                    this.mAndGroupCount = 1 + CanonizerMesoHelper.this.mTHESRGroup[atom];
                    continue;
                }
                if (CanonizerMesoHelper.this.mTHESRType[atom] != 2 || this.mOrGroupCount > CanonizerMesoHelper.this.mTHESRGroup[atom]) continue;
                this.mOrGroupCount = 1 + CanonizerMesoHelper.this.mTHESRGroup[atom];
            }
            this.mGroupCount = this.mAndGroupCount + this.mOrGroupCount;
            this.mMatrix = new boolean[this.mGroupCount + 1][CanonizerMesoHelper.this.mMesoFragmentAtom.length + 1];
            for (atom = 0; atom < CanonizerMesoHelper.this.mMol.getAtoms(); ++atom) {
                if (!CanonizerMesoHelper.this.hasParity1or2(atom) || CanonizerMesoHelper.this.mIsMesoFragmentMember[atom]) continue;
                this.mMatrix[this.groupIndex((int)atom)][((CanonizerMesoHelper)CanonizerMesoHelper.this).mMesoFragmentAtom.length] = true;
            }
            for (fragment = 0; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++fragment) {
                for (int j = 0; j < CanonizerMesoHelper.this.mMesoFragmentAtom[fragment].length; ++j) {
                    int atom2 = CanonizerMesoHelper.this.mMesoFragmentAtom[fragment][j];
                    if (!CanonizerMesoHelper.this.hasParity1or2(atom2)) continue;
                    this.mMatrix[this.groupIndex((int)atom2)][fragment] = true;
                }
            }
            this.mGroupNeighbour = new int[this.mGroupCount][];
            for (fragment = 0; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++fragment) {
                for (int group1 = 1; group1 < this.mGroupCount; ++group1) {
                    if (!this.mMatrix[group1][fragment]) continue;
                    for (group2 = 0; group2 < group1; ++group2) {
                        if (!this.mMatrix[group2][fragment]) continue;
                        this.mGroupNeighbour[group1] = CanonizerMesoHelper.addToIntArray(this.mGroupNeighbour[group1], group2);
                        this.mGroupNeighbour[group2] = CanonizerMesoHelper.addToIntArray(this.mGroupNeighbour[group2], group1);
                    }
                }
            }
            this.mGroupDependence = new int[this.mGroupCount + 1];
            for (int group = 0; group < this.mGroupCount; ++group) {
                this.mGroupDependence[group] = this.mMatrix[group][CanonizerMesoHelper.this.mMesoFragmentAtom.length] ? -1 : -2;
            }
            for (fragment = 0; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++fragment) {
                if (!this.mMatrix[this.mGroupCount][fragment]) continue;
                for (int group = 0; group < this.mGroupCount; ++group) {
                    if (!this.mMatrix[group][fragment] || this.mGroupDependence[group] == fragment) continue;
                    this.mGroupDependence[group] = this.mGroupDependence[group] == -2 ? fragment : -3;
                }
            }
            for (int anchorGroup = 0; anchorGroup < this.mGroupCount; ++anchorGroup) {
                int[] chainMemberLevel;
                if (this.mGroupDependence[anchorGroup] < -1 || !this.extendAnchorChain(chainMemberLevel = new int[this.mGroupCount], anchorGroup)) continue;
                for (int group = 0; group < this.mGroupCount; ++group) {
                    if (chainMemberLevel[group] == 0) continue;
                    this.mGroupDependence[group] = -3;
                }
            }
            for (fragment = 0; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length - 1; ++fragment) {
                block13: for (int group1 = 1; group1 < this.mGroupCount; ++group1) {
                    if (!this.mMatrix[group1][fragment] || this.mGroupDependence[group1] == -3) continue;
                    for (group2 = 0; group2 < group1; ++group2) {
                        int[] cycle;
                        if (!this.mMatrix[group2][fragment] || this.mGroupDependence[group2] == -3 || (cycle = this.getDependencyCycle(group1, group2, fragment)) == null) continue;
                        for (int i = 0; i < cycle.length; ++i) {
                            this.mGroupDependence[cycle[i]] = -3;
                        }
                        this.removeOneGroupFromCycle(cycle);
                        continue block13;
                    }
                }
            }
        }

        private boolean extendAnchorChain(int[] chainMemberLevel, int anchorGroup) {
            int level;
            boolean secondAnchorFound = false;
            chainMemberLevel[anchorGroup] = level = 1;
            boolean chainExtentionFound = true;
            while (chainExtentionFound) {
                chainExtentionFound = false;
                for (int group1 = 0; group1 < this.mGroupCount; ++group1) {
                    if (chainMemberLevel[group1] != level) continue;
                    for (int group2 = 0; group2 < this.mGroupCount; ++group2) {
                        if (chainMemberLevel[group2] != 0 || !this.groupsShareFragment(group1, group2)) continue;
                        if (this.mGroupDependence[group2] == -2) {
                            chainMemberLevel[group2] = level + 1;
                            chainExtentionFound = true;
                            continue;
                        }
                        if (this.mGroupDependence[group2] == this.mGroupDependence[anchorGroup]) continue;
                        chainMemberLevel[group2] = level + 1;
                        secondAnchorFound = true;
                    }
                }
                ++level;
            }
            return secondAnchorFound;
        }

        private int[] getDependencyCycle(int group1, int group2, int startFragment) {
            for (int fragment = startFragment + 1; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++fragment) {
                if (fragment == startFragment || !this.mMatrix[group1][fragment] || !this.mMatrix[group2][fragment]) continue;
                int[] cycle = new int[]{group2, group1};
                return cycle;
            }
            int[] parentGroup = new int[this.mGroupCount];
            int[] graphLevel = new int[this.mGroupCount];
            int[] graphGroup = new int[this.mGroupCount];
            int highest = 0;
            graphGroup[0] = group1;
            graphLevel[group1] = 1;
            for (int current = 0; current <= highest; ++current) {
                for (int i = 0; i < this.mGroupNeighbour[graphGroup[current]].length; ++i) {
                    int candidate = this.mGroupNeighbour[graphGroup[current]][i];
                    if (candidate == group2) {
                        if (current == 0) continue;
                        int cycleLength = graphLevel[graphGroup[current]] + 1;
                        int[] cycle = new int[cycleLength];
                        cycle[0] = candidate;
                        cycle[1] = graphGroup[current];
                        for (int j = 2; j < cycleLength; ++j) {
                            cycle[j] = parentGroup[cycle[j - 1]];
                        }
                        return cycle;
                    }
                    if (graphLevel[candidate] != 0 || this.mGroupDependence[candidate] == -3) continue;
                    graphLevel[candidate] = graphLevel[graphGroup[current]] + 1;
                    graphGroup[++highest] = candidate;
                    parentGroup[candidate] = graphGroup[current];
                }
            }
            return null;
        }

        private void removeOneGroupFromCycle(int[] cycle) {
            int atom;
            int minRank = Integer.MAX_VALUE;
            int minGroup = -1;
            int minType = -1;
            int minGroupIndex = -1;
            for (atom = 0; atom < CanonizerMesoHelper.this.mMol.getAtoms(); ++atom) {
                if (!CanonizerMesoHelper.this.hasParity1or2(atom) || CanonizerMesoHelper.this.mTHESRType[atom] == 0) continue;
                for (int i = 0; i < cycle.length; ++i) {
                    int esrGroup = this.getESRGroup(cycle[i]);
                    int esrType = this.getESRType(cycle[i]);
                    if (CanonizerMesoHelper.this.mTHESRType[atom] != esrType || CanonizerMesoHelper.this.mTHESRGroup[atom] != esrGroup || minRank <= CanonizerMesoHelper.this.mCanRankWithoutStereo[atom] + (esrType == 1 ? 65536 : 0)) continue;
                    minRank = CanonizerMesoHelper.this.mCanRankWithoutStereo[atom] + (esrType == 1 ? 65536 : 0);
                    minGroup = esrGroup;
                    minType = esrType;
                    minGroupIndex = cycle[i];
                }
            }
            for (atom = 0; atom < CanonizerMesoHelper.this.mMol.getAtoms(); ++atom) {
                if (!CanonizerMesoHelper.this.hasParity1or2(atom) || CanonizerMesoHelper.this.mTHESRType[atom] != minType || CanonizerMesoHelper.this.mTHESRGroup[atom] != minGroup) continue;
                ((CanonizerMesoHelper)CanonizerMesoHelper.this).mTHESRType[atom] = 0;
                ((CanonizerMesoHelper)CanonizerMesoHelper.this).mTHESRGroup[atom] = -1;
            }
            for (int fragment = 0; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++fragment) {
                this.mMatrix[minGroupIndex][fragment] = false;
            }
        }

        private boolean groupsShareFragment(int group1, int group2) {
            for (int fragment = 0; fragment < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++fragment) {
                if (!this.mMatrix[group1][fragment] || !this.mMatrix[group2][fragment]) continue;
                return true;
            }
            return false;
        }

        private int getDependentGroupCount(int fragment) {
            int count = 0;
            for (int group = 0; group < this.mGroupCount; ++group) {
                if (!this.mMatrix[group][fragment] || this.mGroupDependence[group] != -3) continue;
                ++count;
            }
            return count;
        }

        private int getDependentType(int fragment) {
            for (int group = 0; group < this.mGroupCount; ++group) {
                if (!this.mMatrix[group][fragment] || this.mGroupDependence[group] != -3) continue;
                return this.getESRType(group);
            }
            return -1;
        }

        private int getDependentGroup(int fragment) {
            for (int group = 0; group < this.mGroupCount; ++group) {
                if (!this.mMatrix[group][fragment] || this.mGroupDependence[group] != -3) continue;
                return this.getESRGroup(group);
            }
            return -1;
        }

        private int getESRType(int group) {
            return group < this.mAndGroupCount ? 1 : (group < this.mGroupCount ? 2 : 0);
        }

        private int getESRGroup(int group) {
            return group < this.mAndGroupCount ? group : (group < this.mGroupCount ? group - this.mAndGroupCount : -1);
        }

        private int groupIndex(int atom) {
            byte type = CanonizerMesoHelper.this.mTHESRType[atom];
            int group = CanonizerMesoHelper.this.mTHESRGroup[atom];
            return type == 0 ? this.mGroupCount : (type == 1 ? group : this.mAndGroupCount + group);
        }

        private void cutTiesOfIndependentGroups(int fragment) {
            for (int group = 0; group < this.mGroupCount; ++group) {
                if (!this.mMatrix[group][fragment] || this.mGroupDependence[group] == -3) continue;
                for (int f = 0; f <= CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++f) {
                    if (f == fragment || !this.mMatrix[group][f]) continue;
                    this.mMatrix[group][fragment] = false;
                    int oldESRGroup = this.getESRGroup(group);
                    int newESRGroup = this.newESRGroup(this.getESRType(group));
                    for (int i = 0; i < CanonizerMesoHelper.this.mMesoFragmentAtom[fragment].length; ++i) {
                        int atom = CanonizerMesoHelper.this.mMesoFragmentAtom[fragment][i];
                        if (!CanonizerMesoHelper.this.hasParity1or2(atom) || CanonizerMesoHelper.this.mTHESRGroup[atom] != oldESRGroup) continue;
                        ((CanonizerMesoHelper)CanonizerMesoHelper.this).mTHESRGroup[atom] = (byte)newESRGroup;
                    }
                }
            }
        }

        private int newESRGroup(int esrType) {
            return esrType == 1 ? this.mAndGroupCount + this.mNewAndGroupCount++ : this.mOrGroupCount + this.mNewOrGroupCount++;
        }
    }
}

