/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Random;

public final class Coordinates
implements Serializable,
Comparable<Coordinates> {
    public double x;
    public double y;
    public double z;

    public Coordinates() {
    }

    public Coordinates(Coordinates c) {
        this(c.x, c.y, c.z);
    }

    public Coordinates(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coordinates set(Coordinates c) {
        this.set(c.x, c.y, c.z);
        return this;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getLength() {
        return this.dist();
    }

    public final double dist() {
        return Math.sqrt(this.distSq());
    }

    public final double distSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double distanceSquared(Coordinates c) {
        return (c.x - this.x) * (c.x - this.x) + (c.y - this.y) * (c.y - this.y) + (c.z - this.z) * (c.z - this.z);
    }

    public final double distSquareTo(Coordinates c) {
        return this.distanceSquared(c);
    }

    public final double distance(Coordinates c) {
        return Math.sqrt(this.distanceSquared(c));
    }

    public final double dot(Coordinates c) {
        return this.x * c.x + this.y * c.y + this.z * c.z;
    }

    public final Coordinates cross(Coordinates c) {
        return new Coordinates(this.y * c.z - this.z * c.y, -(this.x * c.z - this.z * c.x), this.x * c.y - this.y * c.x);
    }

    public final double getAngle(Coordinates c) {
        double d1 = this.distSq();
        double d2 = c.distSq();
        if (d1 == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d = this.dot(c) / Math.sqrt(d1 * d2);
        if (d >= 1.0) {
            return 0.0;
        }
        if (d <= -1.0) {
            return Math.PI;
        }
        return Math.acos(d);
    }

    public double getAngleXY(Coordinates c) {
        double dx = c.x - this.x;
        double dy = c.y - this.y;
        if (dy == 0.0) {
            return dx > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double angle = Math.atan(dx / dy);
        if (dy < 0.0) {
            return dx < 0.0 ? angle - Math.PI : angle + Math.PI;
        }
        return angle;
    }

    public final double getDihedral(Coordinates c2, Coordinates c3, Coordinates c4) {
        return Coordinates.getDihedral(this, c2, c3, c4);
    }

    public final Coordinates subC(Coordinates c) {
        return new Coordinates(this.x - c.x, this.y - c.y, this.z - c.z);
    }

    public final Coordinates addC(Coordinates c) {
        return new Coordinates(this.x + c.x, this.y + c.y, this.z + c.z);
    }

    public final Coordinates scaleC(double scale) {
        return new Coordinates(this.x * scale, this.y * scale, this.z * scale);
    }

    public final Coordinates sub(Coordinates c) {
        this.x -= c.x;
        this.y -= c.y;
        this.z -= c.z;
        return this;
    }

    public final Coordinates add(Coordinates c) {
        this.x += c.x;
        this.y += c.y;
        this.z += c.z;
        return this;
    }

    public void add(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public final Coordinates scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Coordinates rotate(double[][] m) {
        double x0 = this.x;
        double y0 = this.y;
        double z0 = this.z;
        this.x = x0 * m[0][0] + y0 * m[1][0] + z0 * m[2][0];
        this.y = x0 * m[0][1] + y0 * m[1][1] + z0 * m[2][1];
        this.z = x0 * m[0][2] + y0 * m[1][2] + z0 * m[2][2];
        return this;
    }

    public Coordinates rotateC(double[][] m) {
        return new Coordinates(this.x * m[0][0] + this.y * m[1][0] + this.z * m[2][0], this.x * m[0][1] + this.y * m[1][1] + this.z * m[2][1], this.x * m[0][2] + this.y * m[1][2] + this.z * m[2][2]);
    }

    public final Coordinates rotate(Coordinates normal, double theta) {
        if (Math.abs(normal.x * normal.x + normal.y * normal.y + normal.z * normal.z - 1.0) > 1.0E-6) {
            throw new IllegalArgumentException("normal needs to a unit vector: " + normal);
        }
        double x = normal.x;
        double y = normal.y;
        double z = normal.z;
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double t = 1.0 - c;
        Coordinates opp = new Coordinates((t * x * x + c) * this.x + (t * x * y + s * z) * this.y + (t * x * z - s * y) * this.z, (t * x * y - s * z) * this.x + (t * y * y + c) * this.y + (t * y * z + s * x) * this.z, (t * x * z + s * y) * this.x + (t * z * y - s * x) * this.y + (t * z * z + c) * this.z);
        return opp;
    }

    public final Coordinates unitC() {
        double d = this.dist();
        if (d == 0.0) {
            System.err.println("Cannot call unitC() on a null vector");
            return new Coordinates(1.0, 0.0, 0.0);
        }
        return new Coordinates(this.x / d, this.y / d, this.z / d);
    }

    public final Coordinates unit() {
        double d = this.dist();
        if (d == 0.0) {
            System.err.println("Cannot call unit() on a null vector. Returned (1,0,0)");
            this.x = 1.0;
            this.y = 0.0;
            this.z = 0.0;
            return this;
        }
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public Coordinates center(Coordinates c) {
        this.x = (this.x + c.x) / 2.0;
        this.y = (this.y + c.y) / 2.0;
        this.z = (this.z + c.z) / 2.0;
        return this;
    }

    public void center(Coordinates c1, Coordinates c2) {
        this.x = (c1.x + c2.x) / 2.0;
        this.y = (c1.y + c2.y) / 2.0;
        this.z = (c1.z + c2.z) / 2.0;
    }

    public Coordinates between(Coordinates c1, Coordinates c2, double f) {
        this.x = c1.x + f * (c2.x - c1.x);
        this.y = c1.y + f * (c2.y - c1.y);
        this.z = c1.z + f * (c2.z - c1.z);
        return this;
    }

    public final boolean insideBounds(Coordinates[] bounds) {
        return bounds != null && bounds[0].x <= this.x && this.x <= bounds[1].x && bounds[0].y <= this.y && this.y <= bounds[1].y && bounds[0].z <= this.z && this.z <= bounds[1].z;
    }

    public final String toString() {
        DecimalFormat df = new DecimalFormat("0.00");
        return "[" + df.format(this.x) + ", " + df.format(this.y) + ", " + df.format(this.z) + "]";
    }

    public final String toStringSpaceDelimited() {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(this.x) + " " + df.format(this.y) + " " + df.format(this.z);
    }

    public final boolean equals(Object o) {
        if (o == null || !(o instanceof Coordinates)) {
            return false;
        }
        Coordinates c = (Coordinates)o;
        return Math.abs(c.x - this.x) + Math.abs(c.y - this.y) + Math.abs(c.z - this.z) < 1.0E-6;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public final Coordinates min(Coordinates c) {
        return new Coordinates(Math.min(this.x, c.x), Math.min(this.y, c.y), Math.min(this.z, c.z));
    }

    public final Coordinates max(Coordinates c) {
        return new Coordinates(Math.max(this.x, c.x), Math.max(this.y, c.y), Math.max(this.z, c.z));
    }

    public double cosAngle(Coordinates c) {
        double d = this.dist() * c.dist();
        if (d <= 0.0) {
            return 0.0;
        }
        return this.dot(c) / d;
    }

    public static final Coordinates min(Coordinates[] c) {
        Coordinates min = new Coordinates(c[0]);
        for (int i = 1; i < c.length; ++i) {
            min.x = Math.min(c[i].x, min.x);
            min.y = Math.min(c[i].y, min.y);
            min.z = Math.min(c[i].z, min.z);
        }
        return min;
    }

    public static final Coordinates max(Coordinates[] c) {
        Coordinates max = new Coordinates(c[0]);
        for (int i = 1; i < c.length; ++i) {
            max.x = Math.max(c[i].x, max.x);
            max.y = Math.max(c[i].y, max.y);
            max.z = Math.max(c[i].z, max.z);
        }
        return max;
    }

    public static final Coordinates createBarycenter(Coordinates ... coords) {
        if (coords == null) {
            throw new IllegalArgumentException("The coordinates are null");
        }
        Coordinates res = new Coordinates();
        for (int i = 0; i < coords.length; ++i) {
            res.x += coords[i].x;
            res.y += coords[i].y;
            res.z += coords[i].z;
        }
        res.x /= (double)coords.length;
        res.y /= (double)coords.length;
        res.z /= (double)coords.length;
        return res;
    }

    public static final Coordinates getMirror(Coordinates p, Coordinates c1, Coordinates c2, Coordinates c3) {
        Coordinates r31 = new Coordinates(c3);
        r31.sub(c1);
        Coordinates r21 = new Coordinates(c2);
        r21.sub(c1);
        Coordinates c = r31.cross(r21);
        if (c.distSq() < 0.05) {
            return new Coordinates(p);
        }
        Coordinates n = c.unitC();
        Coordinates pc1 = new Coordinates(c1);
        pc1.sub(p);
        double l = pc1.dot(n);
        n.scale(2.0 * l);
        Coordinates pp = new Coordinates(p);
        pp.add(n);
        return pp;
    }

    public static final double getDihedral(Coordinates c1, Coordinates c2, Coordinates c3, Coordinates c4) {
        Coordinates v1 = c2.subC(c1);
        Coordinates v2 = c3.subC(c2);
        Coordinates v3 = c4.subC(c3);
        Coordinates n1 = v1.cross(v2);
        Coordinates n2 = v2.cross(v3);
        return -Math.atan2(v2.getLength() * v1.dot(n2), n1.dot(n2));
    }

    @Override
    public int compareTo(Coordinates o) {
        if (this.x != o.x) {
            return this.x < o.x ? -1 : 1;
        }
        if (this.y != o.y) {
            return this.y < o.y ? -1 : 1;
        }
        if (this.z != o.z) {
            return this.z < o.z ? -1 : 1;
        }
        return 0;
    }

    public static final Coordinates random() {
        Random random = new Random();
        return new Coordinates(random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 2.0 - 1.0);
    }

    public static double getRmsd(Coordinates[] c1, Coordinates[] c2) {
        return Coordinates.getRmsd(c1, c2, Math.min(c1.length, c2.length));
    }

    public static double getRmsd(Coordinates[] c1, Coordinates[] c2, int l) {
        double sum = 0.0;
        for (int i = 0; i < l; ++i) {
            sum += c1[i].distanceSquared(c2[i]);
        }
        return l > 0 ? Math.sqrt(sum / (double)l) : 0.0;
    }
}

