/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPolygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class Depictor2D
extends AbstractDepictor<Graphics2D> {
    private static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private int mpTextSize;
    private double mCurrentStringWidth;
    private float mLineWidth;
    private ArrayList<Font> mFonts;
    private String mCurrentString;
    private Font mCurrentFont;
    private GlyphVector mCurrentGlyphVector;

    public Depictor2D(StereoMolecule mol) {
        super(mol);
    }

    public Depictor2D(StereoMolecule mol, int displayMode) {
        super(mol, displayMode);
    }

    @Override
    protected void init() {
        super.init();
        this.mFonts = new ArrayList();
        this.mLineWidth = 1.0f;
    }

    @Override
    protected void drawBlackLine(AbstractDepictor.DepictorLine theLine) {
        if (isMac) {
            ((Graphics2D)this.mContext).draw(new Line2D.Double(theLine.x1 - 0.5, theLine.y1 - 0.5, theLine.x2 - 0.5, theLine.y2 - 0.5));
        } else {
            ((Graphics2D)this.mContext).draw(new Line2D.Double(theLine.x1, theLine.y1, theLine.x2, theLine.y2));
        }
    }

    @Override
    protected void drawDottedLine(AbstractDepictor.DepictorLine theLine) {
        Stroke stroke = ((Graphics2D)this.mContext).getStroke();
        ((Graphics2D)this.mContext).setStroke(new BasicStroke(this.mLineWidth, 1, 1, this.mLineWidth, new float[]{3.0f * this.mLineWidth}, 0.0f));
        this.drawBlackLine(theLine);
        ((Graphics2D)this.mContext).setStroke(stroke);
    }

    @Override
    protected void drawString(String theString, double x, double y) {
        double strWidth = this.getStringWidth(theString);
        ((Graphics2D)this.mContext).drawGlyphVector(this.mCurrentGlyphVector, (float)(x - strWidth / 2.0), (float)(y + (double)this.mpTextSize / 3.0));
    }

    @Override
    protected void drawPolygon(GenericPolygon p) {
        int i;
        GeneralPath polygon = new GeneralPath(1, p.getSize());
        polygon.moveTo(p.getX(0), p.getY(0));
        for (i = 1; i < p.getSize(); ++i) {
            polygon.lineTo(p.getX(i), p.getY(i));
        }
        polygon.closePath();
        ((Graphics2D)this.mContext).fill(polygon);
        if (isMac) {
            polygon = new GeneralPath(1, p.getSize());
            polygon.moveTo(p.getX(0) - 0.5, p.getY(0) - 0.5);
            for (i = 1; i < p.getSize(); ++i) {
                polygon.lineTo(p.getX(i) - 0.5, p.getY(i) - 0.5);
            }
            polygon.closePath();
        }
        ((Graphics2D)this.mContext).draw(polygon);
    }

    @Override
    protected void fillCircle(double x, double y, double d) {
        if (isMac) {
            ((Graphics2D)this.mContext).fill(new Ellipse2D.Double(x - 0.5, y - 0.5, d, d));
        } else {
            ((Graphics2D)this.mContext).fill(new Ellipse2D.Double(x, y, d, d));
        }
    }

    @Override
    protected double getStringWidth(String theString) {
        if (!(this.mContext == null || theString.equals(this.mCurrentString) && this.mCurrentFont == ((Graphics2D)this.mContext).getFont())) {
            this.mCurrentString = theString;
            this.mCurrentFont = ((Graphics2D)this.mContext).getFont();
            this.mCurrentGlyphVector = ((Graphics2D)this.mContext).getFont().createGlyphVector(((Graphics2D)this.mContext).getFontRenderContext(), theString);
            this.mCurrentStringWidth = this.mCurrentGlyphVector.getLogicalBounds().getWidth();
        }
        return this.mCurrentStringWidth;
    }

    @Override
    protected void setTextSize(int theSize) {
        this.mpTextSize = theSize;
        if (this.mContext != null && ((Graphics2D)this.mContext).getFont().getSize() != theSize) {
            for (int i = 0; i < this.mFonts.size(); ++i) {
                if (this.mFonts.get(i).getSize() != theSize) continue;
                ((Graphics2D)this.mContext).setFont(this.mFonts.get(i));
                return;
            }
            Font newFont = ((Graphics2D)this.mContext).getFont().deriveFont(0, theSize);
            this.mFonts.add(newFont);
            ((Graphics2D)this.mContext).setFont(newFont);
        }
    }

    @Override
    public int getTextSize() {
        return this.mpTextSize;
    }

    @Override
    protected double getLineWidth() {
        return this.mLineWidth;
    }

    @Override
    protected void setLineWidth(double lineWidth) {
        this.mLineWidth = (float)lineWidth;
        ((Graphics2D)this.mContext).setStroke(new BasicStroke((float)lineWidth, 1, 1));
    }

    @Override
    protected void setRGB(int rgb) {
        Color color = new Color(rgb);
        ((Graphics2D)this.mContext).setColor(color);
        ((Graphics2D)this.mContext).setPaint(color);
    }
}

