/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;

public class DepictorTransformation {
    private double mOffsetX;
    private double mOffsetY;
    private double mScaling;

    public DepictorTransformation() {
        this.clear();
    }

    public DepictorTransformation(DepictorTransformation t) {
        this.mScaling = t.mScaling;
        this.mOffsetX = t.mOffsetX;
        this.mOffsetY = t.mOffsetY;
    }

    public DepictorTransformation(double scaling, double offsetX, double offsetY) {
        this.mScaling = scaling;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
    }

    public DepictorTransformation(GenericRectangle bounds, GenericRectangle view, double averageBondLength, int mode) {
        this.clear();
        if (view != null) {
            if ((mode & 0x30000) == 0) {
                if (!view.contains(bounds)) {
                    if (bounds.width > view.width || bounds.height > view.height) {
                        double hScaling = view.width / bounds.width;
                        double vScaling = view.height / bounds.height;
                        this.mScaling = Math.min(hScaling, vScaling);
                    }
                    if (bounds.x * this.mScaling < view.x) {
                        this.mOffsetX = view.x - bounds.x * this.mScaling;
                    } else if ((bounds.x + bounds.width) * this.mScaling > view.x + view.width) {
                        this.mOffsetX = view.x + view.width - (bounds.x + bounds.width) * this.mScaling;
                    }
                    if (bounds.y * this.mScaling < view.y) {
                        this.mOffsetY = view.y - bounds.y * this.mScaling;
                    } else if ((bounds.y + bounds.height) * this.mScaling > view.y + view.height) {
                        this.mOffsetY = view.y + view.height - (bounds.y + bounds.height) * this.mScaling;
                    }
                }
            } else {
                double hScaling = view.width / bounds.width;
                double vScaling = view.height / bounds.height;
                double maxAVBL = mode & 0xFFFF;
                if (maxAVBL == 0.0) {
                    maxAVBL = 24.0;
                } else if ((mode & 0x20000) != 0) {
                    maxAVBL /= 256.0;
                }
                double bScaling = maxAVBL / averageBondLength;
                this.mScaling = Math.min(bScaling, Math.min(hScaling, vScaling));
                this.mOffsetX = view.x + view.width / 2.0 - this.mScaling * (bounds.x + bounds.width / 2.0);
                this.mOffsetY = view.y + view.height / 2.0 - this.mScaling * (bounds.y + bounds.height / 2.0);
            }
        } else if ((mode & 0x10000) != 0) {
            double maxAVBL = (mode & 0xFFFF) != 0 ? (double)(mode & 0xFFFF) : 24.0;
            this.mScaling = maxAVBL / averageBondLength;
        }
    }

    public void clear() {
        this.mOffsetX = 0.0;
        this.mOffsetY = 0.0;
        this.mScaling = 1.0;
    }

    public double transformX(double x) {
        return x * this.mScaling + this.mOffsetX;
    }

    public double transformY(double y) {
        return y * this.mScaling + this.mOffsetY;
    }

    public double getScaling() {
        return this.mScaling;
    }

    public double getOffsetX() {
        return this.mOffsetX;
    }

    public double getOffsetY() {
        return this.mOffsetY;
    }

    public void move(double dx, double dy) {
        this.mOffsetX += dx;
        this.mOffsetY += dy;
    }

    public void setScaling(double scale) {
        this.mScaling = scale;
    }

    public boolean isVoidTransformation() {
        return this.mScaling == 1.0 && this.mOffsetX == 0.0 && this.mOffsetY == 0.0;
    }

    public void applyTo(DepictorTransformation t) {
        t.mScaling *= this.mScaling;
        t.mOffsetX = t.mOffsetX * this.mScaling + this.mOffsetX;
        t.mOffsetY = t.mOffsetY * this.mScaling + this.mOffsetY;
    }

    public void applyTo(GenericPoint p) {
        p.x = p.x * this.mScaling + this.mOffsetX;
        p.y = p.y * this.mScaling + this.mOffsetY;
    }

    public void applyTo(GenericRectangle r) {
        r.x = r.x * this.mScaling + this.mOffsetX;
        r.y = r.y * this.mScaling + this.mOffsetY;
        r.width *= this.mScaling;
        r.height *= this.mScaling;
    }

    public void applyTo(Molecule m) {
        m.scaleCoords(this.mScaling);
        m.translateCoords(this.mOffsetX, this.mOffsetY);
    }

    public void applyTo(AbstractDrawingObject o) {
        o.scale(this.mScaling);
        o.move(this.mOffsetX, this.mOffsetY);
    }

    public DepictorTransformation getInverseTransformation() {
        DepictorTransformation t = new DepictorTransformation();
        t.mScaling = 1.0 / this.mScaling;
        t.mOffsetX = -this.mOffsetX / this.mScaling;
        t.mOffsetY = -this.mOffsetY / this.mScaling;
        return t;
    }

    public String toString() {
        return "DepictorTransformation Offset: " + this.mOffsetX + "," + this.mOffsetY + " Scaling: " + this.mScaling;
    }
}

