/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;

class EZHalfParity {
    ExtendedMolecule mMol;
    int mCentralAxialAtom;
    int mRemoteAxialAtom;
    int mHighConn;
    int mLowConn;
    int mValue;
    boolean mStereoBondFound;
    boolean mRanksEqual;
    boolean mInSameFragment;

    protected EZHalfParity(ExtendedMolecule mol, int[] rank, int atom1, int atom2) {
        this.mMol = mol;
        this.mRemoteAxialAtom = atom1;
        this.mCentralAxialAtom = atom2;
        int highRank = -1;
        for (int i = 0; i < this.mMol.getAllConnAtoms(this.mCentralAxialAtom); ++i) {
            int connAtom = this.mMol.getConnAtom(this.mCentralAxialAtom, i);
            int connBond = this.mMol.getConnBond(this.mCentralAxialAtom, i);
            if (connAtom == this.mRemoteAxialAtom) {
                if (this.mMol.getBondType(connBond) != 26) continue;
                this.mValue = -1;
                continue;
            }
            if (this.mMol.isStereoBond(connBond, this.mCentralAxialAtom)) {
                if (this.mStereoBondFound) {
                    mol.setStereoProblem(atom2);
                }
                this.mStereoBondFound = true;
            }
            if (highRank == rank[connAtom]) {
                this.mLowConn = connAtom;
                this.mRanksEqual = true;
                this.mInSameFragment = this.mMol.isRingBond(connBond);
                continue;
            }
            if (highRank < rank[connAtom]) {
                highRank = rank[connAtom];
                this.mLowConn = this.mHighConn;
                this.mHighConn = connAtom;
                continue;
            }
            this.mLowConn = connAtom;
        }
    }

    protected int getValue() {
        if (this.mValue != 0) {
            return this.mValue;
        }
        if (this.mStereoBondFound && this.mMol.getAtomicNo(this.mCentralAxialAtom) != 15 && this.mMol.getAtomicNo(this.mCentralAxialAtom) != 16) {
            for (int i = 0; i < this.mMol.getAllConnAtoms(this.mCentralAxialAtom); ++i) {
                int connBond = this.mMol.getConnBond(this.mCentralAxialAtom, i);
                if (!this.mMol.isStereoBond(connBond, this.mCentralAxialAtom)) continue;
                this.mValue = this.mMol.getConnAtom(this.mCentralAxialAtom, i) == this.mHighConn ? (this.mMol.getBondType(connBond) == 17 ? 3 : 1) : (this.mMol.getBondType(connBond) == 17 ? 1 : 3);
                return this.mValue;
            }
        }
        double angleDB = this.mMol.getBondAngle(this.mCentralAxialAtom, this.mRemoteAxialAtom);
        double angleHigh = this.mMol.getBondAngle(this.mCentralAxialAtom, this.mHighConn);
        if (angleHigh < angleDB) {
            angleHigh += Math.PI * 2;
        }
        if (this.mMol.getAllConnAtoms(this.mCentralAxialAtom) == 2) {
            double angleDif = angleHigh - angleDB;
            if (angleDif > 3.0915926535897933 && angleDif < 3.191592653589793) {
                this.mValue = -1;
                return this.mValue;
            }
            this.mValue = angleDif < Math.PI ? 4 : 2;
            return this.mValue;
        }
        double angleOther = this.mMol.getBondAngle(this.mCentralAxialAtom, this.mLowConn);
        if (angleOther < angleDB) {
            angleOther += Math.PI * 2;
        }
        this.mValue = angleOther < angleHigh ? 2 : 4;
        return this.mValue;
    }
}

