/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionArrow;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.Color;
import java.awt.Point;

public class ExtendedDepictor {
    public static final int TYPE_MOLECULES = 0;
    public static final int TYPE_REACTION = 1;
    public static final int TYPE_MARKUSH = 2;
    private StereoMolecule[] mMolecule;
    private StereoMolecule[] mCatalyst;
    private Reaction mReaction;
    private GenericDepictor[] mDepictor;
    private GenericDepictor[] mCatalystDepictor;
    private DrawingObjectList mDrawingObjectList;
    private int mDisplayMode;
    private int mReactantCount;
    private int mMarkushCoreCount;
    private int mChemistryType;
    private boolean mReactionLayoutNeeded;
    private DepictorTransformation mTransformation;
    private int mFragmentNoColor;

    public ExtendedDepictor(StereoMolecule mol, DrawingObjectList drawingObjectList) {
        if (mol != null) {
            this.mMolecule = new StereoMolecule[1];
            this.mMolecule[0] = mol;
        }
        this.mChemistryType = 0;
        this.mDrawingObjectList = drawingObjectList;
        this.initialize();
    }

    public ExtendedDepictor(StereoMolecule[] mol, DrawingObjectList drawingObjectList) {
        this.mMolecule = mol;
        this.mChemistryType = 0;
        this.mDrawingObjectList = drawingObjectList;
        this.initialize();
    }

    public ExtendedDepictor(StereoMolecule[] mol, int markushCoreCount, DrawingObjectList drawingObjectList) {
        this.mMolecule = mol;
        this.mChemistryType = 2;
        this.mDrawingObjectList = drawingObjectList;
        this.mMarkushCoreCount = markushCoreCount;
        this.initialize();
    }

    public ExtendedDepictor(Reaction reaction, DrawingObjectList drawingObjectList, boolean layoutReaction) {
        this.mReaction = reaction;
        if (reaction != null) {
            int i;
            this.mMolecule = new StereoMolecule[reaction.getMolecules()];
            for (i = 0; i < reaction.getMolecules(); ++i) {
                this.mMolecule[i] = reaction.getMolecule(i);
            }
            this.mReactantCount = reaction.getReactants();
            this.mCatalyst = new StereoMolecule[reaction.getCatalysts()];
            for (i = 0; i < reaction.getCatalysts(); ++i) {
                this.mCatalyst[i] = reaction.getCatalyst(i);
            }
            this.mReactionLayoutNeeded = layoutReaction;
        }
        this.mChemistryType = 1;
        this.mDrawingObjectList = drawingObjectList;
        this.initialize();
    }

    public boolean isFragment() {
        if (this.mChemistryType == 1) {
            return this.mReaction == null ? false : this.mReaction.isFragment();
        }
        if (this.mMolecule == null) {
            return false;
        }
        for (StereoMolecule mol : this.mMolecule) {
            if (!mol.isFragment()) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        int i;
        this.mTransformation = new DepictorTransformation();
        if (this.mMolecule != null) {
            this.mDepictor = new GenericDepictor[this.mMolecule.length];
            for (i = 0; i < this.mMolecule.length; ++i) {
                this.mDepictor[i] = new GenericDepictor(this.mMolecule[i]);
            }
        }
        if (this.mCatalyst != null) {
            this.mCatalystDepictor = new GenericDepictor[this.mCatalyst.length];
            for (i = 0; i < this.mCatalyst.length; ++i) {
                this.mCatalystDepictor[i] = new GenericDepictor(this.mCatalyst[i]);
            }
        }
    }

    public void setDisplayMode(int displayMode) {
        this.mDisplayMode = displayMode;
    }

    public void setFragmentNoColor(int argb) {
        this.mFragmentNoColor = argb;
    }

    public int getMoleculeCount() {
        return this.mMolecule == null ? 0 : this.mMolecule.length;
    }

    public StereoMolecule getMolecule(int i) {
        return this.mMolecule[i];
    }

    public Reaction getReaction() {
        return this.mReaction;
    }

    public AbstractDepictor getMoleculeDepictor(int i) {
        return this.mDepictor[i];
    }

    @Deprecated
    public void setForegroundColor(Color foreGround, Color background) {
        this.setForegroundColor(foreGround.getRGB(), background.getRGB());
    }

    public void setForegroundColor(int foreground, int background) {
        if (this.mDepictor != null) {
            for (GenericDepictor d : this.mDepictor) {
                d.setForegroundColor(foreground, background);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor d : this.mCatalystDepictor) {
                d.setForegroundColor(foreground, background);
            }
        }
    }

    public void setOverruleColor(Color foreGround, Color background) {
        if (this.mDepictor != null) {
            for (GenericDepictor d : this.mDepictor) {
                d.setOverruleColor(foreGround, background);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor d : this.mCatalystDepictor) {
                d.setOverruleColor(foreGround, background);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GenericDrawContext context) {
        int saveRGB = context.getRGB();
        int fontSize = context.getFontSize();
        try {
            this.paintFragmentNumbers(context);
            this.paintStructures(context);
            this.paintDrawingObjects(context);
        }
        finally {
            context.setRGB(saveRGB);
            context.setFont(fontSize, false, false);
        }
    }

    public void paintFragmentNumbers(GenericDrawContext context) {
        if (this.mFragmentNoColor != 0 && this.mMolecule != null) {
            double averageBondLength = this.calculateAverageBondLength();
            context.setRGB(this.mFragmentNoColor);
            context.setFont((int)(1.6 * averageBondLength), true, false);
            for (int i = 0; i < this.mMolecule.length; ++i) {
                if (this.mMolecule[i].getAllAtoms() == 0) continue;
                Point cog = new Point();
                for (int atom = 0; atom < this.mMolecule[i].getAllAtoms(); ++atom) {
                    cog.x = (int)((double)cog.x + this.mMolecule[i].getAtomX(atom));
                    cog.y = (int)((double)cog.y + this.mMolecule[i].getAtomY(atom));
                }
                cog.x /= this.mMolecule[i].getAllAtoms();
                cog.y /= this.mMolecule[i].getAllAtoms();
                cog.x = (int)this.mDepictor[i].getTransformation().transformX(cog.x);
                cog.y = (int)this.mDepictor[i].getTransformation().transformY(cog.y);
                String str = this.mChemistryType == 0 ? "F" + (i + 1) : (this.mChemistryType == 2 ? (i < this.mMarkushCoreCount ? "" + (char)(65 + i) : "R" + (i + 1 - this.mMarkushCoreCount)) : (this.mChemistryType == 1 ? (i < this.mReactantCount ? "" + (char)(65 + i) : "P" + (i + 1 - this.mReactantCount)) : "?" + (i + 1)));
                context.drawCenteredString(cog.x, cog.y, str);
            }
        }
    }

    public void paintStructures(GenericDrawContext context) {
        int i;
        if (this.mDepictor != null) {
            for (i = 0; i < this.mDepictor.length; ++i) {
                this.mDepictor[i].setDisplayMode(this.mDisplayMode);
                this.mDepictor[i].paint(context);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (i = 0; i < this.mCatalystDepictor.length; ++i) {
                this.mCatalystDepictor[i].paint(context);
            }
        }
    }

    public void paintDrawingObjects(GenericDrawContext context) {
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject object : this.mDrawingObjectList) {
                object.draw(context, this.mTransformation);
            }
        }
    }

    public DepictorTransformation updateCoords(GenericDrawContext context, GenericRectangle viewRect, int mode) {
        int i;
        this.validateView(context, viewRect, mode);
        if (this.mTransformation.isVoidTransformation()) {
            return null;
        }
        if (this.mMolecule != null) {
            for (i = 0; i < this.mMolecule.length; ++i) {
                this.mTransformation.applyTo(this.mMolecule[i]);
            }
        }
        if (this.mDrawingObjectList != null) {
            for (i = 0; i < this.mDrawingObjectList.size(); ++i) {
                this.mTransformation.applyTo((AbstractDrawingObject)this.mDrawingObjectList.get(i));
            }
        }
        if (this.mDepictor != null) {
            for (i = 0; i < this.mDepictor.length; ++i) {
                this.mDepictor[i].getTransformation().clear();
            }
        }
        if (this.mCatalystDepictor != null) {
            for (i = 0; i < this.mCatalystDepictor.length; ++i) {
                this.mCatalystDepictor[i].getTransformation().clear();
            }
        }
        DepictorTransformation t = this.mTransformation;
        this.mTransformation = new DepictorTransformation();
        return t;
    }

    public DepictorTransformation validateView(GenericDrawContext context, GenericRectangle viewRect, int mode) {
        int i;
        if (this.mReactionLayoutNeeded) {
            this.layoutReaction(context);
        }
        GenericRectangle boundingRect = null;
        if (this.mDepictor != null) {
            for (i = 0; i < this.mDepictor.length; ++i) {
                this.mDepictor[i].validateView(context, null, 0);
                boundingRect = boundingRect == null ? this.mDepictor[i].getBoundingRect() : boundingRect.union(this.mDepictor[i].getBoundingRect());
            }
        }
        if (this.mCatalystDepictor != null) {
            for (i = 0; i < this.mCatalystDepictor.length; ++i) {
                this.mCatalystDepictor[i].validateView(context, null, 0);
                boundingRect = boundingRect == null ? this.mCatalystDepictor[i].getBoundingRect() : boundingRect.union(this.mCatalystDepictor[i].getBoundingRect());
            }
        }
        if (this.mDrawingObjectList != null) {
            for (i = 0; i < this.mDrawingObjectList.size(); ++i) {
                GenericRectangle objectBounds = ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).getBoundingRect(context);
                this.mTransformation.applyTo(objectBounds);
                boundingRect = boundingRect == null ? objectBounds : boundingRect.union(objectBounds);
            }
        }
        if (boundingRect == null) {
            return null;
        }
        double avbl = this.calculateAverageBondLength();
        DepictorTransformation t = new DepictorTransformation(boundingRect, viewRect, avbl, mode);
        if (!t.isVoidTransformation()) {
            int i2;
            t.applyTo(this.mTransformation);
            if (this.mDepictor != null) {
                for (i2 = 0; i2 < this.mDepictor.length; ++i2) {
                    this.mDepictor[i2].applyTransformation(t);
                }
            }
            if (this.mCatalystDepictor != null) {
                for (i2 = 0; i2 < this.mCatalystDepictor.length; ++i2) {
                    this.mCatalystDepictor[i2].applyTransformation(t);
                }
            }
            return t;
        }
        return null;
    }

    private double calculateAverageBondLength() {
        float averageBondLength = 0.0f;
        int bondCount = 0;
        if (this.mMolecule != null) {
            for (int i = 0; i < this.mMolecule.length; ++i) {
                if (this.mMolecule[i].getAllAtoms() == 0) continue;
                if (this.mMolecule[i].getAllBonds() != 0) {
                    averageBondLength = (float)((double)averageBondLength + this.mDepictor[i].getTransformation().getScaling() * (double)this.mMolecule[i].getAllBonds() * this.mMolecule[i].getAverageBondLength());
                    bondCount += this.mMolecule[i].getAllBonds();
                    continue;
                }
                averageBondLength = (float)((double)averageBondLength + this.mDepictor[i].getTransformation().getScaling() * this.mMolecule[i].getAverageBondLength());
                ++bondCount;
            }
        }
        return bondCount == 0 ? 24.0 : this.mTransformation.getScaling() * (double)averageBondLength / (double)bondCount;
    }

    private void layoutReaction(GenericDrawContext context) {
        GenericRectangle[] boundingRect = new GenericRectangle[this.mMolecule.length];
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        for (int i = 0; i < this.mMolecule.length; ++i) {
            this.mDepictor[i].validateView(context, null, 65536);
            boundingRect[i] = this.mDepictor[i].getBoundingRect();
            totalWidth += boundingRect[i].width;
            totalHeight = Math.max(totalHeight, boundingRect[i].height);
        }
        double catalystScale = 0.7;
        double catalystSpacing = 12.0;
        GenericRectangle[] catalystBoundingRect = new GenericRectangle[this.mCatalyst.length];
        double totalCatalystWidth = 0.0;
        double totalCatalystHeight = 0.0;
        for (int i = 0; i < this.mCatalyst.length; ++i) {
            this.mCatalystDepictor[i].validateView(context, null, 65552);
            catalystBoundingRect[i] = this.mCatalystDepictor[i].getBoundingRect();
            totalCatalystWidth = Math.max(totalCatalystWidth, catalystBoundingRect[i].width);
            totalCatalystHeight += catalystBoundingRect[i].height + catalystSpacing;
        }
        double spacing = 36.0;
        double arrowWidth = Math.max(48.0, totalCatalystWidth + 24.0);
        totalHeight = Math.max(totalHeight, 24.0 + 2.0 * totalCatalystHeight);
        int arrow = -1;
        if (this.mDrawingObjectList == null) {
            this.mDrawingObjectList = new DrawingObjectList();
            this.mDrawingObjectList.add(new ReactionArrow());
            arrow = 0;
        } else {
            for (int i = 0; i < this.mDrawingObjectList.size(); ++i) {
                if (!(this.mDrawingObjectList.get(i) instanceof ReactionArrow)) continue;
                arrow = i;
                break;
            }
            if (arrow == -1) {
                arrow = this.mDrawingObjectList.size();
                this.mDrawingObjectList.add(new ReactionArrow());
            }
        }
        double rawX = 0.5 * spacing;
        for (int i = 0; i < this.mMolecule.length; ++i) {
            if (i == this.mReactantCount) {
                ((ReactionArrow)this.mDrawingObjectList.get(arrow)).setCoordinates(rawX - spacing / 2.0, totalHeight / 2.0, rawX - spacing / 2.0 + arrowWidth, totalHeight / 2.0);
                double catX = rawX + 0.5 * (24.0 - spacing);
                double catY = 0.5 * (totalHeight - catalystSpacing) - totalCatalystHeight;
                for (int j = 0; j < this.mCatalyst.length; ++j) {
                    double dx = catX + 0.5 * (totalCatalystWidth - catalystBoundingRect[j].width) - catalystBoundingRect[j].x;
                    double dy = catY - catalystBoundingRect[j].y;
                    this.mCatalystDepictor[j].applyTransformation(new DepictorTransformation(1.0, dx, dy));
                    catY += catalystSpacing + catalystBoundingRect[j].height;
                }
                rawX += arrowWidth;
            }
            double dx = rawX - boundingRect[i].x;
            double dy = 0.5 * (totalHeight - boundingRect[i].height) - boundingRect[i].y;
            this.mDepictor[i].applyTransformation(new DepictorTransformation(1.0, dx, dy));
            rawX += spacing + boundingRect[i].width;
        }
        this.mReactionLayoutNeeded = false;
    }
}

