/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.util.Angle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ExtendedMolecule
extends Molecule
implements Serializable {
    static final long serialVersionUID = 537316094L;
    public static final float FISCHER_PROJECTION_LIMIT = 0.08726647f;
    public static final float FISCHER_PROJECTION_RING_LIMIT = 24.0f;
    public static final float STEREO_ANGLE_LIMIT = 0.08726647f;
    public static final int cMaxConnAtoms = 16;
    private transient int mAtoms;
    private transient int mBonds;
    private transient RingCollection mRingSet;
    private transient int[] mPi;
    private transient int[] mConnAtoms;
    private transient int[] mAllConnAtoms;
    private transient int[][] mConnAtom;
    private transient int[][] mConnBond;
    private transient int[][] mConnBondOrder;

    public ExtendedMolecule() {
    }

    public ExtendedMolecule(int maxAtoms, int maxBonds) {
        super(maxAtoms, maxBonds);
    }

    public ExtendedMolecule(Molecule mol) {
        super(mol == null ? 256 : mol.getMaxAtoms(), mol == null ? 256 : mol.getMaxBonds());
        if (mol != null) {
            mol.copyMolecule(this);
        }
    }

    public void copyMoleculeByAtoms(ExtendedMolecule destMol, boolean[] includeAtom, boolean recognizeDelocalizedBonds, int[] atomMap) {
        if (recognizeDelocalizedBonds) {
            this.ensureHelperArrays(7);
        }
        destMol.mAtomList = null;
        if (this.mIsFragment) {
            destMol.setFragment(true);
        }
        int atomCount = includeAtom.length;
        if (atomMap == null) {
            atomMap = new int[atomCount];
        }
        destMol.mAllAtoms = 0;
        for (int atom = 0; atom < atomCount; ++atom) {
            atomMap[atom] = includeAtom[atom] ? this.copyAtom(destMol, atom, 0, 0) : -1;
        }
        destMol.mAllBonds = 0;
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            int atom1 = this.mBondAtom[0][bnd];
            int atom2 = this.mBondAtom[1][bnd];
            if (atom1 >= atomCount || atom2 >= atomCount) continue;
            if (includeAtom[atom1] && includeAtom[atom2]) {
                this.copyBond(destMol, bnd, 0, 0, atomMap, recognizeDelocalizedBonds);
                continue;
            }
            if (this.mAtomCharge[atom1] == 0 || this.mAtomCharge[atom2] == 0 || !(this.mAtomCharge[atom1] < 0 ^ this.mAtomCharge[atom2] < 0)) continue;
            if (includeAtom[atom1]) {
                int n = atomMap[atom1];
                destMol.mAtomCharge[n] = destMol.mAtomCharge[n] + (this.mAtomCharge[atom1] < 0 ? 1 : -1);
            }
            if (!includeAtom[atom2]) continue;
            int n = atomMap[atom2];
            destMol.mAtomCharge[n] = destMol.mAtomCharge[n] + (this.mAtomCharge[atom2] < 0 ? 1 : -1);
        }
        this.copyMoleculeProperties(destMol);
        destMol.mValidHelperArrays = 0;
        destMol.renumberESRGroups(1);
        destMol.renumberESRGroups(2);
        if (destMol.mAllAtoms != atomCount) {
            destMol.setFragment(true);
        }
        if (recognizeDelocalizedBonds) {
            new AromaticityResolver(destMol).locateDelocalizedDoubleBonds(null);
        }
    }

    public int[] copyMoleculeByBonds(ExtendedMolecule destMol, boolean[] includeBond, boolean recognizeDelocalizedBonds, int[] atomMap) {
        if (recognizeDelocalizedBonds) {
            this.ensureHelperArrays(7);
        }
        destMol.mAtomList = null;
        if (this.mIsFragment) {
            destMol.setFragment(true);
        }
        if (atomMap == null) {
            atomMap = new int[this.mAllAtoms];
        }
        destMol.mAllAtoms = 0;
        block0: for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            atomMap[atom] = -1;
            for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
                if (!includeBond[this.mConnBond[atom][i]]) continue;
                atomMap[atom] = this.copyAtom(destMol, atom, 0, 0);
                continue block0;
            }
        }
        destMol.mAllBonds = 0;
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            int atom2;
            if (includeBond[bnd]) {
                this.copyBond(destMol, bnd, 0, 0, atomMap, recognizeDelocalizedBonds);
                continue;
            }
            int atom1 = this.mBondAtom[0][bnd];
            if (!(atomMap[atom1] == -1 ^ atomMap[atom2 = this.mBondAtom[1][bnd]] == -1) || this.mAtomCharge[atom1] == 0 || this.mAtomCharge[atom2] == 0 || !(this.mAtomCharge[atom1] < 0 ^ this.mAtomCharge[atom2] < 0)) continue;
            if (atomMap[atom1] != -1) {
                int n = atomMap[atom1];
                destMol.mAtomCharge[n] = destMol.mAtomCharge[n] + (this.mAtomCharge[atom1] < 0 ? 1 : -1);
            }
            if (atomMap[atom2] == -1) continue;
            int n = atomMap[atom2];
            destMol.mAtomCharge[n] = destMol.mAtomCharge[n] + (this.mAtomCharge[atom2] < 0 ? 1 : -1);
        }
        this.copyMoleculeProperties(destMol);
        destMol.mValidHelperArrays = 0;
        destMol.renumberESRGroups(1);
        destMol.renumberESRGroups(2);
        if (destMol.mAllAtoms != this.mAllAtoms) {
            destMol.setFragment(true);
        }
        if (recognizeDelocalizedBonds) {
            new AromaticityResolver(destMol).locateDelocalizedDoubleBonds(null);
        }
        return atomMap;
    }

    public int getAllConnAtoms(int atom) {
        return this.mAllConnAtoms[atom];
    }

    public int getPlainHydrogens(int atom) {
        return this.getExplicitHydrogens(atom) + this.getImplicitHydrogens(atom);
    }

    public int getAllHydrogens(int atom) {
        return this.mAllConnAtoms[atom] - this.getNonHydrogenNeighbourCount(atom) + this.getImplicitHydrogens(atom);
    }

    public int getAtoms() {
        return this.mAtoms;
    }

    public int getMetalBondedConnAtoms(int atom) {
        return this.mConnAtom[atom].length - this.mAllConnAtoms[atom];
    }

    public int getAtomPi(int atom) {
        return this.mPi[atom];
    }

    public int getAtomRingSize(int atom) {
        return this.mRingSet != null && atom < this.mAtoms ? this.mRingSet.getAtomRingSize(atom) : 0;
    }

    public int getBondRingSize(int bond) {
        return this.mRingSet != null && bond < this.mBonds ? this.mRingSet.getBondRingSize(bond) : 0;
    }

    public int getBonds() {
        return this.mBonds;
    }

    public int getBond(int atom1, int atom2) {
        for (int i = 0; i < this.getAllConnAtomsPlusMetalBonds(atom1); ++i) {
            if (this.mConnAtom[atom1][i] != atom2) continue;
            return this.mConnBond[atom1][i];
        }
        return -1;
    }

    public ExtendedMolecule getCompactCopy() {
        ExtendedMolecule theCopy = new ExtendedMolecule(this.mAllAtoms, this.mAllBonds);
        this.copyMolecule(theCopy);
        return theCopy;
    }

    public int getConnAtom(int atom, int i) {
        return this.mConnAtom[atom][i];
    }

    public int getConnAtoms(int atom) {
        return this.mConnAtoms[atom];
    }

    public int getAllConnAtomsPlusMetalBonds(int atom) {
        return this.mConnAtom[atom].length;
    }

    public int getConnBond(int atom, int i) {
        return this.mConnBond[atom][i];
    }

    public int getConnBondOrder(int atom, int i) {
        return this.mConnBondOrder[atom][i];
    }

    public int getNonHydrogenNeighbourCount(int atom) {
        int count = this.mConnAtoms[atom];
        for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
            if (this.mAtomicNo[this.mConnAtom[atom][i]] != 1) continue;
            --count;
        }
        return count;
    }

    public int getExcludedNeighbourCount(int atom) {
        int count = 0;
        for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
            if ((this.mAtomQueryFeatures[i] & 0x20000000L) == 0L) continue;
            ++count;
        }
        return count;
    }

    public double getAverageBondLength(boolean nonHydrogenBondsOnly) {
        if (nonHydrogenBondsOnly) {
            this.ensureHelperArrays(1);
            return this.getAverageBondLength(this.mAtoms, this.mBonds);
        }
        return this.getAverageBondLength(this.mAllAtoms, this.mAllBonds);
    }

    private int[] getSortedConnMap(int atom) {
        int i;
        int connAtoms = this.mAllConnAtoms[atom];
        int[] indexMap = new int[connAtoms];
        for (i = 0; i < connAtoms; ++i) {
            indexMap[i] = (this.mConnAtom[atom][i] << 16) + i;
        }
        Arrays.sort(indexMap);
        i = 0;
        while (i < connAtoms) {
            int n = i++;
            indexMap[n] = indexMap[n] & 0xFFFF;
        }
        return indexMap;
    }

    @Override
    public int getOccupiedValence(int atom) {
        this.ensureHelperArrays(1);
        boolean piElectronsFound = false;
        boolean delocalizedBondFound = false;
        int valence = 0;
        for (int i = 0; i < this.mAllConnAtoms[atom]; ++i) {
            int bond;
            if (this.mIsFragment && (this.mAtomQueryFeatures[this.mConnAtom[atom][i]] & 0x20000000L) != 0L) continue;
            int order = this.mConnBondOrder[atom][i];
            valence += order;
            if (order > 1) {
                piElectronsFound = true;
            }
            if (this.mBondType[bond = this.mConnBond[atom][i]] != 64) continue;
            delocalizedBondFound = true;
        }
        if (delocalizedBondFound && !piElectronsFound) {
            ++valence;
        }
        return valence;
    }

    public int getFreeValence(int atom) {
        return this.getMaxValence(atom) - this.getOccupiedValence(atom);
    }

    public int getLowestFreeValence(int atom) {
        int occupiedValence = this.getOccupiedValence(atom);
        int correction = this.getElectronValenceCorrection(atom, occupiedValence);
        int valence = this.getAtomAbnormalValence(atom);
        if (valence == -1) {
            int i;
            byte[] valenceList = ExtendedMolecule.getAllowedValences(this.mAtomicNo[atom]);
            for (i = 0; occupiedValence > valenceList[i] + correction && i < valenceList.length - 1; ++i) {
            }
            valence = valenceList[i];
        }
        return valence + correction - occupiedValence;
    }

    public int getImplicitHigherValence(int atom, boolean neglectExplicitHydrogen) {
        byte[] valences;
        int occupiedValence = this.getOccupiedValence(atom);
        occupiedValence -= this.getElectronValenceCorrection(atom, occupiedValence);
        if (neglectExplicitHydrogen) {
            occupiedValence -= this.mAllConnAtoms[atom] - this.mConnAtoms[atom];
        }
        if (occupiedValence <= (valences = ExtendedMolecule.getAllowedValences(this.mAtomicNo[atom]))[0]) {
            return -1;
        }
        for (int i = 1; i < valences.length; ++i) {
            if (valences[i] < occupiedValence) continue;
            return valences[i];
        }
        return occupiedValence;
    }

    public float[] getAverageTopologicalAtomDistance() {
        this.ensureHelperArrays(1);
        float[] meanDistance = new float[this.mAtoms];
        int[] graphAtom = new int[this.mAtoms];
        int startAtom = 0;
        while (startAtom < this.mAtoms) {
            graphAtom[0] = startAtom;
            int[] graphLevel = new int[this.mAtoms];
            graphLevel[startAtom] = 1;
            int highest = 0;
            for (int current = 0; current <= highest; ++current) {
                for (int i = 0; i < this.mConnAtoms[graphAtom[current]]; ++i) {
                    int candidate = this.mConnAtom[graphAtom[current]][i];
                    if (graphLevel[candidate] != 0) continue;
                    graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
                    graphAtom[++highest] = candidate;
                    int n = startAtom;
                    meanDistance[n] = meanDistance[n] + (float)(graphLevel[candidate] - 1);
                }
            }
            int n = startAtom++;
            meanDistance[n] = meanDistance[n] / (float)highest;
        }
        return meanDistance;
    }

    public int getPathLength(int atom1, int atom2) {
        if (atom1 == atom2) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int[] graphLevel = new int[this.mAllAtoms];
        int[] graphAtom = new int[this.mAllAtoms];
        graphAtom[0] = atom1;
        graphLevel[atom1] = 1;
        int highest = 0;
        for (int current = 0; current <= highest; ++current) {
            for (int i = 0; i < this.mAllConnAtoms[graphAtom[current]]; ++i) {
                int candidate = this.mConnAtom[graphAtom[current]][i];
                if (candidate == atom2) {
                    return graphLevel[graphAtom[current]];
                }
                if (graphLevel[candidate] != 0) continue;
                graphAtom[++highest] = candidate;
                graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
            }
        }
        return -1;
    }

    public int getPathLength(int atom1, int atom2, int maxLength, boolean[] neglectAtom) {
        if (atom1 == atom2) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int[] graphLevel = new int[this.mAllAtoms];
        int[] graphAtom = new int[this.mAllAtoms];
        graphAtom[0] = atom1;
        graphLevel[atom1] = 1;
        int highest = 0;
        for (int current = 0; current <= highest && graphLevel[graphAtom[current]] <= maxLength; ++current) {
            for (int i = 0; i < this.mAllConnAtoms[graphAtom[current]]; ++i) {
                int candidate = this.mConnAtom[graphAtom[current]][i];
                if (candidate == atom2) {
                    return graphLevel[graphAtom[current]];
                }
                if (graphLevel[candidate] != 0 || neglectAtom != null && neglectAtom.length > candidate && neglectAtom[candidate]) continue;
                graphAtom[++highest] = candidate;
                graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
            }
        }
        return -1;
    }

    public int getPath(int[] pathAtom, int atom1, int atom2, int maxLength, boolean[] neglectBond) {
        if (atom1 == atom2) {
            pathAtom[0] = atom1;
            return 0;
        }
        this.ensureHelperArrays(1);
        int[] graphLevel = new int[this.mAllAtoms];
        int[] graphAtom = new int[this.mAllAtoms];
        int[] parentAtom = new int[this.mAllAtoms];
        graphAtom[0] = atom1;
        graphLevel[atom1] = 1;
        int highest = 0;
        for (int current = 0; current <= highest && graphLevel[graphAtom[current]] <= maxLength; ++current) {
            int parent = graphAtom[current];
            for (int i = 0; i < this.mAllConnAtoms[parent]; ++i) {
                if (neglectBond != null && neglectBond.length > this.mConnBond[parent][i] && neglectBond[this.mConnBond[parent][i]]) continue;
                int candidate = this.mConnAtom[parent][i];
                if (candidate == atom2) {
                    int index = graphLevel[parent];
                    pathAtom[index] = candidate;
                    pathAtom[--index] = parent;
                    while (index > 0) {
                        pathAtom[index - 1] = parentAtom[pathAtom[index]];
                        --index;
                    }
                    return graphLevel[parent];
                }
                if (graphLevel[candidate] != 0) continue;
                graphAtom[++highest] = candidate;
                graphLevel[candidate] = graphLevel[parent] + 1;
                parentAtom[candidate] = parent;
            }
        }
        return -1;
    }

    public void getPathBonds(int[] pathAtom, int[] pathBond, int pathLength) {
        this.ensureHelperArrays(1);
        block0: for (int i = 0; i < pathLength; ++i) {
            for (int j = 0; j < this.mAllConnAtoms[pathAtom[i]]; ++j) {
                if (this.mConnAtom[pathAtom[i]][j] != pathAtom[i + 1]) continue;
                pathBond[i] = this.mConnBond[pathAtom[i]][j];
                continue block0;
            }
        }
    }

    public boolean shareSameFragment(int atom1, int atom2) {
        return this.getPathLength(atom1, atom2) != -1;
    }

    public void addFragment(ExtendedMolecule sourceMol, int rootAtom, int[] atomMap) {
        sourceMol.ensureHelperArrays(1);
        if (atomMap == null) {
            atomMap = new int[sourceMol.mAllAtoms];
        }
        int esrGroupCountAND = this.renumberESRGroups(1);
        int esrGroupCountOR = this.renumberESRGroups(2);
        boolean[] isFragmentMember = new boolean[sourceMol.mAllAtoms];
        int[] graphAtom = new int[sourceMol.mAllAtoms];
        graphAtom[0] = rootAtom;
        isFragmentMember[rootAtom] = true;
        atomMap[rootAtom] = sourceMol.copyAtom(this, rootAtom, esrGroupCountAND, esrGroupCountOR);
        int highest = 0;
        for (int current = 0; current <= highest; ++current) {
            for (int i = 0; i < sourceMol.getAllConnAtoms(graphAtom[current]); ++i) {
                int candidate = sourceMol.mConnAtom[graphAtom[current]][i];
                if (isFragmentMember[candidate]) continue;
                graphAtom[++highest] = candidate;
                isFragmentMember[candidate] = true;
                atomMap[candidate] = sourceMol.copyAtom(this, candidate, esrGroupCountAND, esrGroupCountOR);
            }
        }
        for (int bond = 0; bond < sourceMol.mAllBonds; ++bond) {
            if (!isFragmentMember[sourceMol.mBondAtom[0][bond]]) continue;
            sourceMol.copyBond(this, bond, esrGroupCountAND, esrGroupCountOR, atomMap, false);
        }
        this.renumberESRGroups(1);
        this.renumberESRGroups(2);
        this.mValidHelperArrays = 0;
    }

    public int[] getFragmentAtoms(int rootAtom) {
        return this.getFragmentAtoms(rootAtom, false);
    }

    public int[] getFragmentAtoms(int rootAtom, boolean considerMetalBonds) {
        this.ensureHelperArrays(1);
        boolean[] isFragmentMember = new boolean[this.mAllAtoms];
        int[] graphAtom = new int[this.mAllAtoms];
        graphAtom[0] = rootAtom;
        isFragmentMember[rootAtom] = true;
        int highest = 0;
        int fragmentMembers = 1;
        for (int current = 0; current <= highest; ++current) {
            int connAtoms = considerMetalBonds ? this.getAllConnAtomsPlusMetalBonds(graphAtom[current]) : this.mAllConnAtoms[graphAtom[current]];
            for (int i = 0; i < connAtoms; ++i) {
                int candidate = this.mConnAtom[graphAtom[current]][i];
                if (isFragmentMember[candidate]) continue;
                graphAtom[++highest] = candidate;
                isFragmentMember[candidate] = true;
                ++fragmentMembers;
            }
        }
        int[] fragmentMember = new int[fragmentMembers];
        fragmentMembers = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (!isFragmentMember[atom]) continue;
            fragmentMember[fragmentMembers++] = atom;
        }
        return fragmentMember;
    }

    public int getFragmentNumbers(int[] fragmentNo, boolean[] neglectBond, boolean considerMetalBonds) {
        this.ensureHelperArrays(1);
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            fragmentNo[atom] = -1;
        }
        int fragments = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (fragmentNo[atom] != -1) continue;
            fragmentNo[atom] = fragments;
            int[] graphAtom = new int[this.mAllAtoms];
            graphAtom[0] = atom;
            int highest = 0;
            for (int current = 0; current <= highest; ++current) {
                int connAtoms = considerMetalBonds ? this.getAllConnAtomsPlusMetalBonds(graphAtom[current]) : this.mAllConnAtoms[graphAtom[current]];
                for (int i = 0; i < connAtoms; ++i) {
                    int candidate = this.mConnAtom[graphAtom[current]][i];
                    if (fragmentNo[candidate] != -1 || neglectBond[this.mConnBond[graphAtom[current]][i]]) continue;
                    graphAtom[++highest] = candidate;
                    fragmentNo[candidate] = fragments;
                }
            }
            ++fragments;
        }
        return fragments;
    }

    public int getFragmentNumbers(int[] fragmentNo, boolean markedAtomsOnly, boolean considerMetalBonds) {
        this.ensureHelperArrays(1);
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            fragmentNo[atom] = -1;
        }
        int fragments = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (fragmentNo[atom] != -1 || markedAtomsOnly && !this.isMarkedAtom(atom)) continue;
            fragmentNo[atom] = fragments;
            int[] graphAtom = new int[this.mAllAtoms];
            graphAtom[0] = atom;
            int highest = 0;
            for (int current = 0; current <= highest; ++current) {
                int connAtoms = considerMetalBonds ? this.getAllConnAtomsPlusMetalBonds(graphAtom[current]) : this.mAllConnAtoms[graphAtom[current]];
                for (int i = 0; i < connAtoms; ++i) {
                    int candidate = this.mConnAtom[graphAtom[current]][i];
                    if (fragmentNo[candidate] != -1 || markedAtomsOnly && !this.isMarkedAtom(candidate)) continue;
                    graphAtom[++highest] = candidate;
                    fragmentNo[candidate] = fragments;
                }
            }
            ++fragments;
        }
        return fragments;
    }

    public int[] stripSmallFragments() {
        return this.stripSmallFragments(false);
    }

    public int[] stripSmallFragments(boolean considerMetalBonds) {
        int[] fragmentNo = new int[this.mAllAtoms];
        int fragmentCount = this.getFragmentNumbers(fragmentNo, false, considerMetalBonds);
        if (fragmentCount <= 1) {
            return null;
        }
        int[] fragmentSize = new int[fragmentCount];
        for (int atom = 0; atom < this.mAtoms; ++atom) {
            int n = fragmentNo[atom];
            fragmentSize[n] = fragmentSize[n] + 1;
        }
        int largestFragment = 0;
        int largestSize = fragmentSize[0];
        for (int i = 1; i < fragmentCount; ++i) {
            if (largestSize >= fragmentSize[i]) continue;
            largestSize = fragmentSize[i];
            largestFragment = i;
        }
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (fragmentNo[atom] == largestFragment) continue;
            this.mAtomicNo[atom] = -1;
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            if ((considerMetalBonds || this.mBondType[bond] != 32) && fragmentNo[this.mBondAtom[0][bond]] == largestFragment) continue;
            this.mBondType[bond] = 128;
        }
        int[] atomMap = this.compressMolTable();
        this.mValidHelperArrays = 0;
        try {
            this.canonizeCharge(true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return atomMap;
    }

    public void findRingSystem(int startAtom, boolean aromaticOnly, boolean[] isMemberAtom, boolean[] isMemberBond) {
        this.ensureHelperArrays(7);
        if (!this.isRingAtom(startAtom) || aromaticOnly && !this.isAromaticAtom(startAtom)) {
            return;
        }
        int[] graphAtom = new int[this.mAtoms];
        graphAtom[0] = startAtom;
        isMemberAtom[startAtom] = true;
        int highest = 0;
        for (int current = 0; current <= highest; ++current) {
            for (int i = 0; i < this.mConnAtoms[graphAtom[current]]; ++i) {
                int candidateBond = this.mConnBond[graphAtom[current]][i];
                if (isMemberBond[candidateBond] || !this.isRingBond(candidateBond) || aromaticOnly && !this.isAromaticBond(candidateBond)) continue;
                isMemberBond[candidateBond] = true;
                int candidateAtom = this.mConnAtom[graphAtom[current]][i];
                if (isMemberAtom[candidateAtom]) continue;
                isMemberAtom[candidateAtom] = true;
                graphAtom[++highest] = candidateAtom;
            }
        }
    }

    public int getSubstituent(int coreAtom, int firstAtom, boolean[] isMemberAtom, ExtendedMolecule substituent, int[] atomMap) {
        this.ensureHelperArrays(1);
        if (substituent != null) {
            substituent.clear();
            substituent.mIsFragment = false;
        }
        int[] graphAtom = new int[this.mAllAtoms];
        if (isMemberAtom == null) {
            isMemberAtom = new boolean[this.mAllAtoms];
        } else {
            Arrays.fill(isMemberAtom, false);
        }
        graphAtom[0] = coreAtom;
        graphAtom[1] = firstAtom;
        isMemberAtom[coreAtom] = true;
        isMemberAtom[firstAtom] = true;
        int highest = 1;
        for (int current = 1; current <= highest; ++current) {
            for (int i = 0; i < this.mAllConnAtoms[graphAtom[current]]; ++i) {
                int candidate = this.mConnAtom[graphAtom[current]][i];
                if (candidate == coreAtom && current != 1) {
                    return -1;
                }
                if (isMemberAtom[candidate]) continue;
                isMemberAtom[candidate] = true;
                graphAtom[++highest] = candidate;
            }
        }
        if (substituent != null) {
            if (atomMap == null) {
                atomMap = new int[isMemberAtom.length];
            }
            this.copyMoleculeByAtoms(substituent, isMemberAtom, false, atomMap);
            substituent.changeAtom(atomMap[coreAtom], 0, 0, -1, 0);
        }
        isMemberAtom[coreAtom] = false;
        return highest;
    }

    public int getSubstituentSize(int coreAtom, int firstAtom) {
        this.ensureHelperArrays(1);
        int[] graphAtom = new int[this.mAtoms];
        boolean[] isMember = new boolean[this.mAtoms];
        graphAtom[0] = coreAtom;
        graphAtom[1] = firstAtom;
        isMember[coreAtom] = true;
        isMember[firstAtom] = true;
        int highest = 1;
        for (int current = 1; current <= highest; ++current) {
            for (int i = 0; i < this.mConnAtoms[graphAtom[current]]; ++i) {
                int candidate = this.mConnAtom[graphAtom[current]][i];
                if (candidate == coreAtom && current != 1) {
                    return -1;
                }
                if (isMember[candidate]) continue;
                isMember[candidate] = true;
                graphAtom[++highest] = candidate;
            }
        }
        return highest;
    }

    public boolean supportsImplicitHydrogen(int atom) {
        if ((this.mAtomFlags[atom] & 0xF0000000) != 0) {
            return true;
        }
        if (this.mAtomicNo[atom] == 1) {
            return false;
        }
        return this.isOrganicAtom(atom) || this.mAtomicNo[atom] == 13 || this.mAtomicNo[atom] >= 171;
    }

    public int getImplicitHydrogens(int atom) {
        if (this.mIsFragment && (this.mAtomQueryFeatures[atom] & 0x800L) == 0L) {
            return 0;
        }
        if (!this.supportsImplicitHydrogen(atom)) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int occupiedValence = 0;
        for (int i = 0; i < this.mAllConnAtoms[atom]; ++i) {
            occupiedValence += this.mConnBondOrder[atom][i];
        }
        if (this.mIsFragment) {
            int delocalizedBonds = 1;
            for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
                if (this.mBondType[this.mConnBond[atom][i]] != 64) continue;
                ++delocalizedBonds;
            }
            occupiedValence += delocalizedBonds >> 1;
        }
        occupiedValence -= this.getElectronValenceCorrection(atom, occupiedValence);
        int maxValence = this.getAtomAbnormalValence(atom);
        if (maxValence == -1) {
            byte[] valenceList = Molecule.getAllowedValences(this.mAtomicNo[atom]);
            maxValence = valenceList[0];
            for (int i = 1; maxValence < occupiedValence && i < valenceList.length; ++i) {
                maxValence = valenceList[i];
            }
        }
        return Math.max(0, maxValence - occupiedValence);
    }

    public int getExplicitHydrogens(int atom) {
        return this.mAllConnAtoms[atom] - this.mConnAtoms[atom];
    }

    public int getMolweight() {
        this.ensureHelperArrays(1);
        int molweight = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            int connAtoms;
            int mass = this.mAtomMass[atom] != 0 ? this.mAtomMass[atom] : cRoundedMass[this.mAtomicNo[atom]];
            molweight += mass + this.getImplicitHydrogens(atom) * cRoundedMass[1];
            if (this.mAtomicNo[atom] < 171 || this.mAtomicNo[atom] > 190 || (connAtoms = this.mAllConnAtoms[atom]) <= 2) continue;
            molweight -= (connAtoms - 2) * cRoundedMass[1];
        }
        return molweight;
    }

    public int getRotatableBondCount() {
        int rCount = 0;
        this.ensureHelperArrays(7);
        for (int bond = 0; bond < this.mBonds; ++bond) {
            if (this.getBondOrder(bond) != 1 || this.isRingBond(bond)) continue;
            boolean isRotatable = true;
            block1: for (int i = 0; i < 2; ++i) {
                int atom1 = this.mBondAtom[i][bond];
                if (this.mConnAtoms[atom1] == 1) {
                    isRotatable = false;
                    break;
                }
                if (this.mAtomicNo[atom1] != 7 || this.isAromaticAtom(atom1)) continue;
                int atom2 = this.mBondAtom[1 - i][bond];
                for (int j = 0; j < this.mConnAtoms[atom2]; ++j) {
                    int connAtom = this.mConnAtom[atom2][j];
                    int connBond = this.mConnBond[atom2][j];
                    if (connBond == bond || this.getBondOrder(connBond) <= 1 || this.isAromaticAtom(connAtom) || !this.isElectronegative(connAtom)) continue;
                    isRotatable = false;
                    continue block1;
                }
            }
            if (!isRotatable || this.isPseudoRotatableBond(bond)) continue;
            ++rCount;
        }
        return rCount;
    }

    public boolean isPseudoRotatableBond(int bond) {
        if (this.getBondOrder(bond) != 1) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            int atom = this.mBondAtom[i][bond];
            int rearAtom = this.mBondAtom[1 - i][bond];
            block1: while (this.mPi[atom] == 2 && this.mConnAtoms[atom] == 2 && this.mAtomicNo[atom] < 10) {
                for (int j = 0; j < 2; ++j) {
                    int connAtom = this.mConnAtom[atom][j];
                    if (connAtom == rearAtom) continue;
                    if (this.mConnAtoms[connAtom] == 1) {
                        return true;
                    }
                    int connBond = this.mConnBond[atom][j];
                    if (this.getBondOrder(connBond) == 1 && connBond < bond) {
                        return true;
                    }
                    rearAtom = atom;
                    atom = connAtom;
                    continue block1;
                }
            }
            if (this.mConnAtoms[atom] != 1) continue;
            return true;
        }
        return false;
    }

    public int getAromaticRingCount() {
        this.ensureHelperArrays(7);
        int count = 0;
        for (int i = 0; i < this.mRingSet.getSize(); ++i) {
            if (!this.mRingSet.isAromatic(i)) continue;
            ++count;
        }
        return count;
    }

    public int getAtomRingCount(int atom, int maxRingSize) {
        this.ensureHelperArrays(7);
        boolean[] bondTouched = new boolean[this.mBonds];
        boolean[] neglectBond = new boolean[this.mBonds];
        int[] ringAtom = new int[this.mAtoms];
        int count = 0;
        for (int i = 1; i < this.mConnAtoms[atom]; ++i) {
            int bond1 = this.mConnBond[atom][i];
            if (!this.isRingBond(bond1)) continue;
            for (int j = 0; j < i; ++j) {
                int bond2 = this.mConnBond[atom][j];
                if (!this.isRingBond(bond2)) continue;
                neglectBond[bond1] = true;
                neglectBond[bond2] = true;
                int pathLength = this.getPath(ringAtom, this.mConnAtom[atom][i], this.mConnAtom[atom][j], maxRingSize - 2, neglectBond);
                neglectBond[bond1] = false;
                neglectBond[bond2] = false;
                if (pathLength == -1) continue;
                boolean isIndependentRing = false;
                int[] pathBond = new int[pathLength];
                this.getPathBonds(ringAtom, pathBond, pathLength);
                for (int k = 0; k < pathLength; ++k) {
                    if (bondTouched[pathBond[k]]) continue;
                    bondTouched[pathBond[k]] = true;
                    isIndependentRing = true;
                }
                if (!isIndependentRing) continue;
                ++count;
            }
        }
        return count;
    }

    public RingCollection getRingSet() {
        this.ensureHelperArrays(7);
        return this.mRingSet;
    }

    public RingCollection getRingSetSimple() {
        this.ensureHelperArrays(3);
        return this.mRingSet;
    }

    public int getAtomPreferredStereoBond(int atom) {
        this.ensureHelperArrays(7);
        if (this.mPi[atom] == 2 && this.mConnAtoms[atom] == 2) {
            return this.preferredAlleneStereoBond(atom);
        }
        return this.preferredTHStereoBond(atom);
    }

    public int getBondPreferredStereoBond(int bond) {
        return this.preferredBinapStereoBond(bond);
    }

    private int getStereoBondScore(int bond, int atom) {
        if (this.getBondOrder(bond) != 1) {
            return 0;
        }
        return 16 - this.mAllConnAtoms[atom] + (this.mAtomicNo[atom] == 1 ? 4096 : 0) + ((this.mBondType[bond] & 0x18) == 0 || this.mBondAtom[0][bond] != atom ? 2048 : 0) + (this.getAtomParity(atom) == 0 ? 1024 : 0) + (!this.isRingBond(bond) ? 512 : 0) + (this.mAtomicNo[atom] != 6 ? 256 : 0);
    }

    public boolean isAllylicAtom(int atom) {
        return (this.mAtomFlags[atom] & 0x2000) != 0;
    }

    public boolean isAromaticAtom(int atom) {
        return (this.mAtomFlags[atom] & 0x1000) != 0;
    }

    public boolean isAromaticBond(int bnd) {
        return (this.mBondFlags[bnd] & 0x100) != 0;
    }

    public boolean isDelocalizedBond(int bond) {
        return (this.mBondFlags[bond] & 0x200) != 0 || this.mIsFragment && (this.mBondQueryFeatures[bond] & 0x1F) == 8;
    }

    public boolean isRingAtom(int atom) {
        return (this.mAtomFlags[atom] & 0xC00) != 0;
    }

    public boolean isRingBond(int bnd) {
        return (this.mBondFlags[bnd] & 0x40) != 0;
    }

    public boolean isSmallRingAtom(int atom) {
        return (this.mAtomFlags[atom] & 8) != 0;
    }

    public boolean isSmallRingBond(int bond) {
        return (this.mBondFlags[bond] & 0x80) != 0;
    }

    public boolean isStabilizedAtom(int atom) {
        return (this.mAtomFlags[atom] & 0x4000) != 0;
    }

    public int getAtomRingBondCount(int atom) {
        int flags = this.mAtomFlags[atom] & 0xC00;
        return flags == 0 ? 0 : (flags == 1024 ? 2 : (flags == 2048 ? 3 : 4));
    }

    public String getChiralText() {
        return null;
    }

    public int getStereoBond(int atom) {
        this.ensureHelperArrays(1);
        if (this.mConnAtoms[atom] == 2 && this.mConnBondOrder[atom][0] == 2 && this.mConnBondOrder[atom][1] == 2) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.mAllConnAtoms[this.mConnAtom[atom][i]]; ++j) {
                    if (!this.isStereoBond(this.mConnBond[this.mConnAtom[atom][i]][j], this.mConnAtom[atom][i])) continue;
                    return this.mConnBond[this.mConnAtom[atom][i]][j];
                }
            }
        } else {
            for (int i = 0; i < this.mAllConnAtoms[atom]; ++i) {
                if (!this.isStereoBond(this.mConnBond[atom][i], atom)) continue;
                return this.mConnBond[atom][i];
            }
        }
        return -1;
    }

    public void setParitiesValid(int helperStereoBits) {
        this.mValidHelperArrays |= 0x1F8 & (8 | helperStereoBits);
    }

    public void setStereoBondsFromParity() {
        int bond;
        this.ensureHelperArrays(7);
        for (int atom = 0; atom < this.mAtoms; ++atom) {
            this.setStereoBondFromAtomParity(atom);
        }
        for (bond = 0; bond < this.mBonds; ++bond) {
            this.setStereoBondFromBondParity(bond);
        }
        for (bond = 0; bond < this.mBonds; ++bond) {
            if (this.mBondType[bond] != 2 || this.getBondParity(bond) != 3) continue;
            this.mBondType[bond] = 26;
        }
    }

    public void convertStereoBondsToSingleBonds(int atom) {
        if (this.mPi[atom] == 2 && this.mConnAtoms[atom] == 2 && this.mConnBondOrder[atom][0] == 2) {
            for (int i = 0; i < 2; ++i) {
                int alleneEnd = this.findAlleneEndAtom(atom, this.mConnAtom[atom][i]);
                if (alleneEnd == -1) continue;
                for (int j = 0; j < this.mConnAtoms[alleneEnd]; ++j) {
                    if (!this.isStereoBond(this.mConnBond[alleneEnd][j])) continue;
                    this.mBondType[this.mConnBond[alleneEnd][j]] = 1;
                }
            }
            return;
        }
        if (this.mPi[atom] == 0 || this.mAtomicNo[atom] >= 15) {
            for (int i = 0; i < this.mAllConnAtoms[atom]; ++i) {
                int connBond = this.mConnBond[atom][i];
                if (!this.isStereoBond(connBond, atom)) continue;
                this.mBondType[connBond] = 1;
            }
        }
    }

    public void setStereoBondFromAtomParity(int atom) {
        int bondType;
        int i;
        this.convertStereoBondsToSingleBonds(atom);
        if (this.getAtomParity(atom) == 0 || this.getAtomParity(atom) == 3) {
            return;
        }
        if (this.mPi[atom] == 2 && this.mConnAtoms[atom] == 2) {
            this.setAlleneStereoBondFromParity(atom);
            return;
        }
        if (this.mConnAtoms[atom] < 3 || this.mConnAtoms[atom] > 4) {
            this.setAtomParity(atom, 0, false);
            return;
        }
        int allConnAtoms = this.mAllConnAtoms[atom];
        boolean singleBondFound = false;
        for (int i2 = 0; i2 < allConnAtoms; ++i2) {
            if (this.getBondOrder(this.mConnBond[atom][i2]) != 1) continue;
            singleBondFound = true;
            break;
        }
        if (!singleBondFound) {
            return;
        }
        int[] sortedConnMap = this.getSortedConnMap(atom);
        double[] angle = new double[allConnAtoms];
        for (i = 0; i < allConnAtoms; ++i) {
            angle[i] = this.getBondAngle(this.mConnAtom[atom][sortedConnMap[i]], atom);
        }
        for (i = 0; i < allConnAtoms; ++i) {
            if (this.mBondAtom[0][this.mConnBond[atom][i]] != atom || this.getBondOrder(this.mConnBond[atom][i]) != 1) continue;
            this.mBondType[this.mConnBond[atom][i]] = 1;
        }
        if ((float)this.getAtomRingSize(atom) <= 24.0f && this.setFisherProjectionStereoBondsFromParity(atom, sortedConnMap, angle)) {
            return;
        }
        int preferredBond = -1;
        for (int i3 = 0; i3 < allConnAtoms; ++i3) {
            int connBond = this.mConnBond[atom][i3];
            if (!this.isStereoBond(connBond, atom)) continue;
            this.mBondType[this.mConnBond[atom][i3]] = 1;
            preferredBond = preferredBond == -1 ? connBond : -2;
        }
        if (preferredBond < 0) {
            preferredBond = this.preferredTHStereoBond(atom);
        }
        if (this.mBondAtom[0][preferredBond] != atom) {
            this.mBondAtom[1][preferredBond] = this.mBondAtom[0][preferredBond];
            this.mBondAtom[0][preferredBond] = atom;
        }
        int preferredBondIndex = -1;
        for (int i4 = 0; i4 < allConnAtoms; ++i4) {
            if (preferredBond != this.mConnBond[atom][sortedConnMap[i4]]) continue;
            preferredBondIndex = i4;
            break;
        }
        int[][] up_down = new int[][]{{2, 1, 2, 1}, {1, 2, 2, 1}, {1, 1, 2, 2}, {2, 1, 1, 2}, {2, 2, 1, 1}, {1, 2, 1, 2}};
        for (int i5 = 1; i5 < allConnAtoms; ++i5) {
            if (!(angle[i5] < angle[0])) continue;
            int n = i5;
            angle[n] = angle[n] + Math.PI * 2;
        }
        if (allConnAtoms == 3) {
            boolean inverted = false;
            switch (preferredBondIndex) {
                case 0: {
                    inverted = angle[1] < angle[2] && angle[2] - angle[1] < Math.PI || angle[1] > angle[2] && angle[1] - angle[2] > Math.PI;
                    break;
                }
                case 1: {
                    inverted = angle[2] - angle[0] > Math.PI;
                    break;
                }
                case 2: {
                    inverted = angle[1] - angle[0] < Math.PI;
                }
            }
            bondType = this.getAtomParity(atom) == 1 ^ inverted ? 17 : 9;
        } else {
            int order = 0;
            if (angle[1] <= angle[2] && angle[2] <= angle[3]) {
                order = 0;
            } else if (angle[1] <= angle[3] && angle[3] <= angle[2]) {
                order = 1;
            } else if (angle[2] <= angle[1] && angle[1] <= angle[3]) {
                order = 2;
            } else if (angle[2] <= angle[3] && angle[3] <= angle[1]) {
                order = 3;
            } else if (angle[3] <= angle[1] && angle[1] <= angle[2]) {
                order = 4;
            } else if (angle[3] <= angle[2] && angle[2] <= angle[1]) {
                order = 5;
            }
            bondType = this.getAtomParity(atom) == 1 ^ up_down[order][preferredBondIndex] == 1 ? 9 : 17;
        }
        this.mBondType[preferredBond] = bondType;
    }

    private boolean setFisherProjectionStereoBondsFromParity(int atom, int[] sortedConnMap, double[] angle) {
        int allConnAtoms = this.mAllConnAtoms[atom];
        int[] direction = new int[allConnAtoms];
        int parity = this.getFisherProjectionParity(atom, sortedConnMap, angle, direction);
        if (parity == 3) {
            return false;
        }
        int bondType = this.getAtomParity(atom) == parity ? 17 : 9;
        for (int i = 0; i < allConnAtoms; ++i) {
            if ((direction[i] & 1) != 1) continue;
            int bond = this.mConnBond[atom][sortedConnMap[i]];
            this.mBondType[bond] = bondType;
            if (this.mBondAtom[0][bond] == atom) continue;
            this.mBondAtom[1][bond] = this.mBondAtom[0][bond];
            this.mBondAtom[0][bond] = atom;
        }
        return true;
    }

    public int getFisherProjectionParity(int atom, int[] sortedConnMap, double[] angle, int[] direction) {
        if ((float)this.getAtomRingSize(atom) > 24.0f) {
            return 3;
        }
        int allConnAtoms = this.mAllConnAtoms[atom];
        if (direction == null) {
            direction = new int[allConnAtoms];
        }
        if (!this.getFisherProjectionBondDirections(atom, sortedConnMap, angle, direction)) {
            return 3;
        }
        int horizontalBondType = -1;
        for (int i = 0; i < allConnAtoms; ++i) {
            if ((direction[i] & 1) != 1) continue;
            int bondType = this.mBondType[this.mConnBond[atom][sortedConnMap[i]]];
            if (horizontalBondType != -1 && horizontalBondType != bondType) {
                return 3;
            }
            horizontalBondType = bondType;
        }
        int index = Math.abs(direction[0] - direction[1]) == 2 ? 1 : 0;
        int dif = direction[index] - direction[index + 1];
        boolean isClockwise = Math.abs(dif) == 3 ^ direction[index] < direction[index + 1];
        boolean is4thConnHorizontal = allConnAtoms == 3 || (direction[3] & 1) == 1;
        return isClockwise ^ is4thConnHorizontal ^ horizontalBondType == 9 ? 1 : 2;
    }

    private boolean getFisherProjectionBondDirections(int atom, int[] sortedConnMap, double[] angle, int[] direction) {
        int allConnAtoms = this.mAllConnAtoms[atom];
        if (this.mPi[atom] != 0 || this.isAromaticAtom(atom) || this.mConnAtoms[atom] < 3 || allConnAtoms > 4) {
            return false;
        }
        boolean[] isUsed = new boolean[4];
        for (int i = 0; i < allConnAtoms; ++i) {
            double a = 3.9269908169872414 - angle[i];
            if (Math.abs(0.7853981633974483 - a % 1.5707963267948966) > 0.0872664675116539) {
                return false;
            }
            direction[i] = 3 & (int)(a / 1.5707963267948966);
            if (isUsed[direction[i]]) {
                return false;
            }
            isUsed[direction[i]] = true;
            if (!((direction[i] & 1) == 0 ? this.mBondType[this.mConnBond[atom][sortedConnMap[i]]] != 1 : !this.isStereoBond(this.mConnBond[atom][sortedConnMap[i]], atom))) continue;
            return false;
        }
        return isUsed[0] && isUsed[2];
    }

    private void setAlleneStereoBondFromParity(int atom) {
        int connBond;
        int connAtom;
        int j;
        int alleneAtom;
        int i;
        if (this.mConnAtoms[atom] != 2 || this.mConnBondOrder[atom][0] != 2 || this.mConnBondOrder[atom][1] != 2 || this.mConnAtoms[this.mConnAtom[atom][0]] < 2 || this.mConnAtoms[this.mConnAtom[atom][1]] < 2 || this.mPi[this.mConnAtom[atom][0]] != 1 || this.mPi[this.mConnAtom[atom][1]] != 1) {
            this.setAtomParity(atom, 0, false);
            return;
        }
        int preferredBond = -1;
        int preferredAtom = -1;
        int preferredAlleneAtom = -1;
        int oppositeAlleneAtom = -1;
        int bestScore = 0;
        for (i = 0; i < 2; ++i) {
            alleneAtom = this.mConnAtom[atom][i];
            for (j = 0; j < this.mAllConnAtoms[alleneAtom]; ++j) {
                int score;
                connAtom = this.mConnAtom[alleneAtom][j];
                if (connAtom == atom || bestScore >= (score = this.getStereoBondScore(connBond = this.mConnBond[alleneAtom][j], connAtom))) continue;
                bestScore = score;
                preferredAtom = connAtom;
                preferredBond = connBond;
                preferredAlleneAtom = alleneAtom;
                oppositeAlleneAtom = this.mConnAtom[atom][1 - i];
            }
        }
        if (preferredAtom == -1) {
            return;
        }
        for (i = 0; i < 2; ++i) {
            alleneAtom = this.mConnAtom[atom][i];
            for (j = 0; j < this.mAllConnAtoms[alleneAtom]; ++j) {
                connAtom = this.mConnAtom[alleneAtom][j];
                connBond = this.mConnBond[alleneAtom][j];
                if (connAtom == atom || this.mBondAtom[0][connBond] != alleneAtom) continue;
                this.mBondType[connBond] = 1;
            }
        }
        if (this.mBondAtom[1][preferredBond] != preferredAtom) {
            this.mBondAtom[0][preferredBond] = this.mBondAtom[1][preferredBond];
            this.mBondAtom[1][preferredBond] = preferredAtom;
        }
        int highPriorityAtom = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < this.mConnAtoms[preferredAlleneAtom]; ++i2) {
            int connAtom2 = this.mConnAtom[preferredAlleneAtom][i2];
            if (connAtom2 == atom || highPriorityAtom <= connAtom2) continue;
            highPriorityAtom = connAtom2;
        }
        int[] oppositeAtom = new int[2];
        int oppositeAtoms = 0;
        for (int i3 = 0; i3 < this.mConnAtoms[oppositeAlleneAtom]; ++i3) {
            int connAtom3 = this.mConnAtom[oppositeAlleneAtom][i3];
            if (connAtom3 == atom) continue;
            oppositeAtom[oppositeAtoms++] = connAtom3;
        }
        double alleneAngle = this.getBondAngle(atom, oppositeAlleneAtom);
        double angleDif = 0.0;
        if (oppositeAtoms == 2) {
            if (oppositeAtom[0] > oppositeAtom[1]) {
                int temp = oppositeAtom[0];
                oppositeAtom[0] = oppositeAtom[1];
                oppositeAtom[1] = temp;
            }
            double hpAngleDif = ExtendedMolecule.getAngleDif(alleneAngle, this.getBondAngle(oppositeAlleneAtom, oppositeAtom[0]));
            double lpAngleDif = ExtendedMolecule.getAngleDif(alleneAngle, this.getBondAngle(oppositeAlleneAtom, oppositeAtom[1]));
            angleDif = hpAngleDif - lpAngleDif;
        } else {
            angleDif = ExtendedMolecule.getAngleDif(alleneAngle, this.getBondAngle(oppositeAlleneAtom, oppositeAtom[0]));
        }
        this.mBondType[preferredBond] = angleDif < 0.0 ^ this.getAtomParity(atom) == 1 ^ highPriorityAtom == preferredAtom ? 17 : 9;
    }

    public void setStereoBondFromBondParity(int bond) {
        int i;
        if (this.getBondParity(bond) == 0 || this.getBondParity(bond) == 3 || !this.isBINAPChiralityBond(bond)) {
            return;
        }
        int preferredBond = -1;
        int preferredAtom = -1;
        int preferredBINAPAtom = -1;
        int oppositeBINAPAtom = -1;
        int bestScore = 0;
        for (i = 0; i < 2; ++i) {
            int atom = this.mBondAtom[i][bond];
            for (int j = 0; j < this.mAllConnAtoms[atom]; ++j) {
                int connAtom;
                int score;
                int connBond = this.mConnBond[atom][j];
                if (connBond == bond || this.getBondOrder(connBond) != 1 || bestScore >= (score = this.getStereoBondScore(connBond, connAtom = this.mConnAtom[atom][j]))) continue;
                bestScore = score;
                preferredAtom = connAtom;
                preferredBond = connBond;
                preferredBINAPAtom = atom;
                oppositeBINAPAtom = this.mBondAtom[1 - i][bond];
            }
        }
        if (preferredAtom == -1) {
            return;
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < this.mAllConnAtoms[this.mBondAtom[i][bond]]; ++j) {
                int connBond = this.mConnBond[this.mBondAtom[i][bond]][j];
                if (connBond == bond || this.getBondOrder(connBond) != 1) continue;
                this.mBondType[connBond] = 1;
            }
        }
        if (this.mBondAtom[1][preferredBond] != preferredAtom) {
            this.mBondAtom[0][preferredBond] = this.mBondAtom[1][preferredBond];
            this.mBondAtom[1][preferredBond] = preferredAtom;
        }
        int highPriorityAtom = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < this.mConnAtoms[preferredBINAPAtom]; ++i2) {
            int connAtom = this.mConnAtom[preferredBINAPAtom][i2];
            if (this.mConnBond[preferredBINAPAtom][i2] == bond || highPriorityAtom <= connAtom) continue;
            highPriorityAtom = connAtom;
        }
        int[] oppositeAtom = new int[2];
        int oppositeAtoms = 0;
        for (int i3 = 0; i3 < this.mConnAtoms[oppositeBINAPAtom]; ++i3) {
            if (this.mConnBond[oppositeBINAPAtom][i3] == bond) continue;
            oppositeAtom[oppositeAtoms++] = this.mConnAtom[oppositeBINAPAtom][i3];
        }
        double binapAngle = this.getBondAngle(preferredBINAPAtom, oppositeBINAPAtom);
        double angleDif = 0.0;
        if (oppositeAtoms == 2) {
            if (oppositeAtom[0] > oppositeAtom[1]) {
                int temp = oppositeAtom[0];
                oppositeAtom[0] = oppositeAtom[1];
                oppositeAtom[1] = temp;
            }
            double hpAngleDif = ExtendedMolecule.getAngleDif(binapAngle, this.getBondAngle(oppositeBINAPAtom, oppositeAtom[0]));
            double lpAngleDif = ExtendedMolecule.getAngleDif(binapAngle, this.getBondAngle(oppositeBINAPAtom, oppositeAtom[1]));
            angleDif = hpAngleDif - lpAngleDif;
        } else {
            angleDif = ExtendedMolecule.getAngleDif(binapAngle, this.getBondAngle(oppositeBINAPAtom, oppositeAtom[0]));
        }
        this.mBondType[preferredBond] = angleDif < 0.0 ^ this.getBondParity(bond) == 2 ^ highPriorityAtom == preferredAtom ? 17 : 9;
    }

    protected boolean bondsAreParallel(double angle1, double angle2) {
        double angleDif = Math.abs(ExtendedMolecule.getAngleDif(angle1, angle2));
        return angleDif < 0.08 || angleDif > 3.061592653589793;
    }

    private int preferredTHStereoBond(int atom) {
        int i;
        int allConnAtoms = this.mAllConnAtoms[atom];
        double[] angle = new double[allConnAtoms];
        for (i = 0; i < allConnAtoms; ++i) {
            angle[i] = this.getBondAngle(atom, this.mConnAtom[atom][i]);
        }
        for (i = 1; i < allConnAtoms; ++i) {
            for (int j = 0; j < i; ++j) {
                int bond;
                if (!this.bondsAreParallel(angle[i], angle[j])) continue;
                float angleDistanceSum1 = 0.0f;
                float angleDistanceSum2 = 0.0f;
                for (int k = 0; k < allConnAtoms; ++k) {
                    if (k == i || k == j) continue;
                    angleDistanceSum1 = (float)((double)angleDistanceSum1 + Math.abs(Angle.difference(angle[i], angle[k])));
                    angleDistanceSum2 = (float)((double)angleDistanceSum2 + Math.abs(Angle.difference(angle[j], angle[k])));
                }
                int n = bond = angleDistanceSum1 < angleDistanceSum2 ? this.mConnBond[atom][i] : this.mConnBond[atom][j];
                if (this.getBondOrder(bond) != 1) continue;
                return bond;
            }
        }
        int preferredBond = -1;
        int bestScore = 0;
        for (int i2 = 0; i2 < allConnAtoms; ++i2) {
            int connBond = this.mConnBond[atom][i2];
            int connAtom = this.mConnAtom[atom][i2];
            int score = this.getStereoBondScore(connBond, connAtom);
            if (bestScore >= score) continue;
            bestScore = score;
            preferredBond = connBond;
        }
        return preferredBond;
    }

    private int preferredAlleneStereoBond(int atom) {
        int preferredBond = -1;
        int bestScore = 0;
        for (int i = 0; i < 2; ++i) {
            int alleneAtom = this.mConnAtom[atom][i];
            for (int j = 0; j < this.mAllConnAtoms[alleneAtom]; ++j) {
                int connBond;
                int score;
                int connAtom = this.mConnAtom[alleneAtom][j];
                if (connAtom == atom || bestScore >= (score = this.getStereoBondScore(connBond = this.mConnBond[alleneAtom][j], connAtom))) continue;
                bestScore = score;
                preferredBond = connBond;
            }
        }
        return preferredBond;
    }

    private int preferredBinapStereoBond(int bond) {
        int preferredBond = -1;
        int bestScore = 0;
        for (int i = 0; i < 2; ++i) {
            int atom = this.mBondAtom[i][bond];
            for (int j = 0; j < this.mAllConnAtoms[atom]; ++j) {
                int connBond;
                int score;
                int connAtom = this.mConnAtom[atom][j];
                if (connAtom == this.mBondAtom[1 - i][bond] || bestScore >= (score = this.getStereoBondScore(connBond = this.mConnBond[atom][j], connAtom))) continue;
                bestScore = score;
                preferredBond = connBond;
            }
        }
        return preferredBond;
    }

    public int findAlleneCenterAtom(int atom) {
        int center = -1;
        if (this.mPi[atom] == 1) {
            block0: for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
                if (this.mConnBondOrder[atom][i] != 2) continue;
                int connAtom = this.mConnAtom[atom][i];
                if (this.mConnAtoms[connAtom] != 2 || this.mPi[connAtom] != 2) break;
                for (int j = 0; j < 2; ++j) {
                    int endAtom = this.mConnAtom[connAtom][j];
                    if (endAtom == atom || this.mPi[endAtom] != 1) continue;
                    center = connAtom;
                    break block0;
                }
                break;
            }
        }
        return center;
    }

    public int findAlleneEndAtom(int atom1, int atom2) {
        int startAtom = atom1;
        while (this.mConnAtoms[atom2] == 2 && this.mPi[atom2] == 2 && atom2 != startAtom) {
            int temp = atom2;
            atom2 = this.mConnAtom[atom2][0] == atom1 ? this.mConnAtom[atom2][1] : this.mConnAtom[atom2][0];
            atom1 = temp;
        }
        return atom2 == startAtom ? -1 : atom2;
    }

    private int findBINAPOppositeAtom(int atom) {
        if (this.mConnAtoms[atom] == 3 && this.isAromaticAtom(atom) && this.getAtomRingSize(atom) >= 6) {
            for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
                if (!this.isBINAPChiralityBond(this.mConnBond[atom][i])) continue;
                return this.mConnAtom[atom][i];
            }
        }
        return -1;
    }

    public int findBINAPChiralityBond(int atom) {
        if (this.mConnAtoms[atom] == 3 && this.isAromaticAtom(atom) && this.getAtomRingSize(atom) >= 5) {
            for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
                if (!this.isBINAPChiralityBond(this.mConnBond[atom][i])) continue;
                return this.mConnBond[atom][i];
            }
        }
        return -1;
    }

    public boolean isAmideTypeBond(int bond) {
        this.ensureHelperArrays(1);
        for (int i = 0; i < 2; ++i) {
            int atom1 = this.mBondAtom[i][bond];
            if (this.mAtomicNo[atom1] != 7) continue;
            int atom2 = this.mBondAtom[1 - i][bond];
            for (int j = 0; j < this.mConnAtoms[atom2]; ++j) {
                int connAtom = this.mConnAtom[atom2][j];
                int connBond = this.mConnBond[atom2][j];
                if (this.mAtomicNo[connAtom] != 7 && this.mAtomicNo[connAtom] != 8 && this.mAtomicNo[connAtom] != 16 || this.getBondOrder(connBond) < 2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCentralAlleneAtom(int atom) {
        return this.mPi[atom] == 2 && this.mConnAtoms[atom] == 2 && this.mConnBondOrder[atom][0] == 2 && this.mConnBondOrder[atom][1] == 2 && this.mAtomicNo[atom] <= 7;
    }

    public boolean isFlatNitrogen(int atom) {
        int connAtom;
        int i;
        if (this.mAtomicNo[atom] != 7) {
            return false;
        }
        if (this.isAromaticAtom(atom) || this.mPi[atom] != 0 || (this.mAtomQueryFeatures[atom] & 0x10000000L) != 0L) {
            return true;
        }
        if (this.mAtomCharge[atom] == 1) {
            return false;
        }
        int heteroCount = 0;
        for (i = 0; i < this.mConnAtoms[atom]; ++i) {
            int atomicNo;
            if (this.mConnBondOrder[atom][i] != 1 || (atomicNo = this.mAtomicNo[this.mConnAtom[atom][i]]) != 8 && atomicNo != 9 && atomicNo != 17) continue;
            ++heteroCount;
        }
        if (heteroCount == 0) {
            for (i = 0; i < this.mConnAtoms[atom]; ++i) {
                connAtom = this.mConnAtom[atom][i];
                if (this.mPi[connAtom] == 0) continue;
                if (this.isAromaticAtom(connAtom)) {
                    if (this.getAtomRingSize(connAtom) >= 5) {
                        int orthoSubstituentCount = 0;
                        for (int j = 0; j < this.mConnAtoms[connAtom]; ++j) {
                            int ortho = this.mConnAtom[connAtom][j];
                            if (ortho == atom || this.getNonHydrogenNeighbourCount(ortho) < 3) continue;
                            ++orthoSubstituentCount;
                        }
                        int nitrogenNeighbourCount = this.getNonHydrogenNeighbourCount(atom);
                        if (orthoSubstituentCount == 2 && nitrogenNeighbourCount >= 2 || orthoSubstituentCount == 1 && nitrogenNeighbourCount == 3) continue;
                    }
                    return true;
                }
                for (int j = 0; j < this.mConnAtoms[connAtom]; ++j) {
                    if (this.mConnBondOrder[connAtom][j] != 2 && !this.isAromaticBond(this.mConnBond[connAtom][j])) continue;
                    return true;
                }
            }
        }
        if (heteroCount < 2) {
            for (i = 0; i < this.mConnAtoms[atom]; ++i) {
                connAtom = this.mConnAtom[atom][i];
                boolean isStabilized = false;
                boolean hasCompetitor = false;
                for (int j = 0; j < this.mConnAtoms[connAtom]; ++j) {
                    if (this.mConnAtom[connAtom][j] == atom) continue;
                    if (this.mConnBondOrder[connAtom][j] != 1 && (this.mAtomicNo[this.mConnAtom[connAtom][j]] == 7 || this.mAtomicNo[this.mConnAtom[connAtom][j]] == 8 || this.mAtomicNo[this.mConnAtom[connAtom][j]] == 16)) {
                        isStabilized = true;
                    }
                    if (this.mConnBondOrder[connAtom][j] != 1 || this.mAtomicNo[this.mConnAtom[connAtom][j]] != 7) continue;
                    hasCompetitor = true;
                }
                if (!isStabilized || hasCompetitor && heteroCount != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBINAPChiralityBond(int bond) {
        if (this.mBondType[bond] != 1 || this.isAromaticBond(bond) || this.isRingBond(bond) && this.getBondRingSize(bond) < 7) {
            return false;
        }
        int atom1 = this.mBondAtom[0][bond];
        if (!this.isAromaticAtom(atom1) || this.getAtomRingSize(atom1) < 5) {
            return false;
        }
        int atom2 = this.mBondAtom[1][bond];
        if (!this.isAromaticAtom(atom2) || this.getAtomRingSize(atom2) < 5) {
            return false;
        }
        int orthoSubstituentCount1 = this.getOrthoSubstituentCount(atom1, atom2);
        int orthoSubstituentCount2 = this.getOrthoSubstituentCount(atom2, atom1);
        if (this.getAtomRingSize(atom1) > 5 && this.getAtomRingSize(atom2) > 5) {
            return orthoSubstituentCount1 + orthoSubstituentCount2 > 2;
        }
        int secondOrderOrthoSubstituentCount1 = this.getSecondOrderOrthoSubstituentCount(atom1, atom2);
        int secondOrderOrthoSubstituentCount2 = this.getSecondOrderOrthoSubstituentCount(atom2, atom1);
        if (orthoSubstituentCount1 == 2 && secondOrderOrthoSubstituentCount2 >= 1) {
            return true;
        }
        if (orthoSubstituentCount2 == 2 && secondOrderOrthoSubstituentCount1 >= 1) {
            return true;
        }
        if (secondOrderOrthoSubstituentCount1 == 2 && (orthoSubstituentCount2 >= 1 || secondOrderOrthoSubstituentCount2 >= 1)) {
            return true;
        }
        return secondOrderOrthoSubstituentCount2 == 2 && (orthoSubstituentCount1 >= 1 || secondOrderOrthoSubstituentCount1 >= 1);
    }

    private int getOrthoSubstituentCount(int atom, int otherBondAtom) {
        int count = 0;
        for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
            int connAtom = this.mConnAtom[atom][i];
            if (connAtom == otherBondAtom || this.mConnAtoms[connAtom] <= 2) continue;
            ++count;
            break;
        }
        return count;
    }

    private int getSecondOrderOrthoSubstituentCount(int atom, int otherBondAtom) {
        int count = 0;
        for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
            int connAtom = this.mConnAtom[atom][i];
            if (connAtom == otherBondAtom) continue;
            int innerCount = 0;
            for (int j = 0; j < this.mConnAtoms[connAtom]; ++j) {
                int nextConnAtom = this.mConnAtom[connAtom][j];
                if (nextConnAtom == atom || !this.isAromaticBond(this.mConnBond[connAtom][j]) || this.mConnAtoms[nextConnAtom] <= 2) continue;
                ++innerCount;
            }
            if (innerCount != 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected boolean validateBondType(int bond, int type) {
        boolean ok = super.validateBondType(bond, type);
        if (ok && type == 26) {
            this.ensureHelperArrays(7);
            ok &= !this.isSmallRingBond(bond);
        }
        return ok;
    }

    public void validate() throws Exception {
        double avbl = this.getAverageBondLength();
        double minDistanceSquare = avbl * avbl / 16.0;
        for (int atom1 = 1; atom1 < this.mAllAtoms; ++atom1) {
            for (int atom2 = 0; atom2 < atom1; ++atom2) {
                double xdif = this.mCoordinates[atom2].x - this.mCoordinates[atom1].x;
                double ydif = this.mCoordinates[atom2].y - this.mCoordinates[atom1].y;
                double zdif = this.mCoordinates[atom2].z - this.mCoordinates[atom1].z;
                if (!(xdif * xdif + ydif * ydif + zdif * zdif < minDistanceSquare)) continue;
                throw new Exception("The distance between two atoms is too close.");
            }
        }
        this.ensureHelperArrays(1);
        int allCharge = 0;
        for (int atom = 0; atom < this.mAtoms; ++atom) {
            if (this.getOccupiedValence(atom) > this.getMaxValence(atom)) {
                throw new Exception("atom valence exceeded");
            }
            allCharge += this.mAtomCharge[atom];
        }
        if (allCharge != 0) {
            throw new Exception("unbalanced atom charge");
        }
    }

    public boolean normalizeAmbiguousBonds() {
        int i;
        this.ensureHelperArrays(1);
        this.normalizeExplicitlyDelocalizedBonds();
        boolean found = false;
        block0: for (int atom = 0; atom < this.mAtoms; ++atom) {
            int connAtom;
            if (this.mAtomicNo[atom] != 7 || this.mAtomCharge[atom] != 0) continue;
            int valence = this.getOccupiedValence(atom);
            if (valence == 4) {
                for (i = 0; i < this.mConnAtoms[atom]; ++i) {
                    connAtom = this.mConnAtom[atom][i];
                    if (this.mConnBondOrder[atom][i] != 1 || this.mAtomicNo[connAtom] != 8 || this.mConnAtoms[connAtom] != 1 || this.mAtomCharge[connAtom] != 0) continue;
                    found = true;
                    int n = atom;
                    this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
                    int n2 = connAtom;
                    this.mAtomCharge[n2] = this.mAtomCharge[n2] - 1;
                    continue block0;
                }
                continue;
            }
            if (valence != 5) continue;
            for (i = 0; i < this.mConnAtoms[atom]; ++i) {
                connAtom = this.mConnAtom[atom][i];
                int connBond = this.mConnBond[atom][i];
                if (this.mConnBondOrder[atom][i] == 2 && this.mAtomicNo[connAtom] == 8) {
                    found = true;
                    int n = atom;
                    this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
                    int n3 = connAtom;
                    this.mAtomCharge[n3] = this.mAtomCharge[n3] - 1;
                    this.mBondType[connBond] = 1;
                    continue block0;
                }
                if (this.mConnBondOrder[atom][i] != 3 || this.mAtomicNo[connAtom] != 7) continue;
                found = true;
                int n = atom;
                this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
                int n4 = connAtom;
                this.mAtomCharge[n4] = this.mAtomCharge[n4] - 1;
                this.mBondType[connBond] = 2;
                continue block0;
            }
        }
        boolean bondDeleted = false;
        block3: for (int bond = 0; bond < this.mBonds; ++bond) {
            for (i = 0; i < 2; ++i) {
                if (!this.isElectronegative(this.mBondAtom[i][bond])) continue;
                int atom = this.mBondAtom[1 - i][bond];
                if (!this.isAlkaliMetal(atom) && !this.isEarthAlkaliMetal(atom)) continue block3;
                if (this.getBondOrder(bond) == 1) {
                    int n = atom;
                    this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
                    int n5 = this.mBondAtom[i][bond];
                    this.mAtomCharge[n5] = this.mAtomCharge[n5] - 1;
                    this.mBondType[bond] = 128;
                    bondDeleted = true;
                    continue block3;
                }
                if (this.mBondType[bond] != 32) continue block3;
                this.mBondType[bond] = 128;
                bondDeleted = true;
                continue block3;
            }
        }
        if (bondDeleted) {
            this.compressMolTable();
            found = true;
        }
        if (found) {
            this.mValidHelperArrays = 0;
        }
        return found;
    }

    private boolean normalizeExplicitlyDelocalizedBonds() {
        for (int bond = 0; bond < this.mBonds; ++bond) {
            if (this.mBondType[bond] != 64) continue;
            return new AromaticityResolver(this).locateDelocalizedDoubleBonds(null);
        }
        return false;
    }

    public boolean isAlkaliMetal(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo == 3 || atomicNo == 11 || atomicNo == 19 || atomicNo == 37 || atomicNo == 55;
    }

    public boolean isEarthAlkaliMetal(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo == 12 || atomicNo == 20 || atomicNo == 38 || atomicNo == 56;
    }

    public boolean isNitrogenFamily(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo == 7 || atomicNo == 15 || atomicNo == 33;
    }

    public boolean isChalcogene(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo == 8 || atomicNo == 16 || atomicNo == 34 || atomicNo == 52;
    }

    public boolean isHalogene(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo == 9 || atomicNo == 17 || atomicNo == 35 || atomicNo == 53;
    }

    public int canonizeCharge(boolean allowUnbalancedCharge) throws Exception {
        return this.canonizeCharge(allowUnbalancedCharge, false);
    }

    public int canonizeCharge(boolean allowUnbalancedCharge, boolean doNeutralize) throws Exception {
        int negativeChargeForRemoval;
        this.ensureHelperArrays(1);
        if (doNeutralize) {
            allowUnbalancedCharge = true;
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            int atom2;
            int atom1;
            int bondOrder = this.getBondOrder(bond);
            if (bondOrder != 1 && bondOrder != 2) continue;
            if (this.mAtomCharge[this.mBondAtom[0][bond]] > 0 && this.mAtomCharge[this.mBondAtom[1][bond]] < 0) {
                atom1 = this.mBondAtom[0][bond];
                atom2 = this.mBondAtom[1][bond];
            } else {
                if (this.mAtomCharge[this.mBondAtom[0][bond]] >= 0 || this.mAtomCharge[this.mBondAtom[1][bond]] <= 0) continue;
                atom1 = this.mBondAtom[1][bond];
                atom2 = this.mBondAtom[0][bond];
            }
            if (this.isMetalAtom(atom1) || this.isMetalAtom(atom2) || this.mAtomicNo[atom1] < 9 && this.getOccupiedValence(atom1) > 3 || this.mAtomicNo[atom2] < 9 && this.getOccupiedValence(atom2) > 3) continue;
            boolean hasImplicitHydrogen = this.getImplicitHydrogens(atom1) != 0;
            int n = atom1;
            this.mAtomCharge[n] = this.mAtomCharge[n] - 1;
            int n2 = atom2;
            this.mAtomCharge[n2] = this.mAtomCharge[n2] + 1;
            if (!hasImplicitHydrogen) {
                int stereoCenter;
                int newStereoBond;
                int oldBondType = this.mBondType[bond];
                this.mBondType[bond] = bondOrder == 1 ? 2 : 4;
                if ((oldBondType == 9 || oldBondType == 17) && this.mBondAtom[0][newStereoBond = this.preferredTHStereoBond(stereoCenter = this.mBondAtom[0][bond])] != stereoCenter) {
                    this.mBondAtom[1][newStereoBond] = this.mBondAtom[0][newStereoBond];
                    this.mBondAtom[1][newStereoBond] = stereoCenter;
                }
            }
            this.mValidHelperArrays = 0;
        }
        int overallCharge = 0;
        int negativeAtomCount = 0;
        int negativeAdjustableCharge = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            overallCharge += this.mAtomCharge[atom];
            if (this.mAtomCharge[atom] >= 0 || this.hasPositiveNeighbour(atom)) continue;
            ++negativeAtomCount;
            if (!this.isElectronegative(atom)) continue;
            negativeAdjustableCharge -= this.mAtomCharge[atom];
        }
        if (!allowUnbalancedCharge && overallCharge != 0) {
            throw new Exception("molecule's overall charges are not balanced");
        }
        this.ensureHelperArrays(1);
        int overallChargeChange = 0;
        int positiveChargeForRemoval = doNeutralize ? overallCharge + negativeAdjustableCharge : negativeAdjustableCharge;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            int chargeReduction;
            if (this.mAtomCharge[atom] <= 0 || this.hasNegativeNeighbour(atom) || !this.isElectronegative(atom) || (chargeReduction = Math.min(this.getImplicitHydrogens(atom), this.mAtomCharge[atom])) == 0 || positiveChargeForRemoval < chargeReduction) continue;
            overallCharge -= chargeReduction;
            overallChargeChange -= chargeReduction;
            positiveChargeForRemoval -= chargeReduction;
            int n = atom;
            this.mAtomCharge[n] = this.mAtomCharge[n] - chargeReduction;
            this.mValidHelperArrays &= 1;
        }
        int n = negativeChargeForRemoval = doNeutralize ? overallCharge : overallChargeChange;
        if (negativeChargeForRemoval < 0) {
            int[] negativeAtom = new int[negativeAtomCount];
            negativeAtomCount = 0;
            for (int atom = 0; atom < this.mAllAtoms; ++atom) {
                if (this.mAtomCharge[atom] >= 0 || this.hasPositiveNeighbour(atom)) continue;
                negativeAtom[negativeAtomCount++] = (this.mAtomicNo[atom] << 22) + atom;
            }
            Arrays.sort(negativeAtom);
            for (int i = negativeAtom.length - 1; negativeChargeForRemoval < 0 && i >= negativeAtom.length - negativeAtomCount; --i) {
                int atom = negativeAtom[i] & 0x3FFFFF;
                if (!this.isElectronegative(atom)) continue;
                int chargeReduction = Math.min(-negativeChargeForRemoval, -this.mAtomCharge[atom]);
                overallCharge += chargeReduction;
                negativeChargeForRemoval += chargeReduction;
                int n3 = atom;
                this.mAtomCharge[n3] = this.mAtomCharge[n3] + chargeReduction;
                this.mValidHelperArrays &= 1;
            }
        }
        return overallCharge;
    }

    private boolean hasNegativeNeighbour(int atom) {
        for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
            if (this.mAtomCharge[this.mConnAtom[atom][i]] >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasPositiveNeighbour(int atom) {
        for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
            if (this.mAtomCharge[this.mConnAtom[atom][i]] <= 0) continue;
            return true;
        }
        return false;
    }

    public int getZNeighbour(int connAtom, int bond) {
        if (this.getBondOrder(bond) != 2 && !this.isAromaticBond(bond)) {
            return -1;
        }
        int parity = this.getBondParity(bond);
        if (parity != 1 && parity != 2) {
            return -1;
        }
        for (int i = 0; i < 2; ++i) {
            int atom1 = this.mBondAtom[i][bond];
            int atom2 = this.mBondAtom[1 - i][bond];
            int other1 = -1;
            boolean found = false;
            for (int j = 0; j < this.mConnAtoms[atom1]; ++j) {
                int conn = this.mConnAtom[atom1][j];
                if (conn == atom2) continue;
                if (conn == connAtom) {
                    found = true;
                    continue;
                }
                other1 = conn;
            }
            if (!found) continue;
            int lowConn = -1;
            int highConn = -1;
            for (int j = 0; j < this.mConnAtoms[atom2]; ++j) {
                int conn = this.mConnAtom[atom2][j];
                if (conn == atom1) continue;
                if (lowConn == -1) {
                    lowConn = conn;
                    continue;
                }
                if (conn > lowConn) {
                    highConn = conn;
                    continue;
                }
                highConn = lowConn;
                lowConn = conn;
            }
            if (this.mConnAtoms[atom1] == 2) {
                if (this.mConnAtoms[atom2] == 2) {
                    return parity == 2 ? lowConn : -1;
                }
                return parity == 2 ? lowConn : highConn;
            }
            if (this.mConnAtoms[atom2] == 2) {
                return parity == 2 ^ connAtom < other1 ? -1 : lowConn;
            }
            return parity == 2 ^ connAtom < other1 ? highConn : lowConn;
        }
        return -1;
    }

    public int getHelperArrayStatus() {
        return this.mValidHelperArrays;
    }

    public void ensureHelperArrays(int required) {
        if ((required & ~this.mValidHelperArrays) == 0) {
            return;
        }
        if ((this.mValidHelperArrays & 1) == 0) {
            this.handleHydrogens();
            this.calculateNeighbours();
            this.mValidHelperArrays |= 1;
            if (this.validateQueryFeatures()) {
                this.handleHydrogens();
                this.calculateNeighbours();
            }
        }
        if ((required & ~this.mValidHelperArrays) == 0) {
            return;
        }
        if ((this.mValidHelperArrays & 0xFFFFFFF9) != 0) {
            boolean found;
            int connAtom;
            int atom = 0;
            while (atom < this.mAtoms) {
                int n = atom++;
                this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFF83F7;
            }
            int bond = 0;
            while (bond < this.mBonds) {
                int n = bond++;
                this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFFFC3F;
            }
            if ((required & 4) == 0) {
                this.findRings(1);
                this.mValidHelperArrays |= 2;
                return;
            }
            this.findRings(7);
            for (bond = 0; bond < this.mBonds; ++bond) {
                if (this.mBondType[bond] != 64) continue;
                int n = this.mBondAtom[0][bond];
                this.mAtomFlags[n] = this.mAtomFlags[n] | 0x1000;
                int n2 = this.mBondAtom[1][bond];
                this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x1000;
                int n3 = bond;
                this.mBondFlags[n3] = this.mBondFlags[n3] | 0x100;
                int n4 = bond;
                this.mBondFlags[n4] = this.mBondFlags[n4] | 0x200;
            }
            for (atom = 0; atom < this.mAtoms; ++atom) {
                for (int i = 0; i < this.mConnAtoms[atom]; ++i) {
                    int connBond = this.mConnBond[atom][i];
                    if (this.isAromaticBond(connBond)) continue;
                    connAtom = this.mConnAtom[atom][i];
                    for (int j = 0; j < this.mConnAtoms[connAtom]; ++j) {
                        if (this.mConnBond[connAtom][j] == connBond || this.mConnBondOrder[connAtom][j] <= 1) continue;
                        if (this.mAtomicNo[this.mConnAtom[connAtom][j]] == 6) {
                            int n = atom;
                            this.mAtomFlags[n] = this.mAtomFlags[n] | 0x2000;
                            continue;
                        }
                        if (this.isAromaticBond(this.mConnBond[connAtom][j]) || !this.isElectronegative(this.mConnAtom[connAtom][j])) continue;
                        int n = atom;
                        this.mAtomFlags[n] = this.mAtomFlags[n] | 0x4000;
                    }
                }
            }
            do {
                found = false;
                for (int atom2 = 0; atom2 < this.mAtoms; ++atom2) {
                    if (this.mPi[atom2] <= 0 || (0x5000 & this.mAtomFlags[atom2]) != 16384) continue;
                    for (int i = 0; i < this.mConnAtoms[atom2]; ++i) {
                        if (this.mConnBondOrder[atom2][i] <= 1) continue;
                        connAtom = this.mConnAtom[atom2][i];
                        int connBond = this.mConnBond[atom2][i];
                        for (int j = 0; j < this.mConnAtoms[connAtom]; ++j) {
                            int candidate;
                            if (this.mConnBond[connAtom][j] == connBond || (this.mAtomFlags[candidate = this.mConnAtom[connAtom][j]] & 0x4000) != 0) continue;
                            int n = candidate;
                            this.mAtomFlags[n] = this.mAtomFlags[n] | 0x4000;
                            found = true;
                        }
                    }
                }
            } while (found);
        }
        this.mValidHelperArrays |= 6;
    }

    private void handleHydrogens() {
        boolean[] isHydrogen = this.findSimpleHydrogens();
        int lastNonHAtom = this.mAllAtoms;
        while (--lastNonHAtom >= 0 && isHydrogen[lastNonHAtom]) {
        }
        for (int atom = 0; atom < lastNonHAtom; ++atom) {
            if (!isHydrogen[atom]) continue;
            this.swapAtoms(atom, lastNonHAtom);
            boolean temp = isHydrogen[atom];
            isHydrogen[atom] = isHydrogen[lastNonHAtom];
            isHydrogen[lastNonHAtom] = temp;
            while (isHydrogen[--lastNonHAtom]) {
            }
        }
        this.mAtoms = lastNonHAtom + 1;
        if (this.mAllAtoms == this.mAtoms) {
            this.mBonds = this.mAllBonds;
            return;
        }
        boolean[] isHydrogenBond = new boolean[this.mAllBonds];
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            int atom1 = this.mBondAtom[0][bond];
            int atom2 = this.mBondAtom[1][bond];
            if (!isHydrogen[atom1] && !isHydrogen[atom2]) continue;
            isHydrogenBond[bond] = true;
        }
        int lastNonHBond = this.mAllBonds;
        while (--lastNonHBond >= 0 && isHydrogenBond[lastNonHBond]) {
        }
        for (int bond = 0; bond < lastNonHBond; ++bond) {
            if (!isHydrogenBond[bond]) continue;
            int tempInt = this.mBondAtom[0][bond];
            this.mBondAtom[0][bond] = this.mBondAtom[0][lastNonHBond];
            this.mBondAtom[0][lastNonHBond] = tempInt;
            tempInt = this.mBondAtom[1][bond];
            this.mBondAtom[1][bond] = this.mBondAtom[1][lastNonHBond];
            this.mBondAtom[1][lastNonHBond] = tempInt;
            tempInt = this.mBondType[bond];
            this.mBondType[bond] = this.mBondType[lastNonHBond];
            this.mBondType[lastNonHBond] = tempInt;
            isHydrogenBond[bond] = false;
            while (isHydrogenBond[--lastNonHBond]) {
            }
        }
        this.mBonds = lastNonHBond + 1;
    }

    public int[] getHandleHydrogenMap() {
        return this.getHandleHydrogenAtomMap(this.findSimpleHydrogens());
    }

    public int[] getHandleHydrogenAtomMap(boolean[] isSimpleHydrogen) {
        int[] map = new int[this.mAllAtoms];
        for (int i = 0; i < this.mAllAtoms; ++i) {
            map[i] = i;
        }
        int lastNonHAtom = this.mAllAtoms;
        while (--lastNonHAtom >= 0 && isSimpleHydrogen[lastNonHAtom]) {
        }
        for (int i = 0; i < lastNonHAtom; ++i) {
            if (!isSimpleHydrogen[map[i]]) continue;
            int tempIndex = map[i];
            map[i] = map[lastNonHAtom];
            map[lastNonHAtom] = tempIndex;
            boolean temp = isSimpleHydrogen[i];
            isSimpleHydrogen[i] = isSimpleHydrogen[lastNonHAtom];
            isSimpleHydrogen[lastNonHAtom] = temp;
            while (isSimpleHydrogen[--lastNonHAtom]) {
            }
        }
        return map;
    }

    public int[] getHandleHydrogenBondMap() {
        boolean[] isSimpleHydrogen = this.findSimpleHydrogens();
        int[] map = new int[this.mAllBonds];
        for (int i = 0; i < this.mAllBonds; ++i) {
            map[i] = i;
        }
        boolean[] isHydrogenBond = new boolean[this.mAllBonds];
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            isHydrogenBond[bond] = isSimpleHydrogen[this.mBondAtom[0][bond]] || isSimpleHydrogen[this.mBondAtom[1][bond]];
        }
        int lastNonHBond = this.mAllBonds;
        while (--lastNonHBond >= 0 && isHydrogenBond[lastNonHBond]) {
        }
        for (int i = 0; i < lastNonHBond; ++i) {
            if (!isHydrogenBond[map[i]]) continue;
            int tempIndex = map[i];
            map[i] = map[lastNonHBond];
            map[lastNonHBond] = tempIndex;
            while (isHydrogenBond[map[--lastNonHBond]]) {
            }
        }
        return map;
    }

    private boolean[] findSimpleHydrogens() {
        int bond;
        boolean[] isSimpleHydrogen = new boolean[this.mAllAtoms];
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            isSimpleHydrogen[atom] = this.isSimpleHydrogen(atom);
        }
        boolean[] oneBondFound = new boolean[this.mAllAtoms];
        for (bond = 0; bond < this.mAllBonds; ++bond) {
            int atom1 = this.mBondAtom[0][bond];
            int atom2 = this.mBondAtom[1][bond];
            if (this.getBondOrder(bond) != 1) {
                isSimpleHydrogen[atom1] = false;
                isSimpleHydrogen[atom2] = false;
                continue;
            }
            if (oneBondFound[atom1]) {
                isSimpleHydrogen[atom1] = false;
            }
            if (oneBondFound[atom2]) {
                isSimpleHydrogen[atom2] = false;
            }
            if (isSimpleHydrogen[atom1] && this.isMetalAtom(atom2) && this.mAtomicNo[atom2] != 13) {
                isSimpleHydrogen[atom1] = false;
            }
            if (isSimpleHydrogen[atom2] && this.isMetalAtom(atom1) && this.mAtomicNo[atom1] != 13) {
                isSimpleHydrogen[atom2] = false;
            }
            oneBondFound[atom1] = true;
            oneBondFound[atom2] = true;
        }
        for (bond = 0; bond < this.mAllBonds; ++bond) {
            if (!isSimpleHydrogen[this.mBondAtom[0][bond]] || !isSimpleHydrogen[this.mBondAtom[1][bond]]) continue;
            isSimpleHydrogen[this.mBondAtom[0][bond]] = false;
            isSimpleHydrogen[this.mBondAtom[1][bond]] = false;
        }
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (oneBondFound[atom]) continue;
            isSimpleHydrogen[atom] = false;
        }
        return isSimpleHydrogen;
    }

    public boolean isSimpleHydrogen(int atom) {
        return this.mAtomicNo[atom] == 1 && this.mAtomMass[atom] == 0 && this.mAtomCharge[atom] == 0 && (this.mAtomCustomLabel == null || this.mAtomCustomLabel[atom] == null);
    }

    public void removeExplicitHydrogens() {
        this.removeExplicitHydrogens(false);
    }

    public void removeExplicitHydrogens(boolean is3D) {
        this.ensureHelperArrays(is3D ? 1 : 15);
        this.mAllAtoms = this.mAtoms;
        this.mAllBonds = this.mBonds;
        for (int atom = 0; atom < this.mAtoms; ++atom) {
            int explicitAbnormalValence;
            int newAbnormalValence;
            if (this.mAllConnAtoms[atom] == this.mConnAtoms[atom]) continue;
            int abnormalValence = this.getImplicitHigherValence(atom, false);
            this.mAllConnAtoms[atom] = this.mConnAtoms[atom];
            if (abnormalValence == -1 || abnormalValence == (newAbnormalValence = this.getImplicitHigherValence(atom, true)) || (explicitAbnormalValence = this.getAtomAbnormalValence(atom)) != -1 && explicitAbnormalValence >= abnormalValence) continue;
            this.setAtomAbnormalValence(atom, abnormalValence);
        }
        if (!is3D) {
            this.setStereoBondsFromParity();
        }
        this.mValidHelperArrays = 0;
    }

    private void calculateNeighbours() {
        int allConnAtoms;
        int atom;
        int i;
        int order;
        int bnd;
        this.mConnAtoms = new int[this.mAllAtoms];
        this.mAllConnAtoms = new int[this.mAllAtoms];
        this.mConnAtom = new int[this.mAllAtoms][];
        this.mConnBond = new int[this.mAllAtoms][];
        this.mConnBondOrder = new int[this.mAllAtoms][];
        this.mPi = new int[this.mAtoms];
        int[] connCount = new int[this.mAllAtoms];
        for (int bnd2 = 0; bnd2 < this.mAllBonds; ++bnd2) {
            int n = this.mBondAtom[0][bnd2];
            connCount[n] = connCount[n] + 1;
            int n2 = this.mBondAtom[1][bnd2];
            connCount[n2] = connCount[n2] + 1;
        }
        for (int atom2 = 0; atom2 < this.mAllAtoms; ++atom2) {
            this.mConnAtom[atom2] = new int[connCount[atom2]];
            this.mConnBond[atom2] = new int[connCount[atom2]];
            this.mConnBondOrder[atom2] = new int[connCount[atom2]];
        }
        boolean metalBondFound = false;
        for (bnd = 0; bnd < this.mBonds; ++bnd) {
            order = this.getBondOrder(bnd);
            if (order == 0) {
                metalBondFound = true;
                continue;
            }
            for (i = 0; i < 2; ++i) {
                atom = this.mBondAtom[i][bnd];
                allConnAtoms = this.mAllConnAtoms[atom];
                this.mConnBondOrder[atom][allConnAtoms] = order;
                this.mConnAtom[atom][allConnAtoms] = this.mBondAtom[1 - i][bnd];
                this.mConnBond[atom][allConnAtoms] = bnd;
                int n = atom;
                this.mAllConnAtoms[n] = this.mAllConnAtoms[n] + 1;
                int n3 = atom;
                this.mConnAtoms[n3] = this.mConnAtoms[n3] + 1;
                if (atom >= this.mAtoms) continue;
                if (order > 1) {
                    int n4 = atom;
                    this.mPi[n4] = this.mPi[n4] + (order - 1);
                    continue;
                }
                if (this.mBondType[bnd] != 64) continue;
                this.mPi[atom] = 1;
            }
        }
        for (bnd = this.mBonds; bnd < this.mAllBonds; ++bnd) {
            order = this.getBondOrder(bnd);
            if (order == 0) {
                metalBondFound = true;
                continue;
            }
            for (i = 0; i < 2; ++i) {
                atom = this.mBondAtom[i][bnd];
                allConnAtoms = this.mAllConnAtoms[atom];
                this.mConnBondOrder[atom][allConnAtoms] = order;
                this.mConnAtom[atom][allConnAtoms] = this.mBondAtom[1 - i][bnd];
                this.mConnBond[atom][allConnAtoms] = bnd;
                int n = atom;
                this.mAllConnAtoms[n] = this.mAllConnAtoms[n] + 1;
                if (this.mBondAtom[1 - i][bnd] >= this.mAtoms) continue;
                int n5 = atom;
                this.mConnAtoms[n5] = this.mConnAtoms[n5] + 1;
            }
        }
        if (metalBondFound) {
            int[] allConnAtoms2 = new int[this.mAllAtoms];
            for (int atom3 = 0; atom3 < this.mAllAtoms; ++atom3) {
                allConnAtoms2[atom3] = this.mAllConnAtoms[atom3];
            }
            for (int bnd3 = 0; bnd3 < this.mAllBonds; ++bnd3) {
                int order2 = this.getBondOrder(bnd3);
                if (order2 != 0) continue;
                for (int i2 = 0; i2 < 2; ++i2) {
                    int atom4 = this.mBondAtom[i2][bnd3];
                    this.mConnBondOrder[atom4][allConnAtoms2[atom4]] = order2;
                    this.mConnAtom[atom4][allConnAtoms2[atom4]] = this.mBondAtom[1 - i2][bnd3];
                    this.mConnBond[atom4][allConnAtoms2[atom4]] = bnd3;
                    int n = atom4;
                    allConnAtoms2[n] = allConnAtoms2[n] + 1;
                }
            }
        }
    }

    private void findRings(int mode) {
        this.mRingSet = new RingCollection(this, mode);
        int[] atomRingBondCount = new int[this.mAtoms];
        for (int bond = 0; bond < this.mBonds; ++bond) {
            if (this.mRingSet.getBondRingSize(bond) == 0) continue;
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] | 0x40;
            int n2 = this.mBondAtom[0][bond];
            atomRingBondCount[n2] = atomRingBondCount[n2] + 1;
            int n3 = this.mBondAtom[1][bond];
            atomRingBondCount[n3] = atomRingBondCount[n3] + 1;
        }
        for (int atom = 0; atom < this.mAtoms; ++atom) {
            if (atomRingBondCount[atom] == 2) {
                int n = atom;
                this.mAtomFlags[n] = this.mAtomFlags[n] | 0x400;
                continue;
            }
            if (atomRingBondCount[atom] == 3) {
                int n = atom;
                this.mAtomFlags[n] = this.mAtomFlags[n] | 0x800;
                continue;
            }
            if (atomRingBondCount[atom] <= 3) continue;
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] | 0xC00;
        }
        boolean includeAromaticity = (mode & 5 & 0xFFFFFFFE) != 0;
        for (int ringNo = 0; ringNo < this.mRingSet.getSize(); ++ringNo) {
            int[] ringAtom = this.mRingSet.getRingAtoms(ringNo);
            int[] ringBond = this.mRingSet.getRingBonds(ringNo);
            int ringAtoms = ringAtom.length;
            for (int i = 0; i < ringAtoms; ++i) {
                int n = ringAtom[i];
                this.mAtomFlags[n] = this.mAtomFlags[n] | 8;
                int n4 = ringBond[i];
                this.mBondFlags[n4] = this.mBondFlags[n4] | 0x80;
                if (includeAromaticity) {
                    if (this.mRingSet.isAromatic(ringNo)) {
                        int n5 = ringAtom[i];
                        this.mAtomFlags[n5] = this.mAtomFlags[n5] | 0x1000;
                        int n6 = ringBond[i];
                        this.mBondFlags[n6] = this.mBondFlags[n6] | 0x100;
                    }
                    if (this.mRingSet.isDelocalized(ringNo)) {
                        int n7 = ringBond[i];
                        this.mBondFlags[n7] = this.mBondFlags[n7] | 0x200;
                    }
                }
                if (this.mBondType[ringBond[i]] != 26) continue;
                this.mBondType[ringBond[i]] = 2;
            }
        }
    }

    private boolean validateQueryFeatures() {
        if (!this.mIsFragment) {
            return false;
        }
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.getFreeValence(atom) > 0 || this.mAtomCharge[atom] == 0 && (this.mAtomicNo[atom] == 5 || this.isNitrogenFamily(atom) || this.isChalcogene(atom))) continue;
            int n = atom;
            this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFFFFFFFFFE7FFL;
        }
        boolean deleteHydrogens = false;
        for (int atom = 0; atom < this.mAtoms; ++atom) {
            int explicitHydrogens = this.getExplicitHydrogens(atom);
            if (!this.mProtectHydrogen && explicitHydrogens > 0) {
                if ((this.mAtomQueryFeatures[atom] & 0x800L) == 0L) {
                    int queryFeatureShift;
                    int queryFeatureHydrogens = (this.mAtomQueryFeatures[atom] & 0x780L) == 896L ? 3 : ((this.mAtomQueryFeatures[atom] & 0x780L) == 384L ? 2 : ((this.mAtomQueryFeatures[atom] & 0x80L) == 128L ? 1 : 0));
                    int freeValence = this.getFreeValence(atom);
                    if (this.mAtomCharge[atom] == 0 && (this.mAtomQueryFeatures[atom] & 0xE000000L) == 0L && this.mAtomicNo[atom] != 6) {
                        ++freeValence;
                    }
                    if ((queryFeatureShift = explicitHydrogens) > 3 - queryFeatureHydrogens) {
                        queryFeatureShift = 3 - queryFeatureHydrogens;
                    }
                    if (queryFeatureShift > freeValence + explicitHydrogens - queryFeatureHydrogens) {
                        queryFeatureShift = freeValence + explicitHydrogens - queryFeatureHydrogens;
                    }
                    if (queryFeatureShift > 0) {
                        long queryFeatures;
                        long l = queryFeatures = queryFeatureHydrogens == 0 ? 0L : (this.mAtomQueryFeatures[atom] & 0x780L) << queryFeatureShift;
                        int n = queryFeatureShift == 3 ? 7 : (explicitHydrogens == 2 ? 3 : 1);
                        int n2 = atom;
                        this.mAtomQueryFeatures[n2] = this.mAtomQueryFeatures[n2] & 0xFFFFFFFFFFFFF87FL;
                        int n3 = atom;
                        this.mAtomQueryFeatures[n3] = this.mAtomQueryFeatures[n3] | 0x780L & (queryFeatures |= (long)(n << 7));
                    }
                }
                for (int i = this.mConnAtoms[atom]; i < this.mAllConnAtoms[atom]; ++i) {
                    int connBond = this.mConnBond[atom][i];
                    if (this.mBondType[connBond] != 1) continue;
                    this.mAtomicNo[this.mConnAtom[atom][i]] = -1;
                    this.mBondType[connBond] = 128;
                    deleteHydrogens = true;
                }
            }
            if ((this.mAtomQueryFeatures[atom] & 2L) != 0L) {
                int n = atom;
                this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFFFFFFFFFFFF7L;
            }
            if (this.mAtomCharge[atom] == 0) continue;
            int n = atom;
            this.mAtomFlags[n] = (int)((long)this.mAtomFlags[n] & 0xFFFFFFFFF1FFFFFFL);
        }
        if (deleteHydrogens) {
            this.compressMolTable();
        }
        return deleteHydrogens;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException {
    }

    public static final Coordinates getCenterGravity(ExtendedMolecule mol) {
        int n = mol.getAllAtoms();
        int[] indices = new int[n];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return ExtendedMolecule.getCenterGravity(mol, indices);
    }

    public static final Coordinates getCenterGravity(ExtendedMolecule mol, int[] indices) {
        Coordinates c = new Coordinates();
        for (int i = 0; i < indices.length; ++i) {
            c.x += mol.getAtomX(indices[i]);
            c.y += mol.getAtomY(indices[i]);
            c.z += mol.getAtomZ(indices[i]);
        }
        c.x /= (double)indices.length;
        c.y /= (double)indices.length;
        c.z /= (double)indices.length;
        return c;
    }
}

