/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.AtomTypeCalculator;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ExtendedMoleculeFunctions {
    public static final int NUMBER_ELEMENTS = 118;
    public static final int COLOR_FOR_CENTER_SELECTION = 128;
    public static final int[] arrRGroupsAtomicNo = new int[]{142, 143, 144, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141};
    public static final String[] arrRGroupsSymbol = new String[]{"R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15", "R16"};

    public static void makeSkeleton(StereoMolecule mol) {
        for (int bond = 0; bond < mol.getAllBonds(); ++bond) {
            mol.setBondType(bond, 1);
        }
        for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
            mol.setAtomicNo(atom, 6);
        }
    }

    public static void analyzeMolecule(StereoMolecule mol) {
        int nAtoms = mol.getAtoms();
        for (int atom = 0; atom < nAtoms; ++atom) {
            if (AtomFunctionAnalyzer.isAcidicOxygen(mol, atom)) {
                System.out.println("Acidic oxygen " + atom);
            }
            if (AtomFunctionAnalyzer.isNitroGroupN(mol, atom)) {
                System.out.println("Nitro group N " + atom);
            }
            if (AtomFunctionAnalyzer.isMemberOfNitroGroup(mol, atom)) {
                System.out.println("Member of group " + atom);
            }
            if (!AtomFunctionAnalyzer.isBasicNitrogen(mol, atom)) continue;
            System.out.println("Basic nitrogen " + atom);
        }
        System.out.println("Index\tAtomic no\tAtom type");
        for (int indexAtom = 0; indexAtom < mol.getAllAtoms(); ++indexAtom) {
            long atomType = -1L;
            try {
                atomType = AtomTypeCalculator.getAtomType(mol, indexAtom, 6241);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(indexAtom + "\t" + mol.getAtomicNo(indexAtom) + "\t" + atomType + "\t" + AtomTypeCalculator.toString(atomType));
        }
        System.out.println();
    }

    public static String getColorVal2String(Molecule mol, int indexAtom) {
        int color = mol.getAtomColor(indexAtom);
        return ExtendedMoleculeFunctions.getcAtomColor2String(color);
    }

    public static String getcAtomColor2String(int cAtomColor) {
        String sColor = "";
        switch (cAtomColor) {
            case 0: {
                sColor = "black";
                break;
            }
            case 64: {
                sColor = "blue";
                break;
            }
            case 128: {
                sColor = "red";
                break;
            }
            case 192: {
                sColor = "green";
                break;
            }
            case 256: {
                sColor = "magenta";
                break;
            }
            case 320: {
                sColor = "orange";
                break;
            }
            case 384: {
                sColor = "darkGreen";
                break;
            }
            case 448: {
                sColor = "darkRed";
                break;
            }
        }
        return sColor;
    }

    public static String getColorRecord(Molecule mol, Collection<Integer> liIndexAtom, int cAtomColor) {
        StringBuilder sb = new StringBuilder();
        int cc = 0;
        for (int indexAtom : liIndexAtom) {
            String sColor = ExtendedMoleculeFunctions.getcAtomColor2String(cAtomColor);
            sColor = sColor + ":" + indexAtom;
            sb.append(sColor);
            if (cc < liIndexAtom.size() - 1) {
                sb.append(";");
            }
            ++cc;
        }
        return sb.toString();
    }

    public static int getNumQueryAtoms(ExtendedMolecule mol, int[] arrAtomicNoQuery) {
        int hetero = 0;
        block0: for (int i = 0; i < mol.getAllAtoms(); ++i) {
            int atomicNo = mol.getAtomicNo(i);
            for (int j = 0; j < arrAtomicNoQuery.length; ++j) {
                if (arrAtomicNoQuery[j] != atomicNo) continue;
                ++hetero;
                continue block0;
            }
        }
        return hetero;
    }

    public static int getNumCarbonAtoms(ExtendedMolecule mol) {
        int carbon = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            int atomicNo = mol.getAtomicNo(i);
            if (atomicNo != 6) continue;
            ++carbon;
        }
        return carbon;
    }

    public static int getNumHeteroAtoms(ExtendedMolecule mol) {
        int hetero = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            int atomicNo = mol.getAtomicNo(i);
            if (atomicNo <= 1 || atomicNo == 6 || atomicNo > 118) continue;
            ++hetero;
        }
        return hetero;
    }

    public static boolean isHetero(ExtendedMolecule mol, int indexAtom) {
        boolean hetero = false;
        int atomicNo = mol.getAtomicNo(indexAtom);
        if (atomicNo > 1 && atomicNo != 6 && atomicNo <= 118) {
            hetero = true;
        }
        return hetero;
    }

    public static int getNumNitroGroupN(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isNitroGroupN(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAmide(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isAmide(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumCarboxy(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isCarboxyC(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAcidicOxygen(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isAcidicOxygen(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumBasicNitrogen(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isBasicNitrogen(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAliphaticRingAtoms(ExtendedMolecule mol, int atomicNoQuery) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            int atomicNo = mol.getAtomicNo(i);
            if (!mol.isRingAtom(i) || atomicNo != atomicNoQuery) continue;
            ++n;
        }
        return n;
    }

    public static int getNumHeavyAtoms(ExtendedMolecule mol) {
        int heavy = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            int atomicNo = mol.getAtomicNo(i);
            if (atomicNo <= 1 || atomicNo > 118) continue;
            ++heavy;
        }
        return heavy;
    }

    public static int getNumAromaticAtoms(ExtendedMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAtoms(); ++i) {
            if (!mol.isAromaticAtom(i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumArylAmine(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isArylAmine(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumHeteroAromaticAtoms(ExtendedMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAtoms(); ++i) {
            if (!mol.isRingAtom(i) || !mol.isAromaticAtom(i) || mol.getAtomicNo(i) == 6) continue;
            ++n;
        }
        return n;
    }

    public static int getNumIsopropyl(ExtendedMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAtoms(); ++i) {
            if (!mol.isRingAtom(i) || !mol.isAromaticAtom(i) || mol.getAtomicNo(i) == 6) continue;
            ++n;
        }
        return n;
    }

    public static int getNumSubstructure(StereoMolecule mol, String idcodeFragment) {
        IDCodeParser parser = new IDCodeParser();
        StereoMolecule frag = parser.getCompactMolecule(idcodeFragment);
        frag.ensureHelperArrays(7);
        SSSearcher ssSearcher = new SSSearcher();
        ssSearcher.setMol(frag, mol);
        int nMatches = ssSearcher.findFragmentInMolecule();
        return nMatches;
    }

    public static int getBondNo(ExtendedMolecule mol, int atm1, int atm2) {
        for (int bnd = 0; bnd < mol.getAllBonds(); ++bnd) {
            if ((mol.getBondAtom(0, bnd) != atm1 || mol.getBondAtom(1, bnd) != atm2) && (mol.getBondAtom(0, bnd) != atm2 || mol.getBondAtom(1, bnd) != atm1)) continue;
            return bnd;
        }
        return -1;
    }

    public static int getBondOrder(ExtendedMolecule mol, int atm1, int atm2) {
        int bndno = ExtendedMoleculeFunctions.getBondNo(mol, atm1, atm2);
        if (bndno == -1) {
            return -1;
        }
        int bndord = mol.getBondOrder(bndno);
        return bndord;
    }

    public static int getBondType(ExtendedMolecule mol, int atm1, int atm2) {
        int bndno = ExtendedMoleculeFunctions.getBondNo(mol, atm1, atm2);
        if (bndno == -1) {
            return -1;
        }
        int bndtype = mol.getBondType(bndno);
        return bndtype;
    }

    public static int getBondParity(ExtendedMolecule mol, int atm1, int atm2) {
        int bndno = ExtendedMoleculeFunctions.getBondNo(mol, atm1, atm2);
        if (bndno == -1) {
            return -1;
        }
        int bndtype = mol.getBondParity(bndno);
        return bndtype;
    }

    public static boolean deleteBond(ExtendedMolecule mol, int atm1, int atm2) {
        int bndno = ExtendedMoleculeFunctions.getBondNo(mol, atm1, atm2);
        if (bndno == -1) {
            return false;
        }
        mol.deleteBond(bndno);
        return true;
    }

    public static String getBiggestFragmentIDCode(String idCode) {
        StereoMolecule mol = new StereoMolecule();
        new IDCodeParser(false).parse(mol, idCode);
        StereoMolecule[] frags = mol.getFragments();
        String idBiggest = idCode;
        if (frags.length > 1) {
            StereoMolecule biggest = mol;
            int maxAtoms = 0;
            for (int ii = 0; ii < frags.length; ++ii) {
                if (frags[ii].getAllAtoms() <= maxAtoms) continue;
                maxAtoms = frags[ii].getAllAtoms();
                biggest = frags[ii];
            }
            Canonizer canFrag = new Canonizer(biggest);
            idBiggest = canFrag.getIDCode();
        }
        return idBiggest;
    }

    public static StereoMolecule getBiggestFragment(StereoMolecule mol) {
        StereoMolecule[] frags = mol.getFragments();
        StereoMolecule biggest = mol;
        if (frags.length > 1) {
            int maxAtoms = 0;
            for (int ii = 0; ii < frags.length; ++ii) {
                if (frags[ii].getAllAtoms() <= maxAtoms) continue;
                maxAtoms = frags[ii].getAllAtoms();
                biggest = frags[ii];
            }
        }
        return biggest;
    }

    public static StereoMolecule getConverted2CarbonSkeleton(StereoMolecule m) {
        StereoMolecule skel = new StereoMolecule(m);
        skel.ensureHelperArrays(7);
        for (int i = 0; i < skel.getAtoms(); ++i) {
            if (skel.getAtomicNo(i) <= 1) continue;
            skel.setAtomicNo(i, 6);
        }
        skel.ensureHelperArrays(7);
        return skel;
    }

    public static Comparator<StereoMolecule> getComparatorAtomsBonds() {
        return new Comparator<StereoMolecule>(){

            @Override
            public int compare(StereoMolecule m1, StereoMolecule m2) {
                if (m1.getAllAtoms() > m2.getAllAtoms()) {
                    return 1;
                }
                if (m1.getAllAtoms() < m2.getAllAtoms()) {
                    return -1;
                }
                if (m1.getAllBonds() > m2.getAllBonds()) {
                    return 1;
                }
                if (m1.getAllBonds() < m2.getAllBonds()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static boolean checkBiggestFragmentForUnwanted(StereoMolecule mol, List<Integer> liAtomicNo) {
        boolean bOk = true;
        StereoMolecule[] frags = mol.getFragments();
        int indexBiggestFrag = 0;
        if (frags.length > 1) {
            int maxAtoms = 0;
            for (int ii = 0; ii < frags.length; ++ii) {
                if (frags[ii].getAllAtoms() <= maxAtoms) continue;
                indexBiggestFrag = ii;
                maxAtoms = frags[ii].getAllAtoms();
            }
        }
        StereoMolecule frag = frags[indexBiggestFrag];
        for (int i = 0; i < frag.getAllAtoms(); ++i) {
            if (!liAtomicNo.contains(new Integer(frag.getAtomicNo(i)))) continue;
            bOk = false;
            break;
        }
        return bOk;
    }

    public static boolean containsAtLeastOneAtomicNumbersFromHashSet(ExtendedMolecule mol, HashSet<Integer> hsAtomicNo) {
        boolean bOk = false;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!hsAtomicNo.contains(mol.getAtomicNo(i))) continue;
            bOk = true;
            break;
        }
        return bOk;
    }

    public static boolean containsHeteroAtom(ExtendedMolecule mol, int[] arrIndexAt) {
        boolean hetero = false;
        for (int indexAt : arrIndexAt) {
            if (mol.getAtomicNo(indexAt) == 6 || mol.getAtomicNo(indexAt) == 1) continue;
            hetero = true;
            break;
        }
        return hetero;
    }

    public static boolean containsSolelyAtomicNumbersFromHashSet(ExtendedMolecule mol, HashSet<Integer> hsAtomicNo) {
        boolean allAtomicNosInHashset = true;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (hsAtomicNo.contains(mol.getAtomicNo(i))) continue;
            allAtomicNosInHashset = false;
            break;
        }
        return allAtomicNosInHashset;
    }

    public static final boolean atomAtomSubStrucMatch(StereoMolecule molecule, int at, StereoMolecule fragment) {
        boolean bMatch = false;
        SSSearcher sss = new SSSearcher();
        sss.setMol(fragment, molecule);
        int numFrags = sss.findFragmentInMolecule(4, 8);
        if (numFrags == 0) {
            return false;
        }
        ArrayList<int[]> liAtomLists = sss.getMatchList();
        ArrayUtilsCalc.removeDoubletsIntOrderIndepend(liAtomLists);
        int atomMarkedInQuery = -1;
        for (int i = 0; i < fragment.getAllAtoms(); ++i) {
            if (fragment.getAtomColor(i) != 128) continue;
            atomMarkedInQuery = i;
        }
        for (int[] arrInd : liAtomLists) {
            if (arrInd[atomMarkedInQuery] != at) continue;
            bMatch = true;
            break;
        }
        return bMatch;
    }

    public static double[][] getDistanceArray(ExtendedMolecule mol) {
        double[][] arr = new double[mol.getAllAtoms()][mol.getAllAtoms()];
        for (int i = 0; i < arr.length; ++i) {
            for (int j = i + 1; j < arr.length; ++j) {
                double v;
                double dx = mol.getAtomX(i) - mol.getAtomX(j);
                double dy = mol.getAtomY(i) - mol.getAtomY(j);
                double dz = mol.getAtomZ(i) - mol.getAtomZ(j);
                arr[i][j] = v = Math.sqrt(dx * dx + dy * dy + dz * dz);
                arr[j][i] = v;
            }
        }
        return arr;
    }

    public static final int getTopologicalDistance(ExtendedMolecule mol, int at1, int at2) {
        int dist = 0;
        if (at1 == at2) {
            return 0;
        }
        ArrayList<Integer> liExamine = new ArrayList<Integer>();
        ArrayList<Integer> liSphere = new ArrayList<Integer>();
        ArrayList<Integer> liVisited = new ArrayList<Integer>();
        liExamine.add(new Integer(at1));
        liSphere.add(new Integer(1));
        boolean bFound = false;
        while (!liExamine.isEmpty()) {
            dist = (Integer)liSphere.remove(0);
            int indAtCenter = (Integer)liExamine.remove(0);
            liVisited.add(new Integer(indAtCenter));
            int numJNeighbors = mol.getAllConnAtoms(indAtCenter);
            for (int i = 0; i < numJNeighbors; ++i) {
                int indAtNeighb = mol.getConnAtom(indAtCenter, i);
                if (indAtNeighb == at2) {
                    bFound = true;
                    break;
                }
                if (liVisited.contains(new Integer(indAtNeighb))) continue;
                liExamine.add(new Integer(indAtNeighb));
                liSphere.add(new Integer(dist + 1));
            }
            if (!bFound) continue;
            break;
        }
        if (!bFound) {
            dist = -1;
        }
        return dist;
    }

    public static final int[][] getTopologicalDistanceMatrix(StereoMolecule mol) {
        return ExtendedMoleculeFunctions.getNumberOfBondsBetweenAtoms(mol, mol.getBonds(), null);
    }

    public static int[][] getNumberOfBondsBetweenAtoms(StereoMolecule mol, int maxBonds, int[][] dist) {
        if (dist == null) {
            dist = new int[mol.getAtoms()][mol.getAtoms()];
        }
        int N = dist.length;
        for (int i = 0; i < N; ++i) {
            dist[i][i] = 0;
            for (int j = i + 1; j < N; ++j) {
                dist[j][i] = -1;
                dist[i][j] = -1;
            }
        }
        for (int j = 0; j < maxBonds; ++j) {
            for (int i = 0; i < mol.getBonds(); ++i) {
                int a1 = mol.getBondAtom(0, i);
                int a2 = mol.getBondAtom(1, i);
                if (a1 >= N || a2 >= N) continue;
                for (int a0 = 0; a0 < N; ++a0) {
                    if (dist[a0][a1] >= 0 && (dist[a0][a2] == -1 || dist[a0][a1] + 1 < dist[a0][a2]) && dist[a0][a1] < maxBonds) {
                        int n = dist[a0][a1] + 1;
                        dist[a0][a2] = n;
                        dist[a2][a0] = n;
                    }
                    if (dist[a0][a2] < 0 || dist[a0][a1] != -1 && dist[a0][a2] + 1 >= dist[a0][a1] || dist[a0][a2] >= maxBonds) continue;
                    int n = dist[a0][a2] + 1;
                    dist[a0][a1] = n;
                    dist[a1][a0] = n;
                }
            }
        }
        return dist;
    }

    public static boolean isAliphaticAtom(StereoMolecule mol, int atm) {
        boolean aliphatic = true;
        if (mol.getAtomicNo(atm) != 6) {
            return false;
        }
        int nConn = mol.getAllConnAtoms(atm);
        for (int i = 0; i < nConn; ++i) {
            int atmConn = mol.getConnAtom(atm, i);
            int atomicNoConn = mol.getAtomicNo(atmConn);
            if (atomicNoConn != 7 && atomicNoConn != 8 && atomicNoConn != 9 && atomicNoConn != 15 && atomicNoConn != 16 && atomicNoConn != 17) continue;
            aliphatic = false;
            break;
        }
        return aliphatic;
    }

    public static boolean isAcceptor(StereoMolecule mol, int atom) {
        boolean acceptor = true;
        if (mol.getAtomicNo(atom) != 8 && mol.getAtomicNo(atom) != 7) {
            return false;
        }
        return acceptor;
    }

    public static boolean isDonor(StereoMolecule mol, int atom) {
        boolean donor = true;
        if (mol.getAtomicNo(atom) != 8 && mol.getAtomicNo(atom) != 7) {
            return false;
        }
        if (mol.getAllHydrogens(atom) == 0) {
            return false;
        }
        return donor;
    }

    public static boolean isCarbonTwoValencesMinimum(StereoMolecule mol) {
        boolean twoValencesMin = true;
        int atoms = mol.getAtoms();
        for (int i = 0; i < atoms; ++i) {
            int connected;
            int atomicNo = mol.getAtomicNo(i);
            if (atomicNo != 6 || (connected = mol.getConnAtoms(i)) >= 2) continue;
            twoValencesMin = false;
            break;
        }
        return twoValencesMin;
    }

    public static boolean isCarbonOnlyConnected2Hetero(StereoMolecule mol) {
        boolean hetero = true;
        int atoms = mol.getAtoms();
        block0: for (int i = 0; i < atoms; ++i) {
            int atomicNo = mol.getAtomicNo(i);
            if (atomicNo != 6) continue;
            int connected = mol.getConnAtoms(i);
            for (int j = 0; j < connected; ++j) {
                int indexConnecetd = mol.getConnAtom(i, j);
                if (mol.getAtomicNo(indexConnecetd) != 6) continue;
                hetero = false;
                break block0;
            }
            if (!mol.isRingAtom(i)) continue;
            hetero = true;
            break;
        }
        return hetero;
    }

    public static boolean isCarbonConnected2Hetero(StereoMolecule mol, int atomIndex) {
        boolean hetero = false;
        int atomicNo = mol.getAtomicNo(atomIndex);
        if (atomicNo == 6) {
            int connected = mol.getConnAtoms(atomIndex);
            for (int j = 0; j < connected; ++j) {
                int indexConnected = mol.getConnAtom(atomIndex, j);
                if (mol.getAtomicNo(indexConnected) == 6 || mol.getAtomicNo(indexConnected) == 1) continue;
                hetero = true;
                break;
            }
        }
        return hetero;
    }

    public static boolean isConnected2Hetero(StereoMolecule mol, int[] arrAtomIndex) {
        boolean hetero = false;
        block0: for (int atomIndex : arrAtomIndex) {
            int connected = mol.getConnAtoms(atomIndex);
            for (int j = 0; j < connected; ++j) {
                int indexConnected = mol.getConnAtom(atomIndex, j);
                if (mol.getAtomicNo(indexConnected) == 6 || mol.getAtomicNo(indexConnected) == 1) continue;
                hetero = true;
                continue block0;
            }
        }
        return hetero;
    }

    public static boolean isRingInMolecule(StereoMolecule mol) {
        boolean ring = false;
        int atoms = mol.getAtoms();
        for (int i = 0; i < atoms; ++i) {
            if (!mol.isRingAtom(i)) continue;
            ring = true;
            break;
        }
        return ring;
    }

    public static boolean isRingExclusively(StereoMolecule mol) {
        boolean ring = true;
        int atoms = mol.getAtoms();
        for (int i = 0; i < atoms; ++i) {
            if (mol.isRingAtom(i)) continue;
            ring = false;
            break;
        }
        return ring;
    }

    public static boolean isCyanoN(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 7) {
            return false;
        }
        int nConn = mol.getConnAtoms(atom);
        if (nConn != 1) {
            return false;
        }
        int indexConn = mol.getConnAtom(atom, 0);
        int bond = mol.getBond(atom, indexConn);
        return mol.getBondOrder(bond) == 3;
    }

    public static boolean isThioEther(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 16) {
            return false;
        }
        int nConn = mol.getConnAtoms(atom);
        if (nConn != 2) {
            return false;
        }
        boolean thio = true;
        for (int i = 0; i < nConn; ++i) {
            int indexConn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(indexConn) == 6) continue;
            thio = false;
            break;
        }
        return thio;
    }

    public static boolean isWildcard(StereoMolecule mol, int atom) {
        return mol.getAtomicNo(atom) == 0;
    }

    public static boolean isSulfoxyGroup(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 16) {
            return false;
        }
        int nConn = mol.getConnAtoms(atom);
        boolean oxy = false;
        for (int i = 0; i < nConn; ++i) {
            int indexConn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(indexConn) != 8) continue;
            oxy = true;
            break;
        }
        return oxy;
    }

    public static boolean isIsolatedCarbon(StereoMolecule mol, int indexAtCentral, int[] arrIndexAt) {
        boolean isolated = true;
        int nConnected = mol.getConnAtoms(indexAtCentral);
        boolean[] arrConnected = new boolean[mol.getAtoms()];
        for (int i = 0; i < nConnected; ++i) {
            arrConnected[mol.getConnAtom((int)indexAtCentral, (int)i)] = true;
        }
        for (int indexAt : arrIndexAt) {
            if (!arrConnected[indexAt] || mol.getAtomicNo(indexAt) != 6) continue;
            isolated = false;
            break;
        }
        return isolated;
    }

    public static int[] extractAromaticRing(StereoMolecule mol, int[] arrIndexAt) {
        RingCollection rc = mol.getRingSet();
        boolean[] arrRingMemberMarker = new boolean[mol.getAtoms()];
        int[] arrIndexAromaticRing = null;
        for (int i = 0; i < rc.getSize(); ++i) {
            int[] arrRingAtoms;
            if (!rc.isAromatic(i)) continue;
            Arrays.fill(arrRingMemberMarker, false);
            for (int indexRingAtom : arrRingAtoms = rc.getRingAtoms(i)) {
                arrRingMemberMarker[indexRingAtom] = true;
            }
            int sum = 0;
            for (int indexAt : arrIndexAt) {
                if (!arrRingMemberMarker[indexAt]) continue;
                ++sum;
            }
            if (sum != arrRingAtoms.length) continue;
            arrIndexAromaticRing = arrRingAtoms;
            break;
        }
        return arrIndexAromaticRing;
    }

    public static int getNumCyanoGroups(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isCyanoN(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAlcoholicOxygen(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isAlcoholicOxygen(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumThioEther(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isThioEther(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumSulfOxyGroups(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isSulfoxyGroup(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumWildcards(StereoMolecule mol) {
        int n = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isWildcard(mol, i)) continue;
            ++n;
        }
        return n;
    }

    public static boolean isAlcoholicOxygen(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 8 || mol.isAromaticAtom(atom)) {
            return false;
        }
        int nConnected = mol.getConnAtoms(atom);
        if (nConnected != 1) {
            return false;
        }
        int indConn = mol.getConnAtom(atom, 0);
        if (mol.getAtomicNo(indConn) != 6) {
            return false;
        }
        return AtomFunctionAnalyzer.getNegativeNeighbourCount(mol, indConn) <= 1;
    }

    public static boolean isEtherOxygenAtAromatic(StereoMolecule mol, int atom) {
        boolean aromaticEtherO = false;
        if (mol.getAtomicNo(atom) != 8 || mol.isAromaticAtom(atom)) {
            return false;
        }
        int nConnected = mol.getConnAtoms(atom);
        if (nConnected != 2) {
            return false;
        }
        int indConn1 = mol.getConnAtom(atom, 0);
        int indConn2 = mol.getConnAtom(atom, 1);
        if (mol.isAromaticAtom(indConn1)) {
            aromaticEtherO = true;
        } else if (mol.isAromaticAtom(indConn2)) {
            aromaticEtherO = true;
        }
        return aromaticEtherO;
    }

    public static boolean isCarboxyC(StereoMolecule mol, int atom) {
        if (mol.getAtomicNo(atom) != 6 || mol.getAtomPi(atom) != 0) {
            return false;
        }
        boolean carboxyO = false;
        boolean etherO = false;
        for (int i = 0; i < mol.getConnAtoms(atom); ++i) {
            int conn = mol.getConnAtom(atom, i);
            if (mol.getAtomicNo(conn) != 6) continue;
            int bond = mol.getBond(atom, conn);
            int bo = mol.getBondOrder(bond);
            if (bo == 1) {
                etherO = true;
                continue;
            }
            if (bo != 2) continue;
            carboxyO = true;
        }
        boolean carboxyC = false;
        if (carboxyO && etherO) {
            carboxyC = true;
        }
        return carboxyC;
    }

    public static int replaceAtoms(ExtendedMolecule[] arr, int atnoOrig, int atnoRpl) {
        int cc = 0;
        for (int i = 0; i < arr.length; ++i) {
            cc += ExtendedMoleculeFunctions.replaceAtoms(arr[i], atnoOrig, atnoRpl);
        }
        return cc;
    }

    public static int replaceAtoms(ExtendedMolecule mol, int atnoOrig, int atnoRpl) {
        int cc = 0;
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (mol.getAtomicNo(i) != atnoOrig) continue;
            mol.setAtomicNo(i, atnoRpl);
            ++cc;
        }
        return cc;
    }

    public static final LinkedList<StereoMolecule> removeSubStructures(List<StereoMolecule> liInput) {
        SSSearcher sss = new SSSearcher();
        LinkedList<StereoMolecule> li = new LinkedList<StereoMolecule>(liInput);
        block0: for (int i = li.size() - 1; i >= 0; --i) {
            StereoMolecule mol1 = li.get(i);
            for (int j = 0; j < li.size(); ++j) {
                if (i == j) continue;
                StereoMolecule mol2 = li.get(j);
                if (mol1.getAtoms() >= mol2.getAtoms()) continue;
                sss.setMol(mol1, mol2);
                if (!sss.isFragmentInMolecule()) continue;
                li.remove(i);
                continue block0;
            }
        }
        return li;
    }

    public static StereoMolecule removeSubstructuresFromMolecule(StereoMolecule mol, List<StereoMolecule> liFragment) {
        StereoMolecule molReduced = new StereoMolecule(mol);
        molReduced.ensureHelperArrays(7);
        SSSearcher sss = new SSSearcher();
        HashSet<Integer> hsIndexMatchingAtoms = new HashSet<Integer>();
        for (StereoMolecule frag : liFragment) {
            sss.setMol(frag, molReduced);
            if (sss.findFragmentInMolecule() <= 0) continue;
            ArrayList<int[]> liMatch = sss.getMatchList();
            hsIndexMatchingAtoms.clear();
            for (int[] arrMatch : liMatch) {
                for (int i = 0; i < arrMatch.length; ++i) {
                    hsIndexMatchingAtoms.add(arrMatch[i]);
                }
            }
            int[] arrIndexMatchingAtomsUnique = ArrayUtilsCalc.toIntArray(hsIndexMatchingAtoms);
            molReduced.deleteAtoms(arrIndexMatchingAtomsUnique);
            molReduced.ensureHelperArrays(7);
        }
        return molReduced;
    }

    public static StereoMolecule removeSubstructureFromMolecule(StereoMolecule mol, StereoMolecule frag) {
        StereoMolecule molReduced = new StereoMolecule(mol);
        molReduced.ensureHelperArrays(7);
        SSSearcher sss = new SSSearcher();
        sss.setMol(frag, molReduced);
        if (sss.findFragmentInMolecule() > 0) {
            ArrayList<int[]> liMatch = sss.getMatchList();
            if (liMatch.size() > 1) {
                throw new RuntimeException("Fragment found more than once!");
            }
            if (liMatch.size() == 1) {
                int[] arrMatchIndex = (int[])liMatch.get(0);
                molReduced.deleteAtoms(arrMatchIndex);
                molReduced.ensureHelperArrays(7);
            }
        }
        return molReduced;
    }

    public static StereoMolecule removeWildcards(StereoMolecule mol) {
        StereoMolecule molReduced = new StereoMolecule(mol);
        molReduced.ensureHelperArrays(7);
        for (int i = molReduced.getAtoms() - 1; i >= 0; --i) {
            if (molReduced.getAtomicNo(i) != 0) continue;
            molReduced.deleteAtom(i);
        }
        molReduced.ensureHelperArrays(7);
        return molReduced;
    }

    public static void setColorMCS2Molecule(StereoMolecule mol, StereoMolecule molMCS) {
        for (int i = 0; i < mol.getAtoms(); ++i) {
            mol.setAtomColor(i, 0);
        }
        SSSearcher sss = new SSSearcher();
        sss.setMol(molMCS, mol);
        if (sss.findFragmentInMolecule() > 0) {
            ArrayList<int[]> liMatch = sss.getMatchList();
            int[] arrIndexMatch = (int[])liMatch.get(0);
            for (int i = 0; i < arrIndexMatch.length; ++i) {
                mol.setAtomColor(arrIndexMatch[i], 64);
            }
        }
    }

    public static void setColorMolecule(StereoMolecule mol, int[] arrIndexMatch) {
        int i;
        for (i = 0; i < mol.getAtoms(); ++i) {
            mol.setAtomColor(i, 0);
        }
        for (i = 0; i < arrIndexMatch.length; ++i) {
            mol.setAtomColor(arrIndexMatch[i], 64);
        }
    }

    public static void setColorMoleculeFromBondIndex(StereoMolecule mol, int[] arrIndexBonds, int color) {
        for (int i = 0; i < arrIndexBonds.length; ++i) {
            int indexAtom1 = mol.getBondAtom(0, arrIndexBonds[i]);
            int indexAtom2 = mol.getBondAtom(1, arrIndexBonds[i]);
            mol.setAtomColor(indexAtom1, color);
            mol.setAtomColor(indexAtom2, color);
        }
    }

    public static void setCoordinatesNull(StereoMolecule mol) {
        for (int i = 0; i < mol.getAtoms(); ++i) {
            mol.setAtomX(i, 0.0);
            mol.setAtomY(i, 0.0);
            mol.setAtomZ(i, 0.0);
        }
    }

    public static String getColorVectorSubstructure(StereoMolecule mol, StereoMolecule frag, int atomColor) {
        SSSearcher sss = new SSSearcher();
        sss.setMol(frag, mol);
        HashSet<Integer> hsAtomIndex = new HashSet<Integer>();
        if (sss.findFragmentInMolecule() > 0) {
            ArrayList<int[]> liMatch = sss.getMatchList();
            int[] arr = (int[])liMatch.get(0);
            for (int i = 0; i < arr.length; ++i) {
                hsAtomIndex.add(arr[i]);
            }
        }
        String sAtomColor = ExtendedMoleculeFunctions.getColorRecord(mol, hsAtomIndex, atomColor);
        return sAtomColor;
    }

    public static float getSimilarity(StereoMolecule m1, StereoMolecule m2, DescriptorHandler dh) {
        Object d1 = dh.createDescriptor(m1);
        Object d2 = dh.createDescriptor(m2);
        return dh.getSimilarity(d1, d2);
    }

    public static int getAtomicNoRGroup(int r) {
        if (r > arrRGroupsAtomicNo.length) {
            throw new RuntimeException("");
        }
        return arrRGroupsAtomicNo[r - 1];
    }
}

