/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.DoubleFormat;

public class IDCodeParserWithoutCoordinateInvention {
    private StereoMolecule mMol;
    private byte[] mDecodingBytes;
    private int mIDCodeBitsAvail;
    private int mIDCodeTempData;
    private int mIDCodeBufferIndex;
    private boolean mNeglectSpaceDelimitedCoordinates;

    protected boolean ensure2DCoordinates() {
        return false;
    }

    public void neglectSpaceDelimitedCoordinates() {
        this.mNeglectSpaceDelimitedCoordinates = true;
    }

    public StereoMolecule getCompactMolecule(String idcode) {
        return idcode == null || idcode.length() == 0 ? null : this.getCompactMolecule(idcode.getBytes(), null);
    }

    public StereoMolecule getCompactMolecule(byte[] idcode) {
        return this.getCompactMolecule(idcode, null);
    }

    public StereoMolecule getCompactMolecule(String idcode, String coordinates) {
        return idcode == null ? null : this.getCompactMolecule(idcode.getBytes(), coordinates == null ? null : coordinates.getBytes());
    }

    public StereoMolecule getCompactMolecule(byte[] idcode, byte[] coordinates) {
        return this.getCompactMolecule(idcode, coordinates, 0, 0);
    }

    public StereoMolecule getCompactMolecule(byte[] idcode, int idcodeStart) {
        return this.getCompactMolecule(idcode, null, idcodeStart, -1);
    }

    public StereoMolecule getCompactMolecule(byte[] idcode, byte[] coordinates, int idcodeStart, int coordsStart) {
        if (idcode == null) {
            return null;
        }
        this.decodeBitsStart(idcode, idcodeStart);
        int abits = this.decodeBits(4);
        int bbits = this.decodeBits(4);
        if (abits > 8) {
            abits = bbits;
        }
        int allAtoms = this.decodeBits(abits);
        int allBonds = this.decodeBits(bbits);
        StereoMolecule mol = new StereoMolecule(allAtoms, allBonds);
        this.parse(mol, idcode, coordinates, idcodeStart, coordsStart);
        return mol;
    }

    public void parse(StereoMolecule mol, String idcode) {
        if (idcode == null || idcode.length() == 0) {
            this.parse(mol, (byte[])null, (byte[])null);
            return;
        }
        int index = idcode.indexOf(32);
        if (index > 0 && index < idcode.length() - 1) {
            this.parse(mol, idcode.substring(0, index).getBytes(), idcode.substring(index + 1).getBytes());
        } else {
            this.parse(mol, idcode.getBytes(), null);
        }
    }

    public void parse(StereoMolecule mol, byte[] idcode) {
        this.parse(mol, idcode, null);
    }

    public void parse(StereoMolecule mol, String idcode, String coordinates) {
        byte[] idcodeBytes = idcode == null ? null : idcode.getBytes();
        byte[] coordinateBytes = coordinates == null ? null : coordinates.getBytes();
        this.parse(mol, idcodeBytes, coordinateBytes);
    }

    public void parse(StereoMolecule mol, byte[] idcode, byte[] coordinates) {
        if (idcode == null || idcode.length == 0) {
            mol.clear();
            return;
        }
        this.parse(mol, idcode, coordinates, 0, 0);
    }

    public void parse(StereoMolecule mol, byte[] idcode, int idcodeStart) {
        this.parse(mol, idcode, null, idcodeStart, -1);
    }

    public void parse(StereoMolecule mol, byte[] idcode, byte[] coordinates, int idcodeStart, int coordsStart) {
        boolean coords2DAvailable;
        int i;
        int i2;
        mol.clear();
        if (idcode == null || idcodeStart >= idcode.length) {
            return;
        }
        this.mMol = mol;
        int version = 8;
        if (coordinates != null && coordsStart >= coordinates.length) {
            coordinates = null;
        }
        this.decodeBitsStart(idcode, idcodeStart);
        int abits = this.decodeBits(4);
        int bbits = this.decodeBits(4);
        if (abits > 8) {
            version = abits;
            abits = bbits;
        }
        if (abits == 0) {
            this.mMol.setFragment(this.decodeBits(1) == 1);
            return;
        }
        int allAtoms = this.decodeBits(abits);
        int allBonds = this.decodeBits(bbits);
        int nitrogens = this.decodeBits(abits);
        int oxygens = this.decodeBits(abits);
        int otherAtoms = this.decodeBits(abits);
        int chargedAtoms = this.decodeBits(abits);
        for (int atom = 0; atom < allAtoms; ++atom) {
            this.mMol.addAtom(6);
        }
        for (i2 = 0; i2 < nitrogens; ++i2) {
            this.mMol.setAtomicNo(this.decodeBits(abits), 7);
        }
        for (i2 = 0; i2 < oxygens; ++i2) {
            this.mMol.setAtomicNo(this.decodeBits(abits), 8);
        }
        for (i2 = 0; i2 < otherAtoms; ++i2) {
            this.mMol.setAtomicNo(this.decodeBits(abits), this.decodeBits(8));
        }
        for (i2 = 0; i2 < chargedAtoms; ++i2) {
            this.mMol.setAtomCharge(this.decodeBits(abits), this.decodeBits(4) - 8);
        }
        int closureBonds = 1 + allBonds - allAtoms;
        int dbits = this.decodeBits(4);
        int base = 0;
        this.mMol.setAtomX(0, 0.0);
        this.mMol.setAtomY(0, 0.0);
        this.mMol.setAtomZ(0, 0.0);
        boolean decodeOldCoordinates = coordinates != null && coordinates[0] >= 39;
        double targetAVBL = 0.0;
        double xOffset = 0.0;
        double yOffset = 0.0;
        double zOffset = 0.0;
        boolean coordsAre3D = false;
        boolean coordsAreAbsolute = false;
        if (decodeOldCoordinates) {
            if (coordinates.length > 2 * allAtoms - 2 && coordinates[2 * allAtoms - 2] == 39 || coordinates.length > 3 * allAtoms - 3 && coordinates[3 * allAtoms - 3] == 39) {
                coordsAreAbsolute = true;
                coordsAre3D = coordinates.length == 3 * allAtoms - 3 + 9;
                int index = coordsAre3D ? 3 * allAtoms - 3 : 2 * allAtoms - 2;
                int avblInt = 86 * (coordinates[index + 1] - 40) + coordinates[index + 2] - 40;
                targetAVBL = Math.pow(10.0, (double)avblInt / 2000.0 - 1.0);
                int xInt = 86 * (coordinates[(index += 2) + 1] - 40) + coordinates[index + 2] - 40;
                xOffset = Math.pow(10.0, (double)xInt / 1500.0 - 1.0);
                int yInt = 86 * (coordinates[(index += 2) + 1] - 40) + coordinates[index + 2] - 40;
                yOffset = Math.pow(10.0, (double)yInt / 1500.0 - 1.0);
                if (coordsAre3D) {
                    int zInt = 86 * (coordinates[(index += 2) + 1] - 40) + coordinates[index + 2] - 40;
                    zOffset = Math.pow(10.0, (double)zInt / 1500.0 - 1.0);
                }
            } else {
                boolean bl = coordsAre3D = coordinates.length == 3 * allAtoms - 3;
            }
        }
        if (this.ensure2DCoordinates() && coordsAre3D) {
            coordinates = null;
            decodeOldCoordinates = false;
        }
        for (i = 1; i < allAtoms; ++i) {
            int dif = this.decodeBits(dbits);
            if (dif == 0) {
                if (decodeOldCoordinates) {
                    this.mMol.setAtomX(i, this.mMol.getAtomX(0) + (double)(8 * (coordinates[i * 2 - 2] - 83)));
                    this.mMol.setAtomY(i, this.mMol.getAtomY(0) + (double)(8 * (coordinates[i * 2 - 1] - 83)));
                    if (coordsAre3D) {
                        this.mMol.setAtomZ(i, this.mMol.getAtomZ(0) + (double)(8 * (coordinates[2 * allAtoms - 3 + i] - 83)));
                    }
                }
                ++closureBonds;
                continue;
            }
            base += dif - 1;
            if (decodeOldCoordinates) {
                this.mMol.setAtomX(i, this.mMol.getAtomX(base) + (double)coordinates[i * 2 - 2] - 83.0);
                this.mMol.setAtomY(i, this.mMol.getAtomY(base) + (double)coordinates[i * 2 - 1] - 83.0);
                if (coordsAre3D) {
                    this.mMol.setAtomZ(i, this.mMol.getAtomZ(base) + (double)(coordinates[2 * allAtoms - 3 + i] - 83));
                }
            }
            this.mMol.addBond(base, i, 1);
        }
        for (i = 0; i < closureBonds; ++i) {
            this.mMol.addBond(this.decodeBits(abits), this.decodeBits(abits), 1);
        }
        boolean[] isDelocalizedBond = new boolean[allBonds];
        block61: for (int bond = 0; bond < allBonds; ++bond) {
            int bondOrder = this.decodeBits(2);
            switch (bondOrder) {
                case 0: {
                    isDelocalizedBond[bond] = true;
                    continue block61;
                }
                case 2: {
                    this.mMol.setBondType(bond, 2);
                    continue block61;
                }
                case 3: {
                    this.mMol.setBondType(bond, 4);
                }
            }
        }
        int THCount = this.decodeBits(abits);
        block62: for (int i3 = 0; i3 < THCount; ++i3) {
            int parity;
            int atom = this.decodeBits(abits);
            if (version == 8) {
                parity = this.decodeBits(2);
                if (parity == 3) {
                    this.mMol.setAtomESR(atom, 1, 0);
                    this.mMol.setAtomParity(atom, 1, false);
                    continue;
                }
                this.mMol.setAtomParity(atom, parity, false);
                continue;
            }
            parity = this.decodeBits(3);
            switch (parity) {
                case 4: {
                    this.mMol.setAtomParity(atom, 1, false);
                    this.mMol.setAtomESR(atom, 1, this.decodeBits(3));
                    continue block62;
                }
                case 5: {
                    this.mMol.setAtomParity(atom, 2, false);
                    this.mMol.setAtomESR(atom, 1, this.decodeBits(3));
                    continue block62;
                }
                case 6: {
                    this.mMol.setAtomParity(atom, 1, false);
                    this.mMol.setAtomESR(atom, 2, this.decodeBits(3));
                    continue block62;
                }
                case 7: {
                    this.mMol.setAtomParity(atom, 2, false);
                    this.mMol.setAtomESR(atom, 2, this.decodeBits(3));
                    continue block62;
                }
                default: {
                    this.mMol.setAtomParity(atom, parity, false);
                }
            }
        }
        if (version == 8 && this.decodeBits(1) == 0) {
            this.mMol.setToRacemate();
        }
        int EZCount = this.decodeBits(bbits);
        for (int i4 = 0; i4 < EZCount; ++i4) {
            int bond = this.decodeBits(bbits);
            if (this.mMol.getBondType(bond) == 1) {
                int parity = this.decodeBits(3);
                switch (parity) {
                    case 4: {
                        this.mMol.setBondParity(bond, 1, false);
                        this.mMol.setBondESR(bond, 1, this.decodeBits(3));
                        break;
                    }
                    case 5: {
                        this.mMol.setBondParity(bond, 2, false);
                        this.mMol.setBondESR(bond, 1, this.decodeBits(3));
                        break;
                    }
                    case 6: {
                        this.mMol.setBondParity(bond, 1, false);
                        this.mMol.setBondESR(bond, 2, this.decodeBits(3));
                        break;
                    }
                    case 7: {
                        this.mMol.setBondParity(bond, 2, false);
                        this.mMol.setBondESR(bond, 2, this.decodeBits(3));
                        break;
                    }
                    default: {
                        this.mMol.setBondParity(bond, parity, false);
                        break;
                    }
                }
                continue;
            }
            this.mMol.setBondParity(bond, this.decodeBits(2), false);
        }
        this.mMol.setFragment(this.decodeBits(1) == 1);
        int[] aromaticSPBond = null;
        int offset = 0;
        block64: while (this.decodeBits(1) == 1) {
            int bond;
            int dataType = offset + this.decodeBits(4);
            switch (dataType) {
                case 0: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        this.mMol.setAtomQueryFeature(atom, 2048L, true);
                    }
                    continue block64;
                }
                case 1: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        int mass = this.decodeBits(8);
                        this.mMol.setAtomMass(atom, mass);
                    }
                    continue block64;
                }
                case 2: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(bbits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(bbits);
                    }
                    continue block64;
                }
                case 3: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        this.mMol.setAtomQueryFeature(atom, 4096L, true);
                    }
                    continue block64;
                }
                case 4: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        long ringState = (long)this.decodeBits(4) << 3;
                        this.mMol.setAtomQueryFeature(atom, ringState, true);
                    }
                    continue block64;
                }
                case 5: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        long aromState = (long)this.decodeBits(2) << 1;
                        this.mMol.setAtomQueryFeature(atom, aromState, true);
                    }
                    continue block64;
                }
                case 6: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        this.mMol.setAtomQueryFeature(atom, 1L, true);
                    }
                    continue block64;
                }
                case 7: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        long hydrogen = (long)this.decodeBits(4) << 7;
                        this.mMol.setAtomQueryFeature(atom, hydrogen, true);
                    }
                    continue block64;
                }
                case 8: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        int atoms = this.decodeBits(4);
                        int[] atomList = new int[atoms];
                        for (int j = 0; j < atoms; ++j) {
                            int atomicNo;
                            atomList[j] = atomicNo = this.decodeBits(8);
                        }
                        this.mMol.setAtomList(atom, atomList);
                    }
                    continue block64;
                }
                case 9: {
                    int i5;
                    int no = this.decodeBits(bbits);
                    for (i5 = 0; i5 < no; ++i5) {
                        bond = this.decodeBits(bbits);
                        int ringState = this.decodeBits(2) << 5;
                        this.mMol.setBondQueryFeature(bond, ringState, true);
                    }
                    continue block64;
                }
                case 10: {
                    int i5;
                    int no = this.decodeBits(bbits);
                    for (i5 = 0; i5 < no; ++i5) {
                        bond = this.decodeBits(bbits);
                        int bondTypes = this.decodeBits(5) << 0;
                        this.mMol.setBondQueryFeature(bond, bondTypes, true);
                    }
                    continue block64;
                }
                case 11: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        this.mMol.setAtomQueryFeature(atom, 8192L, true);
                    }
                    continue block64;
                }
                case 12: {
                    int i5;
                    int no = this.decodeBits(bbits);
                    for (i5 = 0; i5 < no; ++i5) {
                        bond = this.decodeBits(bbits);
                        int bridgeData = this.decodeBits(8) << 7;
                        this.mMol.setBondQueryFeature(bond, bridgeData, true);
                    }
                    continue block64;
                }
                case 13: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        long piElectrons = (long)this.decodeBits(3) << 14;
                        this.mMol.setAtomQueryFeature(atom, piElectrons, true);
                    }
                    continue block64;
                }
                case 14: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        long neighbours = (long)this.decodeBits(5) << 17;
                        this.mMol.setAtomQueryFeature(atom, neighbours, true);
                    }
                    continue block64;
                }
                case 15: {
                    offset = 16;
                    break;
                }
                case 16: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        long ringSize = (long)this.decodeBits(3) << 22;
                        this.mMol.setAtomQueryFeature(atom, ringSize, true);
                    }
                    continue block64;
                }
                case 17: {
                    int atom;
                    int i5;
                    int no = this.decodeBits(abits);
                    for (i5 = 0; i5 < no; ++i5) {
                        atom = this.decodeBits(abits);
                        this.mMol.setAtomAbnormalValence(atom, this.decodeBits(4));
                    }
                    continue block64;
                }
                case 18: {
                    int i6;
                    int no = this.decodeBits(abits);
                    int lbits = this.decodeBits(4);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        int count = this.decodeBits(lbits);
                        byte[] label = new byte[count];
                        for (int j = 0; j < count; ++j) {
                            label[j] = (byte)this.decodeBits(7);
                        }
                        this.mMol.setAtomCustomLabel(atom, new String(label));
                    }
                    continue block64;
                }
                case 19: {
                    int i6;
                    int no = this.decodeBits(abits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        long charge = (long)this.decodeBits(3) << 25;
                        this.mMol.setAtomQueryFeature(atom, charge, true);
                    }
                    continue block64;
                }
                case 20: {
                    int i6;
                    int no = this.decodeBits(bbits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int bond2 = this.decodeBits(bbits);
                        int ringSize = this.decodeBits(3) << 15;
                        this.mMol.setBondQueryFeature(bond2, ringSize, true);
                    }
                    continue block64;
                }
                case 21: {
                    int i6;
                    int no = this.decodeBits(abits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        this.mMol.setAtomRadical(atom, this.decodeBits(2) << 4);
                    }
                    continue block64;
                }
                case 22: {
                    int i6;
                    int no = this.decodeBits(abits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        this.mMol.setAtomQueryFeature(atom, 0x10000000L, true);
                    }
                    continue block64;
                }
                case 23: {
                    int i6;
                    int no = this.decodeBits(bbits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int bond3 = this.decodeBits(bbits);
                        this.mMol.setBondQueryFeature(bond3, 262144, true);
                    }
                    continue block64;
                }
                case 24: {
                    int i6;
                    int no = this.decodeBits(bbits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int bond4 = this.decodeBits(bbits);
                        int aromState = this.decodeBits(2) << 19;
                        this.mMol.setBondQueryFeature(bond4, aromState, true);
                    }
                    continue block64;
                }
                case 25: {
                    int i6;
                    for (i6 = 0; i6 < allAtoms; ++i6) {
                        if (this.decodeBits(1) != 1) continue;
                        this.mMol.setAtomSelection(i6, true);
                    }
                    continue block64;
                }
                case 26: {
                    int i6;
                    int no = this.decodeBits(bbits);
                    aromaticSPBond = new int[no];
                    for (i6 = 0; i6 < no; ++i6) {
                        aromaticSPBond[i6] = this.decodeBits(bbits);
                    }
                    continue block64;
                }
                case 27: {
                    int i6;
                    int no = this.decodeBits(abits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        this.mMol.setAtomQueryFeature(atom, 0x20000000L, true);
                    }
                    continue block64;
                }
                case 28: {
                    int i6;
                    int no = this.decodeBits(bbits);
                    for (i6 = 0; i6 < no; ++i6) {
                        this.mMol.setBondType(this.decodeBits(bbits), 32);
                    }
                    continue block64;
                }
                case 29: {
                    int i6;
                    int no = this.decodeBits(abits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        long hint = this.decodeBits(2) << 30;
                        this.mMol.setAtomQueryFeature(atom, hint, true);
                    }
                    continue block64;
                }
                case 30: {
                    int i6;
                    int no = this.decodeBits(abits);
                    for (i6 = 0; i6 < no; ++i6) {
                        int atom = this.decodeBits(abits);
                        long ringSize = (long)this.decodeBits(7) << 32;
                        this.mMol.setAtomQueryFeature(atom, ringSize, true);
                    }
                    break;
                }
            }
        }
        new AromaticityResolver(this.mMol).locateDelocalizedDoubleBonds(isDelocalizedBond);
        if (aromaticSPBond != null) {
            for (int bond : aromaticSPBond) {
                this.mMol.setBondType(bond, this.mMol.getBondType(bond) == 2 ? 4 : 2);
            }
        }
        if (!(coordinates != null || this.mNeglectSpaceDelimitedCoordinates || idcode.length <= this.mIDCodeBufferIndex + 1 || idcode[this.mIDCodeBufferIndex + 1] != 32 && idcode[this.mIDCodeBufferIndex + 1] != 9)) {
            coordinates = idcode;
            coordsStart = this.mIDCodeBufferIndex + 2;
        }
        if (coordinates != null) {
            try {
                if (coordinates[coordsStart] == 33 || coordinates[coordsStart] == 35) {
                    int atom;
                    double factor;
                    this.decodeBitsStart(coordinates, coordsStart + 1);
                    coordsAre3D = this.decodeBits(1) == 1;
                    coordsAreAbsolute = this.decodeBits(1) == 1;
                    int resolutionBits = 2 * this.decodeBits(4);
                    int binCount = 1 << resolutionBits;
                    int from = 0;
                    int bond = 0;
                    for (int atom2 = 1; atom2 < allAtoms; ++atom2) {
                        double factor2;
                        if (bond < allBonds && this.mMol.getBondAtom(1, bond) == atom2) {
                            from = this.mMol.getBondAtom(0, bond++);
                            factor2 = 1.0;
                        } else {
                            from = 0;
                            factor2 = 8.0;
                        }
                        this.mMol.setAtomX(atom2, this.mMol.getAtomX(from) + factor2 * (double)(this.decodeBits(resolutionBits) - binCount / 2));
                        this.mMol.setAtomY(atom2, this.mMol.getAtomY(from) + factor2 * (double)(this.decodeBits(resolutionBits) - binCount / 2));
                        if (!coordsAre3D) continue;
                        this.mMol.setAtomZ(atom2, this.mMol.getAtomZ(from) + factor2 * (double)(this.decodeBits(resolutionBits) - binCount / 2));
                    }
                    if (coordinates[coordsStart] == 35) {
                        int atom3;
                        int hydrogenCount = 0;
                        int[] hCount = new int[allAtoms];
                        for (atom3 = 0; atom3 < allAtoms; ++atom3) {
                            hCount[atom3] = this.mMol.getImplicitHydrogens(atom3);
                            hydrogenCount += hCount[atom3];
                        }
                        for (atom3 = 0; atom3 < allAtoms; ++atom3) {
                            for (int i7 = 0; i7 < hCount[atom3]; ++i7) {
                                int hydrogen = this.mMol.addAtom(1);
                                this.mMol.addBond(atom3, hydrogen, 1);
                                this.mMol.setAtomX(hydrogen, this.mMol.getAtomX(atom3) + (double)(this.decodeBits(resolutionBits) - binCount / 2));
                                this.mMol.setAtomY(hydrogen, this.mMol.getAtomY(atom3) + (double)(this.decodeBits(resolutionBits) - binCount / 2));
                                if (!coordsAre3D) continue;
                                this.mMol.setAtomZ(hydrogen, this.mMol.getAtomZ(atom3) + (double)(this.decodeBits(resolutionBits) - binCount / 2));
                            }
                        }
                        allAtoms += hydrogenCount;
                        allBonds += hydrogenCount;
                    }
                    double avblDefault = coordsAre3D ? 1.5 : Molecule.getDefaultAverageBondLength();
                    double avbl = this.mMol.getAverageBondLength(allAtoms, allBonds, avblDefault);
                    if (coordsAreAbsolute) {
                        targetAVBL = this.decodeAVBL(this.decodeBits(resolutionBits), binCount);
                        xOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
                        yOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
                        if (coordsAre3D) {
                            zOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
                        }
                        factor = targetAVBL / avbl;
                        for (atom = 0; atom < allAtoms; ++atom) {
                            this.mMol.setAtomX(atom, xOffset + factor * this.mMol.getAtomX(atom));
                            this.mMol.setAtomY(atom, yOffset + factor * this.mMol.getAtomY(atom));
                            if (!coordsAre3D) continue;
                            this.mMol.setAtomZ(atom, zOffset + factor * this.mMol.getAtomZ(atom));
                        }
                    } else {
                        targetAVBL = 1.5;
                        factor = targetAVBL / avbl;
                        for (atom = 0; atom < allAtoms; ++atom) {
                            this.mMol.setAtomX(atom, factor * this.mMol.getAtomX(atom));
                            this.mMol.setAtomY(atom, factor * this.mMol.getAtomY(atom));
                            if (!coordsAre3D) continue;
                            this.mMol.setAtomZ(atom, factor * this.mMol.getAtomZ(atom));
                        }
                    }
                } else {
                    if (coordsAre3D && !coordsAreAbsolute && targetAVBL == 0.0) {
                        targetAVBL = 1.5;
                    }
                    if (targetAVBL != 0.0 && this.mMol.getAllBonds() != 0) {
                        double avbl = 0.0;
                        for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
                            double dx = this.mMol.getAtomX(this.mMol.getBondAtom(0, bond)) - this.mMol.getAtomX(this.mMol.getBondAtom(1, bond));
                            double dy = this.mMol.getAtomY(this.mMol.getBondAtom(0, bond)) - this.mMol.getAtomY(this.mMol.getBondAtom(1, bond));
                            double dz = coordsAre3D ? this.mMol.getAtomZ(this.mMol.getBondAtom(0, bond)) - this.mMol.getAtomZ(this.mMol.getBondAtom(1, bond)) : 0.0;
                            avbl += Math.sqrt(dx * dx + dy * dy + dz * dz);
                        }
                        double f = targetAVBL / (avbl /= (double)this.mMol.getAllBonds());
                        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                            this.mMol.setAtomX(atom, this.mMol.getAtomX(atom) * f + xOffset);
                            this.mMol.setAtomY(atom, this.mMol.getAtomY(atom) * f + yOffset);
                            if (!coordsAre3D) continue;
                            this.mMol.setAtomZ(atom, this.mMol.getAtomZ(atom) * f + zOffset);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Faulty id-coordinates:" + e.toString() + " " + new String(idcode) + " " + new String(coordinates));
                coordinates = null;
                coordsAre3D = false;
            }
        }
        boolean bl = coords2DAvailable = coordinates != null && !coordsAre3D;
        if (coords2DAvailable || this.ensure2DCoordinates()) {
            this.mMol.ensureHelperArrays(7);
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (this.mMol.getBondOrder(bond) != 2 || this.mMol.isSmallRingBond(bond) || this.mMol.getBondParity(bond) != 0) continue;
                this.mMol.setBondParityUnknownOrNone(bond);
            }
        }
        if (!coords2DAvailable && this.ensure2DCoordinates()) {
            this.mMol.setParitiesValid(0);
            try {
                this.inventCoordinates(this.mMol);
                coords2DAvailable = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("2D-coordinate creation failed:" + e.toString() + " " + new String(idcode));
            }
        }
        if (coords2DAvailable) {
            this.mMol.setStereoBondsFromParity();
            this.mMol.setUnknownParitiesToExplicitlyUnknown();
        } else if (!coordsAre3D) {
            this.mMol.setParitiesValid(0);
        }
    }

    protected void inventCoordinates(StereoMolecule mol) throws Exception {
        throw new Exception("Unexpected request to invent coordinates. Check source code logic!");
    }

    public void parseCoordinates(byte[] encodedCoords, int coordsStart, StereoMolecule mol, Coordinates[] coords) throws Exception {
        int atom;
        double avbl;
        double factor;
        mol.ensureHelperArrays(1);
        int atomCount = mol.getAtoms();
        int bondCount = mol.getBonds();
        this.decodeBitsStart(encodedCoords, coordsStart + 1);
        boolean coordsAre3D = this.decodeBits(1) == 1;
        boolean coordsAreAbsolute = this.decodeBits(1) == 1;
        int resolutionBits = 2 * this.decodeBits(4);
        int binCount = 1 << resolutionBits;
        int from = 0;
        int bond = 0;
        for (int atom2 = 1; atom2 < atomCount; ++atom2) {
            if (bond < bondCount && mol.getBondAtom(1, bond) == atom2) {
                from = mol.getBondAtom(0, bond++);
                factor = 1.0;
            } else {
                from = 0;
                factor = 8.0;
            }
            coords[atom2].x = coords[from].x + factor * (double)(this.decodeBits(resolutionBits) - binCount / 2);
            coords[atom2].y = coords[from].y + factor * (double)(this.decodeBits(resolutionBits) - binCount / 2);
            if (!coordsAre3D) continue;
            coords[atom2].z = coords[from].z + factor * (double)(this.decodeBits(resolutionBits) - binCount / 2);
        }
        double d = avbl = coordsAre3D ? 1.5 : Molecule.getDefaultAverageBondLength();
        if (bondCount != 0) {
            for (int b = 0; b < bondCount; ++b) {
                avbl += coords[mol.getBondAtom(0, b)].distance(coords[mol.getBondAtom(1, b)]);
            }
        }
        avbl /= (double)bondCount;
        if (encodedCoords[coordsStart] == 35) {
            int hydrogenCount = 0;
            int hydrogen = atomCount;
            for (atom = 0; atom < atomCount; ++atom) {
                int hCount = mol.getAllConnAtoms(atom) - mol.getConnAtoms(atom);
                for (int i = 0; i < hCount; ++i) {
                    coords[hydrogen].x = coords[atom].x + (double)(this.decodeBits(resolutionBits) - binCount / 2);
                    coords[hydrogen].y = coords[atom].y + (double)(this.decodeBits(resolutionBits) - binCount / 2);
                    if (coordsAre3D) {
                        coords[hydrogen].z = coords[atom].z + (double)(this.decodeBits(resolutionBits) - binCount / 2);
                    }
                    ++hydrogen;
                }
                hydrogenCount += hCount;
            }
            atomCount += hydrogenCount;
            bondCount += hydrogenCount;
        }
        if (coordsAreAbsolute) {
            double targetAVBL = this.decodeAVBL(this.decodeBits(resolutionBits), binCount);
            double xOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
            double yOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
            double zOffset = 0.0;
            if (coordsAre3D) {
                zOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
            }
            factor = targetAVBL / avbl;
            for (int atom3 = 0; atom3 < atomCount; ++atom3) {
                coords[atom3].x = xOffset + factor * coords[atom3].x;
                coords[atom3].y = yOffset + factor * coords[atom3].y;
                if (!coordsAre3D) continue;
                coords[atom3].z = zOffset + factor * coords[atom3].z;
            }
        } else {
            double targetAVBL = 1.5;
            factor = targetAVBL / avbl;
            for (atom = 0; atom < atomCount; ++atom) {
                coords[atom].x = factor * coords[atom].x;
                coords[atom].y = factor * coords[atom].y;
                if (!coordsAre3D) continue;
                coords[atom].z = factor * coords[atom].z;
            }
        }
    }

    public void parseMapping(byte[] mapping) {
        this.parseMapping(mapping, 0);
    }

    public void parseMapping(byte[] mapping, int mappingStart) {
        if (mapping == null || mapping.length <= mappingStart || mapping[mappingStart] < 64) {
            return;
        }
        this.decodeBitsStart(mapping, mappingStart);
        int nbits = this.decodeBits(4);
        boolean autoMappingFound = this.decodeBits(1) == 1;
        boolean manualMappingFound = this.decodeBits(1) == 1;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            int mapNo = this.decodeBits(nbits);
            boolean autoMapped = autoMappingFound;
            if (autoMappingFound && manualMappingFound) {
                autoMapped = this.decodeBits(1) == 1;
            }
            this.mMol.setAtomMapNo(atom, mapNo, autoMapped);
        }
    }

    public boolean coordinatesAre3D(String idcode, String coordinates) {
        return coordinates != null && this.coordinatesAre3D(idcode.getBytes(), coordinates.getBytes());
    }

    public boolean coordinatesAre3D(byte[] idcode, byte[] coordinates) {
        return this.coordinatesAre3D(idcode, coordinates, 0, 0);
    }

    public boolean coordinatesAre3D(byte[] idcode, byte[] coordinates, int idcodeStart, int coordsStart) {
        if (coordinates == null || coordinates.length <= coordsStart) {
            return false;
        }
        if (coordinates[coordsStart] == 33 || coordinates[coordsStart] == 35) {
            this.decodeBitsStart(coordinates, coordsStart + 1);
            return this.decodeBits(1) == 1;
        }
        int allAtoms = this.getAtomCount(idcode, idcodeStart);
        return allAtoms != 0 && coordinates.length >= coordsStart + 3 * allAtoms - 3 && coordinates[coordsStart + 2 * allAtoms - 2] != 39;
    }

    public boolean coordinatesAreAbsolute(String coordinates) {
        return coordinates != null && this.coordinatesAreAbsolute(coordinates.getBytes());
    }

    public boolean coordinatesAreAbsolute(byte[] coordinates) {
        return this.coordinatesAreAbsolute(coordinates, 0);
    }

    public boolean coordinatesAreAbsolute(byte[] coordinates, int coordStart) {
        if (coordinates == null || coordinates.length <= coordStart) {
            return false;
        }
        if (coordinates[coordStart] >= 39) {
            for (int i = coordStart; i < coordinates.length; ++i) {
                if (coordinates[i] != 39 && coordinates[i] != 38) continue;
                return true;
            }
        } else if (coordinates[coordStart] == 33 || coordinates[coordStart] == 35) {
            this.decodeBitsStart(coordinates, coordStart + 1);
            this.decodeBits(1);
            return this.decodeBits(1) == 1;
        }
        return false;
    }

    public int getIDCodeVersion(String idcode) {
        if (idcode == null || idcode.length() == 0) {
            return -1;
        }
        return this.getIDCodeVersion(idcode.getBytes());
    }

    public int getIDCodeVersion(byte[] idcode) {
        int version = 8;
        this.decodeBitsStart(idcode, 0);
        int abits = this.decodeBits(4);
        if (abits > 8) {
            version = abits;
        }
        return version;
    }

    public int getAtomCount(String idcode) {
        if (idcode == null || idcode.length() == 0) {
            return 0;
        }
        return this.getAtomCount(idcode.getBytes(), 0);
    }

    public int getAtomCount(byte[] idcode, int offset) {
        if (idcode == null || idcode.length <= offset) {
            return 0;
        }
        this.decodeBitsStart(idcode, offset);
        int abits = this.decodeBits(4);
        int bbits = this.decodeBits(4);
        if (abits > 8) {
            abits = bbits;
        }
        if (abits == 0) {
            return 0;
        }
        return this.decodeBits(abits);
    }

    public int[] getAtomAndBondCounts(String idcode, int[] count) {
        if (idcode == null || idcode.length() == 0) {
            return null;
        }
        return this.getAtomAndBondCounts(idcode.getBytes(), 0, count);
    }

    public int[] getAtomAndBondCounts(byte[] idcode, int offset, int[] count) {
        if (idcode == null || idcode.length == 0) {
            return null;
        }
        this.decodeBitsStart(idcode, 0);
        int abits = this.decodeBits(4);
        int bbits = this.decodeBits(4);
        if (abits > 8) {
            abits = bbits;
        }
        if (count == null) {
            count = new int[2];
        }
        if (abits == 0) {
            count[0] = 0;
            count[1] = 0;
        } else {
            count[0] = this.decodeBits(abits);
            count[1] = this.decodeBits(bbits);
        }
        return count;
    }

    private void decodeBitsStart(byte[] bytes, int offset) {
        this.mIDCodeBitsAvail = 6;
        this.mIDCodeBufferIndex = offset;
        this.mDecodingBytes = bytes;
        this.mIDCodeTempData = (bytes[this.mIDCodeBufferIndex] & 0x3F) << 11;
    }

    private int decodeBits(int bits) {
        int allBits = bits;
        int data = 0;
        while (bits != 0) {
            if (this.mIDCodeBitsAvail == 0) {
                this.mIDCodeTempData = (this.mDecodingBytes[++this.mIDCodeBufferIndex] & 0x3F) << 11;
                this.mIDCodeBitsAvail = 6;
            }
            data |= (0x10000 & this.mIDCodeTempData) >> 16 - allBits + bits;
            this.mIDCodeTempData <<= 1;
            --bits;
            --this.mIDCodeBitsAvail;
        }
        return data;
    }

    private double decodeAVBL(int value, int binCount) {
        return Math.pow(10.0, Math.log10(2000.0) * (double)value / (double)(binCount - 1) - 1.0);
    }

    private double decodeShift(int value, int binCount) {
        boolean isNegative;
        int halfBinCount = binCount / 2;
        boolean bl = isNegative = value >= halfBinCount;
        if (isNegative) {
            value -= halfBinCount;
        }
        double steepness = binCount / 32;
        double doubleValue = steepness * (double)value / (double)(halfBinCount - value);
        return isNegative ? -doubleValue : doubleValue;
    }

    public void printContent(byte[] idcode, byte[] coordinates) {
        try {
            int EZCount;
            int i;
            int i2;
            int version = 8;
            if (idcode == null || idcode.length == 0) {
                return;
            }
            if (coordinates != null && coordinates.length == 0) {
                coordinates = null;
            }
            System.out.println("idcode: " + new String(idcode));
            if (coordinates != null) {
                System.out.println("coords: " + new String(coordinates));
            }
            this.decodeBitsStart(idcode, 0);
            int abits = this.decodeBits(4);
            int bbits = this.decodeBits(4);
            if (abits > 8) {
                version = abits;
                abits = bbits;
            }
            System.out.println("version:" + version);
            int allAtoms = this.decodeBits(abits);
            if (allAtoms == 0) {
                return;
            }
            int allBonds = this.decodeBits(bbits);
            int nitrogens = this.decodeBits(abits);
            int oxygens = this.decodeBits(abits);
            int otherAtoms = this.decodeBits(abits);
            int chargedAtoms = this.decodeBits(abits);
            System.out.println("allAtoms:" + allAtoms + " allBonds:" + allBonds);
            if (nitrogens != 0) {
                System.out.print("nitrogens:");
                for (i2 = 0; i2 < nitrogens; ++i2) {
                    System.out.print(" " + this.decodeBits(abits));
                }
                System.out.println();
            }
            if (oxygens != 0) {
                System.out.print("oxygens:");
                for (i2 = 0; i2 < oxygens; ++i2) {
                    System.out.print(" " + this.decodeBits(abits));
                }
                System.out.println();
            }
            if (otherAtoms != 0) {
                System.out.print("otherAtoms:");
                for (i2 = 0; i2 < otherAtoms; ++i2) {
                    System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(8));
                }
                System.out.println();
            }
            if (chargedAtoms != 0) {
                System.out.print("chargedAtoms:");
                for (i2 = 0; i2 < chargedAtoms; ++i2) {
                    System.out.print(" " + this.decodeBits(abits) + ":" + (this.decodeBits(4) - 8));
                }
                System.out.println();
            }
            int closureBonds = 1 + allBonds - allAtoms;
            int dbits = this.decodeBits(4);
            int base = 0;
            int[][] bondAtom = new int[2][allBonds];
            int bondCount = 0;
            for (i = 1; i < allAtoms; ++i) {
                int dif = this.decodeBits(dbits);
                if (dif == 0) {
                    ++closureBonds;
                    continue;
                }
                bondAtom[0][bondCount] = base += dif - 1;
                bondAtom[1][bondCount++] = i;
            }
            for (i = 0; i < closureBonds; ++i) {
                bondAtom[0][bondCount] = this.decodeBits(abits);
                bondAtom[1][bondCount++] = this.decodeBits(abits);
            }
            int[] bondOrder = new int[allBonds];
            System.out.print("bonds:");
            for (int bond = 0; bond < allBonds; ++bond) {
                System.out.print(" " + bondAtom[0][bond]);
                bondOrder[bond] = this.decodeBits(2);
                System.out.print(bondOrder[bond] == 0 ? "." : (bondOrder[bond] == 1 ? "-" : (bondOrder[bond] == 2 ? "=" : "#")));
                System.out.print("" + bondAtom[1][bond]);
            }
            System.out.println();
            int THCount = this.decodeBits(abits);
            if (THCount != 0) {
                System.out.print("parities:");
                block54: for (int i3 = 0; i3 < THCount; ++i3) {
                    int parity;
                    int atom = this.decodeBits(abits);
                    if (version == 8) {
                        parity = this.decodeBits(2);
                        if (parity == 3) {
                            System.out.print(" " + atom + ":1&0");
                            continue;
                        }
                        System.out.print(" " + atom + ":" + parity);
                        continue;
                    }
                    parity = this.decodeBits(3);
                    switch (parity) {
                        case 4: {
                            System.out.print(" " + atom + ":1&" + this.decodeBits(3));
                            continue block54;
                        }
                        case 5: {
                            System.out.print(" " + atom + ":2&" + this.decodeBits(3));
                            continue block54;
                        }
                        case 6: {
                            System.out.print(" " + atom + ":1|" + this.decodeBits(3));
                            continue block54;
                        }
                        case 7: {
                            System.out.print(" " + atom + ":2|" + this.decodeBits(3));
                            continue block54;
                        }
                        default: {
                            System.out.print(" " + atom + ":" + parity);
                        }
                    }
                }
                System.out.println();
            }
            if (version == 8 && this.decodeBits(1) == 0) {
                System.out.println("isRacemate");
            }
            if ((EZCount = this.decodeBits(bbits)) != 0) {
                System.out.print("EZ:");
                for (int i4 = 0; i4 < EZCount; ++i4) {
                    int bond = this.decodeBits(bbits);
                    if (bondOrder[bond] == 1) {
                        int parity = this.decodeBits(3);
                        switch (parity) {
                            case 4: {
                                System.out.print(" " + bond + ":1&" + this.decodeBits(3));
                                break;
                            }
                            case 5: {
                                System.out.print(" " + bond + ":2&" + this.decodeBits(3));
                                break;
                            }
                            case 6: {
                                System.out.print(" " + bond + ":1|" + this.decodeBits(3));
                                break;
                            }
                            case 7: {
                                System.out.print(" " + bond + ":2|" + this.decodeBits(3));
                                break;
                            }
                            default: {
                                System.out.print(" " + bond + ":" + parity);
                                break;
                            }
                        }
                        continue;
                    }
                    System.out.print(" " + bond + ":" + this.decodeBits(2));
                }
                System.out.println();
            }
            if (this.decodeBits(1) == 1) {
                System.out.println("isFragment = true");
            }
            int offset = 0;
            block56: while (this.decodeBits(1) == 1) {
                int dataType = offset + this.decodeBits(4);
                switch (dataType) {
                    case 0: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("noMoreNeighbours:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits));
                        }
                        System.out.println();
                        break;
                    }
                    case 1: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("mass:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(8));
                        }
                        System.out.println();
                        break;
                    }
                    case 2: {
                        int i5;
                        int no = this.decodeBits(bbits);
                        System.out.print("delocalizedBonds (outdated, redundant and wrong):");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(bbits));
                        }
                        System.out.println();
                        break;
                    }
                    case 3: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("moreNeighbours:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits));
                        }
                        System.out.println();
                        break;
                    }
                    case 4: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomRingState:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(4));
                        }
                        System.out.println();
                        break;
                    }
                    case 5: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomAromState:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 6: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomAny:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits));
                        }
                        System.out.println();
                        break;
                    }
                    case 7: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomHydrogen:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(4));
                        }
                        System.out.println();
                        break;
                    }
                    case 8: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomList:");
                        for (i5 = 0; i5 < no; ++i5) {
                            int atom = this.decodeBits(abits);
                            int atoms = this.decodeBits(4);
                            System.out.print(" " + atom);
                            for (int j = 0; j < atoms; ++j) {
                                System.out.print(j == 0 ? ":" : ",");
                                System.out.print("" + this.decodeBits(8));
                            }
                        }
                        System.out.println();
                        break;
                    }
                    case 9: {
                        int i5;
                        int no = this.decodeBits(bbits);
                        System.out.print("bondRingState:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(bbits) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 10: {
                        int i5;
                        int no = this.decodeBits(bbits);
                        System.out.print("bondTypes:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(bbits) + ":" + this.decodeBits(5));
                        }
                        System.out.println();
                        break;
                    }
                    case 11: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomMatchStereo:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits));
                        }
                        System.out.println();
                        break;
                    }
                    case 12: {
                        int i5;
                        int no = this.decodeBits(bbits);
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print("bridgeBond:" + this.decodeBits(bbits));
                            int min = this.decodeBits(4);
                            int max = min + this.decodeBits(4);
                            System.out.println("(" + min + "-" + max + ")");
                        }
                        continue block56;
                    }
                    case 13: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("atomPiElectrons:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 14: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomQFNeighbours:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(5));
                        }
                        System.out.println();
                        break;
                    }
                    case 15: {
                        offset = 16;
                        System.out.println("<start second feature set>");
                        break;
                    }
                    case 16: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomQFSmallRingSize:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 17: {
                        int i5;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomAbnormalValence:");
                        for (i5 = 0; i5 < no; ++i5) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(4));
                        }
                        System.out.println();
                        break;
                    }
                    case 18: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomCustomLabel:");
                        int lbits = this.decodeBits(4);
                        for (i6 = 0; i6 < no; ++i6) {
                            int atom = this.decodeBits(abits);
                            int count = this.decodeBits(lbits);
                            byte[] label = new byte[count];
                            for (int j = 0; j < count; ++j) {
                                label[j] = (byte)this.decodeBits(7);
                            }
                            System.out.print(" " + atom + ":" + new String(label));
                        }
                        System.out.println();
                        break;
                    }
                    case 19: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomQFCharge:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 20: {
                        int i6;
                        int no = this.decodeBits(bbits);
                        System.out.print("BondQFRingSize:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(bbits) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 21: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomRadicalState:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 22: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomQFFlatNitrogen:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":true");
                        }
                        System.out.println();
                        break;
                    }
                    case 23: {
                        int i6;
                        int no = this.decodeBits(bbits);
                        System.out.print("cBondQFMatchStereo:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":true");
                        }
                        System.out.println();
                        break;
                    }
                    case 24: {
                        int i6;
                        int no = this.decodeBits(bbits);
                        System.out.print("BondQFAromState:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(bbits) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 25: {
                        int i6;
                        System.out.print("AtomSelection:");
                        for (i6 = 0; i6 < allAtoms; ++i6) {
                            if (this.decodeBits(1) != 1) continue;
                            System.out.print(" " + i6);
                        }
                        System.out.println();
                        break;
                    }
                    case 26: {
                        int i6;
                        System.out.print("DelocalizedHigherOrderBonds:");
                        int no = this.decodeBits(bbits);
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(bbits));
                        }
                        continue block56;
                    }
                    case 27: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomQFExcludeGroup:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":true");
                        }
                        System.out.println();
                        break;
                    }
                    case 28: {
                        int i6;
                        int no = this.decodeBits(bbits);
                        System.out.print("Coordinate Bonds:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(bbits));
                        }
                        System.out.println();
                        break;
                    }
                    case 29: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("ReactionParityHint:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 30: {
                        int i6;
                        int no = this.decodeBits(abits);
                        System.out.print("AtomQFNewRingSize:");
                        for (i6 = 0; i6 < no; ++i6) {
                            System.out.print(" " + this.decodeBits(abits) + ":" + this.decodeBits(7));
                        }
                        System.out.println();
                    }
                }
            }
            if (coordinates != null && (coordinates[0] == 33 || coordinates[0] == 35)) {
                double targetAVBL;
                this.decodeBitsStart(coordinates, 1);
                boolean coordsAre3D = this.decodeBits(1) == 1;
                boolean coordsAreAbsolute = this.decodeBits(1) == 1;
                int resolutionBits = 2 * this.decodeBits(4);
                int binCount = 1 << resolutionBits;
                int hydrogenCount = 0;
                int[] hCount = null;
                if (coordinates[0] == 35) {
                    StereoMolecule mol = new IDCodeParserWithoutCoordinateInvention().getCompactMolecule(idcode);
                    hCount = new int[allAtoms];
                    for (int atom = 0; atom < allAtoms; ++atom) {
                        hCount[atom] = mol.getImplicitHydrogens(atom);
                        hydrogenCount += hCount[atom];
                    }
                }
                double[][] coords = new double[coordsAre3D ? 3 : 2][allAtoms + hydrogenCount];
                int from = 0;
                int bond = 0;
                System.out.print("Raw coords:");
                for (int atom = 1; atom < allAtoms; ++atom) {
                    double factor;
                    if (bond < allBonds && bondAtom[1][bond] == atom) {
                        from = bondAtom[0][bond++];
                        factor = 1.0;
                    } else {
                        from = 0;
                        factor = 8.0;
                    }
                    System.out.print(atom + " (");
                    coords[0][atom] = coords[0][from] + factor * (double)(this.decodeBits(resolutionBits) - binCount / 2);
                    System.out.print((int)coords[0][atom] + ",");
                    coords[1][atom] = coords[1][from] + factor * (double)(this.decodeBits(resolutionBits) - binCount / 2);
                    System.out.print((int)coords[1][atom]);
                    if (coordsAre3D) {
                        coords[2][atom] = coords[2][from] + factor * (double)(this.decodeBits(resolutionBits) - binCount / 2);
                        System.out.print("," + (int)coords[0][atom]);
                    }
                    System.out.print("), ");
                    if ((atom & 3) != 3 && atom != allAtoms - 1) continue;
                    System.out.println();
                }
                double avbl = 0.0;
                if (allBonds != 0) {
                    for (bond = 0; bond < allBonds; ++bond) {
                        avbl += this.getDistance(coords, bondAtom[0][bond], bondAtom[1][bond], coordsAre3D);
                    }
                    avbl /= (double)allBonds;
                } else {
                    double defaultAVBL;
                    double d = defaultAVBL = coordsAre3D ? 1.5 : Molecule.getDefaultAverageBondLength();
                    if (allAtoms < 2) {
                        avbl = defaultAVBL;
                    } else {
                        double lowDistance = Double.MAX_VALUE;
                        for (int atom1 = 1; atom1 < allAtoms; ++atom1) {
                            for (int atom2 = 0; atom2 < atom1; ++atom2) {
                                double distance = this.getDistance(coords, atom1, atom2, coordsAre3D);
                                if (!(distance > 0.0) || !(distance < lowDistance)) continue;
                                lowDistance = distance;
                            }
                        }
                        double d2 = avbl = lowDistance == Double.MAX_VALUE ? defaultAVBL : lowDistance;
                    }
                }
                if (coordinates[0] == 35) {
                    System.out.print("hydrogen coords (" + hydrogenCount + " expected): ");
                    int hydrogen = allAtoms;
                    for (int atom = 0; atom < allAtoms; ++atom) {
                        if (hCount[atom] != 0) {
                            System.out.print(atom);
                        }
                        for (int i7 = 0; i7 < hCount[atom]; ++i7) {
                            System.out.print(" (");
                            coords[0][hydrogen] = coords[0][atom] + (double)(this.decodeBits(resolutionBits) - binCount / 2);
                            System.out.print((int)coords[0][hydrogen] + ",");
                            coords[1][hydrogen] = coords[1][atom] + (double)(this.decodeBits(resolutionBits) - binCount / 2);
                            System.out.print((int)coords[1][hydrogen]);
                            if (coordsAre3D) {
                                coords[2][hydrogen] = coords[2][atom] + (double)(this.decodeBits(resolutionBits) - binCount / 2);
                                System.out.print("," + (int)coords[2][hydrogen]);
                            }
                            System.out.print("), ");
                            ++hydrogen;
                        }
                    }
                    System.out.println();
                }
                System.out.print(coordsAreAbsolute ? "absolute coords:" : "relative coords:");
                if (hydrogenCount != 0) {
                    System.out.println("Coordinates contain " + hydrogenCount + " hydrogen atoms!");
                }
                if (coordsAreAbsolute) {
                    targetAVBL = this.decodeAVBL(this.decodeBits(resolutionBits), binCount);
                    double xOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
                    double yOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
                    double zOffset = 0.0;
                    if (coordsAre3D) {
                        zOffset = targetAVBL * this.decodeShift(this.decodeBits(resolutionBits), binCount);
                    }
                    System.out.println("Abs-coord transformation: targetAVBL:" + targetAVBL + " xOffset:" + xOffset + " yOffset:" + yOffset + " zOffset:" + zOffset);
                    double factor = targetAVBL / avbl;
                    for (int atom = 0; atom < allAtoms; ++atom) {
                        coords[0][atom] = xOffset + factor * coords[0][atom];
                        coords[1][atom] = xOffset + factor * coords[1][atom];
                        if (!coordsAre3D) continue;
                        coords[2][atom] = xOffset + factor * coords[2][atom];
                    }
                } else {
                    targetAVBL = 1.5;
                    double factor = targetAVBL / avbl;
                    for (int atom = 0; atom < allAtoms; ++atom) {
                        System.out.print(atom + " (");
                        coords[0][atom] = coords[0][atom] * factor;
                        System.out.print(DoubleFormat.toString(coords[0][atom]) + ",");
                        coords[1][atom] = coords[1][atom] * factor;
                        System.out.print(DoubleFormat.toString(coords[1][atom]));
                        if (coordsAre3D) {
                            coords[2][atom] = coords[2][atom] * factor;
                            System.out.print("," + DoubleFormat.toString(coords[2][atom]));
                        }
                        System.out.print("), ");
                        if ((atom & 3) != 3 && atom != allAtoms - 1) continue;
                        System.out.println();
                    }
                }
            }
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double getDistance(double[][] coords, int atom1, int atom2, boolean coordsAre3D) {
        double dx = coords[0][atom1] - coords[0][atom2];
        double dy = coords[1][atom1] - coords[1][atom2];
        double dz = coordsAre3D ? coords[2][atom1] - coords[2][atom2] : 0.0;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

