/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.SmilesAtom;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IsomericSmilesCreator {
    public static final int MODE_CREATE_SMARTS = 1;
    public static final int MODE_INCLUDE_MAPPING = 2;
    public static final int MODE_KEKULIZED_OUTPUT = 4;
    private StereoMolecule mMol;
    private Canonizer mCanonizer;
    private String mSmiles;
    private int mMode;
    private int[] mAtomRank;
    private int[] mClosureNumber;
    private int[] mSmilesIndex;
    private int[][] mKnownTHCountInESRGroup;
    private List<SmilesAtom> mGraphAtomList;
    private boolean[] mAtomUsed;
    private boolean[] mBondUsed;
    private boolean[] mPseudoStereoGroupInversion;
    private boolean[] mPseudoStereoGroupInitialized;
    private int[] mEZHalfParity;

    public static String createSmiles(StereoMolecule mol) {
        return new IsomericSmilesCreator(mol, 0).getSmiles();
    }

    public static String createSmarts(StereoMolecule mol) {
        return new IsomericSmilesCreator(mol, 1).getSmiles();
    }

    public static String createReactionSmarts(Reaction rxn) {
        return IsomericSmilesCreator.createReactionSmiles(rxn, 3);
    }

    public static String createReactionSmiles(Reaction rxn) {
        return IsomericSmilesCreator.createReactionSmiles(rxn, 2);
    }

    public static String createReactionSmiles(Reaction rxn, int mode) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < rxn.getReactants(); ++i) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(new IsomericSmilesCreator(rxn.getReactant(i), mode).getSmiles());
        }
        sb.append('>');
        for (i = 0; i < rxn.getCatalysts(); ++i) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(new IsomericSmilesCreator(rxn.getCatalyst(i)).getSmiles());
        }
        sb.append('>');
        for (i = 0; i < rxn.getProducts(); ++i) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(new IsomericSmilesCreator(rxn.getProduct(i), mode).getSmiles());
        }
        return sb.toString();
    }

    public IsomericSmilesCreator(StereoMolecule mol) {
        this(mol, false);
    }

    public IsomericSmilesCreator(StereoMolecule mol, int mode) {
        this.mMol = mol;
        this.mMode = mode;
    }

    @Deprecated
    public IsomericSmilesCreator(StereoMolecule mol, boolean includeAtomMapping) {
        this(mol, includeAtomMapping ? 2 : 0);
    }

    public String getSmiles() {
        if (this.mSmiles == null) {
            this.mSmiles = this.createSmiles();
        }
        return this.mSmiles;
    }

    private String createSmiles() {
        if (this.mMol == null || this.mMol.getAllAtoms() == 0) {
            return "";
        }
        this.mMol.ensureHelperArrays(15);
        this.mCanonizer = new Canonizer(this.mMol, 129);
        int groupCount = this.mCanonizer.getPseudoStereoGroupCount();
        this.mPseudoStereoGroupInversion = new boolean[groupCount + 1];
        this.mPseudoStereoGroupInitialized = new boolean[groupCount + 1];
        this.mKnownTHCountInESRGroup = new int[2][32];
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            int type = this.mMol.getAtomESRType(atom) - 1;
            if (type == -1) continue;
            int[] nArray = this.mKnownTHCountInESRGroup[type];
            int n = this.mMol.getAtomESRGroup(atom);
            nArray[n] = nArray[n] + 1;
        }
        this.generateCanonicalTree();
        this.findRingClosures();
        this.calculateEZBonds();
        StringBuilder builder = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            if (smilesAtom.parent == -1) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append('.');
                }
            }
            this.addAtomString(smilesAtom, builder, buffer);
        }
        return builder.toString();
    }

    private void generateCanonicalTree() {
        this.mAtomRank = this.mCanonizer.getFinalRank();
        this.mAtomUsed = new boolean[this.mMol.getAtoms()];
        this.mBondUsed = new boolean[this.mMol.getBonds()];
        this.mGraphAtomList = new ArrayList<SmilesAtom>();
        int atom = this.findUnusedStartAtom();
        while (atom != -1) {
            int graphIndex;
            this.addToGraph(new SmilesAtom(atom, -1, -1, false, false), graphIndex);
            if (this.mMol.getConnAtoms(atom) != 0) {
                this.addHighestRankingChain(graphIndex, false);
                for (graphIndex = this.mGraphAtomList.size(); graphIndex < this.mGraphAtomList.size() - 1; ++graphIndex) {
                    while (this.hasUnusedNeighborAtom(this.mGraphAtomList.get((int)graphIndex).atom)) {
                        this.addHighestRankingChain(graphIndex, true);
                    }
                }
            }
            atom = this.findUnusedStartAtom();
        }
        this.mSmilesIndex = new int[this.mMol.getAtoms()];
        int index = 0;
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            this.mSmilesIndex[smilesAtom.atom] = index++;
        }
    }

    private void findRingClosures() {
        int i;
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            int closureCount = 0;
            for (i = 0; i < this.mMol.getConnAtoms(smilesAtom.atom); ++i) {
                if (this.mBondUsed[this.mMol.getConnBond(smilesAtom.atom, i)]) continue;
                ++closureCount;
            }
            if (closureCount == 0) continue;
            smilesAtom.closureNeighbour = new int[closureCount];
            closureCount = 0;
            for (i = 0; i < this.mMol.getConnAtoms(smilesAtom.atom); ++i) {
                if (this.mBondUsed[this.mMol.getConnBond(smilesAtom.atom, i)]) continue;
                int neighbour = this.mMol.getConnAtom(smilesAtom.atom, i);
                smilesAtom.closureNeighbour[closureCount++] = this.mSmilesIndex[neighbour] << 16 | neighbour;
            }
            Arrays.sort(smilesAtom.closureNeighbour);
            for (i = 0; i < smilesAtom.closureNeighbour.length; ++i) {
                smilesAtom.closureNeighbour[i] = 0xFFFF & smilesAtom.closureNeighbour[i];
            }
        }
        boolean[] closureNumberUsed = new boolean[this.mMol.getBonds()];
        this.mClosureNumber = new int[this.mMol.getBonds()];
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            if (smilesAtom.closureNeighbour == null) continue;
            smilesAtom.closureOpens = new boolean[smilesAtom.closureNeighbour.length];
            for (i = 0; i < smilesAtom.closureNeighbour.length; ++i) {
                for (int j = 0; j < this.mMol.getConnAtoms(smilesAtom.atom); ++j) {
                    if (smilesAtom.closureNeighbour[i] != this.mMol.getConnAtom(smilesAtom.atom, j)) continue;
                    int bond = this.mMol.getConnBond(smilesAtom.atom, j);
                    if (!this.mBondUsed[bond]) {
                        this.mBondUsed[bond] = true;
                        smilesAtom.closureOpens[i] = true;
                        this.mClosureNumber[bond] = 1;
                        while (closureNumberUsed[this.mClosureNumber[bond]]) {
                            int n = bond;
                            this.mClosureNumber[n] = this.mClosureNumber[n] + 1;
                        }
                        closureNumberUsed[this.mClosureNumber[bond]] = true;
                        continue;
                    }
                    closureNumberUsed[this.mClosureNumber[bond]] = false;
                }
            }
        }
    }

    private void calculateEZBonds() {
        ArrayList<int[]> relativeBondParityList = new ArrayList<int[]>();
        for (SmilesAtom currentSA : this.mGraphAtomList) {
            int i;
            int connAtom;
            int ezBond;
            if (currentSA.parent == -1 || this.mMol.isBINAPChiralityBond(ezBond = this.mMol.getBond(currentSA.atom, currentSA.parent)) || this.mMol.isSmallRingBond(ezBond) || this.mMol.getBondParity(ezBond) != 1 && this.mMol.getBondParity(ezBond) != 2) continue;
            SmilesAtom parentSA = this.mGraphAtomList.get(this.mSmilesIndex[currentSA.parent]);
            int[] bondWithHalfParity = new int[this.mMol.getConnAtoms(currentSA.atom) + this.mMol.getConnAtoms(parentSA.atom) - 2];
            int halfParityIndex = 0;
            boolean parity = false;
            if (parentSA.parent != -1) {
                bondWithHalfParity[halfParityIndex++] = parentSA.bond;
            } else {
                int firstNeighbourIndex = -1;
                int secondNeighbourIndex = -1;
                int firstSmilesIndex = Integer.MAX_VALUE;
                for (int i2 = 0; i2 < this.mMol.getConnAtoms(parentSA.atom); ++i2) {
                    connAtom = this.mMol.getConnAtom(parentSA.atom, i2);
                    if (connAtom == currentSA.atom) continue;
                    if (firstNeighbourIndex == -1) {
                        firstNeighbourIndex = i2;
                        firstSmilesIndex = this.mSmilesIndex[connAtom];
                        continue;
                    }
                    if (firstSmilesIndex < this.mSmilesIndex[connAtom]) {
                        secondNeighbourIndex = i2;
                        continue;
                    }
                    secondNeighbourIndex = firstNeighbourIndex;
                    firstNeighbourIndex = i2;
                }
                if (secondNeighbourIndex == -1) {
                    int neighbourAtom = this.mMol.getConnAtom(parentSA.atom, firstNeighbourIndex);
                    int neighbourBond = this.mMol.getConnBond(parentSA.atom, firstNeighbourIndex);
                    bondWithHalfParity[halfParityIndex++] = neighbourBond | (this.isBondFromTo(parentSA.atom, neighbourAtom) ? 0x40000000 : 0);
                } else {
                    int connAtom1 = this.mMol.getConnAtom(parentSA.atom, firstNeighbourIndex);
                    int connBond1 = this.mMol.getConnBond(parentSA.atom, firstNeighbourIndex);
                    int connAtom2 = this.mMol.getConnAtom(parentSA.atom, secondNeighbourIndex);
                    int connBond2 = this.mMol.getConnBond(parentSA.atom, secondNeighbourIndex);
                    bondWithHalfParity[halfParityIndex++] = connBond1 | (this.isBondFromTo(parentSA.atom, connAtom1) ? 0x40000000 : 0);
                    bondWithHalfParity[halfParityIndex++] = connBond2 | (this.isBondFromTo(parentSA.atom, connAtom2) ? 0 : 0x40000000);
                }
            }
            if (this.mMol.getConnAtoms(parentSA.atom) == 3 && parentSA.parent != -1) {
                for (i = 0; i < this.mMol.getConnAtoms(parentSA.atom); ++i) {
                    int connAtom2 = this.mMol.getConnAtom(parentSA.atom, i);
                    if (connAtom2 == parentSA.parent || connAtom2 == currentSA.atom) continue;
                    int branchBond = this.mMol.getConnBond(parentSA.atom, i);
                    bondWithHalfParity[halfParityIndex++] = branchBond | (this.isBondFromTo(parentSA.atom, connAtom2) ? 0x40000000 : 0);
                    if (connAtom2 >= parentSA.parent) break;
                    parity = !parity;
                    break;
                }
            }
            if (this.mMol.getBondParity(ezBond) == 2) {
                parity = !parity;
            }
            for (i = 0; i < this.mMol.getConnAtoms(currentSA.atom); ++i) {
                int childAtom = this.mMol.getConnAtom(currentSA.atom, i);
                if (childAtom == currentSA.parent) continue;
                boolean halfParity2 = parity;
                if (this.mMol.getConnAtoms(currentSA.atom) == 3) {
                    for (int j = 0; j < this.mMol.getConnAtoms(currentSA.atom); ++j) {
                        connAtom = this.mMol.getConnAtom(currentSA.atom, j);
                        if (connAtom == currentSA.parent || connAtom == childAtom) continue;
                        if (connAtom >= childAtom) break;
                        halfParity2 = !halfParity2;
                        break;
                    }
                }
                if (this.mMol.isBondParityPseudo(ezBond)) {
                    int group = this.mCanonizer.getPseudoEZGroup(ezBond);
                    if (!this.mPseudoStereoGroupInitialized[group]) {
                        this.mPseudoStereoGroupInitialized[group] = true;
                        this.mPseudoStereoGroupInversion[group] = halfParity2;
                    }
                    if (this.mPseudoStereoGroupInversion[group]) {
                        halfParity2 = !halfParity2;
                    }
                }
                int childBond = this.mMol.getBond(currentSA.atom, childAtom);
                bondWithHalfParity[halfParityIndex++] = childBond | (halfParity2 ^ this.isBondFromTo(currentSA.atom, childAtom) ? 0 : 0x40000000);
            }
            relativeBondParityList.add(bondWithHalfParity);
        }
        this.mEZHalfParity = new int[this.mMol.getBonds()];
        if (relativeBondParityList.size() != 0) {
            this.addRelativeBondHalfParities((int[])relativeBondParityList.remove(0), false);
        }
        while (relativeBondParityList.size() != 0) {
            int startSize = relativeBondParityList.size();
            for (int i = relativeBondParityList.size() - 1; i >= 0; --i) {
                int[] bondWithHalfParity = (int[])relativeBondParityList.get(i);
                int overlapCount = 0;
                boolean inverted = false;
                boolean collides = false;
                for (int bwhp : bondWithHalfParity) {
                    int bond = bwhp & 0x3FFFFFFF;
                    if (this.mEZHalfParity[bond] == 0) continue;
                    boolean differs = (bwhp & 0x40000000) != 0 ^ this.mEZHalfParity[bond] == 2;
                    if (overlapCount == 0) {
                        inverted = differs;
                    } else if (inverted != differs) {
                        collides = true;
                    }
                    ++overlapCount;
                }
                if (overlapCount == 0) continue;
                bondWithHalfParity = (int[])relativeBondParityList.remove(i);
                if (collides) continue;
                this.addRelativeBondHalfParities(bondWithHalfParity, inverted);
            }
            if (startSize != relativeBondParityList.size()) continue;
            this.addRelativeBondHalfParities((int[])relativeBondParityList.remove(0), false);
        }
    }

    private void addRelativeBondHalfParities(int[] bondWithHalfParity, boolean inverted) {
        for (int bwhp : bondWithHalfParity) {
            this.mEZHalfParity[bwhp & 0x3FFFFFFF] = (bwhp & 0x40000000) != 0 ^ inverted ? 2 : 1;
        }
    }

    private boolean isBondFromTo(int atom1, int atom2) {
        SmilesAtom sa1 = this.mGraphAtomList.get(this.mSmilesIndex[atom1]);
        if (sa1.parent == atom2) {
            return false;
        }
        SmilesAtom sa2 = this.mGraphAtomList.get(this.mSmilesIndex[atom2]);
        if (sa2.parent == atom1) {
            return true;
        }
        return sa2.isOpeningClosureTo(atom1);
    }

    private int findUnusedStartAtom() {
        int startAtom = -1;
        int startRank = Integer.MAX_VALUE;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mAtomUsed[atom]) continue;
            int rank = this.mAtomRank[atom];
            if ((this.mMol.getAtomQueryFeatures(atom) & 0x20000000L) != 0L) {
                rank += 0x40000000;
            }
            rank = this.mMol.getConnAtoms(atom) == 0 ? (rank += 0x3F000000) : (rank += this.mMol.getConnAtoms(atom) << 24);
            if (startRank <= rank) continue;
            startRank = rank;
            startAtom = atom;
        }
        return startAtom;
    }

    private boolean hasUnusedNeighborAtom(int atom) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (this.mAtomUsed[this.mMol.getConnAtom(atom, i)]) continue;
            return true;
        }
        return false;
    }

    private void addHighestRankingChain(int graphIndex, boolean isSideChain) {
        boolean isFirst = true;
        int parent = this.mGraphAtomList.get((int)graphIndex).atom;
        int neighborIndex = this.getUnusedConnAtomIndex(parent);
        while (neighborIndex != -1) {
            int atom = this.mMol.getConnAtom(parent, neighborIndex);
            int bond = this.mMol.getConnBond(parent, neighborIndex);
            neighborIndex = this.getUnusedConnAtomIndex(atom);
            this.addToGraph(new SmilesAtom(atom, bond, parent, isSideChain && isFirst, isSideChain && neighborIndex == -1), ++graphIndex);
            parent = atom;
            isFirst = false;
        }
    }

    private int getUnusedConnAtomIndex(int atom) {
        int bestIndex = -1;
        int bestRank = -1;
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            int connAtom = this.mMol.getConnAtom(atom, i);
            int rank = (this.mMol.getConnBondOrder(atom, i) << 24) + this.mAtomRank[connAtom];
            if (this.mAtomUsed[connAtom] || bestIndex != -1 && bestRank >= rank) continue;
            bestIndex = i;
            bestRank = rank;
        }
        return bestIndex;
    }

    private void addToGraph(SmilesAtom smilesAtom, int listIndex) {
        this.mGraphAtomList.add(listIndex, smilesAtom);
        this.mAtomUsed[smilesAtom.atom] = true;
        if (smilesAtom.parent != -1) {
            this.mBondUsed[this.mMol.getBond((int)smilesAtom.atom, (int)smilesAtom.parent)] = true;
        }
    }

    private void addAtomString(SmilesAtom smilesAtom, StringBuilder builder, StringBuilder buffer) {
        boolean useBrackets;
        int charge;
        String label;
        int atom = smilesAtom.atom;
        int parent = smilesAtom.parent;
        boolean isAnyAtom = (this.mMol.getAtomQueryFeatures(atom) & 1L) != 0L;
        int[] atomList = this.mMol.getAtomList(atom);
        String string = atomList != null ? this.createMultiAtomLabel(atom, atomList, buffer) : (label = isAnyAtom ? "*" : this.mMol.getAtomLabel(atom));
        if (!isAnyAtom && atomList == null && this.mMol.isAromaticAtom(atom) && (this.mMode & 4) == 0 && (this.mMol.getAtomPi(atom) != 0 || this.mMol.getAtomAbnormalValence(atom) == -1 && this.mMol.getAtomRadical(atom) == 0)) {
            label = label.toLowerCase();
        }
        if (smilesAtom.isSideChainStart) {
            builder.append('(');
        }
        if (parent != -1) {
            this.appendBondOrderSymbol(this.mMol.getBond(smilesAtom.atom, smilesAtom.parent), smilesAtom.parent, builder);
        }
        if ((charge = this.mMol.getAtomCharge(atom)) == 0 && (this.mMode & 1) != 0) {
            long chargeFeatures = this.mMol.getAtomQueryFeatures(atom) & 0xE000000L;
            if (chargeFeatures == 0xC000000L) {
                charge = -1;
            } else if (chargeFeatures == 0x6000000L) {
                charge = 1;
            }
        }
        int isotop = this.mMol.getAtomMass(atom);
        int mapNo = (this.mMode & 2) != 0 ? this.mMol.getAtomMapNo(atom) : 0;
        String smartsFeatures = (this.mMode & 1) != 0 ? this.getAtomSMARTSFeatures(atom, buffer) : null;
        boolean bl = useBrackets = !isAnyAtom && !this.isOrganic(this.mMol.getAtomicNo(atom)) || atomList != null || this.qualifiesForAtomParity(atom) || this.mMol.isAromaticAtom(atom) && this.mMol.getAtomPi(atom) == 0 && (this.mMode & 4) == 0 || charge != 0 || isotop != 0 || mapNo != 0 || this.mMol.getAtomAbnormalValence(atom) != -1 || this.mMol.getAtomRadical(atom) != 0 || smartsFeatures != null;
        if (useBrackets) {
            builder.append('[');
        }
        if (isotop != 0) {
            builder.append(isotop);
        }
        builder.append(label);
        if (this.qualifiesForAtomParity(atom)) {
            builder.append(this.getAtomParitySymbol(atom, parent));
        }
        if ((this.mMode & 1) == 0 && useBrackets) {
            int hCount = this.mMol.getPlainHydrogens(atom);
            if (hCount == 1) {
                builder.append("H");
            } else if (hCount > 1) {
                builder.append("H" + hCount);
            }
        }
        if (charge != 0) {
            builder.append(charge > 0 ? (char)'+' : '-');
            if (Math.abs(charge) > 1) {
                builder.append(Math.abs(charge));
            }
        }
        if (smartsFeatures != null) {
            builder.append(smartsFeatures);
        }
        if (mapNo != 0) {
            builder.append(':');
            builder.append(mapNo);
        }
        if (useBrackets) {
            builder.append(']');
        }
        this.appendClosureBonds(smilesAtom, builder);
        if (smilesAtom.isSideChainEnd) {
            builder.append(')');
        }
    }

    private String createMultiAtomLabel(int atom, int[] atomicNo, StringBuilder buffer) {
        buffer.setLength(0);
        boolean isLowerCase = this.mMol.isAromaticAtom(atom) && (this.mMode & 4) == 0;
        for (int a : atomicNo) {
            if (buffer.length() != 0) {
                buffer.append(',');
            }
            String label = Molecule.cAtomLabel[a];
            buffer.append(isLowerCase ? label.toLowerCase() : label);
        }
        return buffer.toString();
    }

    private String getAtomSMARTSFeatures(int atom, StringBuilder buffer) {
        buffer.setLength(0);
        long queryFeatures = this.mMol.getAtomQueryFeatures(atom);
        int chargeFeatures = (int)((queryFeatures & 0xE000000L) >> 3);
        switch (chargeFeatures) {
            case 0x1400000: {
                buffer.append("+0");
                break;
            }
            case 0x1800000: {
                if (this.mMol.getAtomCharge(atom) != 0) break;
                buffer.append("-");
                break;
            }
            case 0xC00000: {
                if (this.mMol.getAtomCharge(atom) != 0) break;
                buffer.append("+");
            }
        }
        long aromState = queryFeatures & 6L;
        if (aromState == 2L) {
            buffer.append(";a");
        } else if (aromState == 4L) {
            buffer.append(";A");
        }
        long hydrogenQueryFeatures = queryFeatures & 0x780L;
        if (hydrogenQueryFeatures != 0L) {
            if (hydrogenQueryFeatures == 1792L) {
                buffer.append(";H0");
            } else if (hydrogenQueryFeatures == 1664L) {
                buffer.append(";H1");
            } else if (hydrogenQueryFeatures == 1408L) {
                buffer.append(";H2");
            } else if (hydrogenQueryFeatures == 896L) {
                buffer.append(";H3");
            } else if (hydrogenQueryFeatures == 128L) {
                buffer.append(";!H0");
            } else if (hydrogenQueryFeatures == 384L) {
                buffer.append(";!H0;!H1");
            } else if (hydrogenQueryFeatures == 1536L) {
                buffer.append(";!H2;!H3");
            } else if (hydrogenQueryFeatures == 1024L) {
                buffer.append(";!H3");
            }
        }
        int ringState = (int)((queryFeatures & 0x78L) >> 4);
        switch (ringState) {
            case 0: {
                buffer.append(";!R0");
                break;
            }
            case 1: {
                buffer.append(";!R1");
                break;
            }
            case 2: {
                buffer.append(";!R2");
                break;
            }
            case 4: {
                buffer.append(";!R3");
                break;
            }
            case 7: {
                buffer.append(";R0");
                break;
            }
            case 6: {
                buffer.append(";R1");
                break;
            }
            case 5: {
                buffer.append(";R2");
                break;
            }
            case 3: {
                buffer.append(";R3");
            }
        }
        long ringSize = (queryFeatures & 0x1C00000L) >> 22;
        if (ringSize != 0L) {
            buffer.append(";r" + ringSize);
        }
        int neighbourFeatures = (int)((queryFeatures & 0x3E0000L) >> 5);
        switch (neighbourFeatures) {
            case 118784: {
                buffer.append(";D1");
                break;
            }
            case 110592: {
                buffer.append(";D2");
                break;
            }
            case 94208: {
                buffer.append(";D3");
                break;
            }
            case 98304: {
                buffer.append(";!D3;!D4");
                break;
            }
            case 65536: {
                buffer.append(";!D4");
                break;
            }
            case 12288: {
                buffer.append(";!D0;!D1");
                break;
            }
            case 28672: {
                buffer.append(";!D0;!D1;!D2");
                break;
            }
            case 61440: {
                buffer.append(";!D0;!D1;!D2;!D3");
            }
        }
        if ((queryFeatures & 0x800L) != 0L) {
            buffer.append(";D" + this.mMol.getConnAtoms(atom));
        }
        if ((queryFeatures & 0x1000L) != 0L) {
            buffer.append(";!D" + this.mMol.getConnAtoms(atom));
        }
        return buffer.length() == 0 ? null : buffer.toString();
    }

    private boolean qualifiesForAtomParity(int atom) {
        return !(this.mMol.getAtomParity(atom) != 1 && this.mMol.getAtomParity(atom) != 2 || this.isSingleKnownStereoCenterInESRGroup(atom) || this.mMol.getAtomicNo(atom) == 7 && this.mMol.getAtomCharge(atom) <= 0);
    }

    private boolean isSingleKnownStereoCenterInESRGroup(int atom) {
        int type = this.mMol.getAtomESRType(atom) - 1;
        return type == -1 ? false : this.mKnownTHCountInESRGroup[type][this.mMol.getAtomESRGroup(atom)] <= 1;
    }

    private void appendClosureBonds(SmilesAtom smilesAtom, StringBuilder builder) {
        if (smilesAtom.closureNeighbour != null) {
            for (int i = 0; i < smilesAtom.closureNeighbour.length; ++i) {
                for (int j = 0; j < this.mMol.getConnAtoms(smilesAtom.atom); ++j) {
                    if (smilesAtom.closureNeighbour[i] != this.mMol.getConnAtom(smilesAtom.atom, j)) continue;
                    int bond = this.mMol.getConnBond(smilesAtom.atom, j);
                    if (!smilesAtom.closureOpens[i]) {
                        this.appendBondOrderSymbol(bond, smilesAtom.atom, builder);
                    }
                    if (this.mClosureNumber[bond] > 9) {
                        builder.append('%');
                    }
                    builder.append(this.mClosureNumber[bond]);
                }
            }
        }
    }

    private void appendBondOrderSymbol(int bond, int parentAtom, StringBuilder builder) {
        int bondTypes;
        int startLength = builder.length();
        if (this.mEZHalfParity[bond] != 0) {
            builder.append(this.mEZHalfParity[bond] == 1 ? (char)'/' : '\\');
        }
        if (this.mMode == 1 && (bondTypes = this.mMol.getBondQueryFeatures(31)) != 0) {
            if ((bondTypes & 1) != 0 && this.mEZHalfParity[bond] == 0) {
                builder.append('-');
            }
            if ((bondTypes & 2) != 0) {
                if (builder.length() != startLength) {
                    builder.append(',');
                }
                builder.append('=');
            }
            if ((bondTypes & 4) != 0) {
                if (builder.length() != startLength) {
                    builder.append(',');
                }
                builder.append('#');
            }
            if ((bondTypes & 0x40) != 0) {
                if (builder.length() != startLength) {
                    builder.append(',');
                }
                builder.append(':');
            }
            if ((bondTypes & 0x20) != 0) {
                if (builder.length() != startLength) {
                    builder.append(',');
                }
                builder.append(this.mMol.isMetalAtom(parentAtom) ? "<-" : "->");
            }
        }
        if (!(startLength != builder.length() || this.mMol.isAromaticBond(bond) && (this.mMode & 4) == 0)) {
            int bondType = this.mMol.getBondType(bond) & 0x67;
            if (bondType == 1) {
                if (this.mMol.isAromaticAtom(this.mMol.getBondAtom(0, bond)) && this.mMol.isAromaticAtom(this.mMol.getBondAtom(1, bond)) && (this.mMode & 4) == 0 && this.mEZHalfParity[bond] == 0) {
                    builder.append('-');
                }
            } else if (bondType == 2) {
                builder.append('=');
            } else if (bondType == 4) {
                builder.append('#');
            } else if (bondType == 64) {
                builder.append(':');
            } else if (bondType == 32) {
                builder.append(this.mMol.isMetalAtom(parentAtom) ? "<-" : "->");
            }
        }
        if (this.mMode == 1) {
            String gap = startLength == builder.length() ? "" : ";";
            int ringState = this.mMol.getBondQueryFeatures(bond) & 0x60;
            if (ringState == 64) {
                builder.append(gap + "@");
            } else if (ringState == 32) {
                builder.append(gap + "!@");
            }
        }
    }

    private String getAtomParitySymbol(int atom, int parent) {
        boolean inversion = false;
        if (this.mMol.getAtomPi(atom) != 0 && this.mMol.getConnAtoms(atom) == 2 && this.mMol.getConnBondOrder(atom, 0) == 2 && this.mMol.getConnBondOrder(atom, 1) == 2) {
            for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                int connAtom = this.mMol.getConnAtom(atom, i);
                int neighbours = 0;
                int[] neighbour = new int[3];
                for (int j = 0; j < this.mMol.getConnAtoms(connAtom); ++j) {
                    neighbour[neighbours] = this.mMol.getConnAtom(connAtom, j);
                    if (neighbour[neighbours] == atom) continue;
                    ++neighbours;
                }
                if (neighbours != 2 || !(this.mSmilesIndex[neighbour[0]] < this.mSmilesIndex[neighbour[1]] ^ neighbour[0] < neighbour[1])) continue;
                inversion = !inversion;
            }
        } else {
            int[] neighborAtom = new int[4];
            int[] neighborRank = new int[4];
            int index = 0;
            if (parent != -1) {
                neighborAtom[index] = parent;
                neighborRank[index++] = 8 * this.mSmilesIndex[parent];
            }
            if (this.mMol.getImplicitHydrogens(atom) != 0) {
                neighborAtom[index] = Integer.MAX_VALUE;
                neighborRank[index++] = 8 * this.mSmilesIndex[atom];
            } else if (this.mMol.getConnAtoms(atom) == 3) {
                neighborAtom[index] = Integer.MAX_VALUE;
                neighborRank[index++] = 8 * this.mSmilesIndex[atom];
            }
            for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                int connAtom = this.mMol.getConnAtom(atom, i);
                if (connAtom == parent) continue;
                neighborAtom[index] = connAtom;
                neighborRank[index++] = this.getSmilesRank(atom, i);
            }
            inversion = this.isInverseOrder(neighborAtom, neighborRank);
        }
        boolean isClockwise = this.mMol.getAtomParity(atom) == 1 ^ inversion;
        if (this.mMol.isAtomParityPseudo(atom)) {
            int group = this.mCanonizer.getPseudoTHGroup(atom);
            if (!this.mPseudoStereoGroupInitialized[group]) {
                this.mPseudoStereoGroupInitialized[group] = true;
                this.mPseudoStereoGroupInversion[group] = isClockwise;
            }
            if (this.mPseudoStereoGroupInversion[group]) {
                isClockwise = !isClockwise;
            }
        }
        return isClockwise ? "@@" : "@";
    }

    private boolean isInverseOrder(int[] neighborAtom, int[] neighborRank) {
        boolean inversion = false;
        for (int i = 1; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                if (neighborAtom[j] > neighborAtom[i]) {
                    boolean bl = inversion = !inversion;
                }
                if (neighborRank[j] <= neighborRank[i]) continue;
                inversion = !inversion;
            }
        }
        return inversion;
    }

    private int getSmilesRank(int atom, int neighbourIndex) {
        int bond = this.mMol.getConnBond(atom, neighbourIndex);
        int neighbour = this.mMol.getConnAtom(atom, neighbourIndex);
        if (this.mClosureNumber[bond] != 0) {
            int rank = 8 * this.mSmilesIndex[atom] + 1;
            int[] closureNeighbour = this.mGraphAtomList.get((int)this.mSmilesIndex[atom]).closureNeighbour;
            for (int i = 0; i < closureNeighbour.length && neighbour != closureNeighbour[i]; ++i) {
                ++rank;
            }
            return rank;
        }
        return 8 * this.mSmilesIndex[neighbour];
    }

    private boolean isOrganic(int atomicNo) {
        return atomicNo >= 5 && atomicNo <= 9 || atomicNo >= 15 && atomicNo <= 17 || atomicNo == 35 || atomicNo == 53;
    }
}

