/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import java.io.Serializable;
import java.util.ArrayList;

public class MarkushStructure
implements Serializable {
    static final long serialVersionUID = 537396501L;
    private static final int MAX_RGROUP_DEPTH = 5;
    private ArrayList<StereoMolecule> mCoreList = new ArrayList();
    private ArrayList<StereoMolecule> mRGroupList = new ArrayList();
    private StereoMolecule[][] mSubstituent;
    private int mCoreIndex;
    private int[] mSubstituentCount;
    private int[] mSubstituentIndex;
    private int[][] mCoreRGroup;
    private int[][][] mSubstituentRGroup;

    public MarkushStructure() {
    }

    public MarkushStructure(StereoMolecule[] fragment, int coreCount) {
        this();
        if (fragment != null) {
            int i;
            for (i = 0; i < coreCount; ++i) {
                this.mCoreList.add(fragment[i]);
            }
            for (i = coreCount; i < fragment.length; ++i) {
                this.mRGroupList.add(fragment[i]);
            }
        }
    }

    public StereoMolecule getCoreStructure(int no) {
        return this.mCoreList.get(no);
    }

    public int getCoreCount() {
        return this.mCoreList.size();
    }

    public StereoMolecule getRGroup(int no) {
        return this.mRGroupList.get(no);
    }

    public int getRGroupCount() {
        return this.mRGroupList.size();
    }

    public void addCore(StereoMolecule core) {
        this.mCoreList.add(core);
    }

    public void addRGroup(StereoMolecule substituents) {
        this.mRGroupList.add(substituents);
    }

    public String validate() throws Exception {
        int j;
        if (this.mCoreList.size() == 0) {
            throw new Exception("You didn't define a core structure.");
        }
        int rGroupFlags = 0;
        int maxRGroup = -1;
        int rGroupCount = 0;
        this.mCoreRGroup = new int[this.mCoreList.size()][];
        for (int i = 0; i < this.mCoreList.size() + this.mRGroupList.size(); ++i) {
            StereoMolecule mol = i < this.mCoreList.size() ? this.mCoreList.get(i) : this.mRGroupList.get(i - this.mCoreList.size());
            mol.ensureHelperArrays(1);
            ArrayList<Integer> rGroupList = new ArrayList<Integer>();
            for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
                int rGroupIndex = this.getRGroupIndex(mol.getAtomicNo(atom));
                if (rGroupIndex == -1) continue;
                if (mol.getConnAtoms(atom) != 1) {
                    throw new Exception("R" + (rGroupIndex + 1) + " has multiple neighbours.");
                }
                maxRGroup = Math.max(maxRGroup, rGroupIndex);
                int flag = 1 << rGroupIndex;
                if ((rGroupFlags & flag) == 0) {
                    rGroupFlags |= flag;
                    ++rGroupCount;
                }
                if (i >= this.mCoreList.size()) continue;
                rGroupList.add(new Integer(rGroupIndex));
            }
            if (i >= this.mCoreList.size()) continue;
            this.mCoreRGroup[i] = new int[rGroupList.size()];
            for (j = 0; j < rGroupList.size(); ++j) {
                this.mCoreRGroup[i][j] = (Integer)rGroupList.get(j);
            }
        }
        if (maxRGroup >= this.mRGroupList.size()) {
            throw new Exception("Not all used R-groups are defined.");
        }
        String warning = null;
        if (rGroupCount < this.mRGroupList.size()) {
            warning = "One or more defined R-group(s) are unreferenced.";
        }
        this.mSubstituent = new StereoMolecule[this.mRGroupList.size()][];
        this.mSubstituentRGroup = new int[this.mRGroupList.size()][][];
        for (int i = 0; i < this.mRGroupList.size(); ++i) {
            this.mSubstituent[i] = this.mRGroupList.get(i).getFragments();
            this.mSubstituentRGroup[i] = new int[this.mSubstituent[i].length][];
            for (int j2 = 0; j2 < this.mSubstituent[i].length; ++j2) {
                this.mSubstituent[i][j2].ensureHelperArrays(1);
                boolean attachmentPointFound = false;
                ArrayList<Integer> rGroupList = new ArrayList<Integer>();
                for (int atom = 0; atom < this.mSubstituent[i][j2].getAllAtoms(); ++atom) {
                    if (this.mSubstituent[i][j2].getAtomicNo(atom) == 0) {
                        if (attachmentPointFound) {
                            throw new Exception("Variation " + (j2 + 1) + " of R" + (i + 1) + " has multiple attachment points.");
                        }
                        if (this.mSubstituent[i][j2].getConnAtoms(atom) != 1) {
                            throw new Exception("The attachment point of variation " + (j2 + 1) + " of R" + (i + 1) + " has multiple neighbours.");
                        }
                        attachmentPointFound = true;
                        continue;
                    }
                    int rGroupIndex = this.getRGroupIndex(this.mSubstituent[i][j2].getAtomicNo(atom));
                    if (rGroupIndex == -1) continue;
                    rGroupList.add(new Integer(rGroupIndex));
                }
                if (!attachmentPointFound) {
                    throw new Exception("Variation " + (j2 + 1) + " of R" + (i + 1) + " has no attachment point ('?'-atom).");
                }
                this.mSubstituentRGroup[i][j2] = new int[rGroupList.size()];
                for (int k = 0; k < rGroupList.size(); ++k) {
                    this.mSubstituentRGroup[i][j2][k] = (Integer)rGroupList.get(k);
                }
            }
        }
        int rGroupReferenced = 0;
        for (int i = 0; i < this.mCoreRGroup.length; ++i) {
            for (j = 0; j < this.mCoreRGroup[i].length; ++j) {
                rGroupReferenced |= 1 << this.mCoreRGroup[i][j];
            }
        }
        int rGroupReferencedPreviousLevel = rGroupReferenced;
        for (int level = 1; level <= 5; ++level) {
            int rGroupReferencedCurrentLevel = 0;
            for (int rGroup = 0; rGroup <= maxRGroup; ++rGroup) {
                if ((rGroupReferencedPreviousLevel & 1 << rGroup) == 0) continue;
                for (int i = 0; i < this.mSubstituentRGroup[rGroup].length; ++i) {
                    for (int j3 = 0; j3 < this.mSubstituentRGroup[rGroup][i].length; ++j3) {
                        rGroupReferencedCurrentLevel |= 1 << this.mSubstituentRGroup[rGroup][i][j3];
                        rGroupReferenced |= 1 << this.mSubstituentRGroup[rGroup][i][j3];
                    }
                }
            }
            if (rGroupReferencedCurrentLevel == 0) break;
            if (level == 5) {
                throw new Exception("R-Groups are recursively definined or maximum depth of indirection (5) exceeded");
            }
            rGroupReferencedPreviousLevel = rGroupReferencedCurrentLevel;
        }
        this.mSubstituentCount = new int[this.mRGroupList.size()];
        for (int rGroup = 0; rGroup < this.mRGroupList.size(); ++rGroup) {
            this.mSubstituentCount[rGroup] = (rGroupReferenced & 1 << rGroup) == 0 ? 0 : this.mSubstituent[rGroup].length;
        }
        this.mSubstituentIndex = new int[this.mRGroupList.size()];
        this.mCoreIndex = 0;
        return warning;
    }

    public StereoMolecule getNextEnumeration() {
        if (this.mCoreIndex == this.mCoreList.size()) {
            return null;
        }
        StereoMolecule mol = this.createCurrentEnumeration();
        boolean incrementCoreIndex = true;
        for (int rGroup = 0; rGroup < this.mRGroupList.size(); ++rGroup) {
            if (this.mSubstituentCount[rGroup] <= 1) continue;
            if (this.mSubstituentIndex[rGroup] + 1 < this.mSubstituentCount[rGroup]) {
                int n = rGroup;
                this.mSubstituentIndex[n] = this.mSubstituentIndex[n] + 1;
                incrementCoreIndex = false;
                break;
            }
            this.mSubstituentIndex[rGroup] = 0;
        }
        if (incrementCoreIndex) {
            ++this.mCoreIndex;
        }
        return mol;
    }

    private int getRGroupIndex(int atomicNo) {
        if (atomicNo < 129 || atomicNo > 144) {
            return -1;
        }
        return atomicNo >= 142 ? atomicNo - 142 : atomicNo - 126;
    }

    private StereoMolecule createCurrentEnumeration() {
        int atom;
        StereoMolecule mol = new StereoMolecule();
        mol.addMolecule(this.mCoreList.get(this.mCoreIndex));
        for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
            int rGroup = this.getRGroupIndex(mol.getAtomicNo(atom));
            if (rGroup == -1) continue;
            mol.addSubstituent(this.mSubstituent[rGroup][this.mSubstituentIndex[rGroup]], this.getAttachmentAtom(mol, atom));
        }
        for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
            mol.setAtomSelection(atom, this.getRGroupIndex(mol.getAtomicNo(atom)) != -1);
        }
        mol.deleteSelectedAtoms();
        int coreAtoms = this.mCoreList.get(this.mCoreIndex).getAllAtoms() - this.mCoreRGroup[this.mCoreIndex].length;
        for (int atom2 = 0; atom2 < coreAtoms; ++atom2) {
            mol.setAtomMarker(atom2, true);
        }
        new CoordinateInventor(10).invent(mol);
        return mol;
    }

    private int getAttachmentAtom(Molecule mol, int atom) {
        for (int bond = 0; bond < mol.getAllBonds(); ++bond) {
            if (mol.getBondAtom(0, bond) == atom) {
                return mol.getBondAtom(1, bond);
            }
            if (mol.getBondAtom(1, bond) != atom) continue;
            return mol.getBondAtom(0, bond);
        }
        return -1;
    }
}

