/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

class MesoFragmentMembers
implements Comparable<MesoFragmentMembers> {
    public boolean[] isMember;
    public int[] memberAtom;

    public MesoFragmentMembers(int atoms) {
        this.isMember = new boolean[atoms];
    }

    public void add(int atom) {
        this.isMember[atom] = true;
    }

    private void consolidate() {
        int count = 0;
        for (boolean is : this.isMember) {
            if (!is) continue;
            ++count;
        }
        this.memberAtom = new int[count];
        count = 0;
        for (int atom = 0; atom < this.isMember.length; ++atom) {
            if (!this.isMember[atom]) continue;
            this.memberAtom[count++] = atom;
        }
    }

    public boolean hasStereoCenters(boolean[] isStereoCenter) {
        this.consolidate();
        for (int j = 0; j < this.memberAtom.length; ++j) {
            if (!isStereoCenter[this.memberAtom[j]]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(MesoFragmentMembers members) {
        if (this.memberAtom.length != members.memberAtom.length) {
            return this.memberAtom.length < members.memberAtom.length ? -1 : 1;
        }
        for (int i = 0; i < this.memberAtom.length; ++i) {
            if (this.memberAtom[i] == members.memberAtom[i]) continue;
            return this.memberAtom[i] < members.memberAtom[i] ? -1 : 1;
        }
        return 0;
    }
}

