/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Coordinates;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class Molecule
implements Serializable {
    static final long serialVersionUID = 539100439L;
    public static final int cMaxAtomicNo = 190;
    protected static final int cAtomFlagsParity = 3;
    public static final int cAtomParityNone = 0;
    public static final int cAtomParity1 = 1;
    public static final int cAtomParity2 = 2;
    public static final int cAtomParityUnknown = 3;
    public static final int cAtomParityIsPseudo = 4;
    protected static final int cAtomFlagSmallRing = 8;
    public static final int cAtomRadicalState = 48;
    public static final int cAtomRadicalStateShift = 4;
    public static final int cAtomRadicalStateNone = 0;
    public static final int cAtomRadicalStateS = 16;
    public static final int cAtomRadicalStateD = 32;
    public static final int cAtomRadicalStateT = 48;
    private static final int cAtomFlagsColor = 448;
    public static final int cAtomColorNone = 0;
    public static final int cAtomColorBlue = 64;
    public static final int cAtomColorRed = 128;
    public static final int cAtomColorGreen = 192;
    public static final int cAtomColorMagenta = 256;
    public static final int cAtomColorOrange = 320;
    public static final int cAtomColorDarkGreen = 384;
    public static final int cAtomColorDarkRed = 448;
    private static final int cAtomFlagSelected = 512;
    protected static final int cAtomFlagsHelper2 = 31752;
    protected static final int cAtomFlagsHelper3 = 134447111;
    protected static final int cAtomFlagsHelper = 134478863;
    protected static final int cAtomFlagsRingBonds = 3072;
    protected static final int cAtomFlags2RingBonds = 1024;
    protected static final int cAtomFlags3RingBonds = 2048;
    protected static final int cAtomFlags4RingBonds = 3072;
    protected static final int cAtomFlagAromatic = 4096;
    protected static final int cAtomFlagAllylic = 8192;
    protected static final int cAtomFlagStabilized = 16384;
    private static final int cAtomFlagsCIPParity = 98304;
    private static final int cAtomFlagsCIPParityShift = 15;
    public static final int cAtomCIPParityNone = 0;
    public static final int cAtomCIPParityRorM = 1;
    public static final int cAtomCIPParitySorP = 2;
    public static final int cAtomCIPParityProblem = 3;
    protected static final int cAtomFlagStereoProblem = 131072;
    protected static final int cAtomFlagMarked = 262144;
    public static final int cESRTypeAbs = 0;
    public static final int cESRTypeAnd = 1;
    public static final int cESRTypeOr = 2;
    public static final int cESRMaxGroups = 32;
    public static final int cESRGroupBits = 5;
    protected static final int cAtomFlagsESR = 66584576;
    private static final int cAtomFlagsESRType = 0x180000;
    private static final int cAtomFlagsESRTypeShift = 19;
    private static final int cAtomFlagsESRGroup = 0x3E00000;
    private static final int cAtomFlagsESRGroupShift = 21;
    protected static final int cAtomFlagConfigurationUnknown = 0x4000000;
    private static final int cAtomFlagIsStereoCenter = 0x8000000;
    protected static final int cAtomFlagsValence = -268435456;
    private static final int cAtomFlagsValenceShift = 28;
    public static final int cAtomQFNoOfBits = 39;
    public static final int cAtomQFAromStateBits = 2;
    public static final int cAtomQFAromStateShift = 1;
    public static final int cAtomQFRingStateBits = 4;
    public static final int cAtomQFRingStateShift = 3;
    public static final int cAtomQFHydrogenBits = 4;
    public static final int cAtomQFHydrogenShift = 7;
    public static final int cAtomQFPiElectronBits = 3;
    public static final int cAtomQFPiElectronShift = 14;
    public static final int cAtomQFNeighbourBits = 5;
    public static final int cAtomQFNeighbourShift = 17;
    public static final int cAtomQFSmallRingSizeBits = 3;
    public static final int cAtomQFSmallRingSizeShift = 22;
    public static final int cAtomQFChargeBits = 3;
    public static final int cAtomQFChargeShift = 25;
    public static final int cAtomQFRxnParityBits = 2;
    public static final int cAtomQFRxnParityShift = 30;
    public static final int cAtomQFNewRingSizeBits = 7;
    public static final int cAtomQFNewRingSizeShift = 32;
    public static final long cAtomQFSimpleFeatures = 239060990L;
    public static final long cAtomQFNarrowing = 239060990L;
    public static final long cAtomQFAny = 1L;
    public static final long cAtomQFAromState = 6L;
    public static final long cAtomQFAromatic = 2L;
    public static final long cAtomQFNotAromatic = 4L;
    public static final long cAtomQFRingState = 120L;
    public static final long cAtomQFNotChain = 8L;
    public static final long cAtomQFNot2RingBonds = 16L;
    public static final long cAtomQFNot3RingBonds = 32L;
    public static final long cAtomQFNot4RingBonds = 64L;
    public static final long cAtomQFHydrogen = 1920L;
    public static final long cAtomQFNot0Hydrogen = 128L;
    public static final long cAtomQFNot1Hydrogen = 256L;
    public static final long cAtomQFNot2Hydrogen = 512L;
    public static final long cAtomQFNot3Hydrogen = 1024L;
    public static final long cAtomQFNoMoreNeighbours = 2048L;
    public static final long cAtomQFMoreNeighbours = 4096L;
    public static final long cAtomQFMatchStereo = 8192L;
    public static final long cAtomQFPiElectrons = 114688L;
    public static final long cAtomQFNot0PiElectrons = 16384L;
    public static final long cAtomQFNot1PiElectron = 32768L;
    public static final long cAtomQFNot2PiElectrons = 65536L;
    public static final long cAtomQFNeighbours = 0x3E0000L;
    public static final long cAtomQFNot0Neighbours = 131072L;
    public static final long cAtomQFNot1Neighbour = 262144L;
    public static final long cAtomQFNot2Neighbours = 524288L;
    public static final long cAtomQFNot3Neighbours = 0x100000L;
    public static final long cAtomQFNot4Neighbours = 0x200000L;
    public static final long cAtomQFSmallRingSize = 0x1C00000L;
    public static final long cAtomQFCharge = 0xE000000L;
    public static final long cAtomQFNotChargeNeg = 0x2000000L;
    public static final long cAtomQFNotCharge0 = 0x4000000L;
    public static final long cAtomQFNotChargePos = 0x8000000L;
    public static final long cAtomQFFlatNitrogen = 0x10000000L;
    public static final long cAtomQFExcludeGroup = 0x20000000L;
    public static final long cAtomQFRxnParityHint = -1073741824L;
    public static final long cAtomQFRxnParityRetain = 0x40000000L;
    public static final long cAtomQFRxnParityInvert = Integer.MIN_VALUE;
    public static final long cAtomQFRxnParityRacemize = -1073741824L;
    public static final long cAtomQFNewRingSize = 0x7F00000000L;
    public static final long cAtomQFRingSize0 = 0x100000000L;
    public static final long cAtomQFRingSize3 = 0x200000000L;
    public static final long cAtomQFRingSize4 = 0x400000000L;
    public static final long cAtomQFRingSize5 = 0x800000000L;
    public static final long cAtomQFRingSize6 = 0x1000000000L;
    public static final long cAtomQFRingSize7 = 0x2000000000L;
    public static final long cAtomQFRingSizeLarge = 0x4000000000L;
    public static final int cBondTypeSingle = 1;
    public static final int cBondTypeDouble = 2;
    public static final int cBondTypeTriple = 4;
    public static final int cBondTypeDown = 9;
    public static final int cBondTypeUp = 17;
    public static final int cBondTypeCross = 26;
    public static final int cBondTypeMetalLigand = 32;
    public static final int cBondTypeDelocalized = 64;
    public static final int cBondTypeDeleted = 128;
    public static final int cBondTypeIncreaseOrder = 127;
    protected static final int cBondTypeMaskSimple = 103;
    protected static final int cBondTypeMaskStereo = 24;
    protected static final int cBondFlagsHelper2 = 960;
    protected static final int cBondFlagsHelper3 = 63;
    protected static final int cBondFlagsParity = 3;
    public static final int cBondParityNone = 0;
    public static final int cBondParityEor1 = 1;
    public static final int cBondParityZor2 = 2;
    public static final int cBondParityUnknown = 3;
    private static final int cBondParityIsPseudo = 4;
    private static final int cBondFlagsCIPParity = 48;
    protected static final int cBondFlagsCIPParityShift = 4;
    public static final int cBondCIPParityNone = 0;
    public static final int cBondCIPParityEorP = 1;
    public static final int cBondCIPParityZorM = 2;
    public static final int cBondCIPParityProblem = 3;
    protected static final int cBondFlagRing = 64;
    protected static final int cBondFlagSmallRing = 128;
    protected static final int cBondFlagAromatic = 256;
    protected static final int cBondFlagDelocalized = 512;
    protected static final int cBondFlagsESR = 130048;
    private static final int cBondFlagsESRType = 3072;
    private static final int cBondFlagsESRTypeShift = 10;
    private static final int cBondFlagsESRGroup = 126976;
    private static final int cBondFlagsESRGroupShift = 12;
    private static final int cBondFlagBGHilited = 131072;
    private static final int cBondFlagFGHilited = 262144;
    private static final int cBondParityUnknownOrNone = 0x1000000;
    public static final int cBondQFNoOfBits = 21;
    public static final int cBondQFBondTypesBits = 5;
    public static final int cBondQFBondTypesShift = 0;
    public static final int cBondQFRingStateBits = 2;
    public static final int cBondQFRingStateShift = 5;
    public static final int cBondQFBridgeBits = 8;
    public static final int cBondQFBridgeShift = 7;
    public static final int cBondQFBridgeMinBits = 4;
    public static final int cBondQFBridgeMinShift = 7;
    public static final int cBondQFBridgeSpanBits = 4;
    public static final int cBondQFBridgeSpanShift = 11;
    public static final int cBondQFRingSizeBits = 3;
    public static final int cBondQFRingSizeShift = 15;
    public static final int cBondQFAromStateBits = 2;
    public static final int cBondQFAromStateShift = 19;
    public static final int cBondQFAllFeatures = 0x1FFFFF;
    public static final int cBondQFSimpleFeatures = 1572991;
    public static final int cBondQFNarrowing = 1572960;
    public static final int cBondQFBondTypes = 31;
    public static final int cBondQFSingle = 1;
    public static final int cBondQFDouble = 2;
    public static final int cBondQFTriple = 4;
    public static final int cBondQFDelocalized = 8;
    public static final int cBondQFMetalLigand = 16;
    public static final int cBondQFRingState = 96;
    public static final int cBondQFNotRing = 32;
    public static final int cBondQFRing = 64;
    public static final int cBondQFBridge = 32640;
    public static final int cBondQFBridgeMin = 1920;
    public static final int cBondQFBridgeSpan = 30720;
    public static final int cBondQFRingSize = 229376;
    public static final int cBondQFMatchStereo = 262144;
    public static final int cBondQFAromState = 0x180000;
    public static final int cBondQFAromatic = 524288;
    public static final int cBondQFNotAromatic = 0x100000;
    public static final int cHelperNone = 0;
    public static final int cHelperBitNeighbours = 1;
    public static final int cHelperBitRingsSimple = 2;
    public static final int cHelperBitRings = 4;
    public static final int cHelperBitParities = 8;
    public static final int cHelperBitCIP = 16;
    public static final int cHelperBitSymmetrySimple = 32;
    public static final int cHelperBitSymmetryDiastereotopic = 64;
    public static final int cHelperBitSymmetryEnantiotopic = 128;
    public static final int cHelperBitIncludeNitrogenParities = 256;
    public static final int cHelperBitsStereo = 504;
    public static final int cHelperNeighbours = 1;
    public static final int cHelperRingsSimple = 3;
    public static final int cHelperRings = 7;
    public static final int cHelperParities = 15;
    public static final int cHelperCIP = 31;
    public static final int cHelperSymmetrySimple = 63;
    public static final int cHelperSymmetryDiastereotopic = 95;
    public static final int cHelperSymmetryEnantiotopic = 159;
    public static final int cChiralityIsomerCountMask = 65535;
    public static final int cChiralityUnknown = 0;
    public static final int cChiralityNotChiral = 65536;
    public static final int cChiralityMeso = 131072;
    public static final int cChiralityRacemic = 196608;
    public static final int cChiralityKnownEnantiomer = 262144;
    public static final int cChiralityUnknownEnantiomer = 327680;
    public static final int cChiralityEpimers = 393216;
    public static final int cChiralityDiastereomers = 458752;
    private static final double cDefaultAVBL = 24.0;
    private static double sDefaultAVBL = 24.0;
    public static final int cMoleculeColorDefault = 0;
    public static final int cMoleculeColorNeutral = 1;
    public static final String[] cAtomLabel = new String[]{"?", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15", "R16", "R1", "R2", "R3", "A", "A1", "A2", "A3", "??", "??", "D", "T", "X", "R", "H2", "H+", "Nnn", "HYD", "Pol", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "Ala", "Arg", "Asn", "Asp", "Cys", "Gln", "Glu", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val"};
    public static final short[] cRoundedMass = new short[]{0, 1, 4, 7, 9, 11, 12, 14, 16, 19, 20, 23, 24, 27, 28, 31, 32, 35, 40, 39, 40, 45, 48, 51, 52, 55, 56, 59, 58, 63, 64, 69, 74, 75, 80, 79, 84, 85, 88, 89, 90, 93, 98, 0, 102, 103, 106, 107, 114, 115, 120, 121, 130, 127, 132, 133, 138, 139, 140, 141, 142, 0, 152, 153, 158, 159, 164, 165, 166, 169, 174, 175, 180, 181, 184, 187, 192, 193, 195, 197, 202, 205, 208, 209, 209, 210, 222, 223, 226, 227, 232, 231, 238, 237, 244, 243, 247, 247, 251, 252, 257, 258, 259, 262, 267, 268, 271, 270, 277, 276, 281, 281, 283, 285, 289, 289, 293, 294, 294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 156, 114, 115, 103, 128, 129, 57, 137, 113, 113, 128, 131, 147, 97, 87, 101, 186, 163, 99};
    public static final int cDefaultAtomValence = 6;
    private static final byte[] cDefaultAtomValences = new byte[]{6};
    private static final byte[] cAminoAcidValences = new byte[]{2};
    public static final byte[][] cAtomValence = new byte[][]{null, {1}, {0}, {1}, {2}, {3}, {4}, {3}, {2}, {1}, {0}, {1}, {2}, {3}, {4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}, {0}, {1}, {2}, null, null, null, null, null, null, null, null, null, null, {2, 3}, {2, 4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}, {0, 2}, {1}, {2}, null, null, null, null, null, null, null, null, null, null, {1, 2, 3}, {2, 4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}, {0, 2, 4, 6}, {1}, {2}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {2}, {2}, {2}, {2}, {3}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}};
    public static final byte[][] cCommonOxidationState = new byte[][]{null, {1}, null, {1}, {2}, null, null, {-3}, {-2}, {-1}, null, {1}, {2}, {3}, null, {-3}, {-2}, {-1}, null, {1}, {2}, {3}, {2, 3, 4}, {2, 3, 4, 5}, {2, 3, 6}, {2, 3, 4, 7}, {2, 3}, {2, 3}, {2, 3}, {1, 2}, {2}, {3}, {2, 4}, {-3, 3, 5}, {-2}, {-1}, null, {1}, {2}, {3}, {4}, {3, 5}, {6}, {4, 6, 7}, {3}, {3}, {2, 4}, {1}, {2}, {3}, {2, 4}, {-3, 3, 5}, {-2, 4, 6}, {-1}, null, {1}, {2}, {3}, {3, 4}, {3}, {3}, {3}, {2, 3}, {2, 3}, {3}, {3}, {3}, {3}, {3}, {3}, {2, 3}, {3}, {4}, {5}, {6}, {4, 6, 7}, {3, 4}, {3, 4}, {2, 4}, {1, 3}, {1, 2}, {1, 3}, {2, 4}, {3, 5}, {-2, 2, 4}, {-1, 1}, null, {1}, {2}, {3}, {4}, {4, 5}, {3, 4, 5, 6}, {3, 4, 5, 6}, {3, 4, 5, 6}, {3, 4, 5, 6}, {3}, {3, 4}, {3}, {3}, {3}, {2, 3}, {2, 3}, {3}};
    protected transient int mMaxAtoms;
    protected transient int mMaxBonds;
    protected transient int mValidHelperArrays;
    protected transient int mAllAtoms;
    protected transient int mAllBonds;
    protected transient int[] mAtomicNo;
    protected transient int[] mAtomCharge;
    protected transient int[] mAtomMapNo;
    protected transient int[] mAtomMass;
    protected transient int[] mAtomFlags;
    protected transient long[] mAtomQueryFeatures;
    protected transient int[][] mBondAtom;
    protected transient int[] mBondType;
    protected transient int[] mBondFlags;
    protected transient int[] mBondQueryFeatures;
    protected transient Coordinates[] mCoordinates;
    protected transient boolean mIsFragment;
    protected transient boolean mIsRacemate;
    protected transient boolean mProtectHydrogen;
    protected transient int mChirality;
    protected transient int[][] mAtomList;
    protected transient byte[][] mAtomCustomLabel;
    private transient int mMoleculeColor;
    private transient double mZoomRotationX;
    private transient double mZoomRotationY;
    private transient double[] mOriginalAngle;
    private transient double[] mOriginalDistance;
    private transient String mName;
    private transient Object mUserData;

    public static int getAtomicNoFromLabel(String atomLabel) {
        for (int i = 1; i < cAtomLabel.length; ++i) {
            if (!atomLabel.equalsIgnoreCase(cAtomLabel[i])) continue;
            return i;
        }
        return 0;
    }

    public static byte[] getAllowedValences(int atomicNo) {
        return atomicNo >= 0 && atomicNo < cAtomValence.length && cAtomValence[atomicNo] != null ? cAtomValence[atomicNo] : (atomicNo >= 171 && atomicNo <= 190 ? cAminoAcidValences : cDefaultAtomValences);
    }

    public static double getAngle(double x1, double y1, double x2, double y2) {
        double angle;
        double xdiff = x2 - x1;
        double ydiff = y2 - y1;
        if (ydiff != 0.0) {
            angle = Math.atan(xdiff / ydiff);
            if (ydiff < 0.0) {
                angle = xdiff < 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
            }
        } else {
            angle = xdiff > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return angle;
    }

    public static double getAngleDif(double angle1, double angle2) {
        double angleDif;
        for (angleDif = angle1 - angle2; angleDif < -Math.PI; angleDif += Math.PI * 2) {
        }
        while (angleDif > Math.PI) {
            angleDif -= Math.PI * 2;
        }
        return angleDif;
    }

    public Molecule() {
        this.mMaxBonds = 256;
        this.mMaxAtoms = 256;
        this.init();
    }

    public Molecule(int maxAtoms, int maxBonds) {
        this.mMaxAtoms = Math.max(1, maxAtoms);
        this.mMaxBonds = Math.max(1, maxBonds);
        this.init();
    }

    private void init() {
        this.mValidHelperArrays = 0;
        this.mAtomicNo = new int[this.mMaxAtoms];
        this.mAtomCharge = new int[this.mMaxAtoms];
        this.mAtomMapNo = new int[this.mMaxAtoms];
        this.mCoordinates = new Coordinates[this.mMaxAtoms];
        for (int i = 0; i < this.mMaxAtoms; ++i) {
            this.mCoordinates[i] = new Coordinates();
        }
        this.mAtomMass = new int[this.mMaxAtoms];
        this.mAtomFlags = new int[this.mMaxAtoms];
        this.mAtomQueryFeatures = new long[this.mMaxAtoms];
        this.mAtomList = null;
        this.mAtomCustomLabel = null;
        this.mBondAtom = new int[2][this.mMaxBonds];
        this.mBondType = new int[this.mMaxBonds];
        this.mBondFlags = new int[this.mMaxBonds];
        this.mBondQueryFeatures = new int[this.mMaxBonds];
    }

    public int addAtom(double x, double y) {
        return this.addAtom(x, y, 0.0);
    }

    public int addAtom(double x, double y, double z) {
        int atom = this.addAtom(6);
        this.mCoordinates[atom].set(x, y, z);
        return atom;
    }

    public int addAtom(String atomLabel) {
        int atomicNo = Molecule.getAtomicNoFromLabel(atomLabel);
        return atomicNo == 0 ? -1 : this.addAtom(atomicNo);
    }

    public int addAtom(int atomicNo) {
        if (this.mAllAtoms >= this.mMaxAtoms) {
            this.setMaxAtoms(this.mMaxAtoms * 2);
        }
        this.mAtomicNo[this.mAllAtoms] = 0;
        this.setAtomicNo(this.mAllAtoms, atomicNo);
        this.mAtomCharge[this.mAllAtoms] = 0;
        this.mAtomFlags[this.mAllAtoms] = 0;
        this.mAtomQueryFeatures[this.mAllAtoms] = 0L;
        this.mAtomMapNo[this.mAllAtoms] = 0;
        this.mCoordinates[this.mAllAtoms].set(0.0, 0.0, 0.0);
        if (this.mAtomList != null) {
            this.mAtomList[this.mAllAtoms] = null;
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel[this.mAllAtoms] = null;
        }
        this.mValidHelperArrays = 0;
        return this.mAllAtoms++;
    }

    public int suggestBondType(int atom1, int atom2) {
        return this.isMetalAtom(atom1) || this.isMetalAtom(atom2) ? 32 : 1;
    }

    public int addBond(int atom1, int atom2) {
        return this.addBond(atom1, atom2, this.suggestBondType(atom1, atom2));
    }

    public int addBond(int atom1, int atom2, int type) {
        if (atom1 == atom2) {
            return -1;
        }
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            if ((this.mBondAtom[0][bnd] != atom1 || this.mBondAtom[1][bnd] != atom2) && (this.mBondAtom[0][bnd] != atom2 || this.mBondAtom[1][bnd] != atom1)) continue;
            if (this.mBondType[bnd] < type) {
                this.mBondType[bnd] = type;
            }
            return bnd;
        }
        if (this.mAllBonds >= this.mMaxBonds) {
            this.setMaxBonds(this.mMaxBonds * 2);
        }
        this.mBondAtom[0][this.mAllBonds] = atom1;
        this.mBondAtom[1][this.mAllBonds] = atom2;
        this.mBondType[this.mAllBonds] = type;
        this.mBondFlags[this.mAllBonds] = 0;
        this.mBondQueryFeatures[this.mAllBonds] = 0;
        this.mValidHelperArrays = 0;
        return this.mAllBonds++;
    }

    public boolean addOrChangeAtom(double x, double y, int atomicNo, int mass, int abnormalValence, int radical, String customLabel) {
        int atom = this.findAtom(x, y);
        if (atom == -1) {
            if (this.mAllAtoms >= this.mMaxAtoms) {
                this.setMaxAtoms(this.mMaxAtoms * 2);
            }
            atom = this.addAtom(atomicNo);
            this.mCoordinates[atom].set(x, y, 0.0);
            this.mAtomMass[atom] = mass;
            this.setAtomAbnormalValence(atom, abnormalValence);
            this.setAtomRadical(atom, radical);
            this.setAtomCustomLabel(atom, customLabel);
            return true;
        }
        boolean changed = this.changeAtom(atom, atomicNo, mass, abnormalValence, radical);
        this.setAtomCustomLabel(atom, customLabel);
        return changed;
    }

    public int addOrChangeBond(int atm1, int atm2, int type) {
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            if ((this.mBondAtom[0][bnd] != atm1 || this.mBondAtom[1][bnd] != atm2) && (this.mBondAtom[0][bnd] != atm2 || this.mBondAtom[1][bnd] != atm1)) continue;
            this.changeBond(bnd, type);
            this.mValidHelperArrays = 0;
            return bnd;
        }
        if (this.mAllBonds >= this.mMaxBonds) {
            this.setMaxBonds(this.mMaxBonds * 2);
        }
        this.mBondAtom[0][this.mAllBonds] = atm1;
        this.mBondAtom[1][this.mAllBonds] = atm2;
        this.mBondType[this.mAllBonds] = type;
        this.mBondFlags[this.mAllBonds] = 0;
        this.mBondQueryFeatures[this.mAllBonds] = 0;
        this.mValidHelperArrays = 0;
        return this.mAllBonds++;
    }

    public boolean addRing(double x, double y, int ringSize, boolean aromatic) {
        while (this.mAllAtoms + ringSize > this.mMaxAtoms) {
            this.setMaxAtoms(this.mMaxAtoms * 2);
        }
        while (this.mAllBonds + ringSize > this.mMaxBonds) {
            this.setMaxBonds(this.mMaxBonds * 2);
        }
        int atom = this.findAtom(x, y);
        if (atom != -1) {
            return this.addRingToAtom(atom, ringSize, aromatic);
        }
        int bond = this.findBond(x, y);
        if (bond != -1) {
            return this.addRingToBond(bond, ringSize, aromatic);
        }
        atom = this.addAtom(x, y);
        double cornerAngle = Math.PI * (double)(ringSize - 2) / (double)ringSize;
        this.polygon(atom, ringSize, atom, aromatic, 0.0, Math.PI - cornerAngle);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean addRingToAtom(int atom, int ringSize, boolean aromatic) {
        if (aromatic && this.getOccupiedValence(atom) > 1 || !aromatic && this.getOccupiedValence(atom) > 2) {
            return false;
        }
        int angles = 0;
        double[] angle = new double[4];
        for (int i = 0; i < this.mAllBonds; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.mBondAtom[j][i] != atom) continue;
                if (angles == 2) {
                    angles = 3;
                    break;
                }
                angle[angles++] = this.getBondAngle(atom, this.mBondAtom[1 - j][i]);
            }
            if (angles == 3) break;
        }
        if (angles == 3) {
            return false;
        }
        double newAngle = angles == 1 ? angle[0] + Math.PI : (Math.abs(angle[0] - angle[1]) > Math.PI ? (angle[0] + angle[1]) / 2.0 : (angle[0] + angle[1]) / 2.0 + Math.PI);
        double cornerAngle = Math.PI * (double)(ringSize - 2) / (double)ringSize;
        this.polygon(atom, ringSize, atom, aromatic, newAngle - cornerAngle / 2.0, Math.PI - cornerAngle);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean addRingToBond(int bond, int ringSize, boolean aromatic) {
        int atomNo;
        int[] bondAtom = new int[2];
        double[] bondAngle = new double[2];
        bondAtom[0] = this.mBondAtom[0][bond];
        bondAtom[1] = this.mBondAtom[1][bond];
        if (this.getOccupiedValence(bondAtom[0]) > 3) {
            return false;
        }
        if (this.getOccupiedValence(bondAtom[1]) > 3) {
            return false;
        }
        int angles = 0;
        double[] angle = new double[4];
        for (int i = 0; i < this.mAllBonds; ++i) {
            if (i == bond) continue;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (this.mBondAtom[j][i] != bondAtom[k]) continue;
                    if (angles == 4) {
                        angles = 5;
                        break;
                    }
                    angle[angles++] = this.getBondAngle(bondAtom[k], this.mBondAtom[1 - j][i]);
                }
                if (angles == 5) break;
            }
            if (angles == 5) break;
        }
        if (angles == 5) {
            return false;
        }
        bondAngle[0] = this.getBondAngle(bondAtom[0], bondAtom[1]);
        if (bondAngle[0] < 0.0) {
            bondAngle[1] = bondAngle[0] + Math.PI;
            atomNo = 0;
        } else {
            bondAngle[1] = bondAngle[0];
            bondAngle[0] = bondAngle[1] - Math.PI;
            atomNo = 1;
        }
        int side = 0;
        for (int i = 0; i < angles; ++i) {
            if (angle[i] > bondAngle[0] && angle[i] < bondAngle[1]) {
                --side;
                continue;
            }
            ++side;
        }
        atomNo = side > 0 ? 1 - atomNo : atomNo;
        double cornerAngle = Math.PI * (double)(ringSize - 2) / (double)ringSize;
        this.polygon(bondAtom[atomNo], ringSize - 1, bondAtom[1 - atomNo], aromatic, bondAngle[side > 0 ? 0 : 1] + Math.PI - cornerAngle, Math.PI - cornerAngle);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean changeAtom(int atom, int atomicNo, int mass, int abnormalValence, int radical) {
        if ((atomicNo == 1 || atomicNo == 151 || atomicNo == 152) && this.getOccupiedValence(atom) > 1) {
            return false;
        }
        int n = atom;
        this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFFFFFFFFFFFFEL;
        if (this.mAtomList != null) {
            this.mAtomList[atom] = null;
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel[atom] = null;
        }
        if (atomicNo == this.mAtomicNo[atom] && mass == this.mAtomMass[atom] && abnormalValence == this.getAtomAbnormalValence(atom) && radical == this.getAtomRadical(atom)) {
            return false;
        }
        if (atomicNo == 151 || atomicNo == 152) {
            mass = atomicNo - 149;
            atomicNo = 1;
        }
        int n2 = atom;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0x3C0;
        this.mAtomicNo[atom] = atomicNo;
        this.mAtomMass[atom] = mass;
        this.mAtomCharge[atom] = 0;
        this.mAtomQueryFeatures[atom] = 0L;
        this.setAtomAbnormalValence(atom, abnormalValence);
        this.setAtomRadical(atom, radical);
        this.removeMappingNo(this.mAtomMapNo[atom]);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean changeAtomCharge(double x, double y, boolean positive) {
        int atom = this.findAtom(x, y);
        return atom != -1 && this.changeAtomCharge(atom, positive);
    }

    public boolean changeAtomCharge(int atom, boolean positive) {
        if (positive) {
            if (this.mAtomCharge[atom] > 8) {
                return false;
            }
            int n = atom;
            this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
        } else {
            if (this.mAtomCharge[atom] < -8) {
                return false;
            }
            int n = atom;
            this.mAtomCharge[n] = this.mAtomCharge[n] - 1;
        }
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean changeBond(int bnd, int type) {
        boolean bondWasChanged = false;
        int oldType = this.mBondType[bnd];
        if (type == 127) {
            bondWasChanged = this.incrementBondOrder(bnd);
        } else if (this.validateBondType(bnd, type)) {
            if (type == 17 || type == 9) {
                boolean bondAtAtom1Qualifies = this.qualifiesAsStereoBond(bnd, this.mBondAtom[0][bnd]);
                boolean bondAtAtom2Qualifies = this.qualifiesAsStereoBond(bnd, this.mBondAtom[1][bnd]);
                if (type == oldType) {
                    if (bondAtAtom1Qualifies == bondAtAtom2Qualifies || bondAtAtom2Qualifies) {
                        int temp = this.mBondAtom[0][bnd];
                        this.mBondAtom[0][bnd] = this.mBondAtom[1][bnd];
                        this.mBondAtom[1][bnd] = temp;
                        bondWasChanged = true;
                    }
                } else {
                    if (!bondAtAtom1Qualifies && bondAtAtom2Qualifies) {
                        int temp = this.mBondAtom[0][bnd];
                        this.mBondAtom[0][bnd] = this.mBondAtom[1][bnd];
                        this.mBondAtom[1][bnd] = temp;
                    }
                    this.mBondType[bnd] = type;
                    bondWasChanged = true;
                }
            } else {
                this.mBondType[bnd] = type;
                bondWasChanged = true;
            }
        }
        if (bondWasChanged) {
            this.mValidHelperArrays = (oldType & 0x67) == (type & 0x67) ? this.mValidHelperArrays & 7 : 0;
            this.mBondQueryFeatures[bnd] = 0;
        }
        return bondWasChanged;
    }

    private boolean qualifiesAsStereoBond(int bond, int atom) {
        int i;
        if (this.getBondOrder(bond) != 1) {
            return false;
        }
        if ((this.mAtomFlags[atom] & 3) != 0) {
            return true;
        }
        for (i = 0; i < this.mAllBonds; ++i) {
            if (i == bond || this.mBondType[i] != 2 || (this.mBondAtom[0][i] != atom || (this.mAtomFlags[this.mBondAtom[1][i]] & 3) == 0) && (this.mBondAtom[1][i] != atom || (this.mAtomFlags[this.mBondAtom[0][i]] & 3) == 0)) continue;
            return true;
        }
        for (i = 0; i < this.mAllBonds; ++i) {
            if (i == bond || this.mBondType[i] != 1 || this.mBondAtom[0][i] != atom && this.mBondAtom[1][i] != atom || (this.mBondFlags[i] & 3) == 0) continue;
            return true;
        }
        return false;
    }

    public int[] addMolecule(Molecule mol) {
        return this.addMolecule(mol, mol.mAllAtoms, mol.mAllBonds);
    }

    public int[] addMolecule(Molecule mol, int atoms, int bonds) {
        this.mIsFragment |= mol.mIsFragment;
        int[] atomMap = new int[mol.mAllAtoms];
        int esrGroupCountAND = this.renumberESRGroups(1);
        int esrGroupCountOR = this.renumberESRGroups(2);
        for (int atom = 0; atom < atoms; ++atom) {
            atomMap[atom] = mol.copyAtom(this, atom, esrGroupCountAND, esrGroupCountOR);
        }
        for (int bond = 0; bond < bonds; ++bond) {
            mol.copyBond(this, bond, esrGroupCountAND, esrGroupCountOR, atomMap, false);
        }
        this.mIsRacemate = this.mIsRacemate && mol.mIsRacemate;
        this.mChirality = 0;
        this.mValidHelperArrays = 0;
        return atomMap;
    }

    public int[] addSubstituent(Molecule substituent, int connectionAtom) {
        return this.addSubstituent(substituent, connectionAtom, false);
    }

    public int[] addSubstituent(Molecule substituent, int connectionAtom, boolean encodeRingClosuresInMapNo) {
        int[] atomMap = new int[substituent.mAllAtoms];
        int esrGroupCountAND = this.renumberESRGroups(1);
        int esrGroupCountOR = this.renumberESRGroups(2);
        for (int atom = 0; atom < substituent.mAllAtoms; ++atom) {
            atomMap[atom] = substituent.getAtomicNo(atom) != 0 ? substituent.copyAtom(this, atom, esrGroupCountAND, esrGroupCountOR) : (encodeRingClosuresInMapNo && substituent.getAtomMapNo(atom) != 0 ? substituent.getAtomMapNo(atom) - 1 : connectionAtom);
        }
        for (int bond = 0; bond < substituent.mAllBonds; ++bond) {
            substituent.copyBond(this, bond, esrGroupCountAND, esrGroupCountOR, atomMap, false);
        }
        this.mIsRacemate = this.mIsRacemate && substituent.mIsRacemate;
        this.mChirality = 0;
        this.mValidHelperArrays = 0;
        return atomMap;
    }

    public void copyMolecule(Molecule destMol) {
        destMol.mAtomList = null;
        destMol.mAtomCustomLabel = null;
        destMol.mIsFragment = this.mIsFragment;
        destMol.mAllAtoms = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            this.copyAtom(destMol, atom, 0, 0);
        }
        destMol.mAllBonds = 0;
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            this.copyBond(destMol, bnd, 0, 0, null, false);
        }
        this.copyMoleculeProperties(destMol);
    }

    public int copyAtom(Molecule destMol, int sourceAtom, int esrGroupOffsetAND, int esrGroupOffsetOR) {
        int destAtom = destMol.mAllAtoms;
        if (destAtom >= destMol.mMaxAtoms) {
            destMol.setMaxAtoms(destMol.mMaxAtoms * 2);
        }
        int esrType = this.getAtomESRType(sourceAtom);
        int esrGroup = -1;
        if (esrType == 1) {
            esrGroup = esrGroupOffsetAND == -1 ? destMol.renumberESRGroups(esrType) : Math.min(31, esrGroupOffsetAND + this.getAtomESRGroup(sourceAtom));
        } else if (esrType == 2) {
            esrGroup = esrGroupOffsetOR == -1 ? destMol.renumberESRGroups(esrType) : Math.min(31, esrGroupOffsetOR + this.getAtomESRGroup(sourceAtom));
        }
        destMol.mAtomicNo[destAtom] = this.mAtomicNo[sourceAtom];
        destMol.mAtomCharge[destAtom] = this.mAtomCharge[sourceAtom];
        destMol.mAtomMass[destAtom] = this.mAtomMass[sourceAtom];
        destMol.mAtomFlags[destAtom] = this.mAtomFlags[sourceAtom];
        destMol.mAtomQueryFeatures[destAtom] = destMol.mIsFragment ? this.mAtomQueryFeatures[sourceAtom] : 0L;
        destMol.mCoordinates[destAtom].set(this.mCoordinates[sourceAtom]);
        destMol.mAtomMapNo[destAtom] = this.mAtomMapNo[sourceAtom];
        if (destMol.mAtomList != null) {
            destMol.mAtomList[destAtom] = null;
        }
        if (this.mAtomList != null && this.mAtomList[sourceAtom] != null && destMol.mIsFragment) {
            if (destMol.mAtomList == null) {
                destMol.mAtomList = new int[destMol.mAtomicNo.length][];
            }
            destMol.mAtomList[destAtom] = Arrays.copyOf(this.mAtomList[sourceAtom], this.mAtomList[sourceAtom].length);
        }
        if (destMol.mAtomCustomLabel != null) {
            destMol.mAtomCustomLabel[destAtom] = null;
        }
        if (this.mAtomCustomLabel != null && this.mAtomCustomLabel[sourceAtom] != null) {
            if (destMol.mAtomCustomLabel == null) {
                destMol.mAtomCustomLabel = new byte[destMol.mAtomicNo.length][];
            }
            destMol.mAtomCustomLabel[destAtom] = Arrays.copyOf(this.mAtomCustomLabel[sourceAtom], this.mAtomCustomLabel[sourceAtom].length);
        }
        if (esrGroup != -1) {
            int n = destAtom;
            destMol.mAtomFlags[n] = destMol.mAtomFlags[n] & 0xFC1FFFFF;
            int n2 = destAtom;
            destMol.mAtomFlags[n2] = destMol.mAtomFlags[n2] | esrGroup << 21;
        }
        ++destMol.mAllAtoms;
        destMol.mValidHelperArrays = 0;
        return destAtom;
    }

    public int copyBond(Molecule destMol, int sourceBond, int esrGroupOffsetAND, int esrGroupOffsetOR, int[] atomMap, boolean useBondTypeDelocalized) {
        return this.copyBond(destMol, sourceBond, esrGroupOffsetAND, esrGroupOffsetOR, atomMap == null ? this.mBondAtom[0][sourceBond] : atomMap[this.mBondAtom[0][sourceBond]], atomMap == null ? this.mBondAtom[1][sourceBond] : atomMap[this.mBondAtom[1][sourceBond]], useBondTypeDelocalized);
    }

    public int copyBond(Molecule destMol, int sourceBond, int esrGroupOffsetAND, int esrGroupOffsetOR, int destAtom1, int destAtom2, boolean useBondTypeDelocalized) {
        int bondType;
        int destBond = destMol.mAllBonds;
        if (destBond >= destMol.mMaxBonds) {
            destMol.setMaxBonds(destMol.mMaxBonds * 2);
        }
        int esrType = this.getBondESRType(sourceBond);
        int esrGroup = -1;
        if (esrType == 1) {
            esrGroup = esrGroupOffsetAND == -1 ? destMol.renumberESRGroups(esrType) : Math.min(32, esrGroupOffsetAND + this.getBondESRGroup(sourceBond));
        }
        if (esrType == 2) {
            esrGroup = esrGroupOffsetOR == -1 ? destMol.renumberESRGroups(esrType) : Math.min(32, esrGroupOffsetOR + this.getBondESRGroup(sourceBond));
        }
        destMol.mBondAtom[0][destBond] = destAtom1;
        destMol.mBondAtom[1][destBond] = destAtom2;
        destMol.mBondType[destBond] = bondType = useBondTypeDelocalized && (this.mBondFlags[sourceBond] & 0x200) != 0 ? 64 : this.mBondType[sourceBond];
        destMol.mBondFlags[destBond] = this.mBondFlags[sourceBond];
        int n = destMol.mBondQueryFeatures[destBond] = destMol.mIsFragment ? this.mBondQueryFeatures[sourceBond] : 0;
        if (esrGroup != -1) {
            int n2 = destBond;
            destMol.mBondFlags[n2] = destMol.mBondFlags[n2] & 0xFFFE0FFF;
            int n3 = destBond;
            destMol.mBondFlags[n3] = destMol.mBondFlags[n3] | esrGroup << 12;
        }
        ++destMol.mAllBonds;
        destMol.mValidHelperArrays = 0;
        return destBond;
    }

    public void copyMoleculeProperties(Molecule destMol) {
        destMol.mIsFragment = this.mIsFragment;
        destMol.mIsRacemate = this.mIsRacemate;
        destMol.mProtectHydrogen = this.mProtectHydrogen;
        destMol.mChirality = this.mChirality;
        destMol.mName = this.mName;
        destMol.mValidHelperArrays = this.mValidHelperArrays & 0x18;
    }

    public void invalidateHelperArrays(int helperBits) {
        this.mValidHelperArrays &= ~helperBits;
    }

    public int renumberESRGroups(int type) {
        if (type == 0) {
            return 0;
        }
        boolean[] groupUsed = null;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.getAtomESRType(atom) != type) continue;
            if (groupUsed == null) {
                groupUsed = new boolean[32];
            }
            groupUsed[this.getAtomESRGroup((int)atom)] = true;
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            if (this.getBondESRType(bond) != type) continue;
            if (groupUsed == null) {
                groupUsed = new boolean[32];
            }
            groupUsed[this.getBondESRGroup((int)bond)] = true;
        }
        int newIndex = 0;
        if (groupUsed != null) {
            int group;
            int[] newGroup = new int[32];
            for (int i = 0; i < 32; ++i) {
                if (!groupUsed[i]) continue;
                newGroup[i] = newIndex++;
            }
            for (int atom = 0; atom < this.mAllAtoms; ++atom) {
                if (this.getAtomESRType(atom) != type) continue;
                group = newGroup[this.getAtomESRGroup(atom)];
                int n = atom;
                this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFC1FFFFF;
                int n2 = atom;
                this.mAtomFlags[n2] = this.mAtomFlags[n2] | group << 21;
            }
            for (int bond = 0; bond < this.mAllBonds; ++bond) {
                if (this.getBondESRType(bond) != type) continue;
                group = newGroup[this.getBondESRGroup(bond)];
                int n = bond;
                this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFE0FFF;
                int n3 = bond;
                this.mBondFlags[n3] = this.mBondFlags[n3] | group << 12;
            }
        }
        return newIndex;
    }

    public void swapAtoms(int atom1, int atom2) {
        Object[] tempList;
        int tempInt = this.mAtomicNo[atom1];
        this.mAtomicNo[atom1] = this.mAtomicNo[atom2];
        this.mAtomicNo[atom2] = tempInt;
        tempInt = this.mAtomCharge[atom1];
        this.mAtomCharge[atom1] = this.mAtomCharge[atom2];
        this.mAtomCharge[atom2] = tempInt;
        tempInt = this.mAtomMass[atom1];
        this.mAtomMass[atom1] = this.mAtomMass[atom2];
        this.mAtomMass[atom2] = tempInt;
        tempInt = this.mAtomFlags[atom1];
        this.mAtomFlags[atom1] = this.mAtomFlags[atom2];
        this.mAtomFlags[atom2] = tempInt;
        long tempLong = this.mAtomQueryFeatures[atom1];
        this.mAtomQueryFeatures[atom1] = this.mAtomQueryFeatures[atom2];
        this.mAtomQueryFeatures[atom2] = tempLong;
        tempInt = this.mAtomMapNo[atom1];
        this.mAtomMapNo[atom1] = this.mAtomMapNo[atom2];
        this.mAtomMapNo[atom2] = tempInt;
        Coordinates tempCoords = this.mCoordinates[atom1];
        this.mCoordinates[atom1] = this.mCoordinates[atom2];
        this.mCoordinates[atom2] = tempCoords;
        if (this.mAtomList != null) {
            tempList = this.mAtomList[atom1];
            this.mAtomList[atom1] = this.mAtomList[atom2];
            this.mAtomList[atom2] = tempList;
        }
        if (this.mAtomCustomLabel != null) {
            tempList = this.mAtomCustomLabel[atom1];
            this.mAtomCustomLabel[atom1] = this.mAtomCustomLabel[atom2];
            this.mAtomCustomLabel[atom2] = (byte[])tempList;
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            for (int i = 0; i < 2; ++i) {
                if (this.mBondAtom[i][bond] == atom1) {
                    this.mBondAtom[i][bond] = atom2;
                    continue;
                }
                if (this.mBondAtom[i][bond] != atom2) continue;
                this.mBondAtom[i][bond] = atom1;
            }
        }
        this.mValidHelperArrays = 0;
    }

    public void swapBonds(int bond1, int bond2) {
        int temp = this.mBondAtom[0][bond1];
        this.mBondAtom[0][bond1] = this.mBondAtom[0][bond2];
        this.mBondAtom[0][bond2] = temp;
        temp = this.mBondAtom[1][bond1];
        this.mBondAtom[1][bond1] = this.mBondAtom[1][bond2];
        this.mBondAtom[1][bond2] = temp;
        temp = this.mBondType[bond1];
        this.mBondType[bond1] = this.mBondType[bond2];
        this.mBondType[bond2] = temp;
        temp = this.mBondFlags[bond1];
        this.mBondFlags[bond1] = this.mBondFlags[bond2];
        this.mBondFlags[bond2] = temp;
        temp = this.mBondQueryFeatures[bond1];
        this.mBondQueryFeatures[bond1] = this.mBondQueryFeatures[bond2];
        this.mBondQueryFeatures[bond2] = temp;
        this.mValidHelperArrays = 0;
    }

    public void deleteAtom(int atom) {
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            for (int i = 0; i < 2; ++i) {
                if (this.mBondAtom[i][bnd] != atom) continue;
                this.mBondType[bnd] = 128;
                int bonds = 0;
                for (int j = 0; j < this.mAllBonds; ++j) {
                    if (j == bnd || this.mBondAtom[0][j] != this.mBondAtom[1 - i][bnd] && this.mBondAtom[1][j] != this.mBondAtom[1 - i][bnd]) continue;
                    ++bonds;
                }
                if (bonds != 0) continue;
                this.removeMappingNo(this.mAtomMapNo[this.mBondAtom[1 - i][bnd]]);
                this.mAtomicNo[this.mBondAtom[1 - i][bnd]] = -1;
            }
        }
        this.removeMappingNo(this.mAtomMapNo[atom]);
        this.mAtomicNo[atom] = -1;
        if (this.mAtomList != null) {
            this.mAtomList[atom] = null;
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel[atom] = null;
        }
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    public boolean deleteAtomOrBond(double x, double y) {
        int atom = this.findAtom(x, y);
        if (atom != -1) {
            if ((this.mAtomFlags[atom] & 0x200) != 0) {
                this.deleteSelectedAtoms();
            } else {
                this.deleteAtom(atom);
            }
            this.mValidHelperArrays = 0;
            return true;
        }
        int bnd = this.findBond(x, y);
        if (bnd != -1) {
            if ((this.mAtomFlags[this.mBondAtom[0][bnd]] & this.mAtomFlags[this.mBondAtom[1][bnd]] & 0x200) != 0) {
                this.deleteSelectedAtoms();
            } else {
                this.deleteBondAndSurrounding(bnd);
            }
            this.mValidHelperArrays = 0;
            return true;
        }
        return false;
    }

    public void deleteBond(int bond) {
        this.mBondType[bond] = 128;
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    public void deleteBondAndSurrounding(int bond) {
        for (int i = 0; i < 2; ++i) {
            int bonds = 0;
            for (int j = 0; j < this.mAllBonds; ++j) {
                if (j == bond || this.mBondAtom[0][j] != this.mBondAtom[i][bond] && this.mBondAtom[1][j] != this.mBondAtom[i][bond]) continue;
                ++bonds;
            }
            if (bonds != 0) continue;
            this.removeMappingNo(this.mAtomMapNo[this.mBondAtom[i][bond]]);
            this.mAtomicNo[this.mBondAtom[i][bond]] = -1;
        }
        this.mBondType[bond] = 128;
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    public int[] deleteAtoms(boolean[] deleteAtom) {
        boolean found = false;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (!deleteAtom[atom]) continue;
            this.markAtomForDeletion(atom);
            found = true;
        }
        if (!found) {
            return null;
        }
        return this.deleteMarkedAtomsAndBonds();
    }

    public int[] deleteAtoms(int[] atomList) {
        if (atomList.length == 0) {
            return null;
        }
        for (int atom : atomList) {
            this.markAtomForDeletion(atom);
        }
        return this.deleteMarkedAtomsAndBonds();
    }

    public int[] getDeleteAtomsBondMap(boolean[] deleteAtom) {
        boolean[] deleteBond = new boolean[this.mAllBonds];
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            if (!deleteAtom[this.mBondAtom[0][bond]] && !deleteAtom[this.mBondAtom[1][bond]]) continue;
            deleteBond[bond] = true;
        }
        int bondDest = 0;
        int[] bondMap = new int[this.mAllBonds];
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            bondMap[bnd] = deleteBond[bnd] ? -1 : bondDest++;
        }
        return bondMap;
    }

    public int[] getDeleteAtomsBondMap(int[] atomList) {
        boolean[] deleteAtom = new boolean[this.mAllAtoms];
        for (int atom : atomList) {
            deleteAtom[atom] = true;
        }
        return this.getDeleteAtomsBondMap(deleteAtom);
    }

    public boolean deleteSelectedAtoms() {
        boolean found = false;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if ((this.mAtomFlags[atom] & 0x200) == 0) continue;
            this.markAtomForDeletion(atom);
            found = true;
        }
        return found && this.deleteMarkedAtomsAndBonds() != null;
    }

    public void markAtomForDeletion(int atom) {
        this.mAtomicNo[atom] = -1;
    }

    public void markBondForDeletion(int bond) {
        this.mBondType[bond] = 128;
    }

    public boolean isAtomMarkedForDeletion(int atom) {
        return this.mAtomicNo[atom] == -1;
    }

    public boolean isBondMarkedForDeletion(int bond) {
        return this.mBondType[bond] == 128;
    }

    public int[] deleteMarkedAtomsAndBonds() {
        boolean found = false;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.mAtomicNo[atom] != -1) continue;
            found = true;
            this.removeMappingNo(this.mAtomMapNo[atom]);
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            if (this.mBondType[bond] == 128) {
                found = true;
                continue;
            }
            if (this.mAtomicNo[this.mBondAtom[0][bond]] != -1 && this.mAtomicNo[this.mBondAtom[1][bond]] != -1) continue;
            this.mBondType[bond] = 128;
            found = true;
        }
        if (found) {
            this.mValidHelperArrays = 0;
            return this.compressMolTable();
        }
        return null;
    }

    @Deprecated
    public void deleteMolecule() {
        this.clear();
    }

    public void clear() {
        this.mAllAtoms = 0;
        this.mAllBonds = 0;
        this.mIsFragment = false;
        this.mIsRacemate = false;
        this.mChirality = 0;
        this.mAtomList = null;
        this.mAtomCustomLabel = null;
        this.mName = null;
        this.mValidHelperArrays = 0;
    }

    public void removeAtomSelection() {
        int i = 0;
        while (i < this.mAllAtoms) {
            int n = i++;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFDFF;
        }
    }

    public void removeAtomColors() {
        int i = 0;
        while (i < this.mAllAtoms) {
            int n = i++;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFE3F;
        }
    }

    public void removeAtomCustomLabels() {
        this.mAtomCustomLabel = null;
    }

    public void removeAtomMarkers() {
        int i = 0;
        while (i < this.mAllAtoms) {
            int n = i++;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFBFFFF;
        }
    }

    public void removeBondHiliting() {
        int i = 0;
        while (i < this.mAllBonds) {
            int n = i++;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFF9FFFF;
        }
    }

    public int findAtom(double pickx, double picky) {
        int foundAtom = -1;
        double avbl = this.getAverageBondLength();
        double foundDistanceSquare = Double.MAX_VALUE;
        double maxDistanceSquare = avbl * avbl / 12.0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            double x = this.mCoordinates[atom].x;
            double y = this.mCoordinates[atom].y;
            double distanceSquare = (pickx - x) * (pickx - x) + (picky - y) * (picky - y);
            if (!(distanceSquare < maxDistanceSquare) || !(distanceSquare < foundDistanceSquare)) continue;
            foundDistanceSquare = distanceSquare;
            foundAtom = atom;
        }
        return foundAtom;
    }

    public int findBond(double pickx, double picky) {
        int foundBond = -1;
        double maxDistance = this.getAverageBondLength();
        double foundDistance = Double.MAX_VALUE;
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            double distance;
            double x1 = this.mCoordinates[this.mBondAtom[0][bond]].x;
            double y1 = this.mCoordinates[this.mBondAtom[0][bond]].y;
            double x2 = this.mCoordinates[this.mBondAtom[1][bond]].x;
            double y2 = this.mCoordinates[this.mBondAtom[1][bond]].y;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double bondLength = Math.sqrt(dx * dx + dy * dy);
            double centralX = (x1 + x2) / 2.0;
            dx = pickx - centralX;
            double centralY = (y1 + y2) / 2.0;
            dy = picky - centralY;
            if (Math.sqrt(dx * dx + dy * dy) > bondLength / 2.0) continue;
            if (x2 == x1) {
                distance = Math.abs(x1 - pickx);
            } else {
                double constA = (y2 - y1) / (x1 - x2);
                double constC = -constA * x1 - y1;
                distance = Math.abs((constA * pickx + picky + constC) / Math.sqrt(constA * constA + 1.0));
            }
            if (!(distance < maxDistance) || !(distance < foundDistance)) continue;
            foundDistance = distance;
            foundBond = bond;
        }
        return foundBond;
    }

    public int getAllAtoms() {
        return this.mAllAtoms;
    }

    public int getAllBonds() {
        return this.mAllBonds;
    }

    public int getAtomAbnormalValence(int atom) {
        return ((this.mAtomFlags[atom] & 0xF0000000) >>> 28) - 1;
    }

    public int getAtomCharge(int atom) {
        return this.mAtomCharge[atom];
    }

    public int getAtomCIPParity(int atom) {
        return (this.mAtomFlags[atom] & 0x18000) >> 15;
    }

    public int getAtomColor(int atom) {
        return this.mAtomFlags[atom] & 0x1C0;
    }

    public Coordinates[] getAtomCoordinates() {
        return this.mCoordinates;
    }

    public int getAtomESRGroup(int atom) {
        if (this.getAtomESRType(atom) != 1 && this.getAtomESRType(atom) != 2) {
            return -1;
        }
        return (this.mAtomFlags[atom] & 0x3E00000) >> 21;
    }

    public int getAtomESRType(int atom) {
        return (this.mAtomFlags[atom] & 0x180000) >> 19;
    }

    public int getAtomicNo(int atom) {
        return this.mAtomicNo[atom];
    }

    public String getAtomCustomLabel(int atom) {
        return this.mAtomCustomLabel == null ? null : (this.mAtomCustomLabel[atom] == null ? null : new String(this.mAtomCustomLabel[atom]));
    }

    public byte[] getAtomCustomLabelBytes(int atom) {
        return this.mAtomCustomLabel == null ? null : this.mAtomCustomLabel[atom];
    }

    public String getAtomLabel(int atom) {
        return cAtomLabel[this.mAtomicNo[atom]];
    }

    public int[] getAtomList(int atom) {
        return this.mAtomList == null ? null : this.mAtomList[atom];
    }

    public String getAtomListString(int atom) {
        if (this.mAtomList == null || this.mAtomList[atom] == null) {
            return (this.mAtomQueryFeatures[atom] & 1L) != 0L ? "" : cAtomLabel[this.mAtomicNo[atom]];
        }
        String listString = "";
        for (int i = 0; i < this.mAtomList[atom].length; ++i) {
            if (i > 0) {
                listString = listString.concat(",");
            }
            int atomicNo = this.mAtomList[atom][i];
            listString = listString.concat(cAtomLabel[atomicNo]);
        }
        return listString;
    }

    public int getAtomMapNo(int atom) {
        return Math.abs(this.mAtomMapNo[atom]);
    }

    public int getAtomMass(int atom) {
        return this.mAtomMass[atom];
    }

    public int getAtomParity(int atom) {
        return this.mAtomFlags[atom] & 3;
    }

    public long getAtomQueryFeatures(int atom) {
        return this.mAtomQueryFeatures[atom];
    }

    public int getAtomRadical(int atom) {
        return this.mAtomFlags[atom] & 0x30;
    }

    public Coordinates getCoordinates(int atom) {
        return this.mCoordinates[atom];
    }

    public double getAtomX(int atom) {
        return this.mCoordinates[atom].x;
    }

    public double getAtomY(int atom) {
        return this.mCoordinates[atom].y;
    }

    public double getAtomZ(int atom) {
        return this.mCoordinates[atom].z;
    }

    public Rectangle2D.Double getBounds(Rectangle2D.Double r) {
        if (this.mAllAtoms == 0) {
            return null;
        }
        double x1 = this.mCoordinates[0].x;
        double y1 = this.mCoordinates[0].y;
        double x2 = this.mCoordinates[0].x;
        double y2 = this.mCoordinates[0].y;
        for (int atom = 1; atom < this.mAllAtoms; ++atom) {
            if (x1 > this.mCoordinates[atom].x) {
                x1 = this.mCoordinates[atom].x;
            } else if (x2 < this.mCoordinates[atom].x) {
                x2 = this.mCoordinates[atom].x;
            }
            if (y1 > this.mCoordinates[atom].y) {
                y1 = this.mCoordinates[atom].y;
                continue;
            }
            if (!(y2 < this.mCoordinates[atom].y)) continue;
            y2 = this.mCoordinates[atom].y;
        }
        if (r == null) {
            r = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        } else {
            r.x = x1;
            r.y = y1;
            r.width = x2 - x1;
            r.height = y2 - y1;
        }
        return r;
    }

    public static double getDefaultAverageBondLength() {
        return sDefaultAVBL;
    }

    public static void setDefaultAverageBondLength(double defaultAVBL) {
        sDefaultAVBL = defaultAVBL;
    }

    public double getAverageBondLength() {
        return this.getAverageBondLength(this.mAllAtoms, this.mAllBonds, sDefaultAVBL);
    }

    public double getAverageBondLength(int atoms, int bonds) {
        return this.getAverageBondLength(atoms, bonds, sDefaultAVBL);
    }

    public double getAverageBondLength(int atoms, int bonds, double defaultBondLength) {
        return this.getAverageBondLength(atoms, bonds, defaultBondLength, this.mCoordinates);
    }

    public double getAverageBondLength(int atoms, int bonds, double defaultBondLength, Coordinates[] coords) {
        int bond;
        boolean considerMetalBonds = false;
        int consideredBonds = 0;
        for (bond = 0; bond < bonds; ++bond) {
            if (this.mBondType[bond] == 32 || (this.mBondQueryFeatures[bond] & 0x7F80) != 0) continue;
            ++consideredBonds;
        }
        if (consideredBonds == 0) {
            for (bond = 0; bond < bonds; ++bond) {
                if ((this.mBondQueryFeatures[bond] & 0x7F80) != 0) continue;
                ++consideredBonds;
            }
            considerMetalBonds = true;
        }
        if (consideredBonds == 0) {
            if (atoms < 2) {
                return defaultBondLength;
            }
            double lowDistance = Double.MAX_VALUE;
            for (int atom1 = 1; atom1 < atoms; ++atom1) {
                for (int atom2 = 0; atom2 < atom1; ++atom2) {
                    double distance = coords[atom1].distance(coords[atom2]);
                    if (!(distance > 0.0) || !(distance < lowDistance)) continue;
                    lowDistance = distance;
                }
            }
            return lowDistance != Double.MAX_VALUE ? 0.6 * lowDistance : defaultBondLength;
        }
        double avblSum = 0.0;
        for (int bond2 = 0; bond2 < bonds; ++bond2) {
            if (!considerMetalBonds && this.mBondType[bond2] == 32 || (this.mBondQueryFeatures[bond2] & 0x7F80) != 0) continue;
            avblSum += coords[this.mBondAtom[1][bond2]].distance(coords[this.mBondAtom[0][bond2]]);
        }
        return avblSum / (double)consideredBonds;
    }

    public double getBondAngle(int atom1, int atom2) {
        return Molecule.getAngle(this.mCoordinates[atom1].x, this.mCoordinates[atom1].y, this.mCoordinates[atom2].x, this.mCoordinates[atom2].y);
    }

    public double calculateTorsion(int[] atom) {
        Coordinates c1 = this.mCoordinates[atom[0]];
        Coordinates c2 = this.mCoordinates[atom[1]];
        Coordinates c3 = this.mCoordinates[atom[2]];
        Coordinates c4 = this.mCoordinates[atom[3]];
        Coordinates v1 = c2.subC(c1);
        Coordinates v2 = c3.subC(c2);
        Coordinates v3 = c4.subC(c3);
        Coordinates n1 = v1.cross(v2);
        Coordinates n2 = v2.cross(v3);
        return -Math.atan2(v2.getLength() * v1.dot(n2), n1.dot(n2));
    }

    public void center() {
        int atom;
        Coordinates cog = new Coordinates();
        for (atom = 0; atom < this.mAllAtoms; ++atom) {
            cog.add(this.mCoordinates[atom]);
        }
        cog.scale(1.0 / (double)this.mAllAtoms);
        for (atom = 0; atom < this.mAllAtoms; ++atom) {
            this.mCoordinates[atom].sub(cog);
        }
    }

    public void translate(double dx, double dy, double dz) {
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            this.mCoordinates[atom].add(dx, dy, dz);
        }
    }

    public int getBondAtom(int no, int bond) {
        return this.mBondAtom[no][bond];
    }

    public int getBondCIPParity(int bond) {
        return (this.mBondFlags[bond] & 0x30) >> 4;
    }

    public int getBondESRGroup(int bond) {
        if (this.getBondESRType(bond) != 1 && this.getBondESRType(bond) != 2) {
            return -1;
        }
        return (this.mBondFlags[bond] & 0x1F000) >> 12;
    }

    public int getBondESRType(int bond) {
        return (this.mBondFlags[bond] & 0xC00) >> 10;
    }

    public double getBondLength(int bond) {
        int atom1 = this.mBondAtom[0][bond];
        int atom2 = this.mBondAtom[1][bond];
        double xdif = this.mCoordinates[atom2].x - this.mCoordinates[atom1].x;
        double ydif = this.mCoordinates[atom2].y - this.mCoordinates[atom1].y;
        return Math.sqrt(xdif * xdif + ydif * ydif);
    }

    public int getBondOrder(int bond) {
        switch (this.mBondType[bond] & 0x67) {
            case 1: 
            case 64: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public int getBondParity(int bnd) {
        return this.mBondFlags[bnd] & 3;
    }

    public int getBondQueryFeatures(int bnd) {
        return this.mBondQueryFeatures[bnd];
    }

    public boolean isBondBridge(int bond) {
        return (this.mBondQueryFeatures[bond] & 0x7F80) != 0;
    }

    public int getBondBridgeMinSize(int bond) {
        return (this.mBondQueryFeatures[bond] & 0x780) >> 7;
    }

    public int getBondBridgeMaxSize(int bond) {
        return ((this.mBondQueryFeatures[bond] & 0x780) >> 7) + ((this.mBondQueryFeatures[bond] & 0x7800) >> 11);
    }

    public int getBondType(int bond) {
        return this.mBondType[bond];
    }

    public int getBondTypeSimple(int bond) {
        return this.mBondType[bond] & 0x67;
    }

    public int getChirality() {
        return this.mChirality;
    }

    public int getMaxAtoms() {
        return this.mMaxAtoms;
    }

    private static Coordinates[] copyOf(Coordinates[] original, int newLength) {
        Coordinates[] copy = new Coordinates[newLength];
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            copy[i] = new Coordinates(original[i]);
        }
        return copy;
    }

    private static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static int[][] copyOf(int[][] original, int newLength) {
        int[][] copy = new int[newLength][];
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            copy[i] = new int[original[i].length];
            System.arraycopy(original[i], 0, copy[i], 0, original[i].length);
        }
        return copy;
    }

    private static byte[][] copyOf(byte[][] original, int newLength) {
        byte[][] copy = new byte[newLength][];
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            copy[i] = new byte[original[i].length];
            System.arraycopy(original[i], 0, copy[i], 0, original[i].length);
        }
        return copy;
    }

    public void setMaxAtoms(int v) {
        this.mAtomicNo = Molecule.copyOf(this.mAtomicNo, v);
        this.mAtomCharge = Molecule.copyOf(this.mAtomCharge, v);
        this.mAtomMapNo = Molecule.copyOf(this.mAtomMapNo, v);
        int orig = this.mCoordinates.length;
        this.mCoordinates = Molecule.copyOf(this.mCoordinates, v);
        for (int i = orig; i < v; ++i) {
            this.mCoordinates[i] = new Coordinates();
        }
        this.mAtomMass = Molecule.copyOf(this.mAtomMass, v);
        this.mAtomFlags = Molecule.copyOf(this.mAtomFlags, v);
        this.mAtomQueryFeatures = Molecule.copyOf(this.mAtomQueryFeatures, v);
        if (this.mAtomList != null) {
            this.mAtomList = Molecule.copyOf(this.mAtomList, v);
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel = Molecule.copyOf(this.mAtomCustomLabel, v);
        }
        this.mMaxAtoms = v;
    }

    public int getMaxBonds() {
        return this.mMaxBonds;
    }

    public void setMaxBonds(int v) {
        this.mBondAtom[0] = Molecule.copyOf(this.mBondAtom[0], v);
        this.mBondAtom[1] = Molecule.copyOf(this.mBondAtom[1], v);
        this.mBondType = Molecule.copyOf(this.mBondType, v);
        this.mBondFlags = Molecule.copyOf(this.mBondFlags, v);
        this.mBondQueryFeatures = Molecule.copyOf(this.mBondQueryFeatures, v);
        this.mMaxBonds = v;
    }

    public int getMoleculeColor() {
        return this.mMoleculeColor;
    }

    public void setMoleculeColor(int color) {
        this.mMoleculeColor = color;
    }

    public String getName() {
        return this.mName;
    }

    public boolean getStereoProblem(int atom) {
        return (this.mAtomFlags[atom] & 0x20000) != 0;
    }

    public boolean isAtomConfigurationUnknown(int atom) {
        return (this.mAtomFlags[atom] & 0x4000000) != 0;
    }

    public boolean isAtomParityPseudo(int atom) {
        return (this.mAtomFlags[atom] & 4) != 0;
    }

    public boolean isAtomStereoCenter(int atom) {
        return (this.mAtomFlags[atom] & 0x8000000) != 0;
    }

    public boolean isBondParityPseudo(int bond) {
        return (this.mBondFlags[bond] & 4) != 0;
    }

    public boolean isBondParityUnknownOrNone(int bond) {
        return (this.mBondFlags[bond] & 0x1000000) != 0;
    }

    public boolean isFragment() {
        return this.mIsFragment;
    }

    public boolean is3D() {
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.mCoordinates[atom].z == 0.0) continue;
            return true;
        }
        return false;
    }

    public boolean isNaturalAbundance(int atom) {
        return this.mAtomMass[atom] == 0;
    }

    public boolean isPurelyOrganic() {
        block3: for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            switch (this.mAtomicNo[atom]) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 33: 
                case 34: 
                case 35: 
                case 52: 
                case 53: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isSelectedAtom(int atom) {
        return (this.mAtomFlags[atom] & 0x200) != 0;
    }

    public boolean isMarkedAtom(int atom) {
        return (this.mAtomFlags[atom] & 0x40000) != 0;
    }

    public boolean isBondBackgroundHilited(int bond) {
        return (this.mBondFlags[bond] & 0x20000) != 0;
    }

    public boolean isBondForegroundHilited(int bond) {
        return (this.mBondFlags[bond] & 0x40000) != 0;
    }

    public boolean isSelectedBond(int bond) {
        return (this.mAtomFlags[this.mBondAtom[0][bond]] & this.mAtomFlags[this.mBondAtom[1][bond]] & 0x200) != 0;
    }

    public boolean isAutoMappedAtom(int atom) {
        return this.mAtomMapNo[atom] < 0;
    }

    public boolean isStereoBond(int bond) {
        return this.mBondType[bond] == 17 || this.mBondType[bond] == 9;
    }

    public boolean isStereoBond(int bond, int atom) {
        return (this.mBondType[bond] == 17 || this.mBondType[bond] == 9) && this.mBondAtom[0][bond] == atom;
    }

    public void setAllAtoms(int no) {
        this.mAllAtoms = no;
        this.mValidHelperArrays = 0;
    }

    public void setAllBonds(int no) {
        this.mAllBonds = no;
        this.mValidHelperArrays = 0;
    }

    public void setAtomAbnormalValence(int atom, int valence) {
        if (valence >= -1 && valence <= 14) {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFFF;
            int n2 = atom;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] | 1 + valence << 28;
            if (this.mAtomicNo[atom] == 6 && (valence == -1 || valence == 0 || valence == 2 || valence == 4)) {
                int n3 = atom;
                this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFFFFFFCF;
                if (valence == 2) {
                    int n4 = atom;
                    this.mAtomFlags[n4] = this.mAtomFlags[n4] | 0x10;
                }
            }
        }
    }

    public void setAtomCharge(int atom, int charge) {
        this.mAtomCharge[atom] = charge;
        this.mValidHelperArrays = 0;
    }

    public void setAtomColor(int atom, int color) {
        int n = atom;
        this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFE3F;
        int n2 = atom;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] | color;
    }

    public void setAtomConfigurationUnknown(int atom, boolean u) {
        if (u) {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] | 0x4000000;
        } else {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFBFFFFFF;
        }
        this.mValidHelperArrays &= 7;
    }

    public void setAtomSelection(int atom, boolean s) {
        if (s) {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] | 0x200;
        } else {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFDFF;
        }
    }

    public void setAtomMarker(int atom, boolean s) {
        if (s) {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] | 0x40000;
        } else {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFBFFFF;
        }
    }

    public void setAtomicNo(int atom, int no) {
        if (no >= 0 && no <= 190) {
            if (no == 151 || no == 152) {
                this.mAtomicNo[atom] = 1;
                this.mAtomMass[atom] = no - 149;
            } else {
                this.mAtomicNo[atom] = no;
                this.mAtomMass[atom] = 0;
            }
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFFF;
            this.mValidHelperArrays = 0;
        }
    }

    public void setAtomList(int atom, int[] list) {
        if (this.mAtomList == null) {
            this.mAtomList = new int[this.mMaxAtoms][];
        }
        if (list != null) {
            Arrays.sort(list);
        }
        this.mAtomList[atom] = list;
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setAtomList(int atom, int[] list, boolean isExcludeList) {
        if (list == null) {
            if (this.mAtomList != null) {
                this.mAtomList[atom] = null;
            }
            return;
        }
        if (list.length == 1 && !isExcludeList) {
            int atomicNo = list[0];
            if (this.mAtomicNo[atom] != atomicNo) {
                this.changeAtom(atom, atomicNo, 0, -1, 0);
            }
            if (this.mAtomList != null) {
                this.mAtomList[atom] = null;
            }
            return;
        }
        if (this.mAtomList == null) {
            this.mAtomList = new int[this.mMaxAtoms][];
        }
        this.mAtomList[atom] = list;
        if (isExcludeList) {
            int n = atom;
            this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] | 1L;
        }
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setAtomMapNo(int atom, int mapNo, boolean autoMapped) {
        this.mAtomMapNo[atom] = autoMapped ? -mapNo : mapNo;
    }

    public void setAtomMass(int atom, int mass) {
        this.mAtomMass[atom] = mass;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomParity(int atom, int parity, boolean isPseudo) {
        int n = atom;
        this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFFF8;
        int n2 = atom;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] | parity;
        if (isPseudo) {
            int n3 = atom;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] | 4;
        }
    }

    protected void setAtomStereoCenter(int atom, boolean isStereoCenter) {
        int n = atom;
        this.mAtomFlags[n] = this.mAtomFlags[n] & 0xF7FFFFFF;
        if (isStereoCenter) {
            int n2 = atom;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x8000000;
        }
    }

    public void setAtomQueryFeature(int atom, long feature, boolean value) {
        if (value) {
            int n = atom;
            this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] | feature;
        } else {
            int n = atom;
            this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & (feature ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setAtomRadical(int atom, int radical) {
        int n = atom;
        this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFFFFCF;
        int n2 = atom;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] | radical;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomCIPParity(int atom, int parity) {
        int n = atom;
        this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFFFE7FFF;
        int n2 = atom;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] | parity << 15;
    }

    public void setAtomX(int atom, double x) {
        this.mCoordinates[atom].x = x;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomY(int atom, double y) {
        this.mCoordinates[atom].y = y;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomZ(int atom, double z) {
        this.mCoordinates[atom].z = z;
        this.mValidHelperArrays &= 7;
    }

    public void setBondAtom(int no, int bond, int atom) {
        this.mBondAtom[no][bond] = atom;
        this.mValidHelperArrays = 0;
    }

    public void setBondCIPParity(int bond, int parity) {
        int n = bond;
        this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFFFFCF;
        int n2 = bond;
        this.mBondFlags[n2] = this.mBondFlags[n2] | parity << 4;
    }

    public void setBondBackgroundHiliting(int bond, boolean s) {
        if (s) {
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] | 0x20000;
        } else {
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFDFFFF;
        }
    }

    public void setBondForegroundHiliting(int bond, boolean s) {
        if (s) {
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] | 0x40000;
        } else {
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFBFFFF;
        }
    }

    public void setBondParity(int bond, int parity, boolean isPseudo) {
        int n = bond;
        this.mBondFlags[n] = this.mBondFlags[n] & 0xFEFFFFF8;
        int n2 = bond;
        this.mBondFlags[n2] = this.mBondFlags[n2] | parity;
        if (isPseudo) {
            int n3 = bond;
            this.mBondFlags[n3] = this.mBondFlags[n3] | 4;
        }
    }

    public void setBondParityUnknownOrNone(int bond) {
        int n = bond;
        this.mBondFlags[n] = this.mBondFlags[n] | 0x1000000;
    }

    public void setBondQueryFeature(int bond, int feature, boolean value) {
        if (value) {
            int n = bond;
            this.mBondQueryFeatures[n] = this.mBondQueryFeatures[n] | feature;
        } else {
            int n = bond;
            this.mBondQueryFeatures[n] = this.mBondQueryFeatures[n] & ~feature;
        }
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setBondOrder(int bond, int order) {
        this.mBondType[bond] = order == 1 ? 1 : (order == 2 ? 2 : (order == 3 ? 4 : 32));
        this.mValidHelperArrays = 0;
    }

    public void setBondType(int bond, int type) {
        this.mBondType[bond] = type;
        this.mValidHelperArrays = 0;
    }

    public void setChirality(int c) {
        this.mChirality = c;
    }

    public void setHydrogenProtection(boolean protectHydrogen) {
        this.mProtectHydrogen = protectHydrogen;
    }

    public void setHelperValidity(int helperValidity) {
        this.mValidHelperArrays = helperValidity;
    }

    public void setToRacemate() {
        this.mIsRacemate = true;
    }

    public void setAtomCustomLabel(int atom, byte[] label) {
        if (label != null && label.length == 0) {
            label = null;
        }
        if (label == null) {
            if (this.mAtomCustomLabel != null) {
                this.mAtomCustomLabel[atom] = null;
            }
        } else {
            if (this.mAtomCustomLabel == null) {
                this.mAtomCustomLabel = new byte[this.mMaxAtoms][];
            }
            this.mAtomCustomLabel[atom] = label;
        }
    }

    public void setAtomCustomLabel(int atom, String label) {
        if (label != null) {
            if (label.length() == 0) {
                label = null;
            } else {
                int atomicNo = Molecule.getAtomicNoFromLabel(label);
                if (atomicNo != 0 && label.equals(cAtomLabel[atomicNo]) || label.equals("?")) {
                    this.setAtomicNo(atom, atomicNo);
                    label = null;
                }
            }
        }
        if (label == null) {
            if (this.mAtomCustomLabel != null) {
                this.mAtomCustomLabel[atom] = null;
            }
        } else {
            if (this.mAtomCustomLabel == null) {
                this.mAtomCustomLabel = new byte[this.mMaxAtoms][];
            }
            this.mAtomCustomLabel[atom] = label.getBytes();
        }
    }

    public void setAtomESR(int atom, int type, int group) {
        if (type == 0) {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFC07FFFF;
            int n2 = atom;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] | type << 19;
        } else {
            if (group >= 32) {
                return;
            }
            if (group == -1) {
                int i;
                int maxGroup = -1;
                for (i = 0; i < this.mAllAtoms; ++i) {
                    if (i == atom || type != this.getAtomESRType(i) || maxGroup >= this.getAtomESRGroup(i)) continue;
                    maxGroup = this.getAtomESRGroup(i);
                }
                for (i = 0; i < this.mAllBonds; ++i) {
                    if (type != this.getBondESRType(i) || maxGroup >= this.getBondESRGroup(i)) continue;
                    maxGroup = this.getBondESRGroup(i);
                }
                group = maxGroup + 1;
                if (group >= 32) {
                    return;
                }
            }
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFC07FFFF;
            int n3 = atom;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] | (type << 19 | group << 21);
        }
        this.mValidHelperArrays &= 7;
    }

    public void setBondESR(int bond, int type, int group) {
        if (type == 0) {
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFE03FF;
            int n2 = bond;
            this.mBondFlags[n2] = this.mBondFlags[n2] | type << 10;
        } else {
            if (group >= 32) {
                return;
            }
            if (group == -1) {
                int i;
                int maxGroup = -1;
                for (i = 0; i < this.mAllAtoms; ++i) {
                    if (type != this.getAtomESRType(i) || maxGroup >= this.getAtomESRGroup(i)) continue;
                    maxGroup = this.getAtomESRGroup(i);
                }
                for (i = 0; i < this.mAllBonds; ++i) {
                    if (i == bond || type != this.getBondESRType(i) || maxGroup >= this.getBondESRGroup(i)) continue;
                    maxGroup = this.getBondESRGroup(i);
                }
                group = maxGroup + 1;
                if (group >= 32) {
                    return;
                }
            }
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFE03FF;
            int n3 = bond;
            this.mBondFlags[n3] = this.mBondFlags[n3] | (type << 10 | group << 12);
        }
        this.mValidHelperArrays &= 7;
    }

    public void setFragment(boolean isFragment) {
        if (this.mIsFragment != isFragment) {
            this.mIsFragment = isFragment;
            if (!isFragment) {
                this.removeQueryFeatures();
            }
            this.mValidHelperArrays = 0;
        }
    }

    public void setName(String name) {
        this.mName = name;
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void setUserData(Object userData) {
        this.mUserData = userData;
    }

    public boolean removeQueryFeatures() {
        int atom;
        boolean isChanged = false;
        for (atom = 0; atom < this.mAllAtoms; ++atom) {
            if ((this.mAtomQueryFeatures[atom] & 0x20000000L) == 0L) continue;
            this.markAtomForDeletion(atom);
            isChanged = true;
        }
        if (isChanged) {
            this.deleteMarkedAtomsAndBonds();
        }
        if (this.mAtomList != null) {
            this.mAtomList = null;
            isChanged = true;
        }
        for (atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.mAtomQueryFeatures[atom] == 0L) continue;
            this.mAtomQueryFeatures[atom] = 0L;
            isChanged = true;
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            if (this.mBondQueryFeatures[bond] != 0) {
                this.mBondQueryFeatures[bond] = 0;
                isChanged = true;
            }
            if (this.mBondType[bond] != 64) continue;
            this.mBondType[bond] = 1;
            isChanged = true;
        }
        if (isChanged) {
            this.mValidHelperArrays = 0;
        }
        return isChanged;
    }

    protected void setStereoProblem(int atom) {
        int n = atom;
        this.mAtomFlags[n] = this.mAtomFlags[n] | 0x20000;
    }

    public boolean stripIsotopInfo() {
        boolean found = false;
        boolean hydrogenIsotopFound = false;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.mAtomMass[atom] == 0) continue;
            this.mAtomMass[atom] = 0;
            found = true;
            if (this.mAtomicNo[atom] != 1) continue;
            hydrogenIsotopFound = true;
        }
        if (hydrogenIsotopFound) {
            this.mValidHelperArrays = 0;
        }
        return found;
    }

    public void translateCoords(double dx, double dy) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            this.mCoordinates[i].x += dx;
            this.mCoordinates[i].y += dy;
        }
        this.mZoomRotationX += dx;
        this.mZoomRotationY += dy;
    }

    public void scaleCoords(double f) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            this.mCoordinates[i].x *= f;
            this.mCoordinates[i].y *= f;
        }
    }

    public void zoomAndRotateInit(double x, double y) {
        this.mZoomRotationX = x;
        this.mZoomRotationY = y;
        this.mOriginalAngle = new double[this.mAllAtoms];
        this.mOriginalDistance = new double[this.mAllAtoms];
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            double dx = x - this.mCoordinates[atom].x;
            double dy = y - this.mCoordinates[atom].y;
            this.mOriginalDistance[atom] = Math.sqrt(dx * dx + dy * dy);
            this.mOriginalAngle[atom] = Molecule.getAngle(x, y, this.mCoordinates[atom].x, this.mCoordinates[atom].y);
        }
    }

    public void zoomAndRotate(double zoom, double angle, boolean selected) {
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (selected && !this.isSelectedAtom(atom)) continue;
            double newDistance = this.mOriginalDistance[atom] * zoom;
            double newAngle = this.mOriginalAngle[atom] - angle;
            this.mCoordinates[atom].x = this.mZoomRotationX + newDistance * Math.sin(newAngle);
            this.mCoordinates[atom].y = this.mZoomRotationY + newDistance * Math.cos(newAngle);
        }
        if (selected) {
            this.mValidHelperArrays &= 7;
        }
    }

    private int getMaximumBondOrder(int bond) {
        int maxBondOrder = 3;
        for (int i = 0; i < 2; ++i) {
            int atom = this.mBondAtom[i][bond];
            int max = this.getBondOrder(bond) + this.getMaxValence(atom) - this.getOccupiedValence(atom);
            if (maxBondOrder <= max) continue;
            maxBondOrder = max;
        }
        return maxBondOrder;
    }

    private boolean incrementBondOrder(int bond) {
        int startBond;
        int maxBondOrder = this.getMaximumBondOrder(bond);
        boolean hasMetal = this.isMetalAtom(this.mBondAtom[0][bond]) || this.isMetalAtom(this.mBondAtom[1][bond]);
        int n = startBond = hasMetal ? 32 : 1;
        if (this.mBondType[bond] == 4) {
            this.mBondType[bond] = startBond;
            this.mValidHelperArrays = 0;
            return true;
        }
        if (this.mBondType[bond] == 2) {
            this.mBondType[bond] = 26;
            this.mValidHelperArrays &= 7;
            if ((this.mBondFlags[bond] & 0x80) == 0) {
                return true;
            }
        }
        if (this.mBondType[bond] == 26) {
            this.mBondType[bond] = maxBondOrder == 3 ? 4 : startBond;
            this.mValidHelperArrays = 0;
            return true;
        }
        if ((0x18 & this.mBondType[bond]) != 0) {
            this.mBondType[bond] = 1;
            this.mValidHelperArrays &= 7;
            return true;
        }
        if (!hasMetal && maxBondOrder < 2) {
            return false;
        }
        if (this.mBondType[bond] == 1) {
            this.mBondType[bond] = 2;
            this.mValidHelperArrays = 0;
            return true;
        }
        if (maxBondOrder < 1) {
            return false;
        }
        if (this.mBondType[bond] == 32) {
            this.mBondType[bond] = 1;
            this.mValidHelperArrays = 0;
            return true;
        }
        return false;
    }

    protected boolean validateBondType(int bond, int type) {
        int simpleType = type & 0x67;
        int maxBondOrder = this.getMaximumBondOrder(bond);
        switch (simpleType) {
            case 1: 
            case 64: {
                return maxBondOrder >= 1;
            }
            case 2: {
                return maxBondOrder >= 2;
            }
            case 4: {
                return maxBondOrder >= 3;
            }
            case 32: {
                return true;
            }
        }
        return false;
    }

    protected int getOccupiedValence(int atom) {
        return this.simpleGetValence(atom);
    }

    private int simpleGetValence(int atom) {
        int val = 0;
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            if (this.mBondAtom[0][bnd] != atom && this.mBondAtom[1][bnd] != atom) continue;
            val += this.getBondOrder(bnd);
        }
        return val;
    }

    public int getMaxValenceUncharged(int atom) {
        int valence = this.getAtomAbnormalValence(atom);
        if (valence == -1) {
            valence = this.getDefaultMaxValenceUncharged(atom);
        }
        return valence;
    }

    public int getDefaultMaxValenceUncharged(int atom) {
        byte[] valenceList = this.mAtomicNo[atom] < cAtomValence.length ? cAtomValence[this.mAtomicNo[atom]] : null;
        return valenceList == null ? 6 : valenceList[valenceList.length - 1];
    }

    public int getMaxValence(int atom) {
        int valence = this.getMaxValenceUncharged(atom);
        return valence + this.getElectronValenceCorrection(atom, valence);
    }

    public int getElectronValenceCorrection(int atom, int occupiedValence) {
        int charge;
        if (this.mAtomicNo[atom] >= 171 && this.mAtomicNo[atom] <= 190) {
            return 0;
        }
        int correction = 0;
        if ((this.mAtomFlags[atom] & 0x30) == 32) {
            --correction;
        }
        if ((this.mAtomFlags[atom] & 0x30) == 16 || (this.mAtomFlags[atom] & 0x30) == 48) {
            correction -= 2;
        }
        if ((charge = this.mAtomCharge[atom]) == 0 && this.mIsFragment) {
            if ((this.mAtomQueryFeatures[atom] & 0xE000000L) == 0xC000000L) {
                charge = -1;
            }
            if ((this.mAtomQueryFeatures[atom] & 0xE000000L) == 0x6000000L) {
                charge = 1;
            }
        }
        correction = this.mAtomicNo[atom] == 7 || this.mAtomicNo[atom] == 8 || this.mAtomicNo[atom] == 9 ? (correction += charge) : (this.mAtomicNo[atom] == 6 || this.mAtomicNo[atom] == 14 || this.mAtomicNo[atom] == 32 ? (correction -= Math.abs(charge)) : (this.mAtomicNo[atom] == 15 || this.mAtomicNo[atom] == 33 ? (occupiedValence - correction - charge <= 3 ? (correction += charge) : (correction -= charge)) : (this.mAtomicNo[atom] == 16 || this.mAtomicNo[atom] == 34 || this.mAtomicNo[atom] == 52 ? (occupiedValence - correction - charge <= 4 ? (correction += charge) : (correction -= Math.abs(charge))) : (this.mAtomicNo[atom] == 17 || this.mAtomicNo[atom] == 35 || this.mAtomicNo[atom] == 53 ? (occupiedValence - correction - charge <= 5 ? (correction += charge) : (correction -= Math.abs(charge))) : (correction -= charge)))));
        return correction;
    }

    public static boolean isAtomicNoElectronegative(int atomicNo) {
        switch (atomicNo) {
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 34: 
            case 35: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    public boolean isElectronegative(int atom) {
        return Molecule.isAtomicNoElectronegative(this.mAtomicNo[atom]);
    }

    public static boolean isAtomicNoElectropositive(int atomicNo) {
        if (atomicNo == 1 || atomicNo == 6) {
            return false;
        }
        if (Molecule.isAtomicNoElectronegative(atomicNo)) {
            return false;
        }
        if (atomicNo == 2 || atomicNo == 10 || atomicNo == 18 || atomicNo == 36 || atomicNo == 54) {
            return false;
        }
        return atomicNo <= 103;
    }

    public boolean isElectropositive(int atom) {
        return Molecule.isAtomicNoElectropositive(this.mAtomicNo[atom]);
    }

    public boolean isMetalAtom(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo >= 3 && atomicNo <= 4 || atomicNo >= 11 && atomicNo <= 13 || atomicNo >= 19 && atomicNo <= 31 || atomicNo >= 37 && atomicNo <= 51 || atomicNo >= 55 && atomicNo <= 84 || atomicNo >= 87 && atomicNo <= 103;
    }

    public boolean isOrganicAtom(int atom) {
        int atomicNo = this.mAtomicNo[atom];
        return atomicNo == 1 || atomicNo >= 5 && atomicNo <= 9 || atomicNo >= 14 && atomicNo <= 17 || atomicNo >= 32 && atomicNo <= 35 || atomicNo >= 52 && atomicNo <= 53;
    }

    public void removeAtomMapping(boolean keepManualMapping) {
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (keepManualMapping && this.mAtomMapNo[atom] >= 0) continue;
            this.mAtomMapNo[atom] = 0;
        }
    }

    protected void removeMappingNo(int mapNo) {
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (Math.abs(this.mAtomMapNo[atom]) != Math.abs(mapNo)) continue;
            this.mAtomMapNo[atom] = 0;
        }
    }

    protected int[] compressMolTable() {
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            int atom2;
            int atom1;
            if (this.mBondType[bnd] != 128 || !(this.mAtomicNo[atom1 = this.mBondAtom[0][bnd]] == -1 ^ this.mAtomicNo[atom2 = this.mBondAtom[1][bnd]] == -1) || this.mAtomCharge[atom1] == 0 || this.mAtomCharge[atom2] == 0 || !(this.mAtomCharge[atom1] < 0 ^ this.mAtomCharge[atom2] < 0)) continue;
            if (this.mAtomCharge[atom1] < 0) {
                int n = atom1;
                this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
                int n2 = atom2;
                this.mAtomCharge[n2] = this.mAtomCharge[n2] - 1;
                continue;
            }
            int n = atom1;
            this.mAtomCharge[n] = this.mAtomCharge[n] - 1;
            int n3 = atom2;
            this.mAtomCharge[n3] = this.mAtomCharge[n3] + 1;
        }
        int[] newAtmNo = new int[this.mAllAtoms];
        int atomDest = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.mAtomicNo[atom] == -1) {
                newAtmNo[atom] = -1;
                continue;
            }
            if (atomDest < atom) {
                this.mAtomicNo[atomDest] = this.mAtomicNo[atom];
                this.mAtomCharge[atomDest] = this.mAtomCharge[atom];
                this.mAtomMass[atomDest] = this.mAtomMass[atom];
                this.mAtomFlags[atomDest] = this.mAtomFlags[atom];
                this.mAtomQueryFeatures[atomDest] = this.mAtomQueryFeatures[atom];
                this.mAtomMapNo[atomDest] = this.mAtomMapNo[atom];
                this.mCoordinates[atomDest].set(this.mCoordinates[atom]);
                if (this.mAtomList != null) {
                    this.mAtomList[atomDest] = this.mAtomList[atom];
                }
                if (this.mAtomCustomLabel != null) {
                    this.mAtomCustomLabel[atomDest] = this.mAtomCustomLabel[atom];
                }
            }
            newAtmNo[atom] = atomDest++;
        }
        this.mAllAtoms = atomDest;
        int bondDest = 0;
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            if (this.mBondType[bnd] == 128) continue;
            this.mBondType[bondDest] = this.mBondType[bnd];
            this.mBondFlags[bondDest] = this.mBondFlags[bnd];
            this.mBondQueryFeatures[bondDest] = this.mBondQueryFeatures[bnd];
            this.mBondAtom[0][bondDest] = newAtmNo[this.mBondAtom[0][bnd]];
            this.mBondAtom[1][bondDest] = newAtmNo[this.mBondAtom[1][bnd]];
            ++bondDest;
        }
        this.mAllBonds = bondDest;
        return newAtmNo;
    }

    private void polygon(int atom, int bonds, int endAtm, boolean aromatic, double actlAngle, double angleChange) {
        int bnd;
        double bondLength;
        if (atom == endAtm) {
            bondLength = this.getAverageBondLength();
        } else {
            double xdiff = this.mCoordinates[atom].x - this.mCoordinates[endAtm].x;
            double ydiff = this.mCoordinates[atom].y - this.mCoordinates[endAtm].y;
            bondLength = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        }
        int actlAtm = atom;
        boolean dblBnd = this.simpleGetValence(atom) != 3;
        for (int step = 1; step < bonds; ++step) {
            double newx = this.mCoordinates[actlAtm].x + bondLength * Math.sin(actlAngle);
            double newy = this.mCoordinates[actlAtm].y + bondLength * Math.cos(actlAngle);
            int remoteAtm = -1;
            for (int i = 0; i < this.mAllAtoms; ++i) {
                if (!(Math.abs(newx - this.mCoordinates[i].x) < 4.0) || !(Math.abs(newy - this.mCoordinates[i].y) < 4.0)) continue;
                remoteAtm = i;
                break;
            }
            if (remoteAtm == -1) {
                remoteAtm = this.addAtom(newx, newy);
                this.mCoordinates[remoteAtm].x = newx;
                this.mCoordinates[remoteAtm].y = newy;
                this.mCoordinates[remoteAtm].z = 0.0;
            }
            if ((bnd = this.getBondNo(actlAtm, remoteAtm)) == -1) {
                bnd = this.addBond(actlAtm, remoteAtm, this.suggestBondType(actlAtm, remoteAtm));
                if (aromatic) {
                    if (dblBnd && this.simpleGetValence(this.mBondAtom[0][bnd]) < 4 && this.simpleGetValence(this.mBondAtom[1][bnd]) < 3) {
                        this.mBondType[bnd] = 2;
                    }
                    dblBnd = !dblBnd;
                }
            }
            actlAtm = remoteAtm;
            actlAngle += angleChange;
        }
        bnd = this.getBondNo(actlAtm, endAtm);
        if (bnd == -1) {
            bnd = this.addBond(actlAtm, endAtm, this.suggestBondType(actlAtm, endAtm));
        }
        if (aromatic && dblBnd && this.simpleGetValence(this.mBondAtom[0][bnd]) < 4 && this.simpleGetValence(this.mBondAtom[1][bnd]) < 4) {
            this.mBondType[bnd] = 2;
        }
    }

    private int getBondNo(int atm1, int atm2) {
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            if ((this.mBondAtom[0][bnd] != atm1 || this.mBondAtom[1][bnd] != atm2) && (this.mBondAtom[0][bnd] != atm2 || this.mBondAtom[1][bnd] != atm1) || this.mBondType[bnd] == 128) continue;
            return bnd;
        }
        return -1;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.mAllAtoms);
        stream.writeInt(this.mAllBonds);
        stream.writeBoolean(this.mIsFragment);
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            int i;
            stream.writeInt(this.mAtomicNo[atom]);
            stream.writeInt(this.mAtomCharge[atom]);
            stream.writeInt(this.mAtomMass[atom]);
            stream.writeInt(this.mAtomFlags[atom] & 0xF7FC03F0);
            stream.writeLong(this.mAtomQueryFeatures[atom]);
            stream.writeDouble(this.mCoordinates[atom].x);
            stream.writeDouble(this.mCoordinates[atom].y);
            stream.writeDouble(this.mCoordinates[atom].z);
            stream.writeInt(this.mAtomMapNo[atom]);
            if (this.mAtomList != null && this.mAtomList[atom] != null) {
                stream.writeInt(this.mAtomList[atom].length);
                for (i = 0; i < this.mAtomList[atom].length; ++i) {
                    stream.writeInt(this.mAtomList[atom][i]);
                }
            } else {
                stream.writeInt(0);
            }
            if (this.mAtomCustomLabel != null && this.mAtomCustomLabel[atom] != null) {
                stream.writeInt(this.mAtomCustomLabel[atom].length);
                for (i = 0; i < this.mAtomCustomLabel[atom].length; ++i) {
                    stream.writeByte(this.mAtomCustomLabel[atom][i]);
                }
                continue;
            }
            stream.writeInt(0);
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            stream.writeInt(this.mBondAtom[0][bond]);
            stream.writeInt(this.mBondAtom[1][bond]);
            stream.writeInt(this.mBondType[bond]);
            stream.writeInt(this.mBondFlags[bond]);
            stream.writeInt(this.mBondQueryFeatures[bond]);
        }
        stream.writeObject(this.mName);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.mAllAtoms = stream.readInt();
        this.mAllBonds = stream.readInt();
        this.mMaxAtoms = this.mAllAtoms;
        this.mMaxBonds = this.mAllBonds;
        this.init();
        this.mIsFragment = stream.readBoolean();
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            int i;
            this.mAtomicNo[atom] = stream.readInt();
            this.mAtomCharge[atom] = stream.readInt();
            this.mAtomMass[atom] = stream.readInt();
            this.mAtomFlags[atom] = stream.readInt();
            this.mAtomQueryFeatures[atom] = stream.readInt();
            this.mCoordinates[atom].set(stream.readDouble(), stream.readDouble(), stream.readDouble());
            this.mAtomMapNo[atom] = stream.readInt();
            int count = stream.readInt();
            if (count != 0) {
                if (this.mAtomList == null) {
                    this.mAtomList = new int[this.mMaxAtoms][];
                }
                this.mAtomList[atom] = new int[count];
                for (i = 0; i < count; ++i) {
                    this.mAtomList[atom][i] = stream.readInt();
                }
            }
            if ((count = stream.readInt()) == 0) continue;
            if (this.mAtomCustomLabel == null) {
                this.mAtomCustomLabel = new byte[this.mMaxAtoms][];
            }
            this.mAtomCustomLabel[atom] = new byte[count];
            for (i = 0; i < count; ++i) {
                this.mAtomCustomLabel[atom][i] = stream.readByte();
            }
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            this.mBondAtom[0][bond] = stream.readInt();
            this.mBondAtom[1][bond] = stream.readInt();
            this.mBondType[bond] = stream.readInt();
            this.mBondFlags[bond] = stream.readInt();
            this.mBondQueryFeatures[bond] = stream.readInt();
        }
        try {
            this.mName = (String)stream.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mValidHelperArrays = 0;
    }
}

