/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Molecule3D
extends StereoMolecule
implements Comparable<Molecule3D> {
    public static final int RIGID = 1;
    public static final int LIGAND = 2;
    public static final int BACKBONE = 4;
    public static final int FLAG1 = 8;
    public static final int IMPORTANT = 16;
    public static final int PREOPTIMIZED = 32;
    public static final int ATTACHED_HYDROGEN_COUNT = 960;
    public static final int ATTACHED_HYDROGEN_COUNT_SHIFT = 6;
    public static final int INFO_DESCRIPTION = 0;
    public static final int INFO_ATOMSEQUENCE = 1;
    public static final int INFO_INTERACTION_ATOM_TYPE = 2;
    public static final int INFO_ATOMNAME = 3;
    public static final int INFO_AMINO = 4;
    public static final int INFO_PPP = 5;
    public static final int INFO_CHAINID = 6;
    public static final int INFO_BFACTOR = 7;
    public static final int INFO_RESSEQUENCE = 8;
    private static final int MAX_INFOS = 9;
    private int nMovables = -1;
    private final Map<String, Object> auxiliaryInfos = new HashMap<String, Object>();
    private int[] atomFlags;
    private Object[][] infos;
    private double[] partialCharges;

    public Molecule3D(Molecule3D mol) {
        super(mol);
        this.auxiliaryInfos.putAll(mol.auxiliaryInfos);
        this.atomFlags = new int[mol.getMaxAtoms()];
        this.partialCharges = new double[mol.getMaxAtoms()];
        this.infos = new Object[mol.getMaxAtoms()][9];
        for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
            this.atomFlags[atom] = mol.atomFlags[atom];
            this.partialCharges[atom] = mol.partialCharges[atom];
            for (int i = 0; i < 9; ++i) {
                this.infos[atom][i] = mol.infos[atom][i];
            }
        }
    }

    public Molecule3D(StereoMolecule mol) {
        super(mol);
        this.atomFlags = new int[mol.getMaxAtoms()];
        this.partialCharges = new double[mol.getMaxAtoms()];
        this.infos = new Object[mol.getMaxAtoms()][9];
    }

    public Molecule3D() {
        this(5, 5);
    }

    public Molecule3D(int a, int b) {
        super(a, b);
        this.setName("Molecule");
        this.atomFlags = new int[a];
        this.partialCharges = new double[a];
        this.infos = new Object[a][9];
    }

    @Override
    public int getOccupiedValence(int atom) {
        return super.getOccupiedValence(atom) + this.getAttachedHydrogenCount(atom);
    }

    public int getAttachedHydrogenCount(int atom) {
        return (this.atomFlags[atom] & 0x3C0) >> 6;
    }

    public void setAttachedHydrogenCount(int atom, int value) {
        int n = atom;
        this.atomFlags[n] = this.atomFlags[n] | value << 6;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : "";
    }

    @Override
    public void clear() {
        super.deleteMolecule();
    }

    public final void setAtomFlag(int atm, int flag, boolean value) {
        this.nMovables = -1;
        if (value) {
            int n = atm;
            this.atomFlags[n] = this.atomFlags[n] | flag;
        } else {
            int n = atm;
            this.atomFlags[n] = this.atomFlags[n] & ~flag;
        }
    }

    public final boolean isAtomFlag(int atm, int flag) {
        return (this.atomFlags[atm] & flag) != 0;
    }

    public final int getAtomFlags(int atm) {
        return this.atomFlags[atm];
    }

    public final void setAtomFlags(int atm, int flags) {
        this.nMovables = -1;
        this.atomFlags[atm] = flags;
    }

    public final void setAllAtomFlag(int flag, boolean value) {
        this.nMovables = -1;
        for (int i = 0; i < this.getAllAtoms(); ++i) {
            this.setAtomFlag(i, flag, value);
        }
    }

    public int fusion(Molecule3D m2) {
        int i;
        if (m2 == this) {
            throw new IllegalArgumentException("Cannot fusion a molecule with itself");
        }
        int index = this.getAllAtoms();
        int[] oldToNew = new int[m2.getAllAtoms()];
        for (i = 0; i < m2.getAllAtoms(); ++i) {
            oldToNew[i] = this.addAtom(m2, i);
        }
        for (i = 0; i < m2.getAllBonds(); ++i) {
            this.addBond(oldToNew[m2.getBondAtom(0, i)], oldToNew[m2.getBondAtom(1, i)], m2.getBondOrder(i));
        }
        return index;
    }

    @Override
    public void setBondOrder(int bond, int order) {
        if (order == 1) {
            super.setBondType(bond, 1);
        } else if (order == 2) {
            super.setBondType(bond, 2);
        } else if (order == 3) {
            super.setBondType(bond, 4);
        } else {
            System.out.println("ERROR: Unusual bond order:" + order);
        }
    }

    public final void setAtomDescription(int atm, String s) {
        this.infos[atm][0] = s;
    }

    public final String getAtomDescription(int atm) {
        return (String)this.infos[atm][0];
    }

    public final void setPPP(int atm, int[] a) {
        this.infos[atm][5] = a;
    }

    public final int[] getPPP(int atm) {
        return (int[])this.infos[atm][5];
    }

    public final void setAtomSequence(int atm, int a) {
        this.infos[atm][1] = a;
    }

    public final void setResSequence(int atm, int a) {
        this.infos[atm][8] = a;
    }

    public final int getResSequence(int atm) {
        return this.infos[atm][8] == null ? -1 : (Integer)this.infos[atm][8];
    }

    public final int getAtomSequence(int atm) {
        return this.infos[atm][1] == null ? -1 : (Integer)this.infos[atm][1];
    }

    public final void setAtomChainId(int atm, String a) {
        this.infos[atm][6] = a;
    }

    public final String getAtomChainId(int atm) {
        return (String)this.infos[atm][6];
    }

    public final void setAtomName(int atm, String a) {
        this.infos[atm][3] = a;
    }

    public final String getAtomName(int atm) {
        return (String)this.infos[atm][3];
    }

    public final void setAtomAmino(int atm, String a) {
        this.infos[atm][4] = a;
    }

    public final String getAtomAmino(int atm) {
        return (String)this.infos[atm][4];
    }

    public final double getAtomBfactor(int atm) {
        return (Double)this.infos[atm][7];
    }

    public final void setAtomBfactor(int atm, double bfactor) {
        this.infos[atm][7] = bfactor;
    }

    @Override
    public final int getBond(int a1, int a2) {
        for (int connBond = 0; connBond < this.getAllConnAtomsPlusMetalBonds(a1); ++connBond) {
            if (this.getConnAtom(a1, connBond) != a2) continue;
            return this.getConnBond(a1, connBond);
        }
        return -1;
    }

    public final Coordinates[] getCoordinates() {
        Coordinates[] coords = new Coordinates[this.getAtoms()];
        for (int i = 0; i < this.getAtoms(); ++i) {
            coords[i] = this.getCoordinates(i);
        }
        return coords;
    }

    public final void deleteAtoms(List<Integer> atomsToBeDeleted) {
        Collections.sort(atomsToBeDeleted);
        for (int i = atomsToBeDeleted.size() - 1; i >= 0; --i) {
            this.deleteAtom(atomsToBeDeleted.get(i));
        }
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name == null ? "" : name;
    }

    public String getShortName() {
        String name = this.getName();
        if (name.indexOf(32) > 0) {
            name = name.substring(0, name.indexOf(32));
        }
        if (name.length() > 12) {
            name = name.substring(0, 12);
        }
        return name;
    }

    public Map<String, Object> getAuxiliaryInfos() {
        return this.auxiliaryInfos;
    }

    public Object getAuxiliaryInfo(String name) {
        return this.auxiliaryInfos.get(name);
    }

    public void setAuxiliaryInfo(String name, Object value) {
        if (value == null) {
            System.err.println("Attempt to set " + name + " to null");
            this.auxiliaryInfos.remove(name);
        } else {
            this.auxiliaryInfos.put(name, value);
        }
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public final void setInteractionAtomType(int atm, int type) {
        this.infos[atm][2] = type;
    }

    public final int getInteractionAtomType(int atm) {
        return (Integer)this.infos[atm][2];
    }

    @Override
    public void setMaxAtoms(int v) {
        super.setMaxAtoms(v);
        int u = this.atomFlags.length;
        this.atomFlags = Arrays.copyOf(this.atomFlags, v);
        this.partialCharges = Arrays.copyOf(this.partialCharges, v);
        this.infos = (Object[][])Arrays.copyOf(this.infos, v);
        for (int i = u; i < v; ++i) {
            this.infos[i] = new Object[9];
        }
    }

    @Override
    public int copyAtom(Molecule destMol, int sourceAtom, int esrGroupOffsetAND, int esrGroupOffsetOR) {
        int destAtom = super.copyAtom(destMol, sourceAtom, esrGroupOffsetAND, esrGroupOffsetOR);
        if (destMol instanceof Molecule3D) {
            if (((Molecule3D)destMol).atomFlags != null) {
                ((Molecule3D)destMol).atomFlags[destAtom] = this.atomFlags[sourceAtom];
            }
            if (((Molecule3D)destMol).partialCharges != null) {
                ((Molecule3D)destMol).partialCharges[destAtom] = this.partialCharges[sourceAtom];
            }
            if (((Molecule3D)destMol).infos != null) {
                ((Molecule3D)destMol).infos[destAtom] = new Object[9];
                for (int i = 0; i < this.infos[sourceAtom].length; ++i) {
                    ((Molecule3D)destMol).infos[destAtom][i] = this.clone(this.infos[sourceAtom][i]);
                }
            }
        }
        return destAtom;
    }

    private Object clone(Object o) {
        Object newObject = null;
        if (o != null) {
            if (o instanceof String) {
                newObject = new String((String)o);
            } else if (o instanceof Integer) {
                newObject = new Integer((Integer)o);
            } else if (o instanceof Double) {
                newObject = new Double((Double)o);
            } else {
                System.out.println("ERROR: unexpected Object type. Add support for new type: " + o.toString());
            }
        }
        return newObject;
    }

    public void compact() {
        this.setMaxAtoms(this.getAllAtoms());
        this.setMaxBonds(this.getAllBonds());
    }

    @Override
    public void swapAtoms(int atom1, int atom2) {
        super.swapAtoms(atom1, atom2);
        int tempi = this.atomFlags[atom1];
        this.atomFlags[atom1] = this.atomFlags[atom2];
        this.atomFlags[atom2] = tempi;
        double tempd = this.partialCharges[atom1];
        this.partialCharges[atom1] = this.partialCharges[atom2];
        this.partialCharges[atom2] = tempd;
        Object[] tempo = this.infos[atom1];
        this.infos[atom1] = this.infos[atom2];
        this.infos[atom2] = tempo;
    }

    @Override
    public int addAtom(int atomicNo) {
        if (this.mAllAtoms > this.mMaxAtoms) {
            this.setMaxAtoms(this.mMaxAtoms * 2);
        }
        int atom = super.addAtom(atomicNo);
        this.atomFlags[atom] = 0;
        this.partialCharges[atom] = 0.0;
        this.infos[atom] = new Object[9];
        return atom;
    }

    public int addAtom(Molecule3D m, int i) {
        int a = this.addAtom(m.getAtomicNo(i));
        this.atomFlags[a] = m.getAtomFlags(i);
        this.partialCharges[a] = m.getPartialCharge(i);
        this.infos[a] = (Object[])m.infos[i].clone();
        this.setAtomX(i, this.getAtomX(i));
        this.setAtomY(i, this.getAtomY(i));
        this.setAtomZ(i, this.getAtomZ(i));
        return a;
    }

    @Override
    public void deleteAtom(int atom) {
        super.deleteAtom(atom);
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    @Override
    protected int[] compressMolTable() {
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            int atom2;
            int atom1;
            if (this.mBondType[bnd] != 128 || !(this.mAtomicNo[atom1 = this.mBondAtom[0][bnd]] == -1 ^ this.mAtomicNo[atom2 = this.mBondAtom[1][bnd]] == -1) || this.mAtomCharge[atom1] == 0 || this.mAtomCharge[atom2] == 0 || !(this.mAtomCharge[atom1] < 0 ^ this.mAtomCharge[atom2] < 0)) continue;
            if (this.mAtomCharge[atom1] < 0) {
                int n = atom1;
                this.mAtomCharge[n] = this.mAtomCharge[n] + 1;
                int n2 = atom2;
                this.mAtomCharge[n2] = this.mAtomCharge[n2] - 1;
                continue;
            }
            int n = atom1;
            this.mAtomCharge[n] = this.mAtomCharge[n] - 1;
            int n3 = atom2;
            this.mAtomCharge[n3] = this.mAtomCharge[n3] + 1;
        }
        int[] newAtmNo = new int[this.mAllAtoms];
        int atomDest = 0;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            if (this.mAtomicNo[atom] == -1) {
                newAtmNo[atom] = -1;
                continue;
            }
            if (atomDest < atom) {
                this.mAtomicNo[atomDest] = this.mAtomicNo[atom];
                this.mAtomCharge[atomDest] = this.mAtomCharge[atom];
                this.mAtomMass[atomDest] = this.mAtomMass[atom];
                this.mAtomFlags[atomDest] = this.mAtomFlags[atom];
                this.mAtomQueryFeatures[atomDest] = this.mAtomQueryFeatures[atom];
                this.mAtomMapNo[atomDest] = this.mAtomMapNo[atom];
                this.mCoordinates[atomDest].set(this.mCoordinates[atom]);
                this.atomFlags[atomDest] = this.atomFlags[atom];
                if (this.infos[atomDest] == null) {
                    this.infos[atomDest] = new Object[9];
                }
                for (int i = 0; i < this.infos[atom].length; ++i) {
                    this.infos[atomDest][i] = this.clone(this.infos[atom][i]);
                }
                this.partialCharges[atomDest] = this.partialCharges[atom];
                if (this.mAtomList != null) {
                    this.mAtomList[atomDest] = this.mAtomList[atom];
                }
                if (this.mAtomCustomLabel != null) {
                    this.mAtomCustomLabel[atomDest] = this.mAtomCustomLabel[atom];
                }
            }
            newAtmNo[atom] = atomDest++;
        }
        this.mAllAtoms = atomDest;
        int bondDest = 0;
        for (int bnd = 0; bnd < this.mAllBonds; ++bnd) {
            if (this.mBondType[bnd] == 128) continue;
            this.mBondType[bondDest] = this.mBondType[bnd];
            this.mBondFlags[bondDest] = this.mBondFlags[bnd];
            this.mBondQueryFeatures[bondDest] = this.mBondQueryFeatures[bnd];
            this.mBondAtom[0][bondDest] = newAtmNo[this.mBondAtom[0][bnd]];
            this.mBondAtom[1][bondDest] = newAtmNo[this.mBondAtom[1][bnd]];
            ++bondDest;
        }
        this.mAllBonds = bondDest;
        return newAtmNo;
    }

    public boolean reorderAtoms() {
        boolean changed = false;
        int N = this.getAllAtoms();
        int i = 0;
        int j = N - 1;
        if (N == 0) {
            this.nMovables = 0;
            return false;
        }
        while (i < j) {
            while (i < j && !this.isAtomFlag(i, 1)) {
                ++i;
            }
            while (i < j && this.isAtomFlag(j, 1)) {
                --j;
            }
            if (!this.isAtomFlag(i, 1) || this.isAtomFlag(j, 1)) continue;
            this.swapAtoms(i, j);
            changed = true;
        }
        this.nMovables = this.isAtomFlag(i, 1) ? i : i + 1;
        return changed;
    }

    public void setCoordinates(int atom, Coordinates c) {
        this.setAtomX(atom, c.x);
        this.setAtomY(atom, c.y);
        this.setAtomZ(atom, c.z);
    }

    public int getNMovables() {
        if (this.nMovables < 0 || this.getAllAtoms() > 0 && !this.isAtomFlag(0, 2)) {
            this.reorderAtoms();
        }
        return this.nMovables;
    }

    public boolean isMoleculeInOrder() {
        return !this.reorderAtoms();
    }

    public double getPartialCharge(int a) {
        return this.partialCharges[a];
    }

    public void setPartialCharge(int a, double v) {
        this.partialCharges[a] = v;
    }

    @Override
    public int compareTo(Molecule3D o) {
        return o == null ? 1 : this.getName().compareTo(o.getName());
    }
}

