/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;

public class MoleculeStandardizer {
    public static final int MODE_GET_PARENT = 1;
    public static final int MODE_ADD_NA_AND_CL = 2;

    public static StereoMolecule getStandardized(String idcode, String coordinates, int mode) throws Exception {
        StereoMolecule mol = new IDCodeParser().getCompactMolecule(idcode, coordinates);
        MoleculeStandardizer.standardize(mol, mode);
        return mol;
    }

    public static void standardize(StereoMolecule mol, int mode) throws Exception {
        if ((mode & 1) != 0) {
            mol.stripSmallFragments();
            mol.stripIsotopInfo();
        }
        MoleculeStandardizer.repairAndUnify(mol);
        mol.normalizeAmbiguousBonds();
        int remainingCharge = mol.canonizeCharge(true, true);
        if (remainingCharge != 0) {
            MoleculeStandardizer.neutralizeCharges(mol, mode, remainingCharge);
        }
    }

    private static void repairAndUnify(StereoMolecule mol) {
        mol.ensureHelperArrays(7);
        MoleculeStandardizer.repairCovalentBoundChargedAlkaliAndHalogen(mol);
        MoleculeStandardizer.chargeTrivalentOxygen(mol);
        MoleculeStandardizer.repairBadAmideTautomer(mol);
        MoleculeStandardizer.repairQuaternaryNitrogen(mol);
        MoleculeStandardizer.unifyIsoCyano(mol);
        MoleculeStandardizer.unifyAzido(mol);
    }

    private static void neutralizeCharges(StereoMolecule mol, int mode, int totalCharge) {
        int atom;
        mol.ensureHelperArrays(1);
        for (atom = 0; atom < mol.getAllAtoms() && totalCharge > 0; ++atom) {
            if (!AtomFunctionAnalyzer.isAcidicOxygen(mol, atom)) continue;
            mol.setAtomCharge(atom, -1);
            --totalCharge;
        }
        for (atom = 0; atom < mol.getAllAtoms() && totalCharge < 0; ++atom) {
            if (!AtomFunctionAnalyzer.isBasicNitrogen(mol, atom)) continue;
            mol.setAtomCharge(atom, 1);
            ++totalCharge;
        }
        if (totalCharge != 0 && (mode & 2) != 0) {
            int ind;
            for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
                mol.setAtomMarker(atom, true);
            }
            while (totalCharge > 0) {
                ind = mol.addAtom(17);
                mol.setAtomCharge(ind, -1);
                --totalCharge;
            }
            while (totalCharge < 0) {
                ind = mol.addAtom(11);
                mol.setAtomCharge(ind, 1);
                ++totalCharge;
            }
            new CoordinateInventor(6).invent(mol);
        }
    }

    private static void repairCovalentBoundChargedAlkaliAndHalogen(StereoMolecule mol) {
        for (int atom = 0; atom < mol.getAtoms(); ++atom) {
            if (mol.isHalogene(atom)) {
                if (mol.getOccupiedValence(atom) != 1 || mol.getAtomCharge(atom) != -1) continue;
                mol.setAtomCharge(atom, 0);
                mol.setAtomAbnormalValence(atom, -1);
                continue;
            }
            if (mol.isAlkaliMetal(atom)) {
                if (mol.getOccupiedValence(atom) != 1 || mol.getAtomCharge(atom) != 1) continue;
                mol.setAtomCharge(atom, 0);
                mol.setAtomAbnormalValence(atom, -1);
                continue;
            }
            if (!mol.isEarthAlkaliMetal(atom) || mol.getOccupiedValence(atom) != 2 || mol.getAtomCharge(atom) != 2) continue;
            mol.setAtomCharge(atom, 0);
            mol.setAtomAbnormalValence(atom, -1);
        }
    }

    private static void chargeTrivalentOxygen(StereoMolecule mol) {
        for (int atom = 0; atom < mol.getAtoms(); ++atom) {
            if (mol.getAtomicNo(atom) != 8 && mol.getAtomicNo(atom) != 16 || mol.getOccupiedValence(atom) != 3 || mol.getAtomCharge(atom) == 1) continue;
            mol.setAtomCharge(atom, 1);
        }
    }

    private static void repairBadAmideTautomer(StereoMolecule mol) {
        block0: for (int oxygen = 0; oxygen < mol.getAtoms(); ++oxygen) {
            int carbon;
            if (mol.getAtomicNo(oxygen) != 8 || mol.getConnAtoms(oxygen) != 1 || mol.getConnBondOrder(oxygen, 0) != 1 || mol.getAtomicNo(carbon = mol.getConnAtom(oxygen, 0)) != 6 || mol.getAtomPi(carbon) != 1) continue;
            for (int i = 0; i < mol.getConnAtoms(carbon); ++i) {
                int nitrogen;
                if (mol.getConnBondOrder(carbon, i) != 2 || mol.getAtomicNo(nitrogen = mol.getConnAtom(carbon, i)) != 7 || mol.isRingAtom(nitrogen)) continue;
                boolean hasResonance = false;
                for (int j = 0; j < mol.getConnAtoms(nitrogen); ++j) {
                    int connAtom = mol.getConnAtom(nitrogen, j);
                    if (connAtom == carbon || mol.getAtomPi(connAtom) == 0) continue;
                    hasResonance = true;
                    break;
                }
                if (hasResonance) continue;
                mol.setBondType(mol.getConnBond(oxygen, 0), 2);
                mol.setBondType(mol.getConnBond(carbon, i), 1);
                continue block0;
            }
        }
    }

    private static void unifyIsoCyano(StereoMolecule mol) {
        block0: for (int bond = 0; bond < mol.getBonds(); ++bond) {
            if (mol.getBondType(bond) != 4) continue;
            for (int i = 0; i < 2; ++i) {
                int atom1 = mol.getBondAtom(i, bond);
                int atom2 = mol.getBondAtom(1 - i, bond);
                if (mol.getAtomicNo(atom1) != 7 || mol.getConnAtoms(atom1) != 2 || mol.getAtomicNo(atom2) != 6 || mol.getConnAtoms(atom2) != 1) continue;
                if (mol.getAtomCharge(atom1) != 1) {
                    mol.setAtomCharge(atom1, 1);
                }
                if (mol.getAtomCharge(atom2) == -1) continue block0;
                mol.setAtomCharge(atom2, -1);
                continue block0;
            }
        }
    }

    private static void unifyAzido(StereoMolecule mol) {
        block0: for (int atom = 0; atom < mol.getAtoms(); ++atom) {
            if (mol.getAtomicNo(atom) != 7 || mol.getConnAtoms(atom) != 2 || mol.getConnBondOrder(atom, 0) != 2 || mol.getConnBondOrder(atom, 1) != 2 || mol.getAtomicNo(mol.getConnAtom(atom, 0)) != 7 || mol.getAtomicNo(mol.getConnAtom(atom, 1)) != 7) continue;
            for (int i = 0; i < 2; ++i) {
                int atom1 = mol.getConnAtom(atom, i);
                int atom2 = mol.getConnAtom(atom, 1 - i);
                if (mol.getConnAtoms(atom1) != 1 || mol.getConnAtoms(atom2) != 2) continue;
                if (mol.getAtomCharge(atom) != 1) {
                    mol.setAtomCharge(atom, 1);
                }
                if (mol.getAtomCharge(atom1) != -1) {
                    mol.setAtomCharge(atom1, -1);
                }
                if (mol.getAtomCharge(atom2) == 0) continue block0;
                mol.setAtomCharge(atom2, 0);
                continue block0;
            }
        }
    }

    private static void repairQuaternaryNitrogen(StereoMolecule mol) {
        for (int i = 0; i < mol.getAllAtoms(); ++i) {
            if (mol.getAtomicNo(i) != 7 || mol.getOccupiedValence(i) != 4 || mol.getAtomCharge(i) == 1) continue;
            mol.setAtomCharge(i, 1);
        }
    }
}

