/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MolfileCreator {
    private static final float TARGET_AVBL = 1.5f;
    private StringBuilder mBuilder;
    private DecimalFormat mDoubleFormat = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.ENGLISH));

    public MolfileCreator(ExtendedMolecule mol) {
        this(mol, true);
    }

    public MolfileCreator(ExtendedMolecule mol, boolean allowScaling) {
        this(mol, allowScaling, new StringBuilder(32768));
    }

    public MolfileCreator(ExtendedMolecule mol, boolean allowScaling, StringBuilder builder) {
        this(mol, allowScaling, 0.0, builder);
    }

    public MolfileCreator(ExtendedMolecule mol, boolean allowScaling, double scalingFactor, StringBuilder builder) {
        int count;
        int atom;
        int atom2;
        String nl = System.lineSeparator();
        mol.ensureHelperArrays(15);
        boolean isRacemic = true;
        for (int atom3 = 0; atom3 < mol.getAtoms(); ++atom3) {
            if (mol.getAtomParity(atom3) == 0 || mol.getAtomParity(atom3) == 3 || mol.getAtomESRType(atom3) == 1) continue;
            isRacemic = false;
            break;
        }
        int maxESRGroup = -1;
        if (isRacemic) {
            int[] esrGroupCount = new int[32];
            int maxGroupCount = 0;
            for (atom2 = 0; atom2 < mol.getAtoms(); ++atom2) {
                int group;
                if (mol.getAtomParity(atom2) == 0 || mol.getAtomParity(atom2) == 3 || mol.getAtomESRType(atom2) != 1) continue;
                int n = group = mol.getAtomESRGroup(atom2);
                esrGroupCount[n] = esrGroupCount[n] + 1;
                if (maxGroupCount >= esrGroupCount[group]) break;
                maxGroupCount = esrGroupCount[group];
                maxESRGroup = group;
                break;
            }
        }
        this.mBuilder = builder == null ? new StringBuilder() : builder;
        String name = mol.getName() != null ? mol.getName() : "";
        this.mBuilder.append(name + nl);
        this.mBuilder.append("Actelion Java MolfileCreator 1.0" + nl + nl);
        this.appendThreeDigitInt(mol.getAllAtoms());
        this.appendThreeDigitInt(mol.getAllBonds());
        this.mBuilder.append("  0  0");
        this.appendThreeDigitInt(!isRacemic ? 1 : 0);
        this.mBuilder.append("  0  0  0  0  0999 V2000" + nl);
        boolean hasCoordinates = mol.getAllAtoms() == 1;
        for (atom2 = 1; atom2 < mol.getAllAtoms(); ++atom2) {
            if (mol.getAtomX(atom2) == mol.getAtomX(0) && mol.getAtomY(atom2) == mol.getAtomY(0) && mol.getAtomZ(atom2) == mol.getAtomZ(0)) continue;
            hasCoordinates = true;
            break;
        }
        double grafac = 1.0;
        if (hasCoordinates) {
            if (scalingFactor != 0.0) {
                grafac = scalingFactor;
            } else if (allowScaling) {
                double avbl = mol.getAverageBondLength();
                if (avbl != 0.0) {
                    if (avbl < 1.0 || avbl > 3.0) {
                        grafac = 1.5 / avbl;
                    }
                } else {
                    double minDistance = Double.MAX_VALUE;
                    for (int atom1 = 1; atom1 < mol.getAllAtoms(); ++atom1) {
                        for (int atom22 = 0; atom22 < atom1; ++atom22) {
                            double dz;
                            double dy;
                            double dx = mol.getAtomX(atom22) - mol.getAtomX(atom1);
                            double distance = dx * dx + (dy = mol.getAtomY(atom22) - mol.getAtomY(atom1)) * dy + (dz = mol.getAtomZ(atom22) - mol.getAtomZ(atom1)) * dz;
                            if (!(minDistance > distance)) continue;
                            minDistance = distance;
                        }
                    }
                    grafac = 3.0 / minDistance;
                }
            }
        }
        for (int atom4 = 0; atom4 < mol.getAllAtoms(); ++atom4) {
            if (hasCoordinates) {
                this.appendTenDigitDouble(grafac * mol.getAtomX(atom4));
                this.appendTenDigitDouble(grafac * -mol.getAtomY(atom4));
                this.appendTenDigitDouble(grafac * -mol.getAtomZ(atom4));
            } else {
                this.mBuilder.append("    0.0000    0.0000    0.0000");
            }
            if (mol.getAtomList(atom4) != null) {
                this.mBuilder.append(" L  ");
            } else if ((mol.getAtomQueryFeatures(atom4) & 1L) != 0L) {
                this.mBuilder.append(" A  ");
            } else {
                String atomLabel = mol.getAtomLabel(atom4);
                this.mBuilder.append(" " + atomLabel);
                if (atomLabel.length() == 1) {
                    this.mBuilder.append("  ");
                } else if (atomLabel.length() == 2) {
                    this.mBuilder.append(" ");
                }
            }
            this.mBuilder.append(" 0  0  0");
            long hydrogenFlags = 0x780L & mol.getAtomQueryFeatures(atom4);
            if (hydrogenFlags == 0L) {
                this.mBuilder.append("  0");
            } else if (hydrogenFlags == 384L) {
                this.mBuilder.append("  3");
            } else if (hydrogenFlags == 128L) {
                this.mBuilder.append("  2");
            } else if (hydrogenFlags == 1792L) {
                this.mBuilder.append("  1");
            } else if (hydrogenFlags == 1664L) {
                this.mBuilder.append("  2");
            }
            this.mBuilder.append((mol.getAtomQueryFeatures(atom4) & 0x2000L) != 0L ? "  1" : "  0");
            int valence = mol.getAtomAbnormalValence(atom4);
            if (valence == -1) {
                this.mBuilder.append("  0");
            } else if (valence == 0) {
                this.mBuilder.append(" 15");
            } else {
                this.appendThreeDigitInt(valence);
            }
            this.mBuilder.append("  0  0  0");
            this.appendThreeDigitInt(mol.getAtomMapNo(atom4));
            this.mBuilder.append("  0  0" + nl);
        }
        for (int bond = 0; bond < mol.getAllBonds(); ++bond) {
            int ringState;
            int bondType;
            int stereo;
            int order;
            switch (mol.getBondType(bond)) {
                case 1: {
                    order = 1;
                    stereo = 0;
                    break;
                }
                case 2: {
                    order = 2;
                    stereo = 0;
                    break;
                }
                case 4: {
                    order = 3;
                    stereo = 0;
                    break;
                }
                case 9: {
                    order = 1;
                    stereo = 6;
                    break;
                }
                case 17: {
                    order = 1;
                    stereo = 1;
                    break;
                }
                case 26: {
                    order = 2;
                    stereo = 3;
                    break;
                }
                case 64: {
                    order = 4;
                    stereo = 0;
                    break;
                }
                case 32: {
                    order = 8;
                    stereo = 0;
                    break;
                }
                default: {
                    order = 1;
                    stereo = 0;
                }
            }
            if (isRacemic && (stereo == 1 || stereo == 6)) {
                int atom5 = mol.getBondAtom(0, bond);
                if (mol.getAtomESRType(atom5) == 2) {
                    stereo = 0;
                } else if (mol.getAtomESRType(atom5) == 1 && mol.getAtomESRGroup(atom5) != maxESRGroup) {
                    stereo = 4;
                }
            }
            if ((bondType = mol.getBondQueryFeatures(bond) & 0x1F) != 0) {
                order = bondType == 8 ? 4 : (bondType == 3 ? 5 : (bondType == 9 ? 6 : (bondType == 10 ? 7 : 8)));
            }
            int topology = (ringState = mol.getBondQueryFeatures(bond) & 0x60) == 0 ? 0 : (ringState == 64 ? 1 : 2);
            this.appendThreeDigitInt(1 + mol.getBondAtom(0, bond));
            this.appendThreeDigitInt(1 + mol.getBondAtom(1, bond));
            this.appendThreeDigitInt(order);
            this.appendThreeDigitInt(stereo);
            this.mBuilder.append("  0");
            this.appendThreeDigitInt(topology);
            this.mBuilder.append("  0" + nl);
        }
        int no = 0;
        for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
            if (mol.getAtomCharge(atom) == 0) continue;
            ++no;
        }
        if (no != 0) {
            count = 0;
            for (int atom6 = 0; atom6 < mol.getAllAtoms(); ++atom6) {
                if (mol.getAtomCharge(atom6) == 0) continue;
                if (count == 0) {
                    this.mBuilder.append("M  CHG");
                    this.appendThreeDigitInt(Math.min(8, no));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(atom6 + 1);
                int charge = mol.getAtomCharge(atom6);
                if (charge < 0) {
                    this.mBuilder.append("  -");
                    charge = -charge;
                } else {
                    this.mBuilder.append("   ");
                }
                this.mBuilder.append((char)(48 + charge));
                if (++count != 8 && --no != 0) continue;
                count = 0;
                this.mBuilder.append(nl);
            }
        }
        no = 0;
        for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
            if (mol.isNaturalAbundance(atom)) continue;
            ++no;
        }
        if (no != 0) {
            count = 0;
            for (int atom7 = 0; atom7 < mol.getAllAtoms(); ++atom7) {
                if (mol.isNaturalAbundance(atom7)) continue;
                if (count == 0) {
                    this.mBuilder.append("M  ISO");
                    this.appendThreeDigitInt(Math.min(8, no));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(atom7 + 1);
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(mol.getAtomMass(atom7));
                if (++count != 8 && --no != 0) continue;
                count = 0;
                this.mBuilder.append(nl);
            }
        }
        no = 0;
        for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
            if (mol.getAtomRadical(atom) == 0) continue;
            ++no;
        }
        if (no != 0) {
            count = 0;
            for (int atom8 = 0; atom8 < mol.getAllAtoms(); ++atom8) {
                if (mol.getAtomRadical(atom8) == 0) continue;
                if (count == 0) {
                    this.mBuilder.append("M  RAD");
                    this.appendThreeDigitInt(Math.min(8, no));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(atom8 + 1);
                switch (mol.getAtomRadical(atom8)) {
                    case 16: {
                        this.mBuilder.append("   1");
                        break;
                    }
                    case 32: {
                        this.mBuilder.append("   2");
                        break;
                    }
                    case 48: {
                        this.mBuilder.append("   3");
                    }
                }
                if (++count != 8 && --no != 0) continue;
                count = 0;
                this.mBuilder.append(nl);
            }
        }
        if (mol.isFragment()) {
            no = 0;
            for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
                if ((mol.getAtomQueryFeatures(atom) & 0x78L) == 0L) continue;
                ++no;
            }
            if (no != 0) {
                count = 0;
                for (int atom9 = 0; atom9 < mol.getAllAtoms(); ++atom9) {
                    long ringFeatures = mol.getAtomQueryFeatures(atom9) & 0x78L;
                    if (ringFeatures == 0L) continue;
                    if (count == 0) {
                        this.mBuilder.append("M  RBC");
                        this.appendThreeDigitInt(Math.min(8, no));
                    }
                    this.mBuilder.append(" ");
                    this.appendThreeDigitInt(atom9 + 1);
                    if (ringFeatures == 112L) {
                        this.mBuilder.append("  -1");
                    } else if (ringFeatures == 8L) {
                        this.mBuilder.append("   1");
                    } else if (ringFeatures == 104L) {
                        this.mBuilder.append("   2");
                    } else if (ringFeatures == 88L) {
                        this.mBuilder.append("   3");
                    } else if (ringFeatures == 56L) {
                        this.mBuilder.append("   4");
                    }
                    if (++count != 8 && --no != 0) continue;
                    count = 0;
                    this.mBuilder.append(nl);
                }
            }
            for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
                int[] atomList = mol.getAtomList(atom);
                if (atomList == null) continue;
                this.mBuilder.append("M  ALS ");
                this.appendThreeDigitInt(atom + 1);
                this.appendThreeDigitInt(atomList.length);
                this.mBuilder.append((mol.getAtomQueryFeatures(atom) & 1L) != 0L ? " T " : " F ");
                block36: for (int i = 0; i < atomList.length; ++i) {
                    String label = Molecule.cAtomLabel[atomList[i]];
                    switch (label.length()) {
                        case 1: {
                            this.mBuilder.append(label + "   ");
                            continue block36;
                        }
                        case 2: {
                            this.mBuilder.append(label + "  ");
                            continue block36;
                        }
                        case 3: {
                            this.mBuilder.append(label + " ");
                            continue block36;
                        }
                        default: {
                            this.mBuilder.append("   ?");
                        }
                    }
                }
                this.mBuilder.append(nl);
            }
            no = 0;
            for (atom = 0; atom < mol.getAllAtoms(); ++atom) {
                if ((mol.getAtomQueryFeatures(atom) & 0x1800L) == 0L) continue;
                ++no;
            }
            if (no != 0) {
                count = 0;
                for (int atom10 = 0; atom10 < mol.getAllAtoms(); ++atom10) {
                    long substitution = mol.getAtomQueryFeatures(atom10) & 0x1800L;
                    if (substitution == 0L) continue;
                    if (count == 0) {
                        this.mBuilder.append("M  SUB");
                        this.appendThreeDigitInt(Math.min(8, no));
                    }
                    this.mBuilder.append(" ");
                    this.appendThreeDigitInt(atom10 + 1);
                    if ((substitution & 0x1000L) != 0L) {
                        this.mBuilder.append("   " + (mol.getAllConnAtoms(atom10) + 1));
                    } else {
                        this.mBuilder.append("  -2");
                    }
                    if (++count != 8 && --no != 0) continue;
                    count = 0;
                    this.mBuilder.append(nl);
                }
            }
        }
        this.mBuilder.append("M  END" + nl);
    }

    public String getMolfile() {
        return this.mBuilder.toString();
    }

    public void writeMolfile(Writer theWriter) throws IOException {
        theWriter.write(this.mBuilder.toString());
    }

    private void appendThreeDigitInt(int data) {
        if (data < 0 || data > 999) {
            this.mBuilder.append("  ?");
            return;
        }
        boolean digitFound = false;
        for (int i = 0; i < 3; ++i) {
            int theChar = data / 100;
            if (theChar == 0) {
                if (i == 2 || digitFound) {
                    this.mBuilder.append('0');
                } else {
                    this.mBuilder.append(' ');
                }
            } else {
                this.mBuilder.append((char)(48 + theChar));
                digitFound = true;
            }
            data = 10 * (data % 100);
        }
    }

    private void appendTenDigitDouble(double theDouble) {
        String val = this.mDoubleFormat.format(theDouble);
        for (int i = val.length(); i < 10; ++i) {
            this.mBuilder.append(' ');
        }
        this.mBuilder.append(val);
    }
}

