/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.TreeMap;

public class MolfileParser {
    public static final int MODE_KEEP_HYDROGEN_MAP = 1;
    public static boolean debug = false;
    private StereoMolecule mMol;
    private TreeMap<Integer, Integer> mAtomIndexMap;
    private TreeMap<Integer, Integer> mBondIndexMap;
    private boolean mTreatAnyAsMetalBond;
    private boolean mDeduceMissingCharges;
    private boolean mChiralFlag;
    private boolean mIsV3000;
    private boolean mAssumeChiralTrue;
    private int mMode;
    private int[] mHydrogenMap;

    public MolfileParser() {
        this.mMode = 0;
    }

    public MolfileParser(int mode) {
        this.mMode = mode;
    }

    public int[] getHandleHydrogenMap() {
        return this.mHydrogenMap == null ? this.mMol.getHandleHydrogenMap() : this.mHydrogenMap;
    }

    private boolean readMoleculeFromBuffer(BufferedReader reader) {
        int[] valence = null;
        try {
            int atom;
            int i;
            int nlists;
            int nbonds;
            int natoms;
            String line;
            String name;
            this.mHydrogenMap = null;
            if (this.mMol != null) {
                this.mMol.deleteMolecule();
                this.mMol.setFragment(false);
            }
            if (null == (name = (line = reader.readLine()))) {
                this.TRACE("readMoleculeFromBuffer: No Header Line\n");
                return false;
            }
            line = reader.readLine();
            if (null == line) {
                this.TRACE("Error [readMoleculeFromBuffer]: No Program Line\n");
                return false;
            }
            line = reader.readLine();
            if (null == line) {
                this.TRACE("Error [readMoleculeFromBuffer]: No Comment Line\n");
                return false;
            }
            this.mTreatAnyAsMetalBond = line.contains("From CSD data. Using bond type 'Any'");
            this.mDeduceMissingCharges = line.contains("From CSD data.");
            line = reader.readLine();
            if (null == line) {
                this.TRACE("Error [readMoleculeFromBuffer]: No Counts Line\n");
                return false;
            }
            this.mIsV3000 = false;
            this.mChiralFlag = this.mAssumeChiralTrue;
            try {
                natoms = Integer.parseInt(line.substring(0, 3).trim());
                nbonds = Integer.parseInt(line.substring(3, 6).trim());
                nlists = this.parseIntOrSpaces(line.substring(6, 9).trim());
                this.mChiralFlag |= 1 == this.parseIntOrSpaces(line.substring(12, 15).trim());
                this.mIsV3000 = line.length() >= 39 && line.startsWith("V3000", 34);
            }
            catch (Exception e) {
                this.TRACE("Warning [readMoleculeFromBuffer]: Unable to interpret counts line\n");
                return false;
            }
            if (this.mIsV3000) {
                boolean res = this.readMoleculeV3FromBuffer(reader);
                this.mMol.setName(name);
                return res;
            }
            if (this.mMol == null) {
                this.mMol = new StereoMolecule(natoms, nbonds);
            }
            this.mMol.setName(name);
            if (!this.mChiralFlag) {
                this.mMol.setToRacemate();
            }
            if (0 == natoms) {
                while (!(line == null || line.equals("M  END") || line.equals("$$$$") || line.substring(1).equals("$"))) {
                    line = reader.readLine();
                }
                return true;
            }
            for (i = 0; i < natoms; ++i) {
                int v;
                int chargeDif;
                int massDif;
                line = reader.readLine();
                if (null == line) {
                    this.TRACE("Error [readMoleculeFromBuffer]: No Atom Line\n");
                    return false;
                }
                float x = Float.parseFloat(line.substring(0, 10).trim());
                float y = Float.parseFloat(line.substring(10, 20).trim());
                float z = Float.parseFloat(line.substring(20, 30).trim());
                atom = this.mMol.addAtom(x, -y, -z);
                String label = line.substring(31, 34).trim();
                int atomicNo = Molecule.getAtomicNoFromLabel(label);
                this.mMol.setAtomicNo(atom, atomicNo);
                if (label.equals("A")) {
                    this.mMol.setAtomicNo(atom, 6);
                    this.mMol.setAtomQueryFeature(atom, 1L, true);
                }
                if ((massDif = this.parseIntOrSpaces(line.substring(34, 36).trim())) != 0) {
                    this.mMol.setAtomMass(atom, Molecule.cRoundedMass[atomicNo] + massDif);
                }
                if ((chargeDif = this.parseIntOrSpaces(line.substring(36, 39).trim())) != 0) {
                    this.mMol.setAtomCharge(atom, 4 - chargeDif);
                }
                int mapNo = line.length() < 63 ? 0 : this.parseIntOrSpaces(line.substring(60, 63).trim());
                this.mMol.setAtomMapNo(atom, mapNo, false);
                int hCount = line.length() < 45 ? 0 : this.parseIntOrSpaces(line.substring(42, 45).trim());
                switch (hCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.mMol.setAtomQueryFeature(atom, 768L, true);
                        break;
                    }
                    case 2: {
                        this.mMol.setAtomQueryFeature(atom, 128L, true);
                        break;
                    }
                    case 3: {
                        this.mMol.setAtomQueryFeature(atom, 384L, true);
                        break;
                    }
                    default: {
                        this.mMol.setAtomQueryFeature(atom, 896L, true);
                    }
                }
                if (line.length() >= 48 && line.charAt(47) == '1') {
                    this.mMol.setAtomQueryFeature(atom, 8192L, true);
                }
                int n = v = line.length() < 51 ? 0 : this.parseIntOrSpaces(line.substring(48, 51).trim());
                if (v == 0) continue;
                if (valence == null) {
                    valence = new int[natoms];
                }
                valence[atom] = v;
            }
            for (i = 0; i < nbonds; ++i) {
                int topology;
                line = reader.readLine();
                if (null == line) {
                    this.TRACE("Error [readMoleculeFromBuffer]:No Bond Line\n");
                    return false;
                }
                int atom1 = Integer.parseInt(line.substring(0, 3).trim()) - 1;
                int atom2 = Integer.parseInt(line.substring(3, 6).trim()) - 1;
                int bondType = Integer.parseInt(line.substring(6, 9).trim());
                int stereo = line.length() < 12 ? 0 : this.parseIntOrSpaces(line.substring(9, 12).trim());
                int n = topology = line.length() < 18 ? 0 : this.parseIntOrSpaces(line.substring(15, 18).trim());
                if (bondType == 8 && (this.mTreatAnyAsMetalBond || this.mMol.isMetalAtom(atom1) || this.mMol.isMetalAtom(atom2))) {
                    bondType = 9;
                }
                this.buildBond(atom1, atom2, bondType, stereo, topology);
            }
            for (i = 0; i < nlists; ++i) {
                line = reader.readLine();
                if (null != line) continue;
                this.TRACE("Error [readMoleculeFromBuffer]: No List Line\n");
                return false;
            }
            line = reader.readLine();
            if (null == line) {
                this.TRACE("Error ReadMoleculeFromBuffer Missing M END or $$$$\n");
                if ((this.mMode & 1) != 0) {
                    this.mHydrogenMap = this.mMol.getHandleHydrogenMap();
                }
                this.handleValences(valence);
                if (!this.mChiralFlag) {
                    this.mMol.ensureHelperArrays(15);
                }
                return true;
            }
            while (line != null && !line.equals("M  END") && !line.equals("$$$$")) {
                int atom2;
                int j;
                int vvv;
                int aaa;
                int j2;
                if (line.startsWith("M  CHG") && (j2 = Integer.parseInt(line.substring(6, 9).trim())) > 0) {
                    aaa = 10;
                    vvv = 14;
                    int k = 1;
                    while (k <= j2) {
                        atom = Integer.parseInt(line.substring(aaa, aaa + 3).trim()) - 1;
                        int charge = Integer.parseInt(line.substring(vvv, vvv + 3).trim());
                        this.mMol.setAtomCharge(atom, charge);
                        ++k;
                        aaa += 8;
                        vvv += 8;
                    }
                }
                if (line.startsWith("M  ISO") && (j2 = Integer.parseInt(line.substring(6, 9).trim())) > 0) {
                    aaa = 10;
                    vvv = 14;
                    int k = 1;
                    while (k <= j2) {
                        atom = Integer.parseInt(line.substring(aaa, aaa + 3).trim()) - 1;
                        int mass = Integer.parseInt(line.substring(vvv, vvv + 3).trim());
                        this.mMol.setAtomMass(atom, mass);
                        ++k;
                        aaa += 8;
                        vvv += 8;
                    }
                }
                if (line.startsWith("M  RAD") && (j2 = Integer.parseInt(line.substring(6, 9).trim())) > 0) {
                    aaa = 10;
                    vvv = 14;
                    int k = 1;
                    while (k <= j2) {
                        atom = Integer.parseInt(line.substring(aaa, aaa + 3).trim()) - 1;
                        int radical = Integer.parseInt(line.substring(vvv, vvv + 3).trim());
                        switch (radical) {
                            case 1: {
                                this.mMol.setAtomRadical(atom, 16);
                                break;
                            }
                            case 2: {
                                this.mMol.setAtomRadical(atom, 32);
                                break;
                            }
                            case 3: {
                                this.mMol.setAtomRadical(atom, 48);
                            }
                        }
                        ++k;
                        aaa += 8;
                        vvv += 8;
                    }
                }
                if ((line.startsWith("M  RBC") || line.startsWith("M  RBD")) && (j = Integer.parseInt(line.substring(6, 9).trim())) > 0) {
                    int aaa2 = 10;
                    int vvv2 = 14;
                    int k = 1;
                    while (k <= j) {
                        atom = Integer.parseInt(line.substring(aaa2, aaa2 + 3).trim()) - 1;
                        int ringState = Integer.parseInt(line.substring(vvv2, vvv2 + 3).trim());
                        switch (ringState) {
                            case -1: {
                                this.mMol.setAtomQueryFeature(atom, 112L, true);
                                break;
                            }
                            case 1: {
                                this.mMol.setAtomQueryFeature(atom, 8L, true);
                                break;
                            }
                            case 2: {
                                this.mMol.setAtomQueryFeature(atom, 104L, true);
                                break;
                            }
                            case 3: {
                                this.mMol.setAtomQueryFeature(atom, 112L, true);
                                break;
                            }
                            case 4: {
                                this.mMol.setAtomQueryFeature(atom, 56L, true);
                            }
                        }
                        ++k;
                        aaa2 += 8;
                        vvv2 += 8;
                    }
                }
                if (line.startsWith("M  ALS") && (atom2 = Integer.parseInt(line.substring(7, 10).trim()) - 1) >= 0) {
                    int no = Integer.parseInt(line.substring(10, 13).trim());
                    boolean bNotList = line.charAt(14) == 'T';
                    int[] v = new int[no];
                    int aaa3 = 16;
                    int k = 0;
                    while (k < no) {
                        String sym = line.substring(aaa3, aaa3 + 4).trim();
                        v[k] = Molecule.getAtomicNoFromLabel(sym);
                        ++k;
                        aaa3 += 4;
                    }
                    this.mMol.setAtomList(atom2, v, bNotList);
                }
                if (line.startsWith("M  SUB") && (j2 = Integer.parseInt(line.substring(6, 9).trim())) > 0) {
                    aaa = 10;
                    vvv = 14;
                    int k = 1;
                    while (k <= j2) {
                        atom = Integer.parseInt(line.substring(aaa, aaa + 3).trim()) - 1;
                        int substitution = Integer.parseInt(line.substring(vvv, vvv + 3).trim());
                        if (substitution == -2) {
                            this.mMol.setAtomQueryFeature(atom, 2048L, true);
                        } else if (substitution > 0) {
                            int substitutionCount = 0;
                            for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
                                if (this.mMol.getBondAtom(0, bond) != atom && this.mMol.getBondAtom(1, bond) != atom) continue;
                                ++substitutionCount;
                            }
                            if (substitution > substitutionCount) {
                                this.mMol.setAtomQueryFeature(atom, 4096L, true);
                            }
                        }
                        ++k;
                        aaa += 8;
                        vvv += 8;
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("error reading molfile " + e);
            return false;
        }
        if (this.mDeduceMissingCharges) {
            this.introduceObviousMetalBonds();
            this.deduceMissingCharges();
        }
        if ((this.mMode & 1) != 0) {
            this.mHydrogenMap = this.mMol.getHandleHydrogenMap();
        }
        this.handleValences(valence);
        this.mMol.ensureHelperArrays(15);
        return true;
    }

    public void setAssumeChiralTrue(boolean b) {
        this.mAssumeChiralTrue = b;
    }

    public boolean isChiralFlagSet() {
        return this.mChiralFlag;
    }

    public boolean isV3000() {
        return this.mIsV3000;
    }

    private void handleValences(int[] valence) {
        if (valence != null) {
            this.mMol.ensureHelperArrays(1);
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (valence[atom] == 0) continue;
                int chargeCorrection = this.mMol.getElectronValenceCorrection(atom, this.mMol.getOccupiedValence(atom));
                if (valence[atom] == 15) {
                    if (chargeCorrection < 0) continue;
                    this.mMol.setAtomAbnormalValence(atom, 0);
                    continue;
                }
                if (valence[atom] == this.mMol.getMaxValence(atom)) continue;
                this.mMol.setAtomAbnormalValence(atom, valence[atom] - chargeCorrection);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readMoleculeV3FromBuffer(BufferedReader reader) throws IOException {
        boolean MODE_CTAB = true;
        int MODE_CTAB_ATOM = 2;
        int MODE_CTAB_BOND = 3;
        int MODE_CTAB_COLLECTION = 4;
        if (this.mAtomIndexMap != null) {
            this.mAtomIndexMap.clear();
        }
        if (this.mBondIndexMap != null) {
            this.mBondIndexMap.clear();
        }
        int mode = 0;
        String line = reader.readLine();
        while (true) {
            block22: {
                block23: {
                    String modeString;
                    block24: {
                        if (line != null && line.startsWith("M  V30 ")) {
                            line = line.substring(7).trim();
                        } else {
                            while (line != null && !line.startsWith("M  END") && !line.equals("$$$$")) {
                                line = reader.readLine();
                            }
                            return true;
                        }
                        while (line.endsWith("-")) {
                            String cont = reader.readLine();
                            if (!cont.startsWith("M  V30 ")) {
                                return false;
                            }
                            line = line.substring(0, line.length() - 1).concat(cont.substring(7)).trim();
                        }
                        if (!line.startsWith("BEGIN")) break block23;
                        modeString = line.substring(6).trim();
                        if (!modeString.startsWith("CTAB")) break block24;
                        mode = 1;
                        break block22;
                    }
                    if (modeString.startsWith("ATOM")) {
                        mode = 2;
                        break block22;
                    } else if (modeString.startsWith("BOND")) {
                        mode = 3;
                        break block22;
                    } else {
                        if (!modeString.startsWith("COLLECTION")) {
                            this.TRACE("Error MolfileParser: Unsupported version 3 block\n");
                            return false;
                        }
                        mode = 4;
                    }
                    break block22;
                }
                if (line.startsWith("END")) {
                    mode = 0;
                } else if (mode == 1) {
                    this.interpretV3CountLine(line);
                } else if (mode == 2) {
                    this.interpretV3AtomLine(line);
                } else if (mode == 3) {
                    this.interpretV3BondLine(line);
                } else {
                    if (mode != 4) {
                        this.TRACE("Error MolfileParser: Unexpected version 3 line\n");
                        return false;
                    }
                    this.interpretV3CollectionLine(line);
                }
            }
            line = reader.readLine();
        }
    }

    private void interpretV3CountLine(String line) {
        if (this.mMol == null && line.startsWith("COUNTS")) {
            int index1 = 7;
            int index2 = this.indexOfNextItem(line, this.indexOfWhiteSpace(line, 7));
            int natoms = Integer.parseInt(line.substring(index1, this.indexOfWhiteSpace(line, index1)));
            int nbonds = Integer.parseInt(line.substring(index2, this.indexOfWhiteSpace(line, index2)));
            this.mMol = new StereoMolecule(natoms, nbonds);
        }
    }

    private void interpretV3AtomLine(String line) throws IOException {
        int index1 = 0;
        int index2 = this.endOfItem(line, index1);
        int atomIndex = Integer.parseInt(line.substring(index1, index2));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        String label = line.substring(index1, index2);
        int[] v = null;
        boolean bNotList = false;
        int l = this.isV3AtomList(line);
        if (l != 0) {
            v = this.interpretV3AtomList(line);
            if (l < 0) {
                bNotList = true;
            }
            index2 = Math.abs(l);
        }
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        float x = Float.parseFloat(line.substring(index1, index2));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        float y = Float.parseFloat(line.substring(index1, index2));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        float z = Float.parseFloat(line.substring(index1, index2));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        int mapNo = Integer.parseInt(line.substring(index1, index2));
        int atom = this.mMol.addAtom(x, -y, -z);
        if (atom + 1 != atomIndex) {
            this.mapAtomIndex(atomIndex, atom);
        }
        if (v != null) {
            this.mMol.setAtomList(atom, v, bNotList);
        }
        if (mapNo != 0) {
            this.mMol.setAtomMapNo(atom, mapNo, false);
        }
        if (label.equals("A")) {
            this.mMol.setAtomQueryFeature(atom, 1L, true);
        } else if (label.equals("Q")) {
            int[] list = new int[]{6};
            this.mMol.setAtomList(atom, list, true);
        } else {
            this.mMol.setAtomicNo(atom, Molecule.getAtomicNoFromLabel(label));
        }
        block18: while ((index1 = this.indexOfNextItem(line, index2)) != -1) {
            index2 = this.endOfItem(line, index1);
            String specifier = line.substring(index1, index2);
            int index = specifier.indexOf(61);
            String field = specifier.substring(0, index);
            int value = Integer.parseInt(specifier.substring(index + 1));
            if (field.equals("CHG")) {
                this.mMol.setAtomCharge(atom, value);
                continue;
            }
            if (field.equals("RAD")) {
                switch (value) {
                    case 1: {
                        this.mMol.setAtomRadical(atom, 16);
                        break;
                    }
                    case 2: {
                        this.mMol.setAtomRadical(atom, 32);
                        break;
                    }
                    case 3: {
                        this.mMol.setAtomRadical(atom, 48);
                    }
                }
                continue;
            }
            if (field.equals("CFG")) continue;
            if (field.equals("MASS")) {
                this.mMol.setAtomMass(atom, value);
                continue;
            }
            if (field.equals("VAL")) {
                this.mMol.setAtomAbnormalValence(atom, value == -1 ? 0 : (value == 0 ? -1 : value));
                continue;
            }
            if (field.equals("HCOUNT")) {
                switch (value) {
                    case 0: {
                        continue block18;
                    }
                    case -1: {
                        this.mMol.setAtomQueryFeature(atom, 1792L, true);
                        continue block18;
                    }
                    case 1: {
                        this.mMol.setAtomQueryFeature(atom, 128L, true);
                        continue block18;
                    }
                    case 2: {
                        this.mMol.setAtomQueryFeature(atom, 384L, true);
                        continue block18;
                    }
                }
                this.mMol.setAtomQueryFeature(atom, 896L, true);
                continue;
            }
            if (field.equals("SUBST")) {
                if (value == -1) {
                    this.mMol.setAtomQueryFeature(atom, 2048L, true);
                    continue;
                }
                if (value <= 0) continue;
                int substitutionCount = 0;
                for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
                    if (this.mMol.getBondAtom(0, bond) != atom && this.mMol.getBondAtom(1, bond) != atom) continue;
                    ++substitutionCount;
                }
                if (value <= substitutionCount) continue;
                this.mMol.setAtomQueryFeature(atom, 4096L, true);
                continue;
            }
            if (field.equals("RBCNT")) {
                switch (value) {
                    case -1: {
                        this.mMol.setAtomQueryFeature(atom, 112L, true);
                        break;
                    }
                    case 1: {
                        this.mMol.setAtomQueryFeature(atom, 8L, true);
                        break;
                    }
                    case 2: {
                        this.mMol.setAtomQueryFeature(atom, 104L, true);
                        break;
                    }
                    case 3: {
                        this.mMol.setAtomQueryFeature(atom, 112L, true);
                        break;
                    }
                    case 4: {
                        this.mMol.setAtomQueryFeature(atom, 56L, true);
                    }
                }
                continue;
            }
            this.TRACE("Warning MolfileParser: Unused version 3 atom specifier:" + field + "\n");
        }
    }

    private void interpretV3BondLine(String line) throws IOException {
        int index1 = 0;
        int index2 = this.endOfItem(line, index1);
        int bondIndex = Integer.parseInt(line.substring(index1, index2));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        int bondType = Integer.parseInt(line.substring(index1, index2));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        int atom1 = this.getUsedAtomIndex(Integer.parseInt(line.substring(index1, index2)));
        index1 = this.indexOfNextItem(line, index2);
        index2 = this.endOfItem(line, index1);
        int atom2 = this.getUsedAtomIndex(Integer.parseInt(line.substring(index1, index2)));
        int stereo = 0;
        int topology = 0;
        while ((index1 = this.indexOfNextItem(line, index2)) != -1) {
            index2 = this.endOfItem(line, index1);
            String specifier = line.substring(index1, index2);
            int index = specifier.indexOf(61);
            String field = specifier.substring(0, index);
            int value = Integer.parseInt(specifier.substring(index + 1));
            if (field.equals("CFG")) {
                switch (value) {
                    case 1: {
                        stereo = 1;
                        break;
                    }
                    case 2: {
                        stereo = bondType == 2 ? 3 : 4;
                        break;
                    }
                    case 3: {
                        stereo = 6;
                    }
                }
                continue;
            }
            if (field.equals("TOPO")) {
                topology = value;
                continue;
            }
            this.TRACE("Warning MolfileParser: Unused version 3 bond specifier:" + field + "\n");
        }
        int bond = this.buildBond(atom1, atom2, bondType, stereo, topology);
        if (bond + 1 != bondIndex) {
            this.mapBondIndex(bondIndex, bond);
        }
    }

    private void interpretV3CollectionLine(String line) {
        String objectType = this.interpretObjectType(line);
        if (objectType != null) {
            int[] list = this.interpretV3List(line, objectType);
            if (line.startsWith("MDLV30/STEABS")) {
                if (objectType.equals("ATOMS")) {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setAtomESR(this.getUsedAtomIndex(list[i]), 0, -1);
                    }
                } else {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setBondESR(this.getUsedBondIndex(list[i]), 0, -1);
                    }
                }
            } else if (line.startsWith("MDLV30/STERAC")) {
                int group = Integer.parseInt(line.substring(13, this.indexOfWhiteSpace(line, 13)));
                if (objectType.equals("ATOMS")) {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setAtomESR(this.getUsedAtomIndex(list[i]), 1, group - 1);
                    }
                } else {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setBondESR(this.getUsedBondIndex(list[i]), 1, group - 1);
                    }
                }
            } else if (line.startsWith("MDLV30/STEREL")) {
                int group = Integer.parseInt(line.substring(13, this.indexOfWhiteSpace(line, 13)));
                if (objectType.equals("ATOMS")) {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setAtomESR(this.getUsedAtomIndex(list[i]), 2, group - 1);
                    }
                } else {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setBondESR(this.getUsedBondIndex(list[i]), 2, group - 1);
                    }
                }
            } else if (line.startsWith("MDLV30/HILITE")) {
                if (objectType.equals("ATOMS")) {
                    for (int i = 0; i < list.length; ++i) {
                        this.mMol.setAtomColor(this.getUsedAtomIndex(list[i]), 448);
                    }
                } else {
                    for (int i = 0; i < list.length; ++i) {
                        int bond = this.getUsedBondIndex(list[i]);
                        this.mMol.setAtomColor(this.mMol.getBondAtom(0, bond), 448);
                        this.mMol.setAtomColor(this.mMol.getBondAtom(1, bond), 448);
                    }
                }
            } else {
                this.TRACE("Error [readMoleculeFromBuffer]: Unknown version 3 collection type\n");
            }
        }
    }

    private String interpretObjectType(String line) {
        if (line.contains("ATOMS=(")) {
            return "ATOMS";
        }
        if (line.contains("BONDS=(")) {
            return "BONDS";
        }
        this.TRACE("Error [readMoleculeFromBuffer]: Unknown or missing collection object type\n");
        return null;
    }

    private int[] interpretV3AtomList(String line) {
        int[] res = null;
        int i1 = line.indexOf("[");
        int i2 = line.indexOf("]", i1);
        if (i1 >= 0 && i2 > 0) {
            int[] atoms = new int[16];
            String s = line.substring(i1 + 1, i2);
            int index = 0;
            boolean ok = true;
            while (ok && index < 16) {
                i1 = s.indexOf(",");
                String l = null;
                if (i1 == -1) {
                    l = s;
                    ok = false;
                } else {
                    l = s.substring(0, i1);
                    s = s.substring(i1 + 1);
                }
                atoms[index++] = Molecule.getAtomicNoFromLabel(l);
            }
            res = new int[index];
            System.arraycopy(atoms, 0, res, 0, index);
        }
        return res;
    }

    private int isV3AtomList(String line) {
        if (line.indexOf("[") >= 0) {
            int i1 = line.indexOf(" NOT[");
            int i2 = line.indexOf("]", i1);
            if (i1 >= 0 && i2 > 0) {
                return -(i2 + 1);
            }
            i1 = line.indexOf(" [");
            i2 = line.indexOf("]", i1);
            if (i1 >= 0 && i2 > 0) {
                return i2 + 1;
            }
            i1 = line.indexOf(" 'NOT[");
            i2 = line.indexOf("]'", i1);
            if (i1 >= 0 && i2 > 0) {
                return -(i2 + 2);
            }
            i1 = line.indexOf(" '[");
            i2 = line.indexOf("]'", i1);
            if (i1 >= 0 && i2 > 0) {
                return i2 + 2;
            }
            System.err.println("Warning invalid atom list in line: " + line);
        }
        return 0;
    }

    private int[] interpretV3List(String line, String type) {
        int index1 = line.indexOf(type + "=(") + type.length() + 2;
        int index2 = line.indexOf(41, index1);
        int index = this.indexOfWhiteSpace(line, index1);
        int count = Integer.parseInt(line.substring(index1, index));
        int[] list = new int[count];
        for (int i = 0; i < count; ++i) {
            index1 = this.indexOfNextItem(line, index);
            if ((index = this.indexOfWhiteSpace(line, index1)) == -1 || index > index2) {
                index = index2;
            }
            list[i] = Integer.parseInt(line.substring(index1, index));
        }
        return list;
    }

    public boolean parse(StereoMolecule mol, File file) {
        this.mMol = mol;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(reader);
            return this.readMoleculeFromBuffer(reader);
        }
        catch (IOException e) {
            System.err.println("Error reading file " + e);
            return false;
        }
    }

    public boolean parse(StereoMolecule mol, String molFile) {
        return this.parse(mol, new BufferedReader(new StringReader(molFile)));
    }

    public boolean parse(StereoMolecule mol, StringBuffer molFile) {
        return this.parse(mol, molFile.toString());
    }

    public boolean parse(StereoMolecule m, BufferedReader rd) {
        this.mMol = m;
        return this.readMoleculeFromBuffer(rd);
    }

    public StereoMolecule getCompactMolecule(String molFile) {
        this.mMol = null;
        return this.readMoleculeFromBuffer(new BufferedReader(new StringReader(molFile))) ? this.mMol : null;
    }

    public StereoMolecule getCompactMolecule(BufferedReader reader) {
        this.mMol = null;
        return this.readMoleculeFromBuffer(reader) ? this.mMol : null;
    }

    public StereoMolecule getCompactMolecule(File file) {
        this.mMol = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            boolean success = this.readMoleculeFromBuffer(reader);
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return success ? this.mMol : null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    private int buildBond(int atom1, int atom2, int bondType, int stereo, int topology) {
        int realBondType = 1;
        boolean isAtomESRAnd = false;
        block0 : switch (stereo) {
            case 1: {
                realBondType = 17;
                break;
            }
            case 3: {
                realBondType = 26;
                break;
            }
            case 4: {
                realBondType = 17;
                isAtomESRAnd = true;
                break;
            }
            case 6: {
                realBondType = 9;
                break;
            }
            default: {
                switch (bondType) {
                    case 1: {
                        realBondType = 1;
                        break block0;
                    }
                    case 2: {
                        realBondType = 2;
                        break block0;
                    }
                    case 3: {
                        realBondType = 4;
                        break block0;
                    }
                    case 4: {
                        realBondType = 64;
                        break block0;
                    }
                    case 9: {
                        realBondType = 32;
                    }
                }
            }
        }
        int bond = this.mMol.addBond(atom1, atom2, realBondType);
        int queryFeatures = 0;
        if (isAtomESRAnd) {
            this.mMol.setAtomESR(atom1, 1, -1);
        }
        if (bondType > 4) {
            switch (bondType) {
                case 5: {
                    queryFeatures |= 3;
                    break;
                }
                case 6: {
                    queryFeatures |= 9;
                    break;
                }
                case 7: {
                    queryFeatures |= 0xA;
                    break;
                }
                case 8: {
                    if (realBondType == 32) break;
                    queryFeatures |= 0x1F;
                }
            }
        }
        if (topology == 1) {
            queryFeatures |= 0x40;
        }
        if (topology == 2) {
            queryFeatures |= 0x20;
        }
        if (queryFeatures != 0) {
            this.mMol.setBondQueryFeature(bond, queryFeatures, true);
        }
        return bond;
    }

    private void mapAtomIndex(int sourceAtomIndex, int usedAtomIndex) {
        if (this.mAtomIndexMap == null) {
            this.mAtomIndexMap = new TreeMap();
        }
        this.mAtomIndexMap.put(new Integer(sourceAtomIndex), new Integer(usedAtomIndex));
    }

    private void mapBondIndex(int sourceBondIndex, int usedBondIndex) {
        if (this.mBondIndexMap == null) {
            this.mBondIndexMap = new TreeMap();
        }
        this.mBondIndexMap.put(new Integer(sourceBondIndex), new Integer(usedBondIndex));
    }

    private int getUsedAtomIndex(int sourceAtomIndex) {
        Integer ui = this.mAtomIndexMap == null ? null : this.mAtomIndexMap.get(new Integer(sourceAtomIndex));
        return ui == null ? sourceAtomIndex - 1 : ui;
    }

    private int getUsedBondIndex(int sourceBondIndex) {
        Integer ui = this.mBondIndexMap == null ? null : this.mBondIndexMap.get(new Integer(sourceBondIndex));
        return ui == null ? sourceBondIndex - 1 : ui;
    }

    private int parseIntOrSpaces(String s) throws NumberFormatException {
        return s.length() == 0 ? 0 : Integer.parseInt(s);
    }

    private int endOfItem(String line, int start) {
        int end = this.indexOfWhiteSpace(line, start + 1);
        return end == -1 ? line.length() : end;
    }

    private int indexOfWhiteSpace(String line, int fromIndex) {
        for (int i = fromIndex; i < line.length(); ++i) {
            if (line.charAt(i) != ' ' && line.charAt(i) != '\t') continue;
            return i;
        }
        return -1;
    }

    private int indexOfNextItem(String line, int afterPreviousItem) {
        if (afterPreviousItem == -1) {
            return -1;
        }
        for (int i = afterPreviousItem + 1; i < line.length(); ++i) {
            if (line.charAt(i) == ' ' || line.charAt(i) == '\t') continue;
            return i;
        }
        return -1;
    }

    void TRACE(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    private void introduceObviousMetalBonds() {
        int i;
        int bond;
        int[] occupiedValence = new int[this.mMol.getAllAtoms()];
        for (bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            if (this.mMol.getBondType(bond) != 64) continue;
            for (i = 0; i < 2; ++i) {
                occupiedValence[this.mMol.getBondAtom((int)i, (int)bond)] = 1;
            }
        }
        for (bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            int order = this.mMol.getBondOrder(bond);
            for (int i2 = 0; i2 < 2; ++i2) {
                int n = this.mMol.getBondAtom(i2, bond);
                occupiedValence[n] = occupiedValence[n] + order;
            }
        }
        for (bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            if (this.mMol.getBondOrder(bond) != 1) continue;
            for (i = 0; i < 2; ++i) {
                int atom;
                int metalAtom = this.mMol.getBondAtom(1 - i, bond);
                if (!this.mMol.isMetalAtom(metalAtom) || !this.mMol.isElectronegative(atom = this.mMol.getBondAtom(i, bond)) || occupiedValence[atom] <= this.mMol.getMaxValence(atom)) continue;
                this.mMol.setBondType(bond, 32);
            }
        }
    }

    private void deduceMissingCharges() {
        int atom;
        int[] chargeChange = new int[this.mMol.getAllAtoms()];
        for (atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            chargeChange[atom] = -this.mMol.getAtomCharge(atom);
        }
        new AromaticityResolver(this.mMol).locateDelocalizedDoubleBonds(null, true, false);
        for (atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            int n = atom;
            chargeChange[n] = chargeChange[n] + this.mMol.getAtomCharge(atom);
        }
        for (atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (chargeChange[atom] == 0) continue;
            int chargeToDistribute = -chargeChange[atom];
            for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
                for (int i = 0; i < 2; ++i) {
                    int metal;
                    if (chargeToDistribute <= 0 || this.mMol.getBondType(bond) != 32 || this.mMol.getBondAtom(1 - i, bond) != atom || !this.mMol.isMetalAtom(metal = this.mMol.getBondAtom(i, bond))) continue;
                    int maxCharge = this.getMaxOxidationState(metal);
                    int charge = this.mMol.getAtomCharge(metal);
                    if (charge >= maxCharge) continue;
                    int dif = Math.min(chargeToDistribute, maxCharge - charge);
                    this.mMol.setAtomCharge(metal, charge + dif);
                    chargeToDistribute -= dif;
                }
            }
        }
    }

    private int getMaxOxidationState(int metal) {
        int atomicNo = this.mMol.getAtomicNo(metal);
        byte[] os = atomicNo < Molecule.cCommonOxidationState.length ? Molecule.cCommonOxidationState[atomicNo] : null;
        return os == null ? 0 : os[os.length - 1];
    }
}

