/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import java.io.IOException;
import java.io.Writer;

public class MolfileV3Creator {
    private StringBuilder mMolfile;
    private static final double TARGET_AVBL = 1.5;
    private static final double PRECISION_FACTOR = 10000.0;
    private double mScalingFactor = 1.0;

    public MolfileV3Creator(StereoMolecule mol) {
        this(mol, true);
    }

    public MolfileV3Creator(StereoMolecule mol, boolean allowScaling) {
        this(mol, allowScaling, 0.0, new StringBuilder(32768));
    }

    public MolfileV3Creator(StereoMolecule mol, boolean allowScaling, StringBuilder builder) {
        this(mol, allowScaling, 0.0, builder);
    }

    public MolfileV3Creator(StereoMolecule mol, boolean allowScaling, double scalingFactor, StringBuilder builder) {
        mol.ensureHelperArrays(15);
        String nl = System.lineSeparator();
        this.mMolfile = builder == null ? new StringBuilder() : builder;
        String name = mol.getName() != null ? mol.getName() : "";
        this.mMolfile.append(name + nl);
        this.mMolfile.append("Actelion Java MolfileCreator 2.0" + nl + nl);
        this.mMolfile.append("  0  0  0  0  0  0              0 V3000" + nl);
        this.mScalingFactor = 1.0;
        boolean hasCoordinates = MolfileV3Creator.hasCoordinates(mol);
        if (hasCoordinates) {
            if (scalingFactor != 0.0) {
                this.mScalingFactor = scalingFactor;
            } else if (allowScaling) {
                this.mScalingFactor = MolfileV3Creator.calculateScalingFactor(mol);
            }
        }
        this.writeBody(mol, hasCoordinates);
        this.mMolfile.append("M  END" + nl);
    }

    private static boolean hasCoordinates(StereoMolecule mol) {
        if (mol.getAllAtoms() == 1) {
            return true;
        }
        for (int atom = 1; atom < mol.getAllAtoms(); ++atom) {
            if (mol.getAtomX(atom) == mol.getAtomX(0) && mol.getAtomY(atom) == mol.getAtomY(0) && mol.getAtomZ(atom) == mol.getAtomZ(0)) continue;
            return true;
        }
        return false;
    }

    private static double calculateScalingFactor(StereoMolecule mol) {
        double scalingFactor = 1.0;
        double avbl = mol.getAverageBondLength();
        if (avbl != 0.0) {
            if (avbl < 1.0 || avbl > 3.0) {
                scalingFactor = 1.5 / avbl;
            }
        } else {
            double minDistance = 3.4028234663852886E38;
            for (int atom1 = 1; atom1 < mol.getAllAtoms(); ++atom1) {
                for (int atom2 = 0; atom2 < atom1; ++atom2) {
                    double dz;
                    double dy;
                    double dx = mol.getAtomX(atom2) - mol.getAtomX(atom1);
                    double distance = dx * dx + (dy = mol.getAtomY(atom2) - mol.getAtomY(atom1)) * dy + (dz = mol.getAtomZ(atom2) - mol.getAtomZ(atom1)) * dz;
                    if (!(minDistance > distance)) continue;
                    minDistance = distance;
                }
            }
            scalingFactor = 3.0 / Math.max(0.75, minDistance);
        }
        return scalingFactor;
    }

    public static String writeCTAB(StereoMolecule mol, double scalingFactor) {
        MolfileV3Creator mf = new MolfileV3Creator();
        mf.mScalingFactor = scalingFactor;
        mol.ensureHelperArrays(15);
        mf.writeBody(mol, true);
        return mf.getMolfile();
    }

    private static String writeCTAB(StereoMolecule mol, boolean hasCoordinates) {
        MolfileV3Creator mf = new MolfileV3Creator();
        mol.ensureHelperArrays(15);
        mf.writeBody(mol, hasCoordinates);
        return mf.getMolfile();
    }

    private MolfileV3Creator() {
        this.mMolfile = new StringBuilder(32768);
    }

    private void writeBody(StereoMolecule mol, boolean hasCoordinates) {
        int bond;
        String nl = System.lineSeparator();
        this.mMolfile.append("M  V30 BEGIN CTAB" + nl);
        this.mMolfile.append("M  V30 COUNTS " + mol.getAllAtoms() + " " + mol.getAllBonds() + " 0 0 0" + nl);
        this.mMolfile.append("M  V30 BEGIN ATOM" + nl);
        for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
            long ringFeatures;
            long hydrogenFlags;
            int valence;
            this.mMolfile.append("M  V30 " + (atom + 1));
            if (mol.getAtomList(atom) != null) {
                int[] atomList = mol.getAtomList(atom);
                boolean notlist = (mol.getAtomQueryFeatures(atom) & 1L) != 0L;
                this.mMolfile.append(notlist ? " NOT[" : " [");
                block21: for (int i = 0; i < atomList.length; ++i) {
                    if (i > 0) {
                        this.mMolfile.append(",");
                    }
                    String label = Molecule.cAtomLabel[atomList[i]];
                    switch (label.length()) {
                        case 1: {
                            this.mMolfile.append(label);
                            continue block21;
                        }
                        case 2: {
                            this.mMolfile.append(label);
                            continue block21;
                        }
                        case 3: {
                            this.mMolfile.append(label);
                            continue block21;
                        }
                        default: {
                            this.mMolfile.append("?");
                        }
                    }
                }
                this.mMolfile.append("]");
            } else if ((mol.getAtomQueryFeatures(atom) & 1L) != 0L) {
                this.mMolfile.append(" A");
            } else {
                this.mMolfile.append(" " + mol.getAtomLabel(atom));
            }
            if (hasCoordinates) {
                this.mMolfile.append(" " + (double)((int)(10000.0 * this.mScalingFactor * mol.getAtomX(atom))) / 10000.0);
                this.mMolfile.append(" " + (double)((int)(10000.0 * this.mScalingFactor * -mol.getAtomY(atom))) / 10000.0);
                this.mMolfile.append(" " + (double)((int)(10000.0 * this.mScalingFactor * -mol.getAtomZ(atom))) / 10000.0);
            } else {
                this.mMolfile.append(" 0 0 0");
            }
            this.mMolfile.append(" " + mol.getAtomMapNo(atom));
            if (mol.getAtomCharge(atom) != 0) {
                this.mMolfile.append(" CHG=" + mol.getAtomCharge(atom));
            }
            if (mol.getAtomRadical(atom) != 0) {
                this.mMolfile.append(" RAD=");
                switch (mol.getAtomRadical(atom)) {
                    case 16: {
                        this.mMolfile.append("1");
                        break;
                    }
                    case 32: {
                        this.mMolfile.append("2");
                        break;
                    }
                    case 48: {
                        this.mMolfile.append("3");
                    }
                }
            }
            if (mol.getAtomParity(atom) == 1 || mol.getAtomParity(atom) == 2) {
                this.mMolfile.append(" CFG=");
                if (mol.getAtomParity(atom) == 1) {
                    this.mMolfile.append("1");
                } else {
                    this.mMolfile.append("2");
                }
            }
            if (mol.getAtomMass(atom) != 0) {
                this.mMolfile.append(" MASS=" + mol.getAtomMass(atom));
            }
            if ((valence = mol.getAtomAbnormalValence(atom)) != -1) {
                this.mMolfile.append(" VAL=" + (valence == 0 ? "-1" : Integer.valueOf(valence)));
            }
            if ((hydrogenFlags = 0x780L & mol.getAtomQueryFeatures(atom)) == 384L) {
                this.mMolfile.append(" HCOUNT=2");
            } else if (hydrogenFlags == 128L) {
                this.mMolfile.append(" HCOUNT=1");
            } else if (hydrogenFlags == 1792L) {
                this.mMolfile.append(" HCOUNT=-1");
            } else if (hydrogenFlags == 1664L) {
                this.mMolfile.append(" HCOUNT=1");
            }
            long substitution = mol.getAtomQueryFeatures(atom) & 0x1800L;
            if (substitution != 0L) {
                if ((substitution & 0x1000L) != 0L) {
                    this.mMolfile.append(" SUBST=" + (mol.getAllConnAtoms(atom) + 1));
                } else {
                    this.mMolfile.append(" SUBST=-1");
                }
            }
            if ((ringFeatures = mol.getAtomQueryFeatures(atom) & 0x78L) != 0L) {
                if (ringFeatures == 112L) {
                    this.mMolfile.append(" RBCNT=-1");
                } else if (ringFeatures == 8L) {
                    this.mMolfile.append(" RBCNT=2");
                } else if (ringFeatures == 104L) {
                    this.mMolfile.append(" RBCNT=2");
                } else if (ringFeatures == 88L) {
                    this.mMolfile.append(" RBCNT=3");
                } else if (ringFeatures == 56L) {
                    this.mMolfile.append(" RBCNT=4");
                }
            }
            this.mMolfile.append(nl);
        }
        this.mMolfile.append("M  V30 END ATOM" + nl);
        this.mMolfile.append("M  V30 BEGIN BOND" + nl);
        for (int bond2 = 0; bond2 < mol.getAllBonds(); ++bond2) {
            int topology;
            int ringState;
            int stereo;
            int order;
            this.mMolfile.append("M  V30 " + (bond2 + 1));
            switch (mol.getBondType(bond2)) {
                case 1: {
                    order = 1;
                    stereo = 0;
                    break;
                }
                case 2: {
                    order = 2;
                    stereo = 0;
                    break;
                }
                case 4: {
                    order = 3;
                    stereo = 0;
                    break;
                }
                case 9: {
                    order = 1;
                    stereo = 3;
                    break;
                }
                case 17: {
                    order = 1;
                    stereo = 1;
                    break;
                }
                case 26: {
                    order = 2;
                    stereo = 2;
                    break;
                }
                case 64: {
                    order = 4;
                    stereo = 0;
                    break;
                }
                case 32: {
                    order = 9;
                    stereo = 0;
                    break;
                }
                default: {
                    order = 1;
                    stereo = 0;
                }
            }
            int bondType = mol.getBondQueryFeatures(bond2) & 0x1F;
            if (bondType != 0) {
                order = bondType == 8 ? 4 : (bondType == 3 ? 5 : (bondType == 9 ? 6 : (bondType == 10 ? 7 : 8)));
            }
            this.mMolfile.append(" " + order + " " + (mol.getBondAtom(0, bond2) + 1) + " " + (mol.getBondAtom(1, bond2) + 1));
            if (stereo != 0) {
                this.mMolfile.append(" CFG=" + stereo);
            }
            int n = (ringState = mol.getBondQueryFeatures(bond2) & 0x60) == 0 ? 0 : (topology = ringState == 64 ? 1 : 2);
            if (topology != 0) {
                this.mMolfile.append(" TOPO=" + topology);
            }
            this.mMolfile.append(nl);
        }
        this.mMolfile.append("M  V30 END BOND" + nl);
        boolean paritiesFound = false;
        int absAtomsCount = 0;
        int[] orAtomsCount = new int[32];
        int[] andAtomsCount = new int[32];
        for (int atom = 0; atom < mol.getAtoms(); ++atom) {
            if (mol.getAtomParity(atom) != 1 && mol.getAtomParity(atom) != 2) continue;
            paritiesFound = true;
            int type = mol.getAtomESRType(atom);
            if (type == 1) {
                int n = mol.getAtomESRGroup(atom);
                andAtomsCount[n] = andAtomsCount[n] + 1;
                continue;
            }
            if (type == 2) {
                int n = mol.getAtomESRGroup(atom);
                orAtomsCount[n] = orAtomsCount[n] + 1;
                continue;
            }
            ++absAtomsCount;
        }
        int absBondsCount = 0;
        int[] orBondsCount = new int[32];
        int[] andBondsCount = new int[32];
        for (bond = 0; bond < mol.getBonds(); ++bond) {
            if (mol.getBondOrder(bond) == 2 || mol.getBondParity(bond) != 1 && mol.getBondParity(bond) != 2) continue;
            paritiesFound = true;
            int type = mol.getBondESRType(bond);
            if (type == 1) {
                int n = mol.getBondESRGroup(bond);
                andBondsCount[n] = andBondsCount[n] + 1;
                continue;
            }
            if (type == 2) {
                int n = mol.getBondESRGroup(bond);
                orBondsCount[n] = orBondsCount[n] + 1;
                continue;
            }
            ++absBondsCount;
        }
        if (paritiesFound) {
            this.mMolfile.append("M  V30 BEGIN COLLECTION" + nl);
            if (absAtomsCount != 0) {
                this.mMolfile.append("M  V30 MDLV30/STEABS ATOMS=(" + absAtomsCount);
                for (int atom = 0; atom < mol.getAtoms(); ++atom) {
                    if (mol.getAtomParity(atom) != 1 && mol.getAtomParity(atom) != 2 || mol.getAtomESRType(atom) != 0) continue;
                    this.mMolfile.append(" " + (atom + 1));
                }
                this.mMolfile.append(")" + nl);
            }
            if (absBondsCount != 0) {
                this.mMolfile.append("M  V30 MDLV30/STEABS BONDS=(" + absBondsCount);
                for (bond = 0; bond < mol.getBonds(); ++bond) {
                    if (mol.getBondOrder(bond) == 2 || mol.getBondParity(bond) != 1 && mol.getBondParity(bond) != 2 || mol.getBondESRType(bond) != 0) continue;
                    this.mMolfile.append(" " + (bond + 1));
                }
                this.mMolfile.append(")" + nl);
            }
            for (int group = 0; group < 32; ++group) {
                int bond3;
                int atom;
                if (orAtomsCount[group] != 0) {
                    this.mMolfile.append("M  V30 MDLV30/STEREL" + (group + 1) + " ATOMS=(" + orAtomsCount[group]);
                    for (atom = 0; atom < mol.getAtoms(); ++atom) {
                        if (mol.getAtomParity(atom) != 1 && mol.getAtomParity(atom) != 2 || mol.getAtomESRType(atom) != 2 || mol.getAtomESRGroup(atom) != group) continue;
                        this.mMolfile.append(" " + (atom + 1));
                    }
                    this.mMolfile.append(")" + nl);
                }
                if (andAtomsCount[group] != 0) {
                    this.mMolfile.append("M  V30 MDLV30/STERAC" + (group + 1) + " ATOMS=(" + andAtomsCount[group]);
                    for (atom = 0; atom < mol.getAtoms(); ++atom) {
                        if (mol.getAtomParity(atom) != 1 && mol.getAtomParity(atom) != 2 || mol.getAtomESRType(atom) != 1 || mol.getAtomESRGroup(atom) != group) continue;
                        this.mMolfile.append(" " + (atom + 1));
                    }
                    this.mMolfile.append(")" + nl);
                }
                if (orBondsCount[group] != 0) {
                    this.mMolfile.append("M  V30 MDLV30/STEREL" + (group + 1) + " BONDS=(" + orBondsCount[group]);
                    for (bond3 = 0; bond3 < mol.getBonds(); ++bond3) {
                        if (mol.getBondOrder(bond3) == 2 || mol.getBondParity(bond3) != 1 && mol.getBondParity(bond3) != 2 || mol.getBondESRType(bond3) != 2 || mol.getBondESRGroup(bond3) != group) continue;
                        this.mMolfile.append(" " + (bond3 + 1));
                    }
                    this.mMolfile.append(")" + nl);
                }
                if (andBondsCount[group] == 0) continue;
                this.mMolfile.append("M  V30 MDLV30/STERAC" + (group + 1) + " BONDS=(" + andBondsCount[group]);
                for (bond3 = 0; bond3 < mol.getBonds(); ++bond3) {
                    if (mol.getBondOrder(bond3) == 2 || mol.getBondParity(bond3) != 1 && mol.getBondParity(bond3) != 2 || mol.getBondESRType(bond3) != 1 || mol.getBondESRGroup(bond3) != group) continue;
                    this.mMolfile.append(" " + (bond3 + 1));
                }
                this.mMolfile.append(")" + nl);
            }
            this.mMolfile.append("M  V30 END COLLECTION" + nl);
        }
        this.mMolfile.append("M  V30 END CTAB" + nl);
    }

    public String getMolfile() {
        return this.mMolfile.toString();
    }

    public double getScalingFactor() {
        return this.mScalingFactor;
    }

    public void writeMolfile(Writer theWriter) throws IOException {
        theWriter.write(this.mMolfile.toString());
    }
}

