/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.util.TreeMap;

public class NamedSubstituents {
    private static final String[][] SUBSTITUENT_LIST = new String[][]{{"Acyl", "gCaHA`AIf`@"}, {"Alloc", "gNph@l@ILzuR@@"}, {"Allyl", "Al"}, {"Benzyl;Bn", "daD@`F@DjUZxHH@@"}, {"Boc", "daxD`@S@AIgijj@@"}, {"BOM;BzOM", "deTH`@H@Re[TYj`@@@"}, {"Bs", "dmtDpAdLS`aPAIe]jf`@e`@@"}, {"Bt", "dew@`@aJ@DiY]paej`@@@"}, {"Btm", "did@P@BJ@Die_ahH@@@"}, {"Butyl;nButyl", "gJPHB@IRuP@"}, {"Benzoyl;Bz", "didH`@p@RYm^Eh@@@@"}, {"Bzh", "dg|@`N@LdbRbtJUB]aAP@@@@"}, {"Cbz", "dmtD`@S@AIgYVUZh@@@@"}, {"cButyl", "gKPHL@IThuT@@"}, {"cHeptyl", "daD@`L@DjWVzjj`@"}, {"cHexyl", "gOpHL@IToWUU@@"}, {"cOctyl", "did@`L@DjWWajjj@@"}, {"cPentyl", "gFpHL@ITimUP@"}, {"cPropyl", "gBPHL@Qxjh@"}, {"COOH", "gC`h@l@ILt@@ !Bb@K~@Hc}"}, {"DEAE", "daz@`@x@RiUjj`@"}, {"DEIPS", "diD@P@\\B@DjfVjj`@"}, {"DMIPS", "gNpD@xD@RjZjh@"}, {"DMPM", "dcLD`@kPCIEMDdcttDDT@@"}, {"DMPS", "deT@P@\\B@LddTjPsU@@@@"}, {"DMTr", "fak@b@@Mt@ISZ{SMjo{NQKfm@AU@@@E@@@@"}, {"DNP", "dkmB`hdDt~@HeNfS{HihheCAUhBHX@@"}, {"DNS;Dan", "fhi`a@KPP@HH@YIHYheEhYKQgKP@@QP@@@"}, {"DPIPS", "fdyAA@H@\\B@FRRIQSQIHzp_Qjh@h@@@@@"}, {"DPTBS", "fleAA@H@\\B@FRRIQSRIIWNbEMU@EP@@@@@"}, {"DTBMS", "dmT@P@\\B@Djffjjjh@@"}, {"Ethyl", "eMBD@ch@"}, {"Fmoc", "fde@b@@Hp@IL{LrjxeVCzKUT@@@P@@@"}, {"iAmyl", "gGPHJ@YIDZj@@"}, {"iButyl", "gJPHB@ITuP@"}, {"Im", "gFtHAj@IRnKSP@"}, {"iPropyl", "gC`HL@Qz`@"}, {"MDIPS", "diD@P@\\B@DjfZjj`@"}, {"MDPS", "foA@A@@NA@CIIEEBdeeVLzj@@@@@@"}, {"Methyl", "eFBH@c@@"}, {"MEM", "gNphAR@IRoUT@@"}, {"Mes", "deT@`J@DjY{[`bB`@@"}, {"MMTr", "ffcAB@@Z@Dim]ifuWYrI\\uh@Jh@@@@@@"}, {"MOM", "gCaHA`AJZ`@"}, {"MPM;PMB", "deTH`@d@Rfuunh@J@@"}, {"Ms", "gJPdH`DD@cuh@"}, {"MTM", "gC`D@DX@Rfh@"}, {"mTolyl", "daD@`N@DjWjXHB@@"}, {"N3", "gClHaE`@RnReX@"}, {"nAmyl;Amyl", "gGPHJ@IRmU@@"}, {"neoAm", "gGPHJ@IUMU@@"}, {"NO2,Nitro", "gChhhE`BRnRYh@"}, {"Np", "deVDaHAI@HeNR[e_aZ@B@@"}, {"nPropyl;Propyl", "gC`HL@IST@@"}, {"oTolyl", "daD@`J@DjYvxH`@@"}, {"Phenyl", "gOpHL@IToVD@@@"}, {"Pht", "dcLL`@RU@Dfyed]ZBA`@@"}, {"Piv;Pv", "gNqHA`AIffj`@"}, {"PMBM", "dcLD`@T`AJUm]FZh@J@@"}, {"PNB", "dcNLaHAEt@bTyInUvxV`@f@@"}, {"Poc", "didD`@S@AIgexVjj`@"}, {"PPi", "diDFsHSB[`|J|A@Lxn{lddqdZih@@"}, {"pTolyl", "daD@`N@DjWzXHB@@"}, {"sAmyl", "gGPHL@YIDZj@@"}, {"sButyl", "gJPHL@ITuP@"}, {"SEM", "diDHPFApD@rRQUJjj`@"}, {"SES", "dedDpHP@``AgCIICeHmUT@@"}, {"SO3H", "gJQdHl@``D^m@@"}, {"tAmyl", "gGPHB@IUMU@@"}, {"TBDMS;TBS", "dax@P@\\B@Djfjjh@@"}, {"TBDPS", "fdy@A@@NA@CIIEEEIde]XOhuPAT@@@@@"}, {"TBMPS", "dg\\HPHApH@rRQJJPjg]UAT@@@"}, {"tButyl,tBu", "gJPHB@Q}T@@"}, {"TDS", "ded@P@\\B@LddTeeUUP@@"}, {"Tf", "daxDhHP@``BiAiCiCIICHmU@@"}, {"TFA", "gNqBJIARFdF@YEHYUL@@"}, {"Thexyl", "gNpHB@IUMUT@@"}, {"THF", "gFqH@PAJYujj@@"}, {"THP", "gOqH@PAJYZzjh@"}, {"TIPS", "dmT@P@\\B@DjfYjjjh@@"}, {"TMS", "gJPD@xD@czh@"}, {"Tosyl;Ts", "dmtDPHP@``CIICLeaeZ@B@@"}, {"Troc", "diDDHJxHaHcH`PCHiBeJjf@@"}, {"Trt", "fbm@B@A@FRQIRKQPiIZdoIcdHJ`@@@@@@"}, {"Xyl", "did@`J@DjYynBHH@@"}};
    private static TreeMap<String, String> sIDCodeMap = null;

    private static void createMap() {
        sIDCodeMap = new TreeMap();
        for (String[] sp : SUBSTITUENT_LIST) {
            String[] key;
            for (String k : key = sp[0].split(";")) {
                sIDCodeMap.put(NamedSubstituents.normalize(k), sp[1]);
            }
        }
    }

    public static String identify(String nameStart) {
        if (nameStart == null || nameStart.length() == 0) {
            return null;
        }
        String name = null;
        nameStart = NamedSubstituents.normalize(nameStart);
        for (String[] sp : SUBSTITUENT_LIST) {
            String[] key;
            for (String k : key = sp[0].split(";")) {
                if (NamedSubstituents.normalize(k).equals(nameStart)) {
                    return k;
                }
                if (!NamedSubstituents.normalize(k).startsWith(nameStart)) continue;
                if (name == null) {
                    name = k;
                    continue;
                }
                return "";
            }
        }
        return name;
    }

    private static String normalize(String s) {
        return s.toLowerCase().replace("-", "");
    }

    public static String getSubstituentIDCode(String name) {
        if (sIDCodeMap == null) {
            NamedSubstituents.createMap();
        }
        return sIDCodeMap.get(NamedSubstituents.normalize(name));
    }

    public static StereoMolecule getSubstituent(String name) {
        String idcode = NamedSubstituents.getSubstituentIDCode(name);
        return idcode == null ? null : new IDCodeParser(false).getCompactMolecule(idcode);
    }

    public static boolean isValidSubstituentNameStart(String s) {
        if (sIDCodeMap == null) {
            NamedSubstituents.createMap();
        }
        s = NamedSubstituents.normalize(s);
        for (String n : sIDCodeMap.keySet()) {
            if (!n.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

