/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import java.util.ArrayList;

public class RingCollection {
    public static final int MAX_SMALL_RING_SIZE = 7;
    private static final int MAX_SMALL_RING_COUNT = 1024;
    private static final int MODE_SMALL_RINGS = 1;
    private static final int MODE_LARGE_RINGS = 2;
    private static final int MODE_AROMATICITY = 4;
    public static final int MODE_SMALL_RINGS_ONLY = 1;
    public static final int MODE_SMALL_AND_LARGE_RINGS = 3;
    public static final int MODE_SMALL_RINGS_AND_AROMATICITY = 5;
    public static final int MODE_SMALL_AND_LARGE_RINGS_AND_AROMATICITY = 7;
    public static final int MODE_INCLUDE_TAUTOMERIC_BONDS = 8;
    private ExtendedMolecule mMol;
    private ArrayList<int[]> mRingAtomSet;
    private ArrayList<int[]> mRingBondSet;
    private int[] mAtomRingSize;
    private int[] mBondRingSize;
    private int[] mHeteroPosition;
    private boolean[] mIsAromatic;
    private boolean[] mIsDelocalized;
    private int mMaxSmallRingSize;

    public RingCollection(ExtendedMolecule mol, int mode) {
        this(mol, mode, 7);
    }

    public RingCollection(ExtendedMolecule mol, int mode, int maxSmallRingSize) {
        int startAtom;
        boolean found;
        this.mMol = mol;
        this.mMaxSmallRingSize = maxSmallRingSize;
        this.mRingAtomSet = new ArrayList();
        this.mRingBondSet = new ArrayList();
        this.mAtomRingSize = new int[this.mMol.getAtoms()];
        this.mBondRingSize = new int[this.mMol.getBonds()];
        this.mMol.ensureHelperArrays(1);
        boolean[] isConfirmedChainAtom = new boolean[this.mMol.getAtoms()];
        boolean[] isConfirmedChainBond = new boolean[this.mMol.getBonds()];
        do {
            found = false;
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                int i;
                if (isConfirmedChainAtom[atom]) continue;
                int potentialRingNeighbours = 0;
                for (i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                    if (isConfirmedChainAtom[this.mMol.getConnAtom(atom, i)]) continue;
                    ++potentialRingNeighbours;
                }
                if (potentialRingNeighbours >= 2) continue;
                isConfirmedChainAtom[atom] = true;
                for (i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                    isConfirmedChainBond[this.mMol.getConnBond((int)atom, (int)i)] = true;
                }
                found = true;
            }
        } while (found);
        for (startAtom = 0; startAtom < this.mMol.getAtoms() && isConfirmedChainAtom[startAtom]; ++startAtom) {
        }
        if (startAtom == this.mMol.getAtoms()) {
            return;
        }
        int[] graphAtom = new int[this.mMol.getAtoms()];
        graphAtom[0] = startAtom;
        int[] parent = new int[this.mMol.getAtoms()];
        parent[0] = -1;
        int[] fragmentNo = new int[this.mMol.getAtoms()];
        fragmentNo[startAtom] = 1;
        int current = 0;
        int highest = 0;
        int noOfFragments = 1;
        block5: while (current <= highest) {
            for (int i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                if (candidate == parent[graphAtom[current]]) continue;
                if (fragmentNo[candidate] != 0) {
                    this.addSmallRingsToSet(this.mMol.getConnBond(graphAtom[current], i), isConfirmedChainAtom);
                    continue;
                }
                if (isConfirmedChainAtom[candidate]) continue;
                fragmentNo[candidate] = noOfFragments;
                parent[candidate] = graphAtom[current];
                graphAtom[++highest] = candidate;
            }
            if (++current <= highest) continue;
            for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (fragmentNo[atom] != 0 || isConfirmedChainAtom[atom]) continue;
                fragmentNo[atom] = ++noOfFragments;
                graphAtom[++highest] = atom;
                parent[atom] = -1;
                continue block5;
            }
        }
        if ((mode & 4) != 0) {
            this.mIsAromatic = new boolean[this.mRingAtomSet.size()];
            this.mIsDelocalized = new boolean[this.mRingAtomSet.size()];
            this.mHeteroPosition = new int[this.mRingAtomSet.size()];
            this.determineAromaticity(this.mIsAromatic, this.mIsDelocalized, this.mHeteroPosition, (mode & 8) != 0);
        }
        if ((mode & 2) != 0) {
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                int[] ringAtom;
                if (isConfirmedChainBond[bond] || this.mMol.getBondOrder(bond) == 0 || (ringAtom = this.findSmallestRing(bond, isConfirmedChainAtom)) == null) continue;
                this.updateRingSizes(ringAtom, this.getRingBonds(ringAtom));
            }
        }
    }

    private int[] findSmallestRing(int bond, boolean[] isConfirmedChainAtom) {
        int atom1 = this.mMol.getBondAtom(0, bond);
        int atom2 = this.mMol.getBondAtom(1, bond);
        int[] graphAtom = new int[this.mMol.getAtoms()];
        int[] graphLevel = new int[this.mMol.getAtoms()];
        int[] graphParent = new int[this.mMol.getAtoms()];
        graphAtom[0] = atom1;
        graphAtom[1] = atom2;
        graphLevel[atom1] = 1;
        graphLevel[atom2] = 2;
        graphParent[atom1] = -1;
        graphParent[atom2] = atom1;
        int highest = 1;
        for (int current = 1; current <= highest; ++current) {
            for (int i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                if (current > 1 && candidate == atom1) {
                    int[] ringAtom = new int[graphLevel[graphAtom[current]]];
                    int atom = graphAtom[current];
                    for (int j = 0; j < ringAtom.length; ++j) {
                        ringAtom[j] = atom;
                        atom = graphParent[atom];
                    }
                    return ringAtom;
                }
                if (graphLevel[candidate] != 0 || isConfirmedChainAtom[candidate]) continue;
                graphAtom[++highest] = candidate;
                graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
                graphParent[candidate] = graphAtom[current];
            }
        }
        return null;
    }

    public int getAtomRingSize(int atom) {
        return this.mAtomRingSize[atom];
    }

    public int getBondRingSize(int bond) {
        return this.mBondRingSize[bond];
    }

    private void addSmallRingsToSet(int closureBond, boolean[] isConfirmedChainAtom) {
        int[] graphAtom = new int[this.mMaxSmallRingSize];
        int[] connIndex = new int[this.mMaxSmallRingSize];
        boolean[] isUsed = new boolean[this.mMol.getAtoms()];
        int atom1 = this.mMol.getBondAtom(0, closureBond);
        int atom2 = this.mMol.getBondAtom(1, closureBond);
        graphAtom[0] = atom1;
        graphAtom[1] = atom2;
        connIndex[1] = -1;
        isUsed[atom2] = true;
        int current = 1;
        while (current >= 1) {
            int n = current;
            connIndex[n] = connIndex[n] + 1;
            if (connIndex[current] == this.mMol.getConnAtoms(graphAtom[current])) {
                isUsed[graphAtom[current]] = false;
                --current;
                continue;
            }
            int candidate = this.mMol.getConnAtom(graphAtom[current], connIndex[current]);
            if (isUsed[candidate] || isConfirmedChainAtom[candidate]) continue;
            if (candidate == atom1 && current > 1) {
                this.addRingIfNew(graphAtom, current + 1);
                if (this.mRingAtomSet.size() < 1024) continue;
                return;
            }
            if (current + 1 >= this.mMaxSmallRingSize) continue;
            graphAtom[++current] = candidate;
            isUsed[candidate] = true;
            connIndex[current] = -1;
        }
    }

    private void addRingIfNew(int[] ringAtom, int ringSize) {
        int i;
        int lowAtom = this.mMol.getMaxAtoms();
        int lowIndex = 0;
        for (int i2 = 0; i2 < ringSize; ++i2) {
            if (lowAtom <= ringAtom[i2]) continue;
            lowAtom = ringAtom[i2];
            lowIndex = i2;
        }
        int[] sortedRing = new int[ringSize];
        int leftIndex = lowIndex > 0 ? lowIndex - 1 : ringSize - 1;
        int rightIndex = lowIndex < ringSize - 1 ? lowIndex + 1 : 0;
        boolean inverse = ringAtom[leftIndex] < ringAtom[rightIndex];
        for (i = 0; i < ringSize; ++i) {
            sortedRing[i] = ringAtom[lowIndex];
            if (inverse) {
                if (--lowIndex >= 0) continue;
                lowIndex = ringSize - 1;
                continue;
            }
            if (++lowIndex != ringSize) continue;
            lowIndex = 0;
        }
        for (i = 0; i < this.mRingAtomSet.size(); ++i) {
            int[] ringOfSet = this.mRingAtomSet.get(i);
            if (ringOfSet.length != ringSize) continue;
            boolean equal = true;
            for (int j = 0; j < ringSize; ++j) {
                if (ringOfSet[j] == sortedRing[j]) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            return;
        }
        this.mRingAtomSet.add(sortedRing);
        int[] ringBond = this.getRingBonds(sortedRing);
        this.mRingBondSet.add(ringBond);
        this.updateRingSizes(sortedRing, ringBond);
    }

    public int getSize() {
        return this.mRingAtomSet.size();
    }

    public int[] getRingAtoms(int ringNo) {
        return this.mRingAtomSet.get(ringNo);
    }

    public int[] getRingBonds(int ringNo) {
        return this.mRingBondSet.get(ringNo);
    }

    public int getRingSize(int ringNo) {
        return this.mRingBondSet.get(ringNo).length;
    }

    public boolean isAromatic(int ringNo) {
        return this.mIsAromatic[ringNo];
    }

    public boolean isDelocalized(int ringNo) {
        return this.mIsDelocalized[ringNo];
    }

    public int getAtomIndex(int ringNo, int atom) {
        int[] ringAtom = this.mRingAtomSet.get(ringNo);
        for (int i = 0; i < ringAtom.length; ++i) {
            if (atom != ringAtom[i]) continue;
            return i;
        }
        return -1;
    }

    public int getBondIndex(int ringNo, int bond) {
        int[] ringBond = this.mRingBondSet.get(ringNo);
        for (int i = 0; i < ringBond.length; ++i) {
            if (bond != ringBond[i]) continue;
            return i;
        }
        return -1;
    }

    public int validateMemberIndex(int ringNo, int index) {
        int ringSize = this.mRingBondSet.get(ringNo).length;
        while (index >= ringSize) {
            index -= ringSize;
        }
        while (index < 0) {
            index += ringSize;
        }
        return index;
    }

    public int getHeteroPosition(int ringNo) {
        return this.mHeteroPosition[ringNo];
    }

    public boolean isAtomMember(int ringNo, int atom) {
        int[] ringAtom = this.mRingAtomSet.get(ringNo);
        for (int i = 0; i < ringAtom.length; ++i) {
            if (atom != ringAtom[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isBondMember(int ringNo, int bond) {
        int[] ringBond = this.mRingBondSet.get(ringNo);
        for (int i = 0; i < ringBond.length; ++i) {
            if (bond != ringBond[i]) continue;
            return true;
        }
        return false;
    }

    public int getSharedRing(int bond1, int bond2) {
        for (int i = 0; i < this.mRingBondSet.size(); ++i) {
            if (!this.isBondMember(i, bond1) || !this.isBondMember(i, bond2)) continue;
            return i;
        }
        return -1;
    }

    private void updateRingSizes(int[] ringAtom, int[] ringBond) {
        int i;
        int ringSize = ringAtom.length;
        for (i = 0; i < ringSize; ++i) {
            if (this.mAtomRingSize[ringAtom[i]] != 0 && this.mAtomRingSize[ringAtom[i]] <= ringSize) continue;
            this.mAtomRingSize[ringAtom[i]] = ringSize;
        }
        for (i = 0; i < ringSize; ++i) {
            if (this.mBondRingSize[ringBond[i]] != 0 && this.mBondRingSize[ringBond[i]] <= ringSize) continue;
            this.mBondRingSize[ringBond[i]] = ringSize;
        }
    }

    private int[] getRingBonds(int[] ringAtom) {
        int ringAtoms = ringAtom.length;
        int[] ringBond = new int[ringAtoms];
        block0: for (int i = 0; i < ringAtoms; ++i) {
            int atom = i == ringAtoms - 1 ? ringAtom[0] : ringAtom[i + 1];
            for (int j = 0; j < this.mMol.getConnAtoms(ringAtom[i]); ++j) {
                if (this.mMol.getConnAtom(ringAtom[i], j) != atom) continue;
                ringBond[i] = this.mMol.getConnBond(ringAtom[i], j);
                continue block0;
            }
        }
        return ringBond;
    }

    public void determineAromaticity(boolean[] isAromatic, boolean[] isDelocalized, int[] heteroPosition, boolean includeTautomericBonds) {
        int[][] annelatedRing = new int[this.mRingAtomSet.size()][];
        for (int i = 0; i < this.mRingAtomSet.size(); ++i) {
            annelatedRing[i] = new int[this.mRingAtomSet.get(i).length];
            for (int j = 0; j < this.mRingAtomSet.get(i).length; ++j) {
                annelatedRing[i][j] = -1;
            }
        }
        int[] ringMembership = new int[this.mMol.getBonds()];
        for (int ring = 0; ring < this.mRingBondSet.size(); ++ring) {
            int[] ringBond = this.mRingBondSet.get(ring);
            if (ringBond.length != 3 && (ringBond.length < 5 || ringBond.length > 7)) continue;
            for (int i = 0; i < ringBond.length; ++i) {
                int bond = ringBond[i];
                if (this.mMol.getConnAtoms(this.mMol.getBondAtom(0, bond)) != 3 || this.mMol.getConnAtoms(this.mMol.getBondAtom(1, bond)) != 3) continue;
                if (ringMembership[bond] > 0) {
                    annelatedRing[ringMembership[bond] >>> 16][ringMembership[bond] & Short.MAX_VALUE] = ring;
                    annelatedRing[ring][i] = ringMembership[bond] >>> 16;
                    continue;
                }
                ringMembership[bond] = (ring << 16) + 32768 + i;
            }
        }
        boolean[] aromaticityHandled = new boolean[this.mRingAtomSet.size()];
        int ringsHandled = 0;
        int lastRingsHandled = -1;
        while (ringsHandled > lastRingsHandled) {
            lastRingsHandled = ringsHandled;
            for (int ring = 0; ring < this.mRingAtomSet.size(); ++ring) {
                if (aromaticityHandled[ring] || !this.determineAromaticity(ring, annelatedRing, aromaticityHandled, isAromatic, isDelocalized, heteroPosition, includeTautomericBonds)) continue;
                aromaticityHandled[ring] = true;
                ++ringsHandled;
            }
        }
    }

    private boolean determineAromaticity(int ringNo, int[][] annelatedRing, boolean[] aromaticityHandled, boolean[] isAromatic, boolean[] isDelocalized, int[] heteroPosition, boolean includeTautomericBonds) {
        int[] ringAtom;
        for (int atom : ringAtom = this.mRingAtomSet.get(ringNo)) {
            if (RingCollection.qualifiesAsAromatic(this.mMol.getAtomicNo(atom))) continue;
            return true;
        }
        int[] ringBond = this.mRingBondSet.get(ringNo);
        int ringBonds = ringBond.length;
        int bondSequence = 0;
        int aromaticButNotDelocalizedSequence = 0;
        boolean unhandledAnnelatedRingFound = false;
        for (int i = 0; i < ringBonds; ++i) {
            bondSequence <<= 1;
            aromaticButNotDelocalizedSequence <<= 1;
            if (this.qualifiesAsPiBond(ringBond[i])) {
                bondSequence |= 1;
                continue;
            }
            if (includeTautomericBonds && this.qualifiesAsAmideTypeBond(ringBond[i])) {
                bondSequence |= 1;
                aromaticButNotDelocalizedSequence |= 1;
                continue;
            }
            int annelated = annelatedRing[ringNo][i];
            if (annelated == -1) continue;
            if (aromaticityHandled[annelated]) {
                if (!isAromatic[annelated]) continue;
                bondSequence |= 1;
                if (isDelocalized[annelated]) continue;
                aromaticButNotDelocalizedSequence |= 1;
                continue;
            }
            unhandledAnnelatedRingFound = true;
        }
        boolean hasDelocalizationLeak = false;
        switch (ringBonds) {
            case 3: {
                int[] cSequence3Ring = new int[]{2, 1, 4};
                hasDelocalizationLeak = true;
                for (int carbeniumPosition = 0; carbeniumPosition < 3; ++carbeniumPosition) {
                    if ((bondSequence & cSequence3Ring[carbeniumPosition]) != cSequence3Ring[carbeniumPosition] || (this.mMol.getAtomicNo(ringAtom[carbeniumPosition]) != 6 || this.mMol.getAtomCharge(ringAtom[carbeniumPosition]) != 1) && (this.mMol.getAtomicNo(ringAtom[carbeniumPosition]) != 5 || this.mMol.getAtomCharge(ringAtom[carbeniumPosition]) != 0)) continue;
                    isAromatic[ringNo] = true;
                    heteroPosition[ringNo] = carbeniumPosition;
                    if ((aromaticButNotDelocalizedSequence & cSequence3Ring[carbeniumPosition]) != 0) continue;
                    hasDelocalizationLeak = false;
                }
                break;
            }
            case 5: {
                int[] cSequence5Ring = new int[]{10, 5, 18, 9, 20};
                hasDelocalizationLeak = true;
                block15: for (int position = 0; position < 5; ++position) {
                    if ((bondSequence & cSequence5Ring[position]) != cSequence5Ring[position]) continue;
                    switch (this.mMol.getAtomicNo(ringAtom[position])) {
                        case 6: {
                            if (this.mMol.getAtomCharge(ringAtom[position]) != -1) continue block15;
                            isAromatic[ringNo] = true;
                            heteroPosition[ringNo] = position;
                            if ((aromaticButNotDelocalizedSequence & cSequence5Ring[position]) != 0) continue block15;
                            hasDelocalizationLeak = false;
                            continue block15;
                        }
                        case 7: {
                            if (this.mMol.getAtomCharge(ringAtom[position]) > 0) continue block15;
                            isAromatic[ringNo] = true;
                            heteroPosition[ringNo] = position;
                            continue block15;
                        }
                        case 8: {
                            isAromatic[ringNo] = true;
                            heteroPosition[ringNo] = position;
                            continue block15;
                        }
                        case 16: 
                        case 34: 
                        case 52: {
                            if (this.mMol.getConnAtoms(ringAtom[position]) != 2) continue block15;
                            isAromatic[ringNo] = true;
                            heteroPosition[ringNo] = position;
                        }
                    }
                }
                break;
            }
            case 6: {
                hasDelocalizationLeak = true;
                if ((bondSequence & 0x15) == 21) {
                    isAromatic[ringNo] = true;
                    if ((aromaticButNotDelocalizedSequence & 0x15) == 0) {
                        hasDelocalizationLeak = false;
                    }
                }
                if ((bondSequence & 0x2A) != 42) break;
                isAromatic[ringNo] = true;
                if ((aromaticButNotDelocalizedSequence & 0x2A) != 0) break;
                hasDelocalizationLeak = false;
                break;
            }
            case 7: {
                int[] cSequence7Ring = new int[]{42, 21, 74, 37, 82, 41, 84};
                hasDelocalizationLeak = true;
                for (int carbeniumPosition = 0; carbeniumPosition < 7; ++carbeniumPosition) {
                    if ((bondSequence & cSequence7Ring[carbeniumPosition]) != cSequence7Ring[carbeniumPosition] || (this.mMol.getAtomicNo(ringAtom[carbeniumPosition]) != 6 || this.mMol.getAtomCharge(ringAtom[carbeniumPosition]) != 1) && (this.mMol.getAtomicNo(ringAtom[carbeniumPosition]) != 5 || this.mMol.getAtomCharge(ringAtom[carbeniumPosition]) != 0)) continue;
                    isAromatic[ringNo] = true;
                    heteroPosition[ringNo] = carbeniumPosition;
                    if ((aromaticButNotDelocalizedSequence & cSequence7Ring[carbeniumPosition]) != 0) continue;
                    hasDelocalizationLeak = false;
                }
                break;
            }
        }
        if (isAromatic[ringNo] && !hasDelocalizationLeak) {
            isDelocalized[ringNo] = true;
        }
        if (isAromatic[ringNo]) {
            return true;
        }
        return !unhandledAnnelatedRingFound;
    }

    private boolean qualifiesAsPiBond(int bond) {
        return this.mMol.getBondOrder(bond) > 1 || this.mMol.getBondType(bond) == 64;
    }

    public boolean qualifiesAsAmideTypeBond(int bond) {
        for (int i = 0; i < 2; ++i) {
            int atom2;
            int atom1 = this.mMol.getBondAtom(i, bond);
            if (this.mMol.getAtomicNo(atom1) != 7 || this.mMol.getConnAtoms(atom1) != 2 || this.mMol.getAtomicNo(atom2 = this.mMol.getBondAtom(1 - i, bond)) != 6) continue;
            for (int j = 0; j < this.mMol.getConnAtoms(atom2); ++j) {
                int connAtom = this.mMol.getConnAtom(atom2, j);
                int connBond = this.mMol.getConnBond(atom2, j);
                if (this.mMol.getAtomicNo(connAtom) != 8 && this.mMol.getAtomicNo(connAtom) != 16 || this.mMol.getBondOrder(connBond) != 2 || this.mMol.getConnAtoms(connAtom) != 1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean qualifiesAsAromatic(int atomicNo) {
        return atomicNo == 5 || atomicNo == 6 || atomicNo == 7 || atomicNo == 8 || atomicNo == 15 || atomicNo == 16 || atomicNo == 33 || atomicNo == 34;
    }
}

