/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class SSSearcher {
    public static final int cMatchAtomCharge = 1;
    public static final int cMatchAtomMass = 2;
    public static final int cMatchDBondToDelocalized = 4;
    public static final int cMatchAromDBondToDelocalized = 8;
    public static final int cIndexMatchMode = 4;
    public static final int cDefaultMatchMode = 8;
    public static final int cCountModeExistance = 1;
    public static final int cCountModeFirstMatch = 2;
    public static final int cCountModeSeparated = 3;
    public static final int cCountModeOverlapping = 4;
    public static final int cCountModeRigorous = 5;
    public static final int cCountModeUnique = 6;
    private int mDefaultMatchMode;
    protected StereoMolecule mMolecule;
    protected StereoMolecule mFragment;
    private int[] mMoleculeAtomType;
    private int[] mFragmentAtomType;
    private long[] mMoleculeAtomFeatures;
    private long[] mFragmentAtomFeatures;
    private long[] mMoleculeRingFeatures;
    private long[] mFragmentRingFeatures;
    private int[] mMoleculeBondFeatures;
    private int[] mFragmentBondFeatures;
    private int mFragmentExcludeAtoms;
    private int mFragmentExcludeBonds;
    private int mFragmentGraphSize;
    private int mFragmentGraphSizeWithExcludeGroups;
    private int[] mFragmentGraphAtom;
    private int[] mFragmentGraphParentAtom;
    private int[] mFragmentGraphParentBond;
    private boolean[] mFragmentGraphIsRingClosure;
    private boolean[] mIsExcludeAtom;
    private int[] mFragmentConnAtoms;
    private int[] mMatchTable;
    private int[] mExcludeGroupNo;
    private int[] mExcludeGroupGraphIndex;
    private int[] mFragmentAtomContextRank;
    private TreeSet<int[]> mSortedMatchSet;
    private ArrayList<int[]> mMatchList;
    private ArrayList<BridgeBond> mBridgeBondList;
    private boolean mMoleculeFeaturesValid;
    private boolean mFragmentFeaturesValid;
    private int mRequiredHelperLevel;
    private int mExcludeGroupCount;
    private volatile boolean mStop;

    public SSSearcher() {
        this.mDefaultMatchMode = 8;
        this.mMatchList = new ArrayList();
        this.mSortedMatchSet = new TreeSet<int[]>(new IntArrayComparator());
    }

    public SSSearcher(int matchMode) {
        this.mDefaultMatchMode = matchMode;
        this.mMatchList = new ArrayList();
        this.mSortedMatchSet = new TreeSet<int[]>(new IntArrayComparator());
    }

    public void setMol(StereoMolecule fragment, StereoMolecule molecule) {
        this.setMolecule(molecule);
        this.setFragment(fragment);
    }

    public void setMolecule(StereoMolecule molecule) {
        if (molecule == null || molecule.getAllAtoms() == 0) {
            this.mMolecule = null;
            return;
        }
        this.mMolecule = molecule;
        this.mMoleculeFeaturesValid = false;
        this.mMolecule.ensureHelperArrays(1);
    }

    public void stop() {
        this.mStop = true;
    }

    public void setFragment(StereoMolecule fragment) {
        int bond;
        int atom;
        if (fragment == null || fragment.getAllAtoms() == 0 || !fragment.isFragment()) {
            this.mFragment = null;
            return;
        }
        this.mFragment = fragment;
        this.mFragmentFeaturesValid = false;
        this.mFragment.ensureHelperArrays(1);
        this.mRequiredHelperLevel = 7;
        for (atom = 0; atom < this.mFragment.getAtoms(); ++atom) {
            if ((this.mFragment.getAtomQueryFeatures(atom) & 0x2000L) == 0L) continue;
            this.mRequiredHelperLevel = 15;
        }
        for (bond = 0; bond < this.mFragment.getBonds(); ++bond) {
            if ((this.mFragment.getBondQueryFeatures(bond) & 0x40000) == 0) continue;
            this.mRequiredHelperLevel = 15;
        }
        if (this.mMoleculeFeaturesValid && this.mRequiredHelperLevel != 7) {
            this.mMolecule.ensureHelperArrays(this.mRequiredHelperLevel);
        }
        this.mFragmentExcludeAtoms = 0;
        this.mFragmentExcludeBonds = 0;
        this.mIsExcludeAtom = new boolean[this.mFragment.getAtoms()];
        for (atom = 0; atom < this.mFragment.getAtoms(); ++atom) {
            boolean bl = this.mIsExcludeAtom[atom] = (this.mFragment.getAtomQueryFeatures(atom) & 0x20000000L) != 0L;
            if (!this.mIsExcludeAtom[atom]) continue;
            ++this.mFragmentExcludeAtoms;
        }
        this.mExcludeGroupCount = 0;
        this.mExcludeGroupNo = null;
        this.mFragmentAtomContextRank = null;
        if (this.mFragmentExcludeAtoms != 0) {
            if (this.mFragmentExcludeAtoms != 0) {
                for (bond = 0; bond < this.mFragment.getBonds(); ++bond) {
                    if (!this.mIsExcludeAtom[this.mFragment.getBondAtom(0, bond)] && !this.mIsExcludeAtom[this.mFragment.getBondAtom(1, bond)]) continue;
                    ++this.mFragmentExcludeBonds;
                }
            }
            for (atom = 0; atom < this.mFragment.getAllAtoms(); ++atom) {
                this.mFragment.setAtomMarker(atom, this.mIsExcludeAtom[atom]);
            }
            this.mExcludeGroupNo = new int[this.mFragment.getAllAtoms()];
            this.mExcludeGroupCount = this.mFragment.getFragmentNumbers(this.mExcludeGroupNo, true, false);
        }
    }

    public void setFragmentSymmetryConstraints(int[] fragmentContextRank) {
        this.mFragmentAtomContextRank = fragmentContextRank;
    }

    private void buildFragmentGraph() {
        int i;
        this.mFragment.ensureHelperArrays(this.mRequiredHelperLevel);
        int graphAllocation = Math.max(this.mFragment.getAtoms(), this.mFragment.getBonds()) + 16;
        this.mFragmentGraphAtom = new int[graphAllocation];
        this.mFragmentGraphParentAtom = new int[graphAllocation];
        this.mFragmentGraphParentBond = new int[graphAllocation];
        this.mFragmentGraphIsRingClosure = new boolean[graphAllocation + 1];
        boolean[] fragmentAtomUsed = new boolean[this.mFragment.getAtoms()];
        boolean[] fragmentBondUsed = new boolean[this.mFragment.getBonds()];
        int current = 0;
        for (int atom = 0; atom < this.mFragment.getAtoms(); ++atom) {
            if (this.mIsExcludeAtom[atom] || fragmentAtomUsed[atom]) continue;
            this.mFragmentGraphAtom[current] = atom;
            this.mFragmentGraphParentBond[current] = -1;
            this.mFragmentGraphParentAtom[current] = -1;
            int highest = current;
            while (current <= highest) {
                for (i = 0; i < this.mFragment.getAllConnAtomsPlusMetalBonds(this.mFragmentGraphAtom[current]); ++i) {
                    highest = this.tryAddCandidate(current, highest, i, fragmentAtomUsed, fragmentBondUsed, -1);
                }
                while (this.mFragmentGraphIsRingClosure[++current]) {
                }
            }
        }
        this.mFragmentGraphSize = current;
        if (this.mFragmentExcludeAtoms != 0) {
            int i2;
            int highest = this.mFragmentGraphSize - 1;
            for (int excludeGroupNo = 0; excludeGroupNo < this.mExcludeGroupCount; ++excludeGroupNo) {
                current = 0;
                while (current <= highest) {
                    for (i = 0; i < this.mFragment.getAllConnAtomsPlusMetalBonds(this.mFragmentGraphAtom[current]); ++i) {
                        highest = this.tryAddCandidate(current, highest, i, fragmentAtomUsed, fragmentBondUsed, excludeGroupNo);
                    }
                    while (this.mFragmentGraphIsRingClosure[++current]) {
                    }
                }
            }
            for (int atom = 0; atom < this.mFragment.getAtoms(); ++atom) {
                if (!this.mIsExcludeAtom[atom] || fragmentAtomUsed[atom]) continue;
                this.mFragmentGraphAtom[current] = atom;
                this.mFragmentGraphParentBond[current] = -1;
                this.mFragmentGraphParentAtom[current] = -1;
                highest = current;
                while (current <= highest) {
                    for (i = 0; i < this.mFragment.getAllConnAtomsPlusMetalBonds(this.mFragmentGraphAtom[current]); ++i) {
                        if (this.mFragment.getConnAtom(this.mFragmentGraphAtom[current], i) >= this.mFragment.getAtoms()) continue;
                        highest = this.tryAddCandidate(current, highest, i, fragmentAtomUsed, fragmentBondUsed, this.mExcludeGroupNo[atom]);
                    }
                    while (this.mFragmentGraphIsRingClosure[++current]) {
                    }
                }
            }
            this.mExcludeGroupGraphIndex = new int[this.mExcludeGroupCount];
            for (i2 = 0; i2 < this.mExcludeGroupCount; ++i2) {
                this.mExcludeGroupGraphIndex[i2] = -1;
            }
            for (i2 = this.mFragmentGraphSize; i2 < current; ++i2) {
                int excludeGroupNo = this.mExcludeGroupNo[this.mFragmentGraphAtom[i2]];
                if (this.mExcludeGroupGraphIndex[excludeGroupNo] != -1) continue;
                this.mExcludeGroupGraphIndex[excludeGroupNo] = i2;
            }
        }
        this.mFragmentGraphSizeWithExcludeGroups = current;
    }

    private int tryAddCandidate(int current, int highest, int i, boolean[] fragmentAtomUsed, boolean[] fragmentBondUsed, int excludeGroupNo) {
        int candidateBond;
        int candidate = this.mFragment.getConnAtom(this.mFragmentGraphAtom[current], i);
        if (!(this.mIsExcludeAtom[candidate] && this.mExcludeGroupNo[candidate] != excludeGroupNo || candidate == this.mFragmentGraphParentAtom[current] || fragmentBondUsed[candidateBond = this.mFragment.getConnBond(this.mFragmentGraphAtom[current], i)] || this.mFragment.isBondBridge(candidateBond))) {
            this.mFragmentGraphAtom[++highest] = candidate;
            this.mFragmentGraphParentAtom[highest] = this.mFragmentGraphAtom[current];
            this.mFragmentGraphParentBond[highest] = candidateBond;
            fragmentBondUsed[candidateBond] = true;
            if (fragmentAtomUsed[candidate]) {
                this.mFragmentGraphIsRingClosure[highest] = true;
            } else {
                fragmentAtomUsed[candidate] = true;
            }
        }
        return highest;
    }

    public ArrayList<int[]> getMatchList() {
        return this.mMatchList;
    }

    public boolean isFragmentInMolecule() {
        return this.findFragmentInMolecule(1, this.mDefaultMatchMode) > 0;
    }

    public boolean isFragmentInMolecule(int matchMode) {
        return this.findFragmentInMolecule(1, matchMode) > 0;
    }

    public int findFragmentInMolecule() {
        return this.findFragmentInMolecule(4, this.mDefaultMatchMode);
    }

    public int findFragmentInMolecule(int countMode, int matchMode) {
        return this.findFragmentInMolecule(countMode, matchMode, null);
    }

    public int findFragmentInMolecule(int countMode, int matchMode, boolean[] atomExcluded) {
        this.mStop = false;
        this.mMatchList = new ArrayList();
        this.mSortedMatchSet.clear();
        if (this.mMolecule == null || this.mFragment == null) {
            return 0;
        }
        if (this.mFragment.getAtoms() - this.mFragmentExcludeAtoms > this.mMolecule.getAtoms() || this.mFragment.getBonds() - this.mFragmentExcludeBonds > this.mMolecule.getBonds()) {
            return 0;
        }
        if (this.mFragment.getAtoms() == 0) {
            return 0;
        }
        if (countMode == 6) {
            this.mRequiredHelperLevel = 63;
        }
        this.setupAtomAndBondFeatures(matchMode);
        boolean[] atomUsed = new boolean[this.mMolecule.getAtoms()];
        if (atomExcluded != null) {
            for (int atom = 0; atom < this.mMolecule.getAtoms(); ++atom) {
                atomUsed[atom] = atomExcluded[atom];
            }
        }
        this.mMatchTable = new int[this.mFragment.getAtoms()];
        Arrays.fill(this.mMatchTable, -1);
        int[] index = new int[this.mFragmentGraphSizeWithExcludeGroups];
        Arrays.fill(index, -1);
        int current = 0;
        while (!this.mStop) {
            if (this.mFragmentGraphSize != 0) {
                int maxIndex = this.mFragmentGraphParentAtom[current] == -1 ? this.mMolecule.getAtoms() : this.mMolecule.getAllConnAtomsPlusMetalBonds(this.mMatchTable[this.mFragmentGraphParentAtom[current]]);
                int n = current;
                index[n] = index[n] + 1;
                if (index[current] == maxIndex) {
                    index[current] = -1;
                    if (current == 0) break;
                    if (this.mFragmentGraphIsRingClosure[--current]) continue;
                    atomUsed[this.mMatchTable[this.mFragmentGraphAtom[current]]] = false;
                    continue;
                }
                if (this.mFragmentGraphParentAtom[current] == -1) {
                    if (!atomUsed[index[current]] && this.areAtomsSimilar(index[current], this.mFragmentGraphAtom[current])) {
                        this.mMatchTable[this.mFragmentGraphAtom[current]] = index[current];
                        atomUsed[index[current]] = true;
                        ++current;
                    }
                } else {
                    if (this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]) >= this.mMolecule.getAtoms()) continue;
                    int candidate = this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]);
                    if (!this.mFragmentGraphIsRingClosure[current]) {
                        if (!atomUsed[candidate] && this.areAtomsSimilar(candidate, this.mFragmentGraphAtom[current]) && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]), this.mFragmentGraphParentBond[current])) {
                            atomUsed[candidate] = true;
                            this.mMatchTable[this.mFragmentGraphAtom[current]] = candidate;
                            ++current;
                        }
                    } else if (candidate == this.mMatchTable[this.mFragmentGraphAtom[current]] && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]), this.mFragmentGraphParentBond[current])) {
                        ++current;
                    }
                }
            }
            if (current != this.mFragmentGraphSize) continue;
            if (this.doTHParitiesMatch(-1) && this.doEZParitiesMatch(-1) && this.doBridgeBondsMatch(atomUsed, -1)) {
                boolean isExcludedMatch = false;
                for (int excludeGroup = 0; excludeGroup < this.mExcludeGroupCount; ++excludeGroup) {
                    if (!this.isExcludeGroupMatch(atomUsed, index, excludeGroup)) continue;
                    isExcludedMatch = true;
                    break;
                }
                if (countMode == 1 && !isExcludedMatch) {
                    return 1;
                }
                if (!isExcludedMatch) {
                    this.addMatchIfQualifies(countMode);
                    if (countMode == 2) {
                        return 1;
                    }
                }
            }
            if (current == 0) break;
            if (this.mFragmentGraphIsRingClosure[--current]) continue;
            atomUsed[this.mMatchTable[this.mFragmentGraphAtom[current]]] = false;
        }
        return this.mMatchList.size();
    }

    private void addMatchIfQualifies(int countMode) {
        int[] sortedMatch;
        if (countMode == 2 || countMode == 5) {
            this.mMatchList.add(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
        } else if (countMode == 4) {
            int[] sortedMatch2 = this.getSortedMatch(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
            if (!this.mSortedMatchSet.contains(sortedMatch2)) {
                this.mSortedMatchSet.add(sortedMatch2);
                this.mMatchList.add(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
            }
        } else if (countMode == 3) {
            int[] sortedMatch3 = this.getSortedMatch(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
            if (!this.mSortedMatchSet.contains(sortedMatch3)) {
                boolean found = false;
                for (int[] existing : this.mSortedMatchSet) {
                    int existingIndex = 0;
                    for (int atom : sortedMatch3) {
                        while (existingIndex < existing.length && existing[existingIndex] < atom) {
                            ++existingIndex;
                        }
                        if (existingIndex >= existing.length || atom != existing[existingIndex]) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) {
                    this.mSortedMatchSet.add(sortedMatch3);
                    this.mMatchList.add(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
                }
            }
        } else if (countMode == 6 && !this.mSortedMatchSet.contains(sortedMatch = this.getSortedSymmetryMatch(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length)))) {
            this.mSortedMatchSet.add(sortedMatch);
            this.mMatchList.add(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
        }
    }

    private int[] getSortedMatch(int[] match) {
        int count = 0;
        for (int atom : match) {
            if (atom != -1) continue;
            ++count;
        }
        if (count != 0) {
            int[] oldMatch = match;
            match = new int[oldMatch.length - count];
            int index = 0;
            for (int atom : oldMatch) {
                if (atom == -1) continue;
                match[index++] = atom;
            }
        }
        Arrays.sort(match);
        return match;
    }

    private int[] getSortedSymmetryMatch(int[] match) {
        int count = 0;
        for (int atom : match) {
            if (atom != -1) continue;
            ++count;
        }
        int[] symmetryMatch = new int[match.length - count];
        int index = 0;
        for (int i = 0; i < match.length; ++i) {
            if (match[i] == -1) continue;
            symmetryMatch[index] = this.mFragment.getSymmetryRank(i) << 16 | this.mMolecule.getSymmetryRank(match[i]);
            if (this.mFragmentAtomContextRank != null) {
                int n = index;
                symmetryMatch[n] = symmetryMatch[n] | this.mFragmentAtomContextRank[i] << 24;
            }
            ++index;
        }
        Arrays.sort(symmetryMatch);
        return symmetryMatch;
    }

    public boolean areAtomsSimilar(int moleculeAtom, int fragmentAtom) {
        int targetRingSize;
        long moleculeRingQF;
        int fragmentConnAtoms = this.mFragmentConnAtoms[fragmentAtom];
        int moleculeConnAtoms = this.mMolecule.getConnAtoms(moleculeAtom);
        if (fragmentConnAtoms > moleculeConnAtoms) {
            return false;
        }
        long moleculeQF = this.mMolecule.getAtomQueryFeatures(moleculeAtom);
        long fragmentQF = this.mFragment.getAtomQueryFeatures(fragmentAtom);
        int[] fragmentList = this.mFragment.getAtomList(fragmentAtom);
        int[] moleculeList = this.mMolecule.getAtomList(moleculeAtom);
        if ((fragmentQF & 1L) != 0L) {
            if (fragmentList != null) {
                if ((moleculeQF & 1L) != 0L) {
                    if (moleculeList == null) {
                        return false;
                    }
                    if (!this.isSubListOf(fragmentList, moleculeList)) {
                        return false;
                    }
                } else if (moleculeList != null ? this.listsOverlap(moleculeList, fragmentList) : this.isListMember(this.mMolecule.getAtomicNo(moleculeAtom), fragmentList)) {
                    return false;
                }
            }
        } else {
            if ((moleculeQF & 1L) != 0L) {
                return false;
            }
            if (fragmentList != null) {
                if (moleculeList != null ? !this.isSubListOf(moleculeList, fragmentList) : !this.isListMember(this.mMolecule.getAtomicNo(moleculeAtom), fragmentList)) {
                    return false;
                }
            } else {
                if (moleculeList != null) {
                    return false;
                }
                if (this.mMoleculeAtomType[moleculeAtom] != this.mFragmentAtomType[fragmentAtom]) {
                    return false;
                }
            }
        }
        if ((moleculeQF | fragmentQF) != 0L) {
            if ((fragmentQF & 0x800L) != 0L) {
                if (this.mMolecule.isFragment() && (moleculeQF & 0x800L) == 0L) {
                    return false;
                }
                if (fragmentConnAtoms != moleculeConnAtoms) {
                    return false;
                }
            }
            if ((fragmentQF & 0x1000L) != 0L && fragmentConnAtoms >= moleculeConnAtoms && (moleculeQF & 0x1000L) == 0L) {
                return false;
            }
        }
        if ((this.mMoleculeAtomFeatures[moleculeAtom] & (this.mFragmentAtomFeatures[fragmentAtom] ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return false;
        }
        if ((this.mFragmentRingFeatures[fragmentAtom] & (this.mMoleculeRingFeatures[moleculeAtom] ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return false;
        }
        long fragmentRingQF = fragmentQF & 0x7F00000000L;
        if (this.mMolecule.isFragment() ? (moleculeRingQF = fragmentQF & 0x7F00000000L) != 0L && (fragmentRingQF == 0L || (fragmentRingQF & (moleculeRingQF ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) : fragmentRingQF != 0L && (fragmentRingQF & this.mMoleculeRingFeatures[moleculeAtom]) == 0L) {
            return false;
        }
        if (this.mFragment.getAtomCharge(fragmentAtom) != 0 && this.mFragment.getAtomCharge(fragmentAtom) != this.mMolecule.getAtomCharge(moleculeAtom)) {
            return false;
        }
        if (this.mFragment.getAtomMass(fragmentAtom) != 0 && this.mFragment.getAtomMass(fragmentAtom) != this.mMolecule.getAtomMass(moleculeAtom)) {
            return false;
        }
        if (this.mFragment.getAtomRadical(fragmentAtom) != 0 && this.mFragment.getAtomRadical(fragmentAtom) != this.mMolecule.getAtomRadical(moleculeAtom)) {
            return false;
        }
        int smallestRingSize = (int)((this.mFragment.getAtomQueryFeatures(fragmentAtom) & 0x1C00000L) >> 22);
        return smallestRingSize == 0 || !(!this.mMolecule.isFragment() ? this.mMolecule.getAtomRingSize(moleculeAtom) != smallestRingSize : smallestRingSize != (targetRingSize = (int)((this.mMolecule.getAtomQueryFeatures(moleculeAtom) & 0x1C00000L) >> 22)));
    }

    private boolean doTHParitiesMatch(int excludeGroupNo) {
        int esrGroupAtomCount = 0;
        for (int fragmentAtom = 0; fragmentAtom < this.mFragment.getAtoms(); ++fragmentAtom) {
            if (this.mExcludeGroupNo != null && this.mExcludeGroupNo[fragmentAtom] != excludeGroupNo || (this.mFragment.getAtomQueryFeatures(fragmentAtom) & 0x2000L) == 0L) continue;
            int moleculeAtom = this.mMatchTable[fragmentAtom];
            int fragmentParity = this.mFragment.getAtomParity(fragmentAtom);
            int moleculeParity = this.mMolecule.getAtomParity(moleculeAtom);
            if (fragmentParity == 0 || moleculeParity == 0 || fragmentParity == 3) continue;
            if (moleculeParity == 3) {
                return false;
            }
            if (this.mFragment.getAtomESRType(fragmentAtom) == 1) {
                ++esrGroupAtomCount;
                continue;
            }
            if (this.mMolecule.getAtomESRType(moleculeAtom) == 1) {
                return false;
            }
            if (this.mFragment.getAtomESRType(fragmentAtom) == 2) {
                ++esrGroupAtomCount;
                continue;
            }
            if (this.mMolecule.getAtomESRType(moleculeAtom) == 2) {
                return false;
            }
            if (this.isTHParityInversion(fragmentAtom) != (fragmentParity == moleculeParity)) continue;
            return false;
        }
        if (esrGroupAtomCount != 0) {
            int[] esrAtom = new int[esrGroupAtomCount];
            int esrAtomIndex = 0;
            for (int fragmentAtom = 0; fragmentAtom < this.mFragment.getAtoms(); ++fragmentAtom) {
                int fragmentParity;
                if (this.mExcludeGroupNo != null && this.mExcludeGroupNo[fragmentAtom] != excludeGroupNo || (this.mFragment.getAtomQueryFeatures(fragmentAtom) & 0x2000L) == 0L || (fragmentParity = this.mFragment.getAtomParity(fragmentAtom)) == 0 || fragmentParity == 3) continue;
                esrAtom[esrAtomIndex++] = this.mFragment.getAtomESRGroup(fragmentAtom) << 24 | this.mFragment.getAtomESRType(fragmentAtom) << 22 | fragmentAtom;
            }
            Arrays.sort(esrAtom);
            esrAtomIndex = 0;
            while (esrAtomIndex < esrAtom.length) {
                int fragmentBaseAtom = esrAtom[esrAtomIndex] & 0x3FFFFF;
                int moleculeBaseAtom = this.mMatchTable[fragmentBaseAtom];
                int baseGroupAndType = esrAtom[esrAtomIndex] & 0xFFC00000;
                boolean baseParityComparison = this.isTHParityInversion(fragmentBaseAtom) ^ this.mFragment.getAtomParity(fragmentBaseAtom) == this.mMolecule.getAtomParity(moleculeBaseAtom);
                ++esrAtomIndex;
                while (esrAtomIndex < esrAtom.length && (esrAtom[esrAtomIndex] & 0xFFC00000) == baseGroupAndType) {
                    int fragmentAtom = esrAtom[esrAtomIndex] & 0x3FFFFF;
                    int moleculeAtom = this.mMatchTable[fragmentAtom];
                    if (this.mMolecule.getAtomESRType(moleculeAtom) != this.mMolecule.getAtomESRType(moleculeBaseAtom) || this.mMolecule.getAtomESRGroup(moleculeAtom) != this.mMolecule.getAtomESRGroup(moleculeBaseAtom)) {
                        return false;
                    }
                    boolean parityComparison = this.isTHParityInversion(fragmentAtom) ^ this.mFragment.getAtomParity(fragmentAtom) == this.mMolecule.getAtomParity(moleculeAtom);
                    if (parityComparison != baseParityComparison) {
                        return false;
                    }
                    ++esrAtomIndex;
                }
            }
        }
        return true;
    }

    private boolean isTHParityInversion(int fragmentAtom) {
        boolean inversion = false;
        if (this.mFragment.getAtomPi(fragmentAtom) == 0) {
            for (int i = 1; i < this.mFragment.getConnAtoms(fragmentAtom); ++i) {
                for (int j = 0; j < i; ++j) {
                    int connAtom2;
                    int connAtom1 = this.mFragment.getConnAtom(fragmentAtom, i);
                    if (!(this.mMatchTable[connAtom1] > this.mMatchTable[connAtom2 = this.mFragment.getConnAtom(fragmentAtom, j)] ^ connAtom1 > connAtom2)) continue;
                    inversion = !inversion;
                }
            }
        } else {
            for (int i = 0; i < this.mFragment.getConnAtoms(fragmentAtom); ++i) {
                int connAtom = this.mFragment.getConnAtom(fragmentAtom, i);
                int neighbours = 0;
                int[] neighbour = new int[3];
                for (int j = 0; j < this.mFragment.getConnAtoms(connAtom); ++j) {
                    neighbour[neighbours] = this.mFragment.getConnAtom(connAtom, j);
                    if (neighbour[neighbours] == fragmentAtom) continue;
                    ++neighbours;
                }
                if (neighbours != 2 || !(this.mMatchTable[neighbour[0]] > this.mMatchTable[neighbour[1]] ^ neighbour[0] > neighbour[1])) continue;
                inversion = !inversion;
            }
        }
        return inversion;
    }

    private boolean doEZParitiesMatch(int excludeGroupNo) {
        for (int fragmentBond = 0; fragmentBond < this.mFragment.getBonds(); ++fragmentBond) {
            int fragmentParity;
            if ((this.mFragment.getBondQueryFeatures(fragmentBond) & 0x40000) == 0 || (fragmentParity = this.mFragment.getBondParity(fragmentBond)) == 0) continue;
            int fragmentAtom1 = this.mFragment.getBondAtom(0, fragmentBond);
            int fragmentAtom2 = this.mFragment.getBondAtom(1, fragmentBond);
            if (this.mExcludeGroupNo != null && (excludeGroupNo != -1 || this.mExcludeGroupNo[fragmentAtom1] != -1 || this.mExcludeGroupNo[fragmentAtom2] != -1) && (excludeGroupNo == -1 || this.mExcludeGroupNo[fragmentAtom1] != excludeGroupNo && this.mExcludeGroupNo[fragmentAtom2] != excludeGroupNo)) continue;
            int moleculeAtom1 = this.mMatchTable[fragmentAtom1];
            int moleculeAtom2 = this.mMatchTable[fragmentAtom2];
            int moleculeBond = this.mMolecule.getBond(moleculeAtom1, moleculeAtom2);
            int moleculeParity = this.mMolecule.getBondParity(moleculeBond);
            if (moleculeParity == 0) {
                if (this.mMolecule.isSmallRingBond(moleculeBond)) {
                    moleculeParity = this.calculateImplicitSmallRingBondParity(moleculeBond);
                }
                if (moleculeParity == 0) continue;
            }
            if (fragmentParity == 3 || moleculeParity == 3 || this.isEZParityInversion(fragmentBond, moleculeBond) != (fragmentParity == moleculeParity)) continue;
            return false;
        }
        return true;
    }

    private int calculateImplicitSmallRingBondParity(int moleculeBond) {
        RingCollection ringSet = this.mMolecule.getRingSet();
        for (int r = 0; r < ringSet.getSize(); ++r) {
            if (!ringSet.isBondMember(r, moleculeBond)) continue;
            int[] relevantAtom = new int[2];
            for (int i = 0; i < 2; ++i) {
                relevantAtom[i] = Integer.MAX_VALUE;
                int bondAtom = this.mMolecule.getBondAtom(i, moleculeBond);
                for (int j = 0; j < this.mMolecule.getConnAtoms(bondAtom); ++j) {
                    int atom = this.mMolecule.getConnAtom(bondAtom, j);
                    if (atom == this.mMolecule.getBondAtom(1 - i, moleculeBond) || relevantAtom[i] <= atom) continue;
                    relevantAtom[i] = atom;
                }
            }
            int memberCount = 0;
            if (ringSet.isAtomMember(r, relevantAtom[0])) {
                ++memberCount;
            }
            if (ringSet.isAtomMember(r, relevantAtom[1])) {
                ++memberCount;
            }
            if (memberCount == 2) {
                return 2;
            }
            if (memberCount == 1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private boolean isEZParityInversion(int fragmentBond, int moleculeBond) {
        boolean inversion = false;
        for (int i = 0; i < 2; ++i) {
            int fragmentAtom = this.mFragment.getBondAtom(i, fragmentBond);
            int moleculeAtom = this.mMatchTable[fragmentAtom];
            if (this.mMolecule.getConnAtoms(moleculeAtom) <= 2) continue;
            int otherFragmentAtom = this.mFragment.getBondAtom(1 - i, fragmentBond);
            int lowFragmentNeighbour = Integer.MAX_VALUE;
            for (int j = 0; j < this.mFragment.getConnAtoms(fragmentAtom); ++j) {
                int fragmentNeighbour = this.mFragment.getConnAtom(fragmentAtom, j);
                if (fragmentNeighbour == otherFragmentAtom || lowFragmentNeighbour <= fragmentNeighbour) continue;
                lowFragmentNeighbour = fragmentNeighbour;
            }
            int otherMoleculeAtom = this.mMatchTable[otherFragmentAtom];
            int lowMoleculeNeighbour = Integer.MAX_VALUE;
            for (int j = 0; j < this.mMolecule.getConnAtoms(moleculeAtom); ++j) {
                int moleculeNeighbour = this.mMolecule.getConnAtom(moleculeAtom, j);
                if (moleculeNeighbour == otherMoleculeAtom || lowMoleculeNeighbour <= moleculeNeighbour) continue;
                lowMoleculeNeighbour = moleculeNeighbour;
            }
            if (this.mMatchTable[lowFragmentNeighbour] == lowMoleculeNeighbour) continue;
            inversion = !inversion;
        }
        return inversion;
    }

    private boolean isExcludeGroupMatch(boolean[] atomUsed, int[] index, int excludeGroupNo) {
        int excludeGroupGraphMax;
        int excludeGroupGraphBase = this.mExcludeGroupGraphIndex[excludeGroupNo];
        for (excludeGroupGraphMax = excludeGroupGraphBase + 1; excludeGroupGraphMax < this.mFragmentGraphSizeWithExcludeGroups && this.mExcludeGroupNo[this.mFragmentGraphAtom[excludeGroupGraphMax]] == excludeGroupNo; ++excludeGroupGraphMax) {
        }
        for (int i = excludeGroupGraphBase; i < excludeGroupGraphMax; ++i) {
            index[i] = -1;
        }
        int current = excludeGroupGraphBase;
        while (true) {
            int maxIndex = this.mFragmentGraphParentAtom[current] == -1 ? this.mMolecule.getAtoms() : this.mMolecule.getAllConnAtomsPlusMetalBonds(this.mMatchTable[this.mFragmentGraphParentAtom[current]]);
            int n = current;
            index[n] = index[n] + 1;
            if (index[current] == maxIndex) {
                index[current] = -1;
                if (current == excludeGroupGraphBase) break;
                if (this.mFragmentGraphIsRingClosure[--current]) continue;
                atomUsed[this.mMatchTable[this.mFragmentGraphAtom[current]]] = false;
                this.mMatchTable[this.mFragmentGraphAtom[current]] = -1;
                continue;
            }
            if (this.mFragmentGraphParentAtom[current] == -1) {
                if (!atomUsed[index[current]] && this.areAtomsSimilar(index[current], this.mFragmentGraphAtom[current])) {
                    this.mMatchTable[this.mFragmentGraphAtom[current]] = index[current];
                    atomUsed[index[current]] = true;
                    ++current;
                }
            } else {
                if (this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]) >= this.mMolecule.getAtoms()) {
                    int n2 = current;
                    index[n2] = index[n2] + 1;
                    continue;
                }
                int candidate = this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]);
                if (!this.mFragmentGraphIsRingClosure[current]) {
                    if (!atomUsed[candidate] && this.areAtomsSimilar(candidate, this.mFragmentGraphAtom[current]) && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]), this.mFragmentGraphParentBond[current])) {
                        atomUsed[candidate] = true;
                        this.mMatchTable[this.mFragmentGraphAtom[current]] = candidate;
                        ++current;
                    }
                } else if (candidate == this.mMatchTable[this.mFragmentGraphAtom[current]] && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[current]], index[current]), this.mFragmentGraphParentBond[current])) {
                    ++current;
                }
            }
            if (current != excludeGroupGraphMax) continue;
            if (this.doTHParitiesMatch(excludeGroupNo) && this.doEZParitiesMatch(excludeGroupNo) && this.doBridgeBondsMatch(atomUsed, excludeGroupNo)) {
                for (int i = excludeGroupGraphBase; i < excludeGroupGraphMax; ++i) {
                    if (this.mFragmentGraphIsRingClosure[i]) continue;
                    int atom = this.mFragmentGraphAtom[i];
                    atomUsed[this.mMatchTable[atom]] = false;
                    this.mMatchTable[atom] = -1;
                }
                return true;
            }
            if (this.mFragmentGraphIsRingClosure[--current]) continue;
            atomUsed[this.mMatchTable[this.mFragmentGraphAtom[current]]] = false;
            this.mMatchTable[this.mFragmentGraphAtom[current]] = -1;
        }
        return false;
    }

    private boolean doBridgeBondsMatch(boolean[] moleculeAtomUsed, int excludeGroupNo) {
        if (this.mBridgeBondList != null) {
            for (BridgeBond bb : this.mBridgeBondList) {
                int bridgeSize;
                if (this.mExcludeGroupNo != null && (excludeGroupNo != -1 || this.mExcludeGroupNo[bb.atom1] != -1 || this.mExcludeGroupNo[bb.atom2] != -1) && (excludeGroupNo == -1 || this.mExcludeGroupNo[bb.atom1] != excludeGroupNo && this.mExcludeGroupNo[bb.atom2] != excludeGroupNo) || (bridgeSize = this.mMolecule.getPathLength(this.mMatchTable[bb.atom1], this.mMatchTable[bb.atom2], bb.maxBridgeSize + 1, moleculeAtomUsed) - 1) >= bb.minBridgeSize && bridgeSize <= bb.maxBridgeSize) continue;
                return false;
            }
        }
        return true;
    }

    public boolean areBondsSimilar(int moleculeBond, int fragmentBond) {
        if ((this.mMoleculeBondFeatures[moleculeBond] & ~this.mFragmentBondFeatures[fragmentBond]) != 0) {
            return false;
        }
        int ringSize = (this.mFragment.getBondQueryFeatures(fragmentBond) & 0x38000) >> 15;
        if (ringSize != 0) {
            if (this.mMolecule.isFragment() && ringSize == (this.mMolecule.getBondQueryFeatures(fragmentBond) & 0x38000) >> 15) {
                return true;
            }
            boolean found = false;
            RingCollection ringSet = this.mMolecule.getRingSet();
            for (int i = 0; i < ringSet.getSize(); ++i) {
                if (ringSet.getRingSize(i) != ringSize || !ringSet.isBondMember(i, moleculeBond)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    private boolean isSubListOf(int[] list1, int[] list2) {
        int i2 = 0;
        for (int i1 = 0; i1 < list1.length; ++i1) {
            int atomicNo1 = list1[i1];
            while (list2[i2] < atomicNo1) {
                if (++i2 != list2.length) continue;
                return false;
            }
            if (list2[i2] <= atomicNo1) continue;
            return false;
        }
        return true;
    }

    private boolean listsOverlap(int[] list1, int[] list2) {
        int i1 = 0;
        int i2 = 0;
        while (i1 < list1.length && i2 < list2.length) {
            int atomicNo1 = list1[i1];
            int atomicNo2 = list2[i2];
            if (atomicNo1 == atomicNo2) {
                return true;
            }
            if (atomicNo1 < atomicNo2) {
                ++i1;
                continue;
            }
            ++i2;
        }
        return false;
    }

    private boolean isListMember(int atomicNo, int[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != atomicNo) continue;
            return true;
        }
        return false;
    }

    public void setupAtomAndBondFeatures(int matchMode) {
        if (!this.mMoleculeFeaturesValid) {
            this.setupMoleculeFeatures(matchMode);
            this.mMoleculeFeaturesValid = true;
        }
        if (!this.mFragmentFeaturesValid) {
            this.setupFragmentFeatures(matchMode);
            this.buildFragmentGraph();
            this.buildBridgeBondList();
            this.mFragmentFeaturesValid = true;
        }
    }

    private void setupMoleculeFeatures(int matchMode) {
        int ringSize;
        this.mMolecule.ensureHelperArrays(this.mRequiredHelperLevel);
        int nTotalMoleculeAtoms = this.mMolecule.getAtoms();
        this.mMoleculeAtomType = new int[nTotalMoleculeAtoms];
        this.mMoleculeAtomFeatures = new long[nTotalMoleculeAtoms];
        for (int atom = 0; atom < nTotalMoleculeAtoms; ++atom) {
            this.mMoleculeAtomFeatures[atom] = (this.getAtomQueryDefaults(this.mMolecule, atom) | this.mMolecule.getAtomQueryFeatures(atom)) & 0xE3FC7FEL ^ 0xE3FC7FEL;
            this.mMoleculeAtomType[atom] = this.mMolecule.getAtomicNo(atom);
            if ((matchMode & 1) != 0) {
                int n = atom;
                this.mMoleculeAtomType[n] = this.mMoleculeAtomType[n] + (this.mMolecule.getAtomCharge(atom) + 16 << 8);
            }
            if ((matchMode & 2) == 0) continue;
            int n = atom;
            this.mMoleculeAtomType[n] = this.mMoleculeAtomType[n] + (this.mMolecule.getAtomMass(atom) << 16);
        }
        this.mMoleculeRingFeatures = new long[nTotalMoleculeAtoms];
        RingCollection ringSet = this.mMolecule.getRingSet();
        for (int i = 0; i < ringSet.getSize(); ++i) {
            ringSize = ringSet.getRingSize(i);
            for (int atom : ringSet.getRingAtoms(i)) {
                if (ringSize == 3) {
                    int n = atom;
                    this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x200000000L;
                    continue;
                }
                if (ringSize == 4) {
                    int n = atom;
                    this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x400000000L;
                    continue;
                }
                if (ringSize == 5) {
                    int n = atom;
                    this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x800000000L;
                    continue;
                }
                if (ringSize == 6) {
                    int n = atom;
                    this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x1000000000L;
                    continue;
                }
                if (ringSize != 7) continue;
                int n = atom;
                this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x2000000000L;
            }
        }
        for (int atom = 0; atom < nTotalMoleculeAtoms; ++atom) {
            ringSize = this.mMolecule.getAtomRingSize(atom);
            if (ringSize == 0) {
                int n = atom;
                this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x100000000L;
                continue;
            }
            if (ringSize <= 7) continue;
            int n = atom;
            this.mMoleculeRingFeatures[n] = this.mMoleculeRingFeatures[n] | 0x4000000000L;
        }
        int nTotalMoleculeBonds = this.mMolecule.getBonds();
        this.mMoleculeBondFeatures = new int[nTotalMoleculeBonds];
        for (int bond = 0; bond < nTotalMoleculeBonds; ++bond) {
            this.mMoleculeBondFeatures[bond] = (this.getBondQueryDefaults(this.mMolecule, bond) | this.mMolecule.getBondQueryFeatures(bond)) & 0x187FFF ^ 0x180060;
        }
    }

    private void setupFragmentFeatures(int matchMode) {
        long[] atomFeaturesWithoutExcludeAtoms = null;
        int[] bondFeaturesWithoutExcludeAtoms = null;
        int[] atomTypeWithoutExcludeAtoms = null;
        this.mFragment.ensureHelperArrays(this.mRequiredHelperLevel);
        this.mFragmentConnAtoms = new int[this.mFragment.getAtoms()];
        for (int atom = 0; atom < this.mFragment.getAtoms(); ++atom) {
            this.mFragmentConnAtoms[atom] = this.mFragment.getConnAtoms(atom);
        }
        if (this.mFragmentExcludeAtoms != 0) {
            StereoMolecule fragmentWithoutExcludeGroups = new StereoMolecule(this.mFragment.getAllAtoms(), this.mFragment.getAllBonds());
            boolean[] isNonExcludeAtom = new boolean[this.mFragment.getAllAtoms()];
            for (int atom = 0; atom < this.mFragment.getAllAtoms(); ++atom) {
                isNonExcludeAtom[atom] = !this.mIsExcludeAtom[atom];
            }
            this.mFragment.copyMoleculeByAtoms(fragmentWithoutExcludeGroups, isNonExcludeAtom, true, null);
            fragmentWithoutExcludeGroups.ensureHelperArrays(this.mRequiredHelperLevel);
            this.setupFragmentFeatures(fragmentWithoutExcludeGroups, matchMode);
            atomFeaturesWithoutExcludeAtoms = this.mFragmentAtomFeatures;
            bondFeaturesWithoutExcludeAtoms = this.mFragmentBondFeatures;
            atomTypeWithoutExcludeAtoms = this.mFragmentAtomType;
            int index = 0;
            for (int atom = 0; atom < this.mFragment.getAtoms(); ++atom) {
                if (this.mIsExcludeAtom[atom]) continue;
                this.mFragmentConnAtoms[atom] = fragmentWithoutExcludeGroups.getConnAtoms(index++);
            }
        }
        this.setupFragmentFeatures(this.mFragment, matchMode);
        if (this.mFragmentExcludeAtoms != 0) {
            int index = 0;
            for (int atom = 0; atom < this.mFragment.getAllAtoms(); ++atom) {
                if (this.mIsExcludeAtom[atom]) continue;
                this.mFragmentAtomFeatures[atom] = atomFeaturesWithoutExcludeAtoms[index];
                this.mFragmentAtomType[atom] = atomTypeWithoutExcludeAtoms[index++];
            }
            index = 0;
            for (int bond = 0; bond < this.mFragment.getAllBonds(); ++bond) {
                if (this.mIsExcludeAtom[this.mFragment.getBondAtom(0, bond)] || this.mIsExcludeAtom[this.mFragment.getBondAtom(1, bond)]) continue;
                this.mFragmentBondFeatures[bond] = bondFeaturesWithoutExcludeAtoms[index++];
            }
        }
    }

    private void setupFragmentFeatures(StereoMolecule fragment, int matchMode) {
        int nTotalFragmentAtoms = fragment.getAtoms();
        this.mFragmentAtomFeatures = new long[fragment.getAtoms()];
        this.mFragmentAtomType = new int[fragment.getAtoms()];
        for (int atom = 0; atom < nTotalFragmentAtoms; ++atom) {
            this.mFragmentAtomFeatures[atom] = (this.getAtomQueryDefaults(fragment, atom) | this.mFragment.getAtomQueryFeatures(atom)) & 0xE3FC7FEL ^ 0xE3FC7FEL;
            this.mFragmentAtomType[atom] = fragment.getAtomicNo(atom);
            if ((matchMode & 1) != 0) {
                int n = atom;
                this.mFragmentAtomType[n] = this.mFragmentAtomType[n] + (fragment.getAtomCharge(atom) + 16 << 8);
            }
            if ((matchMode & 2) == 0) continue;
            int n = atom;
            this.mFragmentAtomType[n] = this.mFragmentAtomType[n] + (fragment.getAtomMass(atom) << 16);
        }
        this.mFragmentRingFeatures = new long[fragment.getAtoms()];
        RingCollection ringSet = fragment.getRingSet();
        for (int i = 0; i < ringSet.getSize(); ++i) {
            int ringSize = ringSet.getRingSize(i);
            for (int atom : ringSet.getRingAtoms(i)) {
                if (ringSize == 3) {
                    int n = atom;
                    this.mFragmentRingFeatures[n] = this.mFragmentRingFeatures[n] | 0x200000000L;
                    continue;
                }
                if (ringSize == 4) {
                    int n = atom;
                    this.mFragmentRingFeatures[n] = this.mFragmentRingFeatures[n] | 0x400000000L;
                    continue;
                }
                if (ringSize == 5) {
                    int n = atom;
                    this.mFragmentRingFeatures[n] = this.mFragmentRingFeatures[n] | 0x800000000L;
                    continue;
                }
                if (ringSize == 6) {
                    int n = atom;
                    this.mFragmentRingFeatures[n] = this.mFragmentRingFeatures[n] | 0x1000000000L;
                    continue;
                }
                if (ringSize != 7) continue;
                int n = atom;
                this.mFragmentRingFeatures[n] = this.mFragmentRingFeatures[n] | 0x2000000000L;
            }
        }
        for (int atom = 0; atom < nTotalFragmentAtoms; ++atom) {
            if (this.mMolecule.getAtomRingSize(atom) <= 7) continue;
            int n = atom;
            this.mFragmentRingFeatures[n] = this.mFragmentRingFeatures[n] | 0x4000000000L;
        }
        int nTotalFragmentBonds = fragment.getBonds();
        this.mFragmentBondFeatures = new int[fragment.getBonds()];
        for (int bond = 0; bond < nTotalFragmentBonds; ++bond) {
            this.mFragmentBondFeatures[bond] = (this.getBondQueryDefaults(fragment, bond) | fragment.getBondQueryFeatures(bond)) & 0x18007F ^ 0x180060;
            if ((matchMode & 4) != 0) {
                if ((this.mFragmentBondFeatures[bond] & 2) == 0) continue;
                int n = bond;
                this.mFragmentBondFeatures[n] = this.mFragmentBondFeatures[n] | 8;
                continue;
            }
            if ((matchMode & 8) == 0 || (this.mFragmentBondFeatures[bond] & 2) == 0 || !fragment.isAromaticBond(bond)) continue;
            int n = bond;
            this.mFragmentBondFeatures[n] = this.mFragmentBondFeatures[n] | 8;
        }
    }

    private long getAtomQueryDefaults(StereoMolecule mol, int atom) {
        int ringBonds;
        long queryDefaults = 0L;
        if (!mol.isFragment()) {
            queryDefaults = mol.isAromaticAtom(atom) ? (queryDefaults |= 2L) : (queryDefaults |= 4L);
            ringBonds = mol.getAtomRingBondCount(atom);
            queryDefaults = ringBonds == 0 ? (queryDefaults |= 0x70L) : (ringBonds == 2 ? (queryDefaults |= 0x68L) : (ringBonds == 3 ? (queryDefaults |= 0x58L) : (queryDefaults |= 0x38L)));
            int charge = mol.getAtomCharge(atom);
            if (charge == 0) {
                queryDefaults |= 0xA000000L;
            } else if (charge < 0) {
                queryDefaults |= 0xC000000L;
            } else if (charge > 0) {
                queryDefaults |= 0x6000000L;
            }
            int hydrogens = mol.getAllHydrogens(atom);
            switch (hydrogens) {
                case 0: {
                    queryDefaults |= 0x700L;
                    break;
                }
                case 1: {
                    queryDefaults |= 0x680L;
                    break;
                }
                case 2: {
                    queryDefaults |= 0x580L;
                    break;
                }
                default: {
                    queryDefaults |= 0x380L;
                }
            }
            int neighbours = mol.getConnAtoms(atom);
            switch (neighbours) {
                case 0: {
                    queryDefaults |= 0x3C0000L;
                    break;
                }
                case 1: {
                    queryDefaults |= 0x3A0000L;
                    break;
                }
                case 2: {
                    queryDefaults |= 0x360000L;
                    break;
                }
                case 3: {
                    queryDefaults |= 0x2E0000L;
                    break;
                }
                default: {
                    queryDefaults |= 0x1E0000L;
                }
            }
            int piElectrons = mol.getAtomPi(atom);
            switch (piElectrons) {
                case 0: {
                    queryDefaults |= 0x18000L;
                    break;
                }
                case 1: {
                    queryDefaults |= 0x14000L;
                    break;
                }
                default: {
                    queryDefaults |= 0xC000L;
                    break;
                }
            }
        } else {
            int charge;
            if (mol.isAromaticAtom(atom)) {
                queryDefaults |= 2L;
            }
            if ((ringBonds = mol.getAtomRingBondCount(atom)) != 0) {
                queryDefaults |= 8L;
                if (ringBonds > 2) {
                    queryDefaults |= 0x10L;
                }
                if (ringBonds > 3) {
                    queryDefaults |= 0x20L;
                }
            }
            if ((charge = mol.getAtomCharge(atom)) < 0) {
                queryDefaults |= 0xC000000L;
            } else if (charge > 0) {
                queryDefaults |= 0x6000000L;
            }
            int neighbours = mol.getConnAtoms(atom);
            switch (neighbours) {
                case 0: {
                    break;
                }
                case 1: {
                    queryDefaults |= 0x20000L;
                    break;
                }
                case 2: {
                    queryDefaults |= 0x60000L;
                    break;
                }
                case 3: {
                    queryDefaults |= 0xE0000L;
                    break;
                }
                default: {
                    queryDefaults |= 0x1E0000L;
                }
            }
        }
        int piElectrons = mol.getAtomPi(atom);
        if (piElectrons > 0) {
            queryDefaults |= 0x4000L;
        }
        if (piElectrons > 1) {
            queryDefaults |= 0x8000L;
        }
        return queryDefaults;
    }

    private int getBondQueryDefaults(StereoMolecule mol, int bond) {
        int queryDefaults = 0;
        if (mol.isDelocalizedBond(bond) || mol.getBondType(bond) == 64) {
            queryDefaults |= 8;
        } else {
            switch (mol.getBondOrder(bond)) {
                case 0: {
                    queryDefaults |= 0x20;
                    break;
                }
                case 1: {
                    queryDefaults |= 1;
                    break;
                }
                case 2: {
                    queryDefaults |= 2;
                    break;
                }
                case 3: {
                    queryDefaults |= 4;
                }
            }
        }
        if (mol.isRingBond(bond)) {
            queryDefaults |= 0x40;
        } else if (!mol.isFragment()) {
            queryDefaults |= 0x20;
        }
        if (mol.isAromaticBond(bond)) {
            queryDefaults |= 0x80000;
        } else if (!mol.isFragment()) {
            queryDefaults |= 0x100000;
        }
        return queryDefaults;
    }

    private void buildBridgeBondList() {
        this.mBridgeBondList = null;
        for (int bond = 0; bond < this.mFragment.getBonds(); ++bond) {
            if (!this.mFragment.isBondBridge(bond)) continue;
            if (this.mBridgeBondList == null) {
                this.mBridgeBondList = new ArrayList();
            }
            BridgeBond bridgeBond = new BridgeBond();
            bridgeBond.atom1 = this.mFragment.getBondAtom(0, bond);
            bridgeBond.atom2 = this.mFragment.getBondAtom(1, bond);
            bridgeBond.minBridgeSize = this.mFragment.getBondBridgeMinSize(bond);
            bridgeBond.maxBridgeSize = this.mFragment.getBondBridgeMaxSize(bond);
            this.mBridgeBondList.add(bridgeBond);
        }
    }

    private static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private class BridgeBond {
        int atom1;
        int atom2;
        int minBridgeSize;
        int maxBridgeSize;

        private BridgeBond() {
        }
    }
}

