/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SmilesRange;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.ArrayUtils;
import com.actelion.research.util.SortedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;

public class SmilesParser {
    private static final int SMARTS_MODE_MASK = 3;
    public static final int SMARTS_MODE_IS_SMILES = 0;
    public static final int SMARTS_MODE_GUESS = 1;
    public static final int SMARTS_MODE_IS_SMARTS = 2;
    public static final int MODE_SKIP_COORDINATE_TEMPLATES = 4;
    public static final int MODE_MAKE_HYDROGEN_EXPLICIT = 8;
    private static final int INITIAL_CONNECTIONS = 16;
    private static final int MAX_CONNECTIONS = 100;
    private static final int BRACKET_LEVELS = 32;
    private static final int MAX_AROMATIC_RING_SIZE = 15;
    private static final int HYDROGEN_ANY = -1;
    private static final int HYDROGEN_IMPLICIT_ZERO = 9;
    private StereoMolecule mMol;
    private boolean[] mIsAromaticBond;
    private int mAromaticAtoms;
    private int mAromaticBonds;
    private int mSmartsMode;
    private int mCoordinateMode;
    private long mRandomSeed;
    private boolean mCreateSmartsWarnings;
    private boolean mMakeHydrogenExplicit;
    private StringBuilder mSmartsWarningBuffer;

    public SmilesParser() {
        this(0, false);
    }

    public SmilesParser(int mode, boolean createSmartsWarnings) {
        this.mSmartsMode = mode & 3;
        this.mCreateSmartsWarnings = createSmartsWarnings;
        this.mMakeHydrogenExplicit = (mode & 8) != 0;
        this.mCoordinateMode = 2;
        if ((mode & 4) != 0) {
            this.mCoordinateMode |= 1;
        }
        if (this.mMakeHydrogenExplicit) {
            this.mCoordinateMode &= 0xFFFFFFFD;
        }
    }

    public void setRandomSeed(long seed) {
        this.mRandomSeed = seed;
    }

    public StereoMolecule parseMolecule(String smiles) {
        return smiles == null ? null : this.parseMolecule(smiles.getBytes());
    }

    public StereoMolecule parseMolecule(byte[] smiles) {
        StereoMolecule mol = new StereoMolecule();
        try {
            this.parse(mol, smiles);
        }
        catch (Exception e) {
            return null;
        }
        return mol;
    }

    public Reaction parseReaction(String smiles) throws Exception {
        return smiles == null ? null : this.parseReaction(smiles.getBytes());
    }

    public Reaction parseReaction(byte[] smiles) throws Exception {
        int start;
        int index2;
        int index1 = ArrayUtils.indexOf(smiles, (byte)62);
        int n = index2 = index1 == -1 ? -1 : ArrayUtils.indexOf(smiles, (byte)62, index1 + 1);
        if (index2 == -1) {
            throw new Exception("Missing one or both separators ('>').");
        }
        if (ArrayUtils.indexOf(smiles, (byte)62, index2 + 1) != -1) {
            throw new Exception("Found more than 2 separators ('>').");
        }
        Reaction rxn = new Reaction();
        for (int i = start = 0; i < index1 - 1; ++i) {
            if (smiles[i] != 46 || smiles[i + 1] != 46) continue;
            if (i > start) {
                StereoMolecule reactant = new StereoMolecule();
                this.parse(reactant, smiles, start, i);
                rxn.addReactant(reactant);
            }
            start = i + 2;
        }
        StereoMolecule reactants = new StereoMolecule();
        this.parse(reactants, smiles, start, index1);
        rxn.addReactant(reactants);
        if (index2 - index1 > 1) {
            for (int i = start = index1 + 1; i < index2 - 1; ++i) {
                if (smiles[i] != 46 || smiles[i + 1] != 46) continue;
                if (i > start) {
                    StereoMolecule catalyst = new StereoMolecule();
                    this.parse(catalyst, smiles, start, i);
                    rxn.addCatalyst(catalyst);
                }
                start = i + 2;
            }
            StereoMolecule catalysts = new StereoMolecule();
            this.parse(catalysts, smiles, start, index2);
            rxn.addCatalyst(catalysts);
        }
        for (int i = start = index2 + 1; i < smiles.length - 1; ++i) {
            if (smiles[i] != 46 || smiles[i + 1] != 46) continue;
            if (i > start) {
                StereoMolecule product = new StereoMolecule();
                this.parse(product, smiles, start, i);
                rxn.addProduct(product);
            }
            start = i + 2;
        }
        StereoMolecule products = new StereoMolecule();
        this.parse(products, smiles, start, smiles.length);
        rxn.addProduct(products);
        return rxn;
    }

    public String getSmartsWarning() {
        return this.mSmartsWarningBuffer == null ? "" : "Unresolved SMARTS features:" + this.mSmartsWarningBuffer;
    }

    public void parse(StereoMolecule mol, String smiles) throws Exception {
        this.parse(mol, smiles.getBytes(), true, true);
    }

    public void parse(StereoMolecule mol, byte[] smiles) throws Exception {
        this.parse(mol, smiles, true, true);
    }

    public void parse(StereoMolecule mol, byte[] smiles, int position, int endIndex) throws Exception {
        this.parse(mol, smiles, position, endIndex, true, true);
    }

    public void parse(StereoMolecule mol, byte[] smiles, boolean createCoordinates, boolean readStereoFeatures) throws Exception {
        this.parse(mol, smiles, 0, smiles.length, createCoordinates, readStereoFeatures);
    }

    public void parse(StereoMolecule mol, byte[] smiles, int position, int endIndex, boolean createCoordinates, boolean readStereoFeatures) throws Exception {
        this.mMol = mol;
        this.mMol.clear();
        if (this.mSmartsWarningBuffer != null) {
            this.mSmartsWarningBuffer.setLength(0);
        }
        this.mAromaticAtoms = 0;
        boolean allowSmarts = this.mSmartsMode != 0;
        TreeMap<Integer, THParity> parityMap = null;
        int[] baseAtom = new int[32];
        baseAtom[0] = -1;
        int[] ringClosureAtom = new int[16];
        int[] ringClosurePosition = new int[16];
        int[] ringClosureBondType = new int[16];
        int[] ringClosureBondQueryFeatures = new int[16];
        for (int i = 0; i < 16; ++i) {
            ringClosureAtom[i] = -1;
        }
        int atomMass = 0;
        int fromAtom = -1;
        boolean squareBracketOpen = false;
        boolean isDoubleDigit = false;
        boolean smartsFeatureFound = false;
        int bracketLevel = 0;
        int bondType = 1;
        int bondQueryFeatures = 0;
        SortedList<Integer> atomList = new SortedList<Integer>();
        SmilesRange range = new SmilesRange(smiles);
        while (smiles[position] <= 32) {
            ++position;
        }
        block13: while (position < endIndex) {
            char theChar;
            block185: {
                if (Character.isLetter(theChar = (char)smiles[position++]) || theChar == '*' || theChar == '?' || theChar == '!' && allowSmarts && squareBracketOpen || theChar == '#' && allowSmarts && squareBracketOpen) {
                    THParity parity;
                    int atomicNo = -1;
                    int charge = 0;
                    int mapNo = 0;
                    int abnormalValence = -1;
                    int explicitHydrogens = -1;
                    boolean parityFound = false;
                    boolean isClockwise = false;
                    int atomQueryFeatures = 0;
                    if (squareBracketOpen) {
                        boolean isNot;
                        if (theChar == 'R' && Character.isDigit(smiles[position])) {
                            int noOfDigits = Character.isDigit(smiles[position + 1]) ? 2 : 1;
                            atomicNo = Molecule.getAtomicNoFromLabel(new String(smiles, position - 1, 1 + noOfDigits));
                            position += noOfDigits;
                        } else if (theChar == '*') {
                            atomicNo = 6;
                            atomQueryFeatures = (int)((long)atomQueryFeatures | 1L);
                        } else if (theChar == '?') {
                            atomicNo = 0;
                        } else if (theChar == '#') {
                            int number = 0;
                            while (position < endIndex && Character.isDigit(smiles[position])) {
                                number = 10 * number + smiles[position] - 48;
                                ++position;
                            }
                            if (number < 1 || number >= Molecule.cAtomLabel.length) {
                                throw new Exception("SmilesParser: Atomic number out of range.");
                            }
                            atomicNo = number;
                        } else {
                            boolean bl = isNot = theChar == '!';
                            if (isNot) {
                                smartsFeatureFound = true;
                                atomQueryFeatures = (int)((long)atomQueryFeatures | 1L);
                                ++position;
                            }
                            int labelLength = Character.isLowerCase(smiles[position]) ? 2 : 1;
                            atomicNo = Molecule.getAtomicNoFromLabel(new String(smiles, position - 1, labelLength));
                            explicitHydrogens = 9;
                            if (allowSmarts && (smiles[position += labelLength - 1] == 44 || isNot)) {
                                int start;
                                atomList.removeAll();
                                boolean upperCaseFound = false;
                                boolean lowerCaseFound = false;
                                for (int p = start = position - labelLength; p < smiles.length; ++p) {
                                    if (Character.isLetter(smiles[p])) continue;
                                    int no = Molecule.getAtomicNoFromLabel(new String(smiles, start, p - start));
                                    if (no != 0) {
                                        atomList.add(no);
                                        if (Character.isUpperCase(smiles[start])) {
                                            upperCaseFound = true;
                                        } else {
                                            lowerCaseFound = true;
                                        }
                                    }
                                    start = p + 1;
                                    if (smiles[p] != 44) break;
                                    if (smiles[p + 1] != 33) continue;
                                    if (!isNot) {
                                        throw new Exception("SmilesParser: inconsistent '!' in atom list.");
                                    }
                                    ++p;
                                    ++start;
                                }
                                if (atomList.size() > 1) {
                                    if (!upperCaseFound) {
                                        atomQueryFeatures = (int)((long)atomQueryFeatures | 2L);
                                    } else if (!lowerCaseFound) {
                                        atomQueryFeatures = (int)((long)atomQueryFeatures | 4L);
                                    }
                                }
                                position = start - 1;
                            }
                        }
                        while (squareBracketOpen) {
                            int flags;
                            if (smiles[position] == 64) {
                                if (smiles[++position] == 64) {
                                    isClockwise = true;
                                    ++position;
                                }
                                parityFound = true;
                                continue;
                            }
                            if (smiles[position] == 58) {
                                ++position;
                                while (Character.isDigit(smiles[position])) {
                                    mapNo = 10 * mapNo + smiles[position] - 48;
                                    ++position;
                                }
                                continue;
                            }
                            if (smiles[position] == 91) {
                                throw new Exception("SmilesParser: nested square brackets found");
                            }
                            if (smiles[position] == 93) {
                                ++position;
                                squareBracketOpen = false;
                                continue;
                            }
                            if (smiles[position] == 43) {
                                charge = 1;
                                ++position;
                                while (smiles[position] == 43) {
                                    ++charge;
                                    ++position;
                                }
                                if (charge == 1 && Character.isDigit(smiles[position])) {
                                    charge = smiles[position] - 48;
                                    ++position;
                                }
                                if (charge != 0) continue;
                                atomQueryFeatures = (int)((long)atomQueryFeatures | 0xA000000L);
                                continue;
                            }
                            if (smiles[position] == 45) {
                                charge = -1;
                                ++position;
                                while (smiles[position] == 45) {
                                    --charge;
                                    ++position;
                                }
                                if (charge == -1 && Character.isDigit(smiles[position])) {
                                    charge = 48 - smiles[position];
                                    ++position;
                                }
                                if (charge != 0) continue;
                                atomQueryFeatures = (int)((long)atomQueryFeatures | 0xA000000L);
                                continue;
                            }
                            boolean bl = isNot = smiles[position] == 33;
                            if (isNot) {
                                ++position;
                            }
                            if (smiles[position] == 72) {
                                ++position;
                                position += range.parse(smiles, position, 1, 1);
                                explicitHydrogens = range.min;
                                flags = 0;
                                if (range.min <= 0 && range.max >= 0) {
                                    flags = (int)((long)flags | 0x80L);
                                }
                                if (range.min <= 1 && range.max >= 1) {
                                    flags = (int)((long)flags | 0x100L);
                                }
                                if (range.min <= 2 && range.max >= 2) {
                                    flags = (int)((long)flags | 0x200L);
                                }
                                if (range.min <= 3 && range.max >= 3) {
                                    flags = (int)((long)flags | 0x400L);
                                }
                                if (isNot) {
                                    atomQueryFeatures |= flags;
                                    explicitHydrogens = -1;
                                    continue;
                                }
                                if (range.isSingle()) {
                                    explicitHydrogens = range.min;
                                    continue;
                                }
                                atomQueryFeatures = (int)((long)atomQueryFeatures | 0x780L & (long)(~flags));
                                explicitHydrogens = -1;
                                continue;
                            }
                            if (smiles[position] == 68) {
                                ++position;
                                position += range.parse(smiles, position, 1, 1);
                                long flags2 = 0L;
                                if (range.min <= 0 && range.max >= 0) {
                                    flags2 |= 0x20000L;
                                }
                                if (range.min <= 1 && range.max >= 1) {
                                    flags2 |= 0x40000L;
                                }
                                if (range.min <= 2 && range.max >= 2) {
                                    flags2 |= 0x80000L;
                                }
                                if (range.min <= 3 && range.max >= 3) {
                                    flags2 |= 0x100000L;
                                }
                                if (range.min <= 4 && range.max >= 4) {
                                    flags2 |= 0x200000L;
                                }
                                if (flags2 == 0L) continue;
                                if (!isNot) {
                                    flags2 ^= 0x3E0000L;
                                }
                                atomQueryFeatures = (int)((long)atomQueryFeatures | flags2);
                                continue;
                            }
                            if (smiles[position] == 88) {
                                ++position;
                                position += range.parse(smiles, position, 1, 1);
                                continue;
                            }
                            if (smiles[position] == 65 || smiles[position] == 97) {
                                atomQueryFeatures = (int)((long)atomQueryFeatures | (isNot ^ smiles[++position] == 65 ? 4L : 2L));
                                continue;
                            }
                            if (smiles[position] == 82) {
                                ++position;
                                position += range.parse(smiles, position, 1, 3);
                                flags = 0;
                                if (range.min <= 0 && range.max >= 0) {
                                    flags = (int)((long)flags | 8L);
                                }
                                if (range.min <= 1 && range.max >= 1) {
                                    flags = (int)((long)flags | 0x10L);
                                }
                                if (range.min <= 2 && range.max >= 2) {
                                    flags = (int)((long)flags | 0x20L);
                                }
                                if (range.min <= 3 && range.max >= 3) {
                                    flags = (int)((long)flags | 0x40L);
                                }
                                if (range.max > 3) {
                                    this.smartsWarning((isNot ? "!R" : "R") + range.max);
                                }
                                if (flags == 0) continue;
                                if (!isNot) {
                                    flags ^= 0x60;
                                }
                                atomQueryFeatures |= flags;
                                continue;
                            }
                            if (smiles[position] == 114) {
                                ++position;
                                position += range.parse(smiles, position, 1, 1);
                                if (range.isDefault) {
                                    if (isNot) {
                                        atomQueryFeatures = (int)((long)atomQueryFeatures | 0x60L);
                                        continue;
                                    }
                                    atomQueryFeatures = (int)((long)atomQueryFeatures | 8L);
                                    continue;
                                }
                                int ringSize = range.min;
                                if (range.isRange()) {
                                    this.smartsWarning((isNot ? "!r" : "r") + range.toString());
                                }
                                if (!isNot && ringSize >= 3 && ringSize <= 7) {
                                    atomQueryFeatures |= ringSize << 22;
                                    continue;
                                }
                                if (range.isRange()) continue;
                                this.smartsWarning((isNot ? "!r" : "r") + ringSize);
                                continue;
                            }
                            if (smiles[position] == 118) {
                                ++position;
                                position += range.parse(smiles, position, 1, 1);
                                int valence = range.min;
                                if (range.isRange()) {
                                    this.smartsWarning((isNot ? "!v" : "v") + range.toString());
                                }
                                if (!isNot && valence <= 14) {
                                    abnormalValence = valence;
                                    continue;
                                }
                                if (range.isRange()) continue;
                                this.smartsWarning((isNot ? "!v" : "v") + valence);
                                continue;
                            }
                            if (allowSmarts && (smiles[position] == 59 || smiles[position] == 38)) {
                                smartsFeatureFound = true;
                                ++position;
                                continue;
                            }
                            throw new Exception("SmilesParser: unexpected character inside brackets: '" + (char)smiles[position] + "'");
                        }
                    } else if (theChar == '*') {
                        atomicNo = 6;
                        atomQueryFeatures = (int)((long)atomQueryFeatures | 1L);
                    } else if (theChar == '?') {
                        atomicNo = 0;
                    } else {
                        switch (Character.toUpperCase(theChar)) {
                            case 'A': {
                                atomicNo = 6;
                                atomQueryFeatures = (int)((long)atomQueryFeatures | 1L);
                                atomQueryFeatures = (int)((long)atomQueryFeatures | (theChar == 'A' ? 4L : 2L));
                                break;
                            }
                            case 'B': {
                                if (position < endIndex && smiles[position] == 114) {
                                    atomicNo = 35;
                                    ++position;
                                    break;
                                }
                                atomicNo = 5;
                                break;
                            }
                            case 'C': {
                                if (position < endIndex && smiles[position] == 108) {
                                    atomicNo = 17;
                                    ++position;
                                    break;
                                }
                                atomicNo = 6;
                                break;
                            }
                            case 'F': {
                                atomicNo = 9;
                                break;
                            }
                            case 'I': {
                                atomicNo = 53;
                                break;
                            }
                            case 'N': {
                                atomicNo = 7;
                                break;
                            }
                            case 'O': {
                                atomicNo = 8;
                                break;
                            }
                            case 'P': {
                                atomicNo = 15;
                                break;
                            }
                            case 'S': {
                                atomicNo = 16;
                            }
                        }
                    }
                    if (atomicNo == -1 && theChar != '?') {
                        throw new Exception("SmilesParser: unknown element label found");
                    }
                    int atom = this.mMol.addAtom(atomicNo);
                    this.mMol.setAtomCharge(atom, charge);
                    this.mMol.setAtomMapNo(atom, mapNo, false);
                    this.mMol.setAtomAbnormalValence(atom, abnormalValence);
                    if (atomQueryFeatures != 0) {
                        smartsFeatureFound = true;
                        this.mMol.setAtomQueryFeature(atom, atomQueryFeatures, true);
                    }
                    if (atomList.size() != 0) {
                        smartsFeatureFound = true;
                        int[] list = new int[atomList.size()];
                        for (int i = 0; i < atomList.size(); ++i) {
                            list[i] = (Integer)atomList.get(i);
                        }
                        this.mMol.setAtomList(atom, list);
                    }
                    if (Character.isLowerCase(theChar)) {
                        if (atomicNo != 5 && atomicNo != 6 && atomicNo != 7 && atomicNo != 8 && atomicNo != 15 && atomicNo != 16 && atomicNo != 33 && atomicNo != 34) {
                            throw new Exception("SmilesParser: atomicNo " + atomicNo + " must not be aromatic");
                        }
                        this.mMol.setAtomMarker(atom, true);
                        ++this.mAromaticAtoms;
                    } else {
                        this.mMol.setAtomMarker(atom, false);
                    }
                    if (explicitHydrogens != -1 && atomicNo != 1) {
                        byte[] bytes = new byte[]{(byte)(explicitHydrogens == 9 ? 0 : explicitHydrogens)};
                        this.mMol.setAtomCustomLabel(atom, bytes);
                    }
                    fromAtom = baseAtom[bracketLevel];
                    if (baseAtom[bracketLevel] != -1 && bondType != 128) {
                        int bond = this.mMol.addBond(baseAtom[bracketLevel], atom, bondType);
                        if (bondQueryFeatures != 0) {
                            smartsFeatureFound = true;
                            this.mMol.setBondQueryFeature(bond, bondQueryFeatures, true);
                        }
                    }
                    bondType = 1;
                    bondQueryFeatures = 0;
                    baseAtom[bracketLevel] = atom;
                    if (atomMass != 0) {
                        this.mMol.setAtomMass(atom, atomMass);
                        atomMass = 0;
                    }
                    if (!readStereoFeatures) continue;
                    THParity tHParity = parity = parityMap == null ? null : (THParity)parityMap.get(fromAtom);
                    if (parity != null) {
                        parity.addNeighbor(atom, position, atomicNo == 1 && atomMass == 0);
                    }
                    if (!parityFound) continue;
                    if (parityMap == null) {
                        parityMap = new TreeMap<Integer, THParity>();
                    }
                    int hydrogenCount = explicitHydrogens == 9 ? 0 : explicitHydrogens;
                    parityMap.put(atom, new THParity(atom, position - 2, fromAtom, hydrogenCount, position - 1, isClockwise));
                    continue;
                }
                if (theChar == '.') {
                    baseAtom[bracketLevel] = -1;
                    bondType = 128;
                    continue;
                }
                if (!this.isBondSymbol(theChar)) break block185;
                if (squareBracketOpen) {
                    throw new Exception("SmilesParser: unexpected bond symbol inside square brackets: '" + theChar + "'");
                }
                int excludedBonds = 0;
                while (this.isBondSymbol(theChar)) {
                    block188: {
                        block186: {
                            block191: {
                                block190: {
                                    block189: {
                                        block187: {
                                            if (theChar != '!') break block186;
                                            if ((theChar = (char)smiles[position++]) == '@') {
                                                bondQueryFeatures |= 0x20;
                                            }
                                            if ((theChar != '-' || smiles[position] != 62) && (theChar != '<' || smiles[position] != 45)) break block187;
                                            excludedBonds |= 0x20;
                                            ++position;
                                            break block188;
                                        }
                                        if (theChar != '-') break block189;
                                        excludedBonds |= 1;
                                        break block188;
                                    }
                                    if (theChar != '=') break block190;
                                    excludedBonds |= 2;
                                    break block188;
                                }
                                if (theChar != '#') break block191;
                                excludedBonds |= 4;
                                break block188;
                            }
                            if (theChar != ':') break block188;
                            excludedBonds |= 8;
                            break block188;
                        }
                        if (theChar == '@') {
                            bondQueryFeatures |= 0x40;
                        } else if (theChar == '=') {
                            bondType = 2;
                        } else if (theChar == '#') {
                            bondType = 4;
                        } else if (theChar == ':') {
                            bondType = 64;
                        } else if (theChar == '/') {
                            if (readStereoFeatures) {
                                bondType = 17;
                            }
                        } else if (theChar == '\\') {
                            if (readStereoFeatures) {
                                bondType = 9;
                            }
                        } else if (theChar == '-' && smiles[position] == 62 || theChar == '<' && smiles[position] == 45) {
                            bondType = 32;
                            ++position;
                        }
                        if (smiles[position] == 44) {
                            bondQueryFeatures |= this.bondSymbolToQueryFeature(bondType == 32 ? (char)'>' : (char)theChar);
                            while (smiles[position] == 44) {
                                if (smiles[position + 1] == 60 && smiles[position + 2] == 45 || smiles[position + 1] == 45 && smiles[position + 2] == 62) {
                                    bondQueryFeatures |= this.bondSymbolToQueryFeature('>');
                                    position += 3;
                                    continue;
                                }
                                bondQueryFeatures |= this.bondSymbolToQueryFeature((char)smiles[position + 1]);
                                position += 2;
                            }
                        }
                    }
                    if (smiles[position] == 59) {
                        int n = ++position;
                        ++position;
                        theChar = (char)smiles[n];
                        continue;
                    }
                    if (excludedBonds == 0) continue block13;
                    bondQueryFeatures |= 0x1F & ~excludedBonds;
                    continue block13;
                }
                continue;
            }
            if (theChar <= ' ') {
                position = endIndex;
                continue;
            }
            if (Character.isDigit(theChar)) {
                int hasBondType;
                int number = theChar - 48;
                if (squareBracketOpen) {
                    while (position < endIndex && Character.isDigit(smiles[position])) {
                        number = 10 * number + smiles[position] - 48;
                        ++position;
                    }
                    atomMass = number;
                    continue;
                }
                int n = hasBondType = smiles[position - 2] == 45 || smiles[position - 2] == 47 || smiles[position - 2] == 92 || smiles[position - 2] == 61 || smiles[position - 2] == 35 || smiles[position - 2] == 58 || smiles[position - 2] == 62 ? 1 : 0;
                if (isDoubleDigit && position < endIndex && Character.isDigit(smiles[position])) {
                    number = 10 * number + smiles[position] - 48;
                    isDoubleDigit = false;
                    ++position;
                }
                if (number >= ringClosureAtom.length) {
                    if (number >= 100) {
                        throw new Exception("SmilesParser: ringClosureAtom number out of range");
                    }
                    int oldSize = ringClosureAtom.length;
                    int newSize = ringClosureAtom.length;
                    while (newSize <= number) {
                        newSize = Math.min(100, newSize + 16);
                    }
                    ringClosureAtom = Arrays.copyOf(ringClosureAtom, newSize);
                    ringClosurePosition = Arrays.copyOf(ringClosurePosition, newSize);
                    ringClosureBondType = Arrays.copyOf(ringClosureBondType, newSize);
                    ringClosureBondQueryFeatures = Arrays.copyOf(ringClosureBondQueryFeatures, newSize);
                    for (int i = oldSize; i < newSize; ++i) {
                        ringClosureAtom[i] = -1;
                    }
                }
                if (ringClosureAtom[number] == -1) {
                    ringClosureAtom[number] = baseAtom[bracketLevel];
                    ringClosurePosition[number] = position - 1;
                    ringClosureBondType[number] = hasBondType != 0 ? bondType : -1;
                    ringClosureBondQueryFeatures[number] = hasBondType != 0 ? bondQueryFeatures : 0;
                } else {
                    if (ringClosureAtom[number] == baseAtom[bracketLevel]) {
                        throw new Exception("SmilesParser: ring closure to same atom");
                    }
                    if (readStereoFeatures && parityMap != null) {
                        THParity parity = (THParity)parityMap.get(ringClosureAtom[number]);
                        if (parity != null) {
                            parity.addNeighbor(baseAtom[bracketLevel], ringClosurePosition[number], false);
                        }
                        if ((parity = (THParity)parityMap.get(baseAtom[bracketLevel])) != null) {
                            parity.addNeighbor(ringClosureAtom[number], position - 1, false);
                        }
                    }
                    if (ringClosureBondType[number] != -1) {
                        bondType = ringClosureBondType[number];
                    } else if (bondType == 17) {
                        bondType = 9;
                    } else if (bondType == 9) {
                        bondType = 17;
                    }
                    int bond = this.mMol.addBond(ringClosureAtom[number], baseAtom[bracketLevel], bondType);
                    if (ringClosureBondQueryFeatures[number] != 0) {
                        bondQueryFeatures = ringClosureBondQueryFeatures[number];
                    }
                    if (bondQueryFeatures != 0) {
                        smartsFeatureFound = true;
                        this.mMol.setBondQueryFeature(bond, ringClosureBondQueryFeatures[number], true);
                    }
                    ringClosureAtom[number] = -1;
                }
                bondType = 1;
                bondQueryFeatures = 0;
                continue;
            }
            if (theChar == '+') {
                throw new Exception("SmilesParser: '+' found outside brackets");
            }
            if (theChar == '(') {
                if (baseAtom[bracketLevel] == -1) {
                    throw new Exception("Smiles with leading parenthesis are not supported");
                }
                if (baseAtom.length == ++bracketLevel) {
                    baseAtom = Arrays.copyOf(baseAtom, baseAtom.length + 32);
                }
                baseAtom[bracketLevel] = baseAtom[bracketLevel - 1];
                continue;
            }
            if (theChar == ')') {
                --bracketLevel;
                continue;
            }
            if (theChar == '[') {
                squareBracketOpen = true;
                continue;
            }
            if (theChar == ']') {
                throw new Exception("SmilesParser: closing bracket at unexpected position");
            }
            if (theChar == '%') {
                isDoubleDigit = true;
                continue;
            }
            throw new Exception("SmilesParser: unexpected character outside brackets: '" + theChar + "'");
        }
        if (bondType != 1) {
            throw new Exception("SmilesParser: dangling open bond");
        }
        for (int rca : ringClosureAtom) {
            if (rca == -1) continue;
            throw new Exception("SmilesParser: dangling ring closure");
        }
        int[] handleHydrogenAtomMap = this.mMol.getHandleHydrogenMap();
        this.mMol.setHydrogenProtection(true);
        this.mMol.ensureHelperArrays(1);
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            int explicitHydrogen;
            if (this.mMol.getAtomCustomLabel(atom) != null) {
                explicitHydrogen = this.mMol.getAtomCustomLabelBytes(atom)[0];
                if (this.mMakeHydrogenExplicit) {
                    for (int i = 0; i < explicitHydrogen; ++i) {
                        this.mMol.addBond(atom, this.mMol.addAtom(1), 1);
                    }
                    continue;
                }
                if (smartsFeatureFound || this.mSmartsMode == 2) {
                    if (explicitHydrogen == 0) {
                        this.mMol.setAtomQueryFeature(atom, 1792L, true);
                    }
                    if (explicitHydrogen == 1) {
                        this.mMol.setAtomQueryFeature(atom, 1664L, true);
                    }
                    if (explicitHydrogen == 2) {
                        this.mMol.setAtomQueryFeature(atom, 1408L, true);
                    }
                    if (explicitHydrogen != 3) continue;
                    this.mMol.setAtomQueryFeature(atom, 896L, true);
                    continue;
                }
                if (!this.mMol.isMarkedAtom(atom) || this.mMol.getAtomicNo(atom) == 6) {
                    byte[] valences = Molecule.getAllowedValences(this.mMol.getAtomicNo(atom));
                    boolean compatibleValenceFound = false;
                    int usedValence = this.mMol.getOccupiedValence(atom);
                    usedValence -= this.mMol.getElectronValenceCorrection(atom, usedValence);
                    usedValence += explicitHydrogen;
                    if (this.mMol.isMarkedAtom(atom)) {
                        ++usedValence;
                    }
                    for (byte valence : valences) {
                        if (usedValence > valence) continue;
                        compatibleValenceFound = true;
                        if (valence == usedValence + 2) {
                            this.mMol.setAtomRadical(atom, 48);
                            break;
                        }
                        if (valence == usedValence + 1) {
                            this.mMol.setAtomRadical(atom, 32);
                            break;
                        }
                        if (valence == usedValence && valence == valences[0]) break;
                        this.mMol.setAtomAbnormalValence(atom, usedValence);
                        break;
                    }
                    if (!compatibleValenceFound) {
                        this.mMol.setAtomAbnormalValence(atom, usedValence);
                    }
                }
                if (this.mMol.supportsImplicitHydrogen(atom)) continue;
                for (int i = 0; i < explicitHydrogen; ++i) {
                    this.mMol.addBond(atom, this.mMol.addAtom(1), 1);
                }
                continue;
            }
            if (this.mMakeHydrogenExplicit || !smartsFeatureFound && this.mSmartsMode != 2) continue;
            explicitHydrogen = this.mMol.getExplicitHydrogens(atom);
            if (explicitHydrogen >= 1) {
                this.mMol.setAtomQueryFeature(atom, 128L, true);
            }
            if (explicitHydrogen >= 2) {
                this.mMol.setAtomQueryFeature(atom, 256L, true);
            }
            if (explicitHydrogen >= 3) {
                this.mMol.setAtomQueryFeature(atom, 512L, true);
            }
            if (explicitHydrogen < 4) continue;
            this.mMol.setAtomQueryFeature(atom, 1024L, true);
        }
        if (!this.mMakeHydrogenExplicit && (smartsFeatureFound || this.mSmartsMode == 2)) {
            this.mMol.removeExplicitHydrogens();
        }
        this.mMol.ensureHelperArrays(1);
        this.correctValenceExceededNitrogen();
        this.locateAromaticDoubleBonds(allowSmarts);
        this.mMol.removeAtomCustomLabels();
        this.mMol.setHydrogenProtection(false);
        if (readStereoFeatures) {
            this.assignKnownEZBondParities();
            if (parityMap != null) {
                for (THParity parity : parityMap.values()) {
                    this.mMol.setAtomParity(parity.mCentralAtom, parity.calculateParity(handleHydrogenAtomMap), false);
                }
                this.mMol.setParitiesValid(0);
            }
        }
        this.mMol.setParitiesValid(0);
        if (createCoordinates) {
            CoordinateInventor inventor = new CoordinateInventor(this.mCoordinateMode);
            if (this.mRandomSeed != 0L) {
                inventor.setRandomSeed(this.mRandomSeed);
            }
            inventor.invent(this.mMol);
            if (readStereoFeatures) {
                this.mMol.setUnknownParitiesToExplicitlyUnknown();
            }
        }
        if (smartsFeatureFound || this.mSmartsMode == 2) {
            this.mMol.setFragment(true);
        }
    }

    private int parseAtomList(byte[] smiles, int start, SortedList<Integer> atomList) {
        atomList.removeAll();
        for (int p = start; p < smiles.length; ++p) {
            if (Character.isLetter(smiles[p])) continue;
            int atomicNo = Molecule.getAtomicNoFromLabel(new String(smiles, start, p - start));
            if (atomicNo != 0) {
                atomList.add(atomicNo);
            }
            start = p + 1;
            if (smiles[p] != 44) break;
        }
        return start - 1;
    }

    private boolean isBondSymbol(char theChar) {
        return theChar == '-' || theChar == '=' || theChar == '#' || theChar == ':' || theChar == '/' || theChar == '\\' || theChar == '<' || theChar == '!' || theChar == '@';
    }

    private int bondSymbolToQueryFeature(char symbol) {
        return symbol == '=' ? 2 : (symbol == '#' ? 4 : (symbol == ':' ? 8 : (symbol == '>' ? 16 : 1)));
    }

    private void smartsWarning(String feature) {
        if (this.mCreateSmartsWarnings) {
            if (this.mSmartsWarningBuffer == null) {
                this.mSmartsWarningBuffer = new StringBuilder();
            }
            this.mSmartsWarningBuffer.append(" ");
            this.mSmartsWarningBuffer.append(feature);
        }
    }

    private void locateAromaticDoubleBonds(boolean allowSmartsFeatures) throws Exception {
        int atom;
        int ring;
        int bond;
        int i;
        this.mMol.ensureHelperArrays(1);
        this.mIsAromaticBond = new boolean[this.mMol.getBonds()];
        this.mAromaticBonds = 0;
        for (int bond2 = 0; bond2 < this.mMol.getBonds(); ++bond2) {
            if (this.mMol.getBondType(bond2) != 64) continue;
            this.mMol.setBondType(bond2, 1);
            this.mIsAromaticBond[bond2] = true;
            ++this.mAromaticBonds;
        }
        boolean[] isAromaticRingAtom = new boolean[this.mMol.getAtoms()];
        RingCollection ringSet = new RingCollection(this.mMol, 3);
        boolean[] isAromaticRing = new boolean[ringSet.getSize()];
        for (int ring2 = 0; ring2 < ringSet.getSize(); ++ring2) {
            int i2;
            int[] ringAtom = ringSet.getRingAtoms(ring2);
            isAromaticRing[ring2] = true;
            for (i2 = 0; i2 < ringAtom.length; ++i2) {
                if (this.mMol.isMarkedAtom(ringAtom[i2])) continue;
                isAromaticRing[ring2] = false;
                break;
            }
            if (!isAromaticRing[ring2]) continue;
            for (i2 = 0; i2 < ringAtom.length; ++i2) {
                isAromaticRingAtom[ringAtom[i2]] = true;
            }
            int[] ringBond = ringSet.getRingBonds(ring2);
            for (i = 0; i < ringBond.length; ++i) {
                if (this.mIsAromaticBond[ringBond[i]]) continue;
                this.mIsAromaticBond[ringBond[i]] = true;
                ++this.mAromaticBonds;
            }
        }
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mIsAromaticBond[bond] || ringSet.getBondRingSize(bond) == 0 || !this.mMol.isMarkedAtom(this.mMol.getBondAtom(0, bond)) || !this.mMol.isMarkedAtom(this.mMol.getBondAtom(1, bond))) continue;
            this.addLargeAromaticRing(bond);
        }
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mIsAromaticBond[bond]) continue;
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atom2 = this.mMol.getBondAtom(1, bond);
            if (isAromaticRingAtom[atom1] || isAromaticRingAtom[atom2] || !this.mMol.isMarkedAtom(atom1) || !this.mMol.isMarkedAtom(atom2)) continue;
            this.mIsAromaticBond[bond] = true;
            ++this.mAromaticBonds;
        }
        this.mMol.ensureHelperArrays(7);
        boolean[] isAromaticBond = new boolean[this.mMol.getBonds()];
        for (int i3 = 0; i3 < this.mMol.getBonds(); ++i3) {
            isAromaticBond[i3] = this.mIsAromaticBond[i3];
        }
        for (ring = 0; ring < ringSet.getSize(); ++ring) {
            if (!isAromaticRing[ring]) continue;
            int[] ringAtom = ringSet.getRingAtoms(ring);
            for (i = 0; i < ringAtom.length; ++i) {
                if (this.qualifiesForPi(ringAtom[i])) continue;
                if (this.mMol.isMarkedAtom(ringAtom[i])) {
                    this.mMol.setAtomMarker(ringAtom[i], false);
                    --this.mAromaticAtoms;
                }
                for (int j = 0; j < this.mMol.getConnAtoms(ringAtom[i]); ++j) {
                    int connBond = this.mMol.getConnBond(ringAtom[i], j);
                    if (!this.mIsAromaticBond[connBond]) continue;
                    this.mIsAromaticBond[connBond] = false;
                    --this.mAromaticBonds;
                }
            }
        }
        this.promoteObviousBonds();
        for (ring = 0; ring < ringSet.getSize(); ++ring) {
            if (!isAromaticRing[ring] || ringSet.getRingSize(ring) != 6) continue;
            int[] ringBond = ringSet.getRingBonds(ring);
            boolean isFullyDelocalized = true;
            for (int bond3 : ringBond) {
                if (this.mIsAromaticBond[bond3]) continue;
                isFullyDelocalized = false;
                break;
            }
            if (!isFullyDelocalized) continue;
            this.promoteBond(ringBond[0]);
            this.promoteBond(ringBond[2]);
            this.promoteBond(ringBond[4]);
            this.promoteObviousBonds();
        }
        for (int qualifyingNo = 5; qualifyingNo >= 4; --qualifyingNo) {
            boolean qualifyingBondFound;
            block14: do {
                qualifyingBondFound = false;
                for (int bond4 = 0; bond4 < this.mMol.getBonds(); ++bond4) {
                    if (!this.mIsAromaticBond[bond4]) continue;
                    int aromaticConnBonds = 0;
                    for (int i4 = 0; i4 < 2; ++i4) {
                        int bondAtom = this.mMol.getBondAtom(i4, bond4);
                        for (int j = 0; j < this.mMol.getConnAtoms(bondAtom); ++j) {
                            if (!this.mIsAromaticBond[this.mMol.getConnBond(bondAtom, j)]) continue;
                            ++aromaticConnBonds;
                        }
                    }
                    if (aromaticConnBonds != qualifyingNo) continue;
                    this.promoteBond(bond4);
                    this.promoteObviousBonds();
                    qualifyingBondFound = true;
                    continue block14;
                }
            } while (qualifyingBondFound);
        }
        while (this.mAromaticAtoms >= 2 && this.connectConjugatedRadicalPairs(isAromaticBond)) {
        }
        if (allowSmartsFeatures) {
            if (this.mAromaticAtoms != 0) {
                for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    if (!this.mMol.isMarkedAtom(atom)) continue;
                    this.mMol.setAtomMarker(atom, false);
                    this.mMol.setAtomQueryFeature(atom, 2L, true);
                    --this.mAromaticAtoms;
                }
            }
            if (this.mAromaticBonds != 0) {
                for (int bond5 = 0; bond5 < this.mMol.getBonds(); ++bond5) {
                    if (!this.mIsAromaticBond[bond5]) continue;
                    this.mIsAromaticBond[bond5] = false;
                    this.mMol.setBondType(bond5, 64);
                    --this.mAromaticBonds;
                }
            }
        } else {
            for (atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                if (!this.mMol.isMarkedAtom(atom) || this.mMol.getImplicitHydrogens(atom) == 0) continue;
                this.mMol.setAtomMarker(atom, false);
                this.mMol.setAtomRadical(atom, 32);
                --this.mAromaticAtoms;
            }
        }
        if (this.mAromaticAtoms != 0) {
            throw new Exception("Assignment of aromatic double bonds failed");
        }
        if (this.mAromaticBonds != 0) {
            throw new Exception("Assignment of aromatic double bonds failed");
        }
    }

    private boolean connectConjugatedRadicalPairs(boolean[] isAromaticBond) {
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (!this.mMol.isMarkedAtom(atom)) continue;
            int[] graphLevel = new int[this.mMol.getAtoms()];
            int[] graphAtom = new int[this.mMol.getAtoms()];
            int[] graphParent = new int[this.mMol.getAtoms()];
            graphAtom[0] = atom;
            graphLevel[atom] = 1;
            graphParent[atom] = -1;
            int highest = 0;
            for (int current = 0; current <= highest; ++current) {
                int bondOrder = (graphLevel[graphAtom[current]] & 1) == 1 ? 1 : 2;
                for (int i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                    int candidate;
                    int bond = this.mMol.getConnBond(graphAtom[current], i);
                    if (this.mMol.getBondOrder(bond) != bondOrder || !isAromaticBond[bond] || graphLevel[candidate = this.mMol.getConnAtom(graphAtom[current], i)] != 0) continue;
                    if (bondOrder == 1 && this.mMol.isMarkedAtom(candidate)) {
                        int parent = graphAtom[current];
                        while (parent != -1) {
                            this.mMol.setBondType(this.mMol.getBond(candidate, parent), bondOrder == 1 ? 2 : 1);
                            bondOrder = 3 - bondOrder;
                            candidate = parent;
                            parent = graphParent[parent];
                        }
                        this.mMol.setAtomMarker(atom, false);
                        this.mMol.setAtomMarker(candidate, false);
                        this.mAromaticAtoms -= 2;
                        return true;
                    }
                    graphAtom[++highest] = candidate;
                    graphParent[candidate] = graphAtom[current];
                    graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
                }
            }
        }
        return false;
    }

    private void addLargeAromaticRing(int bond) {
        int[] graphLevel = new int[this.mMol.getAtoms()];
        int[] graphAtom = new int[this.mMol.getAtoms()];
        int[] graphBond = new int[this.mMol.getAtoms()];
        int[] graphParent = new int[this.mMol.getAtoms()];
        int atom1 = this.mMol.getBondAtom(0, bond);
        int atom2 = this.mMol.getBondAtom(1, bond);
        graphAtom[0] = atom1;
        graphAtom[1] = atom2;
        graphBond[0] = -1;
        graphBond[1] = bond;
        graphLevel[atom1] = 1;
        graphLevel[atom2] = 2;
        graphParent[atom1] = -1;
        graphParent[atom2] = atom1;
        int highest = 1;
        for (int current = 1; current <= highest && graphLevel[graphAtom[current]] < 15; ++current) {
            int parent = graphAtom[current];
            for (int i = 0; i < this.mMol.getConnAtoms(parent); ++i) {
                int candidate = this.mMol.getConnAtom(parent, i);
                if (candidate == graphParent[parent]) continue;
                int candidateBond = this.mMol.getConnBond(parent, i);
                if (candidate == atom1) {
                    graphBond[0] = candidateBond;
                    for (int j = 0; j <= highest; ++j) {
                        if (this.mIsAromaticBond[graphBond[i]]) continue;
                        this.mIsAromaticBond[graphBond[i]] = true;
                        ++this.mAromaticBonds;
                    }
                    return;
                }
                if (!this.mMol.isMarkedAtom(candidate) || graphLevel[candidate] != 0) continue;
                graphAtom[++highest] = candidate;
                graphBond[highest] = candidateBond;
                graphLevel[candidate] = graphLevel[parent] + 1;
                graphParent[candidate] = parent;
            }
        }
    }

    private boolean qualifiesForPi(int atom) {
        if (!RingCollection.qualifiesAsAromatic(this.mMol.getAtomicNo(atom))) {
            return false;
        }
        if (this.mMol.getAtomicNo(atom) == 6 && this.mMol.getAtomCharge(atom) != 0 || !this.mMol.isMarkedAtom(atom)) {
            return false;
        }
        byte explicitHydrogens = this.mMol.getAtomCustomLabel(atom) == null ? (byte)0 : this.mMol.getAtomCustomLabelBytes(atom)[0];
        int freeValence = this.mMol.getFreeValence(atom) - explicitHydrogens;
        if (freeValence < 1) {
            return false;
        }
        if (this.mMol.getAtomicNo(atom) == 16 || this.mMol.getAtomicNo(atom) == 34 || this.mMol.getAtomicNo(atom) == 52) {
            if (this.mMol.getConnAtoms(atom) == 2 && this.mMol.getAtomCharge(atom) <= 0) {
                return false;
            }
            if (freeValence == 2) {
                return false;
            }
        }
        return true;
    }

    private void promoteBond(int bond) {
        if (this.mMol.getBondType(bond) == 1) {
            this.mMol.setBondType(bond, 2);
        }
        for (int i = 0; i < 2; ++i) {
            int bondAtom = this.mMol.getBondAtom(i, bond);
            if (this.mMol.isMarkedAtom(bondAtom)) {
                this.mMol.setAtomMarker(bondAtom, false);
                --this.mAromaticAtoms;
            }
            for (int j = 0; j < this.mMol.getConnAtoms(bondAtom); ++j) {
                int connBond = this.mMol.getConnBond(bondAtom, j);
                if (!this.mIsAromaticBond[connBond]) continue;
                this.mIsAromaticBond[connBond] = false;
                --this.mAromaticBonds;
            }
        }
    }

    private void promoteObviousBonds() {
        boolean terminalAromaticBondFound;
        do {
            terminalAromaticBondFound = false;
            for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
                if (!this.mIsAromaticBond[bond]) continue;
                boolean isTerminalAromaticBond = false;
                for (int i = 0; i < 2; ++i) {
                    boolean aromaticNeighbourFound = false;
                    int bondAtom = this.mMol.getBondAtom(i, bond);
                    for (int j = 0; j < this.mMol.getConnAtoms(bondAtom); ++j) {
                        if (bond == this.mMol.getConnBond(bondAtom, j) || !this.mIsAromaticBond[this.mMol.getConnBond(bondAtom, j)]) continue;
                        aromaticNeighbourFound = true;
                        break;
                    }
                    if (aromaticNeighbourFound) continue;
                    isTerminalAromaticBond = true;
                    break;
                }
                if (!isTerminalAromaticBond) continue;
                terminalAromaticBondFound = true;
                this.promoteBond(bond);
            }
        } while (terminalAromaticBondFound);
    }

    private void correctValenceExceededNitrogen() {
        block0: for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.getAtomicNo(atom) != 7 || this.mMol.getAtomCharge(atom) != 0 || this.mMol.getOccupiedValence(atom) <= 3 || this.mMol.getAtomPi(atom) <= 0) continue;
            for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                int connAtom = this.mMol.getConnAtom(atom, i);
                int connBond = this.mMol.getConnBond(atom, i);
                if (this.mMol.getBondOrder(connBond) <= 1 || !this.mMol.isElectronegative(connAtom)) continue;
                if (this.mMol.getBondType(connBond) == 4) {
                    this.mMol.setBondType(connBond, 2);
                } else {
                    this.mMol.setBondType(connBond, 1);
                }
                this.mMol.setAtomCharge(atom, this.mMol.getAtomCharge(atom) + 1);
                this.mMol.setAtomCharge(connAtom, this.mMol.getAtomCharge(connAtom) - 1);
                this.mMol.setAtomAbnormalValence(atom, -1);
                continue block0;
            }
        }
    }

    private boolean assignKnownEZBondParities() {
        int bond;
        this.mMol.ensureHelperArrays(7);
        boolean paritiesFound = false;
        int[] refAtom = new int[2];
        int[] refBond = new int[2];
        int[] otherAtom = new int[2];
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            int i;
            if (this.mMol.isSmallRingBond(bond) || this.mMol.getBondType(bond) != 2) continue;
            for (int i2 = 0; i2 < 2; ++i2) {
                refAtom[i2] = -1;
                otherAtom[i2] = -1;
                int atom = this.mMol.getBondAtom(i2, bond);
                for (int j = 0; j < this.mMol.getConnAtoms(atom); ++j) {
                    int connBond = this.mMol.getConnBond(atom, j);
                    if (connBond == bond) continue;
                    if (refAtom[i2] == -1 && (this.mMol.getBondType(connBond) == 17 || this.mMol.getBondType(connBond) == 9)) {
                        refAtom[i2] = this.mMol.getConnAtom(atom, j);
                        refBond[i2] = connBond;
                        continue;
                    }
                    otherAtom[i2] = this.mMol.getConnAtom(atom, j);
                }
                if (refAtom[i2] == -1) break;
            }
            if (refAtom[0] == -1 || refAtom[1] == -1) continue;
            boolean isZ = this.mMol.getBondType(refBond[0]) == this.mMol.getBondType(refBond[1]);
            for (i = 0; i < 2; ++i) {
                if (refAtom[i] != this.mMol.getBondAtom(0, refBond[i])) continue;
                isZ = !isZ;
            }
            for (i = 0; i < 2; ++i) {
                if (otherAtom[i] == -1 || otherAtom[i] >= refAtom[i]) continue;
                isZ = !isZ;
            }
            this.mMol.setBondParity(bond, isZ ? 2 : 1, false);
            paritiesFound = true;
        }
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (this.mMol.getBondType(bond) != 17 && this.mMol.getBondType(bond) != 9) continue;
            this.mMol.setBondType(bond, 1);
        }
        return paritiesFound;
    }

    private static void testStereo() {
        String[][] data = new String[][]{{"F/C=C/I", "F/C=C/I"}, {"F/C=C\\I", "F/C=C\\I"}, {"C(=C/I)/F", "F/C=C\\I"}, {"[H]C(/F)=C/I", "F/C=C\\I"}, {"C(=C\\1)/I.F1", "F/C=C/I"}, {"C(=C1)/I.F/1", "F/C=C/I"}, {"C(=C\\F)/1.I1", "F/C=C/I"}, {"C(=C\\F)1.I\\1", "F/C=C/I"}, {"C\\1=C/I.F1", "F/C=C/I"}, {"C1=C/I.F/1", "F/C=C/I"}, {"C(=C\\1)/2.F1.I2", "F/C=C/I"}, {"C/2=C\\1.F1.I2", "F/C=C/I"}, {"C/1=C/C=C/F.I1", "F/C=C/C=C\\I"}, {"C1=C/C=C/F.I\\1", "F/C=C/C=C\\I"}, {"C(/I)=C/C=C/1.F1", "F/C=C/C=C\\I"}, {"C(/I)=C/C=C1.F\\1", "F/C=C/C=C\\I"}, {"[C@](Cl)(F)(I)1.Br1", "F[C@](Cl)(Br)I"}, {"Br[C@](Cl)(I)1.F1", "F[C@](Cl)(Br)I"}, {"[C@H](F)(I)1.Br1", "F[C@H](Br)I"}, {"Br[C@@H](F)1.I1", "F[C@H](Br)I"}, {"C[S@@](CC)=O", "CC[S@](C)=O"}, {"[S@](=O)(C)CC", "CC[S](C)=O"}};
        StereoMolecule mol = new StereoMolecule();
        for (String[] test : data) {
            try {
                new SmilesParser().parse(mol, test[0]);
                String smiles = new IsomericSmilesCreator(mol).getSmiles();
                System.out.print("IN:" + test[0] + " OUT:" + smiles);
                if (!test[1].equals(smiles)) {
                    System.out.println(" EXPECTED: " + test[1] + " ERROR!");
                    continue;
                }
                System.out.println(" OK");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        SmilesParser.testStereo();
        System.out.println("ID-code equivalence test:");
        String[][] data = new String[][]{{"N[C@@]([H])(C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"N[C@@H](C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"N[C@H](C(=O)O)C", "S-alanine", "gGX`BDdwMUM@@"}, {"[H][C@](N)(C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"[C@H](N)(C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"N[C@]([H])(C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"N[C@H](C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"N[C@@H](C(=O)O)C", "R-alanine", "gGX`BDdwMUL`@"}, {"[H][C@@](N)(C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"[C@@H](N)(C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"C[C@H]1CCCCO1", "S-Methyl-pyran", "gOq@@eLm]UUH`@"}, {"O1CCCC[C@@H]1C", "S-Methyl-pyran", "gOq@@eLm]UUH`@"}, {"[C@H](F)(B)O", "S-Methyl-oxetan", "gCaDDICTBSURH@"}, {"C1CO[C@H]1C", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"C1CO[C@@H](C)1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[C@H]1(C)CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[H][C@]1(C)CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[H][C@@]1(CCO1)C", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[C@@]1([H])(C)CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[C@]1(C)([H])CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"C1[C@@H]2COC2=N1", "oxetan-azetin", "gGy@LDimDvfja`@"}, {"CC(C)[C@@]12C[C@@H]1[C@@H](C)C(=O)C2", "alpha-thujone", "dmLH@@RYe~IfyjjjkDaIh@"}, {"CN1CCC[C@H]1c2cccnc2", "Nicotine", "dcm@@@{IDeCEDUSh@UUECP@"}, {"CC[C@H](O1)CC[C@@]12CCCO2", "2S,5R-Chalcogran", "dmLD@@qJZY|fFZjjjdbH`@"}, {"CCCC", "butane", "gC`@Dij@@"}, {"C1C.CC1", "butane", "gC`@Dij@@"}, {"[CH3][CH2][CH2][CH3]", "butane", "gC`@Dij@@"}, {"C-C-C-C", "butane", "gC`@Dij@@"}, {"C12.C1.CC2", "butane", "gC`@Dij@@"}, {"[Na+].[Cl-]", "NaCl", "eDARHm@zd@@"}, {"[Na+]-[Cl-]", "NaCl", "error"}, {"[Na+]1.[Cl-]1", "NaCl", "error"}, {"c1ccccc1", "benzene", "gFp@DiTt@@@"}, {"C1=C-C=C-C=C1", "benzene", "gFp@DiTt@@@"}, {"C1:C:C:C:C:C:1", "benzene", "gFp@DiTt@@@"}, {"c1ccncc1", "pyridine", "gFx@@eJf`@@@"}, {"[nH]1cccc1", "pyrrole", "gKX@@eKcRp@"}, {"N1C=C-C=C1", "pyrrole", "gKX@@eKcRp@"}, {"[H]n1cccc1", "pyrrole", "gKX@@eKcRp@"}, {"[H]n1cccc1", "pyrrole", "gKX@@eKcRp@"}, {"c1cncc1", "pyrrole no [nH]", "error"}, {"[13CH4]", "C13-methane", "fH@FJp@"}, {"[35ClH]", "35-chlorane", "fHdP@qX`"}, {"[35Cl-]", "35-chloride", "fHtPxAbq@"}, {"[Na+].[O-]c1ccccc1", "Na-phenolate", "daxHaHCPBXyAYUn`@@@"}, {"c1cc([O-].[Na+])ccc1", "Na-phenolate", "daxHaHCPBXyAYUn`@@@"}, {"C[C@@](C)(O1)C[C@@H](O)[C@@]1(O2)[C@@H](C)[C@@H]3CC=C4[C@]3(C2)C(=O)C[C@H]5[C@H]4CC[C@@H](C6)[C@]5(C)Cc(n7)c6nc(C[C@@]89(C))c7C[C@@H]8CC[C@@H]%10[C@@H]9C[C@@H](O)[C@@]%11(C)C%10=C[C@H](O%12)[C@]%11(O)[C@H](C)[C@]%12(O%13)[C@H](O)C[C@@]%13(C)CO", "Cephalostatin-1", "gdKe@h@@K`H@XjKHuYlnoP\\bbdRbbVTLbTrJbRaQRRRbTJTRTrfrfTTOBPHtFODPhLNSMdIERYJmShLfs]aqy|uUMUUUUUUE@UUUUMUUUUUUTQUUTPR`nDdQQKB|RIFbiQeARuQt`rSSMNtGS\\ct@@"}};
        StereoMolecule mol = new StereoMolecule();
        for (String[] test : data) {
            try {
                new SmilesParser().parse(mol, test[0]);
                String idcode = new Canonizer(mol).getIDCode();
                if (test[2].equals("error")) {
                    System.out.println("Should create error! " + test[1] + " smiles:" + test[0] + " idcode:" + idcode);
                    continue;
                }
                if (test[2].equals(idcode)) continue;
                System.out.println("ERROR! " + test[1] + " smiles:" + test[0] + " is:" + idcode + " must:" + test[2]);
            }
            catch (Exception e) {
                if (test[2].equals("error")) continue;
                System.out.println("ERROR! " + test[1] + " smiles:" + test[0] + " exception:" + e.getMessage());
            }
        }
    }

    private class THParity {
        private static final int PSEUDO_ATOM_HYDROGEN = 0x7FFFFFFE;
        private static final int PSEUDO_ATOM_LONE_PAIR = Integer.MAX_VALUE;
        int mCentralAtom;
        int mCentralAtomPosition;
        boolean mIsClockwise;
        boolean mError;
        ArrayList<ParityNeighbour> mNeighbourList;

        public THParity(int centralAtom, int centralAtomPosition, int fromAtom, int explicitHydrogen, int hydrogenPosition, boolean isClockwise) {
            if (explicitHydrogen != 0 && explicitHydrogen != 1) {
                this.mError = true;
            } else {
                this.mCentralAtom = centralAtom;
                this.mCentralAtomPosition = centralAtomPosition;
                this.mIsClockwise = isClockwise;
                this.mNeighbourList = new ArrayList();
                if (fromAtom != -1) {
                    this.addNeighbor(fromAtom, centralAtomPosition - 1, false);
                }
                if (fromAtom != -1 && explicitHydrogen == 1) {
                    this.addNeighbor(0x7FFFFFFE, centralAtomPosition + 1, false);
                }
            }
        }

        public void addNeighbor(int atom, int position, boolean unused) {
            if (!this.mError) {
                if (this.mNeighbourList.size() == 4) {
                    this.mError = true;
                    return;
                }
                this.mNeighbourList.add(new ParityNeighbour(atom, position));
            }
        }

        public int calculateParity(int[] handleHydrogenAtomMap) {
            if (this.mError) {
                return 3;
            }
            for (ParityNeighbour neighbour : this.mNeighbourList) {
                if (neighbour.mAtom == 0x7FFFFFFE || neighbour.mAtom == Integer.MAX_VALUE) continue;
                neighbour.mAtom = handleHydrogenAtomMap[neighbour.mAtom];
            }
            if (this.mNeighbourList.size() == 3) {
                this.mNeighbourList.add(new ParityNeighbour(Integer.MAX_VALUE, this.mCentralAtomPosition));
            } else if (this.mNeighbourList.size() != 4) {
                return 3;
            }
            int parity = this.mIsClockwise ^ this.isInverseOrder() ? 1 : 2;
            return parity;
        }

        private boolean isInverseOrder() {
            boolean inversion = false;
            for (int i = 1; i < this.mNeighbourList.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (this.mNeighbourList.get((int)j).mAtom > this.mNeighbourList.get((int)i).mAtom) {
                        boolean bl = inversion = !inversion;
                    }
                    if (this.mNeighbourList.get((int)j).mPosition <= this.mNeighbourList.get((int)i).mPosition) continue;
                    inversion = !inversion;
                }
            }
            return inversion;
        }
    }

    private class ParityNeighbour {
        int mAtom;
        int mPosition;

        public ParityNeighbour(int atom, int position) {
            this.mAtom = atom;
            this.mPosition = position;
        }
    }
}

