/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

class SmilesRange {
    private byte[] smi;
    private int pos;
    public int min;
    public int max;
    public boolean isDefault;

    public SmilesRange(byte[] smiles) {
        this.smi = smiles;
    }

    public int parse(byte[] smiles, int position, int defaultMin, int defaultMax) {
        this.isDefault = false;
        this.pos = position;
        if (Character.isDigit(smiles[position])) {
            this.min = this.max = this.parseInt();
            return this.pos - position;
        }
        if (smiles[position] == 123 && Character.isDigit(smiles[position + 1])) {
            ++this.pos;
            this.min = this.parseInt();
            if (smiles[this.pos++] != 45) {
                return 0;
            }
            if (!Character.isDigit(smiles[this.pos])) {
                return 0;
            }
            this.max = this.parseInt();
            if (smiles[this.pos++] != 125) {
                return 0;
            }
            return this.pos - position;
        }
        this.min = defaultMin;
        this.max = defaultMax;
        this.isDefault = true;
        return 0;
    }

    public boolean isSingle() {
        return this.max == this.min;
    }

    public boolean isRange() {
        return this.max > this.min;
    }

    public String toString() {
        return "{" + this.min + "-" + this.max + "}";
    }

    private int parseInt() {
        int num = this.smi[this.pos++] - 48;
        if (Character.isDigit(this.smi[this.pos])) {
            num = 10 * num + (this.smi[this.pos++] - 48);
        }
        return num;
    }
}

