/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import java.io.Serializable;
import java.util.ArrayList;

public class SortedStringList
implements Serializable {
    static final long serialVersionUID = 537265952L;
    private ArrayList<String> mList = new ArrayList();

    public boolean contains(String theString) {
        return this.getListIndex(theString) != -1;
    }

    public boolean equals(SortedStringList s) {
        if (this.mList.size() != s.mList.size()) {
            return false;
        }
        for (int i = 0; i < this.mList.size(); ++i) {
            if (this.mList.get(i).equals(s.mList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int getListIndex(String theString) {
        int vectorSize = this.mList.size();
        if (vectorSize == 0) {
            return -1;
        }
        int index = 1;
        while (2 * index <= vectorSize) {
            index <<= 1;
        }
        int increment = index--;
        while (increment != 0) {
            increment >>= 1;
            if (index >= vectorSize) {
                index -= increment;
                continue;
            }
            int comparison = theString.compareTo(this.mList.get(index));
            if (comparison == 0) {
                return index;
            }
            if (increment == 0) break;
            if (comparison < 0) {
                index -= increment;
                continue;
            }
            index += increment;
        }
        return -1;
    }

    public int addString(String theString) {
        int vectorSize = this.mList.size();
        if (vectorSize == 0) {
            this.mList.add(0, theString);
            return 0;
        }
        int index = 1;
        while (2 * index <= vectorSize) {
            index <<= 1;
        }
        int increment = index--;
        while (increment != 0) {
            increment >>= 1;
            if (index >= vectorSize) {
                index -= increment;
                continue;
            }
            int comparison = theString.compareTo(this.mList.get(index));
            if (comparison == 0) {
                return -1;
            }
            if (increment == 0) break;
            if (comparison < 0) {
                index -= increment;
                continue;
            }
            index += increment;
        }
        if (index < vectorSize && theString.compareTo(this.mList.get(index)) > 0) {
            ++index;
        }
        this.mList.add(index, theString);
        return index;
    }

    public int getSize() {
        return this.mList.size();
    }

    public String getStringAt(int i) {
        return this.mList.get(i);
    }

    public String[] toArray() {
        return this.mList.toArray(new String[0]);
    }

    public void removeAllStrings() {
        this.mList.clear();
    }
}

