/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StereoMolecule
extends ExtendedMolecule {
    static final long serialVersionUID = 537316094L;
    public static final String VALIDATION_ERROR_ESR_CENTER_UNKNOWN = "Members of ESR groups must only be stereo centers with known configuration.";
    public static final String VALIDATION_ERROR_OVER_UNDER_SPECIFIED = "Over- or under-specified stereo feature or more than one racemic type bond";
    public static final String VALIDATION_ERROR_AMBIGUOUS_CONFIGURATION = "Ambiguous configuration at stereo center because of 2 parallel bonds";
    public static final String[] VALIDATION_ERRORS_STEREO = new String[]{"Members of ESR groups must only be stereo centers with known configuration.", "Over- or under-specified stereo feature or more than one racemic type bond", "Ambiguous configuration at stereo center because of 2 parallel bonds"};
    private transient Canonizer mCanonizer;
    private transient boolean mAssignParitiesToNitrogen;

    public StereoMolecule() {
    }

    public StereoMolecule(int maxAtoms, int maxBonds) {
        super(maxAtoms, maxBonds);
    }

    public StereoMolecule(Molecule mol) {
        super(mol);
    }

    public StereoMolecule createMolecule(int atoms, int bonds) {
        return new StereoMolecule(atoms, bonds);
    }

    @Override
    public StereoMolecule getCompactCopy() {
        StereoMolecule theCopy = new StereoMolecule(this.mAllAtoms, this.mAllBonds);
        this.copyMolecule(theCopy);
        return theCopy;
    }

    @Override
    public void copyMoleculeProperties(Molecule destMol) {
        super.copyMoleculeProperties(destMol);
        if (this.mCanonizer != null) {
            destMol.mValidHelperArrays = 0;
        }
    }

    public StereoMolecule[] getFragments() {
        int[] fragmentNo = new int[this.mAllAtoms];
        int fragments = this.getFragmentNumbers(fragmentNo, false, false);
        return this.getFragments(fragmentNo, fragments);
    }

    public StereoMolecule[] getFragments(int[] fragmentNo, int fragmentCount) {
        int f2;
        int f1;
        int bond;
        int atom;
        StereoMolecule[] fragment = new StereoMolecule[fragmentCount];
        int[] atoms = new int[fragmentCount];
        int[] bonds = new int[fragmentCount];
        int[] atomMap = new int[this.mAllAtoms];
        for (atom = 0; atom < this.mAllAtoms; ++atom) {
            if (fragmentNo[atom] == -1) continue;
            int n = fragmentNo[atom];
            atoms[n] = atoms[n] + 1;
        }
        for (bond = 0; bond < this.mAllBonds; ++bond) {
            f1 = fragmentNo[this.mBondAtom[0][bond]];
            f2 = fragmentNo[this.mBondAtom[1][bond]];
            if (f1 != f2 || f1 == -1) continue;
            int n = f1;
            bonds[n] = bonds[n] + 1;
        }
        for (int i = 0; i < fragmentCount; ++i) {
            fragment[i] = this.createMolecule(atoms[i], bonds[i]);
            this.copyMoleculeProperties(fragment[i]);
        }
        for (atom = 0; atom < this.mAllAtoms; ++atom) {
            if (fragmentNo[atom] == -1) continue;
            this.copyAtom(fragment[fragmentNo[atom]], atom, 0, 0);
        }
        for (bond = 0; bond < this.mAllBonds; ++bond) {
            f1 = fragmentNo[this.mBondAtom[0][bond]];
            f2 = fragmentNo[this.mBondAtom[1][bond]];
            if (f1 != f2 || f1 == -1) continue;
            this.copyBond(fragment[f1], bond, 0, 0, atomMap, false);
        }
        for (StereoMolecule f : fragment) {
            f.renumberESRGroups(1);
            f.renumberESRGroups(2);
        }
        return fragment;
    }

    @Override
    public void ensureHelperArrays(int required) {
        super.ensureHelperArrays(required);
        if ((required & ~this.mValidHelperArrays) == 0) {
            return;
        }
        if (this.mAssignParitiesToNitrogen) {
            required |= 0x100;
        }
        int atom = 0;
        while (atom < this.getAllAtoms()) {
            int n = atom++;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xF7FC7FF8;
        }
        int bond = 0;
        while (bond < this.getBonds()) {
            int n = bond++;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFFFFC0;
        }
        int rankBits = 0;
        int rankMode = 0;
        if ((required & 0x20) != 0) {
            rankBits = 32;
            rankMode = 1;
        } else if ((required & 0x40) != 0) {
            rankBits = 64;
            rankMode = 3;
        } else if ((required & 0x80) != 0) {
            rankBits = 128;
            rankMode = 5;
        }
        if ((required & 0x100) != 0) {
            rankBits |= 0x100;
            rankMode |= 0x20;
        }
        this.mCanonizer = new Canonizer(this, rankMode);
        this.mCanonizer.setParities();
        this.mCanonizer.setStereoCenters();
        this.mCanonizer.setCIPParities();
        if (this.validateESR()) {
            this.mCanonizer = new Canonizer(this, rankMode);
        }
        this.mValidHelperArrays |= 0x18 | rankBits;
    }

    private boolean validateESR() {
        boolean paritiesUpdated = false;
        for (int atom = 0; atom < this.getAtoms(); ++atom) {
            if (this.isAtomStereoCenter(atom) && this.getAtomParity(atom) != 3) continue;
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFC07FFFF;
        }
        for (int bond = 0; bond < this.getBonds(); ++bond) {
            if (this.getBondOrder(bond) == 1 && this.getBondParity(bond) != 0 && this.getBondParity(bond) != 3) continue;
            int n = bond;
            this.mBondFlags[n] = this.mBondFlags[n] & 0xFFFE03FF;
        }
        if (this.mIsRacemate) {
            if ((this.mChirality & 0xFFFF0000) != 131072) {
                int atom;
                boolean[] isIndependentRacemicAtom = new boolean[this.getAtoms()];
                for (atom = 0; atom < this.getAtoms(); ++atom) {
                    if (!this.isAtomStereoCenter(atom) || this.getAtomParity(atom) == 3 || this.getAtomESRType(atom) != 1) continue;
                    isIndependentRacemicAtom[atom] = true;
                }
                for (atom = 0; atom < this.getAtoms(); ++atom) {
                    if (!this.isAtomStereoCenter(atom) || this.getAtomParity(atom) == 3) continue;
                    this.setAtomESR(atom, 1, 0);
                    paritiesUpdated = true;
                }
                for (atom = 0; atom < this.getAtoms(); ++atom) {
                    if (!isIndependentRacemicAtom[atom]) continue;
                    this.setAtomParity(atom, 1, false);
                    this.setAtomESR(atom, 1, -1);
                    paritiesUpdated = true;
                }
            }
            this.mIsRacemate = false;
        }
        this.renumberESRGroups(1);
        this.renumberESRGroups(2);
        return paritiesUpdated;
    }

    public void stripStereoInformation() {
        this.ensureHelperArrays(15);
        this.mIsRacemate = false;
        for (int atom = 0; atom < this.mAllAtoms; ++atom) {
            int n = atom;
            this.mAtomFlags[n] = this.mAtomFlags[n] & 0xFC07FFFF;
            if ((this.mAtomFlags[atom] & 3) != 0) {
                int n2 = atom;
                this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x4000000;
                continue;
            }
            int n3 = atom;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFBFFFFFF;
        }
        for (int bond = 0; bond < this.mAllBonds; ++bond) {
            if ((this.mBondFlags[bond] & 3) != 0 && this.getBondOrder(bond) == 2) {
                this.mBondType[bond] = 26;
                continue;
            }
            int n = bond;
            this.mBondType[n] = this.mBondType[n] & 0xFFFFFFE7;
        }
        this.mValidHelperArrays &= 0xFFFFFE07;
    }

    public int getAbsoluteAtomParity(int atom) {
        return this.mCanonizer.getTHParity(atom);
    }

    public int getAbsoluteBondParity(int bond) {
        return this.mCanonizer.getEZParity(bond);
    }

    public int getSymmetryRank(int atom) {
        return this.mCanonizer.getSymmetryRank(atom);
    }

    public String getIDCode() {
        this.ensureHelperArrays(15);
        return this.mCanonizer == null ? null : this.mCanonizer.getIDCode();
    }

    public String getIDCoordinates() {
        this.ensureHelperArrays(15);
        return this.mCanonizer == null ? null : this.mCanonizer.getEncodedCoordinates();
    }

    public Canonizer getCanonizer() {
        this.ensureHelperArrays(15);
        return this.mCanonizer;
    }

    public int getStereoCenterCount() {
        this.ensureHelperArrays(31);
        int scCount = 0;
        for (int atom = 0; atom < this.getAtoms(); ++atom) {
            if (this.getAtomParity(atom) == 0 || this.isAtomParityPseudo(atom)) continue;
            ++scCount;
        }
        return scCount;
    }

    public int[][] getESRGroupMemberCounts() {
        int type;
        int type2;
        this.ensureHelperArrays(15);
        int[] maxESRGroup = new int[3];
        for (int atom = 0; atom < this.getAtoms(); ++atom) {
            if (!this.isAtomStereoCenter(atom) || (type2 = this.getAtomESRType(atom)) == 0) continue;
            maxESRGroup[type2] = Math.max(maxESRGroup[type2], this.getAtomESRGroup(atom));
        }
        for (int bond = 0; bond < this.getBonds(); ++bond) {
            if (this.getBondParity(bond) != 1 && this.getBondParity(bond) != 2 || this.getBondType(bond) != 1 || (type2 = this.getBondESRType(bond)) == 0) continue;
            maxESRGroup[type2] = Math.max(maxESRGroup[type2], this.getBondESRGroup(bond));
        }
        int[][] esrGroupMembers = new int[3][];
        esrGroupMembers[1] = new int[1 + maxESRGroup[1]];
        esrGroupMembers[2] = new int[1 + maxESRGroup[2]];
        for (int atom = 0; atom < this.getAtoms(); ++atom) {
            if (!this.isAtomStereoCenter(atom) || (type = this.getAtomESRType(atom)) == 0) continue;
            int[] nArray = esrGroupMembers[type];
            int n = this.getAtomESRGroup(atom);
            nArray[n] = nArray[n] + 1;
        }
        for (int bond = 0; bond < this.getBonds(); ++bond) {
            if (this.getBondParity(bond) != 1 && this.getBondParity(bond) != 2 || this.getBondType(bond) != 1 || (type = this.getBondESRType(bond)) == 0) continue;
            int[] nArray = esrGroupMembers[type];
            int n = this.getBondESRGroup(bond);
            nArray[n] = nArray[n] + 1;
        }
        return esrGroupMembers;
    }

    public void setUnknownParitiesToExplicitlyUnknown() {
        this.ensureHelperArrays(31);
        if (this.mCanonizer != null) {
            this.mCanonizer.setUnknownParitiesToExplicitlyUnknown();
        }
    }

    public void setAssignParitiesToNitrogen(boolean b) {
        this.mAssignParitiesToNitrogen = b;
        this.mValidHelperArrays &= 0xFFFFFEF0;
    }

    public int translateTHParity(int atom, int[] targetAtomIndex) {
        int parity = this.getAtomParity(atom);
        if (parity == 1 || parity == 2) {
            boolean inversion = false;
            if (this.isCentralAlleneAtom(atom)) {
                for (int i = 0; i < this.getConnAtoms(atom); ++i) {
                    int connAtom = this.getConnAtom(atom, i);
                    int neighbours = 0;
                    int[] neighbour = new int[3];
                    for (int j = 0; j < this.getConnAtoms(connAtom); ++j) {
                        neighbour[neighbours] = this.getConnAtom(connAtom, j);
                        if (neighbour[neighbours] == atom) continue;
                        ++neighbours;
                    }
                    if (neighbours != 2 || !(neighbour[0] < neighbour[1] ^ targetAtomIndex[neighbour[0]] < targetAtomIndex[neighbour[1]])) continue;
                    inversion = !inversion;
                }
            } else {
                for (int i = 1; i < this.getConnAtoms(atom); ++i) {
                    for (int j = 0; j < i; ++j) {
                        int connAtom2;
                        int connAtom1 = this.getConnAtom(atom, i);
                        if (!(connAtom1 < (connAtom2 = this.getConnAtom(atom, j)) ^ targetAtomIndex[connAtom1] < targetAtomIndex[connAtom2])) continue;
                        inversion = !inversion;
                    }
                }
            }
            if (inversion) {
                parity = parity == 1 ? 2 : 1;
            }
        }
        return parity;
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        this.ensureHelperArrays(31);
        for (int atom = 0; atom < this.getAtoms(); ++atom) {
            int i;
            if (!(this.getAtomESRType(atom) != 1 && this.getAtomESRType(atom) != 2 || this.isAtomStereoCenter(atom) && this.getAtomParity(atom) != 3)) {
                throw new Exception(VALIDATION_ERROR_ESR_CENTER_UNKNOWN);
            }
            if ((this.mAtomFlags[atom] & 0x20000) != 0) {
                throw new Exception("Over- or under-specified stereofeature or more than one racemic type bond");
            }
            if (this.getAtomParity(atom) != 1 && this.getAtomParity(atom) != 2 || this.getAtomPi(atom) != 0) continue;
            double[] angle = new double[this.getConnAtoms(atom)];
            for (i = 0; i < this.getConnAtoms(atom); ++i) {
                angle[i] = this.getBondAngle(atom, this.getConnAtom(atom, i));
            }
            for (i = 1; i < this.getConnAtoms(atom); ++i) {
                if (this.isStereoBond(this.getConnBond(atom, i), atom)) continue;
                for (int j = 0; j < i; ++j) {
                    if (this.isStereoBond(this.getConnBond(atom, j), atom) || !this.bondsAreParallel(angle[i], angle[j])) continue;
                    throw new Exception(VALIDATION_ERROR_AMBIGUOUS_CONFIGURATION);
                }
            }
        }
    }

    @Override
    public String getChiralText() {
        this.ensureHelperArrays(31);
        int count = this.mChirality & 0xFFFF;
        switch (this.mChirality & 0xFFFF0000) {
            case 65536: {
                return null;
            }
            case 131072: {
                return count == 1 ? "meso" : "" + count + " meso diastereomers";
            }
            case 0: {
                return "unknown chirality";
            }
            case 196608: {
                return "racemate";
            }
            case 262144: {
                return "this enantiomer";
            }
            case 327680: {
                return "this or other enantiomer";
            }
            case 393216: {
                return "two epimers";
            }
        }
        return count == 1 ? "one stereo isomer" : "" + count + " stereo isomers";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException {
    }
}

