/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import java.util.ArrayList;

public class TextDrawingObject
extends AbstractDrawingObject {
    public static final String TYPE_STRING = "text";
    public static final double DEFAULT_SIZE = 9.0;
    public static final int DEFAULT_STYLE = 0;
    private static final float LINE_SPACING = 1.4f;
    private double mSize;
    private double mZoomReferenceSize;
    private String mText;
    private int mStyle;
    private boolean mHilite;
    private GenericRectangle mLastBounds;

    public TextDrawingObject() {
        this("", new GenericPoint(), 9.0, 0);
    }

    public TextDrawingObject(String text, double x, double y) {
        this(text, x, y, 9.0, 0);
    }

    public TextDrawingObject(String text, double x, double y, double size, int style) {
        this(text, new GenericPoint(x, y), size, style);
    }

    public TextDrawingObject(String descriptorDetail) {
        this();
        int index2;
        int index1 = 0;
        while (index1 != -1 && (index2 = descriptorDetail.indexOf("=\"", index1)) != -1) {
            String value;
            String key = descriptorDetail.substring(index1 + 1, index2);
            index1 = descriptorDetail.indexOf("\"", index2 + 2);
            String string = value = index1 == -1 ? descriptorDetail.substring(index2 + 1) : descriptorDetail.substring(index2 + 1, index1);
            if (key.equals(TYPE_STRING)) {
                this.setText(value);
                continue;
            }
            if (key.equals("x")) {
                this.setX(value);
                continue;
            }
            if (key.equals("y")) {
                this.setY(value);
                continue;
            }
            if (key.equals("size")) {
                this.setSize(value);
                continue;
            }
            if (!key.equals("style")) continue;
            this.setStyle(value);
        }
    }

    protected void setText(String value) {
        this.mText = this.decodeText(value);
    }

    protected void setX(String value) {
        try {
            this.mPoint[0].x = Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setY(String value) {
        try {
            this.mPoint[0].y = Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setSize(String value) {
        try {
            this.mSize = Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setStyle(String value) {
        try {
            this.mStyle = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private TextDrawingObject(String text, GenericPoint pt, double size, int style) {
        this.mText = text;
        this.mSize = size;
        this.mStyle = style;
        this.mPoint = new GenericPoint[1];
        this.mPoint[0] = pt;
    }

    @Override
    public String getTypeString() {
        return TYPE_STRING;
    }

    @Override
    public String getDescriptorDetail() {
        StringBuilder detail = new StringBuilder();
        detail.append(" text=\"" + this.encodeText(this.mText) + "\"");
        detail.append(" x=\"" + this.mPoint[0].x + "\"");
        detail.append(" y=\"" + this.mPoint[0].y + "\"");
        if (this.mSize != 9.0) {
            detail.append(String.format(" size=\"%.4f\"", new Double(this.mSize)));
        }
        if (this.mStyle != 0) {
            detail.append(" style=\"" + this.mStyle + "\"");
        }
        return detail.toString();
    }

    @Override
    public AbstractDrawingObject clone() {
        TextDrawingObject duplicate = new TextDrawingObject();
        duplicate.setValues(this.mText, this.mSize, this.mStyle);
        duplicate.setCoordinates(this.mPoint[0].x, this.mPoint[0].y);
        duplicate.mIsSelected = this.mIsSelected;
        return duplicate;
    }

    public void setCoordinates(double x, double y) {
        this.mPoint[0].x = x;
        this.mPoint[0].y = y;
    }

    @Override
    public void scale(double f) {
        super.scale(f);
        this.mSize *= f;
    }

    @Override
    public void zoomAndRotateInit(double x, double y) {
        super.zoomAndRotateInit(x, y);
        this.mZoomReferenceSize = this.mSize;
    }

    @Override
    public void zoomAndRotate(double zoom, double angle) {
        super.zoomAndRotate(zoom, angle);
        this.mSize = this.mZoomReferenceSize * zoom;
    }

    @Override
    public void draw(GenericDrawContext context, DepictorTransformation t) {
        float size = (float)(t == null ? this.mSize : t.getScaling() * this.mSize);
        context.setFont(Math.round(size), (this.mStyle & 1) != 0, (this.mStyle & 2) != 0);
        context.setRGB(this.mIsSelected ? -65536 : (context.isDarkBackground() ? -1 : -16777216));
        ArrayList<String> textList = this.getTextLineList();
        this.mLastBounds = this.calculateBoundingRect(context, textList);
        if (t != null) {
            t.applyTo(this.mLastBounds);
        }
        for (int i = 0; i < textList.size(); ++i) {
            context.drawString(this.mLastBounds.x, this.mLastBounds.y + 1.0 + (double)(size * 5.0f / 6.0f) + (double)(size * 1.4f * (float)i), textList.get(i));
        }
    }

    private GenericRectangle calculateBoundingRect(GenericDrawContext context, ArrayList<String> textList) {
        double maxWidth = 0.0;
        for (String text : textList) {
            double width;
            if (text.length() == 0 || !(maxWidth < (width = context.getBounds(text).getWidth()))) continue;
            maxWidth = width;
        }
        double height = this.mSize * (double)1.4f * (double)(textList.size() - 1) + this.mSize;
        return new GenericRectangle(this.mPoint[0].x, this.mPoint[0].y - this.mSize / 2.0, maxWidth, height);
    }

    @Override
    public GenericRectangle getBoundingRect(GenericDrawContext context) {
        ArrayList<String> textList = this.getTextLineList();
        return this.calculateBoundingRect(context, textList);
    }

    private ArrayList<String> getTextLineList() {
        ArrayList<String> textList = new ArrayList<String>();
        int lineBreak = this.mText.indexOf(10);
        if (lineBreak == -1) {
            textList.add(this.mText);
        } else {
            int textStart = 0;
            while (lineBreak != -1) {
                textList.add(this.mText.substring(textStart, lineBreak));
                textStart = lineBreak + 1;
                lineBreak = this.mText.indexOf(10, textStart);
            }
            textList.add(this.mText.substring(textStart));
        }
        return textList;
    }

    @Override
    public void hilite(GenericDrawContext context) {
        GenericRectangle bounds = this.getBoundingRect(context);
        context.setRGB(context.getSelectionBackgroundRGB());
        context.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public boolean checkHiliting(double x, double y) {
        this.mHilite = this.contains(x, y);
        return this.mHilite;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.mLastBounds != null && this.mLastBounds.contains(x, y);
    }

    @Override
    public void clearHiliting() {
        this.mHilite = false;
    }

    public void setValues(String text, double size, int style) {
        this.mText = text;
        this.mSize = size;
        this.mStyle = style;
    }

    public String getText() {
        return this.mText;
    }

    public double getSize() {
        return this.mSize;
    }

    public int getStyle() {
        return this.mStyle;
    }

    private String encodeText(String source) {
        StringBuffer text = new StringBuffer();
        block6: for (int i = 0; i < source.length(); ++i) {
            switch (source.charAt(i)) {
                case '&': {
                    text.append("&&");
                    continue block6;
                }
                case '\t': {
                    text.append("&09");
                    continue block6;
                }
                case '\n': {
                    text.append("&0A");
                    continue block6;
                }
                case ' ': {
                    text.append("&20");
                    continue block6;
                }
                default: {
                    text.append(source.charAt(i));
                }
            }
        }
        return text.toString();
    }

    private String decodeText(String source) {
        int index = source.indexOf(38);
        if (index == -1) {
            return source;
        }
        int startIndex = 0;
        StringBuffer text = new StringBuffer();
        while (index != -1) {
            text.append(source.substring(startIndex, index));
            if (source.charAt(index + 1) == '&') {
                text.append('&');
                startIndex = index + 2;
            } else {
                int h;
                int l = source.charAt(index + 2);
                text.append((char)(16 * (h -= (h = source.charAt(index + 1)) < 65 ? 48 : (h < 97 ? 65 : 97)) + (l -= l < 65 ? 48 : (l < 97 ? 65 : 97))));
                startIndex = index + 3;
            }
            index = source.indexOf(38, startIndex);
        }
        text.append(source.substring(startIndex));
        return text.toString();
    }
}

