/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.chemicalspaces.synthon;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.MoleculeStandardizer;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SynthonReactor {
    public static final int CONNECTOR_OFFSET = 92;

    public static StereoMolecule react(List<StereoMolecule> synthons) {
        int m_;
        int[] bonds = new int[10];
        ArrayList<int[]> deletionMap = new ArrayList<int[]>();
        ArrayList<int[]> atomMap = new ArrayList<int[]>();
        ArrayList buildingBlocks = new ArrayList();
        synthons.stream().forEach(e -> buildingBlocks.add(new StereoMolecule((Molecule)e)));
        buildingBlocks.forEach(e -> e.ensureHelperArrays(31));
        HashMap<Integer, List> rgrps = new HashMap<Integer, List>();
        for (int m = 0; m < buildingBlocks.size(); ++m) {
            StereoMolecule bb = (StereoMolecule)buildingBlocks.get(m);
            for (int a = 0; a < bb.getAtoms(); ++a) {
                int bondOrder;
                int atomNo = bb.getAtomicNo(a);
                if (atomNo < 92) continue;
                rgrps.putIfAbsent(atomNo - 92 + 1, new ArrayList());
                int connAtom = bb.getConnAtom(a, 0);
                int b = bb.getBond(a, connAtom);
                int upDownIdentifier = bb.getBondAtom(0, b) == a ? -1 : 1;
                int bondType = bb.getBondType(b);
                ((List)rgrps.get(atomNo - 92 + 1)).add(new int[]{m, connAtom, a, upDownIdentifier, bondType});
                bonds[0] = bondOrder = bb.getConnBondOrder(a, 0);
            }
        }
        ArrayList keysToDelete = new ArrayList();
        rgrps.forEach((k, v) -> {
            if (v.size() < 2) {
                keysToDelete.add(k);
            }
        });
        rgrps.keySet().removeAll(keysToDelete);
        rgrps.forEach((k, v) -> {
            ((StereoMolecule)buildingBlocks.get(((int[])v.get(0))[0])).markAtomForDeletion(((int[])v.get(0))[2]);
            ((StereoMolecule)buildingBlocks.get(((int[])v.get(1))[0])).markAtomForDeletion(((int[])v.get(1))[2]);
            int bb1 = ((int[])v.get(0))[0];
            int bb2 = ((int[])v.get(1))[0];
            int u1 = ((int[])v.get(0))[2];
            int u2 = ((int[])v.get(1))[2];
            int a1 = ((int[])v.get(0))[1];
            int a2 = ((int[])v.get(1))[1];
            SynthonReactor.alignSynthons((StereoMolecule)buildingBlocks.get(bb1), (StereoMolecule)buildingBlocks.get(bb2), u1, u2, a1, a2);
        });
        int m = 0;
        while (m < buildingBlocks.size()) {
            StereoMolecule bb = (StereoMolecule)buildingBlocks.get(m);
            int[] map = bb.deleteMarkedAtomsAndBonds();
            deletionMap.add(map);
            m_ = m++;
            rgrps.forEach((k, v) -> v.stream().forEach(e -> {
                if (e[0] == m_) {
                    e[1] = map[e[1]];
                }
            }));
        }
        StereoMolecule product = new StereoMolecule();
        atomMap.add(product.addMolecule((Molecule)buildingBlocks.get(0)));
        int m2 = 1;
        while (m2 < buildingBlocks.size()) {
            int[] map = product.addMolecule((Molecule)buildingBlocks.get(m2));
            atomMap.add(map);
            m_ = m2++;
            rgrps.forEach((k, v) -> v.stream().forEach(e -> {
                if (e[0] == m_) {
                    e[1] = map[e[1]];
                }
            }));
        }
        rgrps.forEach((k, v) -> {
            int atom1 = ((int[])v.get(0))[1];
            int atom2 = ((int[])v.get(1))[1];
            int bondType = ((int[])v.get(0))[4];
            int upDownIdentifier = ((int[])v.get(0))[3];
            int bond = -1;
            bond = upDownIdentifier == 1 ? product.addBond(atom1, atom2) : product.addBond(atom2, atom1);
            product.setBondOrder(bond, bonds[k - 1]);
            product.setBondType(bond, bondType);
        });
        product.ensureHelperArrays(31);
        try {
            MoleculeStandardizer.standardize(product, 0);
            product.ensureHelperArrays(31);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return product;
    }

    private static void alignSynthons(StereoMolecule s1, StereoMolecule s2, int u1, int u2, int a1, int a2) {
        int a;
        Coordinates n;
        Coordinates v1 = s1.getCoordinates(u1).subC(s1.getCoordinates(a1));
        Coordinates v2 = s2.getCoordinates(a2).subC(s2.getCoordinates(u2));
        v1.unit();
        v2.unit();
        double alpha = Math.acos(v1.dot(v2));
        Coordinates cross = v1.cross(v2);
        if (cross.dist() < 0.001) {
            n = new Coordinates(0.0, 0.0, 1.0);
            alpha = Math.PI;
        } else {
            n = cross.unit();
        }
        Coordinates t = s1.getCoordinates(a1).scaleC(-1.0);
        for (a = 0; a < s1.getAtoms(); ++a) {
            s1.getCoordinates(a).add(t);
        }
        t = s2.getCoordinates(u2).scaleC(-1.0);
        for (a = 0; a < s2.getAtoms(); ++a) {
            s2.getCoordinates(a).add(t);
        }
        for (a = 0; a < s2.getAtoms(); ++a) {
            Coordinates newCoords = SynthonReactor.eulerRodrigues(s2.getCoordinates(a), n, -alpha);
            s2.setAtomX(a, newCoords.x);
            s2.setAtomY(a, newCoords.y);
            s2.setAtomZ(a, newCoords.z);
        }
    }

    public static Coordinates eulerRodrigues(Coordinates v, Coordinates k, double theta) {
        Coordinates c1 = v.scaleC(Math.cos(theta));
        Coordinates c2 = k.cross(v).scale(Math.sin(theta));
        Coordinates c3 = k.scaleC(k.dot(v) * (1.0 - Math.cos(theta)));
        Coordinates vNew = c1.addC(c2);
        vNew.add(c3);
        return vNew;
    }
}

