/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.CanonizerBaseValue;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.FragmentAssociation;
import com.actelion.research.chem.coords.InventorAngle;
import com.actelion.research.chem.coords.InventorChain;
import com.actelion.research.chem.coords.InventorCharge;
import com.actelion.research.chem.coords.InventorDefaultTemplateList;
import com.actelion.research.chem.coords.InventorFragment;
import com.actelion.research.chem.coords.InventorTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class CoordinateInventor {
    public static final int MODE_SKIP_DEFAULT_TEMPLATES = 1;
    public static final int MODE_REMOVE_HYDROGEN = 2;
    public static final int MODE_KEEP_MARKED_ATOM_COORDS = 4;
    public static final int MODE_PREFER_MARKED_ATOM_COORDS = 8;
    protected static final int MODE_CONSIDER_MARKED_ATOMS = 12;
    public static final int MODE_DEFAULT = 2;
    private static final byte FLIP_AS_LAST_RESORT = 1;
    private static final byte FLIP_POSSIBLE = 2;
    private static final byte FLIP_PREFERRED = 3;
    private static final int PREFERRED_FLIPS = 32;
    private static final int POSSIBLE_FLIPS = 64;
    private static final int LAST_RESORT_FLIPS = 128;
    private static final int TOTAL_FLIPS = 224;
    private static volatile List<InventorTemplate> sDefaultTemplateList;
    private StereoMolecule mMol;
    private long[] mFFP;
    private Random mRandom;
    private boolean[] mAtomHandled;
    private boolean[] mBondHandled;
    private boolean[] mAtomIsPartOfCustomTemplate;
    private boolean mAbsoluteOrientationTemplateFound;
    private int[] mUnPairedCharge;
    private int mMode;
    private List<InventorFragment> mFragmentList;
    private List<InventorTemplate> mCustomTemplateList;

    private static synchronized void buildDefaultTemplateList() {
        if (sDefaultTemplateList == null) {
            sDefaultTemplateList = new InventorDefaultTemplateList();
        }
    }

    public CoordinateInventor() {
        this(2);
    }

    public CoordinateInventor(int mode) {
        this.mMode = mode;
        if ((mode & 1) == 0 && sDefaultTemplateList == null) {
            CoordinateInventor.buildDefaultTemplateList();
        }
    }

    public void setRandomSeed(long seed) {
        this.mRandom = new Random(seed);
    }

    public void setCustomTemplateList(List<InventorTemplate> templateList) {
        this.mCustomTemplateList = templateList;
        for (InventorTemplate template : templateList) {
            template.normalizeCoordinates();
        }
    }

    public void invent(StereoMolecule mol) {
        this.invent(mol, null);
    }

    public void invent(StereoMolecule mol, long[] ffp) {
        boolean paritiesPresent;
        boolean bl = paritiesPresent = (mol.getHelperArrayStatus() & 0xF) != 0;
        if (this.mRandom == null) {
            this.mRandom = new Random();
        }
        if ((this.mMode & 2) != 0) {
            mol.removeExplicitHydrogens();
        }
        this.mMol = mol;
        this.mMol.ensureHelperArrays(7);
        this.mFFP = ffp;
        this.mFragmentList = new ArrayList<InventorFragment>(){

            @Override
            public boolean add(InventorFragment f) {
                for (InventorFragment ff : this) {
                    if (!ff.equals(f)) continue;
                    return false;
                }
                return super.add(f);
            }
        };
        this.mAtomHandled = new boolean[this.mMol.getAllAtoms()];
        this.mBondHandled = new boolean[this.mMol.getAllBonds()];
        this.mUnPairedCharge = new int[this.mMol.getAllAtoms()];
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            this.mUnPairedCharge[atom] = this.mMol.getAtomCharge(atom);
        }
        if ((this.mMode & 0xC) != 0) {
            this.locateMarkedFragments();
        }
        if (this.mCustomTemplateList != null) {
            this.mAtomIsPartOfCustomTemplate = this.locateTemplateFragments(this.mCustomTemplateList, 512);
        }
        if ((this.mMode & 1) == 0 && sDefaultTemplateList != null) {
            this.locateTemplateFragments(sDefaultTemplateList, 256);
        }
        this.locateInitialFragments();
        this.joinOverlappingFragments();
        this.locateChainFragments();
        this.joinOverlappingFragments();
        for (InventorFragment f : this.mFragmentList) {
            f.locateBonds();
        }
        this.correctChainEZParities();
        this.optimizeFragments();
        this.locateSingleAtoms();
        this.joinMetalBondedFragments();
        this.joinChargedFragments();
        this.joinRemainingFragments();
        for (int i = 0; i < this.mFragmentList.size(); ++i) {
            InventorFragment f;
            f = this.mFragmentList.get(i);
            for (int j = 0; j < f.size(); ++j) {
                this.mMol.setAtomX(f.mGlobalAtom[j], f.mAtomX[j]);
                this.mMol.setAtomY(f.mGlobalAtom[j], f.mAtomY[j]);
                this.mMol.setAtomZ(f.mGlobalAtom[j], 0.0);
            }
        }
        if (paritiesPresent) {
            this.mMol.setStereoBondsFromParity();
        }
        if (this.mAbsoluteOrientationTemplateFound) {
            this.mMol.removeAtomMarkers();
        }
    }

    public boolean[] getCustomTemplateAtomMask() {
        return this.mAtomIsPartOfCustomTemplate;
    }

    private boolean[] locateTemplateFragments(List<InventorTemplate> templateList, int priority) {
        boolean useFFP = this.mFFP != null && templateList.size() != 0 && templateList.get(0).getFFP() != null;
        SSSearcher searcher = null;
        SSSearcherWithIndex searcherWithIndex = null;
        if (useFFP) {
            searcherWithIndex = new SSSearcherWithIndex();
            searcherWithIndex.setMolecule(this.mMol, this.mFFP);
        } else {
            searcher = new SSSearcher();
            searcher.setMolecule(this.mMol);
        }
        boolean[] atomIsPartOfTemplate = new boolean[this.mMol.getAtoms()];
        for (InventorTemplate template : templateList) {
            ArrayList<int[]> matchList = null;
            StereoMolecule templateMol = template.getFragment();
            if (useFFP) {
                searcherWithIndex.setFragment(templateMol, template.getFFP());
                if (searcherWithIndex.findFragmentInMolecule(4, 8) != 0) {
                    matchList = searcherWithIndex.getMatchList();
                }
            } else {
                searcher.setFragment(templateMol);
                if (searcher.findFragmentInMolecule(4, 8) != 0) {
                    matchList = searcher.getMatchList();
                }
            }
            if (matchList == null) continue;
            for (int[] match : matchList) {
                int templateAtomCount = 0;
                for (int atom : match) {
                    if (!atomIsPartOfTemplate[atom]) continue;
                    ++templateAtomCount;
                }
                if (templateAtomCount > true) continue;
                boolean definesAbsoluteOrientation = template.keepAbsoluteOrientation();
                if (this.mAbsoluteOrientationTemplateFound) {
                    definesAbsoluteOrientation = false;
                } else {
                    this.mAbsoluteOrientationTemplateFound = true;
                }
                InventorFragment fragment = new InventorFragment(this.mMol, match.length, definesAbsoluteOrientation);
                for (int i = 0; i < match.length; ++i) {
                    int atom;
                    atom = match[i];
                    if (definesAbsoluteOrientation) {
                        this.mMol.setAtomMarker(atom, true);
                    }
                    fragment.mPriority[i] = priority;
                    fragment.mGlobalAtom[i] = atom;
                    fragment.mAtomX[i] = template.getNormalizedAtomX(i);
                    fragment.mAtomY[i] = template.getNormalizedAtomY(i);
                    atomIsPartOfTemplate[atom] = true;
                    this.mAtomHandled[atom] = true;
                }
                for (int b = 0; b < templateMol.getBonds(); ++b) {
                    this.mBondHandled[this.mMol.getBond((int)match[templateMol.getBondAtom((int)0, (int)b)], (int)match[templateMol.getBondAtom((int)1, (int)b)])] = true;
                }
                this.mFragmentList.add(fragment);
            }
        }
        return atomIsPartOfTemplate;
    }

    private void locateMarkedFragments() {
        int f;
        int atomCount = 0;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (!this.mMol.isMarkedAtom(atom)) continue;
            ++atomCount;
        }
        if (atomCount < 2) {
            return;
        }
        int bondCount = 0;
        double avbl = 0.0;
        for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atom2 = this.mMol.getBondAtom(1, bond);
            if (!this.mMol.isMarkedAtom(atom1) || !this.mMol.isMarkedAtom(atom2)) continue;
            this.mBondHandled[bond] = true;
            this.mAtomHandled[atom1] = true;
            this.mAtomHandled[atom2] = true;
            avbl += this.mMol.getBondLength(bond);
            ++bondCount;
        }
        avbl = bondCount != 0 && avbl != 0.0 ? (avbl /= (double)bondCount) : this.mMol.getAverageBondLength();
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (!this.mMol.isMarkedAtom(atom) || this.mAtomHandled[atom]) continue;
            --atomCount;
        }
        if (atomCount < 2) {
            return;
        }
        int[] fragmentNo = new int[this.mMol.getAllAtoms()];
        int coreFragmentCount = this.mMol.getFragmentNumbers(fragmentNo, true, true);
        int[] fragmentAtomCount = new int[coreFragmentCount];
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (fragmentNo[atom] == -1) continue;
            int n = fragmentNo[atom];
            fragmentAtomCount[n] = fragmentAtomCount[n] + 1;
        }
        InventorFragment[] fragment = new InventorFragment[coreFragmentCount];
        for (int f2 = 0; f2 < coreFragmentCount; ++f2) {
            fragment[f2] = new InventorFragment(this.mMol, fragmentAtomCount[f2], true);
        }
        int[] atomIndex = new int[coreFragmentCount];
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            int f3 = fragmentNo[atom];
            if (f3 == -1) continue;
            fragment[f3].mPriority[atomIndex[f3]] = 1024;
            fragment[f3].mGlobalAtom[atomIndex[f3]] = atom;
            fragment[f3].mAtomX[atomIndex[f3]] = this.mMol.getAtomX(atom) / avbl;
            fragment[f3].mAtomY[atomIndex[f3]] = this.mMol.getAtomY(atom) / avbl;
            int n = f3;
            atomIndex[n] = atomIndex[n] + 1;
        }
        int maxFragment = -1;
        int maxFragmentAtoms = 0;
        for (f = 0; f < coreFragmentCount; ++f) {
            if (maxFragmentAtoms >= fragmentAtomCount[f]) continue;
            maxFragmentAtoms = fragmentAtomCount[f];
            maxFragment = f;
        }
        this.mFragmentList.add(fragment[maxFragment]);
        for (f = 0; f < coreFragmentCount; ++f) {
            if (f == maxFragment) continue;
            this.mFragmentList.add(fragment[f]);
        }
    }

    private void locateInitialFragments() {
        int bond;
        int i;
        int i2;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.getAllConnAtoms(atom) <= 4) continue;
            InventorFragment f = new InventorFragment(this.mMol, 1 + this.mMol.getAllConnAtoms(atom), false);
            f.mAtomX[this.mMol.getAllConnAtoms((int)atom)] = 0.0;
            f.mAtomY[this.mMol.getAllConnAtoms((int)atom)] = 0.0;
            f.mPriority[this.mMol.getAllConnAtoms((int)atom)] = 32;
            f.mGlobalAtom[this.mMol.getAllConnAtoms((int)atom)] = atom;
            this.mAtomHandled[atom] = true;
            for (int i3 = 0; i3 < this.mMol.getAllConnAtoms(atom); ++i3) {
                int connAtom = this.mMol.getConnAtom(atom, i3);
                f.mAtomX[i3] = Math.sin(1.0471975511965976 * (double)i3 - 2.0943951023931953);
                f.mAtomY[i3] = Math.cos(1.0471975511965976 * (double)i3 - 2.0943951023931953);
                f.mPriority[i3] = 32;
                f.mGlobalAtom[i3] = connAtom;
                this.mAtomHandled[connAtom] = true;
                this.mBondHandled[this.mMol.getConnBond((int)atom, (int)i3)] = true;
            }
            this.mFragmentList.add(f);
        }
        RingCollection ringSet = this.mMol.getRingSet();
        for (int ringNo = 0; ringNo < ringSet.getSize(); ++ringNo) {
            int ringSize = ringSet.getRingSize(ringNo);
            int[] ringAtom = ringSet.getRingAtoms(ringNo);
            boolean skipRing = false;
            if ((this.mMode & 0xC) != 0) {
                skipRing = true;
                for (i2 = 0; i2 < ringSize; ++i2) {
                    if (this.mMol.isMarkedAtom(ringAtom[i2])) continue;
                    skipRing = false;
                    break;
                }
            }
            if (skipRing) continue;
            boolean isElementaryRing = false;
            for (int i4 = 0; i4 < ringSize; ++i4) {
                if (this.mMol.getAtomRingSize(ringAtom[i4]) != ringSize) continue;
                isElementaryRing = true;
                break;
            }
            if (!isElementaryRing) continue;
            int[] ringBond = ringSet.getRingBonds(ringNo);
            this.addRingFragment(ringAtom, ringBond);
            for (i = 0; i < ringSize; ++i) {
                this.mAtomHandled[ringAtom[i]] = true;
                this.mBondHandled[ringBond[i]] = true;
            }
        }
        for (bond = 0; bond < this.mMol.getBonds(); ++bond) {
            if (!this.mMol.isRingBond(bond) || this.mBondHandled[bond]) continue;
            InventorChain theRing = this.getSmallestRingFromBond(bond);
            int[] ringAtom = theRing.getRingAtoms();
            int[] ringBond = theRing.getRingBonds();
            this.addRingFragment(ringAtom, ringBond);
            for (i2 = 0; i2 < theRing.getChainLength(); ++i2) {
                this.mAtomHandled[ringAtom[i2]] = true;
                this.mBondHandled[ringBond[i2]] = true;
            }
        }
        for (bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            int connAtom;
            if (this.mBondHandled[bond] || this.mMol.getBondOrder(bond) != 3) continue;
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atom2 = this.mMol.getBondAtom(1, bond);
            int members = this.mMol.getAllConnAtoms(atom1) + this.mMol.getAllConnAtoms(atom2);
            if (members <= 2) continue;
            InventorFragment f = new InventorFragment(this.mMol, members, false);
            int count = 0;
            for (i = 0; i < this.mMol.getAllConnAtoms(atom1); ++i) {
                connAtom = this.mMol.getConnAtom(atom1, i);
                if (connAtom == atom2) continue;
                f.mGlobalAtom[count++] = connAtom;
                this.mAtomHandled[connAtom] = true;
                this.mBondHandled[this.mMol.getConnBond((int)atom1, (int)i)] = true;
            }
            f.mGlobalAtom[count++] = atom1;
            f.mGlobalAtom[count++] = atom2;
            for (i = 0; i < this.mMol.getAllConnAtoms(atom2); ++i) {
                connAtom = this.mMol.getConnAtom(atom2, i);
                if (connAtom == atom1) continue;
                f.mGlobalAtom[count++] = connAtom;
                this.mAtomHandled[connAtom] = true;
                this.mBondHandled[this.mMol.getConnBond((int)atom2, (int)i)] = true;
            }
            for (i = 0; i < members; ++i) {
                f.mAtomX[i] = i;
                f.mAtomY[i] = 0.0;
                f.mPriority[i] = 1;
            }
            this.mAtomHandled[atom1] = true;
            this.mAtomHandled[atom2] = true;
            this.mBondHandled[bond] = true;
            this.mFragmentList.add(f);
        }
        for (bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            if (this.mBondHandled[bond] || this.mMol.getBondOrder(bond) != 2) continue;
            int[] alleneAtom = new int[this.mMol.getAllAtoms()];
            for (int i5 = 0; i5 < 2; ++i5) {
                int connAtom;
                int j;
                alleneAtom[0] = this.mMol.getBondAtom(i5, bond);
                alleneAtom[1] = this.mMol.getBondAtom(1 - i5, bond);
                if (this.mMol.getAtomPi(alleneAtom[0]) != 1 || this.mMol.getAtomPi(alleneAtom[1]) != 2 || this.mMol.getAllConnAtoms(alleneAtom[1]) != 2) continue;
                this.mAtomHandled[alleneAtom[0]] = true;
                this.mAtomHandled[alleneAtom[1]] = true;
                this.mBondHandled[bond] = true;
                int last = 1;
                do {
                    int nextIndex = this.mMol.getConnAtom(alleneAtom[last], 0) == alleneAtom[last - 1] ? 1 : 0;
                    alleneAtom[last + 1] = this.mMol.getConnAtom(alleneAtom[last], nextIndex);
                    if (this.mMol.getAtomPi(alleneAtom[last + 1]) == 2 && this.mMol.getAllConnAtoms(alleneAtom[last + 1]) > 2) break;
                    this.mAtomHandled[alleneAtom[last + 1]] = true;
                    this.mBondHandled[this.mMol.getConnBond((int)alleneAtom[last], (int)nextIndex)] = true;
                } while (this.mMol.getAtomPi(alleneAtom[++last]) == 2 && this.mMol.getAllConnAtoms(alleneAtom[last]) == 2);
                int members = this.mMol.getAllConnAtoms(alleneAtom[0]) + this.mMol.getAllConnAtoms(alleneAtom[last]) + last - 1;
                InventorFragment f = new InventorFragment(this.mMol, members, false);
                for (int j2 = 0; j2 <= last; ++j2) {
                    f.mAtomX[j2] = j2;
                    f.mAtomY[j2] = 0.0;
                    f.mPriority[j2] = 64;
                    f.mGlobalAtom[j2] = alleneAtom[j2];
                }
                int current = last + 1;
                boolean found = false;
                for (j = 0; j < this.mMol.getAllConnAtoms(alleneAtom[0]); ++j) {
                    connAtom = this.mMol.getConnAtom(alleneAtom[0], j);
                    if (connAtom == alleneAtom[1]) continue;
                    f.mAtomX[current] = -0.5;
                    f.mAtomY[current] = found ? Math.sin(1.0471975511965976) : -Math.sin(1.0471975511965976);
                    f.mPriority[current] = 64;
                    f.mGlobalAtom[current] = connAtom;
                    ++current;
                    found = true;
                }
                found = false;
                for (j = 0; j < this.mMol.getAllConnAtoms(alleneAtom[last]); ++j) {
                    connAtom = this.mMol.getConnAtom(alleneAtom[last], j);
                    if (connAtom == alleneAtom[last - 1]) continue;
                    f.mAtomX[current] = (double)last + 0.5;
                    f.mAtomY[current] = found ? -Math.sin(1.0471975511965976) : Math.sin(1.0471975511965976);
                    f.mPriority[current] = 64;
                    f.mGlobalAtom[current] = connAtom;
                    ++current;
                    found = true;
                }
                this.mFragmentList.add(f);
            }
        }
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (this.mMol.getAllConnAtoms(atom) != 4) continue;
            int[] primaryConnAtom = new int[4];
            int[] primaryConnBond = new int[4];
            int primaryConns = 0;
            for (int i6 = 0; i6 < 4; ++i6) {
                primaryConnAtom[primaryConns] = this.mMol.getConnAtom(atom, i6);
                primaryConnBond[primaryConns] = this.mMol.getConnBond(atom, i6);
                if (this.mMol.getAllConnAtoms(primaryConnAtom[primaryConns]) != 1 || this.mBondHandled[primaryConnBond[primaryConns]]) continue;
                ++primaryConns;
            }
            if (primaryConns == 2) {
                InventorFragment f = new InventorFragment(this.mMol, 3, false);
                for (int i7 = 0; i7 < 2; ++i7) {
                    this.mAtomHandled[primaryConnAtom[i7]] = true;
                    this.mBondHandled[primaryConnBond[i7]] = true;
                    f.mGlobalAtom[i7] = primaryConnAtom[i7];
                    f.mPriority[i7] = 32;
                }
                f.mAtomX[0] = -0.5;
                f.mAtomY[0] = 0.866;
                f.mAtomX[1] = 0.5;
                f.mAtomY[1] = 0.866;
                f.mAtomX[2] = 0.0;
                f.mAtomY[2] = 0.0;
                f.mPriority[2] = 32;
                f.mGlobalAtom[2] = atom;
                this.mFragmentList.add(f);
            }
            if (primaryConns != 3) continue;
            for (int i8 = 0; i8 < 2; ++i8) {
                if (this.mMol.getBondOrder(primaryConnBond[i8]) != 1) continue;
                int temp = primaryConnAtom[i8];
                primaryConnAtom[i8] = primaryConnAtom[2];
                primaryConnAtom[2] = temp;
                temp = primaryConnBond[i8];
                primaryConnBond[i8] = primaryConnBond[2];
                primaryConnBond[2] = temp;
            }
            InventorFragment f = new InventorFragment(this.mMol, 4, false);
            for (int i9 = 0; i9 < 3; ++i9) {
                this.mAtomHandled[primaryConnAtom[i9]] = true;
                this.mBondHandled[primaryConnBond[i9]] = true;
                f.mGlobalAtom[i9] = primaryConnAtom[i9];
                f.mPriority[i9] = 32;
            }
            f.mAtomX[0] = -1.0;
            f.mAtomY[0] = 0.0;
            f.mAtomX[1] = 1.0;
            f.mAtomY[1] = 0.0;
            f.mAtomX[2] = 0.0;
            f.mAtomY[2] = 1.0;
            f.mAtomX[3] = 0.0;
            f.mAtomY[3] = 0.0;
            f.mPriority[3] = 32;
            f.mGlobalAtom[3] = atom;
            this.mFragmentList.add(f);
        }
    }

    private void locateChainFragments() {
        while (true) {
            InventorChain longestChain = null;
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                int unhandledBonds = 0;
                for (int i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
                    if (this.mBondHandled[this.mMol.getConnBond(atom, i)]) continue;
                    ++unhandledBonds;
                }
                if (unhandledBonds != true) continue;
                InventorChain theChain = this.getLongestUnhandledChain(atom);
                if (longestChain != null && theChain.getChainLength() <= longestChain.getChainLength()) continue;
                longestChain = theChain;
            }
            if (longestChain == null) break;
            InventorFragment f = new InventorFragment(this.mMol, longestChain.getChainLength(), false);
            for (int i = 0; i < longestChain.getChainLength(); ++i) {
                this.mAtomHandled[longestChain.mAtom[i]] = true;
                if (i < longestChain.getChainLength() - 1) {
                    this.mBondHandled[longestChain.mBond[i]] = true;
                }
                f.mGlobalAtom[i] = longestChain.mAtom[i];
                f.mAtomX[i] = Math.cos(0.5235987755982988) * (double)i;
                f.mAtomY[i] = (i & 1) == 1 ? 0.0 : 0.5;
                f.mPriority[i] = 128 + longestChain.getChainLength();
            }
            this.mFragmentList.add(f);
        }
    }

    private void locateSingleAtoms() {
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (this.mAtomHandled[atom] || this.mMol.getAllConnAtoms(atom) != 0) continue;
            InventorFragment f = new InventorFragment(this.mMol, 1, false);
            this.mAtomHandled[atom] = true;
            f.mGlobalAtom[0] = atom;
            f.mAtomX[0] = 0.0;
            f.mAtomY[0] = 0.0;
            f.mPriority[0] = 0;
            this.mFragmentList.add(f);
        }
    }

    private void addRingFragment(int[] ringAtom, int[] ringBond) {
        int ringSize = ringAtom.length;
        InventorFragment f = new InventorFragment(this.mMol, ringSize, false);
        f.mAtomX[0] = 0.0;
        f.mAtomY[0] = 0.0;
        for (int i = 0; i < ringSize; ++i) {
            f.mPriority[i] = 128 - ringSize;
            f.mGlobalAtom[i] = ringAtom[i];
        }
        if (ringSize < 8) {
            this.createRegularRingFragment(f);
        } else {
            this.createLargeRingFragment(f, ringAtom, ringBond);
        }
        this.mFragmentList.add(f);
    }

    private void createRegularRingFragment(InventorFragment f) {
        double angleChange = Math.PI - Math.PI * (double)(f.size() - 2) / (double)f.size();
        for (int i = 1; i < f.size(); ++i) {
            f.mAtomX[i] = f.mAtomX[i - 1] + Math.sin(angleChange * (double)(i - 1));
            f.mAtomY[i] = f.mAtomY[i - 1] + Math.cos(angleChange * (double)(i - 1));
        }
    }

    private void createRegularRingFragment(InventorFragment f, int bondEConstraint, int bondZConstraint) {
        if (bondEConstraint == 0 || (bondEConstraint & bondZConstraint) != 0) {
            this.createRegularRingFragment(f);
            return;
        }
        int startIndex = -1;
        int startPriority = 0;
        int bitMinus2 = 1 << f.size() - 2;
        int bitMinus1 = 1 << f.size() - 1;
        int currentBit = 1;
        int bitPlus1 = 2;
        for (int i = 0; i < f.size(); ++i) {
            if ((bondZConstraint & (bitMinus1 | currentBit)) == 0 && (bondEConstraint & (bitMinus1 | currentBit)) != 0 && (bondEConstraint & bitMinus2) == 0) {
                int priority = 0;
                if ((bondZConstraint & bitMinus2) != 0) {
                    priority += 4;
                }
                if ((bondEConstraint & bitMinus1) != 0) {
                    priority += 2;
                }
                if ((bondEConstraint & currentBit) != 0) {
                    ++priority;
                }
                if (startPriority < priority) {
                    startPriority = priority;
                    startIndex = i;
                }
            }
            bitMinus2 = bitMinus1;
            bitMinus1 = currentBit;
            currentBit = bitPlus1;
            bitPlus1 = 1 << (i + 2 < f.size() ? i + 2 : i + 2 - f.size());
        }
        if (startIndex == -1) {
            this.createRegularRingFragment(f);
            return;
        }
        int moveToCenter = 0;
        moveToCenter |= 1 << startIndex;
        int offset = 2;
        while (offset < f.size() - 1) {
            int index = startIndex + offset < f.size() ? startIndex + offset : startIndex + offset - f.size();
            bitMinus1 = 1 << (index == 0 ? f.size() - 1 : index - 1);
            if ((bondZConstraint & bitMinus1) != 0) {
                ++offset;
                continue;
            }
            currentBit = 1 << index;
            if ((bondEConstraint & bitMinus1) != 0) {
                if ((bondZConstraint & currentBit) != 0) {
                    this.createRegularRingFragment(f);
                    return;
                }
                moveToCenter |= currentBit;
                offset += 2;
                continue;
            }
            bitPlus1 = 1 << (index + 1 < f.size() ? index + 1 : index + 1 - f.size());
            if ((bondEConstraint & currentBit) != 0 && (bondZConstraint & bitPlus1) != 0) {
                moveToCenter |= currentBit;
                offset += 3;
                continue;
            }
            ++offset;
        }
        if (moveToCenter == 0) {
            this.createRegularRingFragment(f);
            return;
        }
        double angleChange = Math.PI - Math.PI * (double)(f.size() - 2) / (double)f.size();
        for (int i = 1; i < f.size(); ++i) {
            f.mAtomX[i] = f.mAtomX[i - 1] + Math.sin(angleChange * (double)(i - 1));
            f.mAtomY[i] = f.mAtomY[i - 1] + Math.cos(angleChange * (double)(i - 1));
        }
        currentBit = 1;
        double shift = 2.0 * Math.sin(angleChange / 2.0);
        for (int i = 0; i < f.size(); ++i) {
            if ((moveToCenter & currentBit) != 0) {
                int n = i;
                f.mAtomX[n] = f.mAtomX[n] + shift * Math.cos(angleChange * ((double)i - 0.5));
                int n2 = i;
                f.mAtomY[n2] = f.mAtomY[n2] - shift * Math.sin(angleChange * ((double)i - 0.5));
            }
            currentBit <<= 1;
        }
    }

    private void createLargeRingFragment(InventorFragment f, int[] ringAtom, int[] ringBond) {
        int FIRST_RING_SIZE = 9;
        int LAST_RING_SIZE = 25;
        double[][] cAngleCorrection = new double[][]{{20.0}, null, null, {0.0, 10.0}, null, null, {-4.0, 12.0}, {0.0, 0.0, -7.5}, null, null, null, null, {8.0, -8.0}, null, null, null, {-2.4}};
        int[][] cBondZList = new int[][]{{146}, {627}, null, {2457, 1170}, null, {2451, 8643, 2519}, {9362, 14798}, {34377, -2147448999, 26214}, null, {37449, 137313, 95703, 34371, 37815, 54891, 132867, -2147309741, 54857, 55129, -2147449005, -2147449065}, null, {530697, 531819, 899169, 137289, 694617, -2146951863, -2146952797, -2146939175, -2146929547, -2146929564, -2146625111, -2146931799, -2146940503, -2146931935}, {1007293, 610915}, {542985, 137283, 2122017, 530691, 2206773, -2144711351, 219209, 2840841, 137555, -2146871031, -2147264167, 613705, -2145360543, -2146625271, 694611, 2454837, -2145356703, -2147345133, -2146928951, -2146931805, -2144641719, -2146951869, -2146625237, -2146624183, 2841963, 1074905, -2146625117, 2799955, -2144723645, 138583, 859225, -2145264843, -2145216253, -2146624149, -2144700727, -2146928917, -2143905527, -2144045771, -2146789097, 2288547, 544407, 2104323, -2146911977, -2144479405, 3633737, -2146870089, -2146952169}, null, {0x818181, 2172633, 2116611, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8829813}, {14071213}};
        int maxBit = 1 << f.size();
        int bondEConstraint = 0;
        int bondZConstraint = 0;
        if (f.size() > 7) {
            for (int i = 0; i < f.size(); ++i) {
                int bondParity = this.getLargeRingBondParity(ringAtom, ringBond, i);
                if (bondParity == 1) {
                    bondEConstraint += maxBit;
                } else if (bondParity == 2) {
                    bondZConstraint += maxBit;
                }
                bondEConstraint >>>= 1;
                bondZConstraint >>>= 1;
            }
        }
        int ringIndex = f.size() - 9;
        if (f.size() >= 9 && f.size() <= 25 && cBondZList[ringIndex] != null) {
            block1: for (int zList = 0; zList < cBondZList[ringIndex].length; ++zList) {
                boolean isSymmetrical = (Integer.MIN_VALUE & cBondZList[ringIndex][zList]) == 0;
                int bondZList = Integer.MAX_VALUE & cBondZList[ringIndex][zList];
                boolean inverted = false;
                while (!inverted) {
                    if (inverted) {
                        if (isSymmetrical) continue block1;
                        int newBondZList = 0;
                        for (int bit = 1; bit != maxBit; bit <<= 1) {
                            newBondZList <<= 1;
                            if ((bondZList & bit) == 0) continue;
                            newBondZList |= 1;
                        }
                        bondZList = newBondZList;
                    }
                    for (int rotation = 0; rotation < f.size(); ++rotation) {
                        if ((bondZList & bondEConstraint) == 0 && (~bondZList & bondZConstraint) == 0) {
                            double bondAngle = 0.0;
                            double correction = Math.PI / 180 * (cAngleCorrection[ringIndex] == null ? 0.0 : cAngleCorrection[ringIndex][zList]);
                            int rightTurns = 0;
                            int tempZList = bondZList;
                            boolean isRightTurn = true;
                            for (int i = 0; i < f.size(); ++i) {
                                if (isRightTurn) {
                                    ++rightTurns;
                                }
                                if ((tempZList & 1) == 0) {
                                    isRightTurn = !isRightTurn;
                                }
                                tempZList >>>= 1;
                            }
                            boolean wasRightTurn = rightTurns > f.size() / 2;
                            for (int i = 1; i < f.size(); ++i) {
                                f.mAtomX[i] = f.mAtomX[i - 1] + Math.sin(bondAngle);
                                f.mAtomY[i] = f.mAtomY[i - 1] + Math.cos(bondAngle);
                                if ((bondZList & 1) == 0) {
                                    wasRightTurn = !wasRightTurn;
                                }
                                bondAngle += correction + (wasRightTurn ? 1.0471975511965976 : -1.0471975511965976);
                                bondZList >>>= 1;
                            }
                            return;
                        }
                        if ((bondZList & 1) != 0) {
                            bondZList |= maxBit;
                        }
                        bondZList >>>= 1;
                    }
                    inverted = !inverted;
                }
            }
        }
        this.createRegularRingFragment(f, bondEConstraint, bondZConstraint);
    }

    private int getLargeRingBondParity(int[] ringAtom, int[] ringBond, int index) {
        int bondParity;
        int highestIndex;
        int higherIndex = index == ringAtom.length - 1 ? 0 : index + 1;
        int lowerIndex = index == 0 ? ringAtom.length - 1 : index - 1;
        int n = highestIndex = higherIndex == ringAtom.length - 1 ? 0 : higherIndex + 1;
        if (this.mMol.getBondOrder(ringBond[index]) == 2 && ((bondParity = this.mMol.getBondParity(ringBond[index])) == 1 || bondParity == 2)) {
            if (this.isLowestIndexNeighbour(ringAtom[lowerIndex], ringAtom[index], ringAtom[higherIndex]) ^ this.isLowestIndexNeighbour(ringAtom[highestIndex], ringAtom[higherIndex], ringAtom[index])) {
                bondParity = bondParity == 1 ? 2 : 1;
            }
            return bondParity;
        }
        if (this.mMol.isSmallRingBond(ringBond[index])) {
            int sharedRing1 = this.mMol.getRingSet().getSharedRing(ringBond[lowerIndex], ringBond[index]);
            int sharedRing2 = this.mMol.getRingSet().getSharedRing(ringBond[higherIndex], ringBond[index]);
            if (sharedRing1 != -1 || sharedRing2 != -1) {
                return sharedRing1 == sharedRing2 ? 2 : 1;
            }
        }
        return 0;
    }

    private boolean isLowestIndexNeighbour(int atom, int rootAtom, int excludeAtom) {
        for (int i = 0; i < this.mMol.getConnAtoms(rootAtom); ++i) {
            int connAtom = this.mMol.getConnAtom(rootAtom, i);
            if (connAtom == excludeAtom || connAtom >= atom) continue;
            return false;
        }
        return true;
    }

    private InventorChain getSmallestRingFromBond(int bond) {
        int atom1 = this.mMol.getBondAtom(0, bond);
        int atom2 = this.mMol.getBondAtom(1, bond);
        int[] graphAtom = new int[this.mMol.getAllAtoms()];
        int[] graphBond = new int[this.mMol.getAllAtoms()];
        int[] graphLevel = new int[this.mMol.getAllAtoms()];
        int[] graphParent = new int[this.mMol.getAllAtoms()];
        graphAtom[0] = atom1;
        graphAtom[1] = atom2;
        graphBond[1] = bond;
        graphLevel[atom1] = 1;
        graphLevel[atom2] = 2;
        graphParent[0] = -1;
        graphParent[1] = 0;
        int highest = 1;
        for (int current = 1; current <= highest; ++current) {
            for (int i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                if (current > 1 && candidate == atom1) {
                    InventorChain theRing = new InventorChain(graphLevel[graphAtom[current]]);
                    graphBond[0] = this.mMol.getConnBond(graphAtom[current], i);
                    int index = current;
                    for (int j = 0; j < theRing.getChainLength(); ++j) {
                        theRing.mAtom[j] = graphAtom[index];
                        theRing.mBond[j] = graphBond[index];
                        index = graphParent[index];
                    }
                    return theRing;
                }
                if (graphLevel[candidate] != 0 || !this.mMol.isRingAtom(candidate)) continue;
                graphAtom[++highest] = candidate;
                graphBond[highest] = this.mMol.getConnBond(graphAtom[current], i);
                graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
                graphParent[highest] = current;
            }
        }
        return null;
    }

    private int getSmallestRingSize(int atom1, int atom2, int atom3) {
        int[] graphAtom = new int[this.mMol.getAllAtoms()];
        int[] graphLevel = new int[this.mMol.getAllAtoms()];
        graphAtom[0] = atom2;
        graphAtom[1] = atom1;
        graphLevel[atom2] = 1;
        graphLevel[atom1] = 2;
        int highest = 1;
        for (int current = 1; current <= highest; ++current) {
            for (int i = 0; i < this.mMol.getConnAtoms(graphAtom[current]); ++i) {
                int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                if (candidate == atom3) {
                    return 1 + graphLevel[graphAtom[current]];
                }
                if (graphLevel[candidate] != 0 || !this.mMol.isRingAtom(candidate)) continue;
                graphAtom[++highest] = candidate;
                graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
            }
        }
        return 0;
    }

    private void joinOverlappingFragments() {
        while (true) {
            int maxJoinPriority = 0;
            int maxCommonAtoms = 0;
            InventorFragment maxFragment1 = null;
            InventorFragment maxFragment2 = null;
            for (int i = 1; i < this.mFragmentList.size(); ++i) {
                InventorFragment f1 = this.mFragmentList.get(i);
                for (int j = 0; j < i; ++j) {
                    int k;
                    InventorFragment f2 = this.mFragmentList.get(j);
                    int commonAtom = 0;
                    int commonAtoms = 0;
                    int maxF1Priority = 0;
                    int maxF2Priority = 0;
                    for (int k2 = 0; k2 < f1.size(); ++k2) {
                        for (int l = 0; l < f2.size(); ++l) {
                            if (f1.mGlobalAtom[k2] != f2.mGlobalAtom[l]) continue;
                            ++commonAtoms;
                            commonAtom = f1.mGlobalAtom[k2];
                            if (maxF1Priority < f1.mPriority[k2]) {
                                maxF1Priority = f1.mPriority[k2];
                            }
                            if (maxF2Priority >= f2.mPriority[l]) continue;
                            maxF2Priority = f2.mPriority[l];
                        }
                    }
                    if (commonAtoms <= 0) continue;
                    int handlePreferred = commonAtoms == 1 && this.getConnAtoms(f1, commonAtom) == 1 && this.getConnAtoms(f2, commonAtom) == 1 ? 0 : 1;
                    int joinPriority = maxF1Priority > maxF2Priority ? (handlePreferred << 24) + (maxF1Priority << 16) + (maxF2Priority << 8) + commonAtoms : (handlePreferred << 24) + (maxF2Priority << 16) + (maxF1Priority << 8) + commonAtoms;
                    if (maxJoinPriority >= joinPriority) continue;
                    maxJoinPriority = joinPriority;
                    maxCommonAtoms = commonAtoms;
                    maxF1Priority = 0;
                    maxF2Priority = 0;
                    for (k = 0; k < f1.size(); ++k) {
                        if (maxF1Priority >= f1.mPriority[k]) continue;
                        maxF1Priority = f1.mPriority[k];
                    }
                    for (k = 0; k < f2.size(); ++k) {
                        if (maxF2Priority >= f2.mPriority[k]) continue;
                        maxF2Priority = f2.mPriority[k];
                    }
                    if (maxF1Priority > maxF2Priority) {
                        maxFragment1 = f1;
                        maxFragment2 = f2;
                        continue;
                    }
                    maxFragment1 = f2;
                    maxFragment2 = f1;
                }
            }
            if (maxJoinPriority == 0) break;
            if (maxCommonAtoms == maxFragment1.size()) {
                this.mFragmentList.remove(maxFragment1);
                continue;
            }
            if (maxCommonAtoms == maxFragment2.size()) {
                this.mFragmentList.remove(maxFragment2);
                continue;
            }
            this.joinFragments(maxFragment1, maxFragment2, maxCommonAtoms);
        }
    }

    private void joinFragments(InventorFragment f1, InventorFragment f2, int commonAtoms) {
        int[] commonAtom = new int[commonAtoms];
        int count = 0;
        for (int i = 0; i < f1.mGlobalAtom.length; ++i) {
            for (int j = 0; j < f2.mGlobalAtom.length; ++j) {
                if (f1.mGlobalAtom[i] != f2.mGlobalAtom[j]) continue;
                commonAtom[count++] = f1.mGlobalAtom[i];
            }
        }
        InventorFragment joinedFragment = commonAtoms == 1 ? this.getFusedFragment(f1, f2, commonAtom[0]) : this.getFusedFragment(f1, f2, commonAtom, commonAtoms);
        this.updateFragmentList(f1, f2, joinedFragment);
    }

    private InventorFragment getFusedFragment(InventorFragment f1, InventorFragment f2, int commonAtom) {
        int index1 = f1.getLocalAtom(commonAtom);
        int index2 = f2.getLocalAtom(commonAtom);
        f2.translate(f1.mAtomX[index1] - f2.mAtomX[index2], f1.mAtomY[index1] - f2.mAtomY[index2]);
        double angle1 = this.suggestNewBondAngle(f1, commonAtom);
        double angle2 = this.suggestNewBondAngle(f2, commonAtom);
        double angleInc = 0.0;
        if (this.getConnAtoms(f1, commonAtom) == 1 && this.getConnAtoms(f2, commonAtom) == 1) {
            angleInc = 1.0471975511965976;
        }
        f2.rotate(f2.mAtomX[index2], f2.mAtomY[index2], angle1 - angle2 + angleInc + Math.PI);
        return this.getMergedFragment(f1, f2, 1);
    }

    private InventorFragment getFusedFragment(InventorFragment f1, InventorFragment f2, int[] commonAtom, int commonAtoms) {
        int[] index1 = new int[commonAtoms];
        int[] index2 = new int[commonAtoms];
        for (int i = 0; i < commonAtoms; ++i) {
            index1[i] = f1.getLocalAtom(commonAtom[i]);
            index2[i] = f2.getLocalAtom(commonAtom[i]);
        }
        double meanX1 = 0.0;
        double meanY1 = 0.0;
        double meanX2 = 0.0;
        double meanY2 = 0.0;
        for (int i = 0; i < commonAtoms; ++i) {
            meanX1 += f1.mAtomX[index1[i]];
            meanY1 += f1.mAtomY[index1[i]];
            meanX2 += f2.mAtomX[index2[i]];
            meanY2 += f2.mAtomY[index2[i]];
        }
        f2.translate((meanX1 /= (double)commonAtoms) - (meanX2 /= (double)commonAtoms), (meanY1 /= (double)commonAtoms) - (meanY2 /= (double)commonAtoms));
        InventorAngle[] f1Angle = new InventorAngle[commonAtoms];
        InventorAngle[] f2Angle = new InventorAngle[commonAtoms];
        InventorAngle[] angleDif = new InventorAngle[commonAtoms];
        InventorAngle[] angleDifFlip = new InventorAngle[commonAtoms];
        for (int i = 0; i < commonAtoms; ++i) {
            f1Angle[i] = new InventorAngle(meanX1, meanY1, f1.mAtomX[index1[i]], f1.mAtomY[index1[i]]);
            f2Angle[i] = new InventorAngle(meanX1, meanY1, f2.mAtomX[index2[i]], f2.mAtomY[index2[i]]);
            angleDif[i] = new InventorAngle(f1Angle[i].mAngle - f2Angle[i].mAngle, f1Angle[i].mLength * f2Angle[i].mLength);
            angleDifFlip[i] = new InventorAngle(f1Angle[i].mAngle + f2Angle[i].mAngle, f1Angle[i].mLength * f2Angle[i].mLength);
        }
        InventorAngle meanAngleDif = CoordinateInventor.getMeanAngle(angleDif, commonAtoms);
        InventorAngle meanAngleDifFlip = CoordinateInventor.getMeanAngle(angleDifFlip, commonAtoms);
        int neighbourCountF1 = 0;
        int neighbourCountF2 = 0;
        for (int i = 0; i < commonAtoms; ++i) {
            for (int j = 0; j < this.mMol.getAllConnAtoms(commonAtom[i]); ++j) {
                int connAtom = this.mMol.getConnAtom(commonAtom[i], j);
                if (f1.isMember(connAtom) && !f2.isMember(connAtom)) {
                    ++neighbourCountF1;
                }
                if (f1.isMember(connAtom) || !f2.isMember(connAtom)) continue;
                ++neighbourCountF2;
            }
        }
        InventorAngle[] f1NeighbourAngle = new InventorAngle[neighbourCountF1];
        InventorAngle[] f2NeighbourAngle = new InventorAngle[neighbourCountF2];
        InventorAngle[] f2NeighbourAngleFlip = new InventorAngle[neighbourCountF2];
        neighbourCountF1 = 0;
        neighbourCountF2 = 0;
        for (int i = 0; i < commonAtoms; ++i) {
            for (int j = 0; j < this.mMol.getAllConnAtoms(commonAtom[i]); ++j) {
                int connIndex;
                int connAtom = this.mMol.getConnAtom(commonAtom[i], j);
                if (f1.isMember(connAtom) && !f2.isMember(connAtom)) {
                    connIndex = f1.getLocalAtom(connAtom);
                    f1NeighbourAngle[neighbourCountF1] = new InventorAngle(f1.mAtomX[index1[i]], f1.mAtomY[index1[i]], f1.mAtomX[connIndex], f1.mAtomY[connIndex]);
                    ++neighbourCountF1;
                }
                if (f1.isMember(connAtom) || !f2.isMember(connAtom)) continue;
                connIndex = f2.getLocalAtom(connAtom);
                InventorAngle neighbourAngle = new InventorAngle(f2.mAtomX[index2[i]], f2.mAtomY[index2[i]], f2.mAtomX[connIndex], f2.mAtomY[connIndex]);
                f2NeighbourAngle[neighbourCountF2] = new InventorAngle(meanAngleDif.mAngle + neighbourAngle.mAngle, neighbourAngle.mLength);
                f2NeighbourAngleFlip[neighbourCountF2] = new InventorAngle(meanAngleDifFlip.mAngle - neighbourAngle.mAngle, neighbourAngle.mLength);
                ++neighbourCountF2;
            }
        }
        InventorAngle meanNeighbourAngleF1 = CoordinateInventor.getMeanAngle(f1NeighbourAngle, neighbourCountF1);
        InventorAngle meanNeighbourAngleF2 = CoordinateInventor.getMeanAngle(f2NeighbourAngle, neighbourCountF2);
        InventorAngle meanNeighbourAngleF2Flip = CoordinateInventor.getMeanAngle(f2NeighbourAngleFlip, neighbourCountF2);
        if (Math.abs(this.getAngleDif(meanNeighbourAngleF1.mAngle, meanNeighbourAngleF2.mAngle)) > Math.abs(this.getAngleDif(meanNeighbourAngleF1.mAngle, meanNeighbourAngleF2Flip.mAngle))) {
            f2.rotate(meanX1, meanY1, meanAngleDif.mAngle);
        } else {
            f2.flip(meanX1, meanY1, 0.0);
            f2.rotate(meanX1, meanY1, meanAngleDifFlip.mAngle);
        }
        return this.getMergedFragment(f1, f2, commonAtoms);
    }

    private InventorFragment getMergedFragment(InventorFragment f1, InventorFragment f2, int commonAtoms) {
        int i;
        InventorFragment f = new InventorFragment(this.mMol, f1.mGlobalAtom.length + f2.mGlobalAtom.length - commonAtoms, f1.mKeepMarkedAtoms | f2.mKeepMarkedAtoms);
        int count = 0;
        for (i = 0; i < f1.mGlobalAtom.length; ++i) {
            f.mGlobalAtom[count] = f1.mGlobalAtom[i];
            f.mPriority[count] = f1.mPriority[i];
            f.mAtomX[count] = f1.mAtomX[i];
            f.mAtomY[count++] = f1.mAtomY[i];
        }
        for (i = 0; i < f2.mGlobalAtom.length; ++i) {
            int index = f1.getLocalAtom(f2.mGlobalAtom[i]);
            if (index == -1) {
                f.mGlobalAtom[count] = f2.mGlobalAtom[i];
                f.mPriority[count] = f2.mPriority[i];
                f.mAtomX[count] = f2.mAtomX[i];
                f.mAtomY[count++] = f2.mAtomY[i];
                continue;
            }
            if (f.mPriority[index] >= f2.mPriority[i]) continue;
            f.mPriority[index] = f2.mPriority[i];
            f.mAtomX[index] = f2.mAtomX[i];
            f.mAtomY[index] = f2.mAtomY[i];
        }
        return f;
    }

    private InventorChain getLongestUnhandledChain(int atom) {
        int[] graphAtom = new int[this.mMol.getAllAtoms()];
        int[] graphBond = new int[this.mMol.getAllAtoms()];
        int[] graphLevel = new int[this.mMol.getAllAtoms()];
        int[] graphParent = new int[this.mMol.getAllAtoms()];
        graphAtom[0] = atom;
        graphLevel[atom] = 1;
        graphParent[0] = -1;
        int highest = 0;
        for (int current = 0; current <= highest; ++current) {
            if (current == 0 || !this.mAtomHandled[graphAtom[current]]) {
                for (int i = 0; i < this.mMol.getAllConnAtoms(graphAtom[current]); ++i) {
                    int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                    int theBond = this.mMol.getConnBond(graphAtom[current], i);
                    if (graphLevel[candidate] != 0 || this.mBondHandled[theBond]) continue;
                    graphAtom[++highest] = candidate;
                    graphBond[highest] = theBond;
                    graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
                    graphParent[highest] = current;
                }
            }
            if (current != highest) continue;
            InventorChain theChain = new InventorChain(graphLevel[graphAtom[current]]);
            int index = current;
            for (int j = 0; j < theChain.getChainLength(); ++j) {
                theChain.mAtom[j] = graphAtom[index];
                theChain.mBond[j] = graphBond[index];
                index = graphParent[index];
            }
            return theChain;
        }
        return null;
    }

    private double suggestNewBondAngle(InventorFragment f, int atom) {
        int i;
        double[] connAngle = new double[this.mMol.getAllConnAtoms(atom) + 1];
        int[] connAtom = new int[this.mMol.getAllConnAtoms(atom) + 1];
        int[] connBond = new int[this.mMol.getAllConnAtoms(atom) + 1];
        int rootIndex = f.getLocalAtom(atom);
        int connAngles = 0;
        for (i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
            connAtom[connAngles] = this.mMol.getConnAtom(atom, i);
            connBond[connAngles] = this.mMol.getConnBond(atom, i);
            int index = f.getLocalAtom(connAtom[connAngles]);
            if (index == -1) continue;
            connAngle[connAngles++] = InventorAngle.getAngle(f.mAtomX[rootIndex], f.mAtomY[rootIndex], f.mAtomX[index], f.mAtomY[index]);
        }
        if (connAngles == 1) {
            return connAngle[0] + Math.PI;
        }
        for (i = connAngles - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (!(connAngle[j] > connAngle[j + 1])) continue;
                double tempAngle = connAngle[j];
                connAngle[j] = connAngle[j + 1];
                connAngle[j + 1] = tempAngle;
                int tempAtom = connAtom[j];
                connAtom[j] = connAtom[j + 1];
                connAtom[j + 1] = tempAtom;
                int tempBond = connBond[j];
                connBond[j] = connBond[j + 1];
                connBond[j + 1] = tempBond;
            }
        }
        connAngle[connAngles] = connAngle[0] + Math.PI * 2;
        connAtom[connAngles] = connAtom[0];
        connBond[connAngles] = connBond[0];
        double maxAngleDif = -100.0;
        int maxIndex = 0;
        for (int i2 = 0; i2 < connAngles; ++i2) {
            int ringSize;
            double angleDif = connAngle[i2 + 1] - connAngle[i2];
            if (connAngles > 2 && this.mMol.isRingBond(connBond[i2]) && this.mMol.isRingBond(connBond[i2 + 1]) && (ringSize = this.getSmallestRingSize(connAtom[i2], atom, connAtom[i2 + 1])) != 0) {
                angleDif -= 100.0 - (double)ringSize;
            }
            if (!(maxAngleDif < angleDif)) continue;
            maxAngleDif = angleDif;
            maxIndex = i2;
        }
        return (connAngle[maxIndex] + connAngle[maxIndex + 1]) / 2.0;
    }

    private double getAngleDif(double angle1, double angle2) {
        double angleDif;
        for (angleDif = angle1 - angle2; angleDif < -Math.PI; angleDif += Math.PI * 2) {
        }
        while (angleDif > Math.PI) {
            angleDif -= Math.PI * 2;
        }
        return angleDif;
    }

    protected static InventorAngle getMeanAngle(InventorAngle[] angle, int noOfAngles) {
        double meanAngle;
        double sinSum = 0.0;
        double cosSum = 0.0;
        for (int i = 0; i < noOfAngles; ++i) {
            sinSum += angle[i].mLength * Math.sin(angle[i].mAngle);
            cosSum += angle[i].mLength * Math.cos(angle[i].mAngle);
        }
        if (cosSum == 0.0) {
            meanAngle = sinSum > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            meanAngle = Math.atan(sinSum / cosSum);
            if (cosSum < 0.0) {
                meanAngle += Math.PI;
            }
        }
        double length = Math.sqrt(sinSum * sinSum + cosSum * cosSum) / (double)noOfAngles;
        return new InventorAngle(meanAngle, length);
    }

    private int getConnAtoms(InventorFragment f, int atom) {
        int connAtoms = 0;
        for (int i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
            if (!f.isMember(this.mMol.getConnAtom(atom, i))) continue;
            ++connAtoms;
        }
        return connAtoms;
    }

    private void correctChainEZParities() {
        for (int fragmentNo = 0; fragmentNo < this.mFragmentList.size(); ++fragmentNo) {
            InventorFragment f = this.mFragmentList.get(fragmentNo);
            for (int i = 0; i < f.mGlobalBond.length; ++i) {
                int bond = f.mGlobalBond[i];
                if (this.mMol.getBondOrder(bond) != 2) continue;
                if (!(this.mMol.isSmallRingBond(bond) || this.mMol.getBondParity(bond) != 3 && this.mMol.getBondParity(bond) != 0)) {
                    this.mMol.setBondParityUnknownOrNone(bond);
                }
                if (this.mMol.isRingBond(bond) || this.mMol.getConnAtoms(this.mMol.getBondAtom(0, bond)) <= 1 || this.mMol.getConnAtoms(this.mMol.getBondAtom(1, bond)) <= 1 || this.mMol.getBondParity(bond) != 1 && this.mMol.getBondParity(bond) != 2) continue;
                int[] minConnAtom = new int[2];
                int[] bondAtom = new int[2];
                for (int j = 0; j < 2; ++j) {
                    minConnAtom[j] = this.mMol.getMaxAtoms();
                    bondAtom[j] = this.mMol.getBondAtom(j, bond);
                    for (int k = 0; k < this.mMol.getAllConnAtoms(bondAtom[j]); ++k) {
                        int connAtom = this.mMol.getConnAtom(bondAtom[j], k);
                        if (connAtom == this.mMol.getBondAtom(1 - j, bond) || minConnAtom[j] <= connAtom) continue;
                        minConnAtom[j] = connAtom;
                    }
                }
                double dbAngle = InventorAngle.getAngle(f.mAtomX[f.mGlobalToLocalAtom[bondAtom[0]]], f.mAtomY[f.mGlobalToLocalAtom[bondAtom[0]]], f.mAtomX[f.mGlobalToLocalAtom[bondAtom[1]]], f.mAtomY[f.mGlobalToLocalAtom[bondAtom[1]]]);
                double angle1 = InventorAngle.getAngle(f.mAtomX[f.mGlobalToLocalAtom[minConnAtom[0]]], f.mAtomY[f.mGlobalToLocalAtom[minConnAtom[0]]], f.mAtomX[f.mGlobalToLocalAtom[bondAtom[0]]], f.mAtomY[f.mGlobalToLocalAtom[bondAtom[0]]]);
                double angle2 = InventorAngle.getAngle(f.mAtomX[f.mGlobalToLocalAtom[bondAtom[1]]], f.mAtomY[f.mGlobalToLocalAtom[bondAtom[1]]], f.mAtomX[f.mGlobalToLocalAtom[minConnAtom[1]]], f.mAtomY[f.mGlobalToLocalAtom[minConnAtom[1]]]);
                if (!(this.getAngleDif(dbAngle, angle1) < 0.0 ^ this.getAngleDif(dbAngle, angle2) < 0.0 ^ this.mMol.getBondParity(bond) == 2)) continue;
                f.flipOneSide(bond);
            }
        }
    }

    private void optimizeFragments() {
        int[] atomSymRank = this.calculateAtomSymmetries();
        byte[] bondFlipPriority = new byte[this.mMol.getAllBonds()];
        this.locateFlipBonds(bondFlipPriority, atomSymRank);
        for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            if (bondFlipPriority[bond] != 2 || !this.mMol.isRingAtom(this.mMol.getBondAtom(0, bond)) && !this.mMol.isRingAtom(this.mMol.getBondAtom(1, bond))) continue;
            bondFlipPriority[bond] = 3;
        }
        for (int fragmentNo = 0; fragmentNo < this.mFragmentList.size(); ++fragmentNo) {
            int nextAvailableRank;
            InventorFragment f = this.mFragmentList.get(fragmentNo);
            ArrayList<int[]> collisionList = f.getCollisionList();
            double minCollisionPanalty = f.getCollisionPanalty();
            InventorFragment minCollisionFragment = new InventorFragment(f);
            int lastBond = -1;
            for (int flip = 0; flip < 224 && collisionList.size() != 0; ++flip) {
                int i;
                int collisionNo = this.mRandom.nextInt(collisionList.size());
                int[] collidingAtom = collisionList.get(collisionNo);
                int[] bondSequence = this.getShortestConnection(collidingAtom[0], collidingAtom[1]);
                int[] availableBond = new int[bondSequence.length];
                int availableBonds = 0;
                if (flip < 32) {
                    for (i = 1; i < bondSequence.length - 1; ++i) {
                        if (bondFlipPriority[bondSequence[i]] != 3) continue;
                        availableBond[availableBonds++] = bondSequence[i];
                    }
                } else if (flip < 96) {
                    for (i = 1; i < bondSequence.length - 1; ++i) {
                        if (bondFlipPriority[bondSequence[i]] < 2) continue;
                        availableBond[availableBonds++] = bondSequence[i];
                    }
                } else {
                    for (i = 1; i < bondSequence.length - 1; ++i) {
                        if (bondFlipPriority[bondSequence[i]] < 1) continue;
                        availableBond[availableBonds++] = bondSequence[i];
                    }
                }
                if (availableBonds == 0) continue;
                int theBond = availableBond[0];
                if (availableBonds > 1) {
                    while ((theBond = availableBond[this.mRandom.nextInt(availableBonds)]) == lastBond) {
                    }
                }
                if (theBond == lastBond) continue;
                lastBond = theBond;
                f.flipOneSide(theBond);
                collisionList = f.getCollisionList();
                if (!(minCollisionPanalty > f.getCollisionPanalty())) continue;
                minCollisionPanalty = f.getCollisionPanalty();
                minCollisionFragment = new InventorFragment(f);
            }
            this.mFragmentList.set(fragmentNo, minCollisionFragment);
            f = minCollisionFragment;
            int currentRank = 1;
            do {
                nextAvailableRank = 9999;
                for (int i = 0; i < f.size(); ++i) {
                    int theRank = atomSymRank[f.mGlobalAtom[i]];
                    if (theRank == currentRank) {
                        f.optimizeAtomCoordinates(i);
                        continue;
                    }
                    if (theRank <= currentRank || theRank >= nextAvailableRank) continue;
                    nextAvailableRank = theRank;
                }
                currentRank = nextAvailableRank;
            } while (nextAvailableRank != 9999);
        }
    }

    private int[] getShortestConnection(int atom1, int atom2) {
        int[] graphAtom = new int[this.mMol.getAllAtoms()];
        int[] graphBond = new int[this.mMol.getAllAtoms()];
        int[] graphLevel = new int[this.mMol.getAllAtoms()];
        int[] graphParent = new int[this.mMol.getAllAtoms()];
        graphAtom[0] = atom2;
        graphLevel[atom2] = 1;
        graphParent[0] = -1;
        int highest = 0;
        for (int current = 0; current <= highest; ++current) {
            for (int i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(graphAtom[current]); ++i) {
                int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                int theBond = this.mMol.getConnBond(graphAtom[current], i);
                if (candidate == atom1) {
                    int chainLength = graphLevel[graphAtom[current]];
                    int[] bondSequence = new int[chainLength];
                    bondSequence[0] = theBond;
                    for (int j = 1; j < chainLength; ++j) {
                        bondSequence[j] = graphBond[current];
                        current = graphParent[current];
                    }
                    return bondSequence;
                }
                if (graphLevel[candidate] != 0) continue;
                graphAtom[++highest] = candidate;
                graphBond[highest] = theBond;
                graphLevel[candidate] = graphLevel[graphAtom[current]] + 1;
                graphParent[highest] = current;
            }
            if (current != highest) continue;
            return null;
        }
        return null;
    }

    private void locateFlipBonds(byte[] bondFlipPriority, int[] atomSymRank) {
        for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atom2 = this.mMol.getBondAtom(1, bond);
            if (this.mMol.isRingBond(bond) || this.mMol.getBondOrder(bond) != 1 || this.mMol.getAllConnAtoms(atom1) == 1 || this.mMol.getAllConnAtoms(atom2) == 1 || (this.mMode & 4) != 0 && this.mMol.isMarkedAtom(atom1) && this.mMol.isMarkedAtom(atom2)) continue;
            boolean oneBondEndIsSymmetric = false;
            for (int i = 0; i < 2; ++i) {
                int bondAtom = this.mMol.getBondAtom(i, bond);
                if (this.mMol.getAllConnAtoms(bondAtom) <= 2) continue;
                boolean symmetricEndFound = true;
                int connSymRank = -1;
                for (int j = 0; j < this.mMol.getAllConnAtoms(bondAtom); ++j) {
                    int connAtom = this.mMol.getConnAtom(bondAtom, j);
                    if (connAtom == this.mMol.getBondAtom(1 - i, bond)) continue;
                    if (connSymRank == -1) {
                        connSymRank = atomSymRank[connAtom];
                        continue;
                    }
                    if (connSymRank == atomSymRank[connAtom]) continue;
                    symmetricEndFound = false;
                }
                if (!symmetricEndFound) continue;
                oneBondEndIsSymmetric = true;
                break;
            }
            if (oneBondEndIsSymmetric) continue;
            bondFlipPriority[bond] = (this.mMode & 8) != 0 && this.mMol.isMarkedAtom(atom1) && this.mMol.isMarkedAtom(atom2) ? 1 : 2;
        }
    }

    private int[] calculateAtomSymmetries() {
        int oldNoOfRanks;
        int atomBits = Canonizer.getNeededBits(this.mMol.getAtoms());
        int maxConnAtoms = 2;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            maxConnAtoms = Math.max(maxConnAtoms, this.mMol.getAllConnAtoms(atom));
        }
        int baseValueSize = (62 + 2 * atomBits + maxConnAtoms * (atomBits + 1)) / 63;
        CanonizerBaseValue[] baseValue = new CanonizerBaseValue[this.mMol.getAllAtoms()];
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            baseValue[atom] = new CanonizerBaseValue(baseValueSize);
            baseValue[atom].init(atom);
        }
        int[] symRank = new int[this.mMol.getAllAtoms()];
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            int bondParity = this.mMol.getBondParity(bond);
            if (bondParity != 1 && bondParity != 2) continue;
            baseValue[this.mMol.getBondAtom(0, bond)].add(bondParity);
            baseValue[this.mMol.getBondAtom(1, bond)].add(bondParity);
        }
        int newNoOfRanks = this.consolidateRanks(baseValue, symRank);
        do {
            oldNoOfRanks = newNoOfRanks;
            this.calcNextBaseValues(baseValue, symRank, atomBits, maxConnAtoms);
        } while (oldNoOfRanks != (newNoOfRanks = this.consolidateRanks(baseValue, symRank)));
        return symRank;
    }

    private void calcNextBaseValues(CanonizerBaseValue[] baseValue, int[] symRank, int atomBits, int maxConnAtoms) {
        int[] connRank = new int[maxConnAtoms];
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            for (int i = 0; i < this.mMol.getAllConnAtoms(atom); ++i) {
                int j;
                int rank = symRank[this.mMol.getConnAtom(atom, i)];
                for (j = 0; j < i && rank >= connRank[j]; ++j) {
                }
                for (int k = i; k > j; --k) {
                    connRank[k] = connRank[k - 1];
                }
                connRank[j] = rank;
            }
            int neighbours = this.mMol.getAllConnAtoms(atom);
            baseValue[atom].init(atom);
            baseValue[atom].add(atomBits, symRank[atom]);
            baseValue[atom].add((maxConnAtoms - neighbours) * (atomBits + 1), 0L);
            for (int i = 0; i < neighbours; ++i) {
                baseValue[atom].add(atomBits + 1, connRank[i]);
            }
        }
    }

    private int consolidateRanks(CanonizerBaseValue[] baseValue, int[] symRank) {
        int rank = 0;
        Arrays.sort(baseValue);
        for (int i = 0; i < baseValue.length; ++i) {
            if (i == 0 || baseValue[i].compareTo(baseValue[i - 1]) != 0) {
                // empty if block
            }
            symRank[baseValue[i].getAtom()] = ++rank;
        }
        return rank;
    }

    private void joinMetalBondedFragments() {
        ArrayList<FragmentAssociation> associationList = this.createMetalBondAssociations();
        while (associationList != null) {
            FragmentAssociation association = this.getMaxPriorityAssociation(associationList);
            this.joinAssociatedFragments(association, 1.2);
            associationList = this.createMetalBondAssociations();
        }
    }

    private void joinChargedFragments() {
        FragmentAssociation association = this.createChargeAssociation();
        while (association != null) {
            this.joinAssociatedFragments(association, 1.5);
            association = this.createChargeAssociation();
        }
    }

    private void joinRemainingFragments() {
        FragmentAssociation association = this.createDisconnectedAssociation();
        while (association != null) {
            this.joinAssociatedFragments(association, 1.8);
            association = this.createDisconnectedAssociation();
        }
    }

    private void joinAssociatedFragments(FragmentAssociation association, double minDistance) {
        association.arrange(minDistance, (this.mMode & 0xC) != 0);
        InventorFragment mergedFragment = this.getMergedFragment(association.getFragment(0), association.getFragment(1), 0);
        this.updateFragmentList(association.getFragment(0), association.getFragment(1), mergedFragment);
    }

    private FragmentAssociation getMaxPriorityAssociation(ArrayList<FragmentAssociation> associationList) {
        int maxPriority = 0;
        FragmentAssociation maxFA = null;
        for (FragmentAssociation association : associationList) {
            if (maxPriority >= association.getPriority()) continue;
            maxPriority = association.getPriority();
            maxFA = association;
        }
        return maxFA;
    }

    private ArrayList<FragmentAssociation> createMetalBondAssociations() {
        ArrayList<FragmentAssociation> associationList = null;
        FragmentAssociation[][] fa = null;
        for (int bond = 0; bond < this.mMol.getBonds(); ++bond) {
            int f2;
            int f1;
            if (this.mMol.getBondType(bond) != 32) continue;
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atomIndex1 = -1;
            for (f1 = 0; f1 < this.mFragmentList.size() && (atomIndex1 = this.mFragmentList.get(f1).getLocalAtom(atom1)) == -1; ++f1) {
            }
            int atom2 = this.mMol.getBondAtom(1, bond);
            int atomIndex2 = -1;
            for (f2 = 0; f2 < this.mFragmentList.size() && (atomIndex2 = this.mFragmentList.get(f2).getLocalAtom(atom2)) == -1; ++f2) {
            }
            if (f1 == f2) continue;
            if (f1 > f2) {
                int temp = f1;
                f1 = f2;
                f2 = temp;
                temp = atomIndex1;
                atomIndex1 = atomIndex2;
                atomIndex2 = temp;
            }
            if (fa == null) {
                fa = new FragmentAssociation[this.mFragmentList.size()][];
            }
            if (fa[f2] == null) {
                fa[f2] = new FragmentAssociation[f2];
            }
            if (fa[f2][f1] != null) {
                fa[f2][f1].add(atomIndex1, atomIndex2);
                continue;
            }
            fa[f2][f1] = new FragmentAssociation(this.mFragmentList.get(f1), this.mFragmentList.get(f2), atomIndex1, atomIndex2);
            if (associationList == null) {
                associationList = new ArrayList<FragmentAssociation>();
            }
            associationList.add(fa[f2][f1]);
        }
        return associationList;
    }

    private FragmentAssociation createChargeAssociation() {
        ArrayList<InventorCharge> negChargeList = new ArrayList<InventorCharge>();
        ArrayList posChargeList = new ArrayList();
        ArrayList<InventorCharge> chargeList = new ArrayList<InventorCharge>();
        block0: for (InventorFragment f : this.mFragmentList) {
            int charge;
            int fragmentCharge = 0;
            chargeList.clear();
            for (int i = 0; i < f.size(); ++i) {
                int atom = f.getGlobalAtom(i);
                charge = this.mUnPairedCharge[atom];
                if (charge == 0) continue;
                chargeList.add(new InventorCharge(f, i, charge));
                fragmentCharge += charge;
            }
            if (fragmentCharge == 0) continue;
            Collections.sort(chargeList, new Comparator<InventorCharge>(){

                @Override
                public int compare(InventorCharge o1, InventorCharge o2) {
                    int c2;
                    int c1 = Math.abs(o1.charge);
                    return c1 < (c2 = Math.abs(o2.charge)) ? -1 : (c1 == c2 ? 0 : 1);
                }
            });
            for (InventorCharge ic : chargeList) {
                if (fragmentCharge * ic.charge <= 0) continue;
                charge = Math.abs(fragmentCharge) >= Math.abs(ic.charge) ? ic.charge : fragmentCharge;
                (charge < 0 ? negChargeList : posChargeList).add(new InventorCharge(f, ic.atom, charge));
                if ((fragmentCharge -= charge) != 0) continue;
                continue block0;
            }
        }
        if (negChargeList.size() == 0 || posChargeList.size() == 0) {
            return null;
        }
        Collections.sort(posChargeList, new Comparator<InventorCharge>(){

            @Override
            public int compare(InventorCharge o1, InventorCharge o2) {
                int c2;
                int c1 = o1.fragment.size();
                return c1 < (c2 = o1.fragment.size()) ? 1 : (c1 == c2 ? 0 : -1);
            }
        });
        Collections.sort(negChargeList, new Comparator<InventorCharge>(){

            @Override
            public int compare(InventorCharge o1, InventorCharge o2) {
                int c2;
                int c1 = o1.fragment.size();
                return c1 < (c2 = o1.fragment.size()) ? -1 : (c1 == c2 ? 0 : 1);
            }
        });
        for (InventorCharge pc : posChargeList) {
            for (InventorCharge nc : negChargeList) {
                if (pc.charge != -nc.charge) continue;
                int n = pc.fragment.getGlobalAtom(pc.atom);
                this.mUnPairedCharge[n] = this.mUnPairedCharge[n] - pc.charge;
                int n2 = nc.fragment.getGlobalAtom(nc.atom);
                this.mUnPairedCharge[n2] = this.mUnPairedCharge[n2] - nc.charge;
                return new FragmentAssociation(pc.fragment, nc.fragment, pc.atom, nc.atom);
            }
        }
        for (InventorCharge pc : posChargeList) {
            for (InventorCharge nc : negChargeList) {
                if (pc.charge <= -nc.charge) continue;
                int n = pc.fragment.getGlobalAtom(pc.atom);
                this.mUnPairedCharge[n] = this.mUnPairedCharge[n] + nc.charge;
                int n3 = nc.fragment.getGlobalAtom(nc.atom);
                this.mUnPairedCharge[n3] = this.mUnPairedCharge[n3] - nc.charge;
                return new FragmentAssociation(pc.fragment, nc.fragment, pc.atom, nc.atom);
            }
        }
        for (InventorCharge pc : posChargeList) {
            for (InventorCharge nc : negChargeList) {
                if (pc.charge >= -nc.charge) continue;
                int n = pc.fragment.getGlobalAtom(pc.atom);
                this.mUnPairedCharge[n] = this.mUnPairedCharge[n] - pc.charge;
                int n4 = nc.fragment.getGlobalAtom(nc.atom);
                this.mUnPairedCharge[n4] = this.mUnPairedCharge[n4] + pc.charge;
                return new FragmentAssociation(pc.fragment, nc.fragment, pc.atom, nc.atom);
            }
        }
        return null;
    }

    private FragmentAssociation createDisconnectedAssociation() {
        if (this.mFragmentList.size() < 2) {
            return null;
        }
        return new FragmentAssociation(this.mFragmentList.get(0), this.mFragmentList.get(1));
    }

    private void updateFragmentList(InventorFragment fOld1, InventorFragment fOld2, InventorFragment fJoined) {
        int index = Math.min(this.mFragmentList.indexOf(fOld1), this.mFragmentList.indexOf(fOld2));
        this.mFragmentList.add(index, fJoined);
        this.mFragmentList.remove(fOld1);
        this.mFragmentList.remove(fOld2);
    }
}

