/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.coords.InventorFragment;

public class FragmentAssociation {
    private InventorFragment[] mFragment = new InventorFragment[2];
    private double[] mX;
    private double[] mY;
    private int[] mCount;

    public FragmentAssociation(InventorFragment f1, InventorFragment f2, int atomIndex1, int atomIndex2) {
        this.mFragment[0] = f1;
        this.mFragment[1] = f2;
        this.mX = new double[2];
        this.mY = new double[2];
        this.mX[0] = this.mFragment[0].getAtomX(atomIndex1);
        this.mY[0] = this.mFragment[0].getAtomY(atomIndex1);
        this.mX[1] = this.mFragment[1].getAtomX(atomIndex2);
        this.mY[1] = this.mFragment[1].getAtomY(atomIndex2);
        this.mCount = new int[2];
        this.mCount[0] = 1;
        this.mCount[1] = 1;
    }

    public FragmentAssociation(InventorFragment f1, InventorFragment f2) {
        this.mFragment[0] = f1;
        this.mFragment[1] = f2;
        this.mX = new double[2];
        this.mY = new double[2];
        this.mCount = new int[2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.mFragment[i].size(); ++j) {
                int n = i;
                this.mX[n] = this.mX[n] + this.mFragment[i].getAtomX(j);
                int n2 = i;
                this.mY[n2] = this.mY[n2] + this.mFragment[i].getAtomY(j);
            }
            this.mCount[i] = this.mFragment[i].size();
        }
    }

    public void add(int atomIndex1, int atomIndex2) {
        this.mX[0] = this.mX[0] + this.mFragment[0].getAtomX(atomIndex1);
        this.mY[0] = this.mY[0] + this.mFragment[0].getAtomY(atomIndex1);
        this.mX[1] = this.mX[1] + this.mFragment[1].getAtomX(atomIndex2);
        this.mY[1] = this.mY[1] + this.mFragment[1].getAtomY(atomIndex2);
        this.mCount[0] = this.mCount[0] + 1;
        this.mCount[1] = this.mCount[1] + 1;
    }

    public InventorFragment getFragment(int i) {
        return this.mFragment[i];
    }

    public int getPriority() {
        return this.mFragment[0].size() * this.mFragment[1].size();
    }

    public void arrange(double minDistance, boolean keepFirstFragment) {
        int i;
        int i2;
        double[] angle = new double[2];
        for (int i3 = 0; i3 < 2; ++i3) {
            int n = i3;
            this.mX[n] = this.mX[n] / (double)this.mCount[i3];
            int n2 = i3;
            this.mY[n2] = this.mY[n2] / (double)this.mCount[i3];
            angle[i3] = this.mFragment[i3].calculatePreferredAttachmentAngle(this.mX[i3], this.mY[i3], this.mFragment[1 - i3].size(), minDistance);
        }
        this.mFragment[0].rotate(this.mX[0], this.mY[0], 1.5707963267948966 - angle[0]);
        this.mFragment[1].rotate(this.mX[1], this.mY[1], 4.71238898038469 - angle[1]);
        double yMin = Double.MAX_VALUE;
        double yMax = -1.7976931348623157E308;
        double dy = this.mY[0] - this.mY[1];
        for (int i4 = 0; i4 < this.mFragment[1].mAtomY.length; ++i4) {
            int n = i4;
            this.mFragment[1].mAtomY[n] = this.mFragment[1].mAtomY[n] + dy;
            if (yMin > this.mFragment[1].mAtomY[i4]) {
                yMin = this.mFragment[1].mAtomY[i4];
            }
            if (!(yMax < this.mFragment[1].mAtomY[i4])) continue;
            yMax = this.mFragment[1].mAtomY[i4];
        }
        double range = yMax - yMin + 2.0 * minDistance;
        int binCount = (int)Math.ceil(range);
        yMin += (range - (double)binCount) / 2.0 - minDistance;
        double[] leftX = new double[binCount];
        for (i2 = 0; i2 < binCount; ++i2) {
            leftX[i2] = this.mX[1] + minDistance;
        }
        for (i2 = 0; i2 < this.mFragment[1].mAtomY.length; ++i2) {
            double relY = this.mFragment[1].mAtomY[i2] - yMin;
            int low = (int)(relY - minDistance);
            int high = Math.min((int)(relY + minDistance), binCount - 1);
            for (int j = low; j <= high; ++j) {
                if (!(leftX[j] > this.mFragment[1].mAtomX[i2])) continue;
                leftX[j] = this.mFragment[1].mAtomX[i2];
            }
        }
        i2 = 0;
        while (i2 < binCount) {
            int n = i2++;
            leftX[n] = leftX[n] - minDistance;
        }
        double dx = this.mX[0] - this.mX[1];
        for (i = 0; i < this.mFragment[0].mAtomX.length; ++i) {
            int index = (int)(this.mFragment[0].mAtomY[i] - yMin);
            if (index < 0 || index >= leftX.length || !(dx < this.mFragment[0].mAtomX[i] - leftX[index])) continue;
            dx = this.mFragment[0].mAtomX[i] - leftX[index];
        }
        i = 0;
        while (i < this.mFragment[1].mAtomX.length) {
            int n = i++;
            this.mFragment[1].mAtomX[n] = this.mFragment[1].mAtomX[n] + dx;
        }
        if (keepFirstFragment) {
            this.mFragment[0].rotate(this.mX[0], this.mY[0], angle[0] - 1.5707963267948966);
            this.mFragment[1].rotate(this.mX[0], this.mY[0], angle[0] - 1.5707963267948966);
        }
    }
}

