/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

public class InventorAngle {
    double mAngle;
    double mLength;

    protected static double getAngle(double x1, double y1, double x2, double y2) {
        double angle;
        double xdif = x2 - x1;
        double ydif = y2 - y1;
        if (ydif != 0.0) {
            angle = Math.atan(xdif / ydif);
            if (ydif < 0.0) {
                angle = xdif < 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
            }
        } else {
            angle = xdif > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return angle;
    }

    protected InventorAngle(double angle, double length) {
        this.mAngle = angle;
        this.mLength = length;
    }

    protected InventorAngle(double x1, double y1, double x2, double y2) {
        this.mAngle = InventorAngle.getAngle(x1, y1, x2, y2);
        double xdif = x2 - x1;
        double ydif = y2 - y1;
        this.mLength = Math.sqrt(xdif * xdif + ydif * ydif);
    }
}

