/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.coords.InventorAngle;
import java.util.ArrayList;
import java.util.Arrays;

public class InventorFragment {
    private static final double cCollisionLimitBondRotation = 0.8;
    private static final double cCollisionLimitAtomMovement = 0.5;
    private final int CIRCULAR_BINS = 36;
    protected int[] mGlobalAtom;
    protected int[] mGlobalBond;
    protected int[] mGlobalToLocalAtom;
    protected int[] mPriority;
    protected double[] mAtomX;
    protected double[] mAtomY;
    protected boolean mKeepMarkedAtoms;
    private StereoMolecule mMol;
    private boolean mMinMaxAvail;
    private double mMinX;
    private double mMinY;
    private double mMaxX;
    private double mMaxY;
    private double mCollisionPanalty;
    private int[][] mFlipList;
    private int[] mSortedAtom;

    protected InventorFragment(StereoMolecule mol, int atoms, boolean keepMarkedAtoms) {
        this.mMol = mol;
        this.mKeepMarkedAtoms = keepMarkedAtoms;
        this.mGlobalAtom = new int[atoms];
        this.mPriority = new int[atoms];
        this.mAtomX = new double[atoms];
        this.mAtomY = new double[atoms];
    }

    protected InventorFragment(InventorFragment f) {
        int i;
        this.mMol = f.mMol;
        this.mKeepMarkedAtoms = f.mKeepMarkedAtoms;
        this.mGlobalAtom = new int[f.size()];
        this.mPriority = new int[f.size()];
        this.mAtomX = new double[f.size()];
        this.mAtomY = new double[f.size()];
        for (i = 0; i < f.size(); ++i) {
            this.mGlobalAtom[i] = f.mGlobalAtom[i];
            this.mPriority[i] = f.mPriority[i];
            this.mAtomX[i] = f.mAtomX[i];
            this.mAtomY[i] = f.mAtomY[i];
        }
        if (f.mGlobalBond != null) {
            this.mGlobalBond = new int[f.mGlobalBond.length];
            for (i = 0; i < f.mGlobalBond.length; ++i) {
                this.mGlobalBond[i] = f.mGlobalBond[i];
            }
        }
        if (f.mGlobalToLocalAtom != null) {
            this.mGlobalToLocalAtom = new int[f.mGlobalToLocalAtom.length];
            for (i = 0; i < f.mGlobalToLocalAtom.length; ++i) {
                this.mGlobalToLocalAtom[i] = f.mGlobalToLocalAtom[i];
            }
        }
    }

    protected int size() {
        return this.mGlobalAtom.length;
    }

    protected boolean equals(InventorFragment f) {
        if (f.size() != this.size()) {
            return false;
        }
        int[] sorted = this.getSortedAtoms();
        int[] sortedF = f.getSortedAtoms();
        for (int i = 0; i < sorted.length; ++i) {
            if (sorted[i] == sortedF[i]) continue;
            return false;
        }
        return true;
    }

    private int[] getSortedAtoms() {
        if (this.mSortedAtom == null) {
            this.mSortedAtom = (int[])this.mGlobalAtom.clone();
            Arrays.sort(this.mSortedAtom);
        }
        return this.mSortedAtom;
    }

    protected double getAtomX(int index) {
        return this.mAtomX[index];
    }

    protected double getAtomY(int index) {
        return this.mAtomY[index];
    }

    protected double getWidth() {
        this.calculateMinMax();
        return this.mMaxX - this.mMinX + 1.0;
    }

    protected double getHeight() {
        this.calculateMinMax();
        return this.mMaxY - this.mMinY + 1.0;
    }

    protected boolean isMember(int globalAtom) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            if (globalAtom != this.mGlobalAtom[i]) continue;
            return true;
        }
        return false;
    }

    protected int getGlobalAtom(int localAtom) {
        return this.mGlobalAtom[localAtom];
    }

    protected int getLocalAtom(int globalAtom) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            if (globalAtom != this.mGlobalAtom[i]) continue;
            return i;
        }
        return -1;
    }

    protected void translate(double dx, double dy) {
        int i = 0;
        while (i < this.mGlobalAtom.length) {
            int n = i;
            this.mAtomX[n] = this.mAtomX[n] + dx;
            int n2 = i++;
            this.mAtomY[n2] = this.mAtomY[n2] + dy;
        }
    }

    protected void rotate(double x, double y, double angleDif) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double distance = Math.sqrt((this.mAtomX[i] - x) * (this.mAtomX[i] - x) + (this.mAtomY[i] - y) * (this.mAtomY[i] - y));
            double angle = InventorAngle.getAngle(x, y, this.mAtomX[i], this.mAtomY[i]) + angleDif;
            this.mAtomX[i] = x + distance * Math.sin(angle);
            this.mAtomY[i] = y + distance * Math.cos(angle);
        }
    }

    protected void flip(double x, double y, double mirrorAngle) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double distance = Math.sqrt((this.mAtomX[i] - x) * (this.mAtomX[i] - x) + (this.mAtomY[i] - y) * (this.mAtomY[i] - y));
            double angle = 2.0 * mirrorAngle - InventorAngle.getAngle(x, y, this.mAtomX[i], this.mAtomY[i]);
            this.mAtomX[i] = x + distance * Math.sin(angle);
            this.mAtomY[i] = y + distance * Math.cos(angle);
        }
    }

    protected void flipOneSide(int bond) {
        int i;
        if (this.mFlipList == null) {
            this.mFlipList = new int[this.mMol.getAllBonds()][];
        }
        if (this.mFlipList[bond] == null) {
            boolean flipOtherSide;
            int[] graphAtom = new int[this.mGlobalAtom.length];
            boolean[] isOnSide = new boolean[this.mMol.getAllAtoms()];
            int atom1 = this.mMol.getBondAtom(0, bond);
            int atom2 = this.mMol.getBondAtom(1, bond);
            graphAtom[0] = atom1;
            isOnSide[atom1] = true;
            int highest = 0;
            for (int current = 0; current <= highest; ++current) {
                for (i = 0; i < this.mMol.getAllConnAtoms(graphAtom[current]); ++i) {
                    int candidate = this.mMol.getConnAtom(graphAtom[current], i);
                    if (isOnSide[candidate] || candidate == atom2) continue;
                    graphAtom[++highest] = candidate;
                    isOnSide[candidate] = true;
                }
                if (current == highest) break;
            }
            boolean bl = flipOtherSide = highest + 1 > this.mGlobalAtom.length / 2;
            if (this.mKeepMarkedAtoms) {
                boolean coreOnSide = false;
                boolean coreOffSide = false;
                for (int i2 = 0; i2 < this.mGlobalAtom.length; ++i2) {
                    int atom = this.mGlobalAtom[i2];
                    if (!this.mMol.isMarkedAtom(atom) || atom == atom1 || atom == atom2) continue;
                    if (isOnSide[this.mGlobalAtom[i2]]) {
                        coreOnSide = true;
                        continue;
                    }
                    coreOffSide = true;
                }
                if (coreOnSide != coreOffSide) {
                    flipOtherSide = coreOnSide;
                }
            }
            int count = 2;
            this.mFlipList[bond] = new int[flipOtherSide ? this.mGlobalAtom.length - highest : highest + 2];
            for (int i3 = 0; i3 < this.mGlobalAtom.length; ++i3) {
                if (this.mGlobalAtom[i3] == atom1) {
                    this.mFlipList[bond][flipOtherSide ? 0 : 1] = i3;
                    continue;
                }
                if (this.mGlobalAtom[i3] == atom2) {
                    this.mFlipList[bond][flipOtherSide ? 1 : 0] = i3;
                    continue;
                }
                if (!(flipOtherSide ^ isOnSide[this.mGlobalAtom[i3]])) continue;
                this.mFlipList[bond][count++] = i3;
            }
        }
        double x = this.mAtomX[this.mFlipList[bond][0]];
        double y = this.mAtomY[this.mFlipList[bond][0]];
        double mirrorAngle = InventorAngle.getAngle(x, y, this.mAtomX[this.mFlipList[bond][1]], this.mAtomY[this.mFlipList[bond][1]]);
        for (i = 2; i < this.mFlipList[bond].length; ++i) {
            int index = this.mFlipList[bond][i];
            double distance = Math.sqrt((this.mAtomX[index] - x) * (this.mAtomX[index] - x) + (this.mAtomY[index] - y) * (this.mAtomY[index] - y));
            double angle = 2.0 * mirrorAngle - InventorAngle.getAngle(x, y, this.mAtomX[index], this.mAtomY[index]);
            this.mAtomX[index] = x + distance * Math.sin(angle);
            this.mAtomY[index] = y + distance * Math.cos(angle);
        }
    }

    protected void arrangeWith(InventorFragment f) {
        double maxGain = 0.0;
        int maxCorner = 0;
        for (int corner = 0; corner < 4; ++corner) {
            double gain = this.getCornerDistance(corner) + f.getCornerDistance(corner >= 2 ? corner - 2 : corner + 2);
            if (!(maxGain < gain)) continue;
            maxGain = gain;
            maxCorner = corner;
        }
        double sumHeight = this.getHeight() + f.getHeight();
        double sumWidth = 0.75 * (this.getWidth() + f.getWidth());
        double maxHeight = Math.max(this.getHeight(), f.getHeight());
        double maxWidth = 0.75 * Math.max(this.getWidth(), f.getWidth());
        double bestCornerSize = Math.sqrt((sumHeight - maxGain) * (sumHeight - maxGain) + (sumWidth - 0.75 * maxGain) * (sumWidth - 0.75 * maxGain));
        double toppedSize = Math.max(maxWidth, sumHeight);
        double besideSize = Math.max(maxHeight, sumWidth);
        if (bestCornerSize < toppedSize && bestCornerSize < besideSize) {
            switch (maxCorner) {
                case 0: {
                    f.translate(this.mMaxX - f.mMinX - maxGain + 1.0, this.mMinY - f.mMaxY + maxGain - 1.0);
                    break;
                }
                case 1: {
                    f.translate(this.mMaxX - f.mMinX - maxGain + 1.0, this.mMaxY - f.mMinY - maxGain + 1.0);
                    break;
                }
                case 2: {
                    f.translate(this.mMinX - f.mMaxX + maxGain - 1.0, this.mMaxY - f.mMinY - maxGain + 1.0);
                    break;
                }
                case 3: {
                    f.translate(this.mMinX - f.mMaxX + maxGain - 1.0, this.mMinY - f.mMaxY + maxGain - 1.0);
                }
            }
        } else if (besideSize < toppedSize) {
            f.translate(this.mMaxX - f.mMinX + 1.0, (this.mMaxY + this.mMinY - f.mMaxY - f.mMinY) / 2.0);
        } else {
            f.translate((this.mMaxX + this.mMinX - f.mMaxX - f.mMinX) / 2.0, this.mMaxY - f.mMinY + 1.0);
        }
    }

    private void calculateMinMax() {
        if (this.mMinMaxAvail) {
            return;
        }
        this.mMinX = this.mAtomX[0];
        this.mMaxX = this.mAtomX[0];
        this.mMinY = this.mAtomY[0];
        this.mMaxY = this.mAtomY[0];
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double surplus = this.getAtomSurplus(i);
            if (this.mMinX > this.mAtomX[i] - surplus) {
                this.mMinX = this.mAtomX[i] - surplus;
            }
            if (this.mMaxX < this.mAtomX[i] + surplus) {
                this.mMaxX = this.mAtomX[i] + surplus;
            }
            if (this.mMinY > this.mAtomY[i] - surplus) {
                this.mMinY = this.mAtomY[i] - surplus;
            }
            if (!(this.mMaxY < this.mAtomY[i] + surplus)) continue;
            this.mMaxY = this.mAtomY[i] + surplus;
        }
        this.mMinMaxAvail = true;
    }

    private double getCornerDistance(int corner) {
        double minDistance = 9999.0;
        for (int atom = 0; atom < this.mGlobalAtom.length; ++atom) {
            double surplus = this.getAtomSurplus(atom);
            double d = 0.0;
            switch (corner) {
                case 0: {
                    d = this.mMaxX - 0.5 * (this.mMaxX + this.mMinY + this.mAtomX[atom] - this.mAtomY[atom]);
                    break;
                }
                case 1: {
                    d = this.mMaxX - 0.5 * (this.mMaxX - this.mMaxY + this.mAtomX[atom] + this.mAtomY[atom]);
                    break;
                }
                case 2: {
                    d = 0.5 * (this.mMinX + this.mMaxY + this.mAtomX[atom] - this.mAtomY[atom]) - this.mMinX;
                    break;
                }
                case 3: {
                    d = 0.5 * (this.mMinX - this.mMinY + this.mAtomX[atom] + this.mAtomY[atom]) - this.mMinX;
                }
            }
            if (!(minDistance > d - surplus)) continue;
            minDistance = d - surplus;
        }
        return minDistance;
    }

    private double getAtomSurplus(int atom) {
        return this.mMol.getAtomQueryFeatures(this.mGlobalAtom[atom]) != 0L ? 0.6 : (this.mMol.getAtomicNo(this.mGlobalAtom[atom]) != 6 ? 0.25 : 0.0);
    }

    protected ArrayList<int[]> getCollisionList() {
        this.mCollisionPanalty = 0.0;
        ArrayList<int[]> collisionList = new ArrayList<int[]>();
        for (int i = 1; i < this.mGlobalAtom.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double ydif;
                double xdif = Math.abs(this.mAtomX[i] - this.mAtomX[j]);
                double dist = Math.sqrt(xdif * xdif + (ydif = Math.abs(this.mAtomY[i] - this.mAtomY[j])) * ydif);
                if (dist < 0.8) {
                    int[] collidingAtom = new int[]{this.mGlobalAtom[i], this.mGlobalAtom[j]};
                    collisionList.add(collidingAtom);
                }
                double panalty = 1.0 - Math.min(dist, 1.0);
                this.mCollisionPanalty += panalty * panalty;
            }
        }
        return collisionList;
    }

    protected double getCollisionPanalty() {
        return this.mCollisionPanalty;
    }

    protected void locateBonds() {
        int j;
        int connAtoms;
        int atom;
        int i;
        int fragmentBonds = 0;
        for (i = 0; i < this.mGlobalAtom.length; ++i) {
            atom = this.mGlobalAtom[i];
            connAtoms = this.mMol.getAllConnAtoms(atom);
            for (j = 0; j < connAtoms; ++j) {
                if (this.mMol.getConnAtom(atom, j) <= atom) continue;
                ++fragmentBonds;
            }
        }
        this.mGlobalBond = new int[fragmentBonds];
        this.mGlobalToLocalAtom = new int[this.mMol.getAllAtoms()];
        fragmentBonds = 0;
        for (i = 0; i < this.mGlobalAtom.length; ++i) {
            atom = this.mGlobalAtom[i];
            connAtoms = this.mMol.getAllConnAtoms(atom);
            this.mGlobalToLocalAtom[atom] = i;
            for (j = 0; j < connAtoms; ++j) {
                if (this.mMol.getConnAtom(atom, j) <= atom) continue;
                this.mGlobalBond[fragmentBonds++] = this.mMol.getConnBond(atom, j);
            }
        }
    }

    protected void optimizeAtomCoordinates(int atom) {
        double x = this.mAtomX[atom];
        double y = this.mAtomY[atom];
        InventorAngle[] collisionForce = new InventorAngle[4];
        int forces = 0;
        for (int i = 0; i < this.mGlobalBond.length && forces < 4; ++i) {
            if (atom == this.mGlobalToLocalAtom[this.mMol.getBondAtom(0, this.mGlobalBond[i])] || atom == this.mGlobalToLocalAtom[this.mMol.getBondAtom(1, this.mGlobalBond[i])]) continue;
            double x1 = this.mAtomX[this.mGlobalToLocalAtom[this.mMol.getBondAtom(0, this.mGlobalBond[i])]];
            double y1 = this.mAtomY[this.mGlobalToLocalAtom[this.mMol.getBondAtom(0, this.mGlobalBond[i])]];
            double x2 = this.mAtomX[this.mGlobalToLocalAtom[this.mMol.getBondAtom(1, this.mGlobalBond[i])]];
            double y2 = this.mAtomY[this.mGlobalToLocalAtom[this.mMol.getBondAtom(1, this.mGlobalBond[i])]];
            double d1 = Math.sqrt((x1 - x) * (x1 - x) + (y1 - y) * (y1 - y));
            double d2 = Math.sqrt((x2 - x) * (x2 - x) + (y2 - y) * (y2 - y));
            double bondLength = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (d1 < bondLength && d2 < bondLength) {
                double d;
                if (x1 == x2) {
                    d = Math.abs(x - x1);
                    if (!(d < 0.5)) continue;
                    collisionForce[forces++] = new InventorAngle(InventorAngle.getAngle(x1, y, x, y), (0.5 - d) / 2.0);
                    continue;
                }
                if (y1 == y2) {
                    d = Math.abs(y - y1);
                    if (!(d < 0.5)) continue;
                    collisionForce[forces++] = new InventorAngle(InventorAngle.getAngle(x, y1, x, y), (0.5 - d) / 2.0);
                    continue;
                }
                double m1 = (y2 - y1) / (x2 - x1);
                double m2 = -1.0 / m1;
                double a2 = y - m2 * x;
                double a1 = y1 - m1 * x1;
                double xs = (a2 - a1) / (m1 - m2);
                double ys = m1 * xs + a1;
                double d3 = Math.sqrt((xs - x) * (xs - x) + (ys - y) * (ys - y));
                if (!(d3 < 0.5)) continue;
                collisionForce[forces++] = new InventorAngle(InventorAngle.getAngle(xs, ys, x, y), (0.5 - d3) / 2.0);
                continue;
            }
            if (d1 < 0.5) {
                collisionForce[forces++] = new InventorAngle(InventorAngle.getAngle(x1, y1, x, y), (0.5 - d1) / 2.0);
                continue;
            }
            if (!(d2 < 0.5)) continue;
            collisionForce[forces++] = new InventorAngle(InventorAngle.getAngle(x2, y2, x, y), (0.5 - d2) / 2.0);
        }
        if (forces > 0) {
            InventorAngle force = CoordinateInventor.getMeanAngle(collisionForce, forces);
            int n = atom;
            this.mAtomX[n] = this.mAtomX[n] + force.mLength * Math.sin(force.mAngle);
            int n2 = atom;
            this.mAtomY[n2] = this.mAtomY[n2] + force.mLength * Math.cos(force.mAngle);
        }
    }

    protected double calculatePreferredAttachmentAngle(double x, double y, int neighbourAtomCount, double padding) {
        if (this.size() == 1) {
            return 0.0;
        }
        double BIN_ANGLE = 0.17453292519943295;
        double neighbourRadius = padding + Math.sqrt(neighbourAtomCount);
        double[] distance = new double[36];
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double dy;
            double dx;
            double sd;
            double angle = InventorAngle.getAngle(x, y, this.mAtomX[i], this.mAtomY[i]);
            int bin = this.correctBin((int)Math.round(angle * 36.0 / (Math.PI * 2)));
            if (!(distance[bin] < (sd = (dx = x - this.mAtomX[i]) * dx + (dy = y - this.mAtomY[i]) * dy))) continue;
            distance[bin] = sd;
        }
        double maxDistance = -1.0;
        int maxBin = -1;
        for (int i = 0; i < 36; ++i) {
            distance[i] = Math.sqrt(distance[i]);
            if (!(maxDistance < distance[i])) continue;
            maxDistance = distance[i];
            maxBin = i;
        }
        int preferredBin = this.correctBin(maxBin - 18);
        for (int i = 0; i <= 18; ++i) {
            int n = this.correctBin(preferredBin + i);
            distance[n] = distance[n] + 0.01 * (double)i;
            int n2 = this.correctBin(preferredBin - i);
            distance[n2] = distance[n2] + 0.01 * (double)i;
        }
        int neighbourCount = 9;
        double[] sin = new double[neighbourCount];
        double[] cos = new double[neighbourCount];
        for (int i = 1; i < neighbourCount; ++i) {
            sin[i] = Math.sin((double)i * 0.17453292519943295);
            cos[i] = Math.cos((double)i * 0.17453292519943295);
        }
        double squareRadius = neighbourRadius * neighbourRadius;
        double minDistance = Double.MAX_VALUE;
        int minBin = -1;
        for (int bin = 0; bin < 36; ++bin) {
            if (distance[bin] >= minDistance) continue;
            double localMinDistance = distance[bin];
            for (int i = 1; i < neighbourCount; ++i) {
                double d;
                int neighbourBin;
                for (int j = -1; !(j > 1 || !(distance[neighbourBin = this.correctBin(bin + j * i)] * cos[i] <= localMinDistance) && localMinDistance < (d = cos[i] * Math.min(distance[neighbourBin], neighbourRadius / sin[i])) && minDistance <= (localMinDistance = d)); j += 2) {
                }
                if (minDistance <= localMinDistance) break;
            }
            if (!(minDistance > localMinDistance)) continue;
            minDistance = localMinDistance;
            minBin = bin;
        }
        return Math.PI * 2 * (double)minBin / 36.0;
    }

    private int correctBin(int bin) {
        return bin < 0 ? bin + 36 : (bin >= 36 ? bin - 36 : bin);
    }
}

