/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.StereoMolecule;

public class InventorTemplate {
    private StereoMolecule mFragment;
    private long[] mFFP;
    private double mAVBL;
    private boolean mKeepAbsoluteOrientation;

    public InventorTemplate(StereoMolecule fragment, long[] ffp, boolean keepAbsoluteOrientation) {
        this.mFragment = fragment;
        this.mFFP = ffp;
        this.mKeepAbsoluteOrientation = keepAbsoluteOrientation;
    }

    public boolean keepAbsoluteOrientation() {
        return this.mKeepAbsoluteOrientation;
    }

    public void normalizeCoordinates() {
        this.mAVBL = this.mFragment.getAverageBondLength();
    }

    public double getNormalizedAtomX(int atom) {
        return this.mFragment.getAtomX(atom) / this.mAVBL;
    }

    public double getNormalizedAtomY(int atom) {
        return this.mFragment.getAtomY(atom) / this.mAVBL;
    }

    public StereoMolecule getFragment() {
        return this.mFragment;
    }

    public long[] getFFP() {
        return this.mFFP;
    }
}

