/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

class BondSet
implements Comparable<BondSet> {
    private int[] mMask;

    public BondSet(int[] bond, int usedBonds, int bondCount) {
        this.mMask = new int[(bondCount + 31) / 32];
        for (int i = 0; i < usedBonds; ++i) {
            int n = bond[i] / 32;
            this.mMask[n] = this.mMask[n] | 1 << bond[i] % 32;
        }
    }

    public boolean equals(BondSet bs) {
        for (int i = 0; i < this.mMask.length; ++i) {
            if (bs.mMask[i] == this.mMask[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BondSet bs) {
        for (int i = 0; i < this.mMask.length; ++i) {
            if (bs.mMask[i] == this.mMask[i]) continue;
            return bs.mMask[i] < this.mMask[i] ? -1 : 1;
        }
        return 0;
    }
}

