/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

public class DescriptorEncoder {
    public static final int MAX_COUNT_VALUE = 63;
    private static final int BITS = 6;
    private static final int PAIR_BITS = 4;
    private static final byte[] sCode = "0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".getBytes();
    private static final byte[] sCodeMultipleMin = "!#$%&()*+,-./".getBytes();
    private static final byte[] sCodeMultipleMax = ":;<=>?[]^{|}~".getBytes();
    private static int[] sDecode;
    private static int[] sDecodeMultiple;
    private byte[] mBytes;
    private int mByteIndex;
    private int mAvailableBits;
    private int mTempData;
    private int mByteMask;
    private int mTempDataLong;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorEncoder() {
        if (sDecode == null) {
            DescriptorEncoder descriptorEncoder = this;
            synchronized (descriptorEncoder) {
                int i;
                int len = 64;
                assert (len <= sCode.length) : "Error in encoding, not enough characters.";
                sDecode = new int[sCode[sCode.length - 1] + 1];
                for (i = 0; i < sCode.length; ++i) {
                    DescriptorEncoder.sDecode[DescriptorEncoder.sCode[i]] = i;
                }
                sDecodeMultiple = new int[Math.max(sCodeMultipleMin[sCodeMultipleMin.length - 1], sCodeMultipleMax[sCodeMultipleMax.length - 1]) + 1];
                for (i = 0; i < sCodeMultipleMin.length; ++i) {
                    DescriptorEncoder.sDecodeMultiple[DescriptorEncoder.sCodeMultipleMin[i]] = -i - 2;
                }
                for (i = 0; i < sCodeMultipleMax.length; ++i) {
                    DescriptorEncoder.sDecodeMultiple[DescriptorEncoder.sCodeMultipleMax[i]] = i + 2;
                }
            }
        }
    }

    public byte[] encode(int[] data) {
        this.encodeStart(32 * data.length);
        for (int i = 0; i < data.length; ++i) {
            this.encodeBits(data[i], 32);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public byte[] encodeIntArray2D(int[][] data) {
        int maxCount = data.length;
        int maxValue = 0;
        int valueCount = 0;
        for (int i = 0; i < data.length; ++i) {
            if (maxCount < data[i].length) {
                maxCount = data[i].length;
            }
            for (int j = 0; j < data[i].length; ++j) {
                if (maxValue >= data[i][j]) continue;
                maxValue = data[i][j];
            }
            valueCount += data[i].length;
        }
        int countBits = this.getNeededBits(maxCount);
        int valueBits = this.getNeededBits(maxValue);
        this.encodeStart(10 + (1 + data.length) * countBits + valueCount * valueBits);
        this.encodeBits(countBits, 5);
        this.encodeBits(valueBits, 5);
        this.encodeBits(data.length, countBits);
        for (int i = 0; i < data.length; ++i) {
            this.encodeBits(data[i].length, countBits);
            for (int j = 0; j < data[i].length; ++j) {
                this.encodeBits(data[i][j], valueBits);
            }
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public int[][] decodeIntArray2D(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        bytes = this.decodeDuplicateBytes(bytes);
        this.decodeStart(bytes);
        int countBits = this.decodeBits(5);
        int valueBits = this.decodeBits(5);
        int outerSize = this.decodeBits(countBits);
        int[][] data = new int[outerSize][];
        for (int i = 0; i < outerSize; ++i) {
            int innerSize = this.decodeBits(countBits);
            data[i] = new int[innerSize];
            for (int j = 0; j < innerSize; ++j) {
                data[i][j] = this.decodeBits(valueBits);
            }
        }
        return data;
    }

    public byte[] encodeLong(long[] data) {
        this.encodeStart(64 * data.length);
        for (int i = 0; i < data.length; ++i) {
            this.encodeBits(data[i], 64);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public int[] decode(String s) {
        return this.decode(s.getBytes());
    }

    public int[] decode(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        bytes = this.decodeDuplicateBytes(bytes);
        this.decodeStart(bytes);
        int[] data = new int[6 * bytes.length / 32];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.decodeBits(32);
        }
        return data;
    }

    public long[] decodeLong(String s) {
        return this.decodeLong(s.getBytes());
    }

    public long[] decodeLong(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        bytes = this.decodeDuplicateBytes(bytes);
        this.decodeStart(bytes);
        long[] data = new long[6 * bytes.length / 64];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.decodeBitsLong(64);
        }
        return data;
    }

    public byte[] encodeCounts(byte[] data) {
        this.encodeStart(6 * data.length);
        for (int i = 0; i < data.length; ++i) {
            this.encodeBits(data[i], 6);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public byte[] decodeCounts(String s) {
        return this.decodeCounts(s.getBytes());
    }

    public byte[] decodeCounts(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        bytes = this.decodeDuplicateBytes(bytes);
        this.decodeStart(bytes);
        byte[] data = new byte[6 * bytes.length / 6];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)this.decodeBits(6);
        }
        return data;
    }

    public byte[] encodeIntArray(int[] data) {
        int max = 0;
        int sum = 0;
        for (int v : data) {
            sum += this.getNeededBits(v);
            if (max >= v) continue;
            max = v;
        }
        int sizeBits = Math.min(31, this.getNeededBits(data.length));
        int dataBits = this.getNeededBits(this.getNeededBits(max));
        this.encodeStart(9 + sizeBits + sum + dataBits * data.length);
        this.encodeBits(0, 1);
        this.encodeBits(sizeBits, 5);
        this.encodeBits(data.length, sizeBits);
        this.encodeBits(dataBits, 3);
        for (int i = 0; i < data.length; ++i) {
            int bits = this.getNeededBits(data[i]);
            this.encodeBits(bits, dataBits);
            this.encodeBits(data[i], bits);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public int[] decodeIntArray(String s) {
        return s == null ? null : this.decodeIntArray(s.getBytes());
    }

    public int[] decodeIntArray(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        bytes = this.decodeDuplicateBytes(bytes);
        this.decodeStart(bytes);
        this.decodeBits(1);
        int sizeBits = this.decodeBits(5);
        int arraySize = this.decodeBits(sizeBits);
        int dataBits = this.decodeBits(3);
        int[] data = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            int bits = this.decodeBits(dataBits);
            data[i] = this.decodeBits(bits);
        }
        return data;
    }

    public byte[] encodePairs(int[][] data) {
        int maxID = 0;
        int maxCount = 0;
        for (int[] pair : data) {
            maxID = Math.max(maxID, pair[0]);
            maxCount = Math.max(maxCount, pair[1]);
        }
        int idBits = this.getNeededBits(maxID);
        int countBits = this.getNeededBits(maxCount);
        int requiredBits = this.getNeededBits(6) + 8 + data.length * (idBits + countBits);
        this.encodeStart(requiredBits);
        this.encodeBits(this.mBytes.length * 6 - requiredBits, this.getNeededBits(6));
        this.encodeBits(idBits, 4);
        this.encodeBits(countBits, 4);
        for (int[] pair : data) {
            this.encodeBits(pair[0], idBits);
            this.encodeBits(pair[1], countBits);
        }
        this.encodeBitsEnd();
        return this.mBytes;
    }

    public int[][] decodePairs(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        this.decodeStart(bytes);
        int unusedBits = this.decodeBits(this.getNeededBits(6));
        int idBits = this.decodeBits(4);
        int countBits = this.decodeBits(4);
        if (idBits + countBits == 0) {
            return new int[0][2];
        }
        int length = (6 * bytes.length - this.getNeededBits(6) - 8 - unusedBits) / (idBits + countBits);
        int[][] data = new int[length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = this.decodeBits(idBits);
            data[i][1] = this.decodeBits(countBits);
        }
        return data;
    }

    public int[][] decodePairs(String s) {
        return this.decodePairs(s.getBytes());
    }

    private int getNeededBits(int no) {
        int bits = 0;
        while (no > 0) {
            no >>= 1;
            ++bits;
        }
        return bits;
    }

    private void encodeStart(int bitCount) {
        this.mBytes = new byte[(bitCount + 6 - 1) / 6];
        this.mAvailableBits = 6;
        this.mByteIndex = 0;
    }

    private void encodeBits(int data, int bits) {
        int mask;
        int n = mask = bits == 0 ? 0 : 1 << bits - 1;
        while (mask != 0) {
            if (this.mAvailableBits == 0) {
                this.mBytes[this.mByteIndex] = sCode[this.mBytes[this.mByteIndex]];
                this.mAvailableBits = 6;
            }
            int n2 = ++this.mByteIndex;
            this.mBytes[n2] = (byte)(this.mBytes[n2] << 1);
            if ((data & mask) != 0) {
                int n3 = this.mByteIndex;
                this.mBytes[n3] = (byte)(this.mBytes[n3] | 1);
            }
            mask >>>= 1;
            --this.mAvailableBits;
        }
    }

    private void encodeBits(long data, int bits) {
        long mask;
        long l = mask = bits == 0 ? 0L : 1L << bits - 1;
        while (mask != 0L) {
            if (this.mAvailableBits == 0) {
                this.mBytes[this.mByteIndex] = sCode[this.mBytes[this.mByteIndex]];
                this.mAvailableBits = 6;
            }
            int n = ++this.mByteIndex;
            this.mBytes[n] = (byte)(this.mBytes[n] << 1);
            if ((data & mask) != 0L) {
                int n2 = this.mByteIndex;
                this.mBytes[n2] = (byte)(this.mBytes[n2] | 1);
            }
            mask >>>= 1;
            --this.mAvailableBits;
        }
    }

    private void encodeBitsEnd() {
        int n = this.mByteIndex;
        this.mBytes[n] = (byte)(this.mBytes[n] << this.mAvailableBits);
        this.mBytes[this.mByteIndex] = sCode[this.mBytes[this.mByteIndex]];
    }

    private void decodeStart(byte[] bytes) {
        this.mBytes = bytes;
        this.mByteIndex = 0;
        this.mTempData = sDecode[this.mBytes[0]];
        this.mTempDataLong = sDecode[this.mBytes[0]];
        this.mByteMask = 32;
    }

    private int decodeBits(int bits) {
        int data = 0;
        while (bits != 0) {
            if (this.mByteMask == 0) {
                ++this.mByteIndex;
                this.mTempData = sDecode[this.mBytes[this.mByteIndex]];
                this.mByteMask = 32;
            }
            data <<= 1;
            if ((this.mTempData & this.mByteMask) != 0) {
                data |= 1;
            }
            this.mByteMask >>>= 1;
            --bits;
        }
        return data;
    }

    private long decodeBitsLong(int bits) {
        long data = 0L;
        while (bits != 0) {
            if (this.mByteMask == 0) {
                ++this.mByteIndex;
                this.mTempDataLong = sDecode[this.mBytes[this.mByteIndex]];
                this.mByteMask = 32;
            }
            data <<= 1;
            if (((long)this.mTempDataLong & (long)this.mByteMask) != 0L) {
                data |= 1L;
            }
            this.mByteMask >>>= 1;
            --bits;
        }
        return data;
    }

    private byte[] decodeDuplicateBytes(byte[] bytes) {
        int length = bytes.length;
        for (int i = 0; i < bytes.length; ++i) {
            if (sDecodeMultiple[bytes[i]] == 0) continue;
            length += Math.abs(sDecodeMultiple[bytes[i]]) - 1;
        }
        if (length == bytes.length) {
            return bytes;
        }
        byte[] newBytes = new byte[length];
        int oldIndex = 0;
        int newIndex = 0;
        while (oldIndex < bytes.length) {
            if (sDecodeMultiple[bytes[oldIndex]] != 0) {
                int count = Math.abs(sDecodeMultiple[bytes[oldIndex]]);
                byte code = sDecodeMultiple[bytes[oldIndex]] < 0 ? sCode[0] : sCode[sCode.length - 1];
                for (int i = 0; i < count; ++i) {
                    newBytes[newIndex++] = code;
                }
                ++oldIndex;
                continue;
            }
            newBytes[newIndex++] = bytes[oldIndex++];
        }
        return newBytes;
    }

    private void encodeDuplicateBytes() {
        int length = this.encodeDuplicateBytes(sCode[0], sCodeMultipleMin, this.mBytes.length);
        length = this.encodeDuplicateBytes(sCode[sCode.length - 1], sCodeMultipleMax, length);
        byte[] oldBytes = this.mBytes;
        this.mBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.mBytes[i] = oldBytes[i];
        }
    }

    private int encodeDuplicateBytes(byte code, byte[] replacement, int length) {
        int oldIndex = 0;
        int newIndex = 0;
        while (oldIndex < length) {
            if (this.mBytes[oldIndex] == code) {
                int count = 1;
                for (int i = oldIndex + 1; i < length && this.mBytes[i] == code; ++i) {
                    ++count;
                }
                while (count > replacement.length + 1) {
                    this.mBytes[newIndex++] = replacement[replacement.length - 1];
                    oldIndex += replacement.length + 1;
                    count -= replacement.length + 1;
                }
                if (count > 1) {
                    this.mBytes[newIndex++] = replacement[count - 2];
                    oldIndex += count;
                    continue;
                }
            }
            this.mBytes[newIndex++] = this.mBytes[oldIndex++];
        }
        return newIndex;
    }
}

