/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.BondSet;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.BurtleHasher;
import com.actelion.research.util.SortedList;

public class DescriptorHandlerAllFragmentsFP
extends AbstractDescriptorHandlerLongFP<StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.6;
    public static boolean skipIDCodes;
    private static DescriptorHandlerAllFragmentsFP sDefaultInstance;
    private static final int MAX_BOND_COUNT = 7;
    private static final int HASH_BITS = 11;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 2048;
    private static final int DESCRIPTOR_LEN = 32;
    private StereoMolecule mMol;
    private StereoMolecule mFragment;
    private boolean[] mIsAtomMember;
    private boolean[] mIsBondMember;
    private int[] mMemberBond;
    private int[] mMemberAtom;
    private int[] mAtomMap;
    private long[] mDescriptor;
    private SortedList<BondSet> mBondSets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerAllFragmentsFP getDefaultInstance() {
        Class<DescriptorHandlerAllFragmentsFP> clazz = DescriptorHandlerAllFragmentsFP.class;
        synchronized (DescriptorHandlerAllFragmentsFP.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerAllFragmentsFP();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_ALLFRAG;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_ALLFRAG.version;
    }

    private StereoMolecule preprocessStructure(StereoMolecule mol) {
        if (mol.isFragment()) {
            mol.ensureHelperArrays(1);
            boolean[] isBlockedAtom = new boolean[mol.getAtoms()];
            for (int atom = 0; atom < mol.getAtoms(); ++atom) {
                isBlockedAtom[atom] = (mol.getAtomQueryFeatures(atom) & 0xFFFFFFFFF1C03801L) != 0L;
            }
            boolean hasBlockedBond = false;
            boolean[] includeBond = new boolean[mol.getBonds()];
            for (int bond = 0; bond < mol.getBonds(); ++bond) {
                includeBond[bond] = !isBlockedAtom[mol.getBondAtom(0, bond)] && !isBlockedAtom[mol.getBondAtom(1, bond)] && (mol.getBondQueryFeatures(bond) & 0xFFE7FF9F) == 0;
                hasBlockedBond |= !includeBond[bond];
            }
            if (hasBlockedBond) {
                StereoMolecule query = new StereoMolecule(mol.getAllBonds(), mol.getAllBonds());
                mol.copyMoleculeByAtoms(query, includeBond, true, null);
                mol = query;
            } else {
                mol = mol.getCompactCopy();
            }
            for (int atom = 0; atom < mol.getAtoms(); ++atom) {
                mol.setAtomQueryFeature(atom, 239060990L, false);
            }
            for (int bond = 0; bond < mol.getBonds(); ++bond) {
                mol.setBondQueryFeature(bond, 1572960, false);
            }
        } else {
            mol = mol.getCompactCopy();
        }
        for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
            mol.setAtomCharge(atom, 0);
            mol.setAtomRadical(atom, 0);
        }
        return mol;
    }

    @Override
    public long[] createDescriptor(StereoMolecule mol) {
        if (mol == null) {
            return null;
        }
        this.mMol = this.preprocessStructure(mol);
        this.mMol.ensureHelperArrays(7);
        this.mFragment = new StereoMolecule(this.mMol.getAtoms(), this.mMol.getBonds());
        this.mBondSets = new SortedList();
        this.mIsAtomMember = new boolean[this.mMol.getAtoms()];
        this.mIsBondMember = new boolean[this.mMol.getBonds()];
        this.mAtomMap = new int[this.mMol.getAtoms()];
        this.mDescriptor = new long[32];
        this.mMemberAtom = new int[this.mMol.getAtoms()];
        this.mMemberBond = new int[this.mMol.getBonds()];
        for (int rootBond = 0; rootBond < this.mMol.getBonds(); ++rootBond) {
            this.mMemberAtom[0] = this.mMol.getBondAtom(0, rootBond);
            this.mMemberAtom[1] = this.mMol.getBondAtom(1, rootBond);
            this.mMemberBond[0] = rootBond;
            this.mIsAtomMember[this.mMemberAtom[0]] = true;
            this.mIsAtomMember[this.mMemberAtom[1]] = true;
            this.mIsBondMember[rootBond] = true;
            this.setHashBitIfNew(1);
            this.processOneMoreBond(2, 1);
            this.mIsAtomMember[this.mMemberAtom[0]] = false;
            this.mIsAtomMember[this.mMemberAtom[1]] = false;
            this.mIsBondMember[rootBond] = false;
        }
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.getConnAtoms(atom) != 0) continue;
            int atomicNo = this.mMol.getAtomicNo(atom);
            int n = atomicNo < 64 ? 0 : 1;
            this.mDescriptor[n] = this.mDescriptor[n] | (long)(1 << atomicNo % 64);
        }
        return this.mDescriptor;
    }

    public void processOneMoreBond(int atomCount, int bondCount) {
        for (int i = 0; i < atomCount; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(this.mMemberAtom[i]); ++j) {
                int candidateBond = this.mMol.getConnBond(this.mMemberAtom[i], j);
                if (this.mIsBondMember[candidateBond]) continue;
                int candidateAtom = this.mMol.getConnAtom(this.mMemberAtom[i], j);
                this.mMemberBond[bondCount] = candidateBond;
                this.mIsBondMember[candidateBond] = true;
                boolean isAtomMember = this.mIsAtomMember[candidateAtom];
                if (!isAtomMember) {
                    this.mIsAtomMember[candidateAtom] = true;
                    this.mMemberAtom[atomCount] = candidateAtom;
                    ++atomCount;
                }
                this.setHashBitIfNew(++bondCount);
                if (bondCount < 7) {
                    this.processOneMoreBond(atomCount, bondCount);
                }
                --bondCount;
                this.mIsBondMember[candidateBond] = false;
                if (isAtomMember) continue;
                --atomCount;
                this.mIsAtomMember[candidateAtom] = false;
            }
        }
    }

    private void setHashBitIfNew(int bondCount) {
        BondSet bondSet = new BondSet(this.mMemberBond, bondCount, this.mMol.getBonds());
        if (this.mBondSets.addIfNew(bondSet)) {
            this.mMol.copyMoleculeByBonds(this.mFragment, this.mIsBondMember, true, this.mAtomMap);
            this.mFragment.setFragment(true);
            String idcode = new Canonizer(this.mFragment, 2048).getIDCode();
            int hash = BurtleHasher.hashlittle(idcode, 13L);
            int high = 32 - (hash &= BurtleHasher.hashmask(11)) / 64 - 1;
            int low = hash % 64;
            int n = high;
            this.mDescriptor[n] = this.mDescriptor[n] | 1L << low;
        }
    }

    @Override
    public float getSimilarity(long[] o1, long[] o2) {
        return o1 == null || o2 == null || o1.length == 0 || o2.length == 0 ? 0.0f : this.normalizeValue(SSSearcherWithIndex.getSimilarityTanimoto(o1, o2));
    }

    private float normalizeValue(double value) {
        return value <= 0.0 ? 0.0f : (value >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(value, 0.6), 1.6666666666666667)));
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return new DescriptorHandlerAllFragmentsFP();
    }
}

