/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.reaction.FunctionalGroupClassifier;
import java.util.Arrays;
import java.util.TreeSet;

public class DescriptorHandlerFunctionalGroups
implements DescriptorHandler<int[][], StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.7;
    private static final int[][] FAILED_OBJECT = new int[][]{{1, 0}};
    private static DescriptorHandlerFunctionalGroups sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerFunctionalGroups getDefaultInstance() {
        Class<DescriptorHandlerFunctionalGroups> clazz = DescriptorHandlerFunctionalGroups.class;
        synchronized (DescriptorHandlerFunctionalGroups.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerFunctionalGroups();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public boolean calculationFailed(int[][] d) {
        return d == null || d.length == 1 && d[0][1] == 0;
    }

    @Override
    public int[][] createDescriptor(StereoMolecule mol) {
        if (mol == null) {
            return null;
        }
        FunctionalGroupClassifier fgc = new FunctionalGroupClassifier(mol);
        return fgc.getOrganicFunctionalGroupCounts();
    }

    @Override
    public int[][] decode(String s) {
        return s == null ? (int[][])null : (s.equals("Calculation Failed") ? FAILED_OBJECT : new DescriptorEncoder().decodePairs(s));
    }

    @Override
    public int[][] decode(byte[] bytes) {
        return bytes == null ? (int[][])null : (Arrays.equals(bytes, FAILED_BYTES) ? FAILED_OBJECT : new DescriptorEncoder().decodePairs(bytes));
    }

    @Override
    public String encode(int[][] d) {
        return this.calculationFailed(d) ? "Calculation Failed" : new String(new DescriptorEncoder().encodePairs(d));
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_OrganicFunctionalGroups;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_OrganicFunctionalGroups.version;
    }

    @Override
    public float getSimilarity(int[][] dl1, int[][] dl2) {
        if (dl1 == null || dl2 == null) {
            return Float.NaN;
        }
        if (dl1.length == 0 && dl2.length == 0) {
            return 1.0f;
        }
        if (dl1.length == 0 || dl2.length == 0) {
            return 0.0f;
        }
        TreeSet<Match> matchList = new TreeSet<Match>();
        int i1 = 0;
        int i2 = -1;
        for (int[] d1 : dl1) {
            i2 = 0;
            for (int[] d2 : dl2) {
                int matchLevel = FunctionalGroupClassifier.getFunctionalGroupEquivalenceLevel(d1[0], (int)d2[0]);
                if (matchLevel != -1) {
                    for (int i = 0; i < d1[1]; ++i) {
                        for (int j = 0; j < d2[1]; ++j) {
                            matchList.add(new Match(i1 + i, i2 + j, matchLevel));
                        }
                    }
                }
                i2 += d2[1];
            }
            i1 += d1[1];
        }
        float total = i1 + i2;
        float matching = 0.0f;
        boolean[] used1 = new boolean[i1];
        boolean[] used2 = new boolean[i2];
        Object object = matchList.iterator();
        while (object.hasNext()) {
            Match match = (Match)object.next();
            if (used1[match.fg1] || used2[match.fg2]) continue;
            float m = 1.0f - 0.1f * (float)match.level;
            matching += m;
            total -= m;
            used1[match.fg1] = true;
            used2[match.fg2] = true;
        }
        return this.normalizeValue(matching / total);
    }

    private float normalizeValue(double value) {
        return value <= 0.0 ? 0.0f : (value >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(value, 0.7), 1.4285714285714286)));
    }

    @Override
    public DescriptorHandler<int[][], StereoMolecule> getThreadSafeCopy() {
        return new DescriptorHandlerFunctionalGroups();
    }

    private class Match
    implements Comparable<Match> {
        int fg1;
        int fg2;
        int level;

        Match(int fg1, int fg2, int level) {
            this.fg1 = fg1;
            this.fg2 = fg2;
            this.level = level;
        }

        @Override
        public int compareTo(Match o) {
            int ov;
            if (this.level != o.level) {
                return this.level < o.level ? -1 : 1;
            }
            int v = this.fg1 < this.fg2 ? (this.fg1 << 10) + this.fg2 : (this.fg2 << 10) + this.fg1;
            int n = ov = o.fg1 < o.fg2 ? (o.fg1 << 10) + o.fg2 : (o.fg2 << 10) + o.fg1;
            return v < ov ? -1 : (v > ov ? 1 : 0);
        }
    }
}

