/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class DescriptorHandlerLongCFP
extends AbstractDescriptorHandlerLongFP<StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.6;
    private static DescriptorHandlerLongCFP sDefaultInstance;
    private static final int SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerLongCFP getDefaultInstance() {
        Class<DescriptorHandlerLongCFP> clazz = DescriptorHandlerLongCFP.class;
        synchronized (DescriptorHandlerLongCFP.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerLongCFP();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_HashedCFp;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_HashedCFp.version;
    }

    @Override
    public long[] createDescriptor(StereoMolecule mol) {
        if (mol == null) {
            return null;
        }
        mol.ensureHelperArrays(7);
        StereoMolecule fragment = new StereoMolecule(mol.getAtoms(), mol.getBonds());
        int len = 16;
        long[] data = new long[16];
        int[] atomList = new int[mol.getAtoms()];
        boolean[] atomMask = new boolean[mol.getAtoms()];
        for (int rootAtom = 0; rootAtom < mol.getAtoms(); ++rootAtom) {
            if (rootAtom != 0) {
                Arrays.fill(atomMask, false);
            }
            int min = 0;
            int max = 0;
            for (int sphere = 0; sphere < 5 && max < mol.getAtoms(); ++sphere) {
                if (max == 0) {
                    atomList[0] = rootAtom;
                    atomMask[rootAtom] = true;
                    max = 1;
                } else {
                    int newMax = max;
                    for (int i = min; i < max; ++i) {
                        int atom = atomList[i];
                        for (int j = 0; j < mol.getConnAtoms(atom); ++j) {
                            int connAtom = mol.getConnAtom(atom, j);
                            if (atomMask[connAtom]) continue;
                            atomMask[connAtom] = true;
                            atomList[newMax++] = connAtom;
                        }
                    }
                    min = max;
                    max = newMax;
                }
                mol.copyMoleculeByAtoms(fragment, atomMask, true, null);
                String idcode = new Canonizer(fragment).getIDCode();
                int h = BurtleHasher.hashlittle(idcode, 13L);
                int index = 16 - (h &= BurtleHasher.hashmask(10)) / 64 - 1;
                int bitNo = h % 32;
                if (h % 64 >= 32) {
                    bitNo += 32;
                }
                int n = index;
                data[n] = data[n] | 1L << bitNo;
            }
        }
        return data;
    }

    @Override
    public float getSimilarity(long[] o1, long[] o2) {
        return o1 == null || o2 == null || o1.length == 0 || o2.length == 0 ? 0.0f : this.normalizeValue(SSSearcherWithIndex.getSimilarityTanimoto(o1, o2));
    }

    private float normalizeValue(double value) {
        return value <= 0.0 ? 0.0f : (value >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(value, 0.6), 1.6666666666666667)));
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }
}

