/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.FingerPrintGenerator;
import java.util.BitSet;

public class DescriptorHandlerLongPFP512
extends AbstractDescriptorHandlerLongFP<StereoMolecule>
implements DescriptorConstants {
    private static final double CORRECTION_FACTOR = 0.85;
    private static DescriptorHandlerLongPFP512 sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerLongPFP512 getDefaultInstance() {
        Class<DescriptorHandlerLongPFP512> clazz = DescriptorHandlerLongPFP512.class;
        synchronized (DescriptorHandlerLongPFP512.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerLongPFP512();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DESCRIPTOR_PFP512;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_PFP512.version;
    }

    @Override
    public long[] createDescriptor(StereoMolecule mol) {
        if (mol == null) {
            return null;
        }
        BitSet bitset = new FingerPrintGenerator().getFingerprint(mol);
        if (bitset == null) {
            return FAILED_OBJECT;
        }
        long[] fp = new long[8];
        long mask1 = 1L;
        long mask2 = 0x100000000L;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (bitset.get(16 * i + 2 * j + 1)) {
                    int n = j;
                    fp[n] = fp[n] + mask1;
                }
                if (!bitset.get(16 * i + 2 * j)) continue;
                int n = j;
                fp[n] = fp[n] + mask2;
            }
            mask1 <<= 1;
            mask2 <<= 1;
        }
        return fp;
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }

    @Override
    public float getSimilarity(long[] o1, long[] o2) {
        return this.normalizeValue(super.getSimilarity(o1, o2));
    }

    private float normalizeValue(double value) {
        return value <= 0.0 ? 0.0f : (value >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(value, 0.85), 1.1764705882352942)));
    }
}

