/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class DescriptorHandlerReactionFP
extends AbstractDescriptorHandlerLongFP<Reaction> {
    public static final String cVersion = "1.0.0";
    public static final int REACTION_CENTER_LONG_COUNT = 8;
    public static final float REACTION_CENTER_WEIGHT = 0.8f;
    public static final float PERIPHERY_WEIGHT = 0.19999999f;
    private static final int SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;
    private static DescriptorHandlerReactionFP sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DescriptorHandlerReactionFP getDefaultInstance() {
        if (sDefaultInstance != null) return sDefaultInstance;
        Class<DescriptorHandlerReactionFP> clazz = DescriptorHandlerReactionFP.class;
        synchronized (DescriptorHandlerReactionFP.class) {
            sDefaultInstance = new DescriptorHandlerReactionFP();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_ReactionFP;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_ReactionFP.version;
    }

    @Override
    public long[] createDescriptor(Reaction rxn) {
        if (rxn == null) {
            return null;
        }
        boolean[] isReactionCenterMapNo = rxn.getReactionCenterMapNos();
        if (isReactionCenterMapNo == null) {
            return FAILED_OBJECT;
        }
        int len = 16;
        long[] data = new long[16];
        for (int m = 0; m < rxn.getMolecules(); ++m) {
            StereoMolecule mol = rxn.getMolecule(m);
            mol.ensureHelperArrays(7);
            boolean[] isReactionCenterAtom = new boolean[mol.getAllAtoms()];
            int reactionCenterAtomCount = rxn.getReactionCenterAtoms(m, isReactionCenterMapNo, isReactionCenterAtom, null);
            StereoMolecule fragment = new StereoMolecule(mol.getAllAtoms(), mol.getAllBonds());
            int[] atomList = new int[mol.getAllAtoms()];
            boolean[] atomMask = new boolean[mol.getAllAtoms()];
            block1: for (int rootAtom = 0; rootAtom < mol.getAtoms(); ++rootAtom) {
                if (rootAtom != 0) {
                    Arrays.fill(atomMask, false);
                }
                int min = 0;
                int max = 0;
                for (int sphere = 0; sphere < 5 && max < mol.getAtoms(); ++sphere) {
                    if (max == 0) {
                        atomList[0] = rootAtom;
                        atomMask[rootAtom] = true;
                        max = 1;
                    } else {
                        int newMax = max;
                        for (int i = min; i < max; ++i) {
                            int atom = atomList[i];
                            for (int j = 0; j < mol.getConnAtoms(atom); ++j) {
                                int connAtom = mol.getConnAtom(atom, j);
                                if (atomMask[connAtom] || !isReactionCenterAtom[rootAtom] && isReactionCenterAtom[connAtom]) continue;
                                atomMask[connAtom] = true;
                                atomList[newMax++] = connAtom;
                            }
                        }
                        if (max == newMax) continue block1;
                        min = max;
                        max = newMax;
                    }
                    mol.copyMoleculeByAtoms(fragment, atomMask, true, null);
                    String idcode = new Canonizer(fragment).getIDCode();
                    if (m >= rxn.getReactants()) {
                        idcode = idcode.concat("P");
                    }
                    int weight = isReactionCenterAtom[rootAtom] ? 5 - sphere : 1;
                    for (int i = 0; i < weight; ++i) {
                        int index;
                        int h = BurtleHasher.hashlittle(idcode.concat(Integer.toString(i)), 13L);
                        h &= BurtleHasher.hashmask(9);
                        if (isReactionCenterAtom[rootAtom]) {
                            h += 512;
                        }
                        int n = index = 16 - h / 64 - 1;
                        data[n] = data[n] | 1L << h % 64;
                    }
                }
            }
        }
        return data;
    }

    @Override
    public float getSimilarity(long[] o1, long[] o2) {
        if (o1 == null || o2 == null || o1.length == 0 || o2.length == 0) {
            return 0.0f;
        }
        float reactionCenterSimilarity = DescriptorHandlerReactionFP.getSimilarityTanimoto(o1, o2, 0, 8);
        float nonReactionCenterSimilarity = DescriptorHandlerReactionFP.getSimilarityTanimoto(o1, o2, 8, o1.length);
        return 0.8f * reactionCenterSimilarity + 0.19999999f * nonReactionCenterSimilarity;
    }

    public float getReactionCenterSimilarity(long[] o1, long[] o2) {
        if (o1 == null || o2 == null || o1.length == 0 || o2.length == 0) {
            return 0.0f;
        }
        return DescriptorHandlerReactionFP.getSimilarityTanimoto(o1, o2, 0, 8);
    }

    public float getPeripherySimilarity(long[] o1, long[] o2) {
        if (o1 == null || o2 == null || o1.length == 0 || o2.length == 0) {
            return 0.0f;
        }
        return DescriptorHandlerReactionFP.getSimilarityTanimoto(o1, o2, 8, o1.length);
    }

    public static float getSimilarityTanimoto(long[] index1, long[] index2, int i1, int i2) {
        int sharedKeys = 0;
        int allKeys = 0;
        for (int i = i1; i < i2; ++i) {
            sharedKeys += Long.bitCount(index1[i] & index2[i]);
            allKeys += Long.bitCount(index1[i] | index2[i]);
        }
        return allKeys == 0 ? 1.0f : (float)sharedKeys / (float)allKeys;
    }

    @Override
    public DescriptorHandler<long[], Reaction> getThreadSafeCopy() {
        return this;
    }
}

