/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class DescriptorHandlerSkeletonSpheres
implements DescriptorHandler<byte[], StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.7;
    private static final byte[] FAILED_OBJECT = new byte[0];
    private static final int MAX_SPHERE_COUNT = 5;
    private static final int EXACT_SPHERE_COUNT = 4;
    private static final int SKELETON_SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;
    private static DescriptorHandlerSkeletonSpheres sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerSkeletonSpheres getDefaultInstance() {
        Class<DescriptorHandlerSkeletonSpheres> clazz = DescriptorHandlerSkeletonSpheres.class;
        synchronized (DescriptorHandlerSkeletonSpheres.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerSkeletonSpheres();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public boolean calculationFailed(byte[] o) {
        return o == null || o.length == 0;
    }

    @Override
    public byte[] createDescriptor(StereoMolecule mol) {
        if (mol == null) {
            return null;
        }
        mol.ensureHelperArrays(7);
        StereoMolecule fragment = new StereoMolecule(mol.getAtoms(), mol.getBonds());
        byte[] descriptor = new byte[1024];
        int[] atomList = new int[mol.getAtoms()];
        boolean[] atomMask = new boolean[mol.getAtoms()];
        for (int rootAtom = 0; rootAtom < mol.getAtoms(); ++rootAtom) {
            if (rootAtom != 0) {
                Arrays.fill(atomMask, false);
            }
            int min = 0;
            int max = 0;
            for (int sphere = 0; sphere < 5 && max < mol.getAtoms(); ++sphere) {
                int h;
                if (max == 0) {
                    atomList[0] = rootAtom;
                    atomMask[rootAtom] = true;
                    max = 1;
                } else {
                    int newMax = max;
                    for (int i = min; i < max; ++i) {
                        int atom = atomList[i];
                        for (int j = 0; j < mol.getConnAtoms(atom); ++j) {
                            int connAtom = mol.getConnAtom(atom, j);
                            if (atomMask[connAtom]) continue;
                            atomMask[connAtom] = true;
                            atomList[newMax++] = connAtom;
                        }
                    }
                    min = max;
                    max = newMax;
                }
                mol.copyMoleculeByAtoms(fragment, atomMask, true, null);
                if (sphere < 4) {
                    String idcode = new Canonizer(fragment).getIDCode();
                    h = BurtleHasher.hashlittle(idcode, 13L);
                    if (descriptor[h &= BurtleHasher.hashmask(10)] < 63) {
                        int n = h;
                        descriptor[n] = (byte)(descriptor[n] + 1);
                    }
                }
                if (sphere >= 5) continue;
                for (int atom = 0; atom < fragment.getAllAtoms(); ++atom) {
                    fragment.setAtomicNo(atom, 6);
                }
                String idcode = new Canonizer(fragment).getIDCode();
                h = BurtleHasher.hashlittle(idcode, 13L);
                if (descriptor[h &= BurtleHasher.hashmask(10)] >= 63) continue;
                int n = h;
                descriptor[n] = (byte)(descriptor[n] + 1);
            }
        }
        return descriptor;
    }

    @Override
    public byte[] decode(String s) {
        return s == null ? null : (s.equals("Calculation Failed") ? FAILED_OBJECT : new DescriptorEncoder().decodeCounts(s));
    }

    @Override
    public byte[] decode(byte[] bytes) {
        return bytes == null ? null : (Arrays.equals(bytes, FAILED_BYTES) ? FAILED_OBJECT : new DescriptorEncoder().decodeCounts(bytes));
    }

    @Override
    public String encode(byte[] o) {
        return this.calculationFailed(o) ? "Calculation Failed" : new String(new DescriptorEncoder().encodeCounts(o));
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_SkeletonSpheres;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_SkeletonSpheres.version;
    }

    @Override
    public float getSimilarity(byte[] d1, byte[] d2) {
        if (d1 == null || d2 == null) {
            return Float.NaN;
        }
        int total = 0;
        int matching = 0;
        for (int i = 0; i < d1.length; ++i) {
            byte i1 = d1[i];
            byte i2 = d2[i];
            total += Math.max(i1, i2);
            matching += Math.min(i1, i2);
        }
        return this.normalizeValue((double)matching / (double)total);
    }

    public float normalizeValue(double value) {
        return value <= 0.0 ? 0.0f : (value >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(value, 0.7), 1.4285714285714286)));
    }

    @Override
    public DescriptorHandler<byte[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }
}

