/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.ISimilarityCalculator;
import com.actelion.research.chem.descriptor.SimilarityCalculatorInfo;

public class DescriptorHelper
implements DescriptorConstants {
    public static final String TAG_SIMILARITY = "Similarity";

    public static int getDescriptorType(String shortName) {
        DescriptorInfo descriptorInfo = DescriptorHelper.getDescriptorInfo(DescriptorHelper.unifyShortName(shortName));
        return descriptorInfo == null ? -1 : descriptorInfo.type;
    }

    public static DescriptorInfo getDescriptorInfo(String shortName) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName.equals(DescriptorHelper.unifyShortName(shortName))) continue;
            return DESCRIPTOR_EXTENDED_LIST[i];
        }
        return null;
    }

    public static boolean isBinaryFingerprint(String shortName) {
        DescriptorInfo descriptorInfo = DescriptorHelper.getDescriptorInfo(DescriptorHelper.unifyShortName(shortName));
        return descriptorInfo == null ? false : descriptorInfo.isBinary;
    }

    public static boolean isDescriptorShortName(String shortName) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName.equals(DescriptorHelper.unifyShortName(shortName))) continue;
            return true;
        }
        return false;
    }

    public static String shortNameToName(String shortName) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName.equals(shortName)) continue;
            return DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].name;
        }
        return null;
    }

    public static String nameToShortName(String name) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].name.equals(name)) continue;
            return DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName;
        }
        return null;
    }

    private static String unifyShortName(String shortname) {
        return "PP3DMM2".equals(shortname) ? "Flexophore" : shortname;
    }

    public static String getTagDescriptorSimilarity(ISimilarityCalculator<?> dh) {
        return TAG_SIMILARITY + dh.getInfo().shortName;
    }

    public static String getTagDescriptorSimilarity(String shortName) {
        return TAG_SIMILARITY + shortName;
    }

    public static String getTagDescriptorSimilarity(SimilarityCalculatorInfo info) {
        return TAG_SIMILARITY + info.shortName;
    }

    public static String getTagDescriptorSimilarity(DescriptorInfo dh) {
        return TAG_SIMILARITY + dh.shortName;
    }

    public static <T> T create(DescriptorHandler<T, StereoMolecule> dh, String idcode) {
        IDCodeParser parser = new IDCodeParser();
        StereoMolecule mol = parser.getCompactMolecule(idcode);
        mol.ensureHelperArrays(7);
        return dh.createDescriptor(mol);
    }
}

