/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public class FingerPrintGenerator {
    private static final int MAX_BITS = 512;
    private static final int MAX_DEPTH = 6;
    private static final boolean DEBUG = false;
    private static int debugCounter = 0;
    private Hashtable paths;

    public BitSet getFingerprint(StereoMolecule mol) {
        return this.getFingerprint(mol, 512);
    }

    public BitSet getFingerprint(StereoMolecule mol, int size) {
        String path = null;
        mol.ensureHelperArrays(7);
        this.findAllPaths(mol);
        BitSet bs = new BitSet(size);
        Enumeration e = this.paths.elements();
        while (e.hasMoreElements()) {
            path = (String)e.nextElement();
            int index = new Random(path.hashCode()).nextInt(size);
            bs.set(index);
        }
        return bs;
    }

    private static boolean matches(BitSet reference, BitSet query) {
        BitSet cp = (BitSet)reference.clone();
        cp.and(query);
        return cp.equals(query);
    }

    public static byte[] getBitSetBits(BitSet bs) {
        int size = bs.size();
        int t = size % 8 == 0 ? size / 8 : size / 8 + 1;
        byte[] r = new byte[t];
        for (int i = 0; i < size; ++i) {
            int bite;
            if (!bs.get(i)) continue;
            byte bit = (byte)(1 << 7 - i % 8);
            int n = bite = i / 8;
            r[n] = (byte)(r[n] | bit);
        }
        return r;
    }

    private void findAllPaths(StereoMolecule mol) {
        this.paths = new Hashtable();
        debugCounter = 0;
        int atoms = mol.getAtoms();
        boolean[] flags = new boolean[atoms];
        for (int atom = 0; atom < atoms; ++atom) {
            String s = mol.getAtomLabel(atom);
            for (int i = 0; i < atoms; ++i) {
                flags[i] = false;
            }
            this.addPath(s);
            this.traverseDFS(mol, -1, atom, s, 0, flags);
        }
    }

    private void traverseDFS(StereoMolecule mol, int lastAtom, int rootAtom, String path, int depth, boolean[] flags) {
        int connAtoms = mol.getConnAtoms(rootAtom) + mol.getMetalBondedConnAtoms(rootAtom);
        int nextAtom = 0;
        int bond = 0;
        StringBuilder newPath = new StringBuilder();
        ++depth;
        for (int i = 0; i < connAtoms; ++i) {
            flags[rootAtom] = true;
            nextAtom = mol.getConnAtom(rootAtom, i);
            if (nextAtom == lastAtom || flags[nextAtom]) continue;
            bond = mol.getConnBond(rootAtom, i);
            newPath.setLength(0);
            newPath.append(path);
            if (mol.isDelocalizedBond(bond) || mol.isAromaticBond(bond)) {
                newPath.append(":");
            } else if (mol.getBondOrder(bond) == 1) {
                newPath.append("-");
            } else if (mol.getBondOrder(bond) == 2) {
                newPath.append("=");
            } else if (mol.getBondOrder(bond) == 3) {
                newPath.append("#");
            } else if (mol.getBondOrder(bond) == 0) {
                newPath.append(".");
            } else {
                System.out.println("FingerPrintGenerator.depthFirstSearch() Error: Invalid Bond order! " + mol.getBondOrder(bond));
            }
            newPath.append(mol.getAtomLabel(nextAtom));
            flags[nextAtom] = true;
            this.addPath(newPath.toString());
            if (depth == 6) {
                flags[nextAtom] = false;
            }
            if (depth >= 6) continue;
            this.traverseDFS(mol, rootAtom, nextAtom, newPath.toString(), depth, flags);
            flags[nextAtom] = false;
        }
    }

    private boolean addPath(String newPath) {
        String storePath = newPath;
        String reversePath = new StringBuilder(storePath).reverse().toString();
        boolean ok = false;
        if (reversePath.compareTo(newPath) < 0) {
            storePath = reversePath;
        }
        if (!this.paths.containsKey(storePath)) {
            this.paths.put(storePath, storePath);
            ok = true;
        }
        return ok;
    }

    public static void main(String[] args) {
        String test = "sFp@DiTt@@@@ S~x>xixix>";
        IDCodeParser p = new IDCodeParser(false);
        StereoMolecule m = new StereoMolecule();
        BitSet referencebs = null;
        BitSet querybs = null;
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        FingerPrintGenerator fp = null;
        try {
            String query;
            if (args.length > 0) {
                System.out.println("Query set");
                test = args[0];
                p.parse(m, test);
                m.ensureHelperArrays(7);
                fp = new FingerPrintGenerator();
                querybs = fp.getFingerprint(m);
                while (true) {
                    System.out.print("Molecule:");
                    String query2 = r.readLine();
                    if (query2 == null || query2.trim().length() <= 0) continue;
                    p.parse(m, query2);
                    m.ensureHelperArrays(7);
                    fp = new FingerPrintGenerator();
                    referencebs = fp.getFingerprint(m);
                    if (FingerPrintGenerator.matches(referencebs, querybs)) {
                        System.out.println(query2.trim() + "\tOK");
                        continue;
                    }
                    System.out.println(query2.trim() + "\tNOT OK");
                }
            }
            test = r.readLine();
            p.parse(m, test);
            m.ensureHelperArrays(7);
            fp = new FingerPrintGenerator();
            querybs = fp.getFingerprint(m);
            int count = 0;
            int notok = 0;
            while ((query = r.readLine()) != null && query.trim().length() > 0) {
                System.out.println("*********************");
                query = query.trim();
                p.parse(m, query);
                m.ensureHelperArrays(7);
                fp = new FingerPrintGenerator();
                referencebs = fp.getFingerprint(m);
                if (!FingerPrintGenerator.matches(referencebs, querybs)) {
                    ++notok;
                }
                ++count;
            }
            System.out.println("Total/Not OK " + count + " " + notok);
        }
        catch (Exception e) {
            System.err.println("Server Exception: " + e);
            e.printStackTrace();
        }
    }
}

