/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Molecule3D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractParser {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected List<String> errors = new ArrayList<String>();
    protected boolean optimize3D = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Molecule3D> loadGroup(String fileName) throws Exception {
        Reader r = null;
        try {
            InflaterInputStream is;
            if (fileName.toUpperCase().endsWith(".GZ")) {
                is = new GZIPInputStream(new FileInputStream(fileName));
                r = new InputStreamReader(is);
            } else if (fileName.toUpperCase().endsWith(".ZIP")) {
                is = new ZipInputStream(new FileInputStream(fileName));
                r = new InputStreamReader(is);
            } else {
                r = new BufferedReader(new FileReader(fileName));
            }
            List<Molecule3D> mols = this.loadGroup(fileName, r, -1, -1);
            int count = 0;
            for (Molecule3D mol : mols) {
                ++count;
                if (mol == null || mol.getName() != null && mol.getName().length() != 0) continue;
                mol.setName(new File(fileName).getName() + (mols.size() > 1 ? "#" + count : ""));
            }
            List<Molecule3D> list = mols;
            return list;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public List<Molecule3D> loadGroup(String fileName, Reader in) throws Exception {
        return this.loadGroup(fileName, in, -1, -1);
    }

    public abstract List<Molecule3D> loadGroup(String var1, Reader var2, int var3, int var4) throws Exception;

    public final Molecule3D load(File file) throws Exception {
        return this.load(file.getPath());
    }

    public final Molecule3D load(String fileName) throws Exception {
        List<Molecule3D> list = this.loadGroup(fileName);
        return list.size() > 0 ? list.get(0) : null;
    }

    public final Molecule3D load(String fileName, Reader in) throws Exception {
        List<Molecule3D> list = this.loadGroup(fileName, in, -1, -1);
        return list.size() > 0 ? list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(List<Molecule3D> mol, String fileName) throws Exception {
        Writer w = null;
        try {
            if (fileName.toUpperCase().endsWith(".GZ")) {
                GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(fileName));
                w = new OutputStreamWriter(os);
            } else if (fileName.toUpperCase().endsWith(".ZIP")) {
                ZipOutputStream os = new ZipOutputStream(new FileOutputStream(fileName));
                w = new OutputStreamWriter(os);
            } else {
                w = new BufferedWriter(new FileWriter(fileName));
            }
            this.save(mol, w);
            w.close();
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Molecule3D mol, String fileName) throws Exception {
        Writer w = null;
        try {
            if (fileName.toUpperCase().endsWith(".GZ")) {
                GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(fileName));
                w = new OutputStreamWriter(os);
            } else if (fileName.toUpperCase().endsWith(".ZIP")) {
                ZipOutputStream os = new ZipOutputStream(new FileOutputStream(fileName));
                w = new OutputStreamWriter(os);
            } else {
                w = new FileWriter(fileName);
            }
            this.save(mol, w);
            w.close();
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void save(Molecule3D mol, Writer writer) throws Exception {
        throw new IllegalAccessError("Not implemented");
    }

    public void save(List<Molecule3D> mols, Writer writer) throws Exception {
        if (mols == null || mols.size() == 0) {
            return;
        }
        if (mols.size() != 1) {
            throw new IllegalAccessError("Cannot save more than one file in  this format");
        }
        this.save(mols.get(0), writer);
    }

    public static final void convertDataToPrimitiveTypes(List<Molecule3D> res) {
        if (res.size() == 0) {
            return;
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (Molecule3D m : res) {
            fieldNames.addAll(m.getAuxiliaryInfos().keySet());
        }
        block5: for (String fieldName : fieldNames) {
            int type = 0;
            String val = "";
            for (Molecule3D m : res) {
                Object o = m.getAuxiliaryInfos().get(fieldName);
                if (o == null) continue;
                if (!(o instanceof String)) continue block5;
                val = (String)o;
                if (type == 0) {
                    try {
                        Integer.parseInt(val);
                    }
                    catch (Exception e) {
                        ++type;
                    }
                }
                if (type == 1) {
                    try {
                        Double.parseDouble(val);
                    }
                    catch (Exception e) {
                        ++type;
                    }
                }
                if (type != 2) continue;
                break;
            }
            if (type == 0) {
                for (Molecule3D m : res) {
                    val = (String)m.getAuxiliaryInfos().get(fieldName);
                    if (val == null) continue;
                    m.getAuxiliaryInfos().put(fieldName, Integer.parseInt((String)m.getAuxiliaryInfos().get(fieldName)));
                }
                continue;
            }
            if (type != true) continue;
            for (Molecule3D m : res) {
                val = (String)m.getAuxiliaryInfos().get(fieldName);
                if (val == null) continue;
                m.getAuxiliaryInfos().put(fieldName, Double.parseDouble(val));
            }
        }
    }

    protected static void writeR(Writer writer, String data, int len) throws IOException {
        if (data == null) {
            data = "";
        }
        int l = Math.max(0, len - data.length());
        for (int i = 0; i < l; ++i) {
            writer.write(32);
        }
        writer.write(data);
    }

    protected static void writeL(Writer writer, String data, int len) throws IOException {
        if (data == null) {
            data = "";
        }
        writer.write(data);
        int l = Math.max(0, len - data.length());
        for (int i = 0; i < l; ++i) {
            writer.write(32);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected static boolean is3D(Molecule3D m) {
        for (int a = 0; a < m.getAllAtoms(); ++a) {
            if (!(Math.abs(m.getAtomZ(a)) > 0.1)) continue;
            return true;
        }
        return false;
    }

    public void setOptimize3D(boolean optimize3d) {
        this.optimize3D = optimize3d;
    }

    public boolean isOptimize3D() {
        return this.optimize3D;
    }
}

